/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Log;
import android.util.Pair;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class zzb
extends Service {
    @VisibleForTesting
    final ExecutorService zzbtI = Executors.newSingleThreadExecutor();
    private Binder zzckU;
    private final Object zzrJ = new Object();
    private int zzckV;
    private int zzckW = 0;

    public final synchronized IBinder onBind(Intent intent) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"Service received bind request");
        }
        if (this.zzckU == null) {
            this.zzckU = new zza(this);
        }
        return this.zzckU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int onStartCommand(Intent intent, int n, int n2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzckV = n2;
            ++this.zzckW;
        }
        object = this.zzD(intent);
        if (object == null) {
            this.zzC(intent);
            return 2;
        }
        if (this.zzE((Intent)object)) {
            this.zzC(intent);
            return 2;
        }
        this.zzbtI.execute(new Runnable((Intent)object, intent){
            final /* synthetic */ Intent val$intent;
            final /* synthetic */ Intent zzckX;
            {
                this.val$intent = intent;
                this.zzckX = intent2;
            }

            @Override
            public void run() {
                zzb.this.handleIntent(this.val$intent);
                zzb.this.zzC(this.zzckX);
            }
        });
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzC(Intent intent) {
        if (intent != null) {
            WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
        Object object = this.zzrJ;
        synchronized (object) {
            --this.zzckW;
            if (this.zzckW == 0) {
                this.zzqE(this.zzckV);
            }
        }
    }

    boolean zzqE(int n) {
        return this.stopSelfResult(n);
    }

    protected Intent zzD(Intent intent) {
        return intent;
    }

    public boolean zzE(Intent intent) {
        return false;
    }

    public abstract void handleIntent(Intent var1);

    public static class zza
    extends Binder {
        private final zzb zzckZ;

        zza(zzb zzb2) {
            this.zzckZ = zzb2;
        }

        public void zza(final Intent intent, final @Nullable BroadcastReceiver.PendingResult pendingResult) {
            if (Binder.getCallingUid() != Process.myUid()) {
                throw new SecurityException("Binding only allowed within app");
            }
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"service received new intent via bind strategy");
            }
            if (this.zzckZ.zzE(intent)) {
                zza.zza(pendingResult);
            } else {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"intent being queued for bg execution");
                }
                this.zzckZ.zzbtI.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                            Log.d((String)"EnhancedIntentService", (String)"bg processing of the intent starting now");
                        }
                        zza.this.zzckZ.handleIntent(intent);
                        zza.zza(pendingResult);
                    }
                });
            }
        }

        private static void zza(@Nullable BroadcastReceiver.PendingResult pendingResult) {
            if (pendingResult != null) {
                pendingResult.finish();
            }
        }
    }

    public static class zzb
    implements ServiceConnection {
        private final Context zzqn;
        private final Intent zzclc;
        private final Queue<Pair<Intent, BroadcastReceiver.PendingResult>> zzcld = new LinkedList<Pair<Intent, BroadcastReceiver.PendingResult>>();
        private zza zzcle;
        private boolean zzclf = false;

        public zzb(Context context, String string) {
            this.zzqn = context.getApplicationContext();
            this.zzclc = new Intent(string).setPackage(this.zzqn.getPackageName());
        }

        public synchronized void zzb(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
            }
            this.zzcld.add((Pair<Intent, BroadcastReceiver.PendingResult>)new Pair((Object)intent, (Object)pendingResult));
            this.zzwH();
        }

        private synchronized void zzwH() {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"flush queue called");
            }
            while (!this.zzcld.isEmpty()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
                }
                if (this.zzcle != null && this.zzcle.isBinderAlive()) {
                    if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                        Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                    }
                    Pair<Intent, BroadcastReceiver.PendingResult> pair = this.zzcld.poll();
                    this.zzcle.zza((Intent)pair.first, (BroadcastReceiver.PendingResult)pair.second);
                    continue;
                }
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    boolean bl = !this.zzclf;
                    Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
                }
                if (!this.zzclf) {
                    this.zzclf = true;
                    try {
                        if (com.google.android.gms.common.stats.zza.zzyJ().zza(this.zzqn, this.zzclc, this, 65)) {
                            return;
                        }
                        Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                    }
                    catch (SecurityException securityException) {
                        Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                    }
                    while (!this.zzcld.isEmpty()) {
                        Pair<Intent, BroadcastReceiver.PendingResult> pair = this.zzcld.poll();
                        ((BroadcastReceiver.PendingResult)pair.second).finish();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzb zzb2 = this;
            synchronized (zzb2) {
                this.zzclf = false;
                this.zzcle = (zza)iBinder;
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    String string = String.valueOf(componentName);
                    Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
                }
                this.zzwH();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                String string = String.valueOf(componentName);
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
            }
            this.zzwH();
        }
    }
}

