/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v4.content.SharedPreferencesCompat;

public class AppLaunchChecker {
    private static final String SHARED_PREFS_NAME = "android.support.AppLaunchChecker";
    private static final String KEY_STARTED_FROM_LAUNCHER = "startedFromLauncher";

    public static boolean hasStartedFromLauncher(Context context) {
        return context.getSharedPreferences(SHARED_PREFS_NAME, 0).getBoolean(KEY_STARTED_FROM_LAUNCHER, false);
    }

    public static void onActivityCreate(Activity activity) {
        SharedPreferences sp = activity.getSharedPreferences(SHARED_PREFS_NAME, 0);
        if (sp.getBoolean(KEY_STARTED_FROM_LAUNCHER, false)) {
            return;
        }
        Intent launchIntent = activity.getIntent();
        if (launchIntent == null) {
            return;
        }
        if ("android.intent.action.MAIN".equals(launchIntent.getAction()) && (launchIntent.hasCategory("android.intent.category.LAUNCHER") || launchIntent.hasCategory("android.intent.category.LEANBACK_LAUNCHER"))) {
            SharedPreferencesCompat.EditorCompat.getInstance().apply(sp.edit().putBoolean(KEY_STARTED_FROM_LAUNCHER, true));
        }
    }
}

