/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import com.google.android.gms.internal.zza;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzd;
import com.google.android.gms.internal.zzg;
import com.google.android.gms.internal.zzi;
import com.google.android.gms.internal.zzj;
import com.google.android.gms.internal.zzk;
import com.google.android.gms.internal.zzl;
import com.google.android.gms.internal.zzp;
import com.google.android.gms.internal.zzq;
import com.google.android.gms.internal.zzr;
import com.google.android.gms.internal.zzs;
import com.google.android.gms.internal.zzt;
import com.google.android.gms.internal.zzv;
import com.google.android.gms.internal.zzz;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.cookie.DateUtils;

public class zzu
implements zzg {
    protected static final boolean DEBUG = zzt.DEBUG;
    private static int zzan = 3000;
    private static int zzao = 4096;
    protected final zzz zzap;
    protected final zzv zzaq;

    public zzu(zzz zzz2) {
        this(zzz2, new zzv(zzao));
    }

    public zzu(zzz zzz2, zzv zzv2) {
        this.zzap = zzz2;
        this.zzaq = zzv2;
    }

    @Override
    public zzj zza(zzl<?> zzl2) throws zzs {
        long l = SystemClock.elapsedRealtime();
        while (true) {
            HttpResponse httpResponse = null;
            byte[] byArray = null;
            Map<String, String> map = Collections.emptyMap();
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.zza(hashMap, zzl2.zzh());
                httpResponse = this.zzap.zza(zzl2, hashMap);
                StatusLine statusLine = httpResponse.getStatusLine();
                int n = statusLine.getStatusCode();
                map = zzu.zza(httpResponse.getAllHeaders());
                if (n == 304) {
                    zzb.zza zza2 = zzl2.zzh();
                    if (zza2 == null) {
                        return new zzj(304, null, map, true, SystemClock.elapsedRealtime() - l);
                    }
                    zza2.zzf.putAll(map);
                    return new zzj(304, zza2.data, zza2.zzf, true, SystemClock.elapsedRealtime() - l);
                }
                byArray = httpResponse.getEntity() != null ? this.zza(httpResponse.getEntity()) : new byte[]{};
                long l2 = SystemClock.elapsedRealtime() - l;
                this.zza(l2, zzl2, byArray, statusLine);
                if (n < 200 || n > 299) {
                    throw new IOException();
                }
                return new zzj(n, byArray, map, false, SystemClock.elapsedRealtime() - l);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                zzu.zza("socket", zzl2, new zzr());
                continue;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                zzu.zza("connection", zzl2, new zzr());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Bad URL " + zzl2.getUrl(), malformedURLException);
            }
            catch (IOException iOException) {
                if (httpResponse == null) {
                    throw new zzk(iOException);
                }
                int n = httpResponse.getStatusLine().getStatusCode();
                zzt.zzc("Unexpected response code %d for %s", n, zzl2.getUrl());
                if (byArray != null) {
                    zzj zzj2 = new zzj(n, byArray, map, false, SystemClock.elapsedRealtime() - l);
                    if (n == 401 || n == 403) {
                        zzu.zza("auth", zzl2, new zza(zzj2));
                        continue;
                    }
                    if (n >= 400 && n <= 499) {
                        throw new zzd(zzj2);
                    }
                    if (n >= 500 && n <= 599) {
                        throw new zzq(zzj2);
                    }
                    throw new zzq(zzj2);
                }
                zzu.zza("network", zzl2, new zzi());
                continue;
            }
            break;
        }
    }

    private void zza(long l, zzl<?> zzl2, byte[] byArray, StatusLine statusLine) {
        if (DEBUG || l > (long)zzan) {
            zzt.zzb("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", zzl2, l, byArray != null ? Integer.valueOf(byArray.length) : "null", statusLine.getStatusCode(), zzl2.zzq().zzd());
        }
    }

    private static void zza(String string2, zzl<?> zzl2, zzs zzs2) throws zzs {
        zzp zzp2 = zzl2.zzq();
        int n = zzl2.zzp();
        try {
            zzp2.zza(zzs2);
        }
        catch (zzs zzs3) {
            zzl2.zzc(String.format("%s-timeout-giveup [timeout=%s]", string2, n));
            throw zzs3;
        }
        zzl2.zzc(String.format("%s-retry [timeout=%s]", string2, n));
    }

    private void zza(Map<String, String> map, zzb.zza zza2) {
        if (zza2 == null) {
            return;
        }
        if (zza2.zza != null) {
            map.put("If-None-Match", zza2.zza);
        }
        if (zza2.zzc > 0L) {
            Date date = new Date(zza2.zzc);
            map.put("If-Modified-Since", DateUtils.formatDate((Date)date));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zza(HttpEntity httpEntity) throws IOException, zzq {
        byte[] byArray;
        zzab zzab2 = new zzab(this.zzaq, (int)httpEntity.getContentLength());
        byte[] byArray2 = null;
        try {
            int n;
            InputStream inputStream = httpEntity.getContent();
            if (inputStream == null) {
                throw new zzq();
            }
            byArray2 = this.zzaq.zzb(1024);
            while ((n = inputStream.read(byArray2)) != -1) {
                zzab2.write(byArray2, 0, n);
            }
            byArray = zzab2.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                httpEntity.consumeContent();
            }
            catch (IOException iOException) {
                zzt.zza("Error occured when calling consumingContent", new Object[0]);
            }
            this.zzaq.zza(byArray2);
            zzab2.close();
            throw throwable;
        }
        try {
            httpEntity.consumeContent();
        }
        catch (IOException iOException) {
            zzt.zza("Error occured when calling consumingContent", new Object[0]);
        }
        this.zzaq.zza(byArray2);
        zzab2.close();
        return byArray;
    }

    protected static Map<String, String> zza(Header[] headerArray) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < headerArray.length; ++i) {
            treeMap.put(headerArray[i].getName(), headerArray[i].getValue());
        }
        return treeMap;
    }
}

