# DeepRec Model Zoo

Here is example training code of some public popular models using public dataset.
Contained models are as follow:

|            Model               |                                                                 Paper                                                                  |
| ------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------- |
| [WDL](wide_and_deep/README.md) | [DLRS 2016] [Wide & Deep Learning for Recommender Systems](https://arxiv.org/pdf/1606.07792.pdf)                                       |
| [DLRM](dlrm/README.md)         | [ArXiv 2019] [Deep Learning Recommendation Model for Personalization and Recommendation Systems](https://arxiv.org/pdf/1906.00091.pdf) |
| [DSSM](dssm/README.md)         | [CIKM 2013] [Learning Deep Structured Semantic Models for Web Search using Clickthrough Data](https://posenhuang.github.io/papers/cikm2013_DSSM_fullversion.pdf)     |
| [DIEN](dien/README.md)         | [AAAI 2019] [Deep Interest Evolution Network for Click-Through Rate Prediction](https://arxiv.org/pdf/1809.03672.pdf)                  |
| [DIN](din/README.md)           | [KDD 2018] [Deep Interest Network for Click-Through Rate Prediction](https://arxiv.org/pdf/1706.06978.pdf)                             |
| [DeepFM](deepfm/README.md)     | [IJCAI 2017] [DeepFM: A Factorization-Machine based Neural Network for CTR Prediction](http://www.ijcai.org/proceedings/2017/0239.pdf) |
| [MMOE](mmoe/README.md)         | [KDD 2018] [Modeling Task Relationships in Multi-task Learning with Multi-gate Mixture-of-Experts](https://dl.acm.org/doi/abs/10.1145/3219819.3220007) |
| [DBMTL](dbmtl/README.md)       | [ArXiv 2019] [Deep Bayesian Multi-Target Learning for Recommender Systems](https://arxiv.org/pdf/1902.09154.pdf)                       |
| [BST](bst/README.md)           | [DLP-KDD 2019] [Behavior sequence transformer for e-commerce recommendation in Alibaba](https://arxiv.org/pdf/1905.06874.pdf)          |
| [ESMM](esmm/README.md)         | [SIGIR 2018] [Entire Space Multi-Task Model: An Effective Approach for Estimating Post-Click Conversion Rate](https://arxiv.org/pdf/1804.07931.pdf) |
| [SimpleMultiTask](simplemultitask/README.md) | [ArXiv 2017] [An Overview of Multi-Task Learning in Deep Neural Networks](https://arxiv.org/pdf/1706.05098.pdf)          |
| [DCN](dcn/README.md)           | [ADKDD 2017] [Deep & Cross Network for Ad Click Predictions](https://arxiv.org/abs/1708.05123)                                         |
| [DCNv2](dcnv2/README.md)       | [ArXiv 2020] [DCN V2: Improved Deep & Cross Network and Practical Lessons for Web-scale Learning to Rank Systems](https://arxiv.org/pdf/2008.13535.pdf) |
| [MaskNet](masknet/README.md)   | [ArXiv 2021] [MaskNet: Introducing Feature-Wise Multiplication to CTR Ranking Models by Instance-Guided Mask](https://arxiv.org/pdf/2102.07619.pdf) |
| [PLE](ple/README.md)           | [RecSys 2020] [Progressive Layered Extraction (PLE): A Novel Multi-Task Learning (MTL) Model for Personalized Recommendations](https://dl.acm.org/doi/10.1145/3383313.3412236)   |
