import { __decorate } from '../../../../tslib/tslib.es6.mjs.js';
import { property as n } from '../../../../@lit/reactive-element/decorators/property.js';
import { Tab } from './tab.js';

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A primary tab component.
 */
class PrimaryTab extends Tab {
    constructor() {
        super(...arguments);
        /**
         * Whether or not the icon renders inline with label or stacked vertically.
         */
        this.inlineIcon = false;
    }
    getContentClasses() {
        return {
            ...super.getContentClasses(),
            'stacked': !this.inlineIcon,
        };
    }
}
__decorate([
    n({ type: Boolean, attribute: 'inline-icon' })
], PrimaryTab.prototype, "inlineIcon", void 0);

export { PrimaryTab };
