import { __decorate } from '../../../tslib/tslib.es6.mjs.js';
import { customElement as t } from '../../../@lit/reactive-element/decorators/custom-element.js';
import '../../../@lit/reactive-element/reactive-element.js';
import { Radio } from './internal/radio.js';
import { styles } from './internal/radio-styles.js';

/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary Radio buttons allow users to select one option from a set.
 *
 * @description
 * Radio buttons are the recommended way to allow users to make a single
 * selection from a list of options.
 *
 * Only one radio button can be selected at a time.
 *
 * Use radio buttons to:
 * - Select a single option from a set
 * - Expose all available options
 *
 * @final
 * @suppress {visibility}
 */
let MdRadio = class MdRadio extends Radio {
};
MdRadio.styles = [styles];
MdRadio = __decorate([
    t('md-radio')
], MdRadio);

export { MdRadio };
