import { __decorate } from '../../../../tslib/tslib.es6.mjs.js';
import '../../../../@lit/reactive-element/reactive-element.js';
import { html as x, nothing as T } from '../../../../lit-html/lit-html.js';
import { LitElement as s } from '../../../../lit-element/lit-element.js';
import { property as n } from '../../../../@lit/reactive-element/decorators/property.js';
import { classMap as e } from '../../../../lit-html/directives/class-map.js';
import { requestUpdateOnAriaChange } from '../../internal/aria/delegate.js';

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A progress component.
 */
class Progress extends s {
    constructor() {
        super(...arguments);
        /**
         * Progress to display, a fraction between 0 and `max`.
         */
        this.value = 0;
        /**
         * Maximum progress to display, defaults to 1.
         */
        this.max = 1;
        /**
         * Whether or not to display indeterminate progress, which gives no indication
         * to how long an activity will take.
         */
        this.indeterminate = false;
        /**
         * Whether or not to render indeterminate mode using 4 colors instead of one.
         */
        this.fourColor = false;
    }
    render() {
        // Needed for closure conformance
        const { ariaLabel } = this;
        return x `
      <div
        class="progress ${e(this.getRenderClasses())}"
        role="progressbar"
        aria-label="${ariaLabel || T}"
        aria-valuemin="0"
        aria-valuemax=${this.max}
        aria-valuenow=${this.indeterminate ? T : this.value}
        >${this.renderIndicator()}</div
      >
    `;
    }
    getRenderClasses() {
        return {
            'indeterminate': this.indeterminate,
            'four-color': this.fourColor,
        };
    }
}
(() => {
    requestUpdateOnAriaChange(Progress);
})();
__decorate([
    n({ type: Number })
], Progress.prototype, "value", void 0);
__decorate([
    n({ type: Number })
], Progress.prototype, "max", void 0);
__decorate([
    n({ type: Boolean })
], Progress.prototype, "indeterminate", void 0);
__decorate([
    n({ type: Boolean, attribute: 'four-color' })
], Progress.prototype, "fourColor", void 0);

export { Progress };
