import { __decorate } from '../../../tslib/tslib.es6.mjs.js';
import { customElement as t } from '../../../@lit/reactive-element/decorators/custom-element.js';
import '../../../@lit/reactive-element/reactive-element.js';
import { List } from './internal/list.js';
import { styles } from './internal/list-styles.js';

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary Lists are continuous, vertical indexes of text or images.
 *
 * @description
 * Lists consist of one or more list items, and can contain actions represented
 * by icons and text. List items come in three sizes: one-line, two-line, and
 * three-line.
 *
 * __Takeaways:__
 *
 * - Lists should be sorted in logical ways that make content easy to scan, such
 *   as alphabetical, numerical, chronological, or by user preference.
 * - Lists present content in a way that makes it easy to identify a specific
 *   item in a collection and act on it.
 * - Lists should present icons, text, and actions in a consistent format.
 *
 * @final
 * @suppress {visibility}
 */
let MdList = class MdList extends List {
};
MdList.styles = [styles];
MdList = __decorate([
    t('md-list')
], MdList);

export { MdList };
