import '../../../../../@lit/reactive-element/reactive-element.js';
import { render as j, html as x } from '../../../../../lit-html/lit-html.js';
import '../../../../../lit-element/lit-element.js';
import { Validator } from './validator.js';

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A validator that provides constraint validation that emulates `<select>`
 * validation.
 */
class SelectValidator extends Validator {
    computeValidity(state) {
        if (!this.selectControl) {
            // Lazily create the platform select
            this.selectControl = document.createElement('select');
        }
        j(x `<option value=${state.value}></option>`, this.selectControl);
        this.selectControl.value = state.value;
        this.selectControl.required = state.required;
        return {
            validity: this.selectControl.validity,
            validationMessage: this.selectControl.validationMessage,
        };
    }
    equals(prev, next) {
        return prev.value === next.value && prev.required === next.required;
    }
    copy({ value, required }) {
        return { value, required };
    }
}

export { SelectValidator };
