import { __decorate } from '../../../tslib/tslib.es6.mjs.js';
import { customElement as t } from '../../../@lit/reactive-element/decorators/custom-element.js';
import '../../../@lit/reactive-element/reactive-element.js';
import { styles as styles$1 } from './internal/filled-tonal-styles.js';
import { IconButton } from './internal/icon-button.js';
import { styles } from './internal/shared-styles.js';

/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary Icon buttons help people take supplementary actions with a single
 * tap.
 *
 * @description
 * __Emphasis:__ Low emphasis – For optional or supplementary actions with the
 * least amount of prominence.
 *
 * __Rationale:__ The most compact and unobtrusive type of button, icon buttons
 * are used for optional supplementary actions such as "Bookmark" or "Star."
 *
 * __Example usages:__
 * - Add to Favorites
 * - Print
 *
 * @final
 * @suppress {visibility}
 */
let MdFilledTonalIconButton = class MdFilledTonalIconButton extends IconButton {
    getRenderClasses() {
        return {
            ...super.getRenderClasses(),
            'filled-tonal': true,
            'toggle-filled-tonal': this.toggle,
        };
    }
};
MdFilledTonalIconButton.styles = [styles, styles$1];
MdFilledTonalIconButton = __decorate([
    t('md-filled-tonal-icon-button')
], MdFilledTonalIconButton);

export { MdFilledTonalIconButton };
