import { __decorate } from '../../../tslib/tslib.es6.mjs.js';
import { customElement as t } from '../../../@lit/reactive-element/decorators/custom-element.js';
import '../../../@lit/reactive-element/reactive-element.js';
import { Fab } from './internal/fab.js';
import { styles as styles$1 } from './internal/fab-branded-styles.js';
import { styles as styles$2 } from './internal/forced-colors-styles.js';
import { styles } from './internal/shared-styles.js';

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary Floating action buttons (FABs) help people take primary actions.
 * They’re used to represent the most important action on a screen, such as
 * Create or Reply.
 *
 * @description
 * __Emphasis:__ High emphasis – For the primary, most important, or most common
 * action on a screen
 *
 * __Rationale:__ The FAB remains the default component for a screen’s primary
 * action. It comes in three sizes: small FAB, FAB, and large FAB. The extended
 * FAB’s wider format and text label give it more visual prominence than a  FAB.
 * It’s often used on larger screens where a FAB would seem too small. Branded
 * FABs are used to specifically call attention to branded logo icons.
 *
 * __Example usages:__
 * - FAB
 *   - Create
 *   - Compose
 * - Extended FAB
 *   - Create
 *   - Compose
 *   - New Thread
 *   - New File
 *
 * @final
 * @suppress {visibility}
 */
let MdBrandedFab = class MdBrandedFab extends Fab {
    getRenderClasses() {
        return {
            ...super.getRenderClasses(),
            'primary': false,
            'secondary': false,
            'tertiary': false,
            'small': false,
        };
    }
};
MdBrandedFab.styles = [styles, styles$1, styles$2];
MdBrandedFab = __decorate([
    t('md-branded-fab')
], MdBrandedFab);

export { MdBrandedFab };
