import { __decorate } from '../../../tslib/tslib.es6.mjs.js';
import { customElement as t } from '../../../@lit/reactive-element/decorators/custom-element.js';
import '../../../@lit/reactive-element/reactive-element.js';
import { Divider } from './internal/divider.js';
import { styles } from './internal/divider-styles.js';

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary A divider is a thin line that groups content in lists and
 * containers.
 *
 * @description Dividers can reinforce tapability, such as when used to separate
 * list items or define tappable regions in an accordion.
 *
 * @final
 * @suppress {visibility}
 */
let MdDivider = class MdDivider extends Divider {
};
MdDivider.styles = [styles];
MdDivider = __decorate([
    t('md-divider')
], MdDivider);

export { MdDivider };
