import { __decorate } from '../../../../tslib/tslib.es6.mjs.js';
import '../../../../@lit/reactive-element/reactive-element.js';
import { html as x, nothing as T } from '../../../../lit-html/lit-html.js';
import '../../../../lit-element/lit-element.js';
import { property as n } from '../../../../@lit/reactive-element/decorators/property.js';
import { query as e } from '../../../../@lit/reactive-element/decorators/query.js';
import { MultiActionChip } from './multi-action-chip.js';
import { renderRemoveButton } from './trailing-icons.js';

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * An input chip component.
 *
 * @fires remove {Event} Dispatched when the remove button is clicked.
 */
class InputChip extends MultiActionChip {
    constructor() {
        super(...arguments);
        this.avatar = false;
        this.href = '';
        this.target = '';
        this.removeOnly = false;
        this.selected = false;
    }
    get primaryId() {
        if (this.href) {
            return 'link';
        }
        if (this.removeOnly) {
            return '';
        }
        return 'button';
    }
    get rippleDisabled() {
        // Link chips cannot be disabled
        return !this.href && this.disabled;
    }
    get primaryAction() {
        // Don't use @query() since a remove-only input chip still has a span that
        // has "primary action" classes.
        if (this.removeOnly) {
            return null;
        }
        return this.renderRoot.querySelector('.primary.action');
    }
    getContainerClasses() {
        return {
            ...super.getContainerClasses(),
            avatar: this.avatar,
            // Link chips cannot be disabled
            disabled: !this.href && this.disabled,
            link: !!this.href,
            selected: this.selected,
            'has-trailing': true,
        };
    }
    renderPrimaryAction(content) {
        const { ariaLabel } = this;
        if (this.href) {
            return x `
        <a
          class="primary action"
          id="link"
          aria-label=${ariaLabel || T}
          href=${this.href}
          target=${this.target || T}
          >${content}</a
        >
      `;
        }
        if (this.removeOnly) {
            return x `
        <span class="primary action" aria-label=${ariaLabel || T}>
          ${content}
        </span>
      `;
        }
        return x `
      <button
        class="primary action"
        id="button"
        aria-label=${ariaLabel || T}
        ?disabled=${this.disabled && !this.alwaysFocusable}
        type="button"
        >${content}</button
      >
    `;
    }
    renderTrailingAction(focusListener) {
        return renderRemoveButton({
            focusListener,
            ariaLabel: this.ariaLabelRemove,
            disabled: !this.href && this.disabled,
            tabbable: this.removeOnly,
        });
    }
}
__decorate([
    n({ type: Boolean })
], InputChip.prototype, "avatar", void 0);
__decorate([
    n()
], InputChip.prototype, "href", void 0);
__decorate([
    n()
], InputChip.prototype, "target", void 0);
__decorate([
    n({ type: Boolean, attribute: 'remove-only' })
], InputChip.prototype, "removeOnly", void 0);
__decorate([
    n({ type: Boolean, reflect: true })
], InputChip.prototype, "selected", void 0);
__decorate([
    e('.trailing.action')
], InputChip.prototype, "trailingAction", void 0);

export { InputChip };
