import { __decorate } from '../../../../tslib/tslib.es6.mjs.js';
import '../../elevation/elevation.js';
import '../../../../@lit/reactive-element/reactive-element.js';
import { html as x, nothing as T } from '../../../../lit-html/lit-html.js';
import '../../../../lit-element/lit-element.js';
import { property as n } from '../../../../@lit/reactive-element/decorators/property.js';
import { Chip } from './chip.js';

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * An assist chip component.
 */
class AssistChip extends Chip {
    constructor() {
        super(...arguments);
        this.elevated = false;
        this.href = '';
        this.target = '';
    }
    get primaryId() {
        return this.href ? 'link' : 'button';
    }
    get rippleDisabled() {
        // Link chips cannot be disabled
        return !this.href && this.disabled;
    }
    getContainerClasses() {
        return {
            ...super.getContainerClasses(),
            // Link chips cannot be disabled
            disabled: !this.href && this.disabled,
            elevated: this.elevated,
            link: !!this.href,
        };
    }
    renderPrimaryAction(content) {
        const { ariaLabel } = this;
        if (this.href) {
            return x `
        <a
          class="primary action"
          id="link"
          aria-label=${ariaLabel || T}
          href=${this.href}
          target=${this.target || T}
          >${content}</a
        >
      `;
        }
        return x `
      <button
        class="primary action"
        id="button"
        aria-label=${ariaLabel || T}
        ?disabled=${this.disabled && !this.alwaysFocusable}
        type="button"
        >${content}</button
      >
    `;
    }
    renderOutline() {
        if (this.elevated) {
            return x `<md-elevation part="elevation"></md-elevation>`;
        }
        return super.renderOutline();
    }
}
__decorate([
    n({ type: Boolean })
], AssistChip.prototype, "elevated", void 0);
__decorate([
    n()
], AssistChip.prototype, "href", void 0);
__decorate([
    n()
], AssistChip.prototype, "target", void 0);

export { AssistChip };
