import { __decorate } from '../../../tslib/tslib.es6.mjs.js';
import { customElement as t } from '../../../@lit/reactive-element/decorators/custom-element.js';
import '../../../@lit/reactive-element/reactive-element.js';
import { OutlinedButton } from './internal/outlined-button.js';
import { styles as styles$1 } from './internal/outlined-styles.js';
import { styles } from './internal/shared-styles.js';

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary Buttons help people take action, such as sending an email, sharing a
 * document, or liking a comment.
 *
 * @description
 * __Emphasis:__ Medium emphasis – For important actions that don’t distract
 * from other onscreen elements.
 *
 * __Rationale:__ Use an outlined button for actions that need attention but
 * aren’t the primary action, such as “See all” or “Add to cart.” This is also
 * the button to use for giving someone the opportunity to change their mind or
 * escape a flow.
 *
 * __Example usages:__
 * - Reply
 * - View all
 * - Add to cart
 * - Take out of trash
 *
 * @final
 * @suppress {visibility}
 */
let MdOutlinedButton = class MdOutlinedButton extends OutlinedButton {
};
MdOutlinedButton.styles = [styles, styles$1];
MdOutlinedButton = __decorate([
    t('md-outlined-button')
], MdOutlinedButton);

export { MdOutlinedButton };
