---
title: Gun-Vue
layout: home
hero:
  name: Gun-Vue
  text: Reactive crypto graph webapp toolbox
  tagline: Pluggable Vue UI powered by GUN graph database and SEA cryptography
  image:
    src: gun-vue-logo.svg
    alt: Gun-Vue logo
  actions:
    - theme: brand
      text: Getting Started
      link: /reference/typedoc/README
    - theme: alt
      text: Documentation
      link: /reference/typedoc/modules
    - theme: alt
      text: Go to app
      link: https://gun-vue.js.org/
features:
  - icon: ✨
    title: Low-code trustful web-apps
    details: Build trustful reactive p2p crypto graph applications for casual use with family, friends and wider communities.
    linkText: Start building
    link: /tutorials/first-app

  - icon: <span class="i-carbon:ibm-toolchain"></span>
    title: Reactive composables
    details: Gun-Vue provides a set of reactive composables that make it easy to integrate Gun with Vue.js applications, allowing you to build powerful p2p apps with minimal boilerplate code.
    link: /packages/composables
    linkText: Explore composables

  - icon: ⚡️
    title: Reactive P2P database
    details: Every object exported is reactive to changes in Gun p2p database
  
  - icon: ✨
    title: Local-first single HTML apps
    details: Gun-Vue enables the creation of local-first applications, meaning data is stored locally and synced with the global network only when necessary. All the components and logic required for your Gun-Vue application can be packed into a single HTML file, simplifying deployment and making it easy to share your app with others.

  - title: Pluggable Components
    details: With Gun-Vue, you can create and use custom pluggable components, making it simple to extend the functionality of your app and reuse components across different projects.
    link: https://github.com/DeFUCC/gun-vue/tree/master/src/components
    linkText: Explore Pluggable Components

  - title: Easy Integration
    details: Gun-Vue is designed to work seamlessly with existing Vue.js projects, making it simple to add real-time data synchronization and other Gun features to your app without major refactoring.

  - title: Decentralized Data Storage
    details: Leverage the power of Gun's decentralized data storage system to build apps that are resistant to censorship and data loss, providing a secure and resilient foundation for your projects.
    link: https://gun.eco/docs/
    linkText: Read Gun docs



  - title: Open Source
    details: Gun-Vue is an open-source project, meaning you can contribute to its development, report issues, and collaborate with the community to help improve the toolkit and build better apps.
    link: https://github.com/DeFUCC/gun-vue
    linkText: View on GitHub

---


<style >
.VPImage {
  transform: translate(-50%, -50%) scale(2)  !important;
}
</style>

<script setup>

</script>
