/*
 * Copyright 2019 WeBank
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.webank.wedatasphere.dss.standard.common.entity.ref;

import com.webank.wedatasphere.dss.standard.common.entity.ref.ResponseRefBuilder.*;

import java.util.Map;


public interface ResponseRef extends Ref {

    Object getValue(String key);

    Map<String, Object> toMap();

    String getResponseBody();

    int getStatus();

    String getErrorMsg();

    default boolean isSucceed() {
        return getStatus() == 0 || getStatus() == 200;
    }

    default boolean isFailed() {
        return !isSucceed();
    }

    static InternalResponseRefBuilder newInternalBuilder() {
        return new InternalResponseRefBuilder();
    }

    static ExternalResponseRefBuilder newExternalBuilder() {
        return new ExternalResponseRefBuilder();
    }

    static MutableExternalResponseRefBuilder newMutableExternalBuilder() {
        return new MutableExternalResponseRefBuilder();
    }

}