/*
 * Copyright 2019 WeBank
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.webank.wedatasphere.dss.workflow.entity.vo;

import java.util.List;

public class NodeGroupVO implements Comparable<NodeGroupVO> {
    private Long id;
    /**
     * title是前台字段..后台自动根据请求头返回中英文字段
     * chilren是为了适配前台插件的字段
     */
    private String title;
    private String description;
    private Integer order;

    private List<NodeInfoVO> children;

    public List<NodeInfoVO> getChildren() {
        return children;
    }

    public void setChildren(List<NodeInfoVO> children) {
        this.children = children;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    @Override
    public int compareTo(NodeGroupVO o) {
        return this.order - o.order;
    }
}
