package com.webank.wedatasphere.dss.orchestrator.core.type;

import com.webank.wedatasphere.dss.appconn.core.AppConn;
import com.webank.wedatasphere.dss.appconn.core.ext.OnlyDevelopmentAppConn;

import java.util.function.Predicate;

/**
 * @author enjoyyin
 * @date 2022-03-20
 * @since 0.5.0
 */
public class WorkflowRelation implements DSSOrchestratorRelation {

    @Override
    public String getDSSOrchestratorMode() {
        return "pom_work_flow";
    }

    @Override
    public String getDSSOrchestratorName() {
        return "workflow";
    }

    @Override
    public String getDSSOrchestratorName_CN() {
        return "工作流";
    }

    @Override
    public String getBindingAppConnName() {
        return "workflow";
    }

    @Override
    public String getBindingSchedulerAppConnName() {
        return "schedulis";
    }

    @Override
    public Predicate<AppConn> isLinkedAppConn() {
        return appConn -> appConn instanceof OnlyDevelopmentAppConn;
    }
}
