# DSharpPlus CommandsNext Example: Argument Converters!
This example shows how to create and register argument converters. Argument converters are used to convert raw string arguments into objects that can be used by commands.

# Creating the converter:
```cs
// Inherit from IArgumentConverter<T>, where T is the type you want to convert to.
public sealed class UlidConverter : IArgumentConverter<Ulid>
{
    public Task<Optional<Ulid>> ConvertAsync(string value, CommandContext context)
    {
        // Attempt to parse the value as an Ulid.
        if (Ulid.TryParse(value, out Ulid ulid))
        {
            // Because our logic is synchronous, we can use Task.FromResult.
            return Task.FromResult(Optional.FromValue(ulid));
        }
        else
        {
            // We use Optional.FromNoValue to indicate that the conversion failed.
            return Task.FromResult(Optional.FromNoValue<Ulid>());
        }
    }
}
```

# Registering the converter:
```cs
CommandsNextExtension commandsNext = client.UseCommandsNext(commandsConfig);
commandsNext.RegisterConverter(new UlidConverter());
```