# Contributing to Cylvre

First of all, thanks for contributing to Cylvre! :partying_face: 

It is the dedication of people like you that help this project by submitting issues, pull requests etc that drive this project and make it better. As of now, there are a lot of issues with the compiler as it is still pre-alpha. There are still a few ways to contribute to this project. Interested? Read these guidelines to help you on your journey.

## Ways to contribute.

- **Star this repository**: By starring this repository, you show that this project is valuable to you. By showing your interest, we know that this project is worth taking to the next level to provide better software.

- **Help with issues**: Contribute some code! Help us bring Cylvre to next stages faster by helping us with issues. To show that you want to work on an issue, comment on the issue you wan to work on and submit a pull request once you are done. If you are a newcomer, try [these](https://github.com/Cylvre-Language/Cylvre/labels/good%20first%20issue) issues that are marked as good first issues. You can then move on to other issues.
   - If any issue is marked with the `in progress` label, then it is being worked on by someone. If it has the label and the issue has been sitting for a long time, you can comment on the issue stating that you have an interest in it. Then, a reviewer will most probably let you work on the issue, considering there are no special circumstances.
   - Also check whether anyone has been assigned to an issue, we don't want to waste any hard work.

- **Testing Cylvre**: OK. Cylvre's compiler already has a lot of issues currently (pre-alpha), but there may be unknown errors lurking in there on errors that hasn't been listed yet. Check [this TODO list](https://github.com/Cylvre-Language/Cylvre/blob/main/TODO.md) of things to implement and check existing issues also. If the issue you are looking for isn't there, feel free to open a new one or submit a pull request updating the list. 

- **Fixing Typos**: No one can type/write perfectly. Found a typo or broken link? submit a quick [pull request](https://github.com/Cylvre-Language/Cylvre/pulls) or [create an issue](https://github.com/Cylvre-Language/Cylvre/issues).

- **Documentation**: Help with the documentation of Cylvre! Submit a PR with docs on a feature, or give suggestions on how to improve [Cylvre Docs](https://sivaxis.gitbook.io/cylvre-docs/) in [this issue](https://github.com/Cylvre-Language/Cylvre/issues/11).

- **Reporting Vulnerabilities**: Found a security vulnerability in the compiler? Report it by opening an issue. Details can be found [here](https://github.com/Cylvre-Language/Cylvre/blob/main/SECURITY.md).

## Code Contribution
If you are contrbuting code, please make sure you follow the following guidelines.
- Code is properly indented.
- For functions with too many parameters, please make sure you pu the parameters on a new line if it crosses a certain limit.

```java
public String aLotOfParameters(String p1, String p2, String p3, String p4, String p5, String p6,
                               String p7) 
{
   //code goes here                               
}
```

**Pull Requests are checked by both TravisCI. Please make sure your pull request passes the checks or your pull request will be closed or you will be asked to modify your pull request.**

## Issues and Pull Requests
- **Issues**: To submit an issue, please use the issue templates provided. If the issue type you are going to submit isn't there as part of the templates, open a blank issue.
  - Make sure your issue isn't a duplicate of another existing issue, or the issue has already been resolved by a pull request that hasn't been merged yet.


- **Pull Requests**: Before you submit a pull request, make sure you check all the points in the following list.
  - The changes all follow the MIT license.
  - The changes you have made are not breaking changes. If so, ask me about it [here](https://github.com/Cylvre-Language/Cylvre/discussions/9).
  - The changes work on your system locally.
  - You have written tests for it and all tests have passed.
  - The additions/deletions you have made don't introduce new errors or warnings.
  - The code you have written is properly commented, explaining what a code snippet does where ever necessary.
 

**If no one answers a newly opened issue or pull request for more than 3 days, feel free to follow up.**

> **Please follow the [CODE OF CONDUCT](https://github.com/Cylvre-Language/Cylvre/blob/main/CODE_OF_CONDUCT.md) while part of this community, let's make this place a joy for contributors!**

## Conclusions
If you are a contributor and want to chat with other contributors or with me, feel free to join the #CylvreSmiths (  [![Gitter](https://badges.gitter.im/Cylvre/CylvreSmiths.svg)](https://gitter.im/Cylvre/CylvreSmiths?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)  )!

Once again, Thank You for contributing.
More tips relevant to contributing will be posted here.

_Happy Coding!_
