// This is an open source non-commercial project. Dear PVS-Studio, please check it.
// PVS-Studio Static Code Analyzer for C, C++ and C#: http://www.viva64.com
// ******************************************************************
// *
// *  This file is part of the Cxbx project.
// *
// *  Cxbx and Cxbe are free software; you can redistribute them
// *  and/or modify them under the terms of the GNU General Public
// *  License as published by the Free Software Foundation; either
// *  version 2 of the license, or (at your option) any later version.
// *
// *  This program is distributed in the hope that it will be useful,
// *  but WITHOUT ANY WARRANTY; without even the implied warranty of
// *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// *  GNU General Public License for more details.
// *
// *  You should have recieved a copy of the GNU General Public License
// *  along with this program; see the file COPYING.
// *  If not, write to the Free Software Foundation, Inc.,
// *  59 Temple Place - Suite 330, Bostom, MA 02111-1307, USA.
// *
// *  (c) 2002-2003 Aaron Robinson <caustik@caustik.com>
// *
// *  All rights reserved
// *
// ******************************************************************


#include <core\kernel\exports\xboxkrnl.h>
#include "Cxbx.h" // For CxbxKrnl_KernelThunkTable
#include "core\kernel\init\CxbxKrnl.h" // For UINT

#define FUNC(f) f
#define VARIABLE(v) v

#define DEVKIT // developer kit only functions
#define PROFILING // private kernel profiling functions
// A.k.a. _XBOX_ENABLE_PROFILING

// kernel thunk table
// Note : Names that collide with other symbols, use the KRNL() macro.
uint32_t CxbxKrnl_KernelThunkTable[379] =
{
	(uint32_t)FUNC(xbox::zeroptr),                                  // 0x0000 (0) "Undefined", this function doesn't exist
	(uint32_t)FUNC(&xbox::AvGetSavedDataAddress),                   // 0x0001 (1)
	(uint32_t)FUNC(&xbox::AvSendTVEncoderOption),                   // 0x0002 (2)
	(uint32_t)FUNC(&xbox::AvSetDisplayMode),                        // 0x0003 (3)
	(uint32_t)FUNC(&xbox::AvSetSavedDataAddress),                   // 0x0004 (4)
	(uint32_t)FUNC(&xbox::DbgBreakPoint),                           // 0x0005 (5)
	(uint32_t)FUNC(&xbox::DbgBreakPointWithStatus),                 // 0x0006 (6)
	(uint32_t)FUNC(&xbox::DbgLoadImageSymbols),                     // 0x0007 (7) DEVKIT
	(uint32_t)FUNC(&xbox::DbgPrint),                                // 0x0008 (8)
	(uint32_t)FUNC(&xbox::HalReadSMCTrayState),                     // 0x0009 (9)
	(uint32_t)FUNC(&xbox::DbgPrompt),                               // 0x000A (10)
	(uint32_t)FUNC(&xbox::DbgUnLoadImageSymbols),                   // 0x000B (11) DEVKIT
	(uint32_t)FUNC(&xbox::ExAcquireReadWriteLockExclusive),         // 0x000C (12)
	(uint32_t)FUNC(&xbox::ExAcquireReadWriteLockShared),            // 0x000D (13)
	(uint32_t)FUNC(&xbox::ExAllocatePool),                          // 0x000E (14)
	(uint32_t)FUNC(&xbox::ExAllocatePoolWithTag),                   // 0x000F (15)
	(uint32_t)VARIABLE(&xbox::ExEventObjectType),                   // 0x0010 (16)
	(uint32_t)FUNC(&xbox::ExFreePool),                              // 0x0011 (17)
	(uint32_t)FUNC(&xbox::ExInitializeReadWriteLock),               // 0x0012 (18)
	(uint32_t)FUNC(&xbox::ExInterlockedAddLargeInteger),            // 0x0013 (19)
	(uint32_t)FUNC(&xbox::ExInterlockedAddLargeStatistic),          // 0x0014 (20)
	(uint32_t)FUNC(&xbox::ExInterlockedCompareExchange64),          // 0x0015 (21)
	(uint32_t)VARIABLE(&xbox::ExMutantObjectType),                  // 0x0016 (22)
	(uint32_t)FUNC(&xbox::ExQueryPoolBlockSize),                    // 0x0017 (23)
	(uint32_t)FUNC(&xbox::ExQueryNonVolatileSetting),               // 0x0018 (24)
	(uint32_t)FUNC(&xbox::ExReadWriteRefurbInfo),                   // 0x0019 (25)
	(uint32_t)FUNC(&xbox::ExRaiseException),                        // 0x001A (26)
	(uint32_t)FUNC(&xbox::ExRaiseStatus),                           // 0x001B (27)
	(uint32_t)FUNC(&xbox::ExReleaseReadWriteLock),                  // 0x001C (28)
	(uint32_t)FUNC(&xbox::ExSaveNonVolatileSetting),                // 0x001D (29)
	(uint32_t)VARIABLE(&xbox::ExSemaphoreObjectType),               // 0x001E (30)
	(uint32_t)VARIABLE(&xbox::ExTimerObjectType),                   // 0x001F (31)
	(uint32_t)FUNC(&xbox::ExfInterlockedInsertHeadList),            // 0x0020 (32)
	(uint32_t)FUNC(&xbox::ExfInterlockedInsertTailList),            // 0x0021 (33)
	(uint32_t)FUNC(&xbox::ExfInterlockedRemoveHeadList),            // 0x0022 (34)
	(uint32_t)FUNC(&xbox::FscGetCacheSize),                         // 0x0023 (35)
	(uint32_t)FUNC(&xbox::FscInvalidateIdleBlocks),                 // 0x0024 (36)
	(uint32_t)FUNC(&xbox::FscSetCacheSize),                         // 0x0025 (37)
	(uint32_t)FUNC(&xbox::HalClearSoftwareInterrupt),               // 0x0026 (38)
	(uint32_t)FUNC(&xbox::HalDisableSystemInterrupt),               // 0x0027 (39)
	(uint32_t)VARIABLE(&xbox::HalDiskCachePartitionCount),          // 0x0028 (40)  A.k.a. "IdexDiskPartitionPrefixBuffer"
	(uint32_t)VARIABLE(&xbox::HalDiskModelNumber),                  // 0x0029 (41)
	(uint32_t)VARIABLE(&xbox::HalDiskSerialNumber),                 // 0x002A (42)
	(uint32_t)FUNC(&xbox::HalEnableSystemInterrupt),                // 0x002B (43)
	(uint32_t)FUNC(&xbox::HalGetInterruptVector),                   // 0x002C (44)
	(uint32_t)FUNC(&xbox::HalReadSMBusValue),                       // 0x002D (45)
	(uint32_t)FUNC(&xbox::HalReadWritePCISpace),                    // 0x002E (46)
	(uint32_t)FUNC(&xbox::HalRegisterShutdownNotification),         // 0x002F (47)
	(uint32_t)FUNC(&xbox::HalRequestSoftwareInterrupt),             // 0x0030 (48)
	(uint32_t)FUNC(&xbox::HalReturnToFirmware),                     // 0x0031 (49)
	(uint32_t)FUNC(&xbox::HalWriteSMBusValue),                      // 0x0032 (50)
	(uint32_t)FUNC(&xbox::KRNL(InterlockedCompareExchange)),        // 0x0033 (51)
	(uint32_t)FUNC(&xbox::KRNL(InterlockedDecrement)),              // 0x0034 (52)
	(uint32_t)FUNC(&xbox::KRNL(InterlockedIncrement)),              // 0x0035 (53)
	(uint32_t)FUNC(&xbox::KRNL(InterlockedExchange)),               // 0x0036 (54)
	(uint32_t)FUNC(&xbox::KRNL(InterlockedExchangeAdd)),            // 0x0037 (55)
	(uint32_t)FUNC(&xbox::KRNL(InterlockedFlushSList)),             // 0x0038 (56)
	(uint32_t)FUNC(&xbox::KRNL(InterlockedPopEntrySList)),          // 0x0039 (57)
	(uint32_t)FUNC(&xbox::KRNL(InterlockedPushEntrySList)),         // 0x003A (58)
	(uint32_t)FUNC(&xbox::IoAllocateIrp),                           // 0x003B (59)
	(uint32_t)FUNC(&xbox::IoBuildAsynchronousFsdRequest),           // 0x003C (60)
	(uint32_t)FUNC(&xbox::IoBuildDeviceIoControlRequest),           // 0x003D (61)
	(uint32_t)FUNC(&xbox::IoBuildSynchronousFsdRequest),            // 0x003E (62)
	(uint32_t)FUNC(&xbox::IoCheckShareAccess),                      // 0x003F (63)
	(uint32_t)VARIABLE(&xbox::IoCompletionObjectType),              // 0x0040 (64)
	(uint32_t)FUNC(&xbox::IoCreateDevice),                          // 0x0041 (65)
	(uint32_t)FUNC(&xbox::IoCreateFile),                            // 0x0042 (66)
	(uint32_t)FUNC(&xbox::IoCreateSymbolicLink),                    // 0x0043 (67)
	(uint32_t)FUNC(&xbox::IoDeleteDevice),                          // 0x0044 (68)
	(uint32_t)FUNC(&xbox::IoDeleteSymbolicLink),                    // 0x0045 (69)
	(uint32_t)VARIABLE(&xbox::IoDeviceObjectType),                  // 0x0046 (70)
	(uint32_t)VARIABLE(&xbox::IoFileObjectType),                    // 0x0047 (71)
	(uint32_t)FUNC(&xbox::IoFreeIrp),                               // 0x0048 (72)
	(uint32_t)FUNC(&xbox::IoInitializeIrp),                         // 0x0049 (73)
	(uint32_t)FUNC(&xbox::IoInvalidDeviceRequest),                  // 0x004A (74)
	(uint32_t)FUNC(&xbox::IoQueryFileInformation),                  // 0x004B (75)
	(uint32_t)FUNC(&xbox::IoQueryVolumeInformation),                // 0x004C (76)
	(uint32_t)FUNC(&xbox::IoQueueThreadIrp),                        // 0x004D (77)
	(uint32_t)FUNC(&xbox::IoRemoveShareAccess),                     // 0x004E (78)
	(uint32_t)FUNC(&xbox::IoSetIoCompletion),                       // 0x004F (79)
	(uint32_t)FUNC(&xbox::IoSetShareAccess),                        // 0x0050 (80)
	(uint32_t)FUNC(&xbox::IoStartNextPacket),                       // 0x0051 (81)
	(uint32_t)FUNC(&xbox::IoStartNextPacketByKey),                  // 0x0052 (82)
	(uint32_t)FUNC(&xbox::IoStartPacket),                           // 0x0053 (83)
	(uint32_t)FUNC(&xbox::IoSynchronousDeviceIoControlRequest),     // 0x0054 (84)
	(uint32_t)FUNC(&xbox::IoSynchronousFsdRequest),                 // 0x0055 (85)
	(uint32_t)FUNC(&xbox::IofCallDriver),                           // 0x0056 (86)
	(uint32_t)FUNC(&xbox::IofCompleteRequest),                      // 0x0057 (87)
	(uint32_t)VARIABLE(&xbox::KdDebuggerEnabled),                   // 0x0058 (88)
	(uint32_t)VARIABLE(&xbox::KdDebuggerNotPresent),                // 0x0059 (89)
	(uint32_t)FUNC(&xbox::IoDismountVolume),                        // 0x005A (90)
	(uint32_t)FUNC(&xbox::IoDismountVolumeByName),                  // 0x005B (91)
	(uint32_t)FUNC(&xbox::KeAlertResumeThread),                     // 0x005C (92)
	(uint32_t)FUNC(&xbox::KeAlertThread),                           // 0x005D (93)
	(uint32_t)FUNC(&xbox::KeBoostPriorityThread),                   // 0x005E (94)
	(uint32_t)FUNC(&xbox::KeBugCheck),                              // 0x005F (95)
	(uint32_t)FUNC(&xbox::KeBugCheckEx),                            // 0x0060 (96)
	(uint32_t)FUNC(&xbox::KeCancelTimer),                           // 0x0061 (97)
	(uint32_t)FUNC(&xbox::KeConnectInterrupt),                      // 0x0062 (98)
	(uint32_t)FUNC(&xbox::KeDelayExecutionThread),                  // 0x0063 (99)
	(uint32_t)FUNC(&xbox::KeDisconnectInterrupt),                   // 0x0064 (100
	(uint32_t)FUNC(&xbox::KeEnterCriticalRegion),                   // 0x0065 (101)
	(uint32_t)VARIABLE(&xbox::MmGlobalData),                        // 0x0066 (102)
	(uint32_t)FUNC(&xbox::KeGetCurrentIrql),                        // 0x0067 (103)
	(uint32_t)FUNC(&xbox::KeGetCurrentThread),                      // 0x0068 (104)
	(uint32_t)FUNC(&xbox::KeInitializeApc),                         // 0x0069 (105)
	(uint32_t)FUNC(&xbox::KeInitializeDeviceQueue),                 // 0x006A (106)
	(uint32_t)FUNC(&xbox::KeInitializeDpc),                         // 0x006B (107)
	(uint32_t)FUNC(&xbox::KeInitializeEvent),                       // 0x006C (108)
	(uint32_t)FUNC(&xbox::KeInitializeInterrupt),                   // 0x006D (109)
	(uint32_t)FUNC(&xbox::KeInitializeMutant),                      // 0x006E (110)
	(uint32_t)FUNC(&xbox::KeInitializeQueue),                       // 0x006F (111)
	(uint32_t)FUNC(&xbox::KeInitializeSemaphore),                   // 0x0070 (112)
	(uint32_t)FUNC(&xbox::KeInitializeTimerEx),                     // 0x0071 (113)
	(uint32_t)FUNC(&xbox::KeInsertByKeyDeviceQueue),                // 0x0072 (114)
	(uint32_t)FUNC(&xbox::KeInsertDeviceQueue),                     // 0x0073 (115)
	(uint32_t)FUNC(&xbox::KeInsertHeadQueue),                       // 0x0074 (116)
	(uint32_t)FUNC(&xbox::KeInsertQueue),                           // 0x0075 (117)
	(uint32_t)FUNC(&xbox::KeInsertQueueApc),                        // 0x0076 (118)
	(uint32_t)FUNC(&xbox::KeInsertQueueDpc),                        // 0x0077 (119)
	(uint32_t)VARIABLE(&xbox::KeInterruptTime),                     // 0x0078 (120) KeInterruptTime
	(uint32_t)FUNC(&xbox::KeIsExecutingDpc),                        // 0x0079 (121)
	(uint32_t)FUNC(&xbox::KeLeaveCriticalRegion),                   // 0x007A (122)
	(uint32_t)FUNC(&xbox::KePulseEvent),                            // 0x007B (123)
	(uint32_t)FUNC(&xbox::KeQueryBasePriorityThread),               // 0x007C (124)
	(uint32_t)FUNC(&xbox::KeQueryInterruptTime),                    // 0x007D (125)
	(uint32_t)FUNC(&xbox::KeQueryPerformanceCounter),               // 0x007E (126)
	(uint32_t)FUNC(&xbox::KeQueryPerformanceFrequency),             // 0x007F (127)
	(uint32_t)FUNC(&xbox::KeQuerySystemTime),                       // 0x0080 (128)
	(uint32_t)FUNC(&xbox::KeRaiseIrqlToDpcLevel),                   // 0x0081 (129)
	(uint32_t)FUNC(&xbox::KeRaiseIrqlToSynchLevel),                 // 0x0082 (130)
	(uint32_t)FUNC(&xbox::KeReleaseMutant),                         // 0x0083 (131)
	(uint32_t)FUNC(&xbox::KeReleaseSemaphore),                      // 0x0084 (132)
	(uint32_t)FUNC(&xbox::KeRemoveByKeyDeviceQueue),                // 0x0085 (133)
	(uint32_t)FUNC(&xbox::KeRemoveDeviceQueue),                     // 0x0086 (134)
	(uint32_t)FUNC(&xbox::KeRemoveEntryDeviceQueue),                // 0x0087 (135)
	(uint32_t)FUNC(&xbox::KeRemoveQueue),                           // 0x0088 (136)
	(uint32_t)FUNC(&xbox::KeRemoveQueueDpc),                        // 0x0089 (137)
	(uint32_t)FUNC(&xbox::KeResetEvent),                            // 0x008A (138)
	(uint32_t)FUNC(&xbox::KeRestoreFloatingPointState),             // 0x008B (139)
	(uint32_t)FUNC(&xbox::KeResumeThread),                          // 0x008C (140)
	(uint32_t)FUNC(&xbox::KeRundownQueue),                          // 0x008D (141)
	(uint32_t)FUNC(&xbox::KeSaveFloatingPointState),                // 0x008E (142)
	(uint32_t)FUNC(&xbox::KeSetBasePriorityThread),                 // 0x008F (143)
	(uint32_t)FUNC(&xbox::KeSetDisableBoostThread),                 // 0x0090 (144)
	(uint32_t)FUNC(&xbox::KeSetEvent),                              // 0x0091 (145)
	(uint32_t)FUNC(&xbox::KeSetEventBoostPriority),                 // 0x0092 (146)
	(uint32_t)FUNC(&xbox::KeSetPriorityProcess),                    // 0x0093 (147)
	(uint32_t)FUNC(&xbox::KeSetPriorityThread),                     // 0x0094 (148)
	(uint32_t)FUNC(&xbox::KeSetTimer),                              // 0x0095 (149)
	(uint32_t)FUNC(&xbox::KeSetTimerEx),                            // 0x0096 (150)
	(uint32_t)FUNC(&xbox::KeStallExecutionProcessor),               // 0x0097 (151)
	(uint32_t)FUNC(&xbox::KeSuspendThread),                         // 0x0098 (152)
	(uint32_t)FUNC(&xbox::KeSynchronizeExecution),                  // 0x0099 (153)
	(uint32_t)VARIABLE(&xbox::KeSystemTime),                        // 0x009A (154) KeSystemTime
	(uint32_t)FUNC(&xbox::KeTestAlertThread),                       // 0x009B (155)
	(uint32_t)VARIABLE(&xbox::KeTickCount),                         // 0x009C (156)
	(uint32_t)VARIABLE(&xbox::KeTimeIncrement),                     // 0x009D (157)
	(uint32_t)FUNC(&xbox::KeWaitForMultipleObjects),                // 0x009E (158)
	(uint32_t)FUNC(&xbox::KeWaitForSingleObject),                   // 0x009F (159)
	(uint32_t)FUNC(&xbox::KfRaiseIrql),                             // 0x00A0 (160)
	(uint32_t)FUNC(&xbox::KfLowerIrql),                             // 0x00A1 (161)
	(uint32_t)VARIABLE(&xbox::KiBugCheckData),                      // 0x00A2 (162)
	(uint32_t)FUNC(&xbox::KiUnlockDispatcherDatabase),              // 0x00A3 (163)
	(uint32_t)VARIABLE(&xbox::LaunchDataPage),                      // 0x00A4 (164)
	(uint32_t)FUNC(&xbox::MmAllocateContiguousMemory),              // 0x00A5 (165)
	(uint32_t)FUNC(&xbox::MmAllocateContiguousMemoryEx),            // 0x00A6 (166)
	(uint32_t)FUNC(&xbox::MmAllocateSystemMemory),                  // 0x00A7 (167)
	(uint32_t)FUNC(&xbox::MmClaimGpuInstanceMemory),                // 0x00A8 (168)
	(uint32_t)FUNC(&xbox::MmCreateKernelStack),                     // 0x00A9 (169)
	(uint32_t)FUNC(&xbox::MmDeleteKernelStack),                     // 0x00AA (170)
	(uint32_t)FUNC(&xbox::MmFreeContiguousMemory),                  // 0x00AB (171)
	(uint32_t)FUNC(&xbox::MmFreeSystemMemory),                      // 0x00AC (172)
	(uint32_t)FUNC(&xbox::MmGetPhysicalAddress),                    // 0x00AD (173)
	(uint32_t)FUNC(&xbox::MmIsAddressValid),                        // 0x00AE (174)
	(uint32_t)FUNC(&xbox::MmLockUnlockBufferPages),                 // 0x00AF (175)
	(uint32_t)FUNC(&xbox::MmLockUnlockPhysicalPage),                // 0x00B0 (176)
	(uint32_t)FUNC(&xbox::MmMapIoSpace),                            // 0x00B1 (177)
	(uint32_t)FUNC(&xbox::MmPersistContiguousMemory),               // 0x00B2 (178)
	(uint32_t)FUNC(&xbox::MmQueryAddressProtect),                   // 0x00B3 (179)
	(uint32_t)FUNC(&xbox::MmQueryAllocationSize),                   // 0x00B4 (180)
	(uint32_t)FUNC(&xbox::MmQueryStatistics),                       // 0x00B5 (181)
	(uint32_t)FUNC(&xbox::MmSetAddressProtect),                     // 0x00B6 (182)
	(uint32_t)FUNC(&xbox::MmUnmapIoSpace),                          // 0x00B7 (183)
	(uint32_t)FUNC(&xbox::NtAllocateVirtualMemory),                 // 0x00B8 (184)
	(uint32_t)FUNC(&xbox::NtCancelTimer),                           // 0x00B9 (185)
	(uint32_t)FUNC(&xbox::NtClearEvent),                            // 0x00BA (186)
	(uint32_t)FUNC(&xbox::NtClose),                                 // 0x00BB (187)
	(uint32_t)FUNC(&xbox::NtCreateDirectoryObject),                 // 0x00BC (188)
	(uint32_t)FUNC(&xbox::NtCreateEvent),                           // 0x00BD (189)
	(uint32_t)FUNC(&xbox::NtCreateFile),                            // 0x00BE (190)
	(uint32_t)FUNC(&xbox::NtCreateIoCompletion),                    // 0x00BF (191)
	(uint32_t)FUNC(&xbox::NtCreateMutant),                          // 0x00C0 (192)
	(uint32_t)FUNC(&xbox::NtCreateSemaphore),                       // 0x00C1 (193)
	(uint32_t)FUNC(&xbox::NtCreateTimer),                           // 0x00C2 (194)
	(uint32_t)FUNC(&xbox::NtDeleteFile),                            // 0x00C3 (195)
	(uint32_t)FUNC(&xbox::NtDeviceIoControlFile),                   // 0x00C4 (196)
	(uint32_t)FUNC(&xbox::NtDuplicateObject),                       // 0x00C5 (197)
	(uint32_t)FUNC(&xbox::NtFlushBuffersFile),                      // 0x00C6 (198)
	(uint32_t)FUNC(&xbox::NtFreeVirtualMemory),                     // 0x00C7 (199)
	(uint32_t)FUNC(&xbox::NtFsControlFile),                         // 0x00C8 (200)
	(uint32_t)FUNC(&xbox::NtOpenDirectoryObject),                   // 0x00C9 (201)
	(uint32_t)FUNC(&xbox::NtOpenFile),                              // 0x00CA (202)
	(uint32_t)FUNC(&xbox::NtOpenSymbolicLinkObject),                // 0x00CB (203)
	(uint32_t)FUNC(&xbox::NtProtectVirtualMemory),                  // 0x00CC (204)
	(uint32_t)FUNC(&xbox::NtPulseEvent),                            // 0x00CD (205)
	(uint32_t)FUNC(&xbox::NtQueueApcThread),                        // 0x00CE (206)
	(uint32_t)FUNC(&xbox::NtQueryDirectoryFile),                    // 0x00CF (207)
	(uint32_t)FUNC(&xbox::NtQueryDirectoryObject),                  // 0x00D0 (208)
	(uint32_t)FUNC(&xbox::NtQueryEvent),                            // 0x00D1 (209)
	(uint32_t)FUNC(&xbox::NtQueryFullAttributesFile),               // 0x00D2 (210)
	(uint32_t)FUNC(&xbox::NtQueryInformationFile),                  // 0x00D3 (211)
	(uint32_t)FUNC(&xbox::NtQueryIoCompletion),                     // 0x00D4 (212)
	(uint32_t)FUNC(&xbox::NtQueryMutant),                           // 0x00D5 (213)
	(uint32_t)FUNC(&xbox::NtQuerySemaphore),                        // 0x00D6 (214)
	(uint32_t)FUNC(&xbox::NtQuerySymbolicLinkObject),               // 0x00D7 (215)
	(uint32_t)FUNC(&xbox::NtQueryTimer),                            // 0x00D8 (216)
	(uint32_t)FUNC(&xbox::NtQueryVirtualMemory),                    // 0x00D9 (217)
	(uint32_t)FUNC(&xbox::NtQueryVolumeInformationFile),            // 0x00DA (218)
	(uint32_t)FUNC(&xbox::NtReadFile),                              // 0x00DB (219)
	(uint32_t)FUNC(&xbox::NtReadFileScatter),                       // 0x00DC (220)
	(uint32_t)FUNC(&xbox::NtReleaseMutant),                         // 0x00DD (221)
	(uint32_t)FUNC(&xbox::NtReleaseSemaphore),                      // 0x00DE (222)
	(uint32_t)FUNC(&xbox::NtRemoveIoCompletion),                    // 0x00DF (223)
	(uint32_t)FUNC(&xbox::NtResumeThread),                          // 0x00E0 (224)
	(uint32_t)FUNC(&xbox::NtSetEvent),                              // 0x00E1 (225)
	(uint32_t)FUNC(&xbox::NtSetInformationFile),                    // 0x00E2 (226)
	(uint32_t)FUNC(&xbox::NtSetIoCompletion),                       // 0x00E3 (227)
	(uint32_t)FUNC(&xbox::NtSetSystemTime),                         // 0x00E4 (228)
	(uint32_t)FUNC(&xbox::NtSetTimerEx),                            // 0x00E5 (229)
	(uint32_t)FUNC(&xbox::NtSignalAndWaitForSingleObjectEx),        // 0x00E6 (230)
	(uint32_t)FUNC(&xbox::NtSuspendThread),                         // 0x00E7 (231)
	(uint32_t)FUNC(&xbox::NtUserIoApcDispatcher),                   // 0x00E8 (232)
	(uint32_t)FUNC(&xbox::NtWaitForSingleObject),                   // 0x00E9 (233)
	(uint32_t)FUNC(&xbox::NtWaitForSingleObjectEx),                 // 0x00EA (234)
	(uint32_t)FUNC(&xbox::NtWaitForMultipleObjectsEx),              // 0x00EB (235)
	(uint32_t)FUNC(&xbox::NtWriteFile),                             // 0x00EC (236)
	(uint32_t)FUNC(&xbox::NtWriteFileGather),                       // 0x00ED (237)
	(uint32_t)FUNC(&xbox::NtYieldExecution),                        // 0x00EE (238)
	(uint32_t)FUNC(&xbox::ObCreateObject),                          // 0x00EF (239)
	(uint32_t)VARIABLE(&xbox::ObDirectoryObjectType),               // 0x00F0 (240)
	(uint32_t)FUNC(&xbox::ObInsertObject),                          // 0x00F1 (241)
	(uint32_t)FUNC(&xbox::ObMakeTemporaryObject),                   // 0x00F2 (242) 
	(uint32_t)FUNC(&xbox::ObOpenObjectByName),                      // 0x00F3 (243)
	(uint32_t)FUNC(&xbox::ObOpenObjectByPointer),                   // 0x00F4 (244)
	(uint32_t)VARIABLE(&xbox::ObpObjectHandleTable),                // 0x00F5 (245)
	(uint32_t)FUNC(&xbox::ObReferenceObjectByHandle),               // 0x00F6 (246)
	(uint32_t)FUNC(&xbox::ObReferenceObjectByName),                 // 0x00F7 (247)
	(uint32_t)FUNC(&xbox::ObReferenceObjectByPointer),              // 0x00F8 (248)
	(uint32_t)VARIABLE(&xbox::ObSymbolicLinkObjectType),            // 0x00F9 (249)
	(uint32_t)FUNC(&xbox::ObfDereferenceObject),                    // 0x00FA (250)
	(uint32_t)FUNC(&xbox::ObfReferenceObject),                      // 0x00FB (251)
	(uint32_t)FUNC(&xbox::PhyGetLinkState),                         // 0x00FC (252)
	(uint32_t)FUNC(&xbox::PhyInitialize),                           // 0x00FD (253)
	(uint32_t)FUNC(&xbox::PsCreateSystemThread),                    // 0x00FE (254)
	(uint32_t)FUNC(&xbox::PsCreateSystemThreadEx),                  // 0x00FF (255)
	(uint32_t)FUNC(&xbox::PsQueryStatistics),                       // 0x0100 (256)
	(uint32_t)FUNC(&xbox::PsSetCreateThreadNotifyRoutine),          // 0x0101 (257)
	(uint32_t)FUNC(&xbox::PsTerminateSystemThread),                 // 0x0102 (258)
	(uint32_t)VARIABLE(&xbox::PsThreadObjectType),                  // 0x0103 (259)
	(uint32_t)FUNC(&xbox::RtlAnsiStringToUnicodeString),            // 0x0104 (260)
	(uint32_t)FUNC(&xbox::RtlAppendStringToString),                 // 0x0105 (261)
	(uint32_t)FUNC(&xbox::RtlAppendUnicodeStringToString),          // 0x0106 (262)
	(uint32_t)FUNC(&xbox::RtlAppendUnicodeToString),                // 0x0107 (263)
	(uint32_t)FUNC(&xbox::RtlAssert),                               // 0x0108 (264)
	(uint32_t)FUNC(&xbox::RtlCaptureContext),                       // 0x0109 (265)
	(uint32_t)FUNC(&xbox::RtlCaptureStackBackTrace),                // 0x010A (266)
	(uint32_t)FUNC(&xbox::RtlCharToInteger),                        // 0x010B (267)
	(uint32_t)FUNC(&xbox::RtlCompareMemory),                        // 0x010C (268)
	(uint32_t)FUNC(&xbox::RtlCompareMemoryUlong),                   // 0x010D (269)
	(uint32_t)FUNC(&xbox::RtlCompareString),                        // 0x010E (270)
	(uint32_t)FUNC(&xbox::RtlCompareUnicodeString),                 // 0x010F (271)
	(uint32_t)FUNC(&xbox::RtlCopyString),                           // 0x0110 (272)
	(uint32_t)FUNC(&xbox::RtlCopyUnicodeString),                    // 0x0111 (273)
	(uint32_t)FUNC(&xbox::RtlCreateUnicodeString),                  // 0x0112 (274)
	(uint32_t)FUNC(&xbox::RtlDowncaseUnicodeChar),                  // 0x0113 (275)
	(uint32_t)FUNC(&xbox::RtlDowncaseUnicodeString),                // 0x0114 (276)
	(uint32_t)FUNC(&xbox::RtlEnterCriticalSection),                 // 0x0115 (277)
	(uint32_t)FUNC(&xbox::RtlEnterCriticalSectionAndRegion),        // 0x0116 (278)
	(uint32_t)FUNC(&xbox::RtlEqualString),                          // 0x0117 (279)
	(uint32_t)FUNC(&xbox::RtlEqualUnicodeString),                   // 0x0118 (280)
	(uint32_t)FUNC(&xbox::RtlExtendedIntegerMultiply),              // 0x0119 (281)
	(uint32_t)FUNC(&xbox::RtlExtendedLargeIntegerDivide),           // 0x011A (282)
	(uint32_t)FUNC(&xbox::RtlExtendedMagicDivide),                  // 0x011B (283)
	(uint32_t)FUNC(&xbox::RtlFillMemory),                           // 0x011C (284)
	(uint32_t)FUNC(&xbox::RtlFillMemoryUlong),                      // 0x011D (285)
	(uint32_t)FUNC(&xbox::RtlFreeAnsiString),                       // 0x011E (286)
	(uint32_t)FUNC(&xbox::RtlFreeUnicodeString),                    // 0x011F (287)
	(uint32_t)FUNC(&xbox::RtlGetCallersAddress),                    // 0x0120 (288)
	(uint32_t)FUNC(&xbox::RtlInitAnsiString),                       // 0x0121 (289)
	(uint32_t)FUNC(&xbox::RtlInitUnicodeString),                    // 0x0122 (290)
	(uint32_t)FUNC(&xbox::RtlInitializeCriticalSection),            // 0x0123 (291)
	(uint32_t)FUNC(&xbox::RtlIntegerToChar),                        // 0x0124 (292)
	(uint32_t)FUNC(&xbox::RtlIntegerToUnicodeString),               // 0x0125 (293)
	(uint32_t)FUNC(&xbox::RtlLeaveCriticalSection),                 // 0x0126 (294)
	(uint32_t)FUNC(&xbox::RtlLeaveCriticalSectionAndRegion),        // 0x0127 (295)
	(uint32_t)FUNC(&xbox::RtlLowerChar),                            // 0x0128 (296)
	(uint32_t)FUNC(&xbox::RtlMapGenericMask),                       // 0x0129 (297)
	(uint32_t)FUNC(&xbox::RtlMoveMemory),                           // 0x012A (298)
	(uint32_t)FUNC(&xbox::RtlMultiByteToUnicodeN),                  // 0x012B (299)
	(uint32_t)FUNC(&xbox::RtlMultiByteToUnicodeSize),               // 0x012C (300)
	(uint32_t)FUNC(&xbox::RtlNtStatusToDosError),                   // 0x012D (301)
	(uint32_t)FUNC(&xbox::RtlRaiseException),                       // 0x012E (302)
	(uint32_t)FUNC(&xbox::RtlRaiseStatus),                          // 0x012F (303)
	(uint32_t)FUNC(&xbox::RtlTimeFieldsToTime),                     // 0x0130 (304)
	(uint32_t)FUNC(&xbox::RtlTimeToTimeFields),                     // 0x0131 (305)
	(uint32_t)FUNC(&xbox::RtlTryEnterCriticalSection),              // 0x0132 (306)
	(uint32_t)FUNC(&xbox::RtlUlongByteSwap),                        // 0x0133 (307)
	(uint32_t)FUNC(&xbox::RtlUnicodeStringToAnsiString),            // 0x0134 (308)
	(uint32_t)FUNC(&xbox::RtlUnicodeStringToInteger),               // 0x0135 (309)
	(uint32_t)FUNC(&xbox::RtlUnicodeToMultiByteN),                  // 0x0136 (310)
	(uint32_t)FUNC(&xbox::RtlUnicodeToMultiByteSize),               // 0x0137 (311)
	(uint32_t)FUNC(&xbox::RtlUnwind),                               // 0x0138 (312)
	(uint32_t)FUNC(&xbox::RtlUpcaseUnicodeChar),                    // 0x0139 (313)
	(uint32_t)FUNC(&xbox::RtlUpcaseUnicodeString),                  // 0x013A (314)
	(uint32_t)FUNC(&xbox::RtlUpcaseUnicodeToMultiByteN),            // 0x013B (315)
	(uint32_t)FUNC(&xbox::RtlUpperChar),                            // 0x013C (316)
	(uint32_t)FUNC(&xbox::RtlUpperString),                          // 0x013D (317)
	(uint32_t)FUNC(&xbox::RtlUshortByteSwap),                       // 0x013E (318)
	(uint32_t)FUNC(&xbox::RtlWalkFrameChain),                       // 0x013F (319)
	(uint32_t)FUNC(&xbox::RtlZeroMemory),                           // 0x0140 (320)
	(uint32_t)VARIABLE(&xbox::XboxEEPROMKey),                       // 0x0141 (321)
	(uint32_t)VARIABLE(&xbox::XboxHardwareInfo),                    // 0x0142 (322)
	(uint32_t)VARIABLE(&xbox::XboxHDKey),                           // 0x0143 (323)
	(uint32_t)VARIABLE(&xbox::XboxKrnlVersion),                     // 0x0144 (324)
	(uint32_t)VARIABLE(&xbox::XboxSignatureKey),                    // 0x0145 (325)
	(uint32_t)VARIABLE(&xbox::XeImageFileName),                     // 0x0146 (326)
	(uint32_t)FUNC(&xbox::XeLoadSection),                           // 0x0147 (327)
	(uint32_t)FUNC(&xbox::XeUnloadSection),                         // 0x0148 (328)
	(uint32_t)FUNC(&xbox::READ_PORT_BUFFER_UCHAR),                  // 0x0149 (329)
	(uint32_t)FUNC(&xbox::READ_PORT_BUFFER_USHORT),                 // 0x014A (330)
	(uint32_t)FUNC(&xbox::READ_PORT_BUFFER_ULONG),                  // 0x014B (331)
	(uint32_t)FUNC(&xbox::WRITE_PORT_BUFFER_UCHAR),                 // 0x014C (332)
	(uint32_t)FUNC(&xbox::WRITE_PORT_BUFFER_USHORT),                // 0x014D (333)
	(uint32_t)FUNC(&xbox::WRITE_PORT_BUFFER_ULONG),                 // 0x014E (334)
	(uint32_t)FUNC(&xbox::XcSHAInit),                               // 0x014F (335)
	(uint32_t)FUNC(&xbox::XcSHAUpdate),                             // 0x0150 (336)
	(uint32_t)FUNC(&xbox::XcSHAFinal),                              // 0x0151 (337)
	(uint32_t)FUNC(&xbox::XcRC4Key),                                // 0x0152 (338)
	(uint32_t)FUNC(&xbox::XcRC4Crypt),                              // 0x0153 (339)
	(uint32_t)FUNC(&xbox::XcHMAC),                                  // 0x0154 (340)
	(uint32_t)FUNC(&xbox::XcPKEncPublic),                           // 0x0155 (341)
	(uint32_t)FUNC(&xbox::XcPKDecPrivate),                          // 0x0156 (342)
	(uint32_t)FUNC(&xbox::XcPKGetKeyLen),                           // 0x0157 (343)
	(uint32_t)FUNC(&xbox::XcVerifyPKCS1Signature),                  // 0x0158 (344)
	(uint32_t)FUNC(&xbox::XcModExp),                                // 0x0159 (345)
	(uint32_t)FUNC(&xbox::XcDESKeyParity),                          // 0x015A (346)
	(uint32_t)FUNC(&xbox::XcKeyTable),                              // 0x015B (347)
	(uint32_t)FUNC(&xbox::XcBlockCrypt),                            // 0x015C (348)
	(uint32_t)FUNC(&xbox::XcBlockCryptCBC),                         // 0x015D (349)
	(uint32_t)FUNC(&xbox::XcCryptService),                          // 0x015E (350)
	(uint32_t)FUNC(&xbox::XcUpdateCrypto),                          // 0x015F (351)
	(uint32_t)FUNC(&xbox::RtlRip),                                  // 0x0160 (352)
	(uint32_t)VARIABLE(&xbox::XboxLANKey),                          // 0x0161 (353)
	(uint32_t)VARIABLE(&xbox::XboxAlternateSignatureKeys),          // 0x0162 (354)
	(uint32_t)VARIABLE(&xbox::XePublicKeyData),                     // 0x0163 (355)
	(uint32_t)VARIABLE(&xbox::HalBootSMCVideoMode),                 // 0x0164 (356)
	(uint32_t)VARIABLE(&xbox::IdexChannelObject),                   // 0x0165 (357)
	(uint32_t)FUNC(&xbox::HalIsResetOrShutdownPending),             // 0x0166 (358)
	(uint32_t)FUNC(&xbox::IoMarkIrpMustComplete),                   // 0x0167 (359)
	(uint32_t)FUNC(&xbox::HalInitiateShutdown),                     // 0x0168 (360)
	(uint32_t)FUNC(&xbox::RtlSnprintf),                             // 0x0169 (361)
	(uint32_t)FUNC(&xbox::RtlSprintf),                              // 0x016A (362)
	(uint32_t)FUNC(&xbox::RtlVsnprintf),                            // 0x016B (363) 
	(uint32_t)FUNC(&xbox::RtlVsprintf),                             // 0x016C (364)
	(uint32_t)FUNC(&xbox::HalEnableSecureTrayEject),                // 0x016D (365)
	(uint32_t)FUNC(&xbox::HalWriteSMCScratchRegister),              // 0x016E (366)
	(uint32_t)FUNC(&xbox::UnknownAPI367),                           // 0x016F (367)
	(uint32_t)FUNC(&xbox::UnknownAPI368),                           // 0x0170 (368)
	(uint32_t)FUNC(&xbox::UnknownAPI369),                           // 0x0171 (369)
	(uint32_t)FUNC(&xbox::XProfpControl),                           // 0x0172 (370) PROFILING
	(uint32_t)FUNC(&xbox::XProfpGetData),                           // 0x0173 (371) PROFILING
	(uint32_t)FUNC(&xbox::IrtClientInitFast),                       // 0x0174 (372) PROFILING
	(uint32_t)FUNC(&xbox::IrtSweep),                                // 0x0175 (373) PROFILING
	(uint32_t)FUNC(&xbox::MmDbgAllocateMemory),                     // 0x0176 (374) DEVKIT ONLY!
	(uint32_t)FUNC(&xbox::MmDbgFreeMemory),                         // 0x0177 (375) DEVKIT ONLY!
	(uint32_t)FUNC(&xbox::MmDbgQueryAvailablePages),                // 0x0178 (376) DEVKIT ONLY!
	(uint32_t)FUNC(&xbox::MmDbgReleaseAddress),                     // 0x0179 (377) DEVKIT ONLY!
	(uint32_t)FUNC(&xbox::MmDbgWriteCheck),                         // 0x017A (378) DEVKIT ONLY!
};
