# Awesome Google Gemini AI

Gemini AI is Google’s latest LLM (large language model) that excels in power and capability compared to its predecessor. It is designed for multimodality, seamlessly reasoning across text, images, video, audio, and code. Gemini is the first model to outperform human experts on MMLU (Massive Multitask Language Understanding), a widely-used method assessing the knowledge and problem-solving abilities of AI models.

Gemini AI is available in three variants—Nano, Pro, and Ultra—tailored to meet diverse user needs. Nano is designed for swift on-device tasks, while Pro serves as the versatile middle tier. The Ultra variant, the most powerful among the three, is set to be released next year after undergoing safety checks.

Note: as Google Gemini AI is still in its early stages, the awesome list will be updated regularly to include new resources.

## Table of Contents

- [GitHub projects](#github-projects)
- [Articles & Blogs](#articles-&-blogs)
- [Online Courses](#online-courses)
- [Books](#books)
- [Research Papers](#research-papers)
- [Videos](#videos)
- [Tools & Software](#tools-&-software)
- [Conferences & Events](#conferences-&-events)
- [Slides & Presentations](#slides-&-presentations)
- [Podcasts](#podcasts)

## GitHub projects

- [LibreChat](https://github.com/danny-avila/LibreChat): Enhanced ChatGPT Clone with various features including OpenAI, Assistants API, Azure, GPT-4 Vision, and Google Gemini. It is open-source for self-hosting. ⭐️⭐️⭐️⭐️⭐️
- [casibase](https://github.com/casibase/casibase): Open-source AI knowledge database with web UI and Enterprise SSO supporting OpenAI, Azure, LLaMA, Google Gemini, HuggingFace, Claude, Grok, and more. Check out the [demo chat bot](https://demo.casibase.com) and [admin UI](https://demo-admin.casibase.com). ⭐️⭐️⭐️
- [generative-ai-python](https://github.com/google/generative-ai-python): The Google AI Python SDK enables developers to use Google's generative AI models like Gemini and PaLM to build AI-powered features and applications. ⭐️⭐️⭐️
- [chatnio](https://github.com/Deeptrain-Community/chatnio): Powerful AI chat aggregation platform supporting various models including OpenAI, Claude, Google Gemini (PaLM2), and more. Offers features like distributed streaming, image generation, multi-device sync, and more. ⭐️⭐️
- [GPT-Telegramus](https://github.com/F33RNI/GPT-Telegramus): The best free Telegram bot for ChatGPT, DALL-E, Bing AI (EdgeGPT), Bing Image generator, Bard, and Gemini. Supports multiple languages, image requests, admin control, and more. ⭐️
- [gemini-android](https://github.com/skydoves/gemini-android): Gemini Android demonstrates Google's Generative AI on Android using the Stream Chat SDK for Compose. ⭐️
- [ChaKt-KMP](https://github.com/PatilShreyas/ChaKt-KMP): Multiplatform chat-prompt based app for Android, iOS, Desktop, and Web. Powered by Google's Gemini AI API and Generative AI Multiplatform SDK. ⭐️
- [gemini-ai](https://github.com/EvanZhouDev/gemini-ai): The easiest way to use the powerful Google Gemini model. ⭐️
- [letmedoit](https://github.com/eliranwong/letmedoit): An advanced AI assistant leveraging ChatGPT API, Gemini Pro, and AutoGen. It can engage in conversations and execute computing tasks locally. ⭐️
- [gemini-api-php/client](https://github.com/gemini-api-php/client): Google Gemini API PHP Client allows you to use the Gemini AI model. ⭐️
- [Ruby Implementation of Nano Bots](https://github.com/icebaker/ruby-nano-bots): Small, AI-powered bots that support multiple providers including Google Gemini.
- [Gemini AI Ruby Gem](https://github.com/gbaptista/gemini-ai): Ruby Gem for interacting with Gemini through Vertex AI and Google's generative AI services.
- [Gemini implemented with GPT-4 Vision](https://github.com/ZohaibAhmed/real-gemini): Implementation of Google's Gemini using GPT-4 Vision, Whisper, and Resemble AI.
- [Gemini2tg](https://github.com/zhuchangyi/Gemini2tg): Deploy Google Gemini's API to a Telegram bot, creating your own AI bot powered by Gemini.
- [Dennx](https://github.com/sinnedpenguin/dennx): An AI chatbot powered by Google's Gemini Pro model.
- [Gemini PHP Library](https://github.com/rpurinton/gemini-php): A PHP library for interacting with Google Gemini AI.
- [MultiPDFs Chat AI App](https://github.com/GURPREETKAURJETHRA/Multi-PDFs_ChatApp_AI-Agent): Chat seamlessly with multiple PDFs using Langchain, Google Gemini Pro, and FAISS Vector DB for accurate responses.
- [Google Gemini UI](https://github.com/fjosue4/google-gemini-ui): Basic UI to chat with Google Gemini AI.
- [IntelliChat](https://github.com/intelligentnode/IntelliChat): Modern AI chatbot supporting multiple language models, including Google Gemini and ChatGPT.

## Articles & Blogs

- [Getting Started with Gemini AI API via Google Cloud Code](https://medium.com/google-cloud/getting-started-with-gemini-ai-api-via-google-cloud-code-application-templates-098cdb84c3d1) : This tutorial provides step-by-step instructions on how to test out the Gemini AI API using Google Cloud Code.
- [Creating a Custom Function in Google Sheets to ask Gemini Pro](https://medium.com/@larry_nguyen/creating-a-custom-function-in-google-sheets-to-ask-gemini-pro-0f441fab3679) : Learn how to create a custom function in Google Sheets to interact with Gemini Pro AI.
- [Exploring Google's Gemini AI: A Hands-On Guide to Leveraging the Latest Large Language Model](https://medium.com/@kagglepro.llc/exploring-googles-gemini-ai-a-hands-on-guide-to-leveraging-the-latest-large-language-model-b0379ce8df62) : Dive into the capabilities of Gemini, Google's advanced AI model with multimodal capabilities.
- [Gemini AI: The Dawn of Multimodal Superintelligence](https://medium.com/google-cloud/gemini-ai-the-dawn-of-multimodal-superintelligence-263a28588d04) : Discover the release of Gemini AI and its availability in Google AI Studio.
- [Google Gemini Pro AI Integration With React (Vite) Tutorial In Just 5 Min](https://medium.com/@ldudaraliyanage/google-gemini-pro-ai-integration-with-react-vite-tutorial-in-just-5-min-90ba0c377723) : A quick tutorial on integrating Gemini Pro AI with React using Vite.
- [Google's Gemini AI is a lesson for storytelling in healthcare](https://medium.com/@psethmd/googles-gemini-ai-is-a-lesson-for-storytelling-in-healthcare-74e886e2bda0) : Explore how Google's Gemini AI is shaping storytelling in the healthcare industry.
- [Multi-turn Chat with Gemini AI on iOS (SwiftUI Tutorial)](https://medium.com/google-cloud/multi-turn-chat-with-gemini-ai-on-ios-swiftui-tutorial-1ba3a760be88) : Learn how to build multi-turn conversations using Gemini AI on iOS.
- [Google Gemini: all the details on the AI model Google hopes can](https://medium.com/@chamoddilshan9/did-you-create-your-google-gemini-account-24d7820d90ee) : Get all the details on Google Gemini AI and its availability for developers and enterprise customers.
- [Google launches Gemini… but again, fails to impress anyone](https://medium.com/enrique-dans/google-launches-gemini-but-again-fails-to-impress-anyone-a5a9bf7dd73d) : Explore the launch of Google Gemini AI and its initial reception.
- [Meet Gemini: Google's Largest and Most Powerful AI Model](https://towardsdatascience.com/meet-gemini-googles-largest-and-most-powerful-ai-model-2ffd2f07490f) : Discover the capabilities of Gemini, Google's largest and most powerful AI model.
- [Google launches Gemini… but again, fails to impress anyone](https://medium.com/enrique-dans/google-launches-gemini-but-again-fails-to-impress-anyone-a5a9bf7dd73d) 💫: Amid much fanfare, Google has announced the launch of Gemini, its answer to ChatGPT, describing it as its most ambitious large language model.
- [Meet Gemini: Google's Largest and Most Powerful AI Model](https://towardsdatascience.com/meet-gemini-googles-largest-and-most-powerful-ai-model-2ffd2f07490f) 🚀: This next-gen AI model outperformed ChatGPT on almost all academic benchmarks, and this article provides a guide to learn more about chain-of-thought prompting in Gemini Pro.
- [Here's Why I Still Don't Buy the Hype of Google Gemini](https://medium.com/artificial-corner/heres-why-i-still-don-t-buy-the-hype-of-google-gemini-16ed78293975) ❓: Gemini might not be as good as it seems to be, according to this critical analysis of Google's most powerful AI model.
- [A Piscean's take on Gemini. Building a quick multimodal…](https://medium.com/google-cloud/a-pisceans-take-on-gemini-b9681a0fa04d) 💡: This article discusses building a quick multimodal recommendation app with Gemini AI and shares insights from a Piscean's perspective.
- [First Hands-On With Google's New Gemini Ultra](https://medium.com/the-generator/first-hands-on-with-googles-new-gemini-ultra-3e62eccf8ab1) 👐: Yesterday, Google released Gemini Ultra, the company's most powerful chatbot, and this article provides a hands-on exploration and comparison to ChatGPT and GPT-4.
- [Get Started with Gemini in Java](https://medium.com/google-cloud/get-started-with-gemini-in-java-923f2069ea4d) 🖥️: This article guides you through getting started with using Gemini, Google's latest and more powerful Large Language Model, in Java.
- [From Google Gemini to OpenAI Q*(Q-Star): A Survey of Reshaping](https://arxiv.org/abs/2312.10868) 📚: This survey delves into the evolving landscape of generative Artificial Intelligence (AI), including innovations like Google's Gemini and the anticipated OpenAI Q* project, exploring their impact on research priorities and applications across various domains.
- [Gemini: The Power of the Most Capable AI Model by Google](https://medium.com/@pankaj_pandey/gemini-the-power-of-the-most-capable-ai-model-by-google-ff72ddc66c2d) ⚡: The world of artificial intelligence has taken a monumental leap forward with the introduction of Gemini, Google DeepMind's most advanced AI model.
- [Is Google's Gemini AI Good for Blogging? (Tested)](https://medium.com/swlh/tested-is-googles-gemini-ai-good-for-blogging-honest-review-f7184aca83de) ✍️: This article explores the use of Google's Gemini AI for blogging, covering the clean and intuitive user interface and the option to choose from different Gemini versions.
- [Time To Cancel My ChatGPT Plus Account in Favour of Gemini](https://medium.com/@dlaytonj2/time-to-cancel-my-chatgpt-plus-account-in-favour-of-gemini-0f731bff8c6b) ⏱️: Considering the seamless integration with the Google ecosystem, this article contemplates canceling a ChatGPT Plus account in favor of Gemini AI.

## Online Courses

- [Google Gemini AI Masterclass: The Ultimate Guide NEW 2024](https://www.udemy.com/course/google-gemini-ai-masterclass/): Develop skills to customize, build, and scale generative AI applications using Gemini Pro. This course covers everything from basic to advanced generative artificial intelligence on Google Gemini.
- [Gemini AI: The Complete Guide with Bard | Udemy](https://www.udemy.com/course/google-gemini-ai-the-complete-guide-with-bard/): Unlocking Google Gemini AI with Bard. Gain expertise in text generation, practical use cases, and advanced image analysis.
- [Social Media Growth: Use ChatGPT & Google Gemini AI in 2024](https://www.udemy.com/course/social-media-chatgpt-gemini-ai/): Harness Canva AI tools to incorporate artificial intelligence into design processes. Unleash the Power of Gemini AI and ChatGPT to elevate social media on platforms like Instagram, Facebook, TikTok, YouTube, and more.
- [Unlocking the Potential of Google DeepMind Gemini | Udemy](https://www.udemy.com/course/unlocking-the-potential-of-google-deepmind-gemini/): Explore Gemini in Google AI Studio, Gemini in Bard, and Google VideoPoet to unlock the potential of Google DeepMind Gemini.
- [Google Gemini for WorkSpaces: Use Gemini AI in Google Suite](https://www.udemy.com/course/google-duet-use-ai-in-google-suite/): Learn how to use Google Duet in Slides and unlock the potential of Gemini AI in Gmail, Slides, Docs, and Sheets.
- [Google Bard AI: From Beginner To Expert with Bard & Gemini | Udemy](https://www.udemy.com/course/google-bard-ai-from-beginner-to-expert-with-google-bard/): Learn Google Bard AI and Gemini to enhance productivity and workflow, saving time with Google Bard and Gemini.
- [The Complete Guide To Google Gemini (With Gemini Ultra!) | Udemy](https://www.udemy.com/course/google-generative-ai/): Learn to use Gemini Ultra, Gemini Pro, Gemini Vision, Google AI Studio, Vertex AI, and more. Develop with AI for FREE!
- [Free Tutorial - Master Gemini AI - Google Bard Prompt Engineering](https://www.udemy.com/course/master-gemini-ai-google-bard-prompt-engineering-bootcamp/): Learn the power of Google's Gemini Models with Bard and acquire the latest skills in AI.
- [AI Software Testing with Google Gemini | Udemy](https://www.udemy.com/course/generative-ai-google-bard-for-software-engineers/): Hands-on material on leveraging the power of Google Gemini in everyday life for software testers.
- [Generative AI ChatGPT | Google Gemini for Software Engineers](https://www.udemy.com/course/testing-quality-engineering-gen-ai-examples-gpt-bard/): Understand how software engineers can leverage generative AI with practical examples and future use cases.
- [Master 3 AI Chatbots in 1 Course: ChatGPT, Gemini, Bing Chat ...](https://www.udemy.com/course/learn-ai-chatbots-chatgpt-google-bard-bing-chat-edge-image-creator/): Welcome to the ultimate AI chatbot course, where you'll master not just one but three powerful AI tools: ChatGPT, Google Bard/Gemini, and 5 Powerful AI Tools 10x Your Productivity.
- [Learn Google Bard and Gemini | Udemy](https://www.udemy.com/course/google-bard-lamda-language-model-for-dialogue-application/): This course is perfect for anyone who wants to learn how to use Google Bard to generate creative content, translate.
- [Social Media Joyride with ChatGPT & Google Gemini AI (Bard ...](https://www.udemy.com/course/social-media-chatgpt-bard-gemini-ai/): This course will transform social media from a chore into a delightful adventure. Say goodbye to the traditional methods and learn how to leverage ChatGPT and Gemini AI for Social Media Marketing.
- [Generative AI and ChatGPT Masterclass for Software Engineers ...](https://www.udemy.com/course/chatgpt-generative-ai-for-software-professionals/): Master ChatGPT, Gemini, Bard, and Gen AI through hands-on training and real-world projects. Build apps with hands-on coding.
- [The Ultimate Guide - Google Bard AI | Udemy](https://www.udemy.com/course/google-bard-the-ultimate-guide-master-generative-ai/): Learn everything about Google Bard, including how to get started and what it can do. Use Google Bard AI to generate text, write emails, blog posts, resume, cover letter, and creative content.
- [Master Google's Gemini API with Python | Udemy](https://www.udemy.com/course/google-gemini-pro-vision-api-with-python/): Prepare to master Google's Gemini Pro Vision API with Python and unleash the power of Google's most capable AI family into your applications.

## Books

- [Google's AI Software Gemini: Unlocking the Potential...](https://www.amazon.com/Googles-Software-Gemini-Unlocking-Potential/dp/B0CKJGY294) 📚: A comprehensive guide to Google's Gemini AI software design, exploring its potential, evolution, and ethical considerations.
- [Google Gemini AI Comprehensive Guide: The Rise of...](https://www.amazon.com/Google-Gemini-AI-Comprehensive-Guide-ebook/dp/B0CPW5L2Z5) 📚: Unleash the power of Google's most advanced AI model and discover how it is transforming the world.
- [Getting Started with Gemini AI | 2 mins | Packt](https://www.packtpub.com/article-hub/getting-started-with-gemini-ai) 📚: Dive into the future of AI with Gemini AI, Google DeepMind's next-gen language model, and explore its capabilities.
- [Google's Gemini: Revolutionizing AI with Multimodal Capabilities...](https://www.amazon.com/Googles-Gemini-Revolutionizing-Capabilities-Transformative/dp/B0CPSXQCS5) 📚: An in-depth analysis of Google's Gemini AI and its revolutionary advancements in artificial intelligence.
- [The Gemini Effect: Google's AI Masterpiece: Discovering the Secrets...](https://www.amazon.com/Gemini-Effect-Masterpiece-Discovering-Advanced/dp/B0CPXPYSGP) 📚: Explore the secrets behind Google's most advanced AI model, the Gemini Effect.
- [AI Unraveled: Master Generative AI, LLMs, GPT...](https://www.amazon.com/Unraveled-Demystifying-Frequently-Artificial-Intelligence-ebook/dp/B0BVYJZH36) 📚: Demystify artificial intelligence, including generative AI, LLMs, GPT, Gemini, and prompt engineering.
- [AI Unraveled: Demystifying Frequently Asked Questions on Artificial...](https://www.amazon.com/Unraveled-Demystifying-Frequently-Artificial-Intelligence/dp/B0BVSXDHQR) 📚: Get answers to frequently asked questions about artificial intelligence.
- [AI_Distilled 37: Cutting-Edge Updates and Expert Guidance | 7 mins](https://www.packtpub.com/article-hub/ai-distilled-37-cutting-edge-updates-and-expert-guidance) 📚: Stay on top of the latest AI innovations and gain expert guidance through the AI_Distilled newsletter.
- [Pivot Podcast | Listen on Amazon Music](https://music.amazon.com/podcasts/c3c61629-4da5-467a-969b-ac4bebab0144/pivot): Every Tuesday and Friday, tech journalist Kara Swisher and NYU Professor Scott Galloway offer sharp, unfiltered insights into the biggest stories in tech.
- [Hands-On Large Language Models](https://www.oreilly.com/library/view/hands-on-large-language/9781098150952/): Explores AI's new language capabilities driven by rapid advances in deep learning and language AI systems.
- [The AI Whisperer's Code](https://www.amazon.com/AI-Whisperers-Code-Achieving-Unbelievable-ebook/dp/B0BXGH51NY): A book introducing the proven method for achieving unbelievable results using Chat GPT and AI.

## Research Papers

- [From Google Gemini to OpenAI Q*(Q-Star): A Survey of Reshaping...](https://arxiv.org/abs/2312.10868) 📑: This comprehensive survey explores the evolving landscape of generative Artificial Intelligence (AI), focusing on the transformative impacts of Mixture of Experts (MoE), multimodal learning, and advancements towards Artificial General Intelligence (AGI). It critically examines the current state and future trajectory of generative AI, including the role of Google's Gemini and the anticipated OpenAI Q* project.
- [Gemini: A Family of Highly Capable Multimodal Models](https://arxiv.org/abs/2312.11805) 📑: Introducing the Gemini family of multimodal models, which excel in image, audio, video, and text understanding. The Gemini Ultra model achieves human-expert performance, surpassing the state of the art in 30 of 32 benchmarks for multimodal tasks. The report discusses the potential use cases and responsible deployment of Gemini models.
- [Google DeepMind's Gemini AI versus ChatGPT: a comparative analysis in ophthalmology](https://www.researchgate.net/publication/378224975_Google_DeepMind's_gemini_AI_versus_ChatGPT_a_comparative_analysis_in_ophthalmology/fulltext/65ce25d1e51f606f99731644/Google-DeepMinds-gemini-AI-versus-ChatGPT-a-comparative-analysis-in-ophthalmology.pdf) 📑: A comparative analysis of Gemini AI and ChatGPT, highlighting Gemini's native multimodal capabilities and its potential to process and learn from various data types.
- [From Google Gemini to OpenAI Q* (Q-Star): A Survey of Reshaping...](https://arxiv.org/pdf/2312.10868) 📑: Another comprehensive survey that explores the evolving landscape of generative AI with a specific focus on the transformative impacts of Gemini and OpenAI Q* projects.
- [An In-depth Look at Gemini's Language Abilities](https://arxiv.org/abs/2312.11444) 📑: This paper provides an in-depth exploration of Gemini's language abilities, comparing them with the OpenAI GPT series across various language tasks. It reports the performance of Gemini Pro and showcases areas where it excels.
- [From Google Gemini to OpenAI Q* (Q-Star): A Survey of...](https://www.researchgate.net/publication/376616303_From_Google_Gemini_to_OpenAI_Q_Q-Star_A_Survey_of_Reshaping_the_Generative_Artificial_Intelligence_AI_Research_Landscape) 📑: A comprehensive survey that explores the evolving landscape of generative AI, focusing on the transformative impacts and reshaping of the AI research landscape by Google's Gemini and OpenAI projects.
- [Preparing to Revolutionize Education with the Multi-Model GenAI Tool Google Gemini: A Journey towards Effective Policy Making](https://www.researchgate.net/publication/373066196_Preparing_to_Revolutionize_Education_with_the_Multi-Model_GenAI_Tool_Google_Gemini_A_Journey_towards_Effective_Policy_Making): This paper offers guidelines for shaping AI strategies across stakeholders, including government, in the context of AI Policy and Google Gemini.
- [Welcome to the Gemini era: Google DeepMind and the Information Industry](https://www.researchgate.net/publication/376812352_Welcome_to_the_Gemini_era_Google_DeepMind_and_the_Information_Industry): Examines the motivation behind Google's development of Gemini and its potential impact on the information industry.
- [Compare Gemini Pro AI from Google and ChatGPT 4.0](https://www.researchgate.net/publication/377112787_Compare_Gemini_Pro_AI_from_Google_and_ChatGPT_40): Conducts a comparative analysis between Google's Gemini Pro and OpenAI's ChatGPT 4.0, focusing on generative AI models.
- [A Challenger to GPT-4V? Early Explorations of Gemini in Visual Understanding](https://arxiv.org/abs/2312.12436): Explores the visual understanding proficiency of Gemini Pro in comparison to GPT-4V and showcases its capabilities in fundamental perception, advanced cognition, challenging vision tasks, and expert capacities.
- [The Impact of Changing the Name of Google AI from Bard to Gemini](https://www.researchgate.net/publication/378124023_The_Impact_of_Changing_the_Name_of_Google_AI_from_Bard_to_Gemini): Delves into the intricacies of renaming Google AI from Bard to Gemini, exploring its historical context, rationale, and implications.
- [Gemini vs GPT-4V: A Preliminary Comparison and Combination of Vision-Language Models](https://arxiv.org/abs/2312.15011): Presents an in-depth comparative study between Google's Gemini and OpenAI's GPT-4V, evaluating their performance across various dimensions such as Vision-Language Capability, Interaction with Humans, Temporal Understanding, and Intelligence and Emotional Quotients.
- [Gemini in Reasoning: Unveiling Commonsense in Multimodal Large Language Models](https://arxiv.org/abs/2312.17661): Evaluates Gemini's performance in complex reasoning tasks that require the integration of commonsense knowledge across multiple modalities, comparing it with GPT models.
- [Google DeepMind's gemini AI versus ChatGPT: a comparative analysis in ophthalmology](https://pubmed.ncbi.nlm.nih.gov/38355668/): Conducts a comparative analysis of Google DeepMind's gemini AI and ChatGPT in the field of ophthalmology.

## Videos

- [The capabilities of multimodal AI | Gemini Demo - YouTube](https://www.youtube.com/watch?v=UIZAiXYceBI) 🎥: YouTube video showcasing the power of Gemini AI, a natively multimodal AI model capable of reasoning across text, images, audio, video, and code.
- [How to use Gemini AI with Google Workspace (Gmail, Drive & Docs) - YouTube](https://www.youtube.com/watch?v=VqTjJubt0kE) 🎥: In this video, Scott Friesen demonstrates how to maximize your AI experience by utilizing Gemini AI in Google Workspace applications.
- [Google's newest and most capable AI | Gemini - YouTube](https://www.youtube.com/watch?v=jV1vkHv4zq8) 🎥: Learn about Gemini AI, Google's latest AI model designed to make AI more accessible for everyone, recognizing and understanding various forms of data.
- [Reasoning across a 402-page transcript | Gemini 1.5 Pro Demo - YouTube](https://www.youtube.com/watch?v=LHKL_210CcU) 🎥: Check out the demonstration of Gemini 1.5 Pro, highlighting its ability to reason across a lengthy transcript and its improved performance.
- [Gemini 1.5 and The Biggest Night in AI - YouTube](https://www.youtube.com/watch?v=Cs6pe8o7XY8) 🎥: Dive into the details of Gemini 1.5 with this video, which includes the link to the Gemini 1.5 report and additional information from the Google DeepMind Blog.
- [Multimodal prompting with a 44-minute movie | Gemini 1.5 Pro - YouTube](https://www.youtube.com/watch?v=wa0MT8OwHuk) 🎥: Discover how Gemini 1.5 Pro handles multimodal prompting by utilizing a 44-minute movie, demonstrating the capabilities of generative AI with Gemini.
- [AI makes a Mark Rober video | Bard with Gemini Pro - YouTube](https://www.youtube.com/watch?v=mHZSrtl4zX0) 🎥: Witness the collaboration between Mark Rober and Gemini AI, combining science, engineering, and AI to create an extraordinary paper plane in this mind-blowing video.
- [I've Built an Android App With Google's New AI Gemini - YouTube](https://www.youtube.com/watch?v=i7PJwg0lrU0) 🎥: Join this video to see how an Android app was built using Google's new AI, Gemini, and be inspired to become industry-ready with the assistance of Gemini AI.
- [Can Google's Gemini Take On ChatGPT? - YouTube](https://www.youtube.com/watch?v=-VdMv4mVOMs) 🎥: Explore the capabilities of Google's Gemini compared to ChatGPT, the world's most powerful AI model, and gain insights into Gemini AI's potential.
- [Google's newest AI in 90 seconds | Gemini - YouTube](https://www.youtube.com/watch?v=_TVnM9dmUSk) 🎥: Get a brief introduction to Gemini, Google's largest and most capable AI model, built to be multimodal and trained to recognize diverse types of data.
- [Math & physics with AI | Gemini - YouTube](https://www.youtube.com/watch?v=K4pX1VAxaAI) 💡
Dec 6, 2023... AI explains learning in math & physics. Introducing Google's newest and most capable AI model Gemini. Gemini was trained to recognize and understand various concepts in math and physics.
- [This is changing the way scientists research | Gemini - YouTube](https://www.youtube.com/watch?v=sPiOP_CB54A) 💡
Dec 6, 2023... Gemini — Google's newest and most capable AI model. It enables researchers to read, understand, and extract crucial scientific information from a vast corpus of 200,000 scientific papers.
- [Using AI to solve complex problems | Gemini - YouTube](https://www.youtube.com/watch?v=LvGmVmHv69s) 💡
Dec 6, 2023... Watch as AI solves complex problems with the help of Google DeepMind Research Engineer Gabriela Surita, utilizing Gemini's advanced coding abilities.
- [Bard becomes Gemini | Ultra 1.0 and a new mobile app - YouTube](https://www.youtube.com/watch?v=b5Fh7TaTkEU) 💡
Feb 8, 2024... Introducing Bard's transformation into Gemini Advanced and the announcement of a new mobile app that facilitates collaboration with the best of Google AI.
- [Gemini: Google's largest and most capable AI model - YouTube](https://www.youtube.com/playlist?list=PL590L5WQmH8cSyqzo1PwQVUrZYgLcGZcG) 💡
Gemini is Google's most capable AI model designed to be helpful for everyone. Inspired by the human understanding and interaction, Gemini surpasses its predecessors in terms of power and capability.

## Tools & Software

- [Google Gemini Alternatives: 25+ AI Writing Tools | AlternativeTo](https://alternativeto.net/software/google-bard/): The best Google Gemini alternatives are ChatGPT, HuggingChat, and Perplexity AI. Explore more than 100 apps similar to Google Gemini for various platforms.
- [Top 10 Google Gemini Alternatives & Competitors (Free/Paid)](https://www.g2.com/products/google-google-gemini/competitors/alternatives): Find top-ranking free and paid Google Gemini alternatives and competitors. Read the latest reviews to choose the best AI Chatbots Software for your business.
- [Google unveils Gemini 1.5 AI with enhanced efficiency and million ...](https://alternativeto.net/news/2024/2/google-unveils-gemini-1-5-ai-with-enhanced-efficiency-and-million-token-context-window/): Google has launched an updated version of its conversational AI system, Google Gemini, providing improvements in efficiency, performance, and context window size.
- [Google Gemini: Chat to start writing, planning, learning and more ...](https://alternativeto.net/software/google-bard/about/): Gemini gives you direct access to Google AI, providing assistance with writing, planning, learning, and more tasks.
- [Compare Google Gemini vs. Microsoft Copilot | G2](https://www.g2.com/compare/google-google-gemini-vs-microsoft-copilot): Compare Google Gemini and Microsoft Copilot in terms of pricing, user satisfaction, and features. Make smarter and cost-effective software buying decisions.
- [Google launched Gemini 1.0](https://deepmind.google/technologies/gemini/): Google's next-generation multimodal AI model that surpasses OpenAI's GPT-4. Rated 5 for its AI-powered functionalities and ad-free interface.
- [Compare GitHub Copilot vs. Google Gemini](https://www.g2.com/compare/github-copilot-vs-google-google-gemini): A head-to-head comparison of AI code generation software, GitHub Copilot, and Google Gemini, covering pricing, user satisfaction, and features.
- [Google Gemini AI ChatBot Makers](https://www.producthunt.com/products/free-google-gemini-ai-chatbot/makers): Meet the founders, developers, designers, and product people behind the Free Google Gemini AI ChatBot.
- [Google Duet AI](https://alternativeto.net/software/google-duet-ai/about/): A powerful collaborator and productivity booster in Google Workspace, now merged into Google Gemini.
- [ChatGPT vs. Duet AI vs. Gemini Comparison](https://sourceforge.net/software/compare/ChatGPT-vs-Duet-AI-vs-Gemini-Google/): Side-by-side comparison of ChatGPT, Duet AI, and Gemini, analyzing price, features, and reviews.
- [Gemini & Gemini Advanced](https://www.producthunt.com/posts/gemini-gemini-advanced-3): Access Google's best family of AI models on your phone with Gemini (formerly Google Bard).

## Conferences & Events

- [AI tools for writers: Chat GPT & Google Bard (Gemini)](https://www.meetup.com/personality-psychology-for-writers/events/298943266/) : Let's discuss the new possibilities for writers that the AI revolution has brought as we dive into the tricks and potential uses of the best-known generative text AIs.
- [NYC AI Users - AI Tech Talks, Demo & Social: RAG Search and ...](https://www.meetup.com/nycaiu/events/299123889/) : AI technology like OpenAI's ChatGPT, Google's Bard and Gemini, Midjourney, Dall-E, and many others will play an increasingly large role in our day-to-day activities.
- [Flutter Singapore Meetup Q1 2024](https://www.meetup.com/flutter-singapore/events/297896865/) : Join us for an enlightening talk that explores the seamless integration of LangChain, Google AI aka Gemini, and Large Language Model (LLM) into Flutter apps.
- [Intro to Large Language Models](https://www.meetup.com/tfugblr/events/298630027/) : Join us for an exciting event as we dive into the world of Large Language Models and explore their applications in AI/ML and Machine Intelligence.
- [Geminight](https://www.meetup.com/gdg-cloud-belgium/events/299030315/) : Our speakers from Google and Xebia will tell you all about the possibilities and challenges of building LLM-driven applications, including diving deeper into Gemini, Google's latest state-of-the-art GenAI model.
- [Unlocking the Power of LLMs in Enterprises using Google Cloud](https://www.meetup.com/nl-NL/eindhoven-data-community/events/298592514/) : Learn how Google Cloud can be leveraged to build LLM driven applications in enterprises through a showcase by Pankaj Barawal, Customer Engineer Smart Analytics, and AI at Google.
- [Find Fantasy Writers Events & Groups in London, GB](https://www.meetup.com/find/gb--london/fantasy-writers/): AI tools for writers: Chat GPT & Google Bard (Gemini). Attend online or in-person events to connect with people who share your interests in fantasy writing.
- [Find Writing Events & Groups in Twickenham, London Borough of...](https://www.meetup.com/find/gb--twickenham/writing/): Creative Writing Workshop (in person) with Lisa. Group name: London Writers. AI tools for writers: Chat GPT & Google Bard (Gemini). Join writing groups in Twickenham to connect with like-minded individuals.
- [Find Writing Events & Groups in London Borough of Islington...](https://www.meetup.com/find/gb--islington/writing/): Writing Events near London Borough of Islington. Join authors who are learning to use AI, participate in the Hackney Writing Circle, or enhance your creative writing skills.

## Slides & Presentations

- [Google's Gemini AI](https://www.slideshare.net/HasnaMariyam/googles-geminipdf): A presentation providing an overview of Google's latest and most capable AI model, Gemini. It highlights its multimodal capabilities and state-of-the-art performance in various benchmarks.
- [Generative AI for Teaching, Learning and Assessment](https://www.slideshare.net/sharplem/generative-ai-for-teaching-learning-and-assessment): This presentation explores how AI is disrupting education, enabling students, teachers, and academics to access software that writes essays and summarizes scientific texts.
- [Google's Gemini Marketing Trick: what a trickster!](https://www.slideshare.net/posselist/googles-gemini-marketing-trick-what-a-trickster): A presentation discussing Google's marketing strategy for Gemini AI, highlighting its intriguing aspects.
- [Gemini Introduction](https://www.slideshare.net/SoCalDevGal/gemini-introduction): An introduction to Gemini AI, showcasing its application in a three-dimensional database and e-commerce web services.
- [Identifying and attracting talent: 3 tips for building your ideal marketing team with Hibob](https://www.slideshare.net/saastr/identifying-and-attracting-talent-3-tips-for-building-your-ideal-marketing-team-with-hibob) - Sep 15, 2023. Download as a PDF or view online for free.
- [How should our higher education institutions respond to innovations in new AI-based language processing software](https://www.slideshare.net/suebeckingham/how-should-our-higher-education-institutions-respond-to-innovations-in-new-aibased-language-processing-software-pptx) - May 20, 2023. Download as a PDF or view online for free.
- [For tech giants, AI like Bing and Bard poses billion-dollar search problem](https://www.slideshare.net/posselist/for-tech-giants-ai-like-bing-and-bard-poses-billiondollar-search-problem) - Feb 24, 2023. Download as a PDF or view online for free.
- [CHATGPT VS BARD AI](https://www.slideshare.net/RajaSubramanianV/chatgpt-vs-bard-ai) - May 14, 2023. Download as a PDF or view online for free.
- [AI is already writing books, websites and online recipes](https://www.slideshare.net/posselist/ai-is-already-writing-books-websites-and-online-recipes) - May 9, 2023. Download as a PDF or view online for free.
- [Is Machine Learning the Solution to Your Capacity Management Challenges?](https://www.slideshare.net/Syncsort/is-machine-learning-the-solution-to-your-capacity-management-challenges) - Sep 23, 2019. Download as a PDF or view online for free.
- [Why ChatGPT Is Getting Dumber at Basic Math](https://www.slideshare.net/posselist/why-chatgpt-is-getting-dumber-at-basic-math) - Aug 9, 2023. Download as a PDF or view online for free.
- [What happens when ChatGPT lies about real people?](https://www.slideshare.net/posselist/what-happens-when-chatgpt-lies-about-real-people) - Apr 12, 2023. Download as a PDF or view online for free.

## Podcasts

- [Marketing Against The Grain: Google Launches Gemini AI (And It's Better Than GPT-4)](https://podcasts.apple.com/us/podcast/google-launches-gemini-ai-and-its-better-than-gpt-4/id1616700934?i=1000637864670): In this episode, learn about Google's latest Gemini AI release and how it surpasses GPT-4.
- [An AI and ChatGPT Podcast: EP 204: Google Gemini Advanced - 7 things you need to know](https://podcasts.apple.com/au/podcast/ep-204-google-gemini-advanced-7-things-you-need-to-know/id1683401861?i=1000644772359): Dive into a discussion about Google's paid Gemini Advanced, its features, and if it lives up to its "advanced" label.
- [This Day in AI Podcast on Apple Podcasts](https://podcasts.apple.com/no/podcast/this-day-in-ai-podcast/id1671087656): EP47: GPT-5 Rumors, AutoGen Studio, SeeAct Web Agents, Google AMIE, Anthropic's Sleeper Agents. (Duration: 1 hr 26 min)
- [This Day in AI Podcast Trên Apple Podcast](https://podcasts.apple.com/us/podcast/this-day-in-ai-podcast/id1671087656?l=vi): EP47: GPT-5 Rumors, AutoGen Studio, SeeAct Web Agents, Google AMIE, Anthropic's Sleeper Agents. (Duration: 1 giờ 26 phút)
- [SERP's Up SEO Podcast on Apple Podcasts](https://podcasts.apple.com/il/podcast/serps-up-seo-podcast/id1639368336): SERP's Up | How will Google's most powerful AI, Gemini, impact SEO? The race is... episode 74 of the SERP's Up SEO Podcast as we discover Google Gemini! Key... (Duration: n/a)
- [The AI Breakdown: Daily Artificial Intelligence News and...](https://podcasts.apple.com/ca/podcast/google-launches-gemini-1-5-with-one-million-token/id1680633614?i=1000645495994): Google surprises everyone with a massive context window on their new Gemini 1.5 model. Speaking of huge context windows, Magic.dev raises $100M+ for a model... (Duration: n/a)

---

This initial version of the Awesome List was generated with the help of the [Awesome List Generator](https://github.com/alialsaeedi19/GPT-Awesome-List-Maker). It's an open-source Python package that uses the power of GPT models to automatically curate and generate starting points for resource lists related to a specific topic. 
