/*
 * ThingPark things management Devices API
 * REST interface for Devices management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.device;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * DeviceProfilesBriefsInner
 */
@JsonPropertyOrder({ DeviceProfilesBriefsInner.JSON_PROPERTY_I_D,
    DeviceProfilesBriefsInner.JSON_PROPERTY_COMMERCIAL_NAME, DeviceProfilesBriefsInner.JSON_PROPERTY_CONNECTIVITY,
    DeviceProfilesBriefsInner.JSON_PROPERTY_MAC_MAJOR_VERSION,
    DeviceProfilesBriefsInner.JSON_PROPERTY_MAC_MINOR_VERSION, DeviceProfilesBriefsInner.JSON_PROPERTY_TYPE_M_A_C,
    DeviceProfilesBriefsInner.JSON_PROPERTY_VENDOR, DeviceProfilesBriefsInner.JSON_PROPERTY_DEFAULT_ISM_BANDS,
    DeviceProfilesBriefsInner.JSON_PROPERTY_MOTION_MODEL_INDICATOR })
@JsonTypeName("DeviceProfiles_briefs_inner")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-29T11:51:09.923129109+02:00[Europe/Paris]", comments = "Generator version: 7.6.0")
public class DeviceProfilesBriefsInner {
  public static final String JSON_PROPERTY_I_D = "ID";
  private String ID;

  public static final String JSON_PROPERTY_COMMERCIAL_NAME = "commercialName";
  private String commercialName;

  /**
   * Device Profile connectivity: - &#x60;LORAWAN&#x60;: LoRaWAN connectivity -
   * &#x60;CELLULAR&#x60;: Cellular connectivity &#x60;CELLULAR&#x60; is only
   * applicable to **ThingPark Wireless** if the cellular connectivity is enabled
   * by the Operator.
   */
  public enum ConnectivityEnum {
    LORAWAN("LORAWAN"),

    CELLULAR("CELLULAR");

    private String value;

    ConnectivityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ConnectivityEnum fromValue(String value) {
      for (ConnectivityEnum b : ConnectivityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CONNECTIVITY = "connectivity";
  private ConnectivityEnum connectivity;

  public static final String JSON_PROPERTY_MAC_MAJOR_VERSION = "macMajorVersion";
  private Integer macMajorVersion;

  public static final String JSON_PROPERTY_MAC_MINOR_VERSION = "macMinorVersion";
  private Integer macMinorVersion;

  /**
   * MAC layer of the Device : - &#39;LoRaMAC&#39;: LoRa MAC layer -
   * &#39;802.15.4&#39;: 802.15.4 MAC layer (DEPRECATED) -
   * &#39;WattecoMAC_3.1&#39;: Watteco 3.1 MAC layer (DEPRECATED) -
   * &#39;WattecoMAC_3.2&#39;: Watteco 3.2 MAC layer (DEPRECATED)
   */
  public enum TypeMACEnum {
    LORAMAC("LoRaMAC"),

    _802_15_4("802.15.4"),

    WATTECOMAC_3_1("WattecoMAC_3.1"),

    WATTECOMAC_3_2("WattecoMAC_3.2");

    private String value;

    TypeMACEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeMACEnum fromValue(String value) {
      for (TypeMACEnum b : TypeMACEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE_M_A_C = "typeMAC";
  private TypeMACEnum typeMAC;

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private DeviceProfilesBriefsInnerVendor vendor;

  public static final String JSON_PROPERTY_DEFAULT_ISM_BANDS = "defaultIsmBands";
  private List<DeviceProfilesBriefsInnerDefaultIsmBandsInner> defaultIsmBands = new ArrayList<>();

  /**
   * The motion indicator provides an indication on the maximal speed of the node
   */
  public enum MotionModelIndicatorEnum {
    NEAR_STATIC("NEAR_STATIC"),

    WALKING_SPEED("WALKING_SPEED"),

    BIKE_SPEED("BIKE_SPEED"),

    VEHICLE_SPEED("VEHICLE_SPEED"),

    RANDOM("RANDOM");

    private String value;

    MotionModelIndicatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MotionModelIndicatorEnum fromValue(String value) {
      for (MotionModelIndicatorEnum b : MotionModelIndicatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MOTION_MODEL_INDICATOR = "motionModelIndicator";
  private MotionModelIndicatorEnum motionModelIndicator;

  public DeviceProfilesBriefsInner() {
  }

  public DeviceProfilesBriefsInner ID(String ID) {

    this.ID = ID;
    return this;
  }

  /**
   * ID of the device profile
   * 
   * @return ID
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getID() {
    return ID;
  }

  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setID(String ID) {
    this.ID = ID;
  }

  public DeviceProfilesBriefsInner commercialName(String commercialName) {

    this.commercialName = commercialName;
    return this;
  }

  /**
   * B2C name of device profile
   * 
   * @return commercialName
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_COMMERCIAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCommercialName() {
    return commercialName;
  }

  @JsonProperty(JSON_PROPERTY_COMMERCIAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommercialName(String commercialName) {
    this.commercialName = commercialName;
  }

  public DeviceProfilesBriefsInner connectivity(ConnectivityEnum connectivity) {

    this.connectivity = connectivity;
    return this;
  }

  /**
   * Device Profile connectivity: - &#x60;LORAWAN&#x60;: LoRaWAN connectivity -
   * &#x60;CELLULAR&#x60;: Cellular connectivity &#x60;CELLULAR&#x60; is only
   * applicable to **ThingPark Wireless** if the cellular connectivity is enabled
   * by the Operator.
   * 
   * @return connectivity
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CONNECTIVITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ConnectivityEnum getConnectivity() {
    return connectivity;
  }

  @JsonProperty(JSON_PROPERTY_CONNECTIVITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setConnectivity(ConnectivityEnum connectivity) {
    this.connectivity = connectivity;
  }

  public DeviceProfilesBriefsInner macMajorVersion(Integer macMajorVersion) {

    this.macMajorVersion = macMajorVersion;
    return this;
  }

  /**
   * LoRaWAN MAC major version implemented by the device: - 0: LoRaWAN 1.x
   * 
   * @return macMajorVersion
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAC_MAJOR_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMacMajorVersion() {
    return macMajorVersion;
  }

  @JsonProperty(JSON_PROPERTY_MAC_MAJOR_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMacMajorVersion(Integer macMajorVersion) {
    this.macMajorVersion = macMajorVersion;
  }

  public DeviceProfilesBriefsInner macMinorVersion(Integer macMinorVersion) {

    this.macMinorVersion = macMinorVersion;
    return this;
  }

  /**
   * LoRaWAN MAC minor version implemented by the device: - 3: LoRaWAN 1.0.0/1.0.1
   * - 4: LoRaWAN 1.0.2 - 5: LoRaWAN 1.0.3 - 6: LoRaWAN 1.0.4 - 10: LoRaWAN 1.1
   * 
   * @return macMinorVersion
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAC_MINOR_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMacMinorVersion() {
    return macMinorVersion;
  }

  @JsonProperty(JSON_PROPERTY_MAC_MINOR_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMacMinorVersion(Integer macMinorVersion) {
    this.macMinorVersion = macMinorVersion;
  }

  public DeviceProfilesBriefsInner typeMAC(TypeMACEnum typeMAC) {

    this.typeMAC = typeMAC;
    return this;
  }

  /**
   * MAC layer of the Device : - &#39;LoRaMAC&#39;: LoRa MAC layer -
   * &#39;802.15.4&#39;: 802.15.4 MAC layer (DEPRECATED) -
   * &#39;WattecoMAC_3.1&#39;: Watteco 3.1 MAC layer (DEPRECATED) -
   * &#39;WattecoMAC_3.2&#39;: Watteco 3.2 MAC layer (DEPRECATED)
   * 
   * @return typeMAC
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE_M_A_C)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeMACEnum getTypeMAC() {
    return typeMAC;
  }

  @JsonProperty(JSON_PROPERTY_TYPE_M_A_C)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTypeMAC(TypeMACEnum typeMAC) {
    this.typeMAC = typeMAC;
  }

  public DeviceProfilesBriefsInner vendor(DeviceProfilesBriefsInnerVendor vendor) {

    this.vendor = vendor;
    return this;
  }

  /**
   * Get vendor
   * 
   * @return vendor
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DeviceProfilesBriefsInnerVendor getVendor() {
    return vendor;
  }

  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(DeviceProfilesBriefsInnerVendor vendor) {
    this.vendor = vendor;
  }

  public DeviceProfilesBriefsInner defaultIsmBands(
          List<DeviceProfilesBriefsInnerDefaultIsmBandsInner> defaultIsmBands) {

    this.defaultIsmBands = defaultIsmBands;
    return this;
  }

  public DeviceProfilesBriefsInner addDefaultIsmBandsItem(
          DeviceProfilesBriefsInnerDefaultIsmBandsInner defaultIsmBandsItem) {
    if (this.defaultIsmBands == null) {
      this.defaultIsmBands = new ArrayList<>();
    }
    this.defaultIsmBands.add(defaultIsmBandsItem);
    return this;
  }

  /**
   * List of ISM bands supported by the device profile. If the list of device
   * profiles is filtered by ISM bands, this list is an intersection between
   * requested ISM bands and supported ISM bands.
   * 
   * @return defaultIsmBands
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_ISM_BANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DeviceProfilesBriefsInnerDefaultIsmBandsInner> getDefaultIsmBands() {
    return defaultIsmBands;
  }

  @JsonProperty(JSON_PROPERTY_DEFAULT_ISM_BANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultIsmBands(List<DeviceProfilesBriefsInnerDefaultIsmBandsInner> defaultIsmBands) {
    this.defaultIsmBands = defaultIsmBands;
  }

  public DeviceProfilesBriefsInner motionModelIndicator(MotionModelIndicatorEnum motionModelIndicator) {

    this.motionModelIndicator = motionModelIndicator;
    return this;
  }

  /**
   * The motion indicator provides an indication on the maximal speed of the node
   * 
   * @return motionModelIndicator
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MOTION_MODEL_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MotionModelIndicatorEnum getMotionModelIndicator() {
    return motionModelIndicator;
  }

  @JsonProperty(JSON_PROPERTY_MOTION_MODEL_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMotionModelIndicator(MotionModelIndicatorEnum motionModelIndicator) {
    this.motionModelIndicator = motionModelIndicator;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceProfilesBriefsInner deviceProfilesBriefsInner = (DeviceProfilesBriefsInner) o;
    return Objects.equals(this.ID, deviceProfilesBriefsInner.ID)
            && Objects.equals(this.commercialName, deviceProfilesBriefsInner.commercialName)
            && Objects.equals(this.connectivity, deviceProfilesBriefsInner.connectivity)
            && Objects.equals(this.macMajorVersion, deviceProfilesBriefsInner.macMajorVersion)
            && Objects.equals(this.macMinorVersion, deviceProfilesBriefsInner.macMinorVersion)
            && Objects.equals(this.typeMAC, deviceProfilesBriefsInner.typeMAC)
            && Objects.equals(this.vendor, deviceProfilesBriefsInner.vendor)
            && Objects.equals(this.defaultIsmBands, deviceProfilesBriefsInner.defaultIsmBands)
            && Objects.equals(this.motionModelIndicator, deviceProfilesBriefsInner.motionModelIndicator);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ID, commercialName, connectivity, macMajorVersion, macMinorVersion, typeMAC, vendor,
            defaultIsmBands, motionModelIndicator);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceProfilesBriefsInner {\n");
    sb.append("    ID: ").append(toIndentedString(ID)).append("\n");
    sb.append("    commercialName: ").append(toIndentedString(commercialName)).append("\n");
    sb.append("    connectivity: ").append(toIndentedString(connectivity)).append("\n");
    sb.append("    macMajorVersion: ").append(toIndentedString(macMajorVersion)).append("\n");
    sb.append("    macMinorVersion: ").append(toIndentedString(macMinorVersion)).append("\n");
    sb.append("    typeMAC: ").append(toIndentedString(typeMAC)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    defaultIsmBands: ").append(toIndentedString(defaultIsmBands)).append("\n");
    sb.append("    motionModelIndicator: ").append(toIndentedString(motionModelIndicator)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
