/*
 * ThingPark things management Devices API
 * REST interface for Devices management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.device;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Device Profile When updated, the MAC type of the new Device Profile must be
 * the same than the current one
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonPropertyOrder({ DeviceModel.JSON_PROPERTY_I_D, DeviceModel.JSON_PROPERTY_COMMERCIAL_NAME,
    DeviceModel.JSON_PROPERTY_LOGO })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-29T01:47:08.521515962+02:00[Europe/Paris]", comments = "Generator version: 7.6.0")
public class DeviceModel {
  public static final String JSON_PROPERTY_I_D = "ID";
  private String ID;

  public static final String JSON_PROPERTY_COMMERCIAL_NAME = "commercialName";
  private String commercialName;

  public static final String JSON_PROPERTY_LOGO = "logo";
  private String logo;

  public DeviceModel() {
  }

  @JsonCreator
  public DeviceModel(@JsonProperty(JSON_PROPERTY_COMMERCIAL_NAME) String commercialName,
          @JsonProperty(JSON_PROPERTY_LOGO) String logo) {
    this();
    this.commercialName = commercialName;
    this.logo = logo;
  }

  public DeviceModel ID(String ID) {

    this.ID = ID;
    return this;
  }

  /**
   * Device Profile ID The Device Profile must have the same connectivity than the
   * Device LoRaWAN device: - If NS only mode is deactivated
   * (external-js-opt&#x3D;DEACTIVATED), the Device Profile associated with the
   * Device can be updated only if the MAC type is the same and, for LoRaMAC type,
   * the LoRaWAN version is compatible - Else if NS only mode is activated
   * (external-js-opt&#x3D;ACTIVATED), the Device Profile associated with the
   * Device can be updated only if the MAC type is compatible
   * 
   * @return ID
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getID() {
    return ID;
  }

  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setID(String ID) {
    this.ID = ID;
  }

  /**
   * Device Profile commercial name
   * 
   * @return commercialName
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_COMMERCIAL_NAME)

  public String getCommercialName() {
    return commercialName;
  }

  /**
   * Device Profile logo href
   * 
   * @return logo
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LOGO)

  public String getLogo() {
    return logo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceModel deviceModel = (DeviceModel) o;
    return Objects.equals(this.ID, deviceModel.ID) && Objects.equals(this.commercialName, deviceModel.commercialName)
            && Objects.equals(this.logo, deviceModel.logo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ID, commercialName, logo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceModel {\n");
    sb.append("    ID: ").append(toIndentedString(ID)).append("\n");
    sb.append("    commercialName: ").append(toIndentedString(commercialName)).append("\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
