/*
 * ThingPark things management Devices API
 * REST interface for Devices management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.device;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * DeviceLorawanLRR
 */
@JsonPropertyOrder({ DeviceLorawanLRR.JSON_PROPERTY_I_D, DeviceLorawanLRR.JSON_PROPERTY_R_S_S_I,
    DeviceLorawanLRR.JSON_PROPERTY_S_N_R, DeviceLorawanLRR.JSON_PROPERTY_INSTANT_P_E_R,
    DeviceLorawanLRR.JSON_PROPERTY_E_S_P, DeviceLorawanLRR.JSON_PROPERTY_LAT, DeviceLorawanLRR.JSON_PROPERTY_LON })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-29T01:47:08.521515962+02:00[Europe/Paris]", comments = "Generator version: 7.6.0")
public class DeviceLorawanLRR {
  public static final String JSON_PROPERTY_I_D = "ID";
  private String ID;

  public static final String JSON_PROPERTY_R_S_S_I = "RSSI";
  private Float RSSI;

  public static final String JSON_PROPERTY_S_N_R = "SNR";
  private Float SNR;

  public static final String JSON_PROPERTY_INSTANT_P_E_R = "instantPER";
  private Float instantPER;

  public static final String JSON_PROPERTY_E_S_P = "ESP";
  private Float ESP;

  public static final String JSON_PROPERTY_LAT = "lat";
  private Float lat;

  public static final String JSON_PROPERTY_LON = "lon";
  private Float lon;

  public DeviceLorawanLRR() {
  }

  public DeviceLorawanLRR ID(String ID) {

    this.ID = ID;
    return this;
  }

  /**
   * Ordered list of last LRRs (max 3) that receive the last uplink frame. The
   * best LRR is always placed at the first position. Note: The LRR lon/lan is not
   * returned when the LRR ID does not match a base station in the TWA database.
   * 
   * @return ID
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getID() {
    return ID;
  }

  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setID(String ID) {
    this.ID = ID;
  }

  public DeviceLorawanLRR RSSI(Float RSSI) {

    this.RSSI = RSSI;
    return this;
  }

  /**
   * Get RSSI
   * 
   * @return RSSI
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_R_S_S_I)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getRSSI() {
    return RSSI;
  }

  @JsonProperty(JSON_PROPERTY_R_S_S_I)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRSSI(Float RSSI) {
    this.RSSI = RSSI;
  }

  public DeviceLorawanLRR SNR(Float SNR) {

    this.SNR = SNR;
    return this;
  }

  /**
   * Get SNR
   * 
   * @return SNR
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_S_N_R)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getSNR() {
    return SNR;
  }

  @JsonProperty(JSON_PROPERTY_S_N_R)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSNR(Float SNR) {
    this.SNR = SNR;
  }

  public DeviceLorawanLRR instantPER(Float instantPER) {

    this.instantPER = instantPER;
    return this;
  }

  /**
   * Instantaneous PER (Packet Error Rate) only considering uplink frames received
   * by this LRR. The instantaneous PER is computed over the 2 last distinct
   * uplink frames as follows: - InstantPER &#x3D; 1 – [ 2 / (FCntUp(N) -
   * FCntUp(N-1) + 1)], where: - FCntUp(N) is the FCntUp of the last uplink frame
   * - FCntUp(N-1) is the FCntUp of the previous uplink frame (excluding
   * repetitions) - Example: If the two last received uplink frames have FCntUp 33
   * and 36, then InstantPER &#x3D; 1 - [2/(36-33+1)] &#x3D; 0.5 &#x3D; 50%
   * (because frames 34 &amp; 35 were missing, so 4 frames expected but only 2
   * frames received). - A device reset/rejoin resets the InstantPER to 0 minimum:
   * 0
   * 
   * @return instantPER
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INSTANT_P_E_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getInstantPER() {
    return instantPER;
  }

  @JsonProperty(JSON_PROPERTY_INSTANT_P_E_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstantPER(Float instantPER) {
    this.instantPER = instantPER;
  }

  public DeviceLorawanLRR ESP(Float ESP) {

    this.ESP = ESP;
    return this;
  }

  /**
   * Get ESP
   * 
   * @return ESP
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_E_S_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getESP() {
    return ESP;
  }

  @JsonProperty(JSON_PROPERTY_E_S_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setESP(Float ESP) {
    this.ESP = ESP;
  }

  public DeviceLorawanLRR lat(Float lat) {

    this.lat = lat;
    return this;
  }

  /**
   * Get lat
   * 
   * @return lat
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLat() {
    return lat;
  }

  @JsonProperty(JSON_PROPERTY_LAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLat(Float lat) {
    this.lat = lat;
  }

  public DeviceLorawanLRR lon(Float lon) {

    this.lon = lon;
    return this;
  }

  /**
   * Get lon
   * 
   * @return lon
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLon() {
    return lon;
  }

  @JsonProperty(JSON_PROPERTY_LON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLon(Float lon) {
    this.lon = lon;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceLorawanLRR deviceLorawanLRR = (DeviceLorawanLRR) o;
    return Objects.equals(this.ID, deviceLorawanLRR.ID) && Objects.equals(this.RSSI, deviceLorawanLRR.RSSI)
            && Objects.equals(this.SNR, deviceLorawanLRR.SNR)
            && Objects.equals(this.instantPER, deviceLorawanLRR.instantPER)
            && Objects.equals(this.ESP, deviceLorawanLRR.ESP) && Objects.equals(this.lat, deviceLorawanLRR.lat)
            && Objects.equals(this.lon, deviceLorawanLRR.lon);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ID, RSSI, SNR, instantPER, ESP, lat, lon);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceLorawanLRR {\n");
    sb.append("    ID: ").append(toIndentedString(ID)).append("\n");
    sb.append("    RSSI: ").append(toIndentedString(RSSI)).append("\n");
    sb.append("    SNR: ").append(toIndentedString(SNR)).append("\n");
    sb.append("    instantPER: ").append(toIndentedString(instantPER)).append("\n");
    sb.append("    ESP: ").append(toIndentedString(ESP)).append("\n");
    sb.append("    lat: ").append(toIndentedString(lat)).append("\n");
    sb.append("    lon: ").append(toIndentedString(lon)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
