/*
 * ThingPark things management Networks API
 * REST interface for networks management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.basestation;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;

import lora.ns.actility.api.model.basestation.BsProfilesBriefsInnerDefaultIsmBandsInner;
import lora.ns.actility.api.model.basestation.BsProfilesBriefsInnerVendor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * BsProfilesBriefsInner
 */
@JsonPropertyOrder({ BsProfilesBriefsInner.JSON_PROPERTY_I_D, BsProfilesBriefsInner.JSON_PROPERTY_COMMERCIAL_NAME,
    BsProfilesBriefsInner.JSON_PROPERTY_VENDOR, BsProfilesBriefsInner.JSON_PROPERTY_DEFAULT_ISM_BANDS,
    BsProfilesBriefsInner.JSON_PROPERTY_RF_HARDWARE_CONFIG, BsProfilesBriefsInner.JSON_PROPERTY_SOFTWARE_TYPE })
@JsonTypeName("BsProfiles_briefs_inner")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-31T16:08:44.630492043+02:00[Europe/Paris]", comments = "Generator version: 7.6.0")
public class BsProfilesBriefsInner {
  public static final String JSON_PROPERTY_I_D = "ID";
  private String ID;

  public static final String JSON_PROPERTY_COMMERCIAL_NAME = "commercialName";
  private String commercialName;

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private BsProfilesBriefsInnerVendor vendor;

  public static final String JSON_PROPERTY_DEFAULT_ISM_BANDS = "defaultIsmBands";
  private List<BsProfilesBriefsInnerDefaultIsmBandsInner> defaultIsmBands = new ArrayList<>();

  /**
   * RF hardware configuration of the base station model: - &#x60;S1_A1_B1&#x60;:
   * 1 sector, 1 antenna, 1 board (mono-sector 1\\*8 or 1\\*16) -
   * &#x60;S1_A2_B1&#x60;: 1 sector, 2 antennas, 1 board (mono-sector 2\\*8) -
   * &#x60;S1_A2_B2&#x60;: 1 sector, 2 antennas, 2 boards (mono-sector 2\\*16) -
   * &#x60;S1_A1_B4&#x60;: 1 sector, 1 antennas, 4 boards (mono-sector 1\\*64) -
   * &#x60;S3_A3_B3&#x60;: 3 sectors, 3 antennas, 3 boards (tri-sectors 1\\*8 or
   * 1\\*16)
   */
  public enum RfHardwareConfigEnum {
    S1_A1_B1("S1_A1_B1"),

    S1_A2_B1("S1_A2_B1"),

    S1_A2_B2("S1_A2_B2"),

    S1_A1_B4("S1_A1_B4"),

    S3_A3_B3("S3_A3_B3");

    private String value;

    RfHardwareConfigEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RfHardwareConfigEnum fromValue(String value) {
      for (RfHardwareConfigEnum b : RfHardwareConfigEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RF_HARDWARE_CONFIG = "rfHardwareConfig";
  private RfHardwareConfigEnum rfHardwareConfig;

  /**
   * Type of software executed on the Base Station: - LRR_LINUX: Actility LRR on
   * Linux OS - BASIC_STATION_LINUX: Semtech Basic Station on Linux OS -
   * LRR_FREERTOS: Actility LRR on FreeRTOS
   */
  public enum SoftwareTypeEnum {
    LRR_LINUX("LRR_LINUX"),

    BASIC_STATION_LINUX("BASIC_STATION_LINUX"),

    LRR_FREERTOS("LRR_FREERTOS");

    private String value;

    SoftwareTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SoftwareTypeEnum fromValue(String value) {
      for (SoftwareTypeEnum b : SoftwareTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOFTWARE_TYPE = "softwareType";
  private SoftwareTypeEnum softwareType;

  public BsProfilesBriefsInner() {
  }

  public BsProfilesBriefsInner ID(String ID) {

    this.ID = ID;
    return this;
  }

  /**
   * ID of the base station model
   * 
   * @return ID
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getID() {
    return ID;
  }

  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setID(String ID) {
    this.ID = ID;
  }

  public BsProfilesBriefsInner commercialName(String commercialName) {

    this.commercialName = commercialName;
    return this;
  }

  /**
   * B2C name of the base station model
   * 
   * @return commercialName
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_COMMERCIAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCommercialName() {
    return commercialName;
  }

  @JsonProperty(JSON_PROPERTY_COMMERCIAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommercialName(String commercialName) {
    this.commercialName = commercialName;
  }

  public BsProfilesBriefsInner vendor(BsProfilesBriefsInnerVendor vendor) {

    this.vendor = vendor;
    return this;
  }

  /**
   * Get vendor
   * 
   * @return vendor
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BsProfilesBriefsInnerVendor getVendor() {
    return vendor;
  }

  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(BsProfilesBriefsInnerVendor vendor) {
    this.vendor = vendor;
  }

  public BsProfilesBriefsInner defaultIsmBands(List<BsProfilesBriefsInnerDefaultIsmBandsInner> defaultIsmBands) {

    this.defaultIsmBands = defaultIsmBands;
    return this;
  }

  public BsProfilesBriefsInner addDefaultIsmBandsItem(BsProfilesBriefsInnerDefaultIsmBandsInner defaultIsmBandsItem) {
    if (this.defaultIsmBands == null) {
      this.defaultIsmBands = new ArrayList<>();
    }
    this.defaultIsmBands.add(defaultIsmBandsItem);
    return this;
  }

  /**
   * List of ISM bands supported by the base station model. If the list of base
   * station models is filtered by ISM bands, this list is an intersection between
   * requested ISM bands and supported ISM bands.
   * 
   * @return defaultIsmBands
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_ISM_BANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BsProfilesBriefsInnerDefaultIsmBandsInner> getDefaultIsmBands() {
    return defaultIsmBands;
  }

  @JsonProperty(JSON_PROPERTY_DEFAULT_ISM_BANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultIsmBands(List<BsProfilesBriefsInnerDefaultIsmBandsInner> defaultIsmBands) {
    this.defaultIsmBands = defaultIsmBands;
  }

  public BsProfilesBriefsInner rfHardwareConfig(RfHardwareConfigEnum rfHardwareConfig) {

    this.rfHardwareConfig = rfHardwareConfig;
    return this;
  }

  /**
   * RF hardware configuration of the base station model: - &#x60;S1_A1_B1&#x60;:
   * 1 sector, 1 antenna, 1 board (mono-sector 1\\*8 or 1\\*16) -
   * &#x60;S1_A2_B1&#x60;: 1 sector, 2 antennas, 1 board (mono-sector 2\\*8) -
   * &#x60;S1_A2_B2&#x60;: 1 sector, 2 antennas, 2 boards (mono-sector 2\\*16) -
   * &#x60;S1_A1_B4&#x60;: 1 sector, 1 antennas, 4 boards (mono-sector 1\\*64) -
   * &#x60;S3_A3_B3&#x60;: 3 sectors, 3 antennas, 3 boards (tri-sectors 1\\*8 or
   * 1\\*16)
   * 
   * @return rfHardwareConfig
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_RF_HARDWARE_CONFIG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RfHardwareConfigEnum getRfHardwareConfig() {
    return rfHardwareConfig;
  }

  @JsonProperty(JSON_PROPERTY_RF_HARDWARE_CONFIG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRfHardwareConfig(RfHardwareConfigEnum rfHardwareConfig) {
    this.rfHardwareConfig = rfHardwareConfig;
  }

  public BsProfilesBriefsInner softwareType(SoftwareTypeEnum softwareType) {

    this.softwareType = softwareType;
    return this;
  }

  /**
   * Type of software executed on the Base Station: - LRR_LINUX: Actility LRR on
   * Linux OS - BASIC_STATION_LINUX: Semtech Basic Station on Linux OS -
   * LRR_FREERTOS: Actility LRR on FreeRTOS
   * 
   * @return softwareType
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SOFTWARE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SoftwareTypeEnum getSoftwareType() {
    return softwareType;
  }

  @JsonProperty(JSON_PROPERTY_SOFTWARE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSoftwareType(SoftwareTypeEnum softwareType) {
    this.softwareType = softwareType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BsProfilesBriefsInner bsProfilesBriefsInner = (BsProfilesBriefsInner) o;
    return Objects.equals(this.ID, bsProfilesBriefsInner.ID)
            && Objects.equals(this.commercialName, bsProfilesBriefsInner.commercialName)
            && Objects.equals(this.vendor, bsProfilesBriefsInner.vendor)
            && Objects.equals(this.defaultIsmBands, bsProfilesBriefsInner.defaultIsmBands)
            && Objects.equals(this.rfHardwareConfig, bsProfilesBriefsInner.rfHardwareConfig)
            && Objects.equals(this.softwareType, bsProfilesBriefsInner.softwareType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ID, commercialName, vendor, defaultIsmBands, rfHardwareConfig, softwareType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BsProfilesBriefsInner {\n");
    sb.append("    ID: ").append(toIndentedString(ID)).append("\n");
    sb.append("    commercialName: ").append(toIndentedString(commercialName)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    defaultIsmBands: ").append(toIndentedString(defaultIsmBands)).append("\n");
    sb.append("    rfHardwareConfig: ").append(toIndentedString(rfHardwareConfig)).append("\n");
    sb.append("    softwareType: ").append(toIndentedString(softwareType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
