/*
 * ThingPark things management Networks API
 * REST interface for networks management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.basestation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * BsModel
 */
@JsonPropertyOrder({ BsModel.JSON_PROPERTY_I_D, BsModel.JSON_PROPERTY_COMMERCIAL_NAME, BsModel.JSON_PROPERTY_ISM_BANDS,
    BsModel.JSON_PROPERTY_LOGO, BsModel.JSON_PROPERTY_RF_HARDWARE_CONFIG, BsModel.JSON_PROPERTY_SOFTWARE_TYPE })
@JsonTypeName("Bs_model")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-31T16:08:44.630492043+02:00[Europe/Paris]", comments = "Generator version: 7.6.0")
public class BsModel {
  public static final String JSON_PROPERTY_I_D = "ID";
  private String ID;

  public static final String JSON_PROPERTY_COMMERCIAL_NAME = "commercialName";
  private String commercialName;

  public static final String JSON_PROPERTY_ISM_BANDS = "ismBands";
  private List<BsModelIsmBandsInner> ismBands;

  public static final String JSON_PROPERTY_LOGO = "logo";
  private String logo;

  /**
   * RF hardware configuration of the BS profile: - &#x60;S1_A1_B1&#x60;: 1
   * sector, 1 antenna, 1 board (mono-sector 1\\*8 or 1\\*16) -
   * &#x60;S1_A2_B1&#x60;: 1 sector, 2 antennas, 1 board (mono-sector 2\\*8) -
   * &#x60;S1_A2_B2&#x60;: 1 sector, 2 antennas, 2 boards (mono-sector 2\\*16) -
   * &#x60;S1_A1_B4&#x60;: 1 sector, 1 antennas, 4 boards (mono-sector 1\\*64) -
   * &#x60;S3_A3_B3&#x60;: 3 sectors, 3 antennas, 3 boards (tri-sectors 1\\*8 or
   * 1\\*16)
   */
  public enum RfHardwareConfigEnum {
    S1_A1_B1("S1_A1_B1"),

    S1_A2_B1("S1_A2_B1"),

    S1_A2_B2("S1_A2_B2"),

    S1_A1_B4("S1_A1_B4"),

    S3_A3_B3("S3_A3_B3");

    private String value;

    RfHardwareConfigEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RfHardwareConfigEnum fromValue(String value) {
      for (RfHardwareConfigEnum b : RfHardwareConfigEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RF_HARDWARE_CONFIG = "rfHardwareConfig";
  private RfHardwareConfigEnum rfHardwareConfig;

  /**
   * Type of software executed on the Base Station: - LRR_LINUX: Actility LRR on
   * Linux OS - BASIC_STATION_LINUX: Semtech Basic Station on Linux OS -
   * LRR_FREERTOS: Actility LRR on FreeRTOS
   */
  public enum SoftwareTypeEnum {
    LRR_LINUX("LRR_LINUX"),

    BASIC_STATION_LINUX("BASIC_STATION_LINUX"),

    LRR_FREERTOS("LRR_FREERTOS");

    private String value;

    SoftwareTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SoftwareTypeEnum fromValue(String value) {
      for (SoftwareTypeEnum b : SoftwareTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOFTWARE_TYPE = "softwareType";
  private SoftwareTypeEnum softwareType;

  public BsModel() {
  }

  @JsonCreator
  public BsModel(@JsonProperty(JSON_PROPERTY_COMMERCIAL_NAME) String commercialName,
          @JsonProperty(JSON_PROPERTY_LOGO) String logo,
          @JsonProperty(JSON_PROPERTY_RF_HARDWARE_CONFIG) RfHardwareConfigEnum rfHardwareConfig,
          @JsonProperty(JSON_PROPERTY_SOFTWARE_TYPE) SoftwareTypeEnum softwareType) {
    this();
    this.commercialName = commercialName;
    this.logo = logo;
    this.rfHardwareConfig = rfHardwareConfig;
    this.softwareType = softwareType;
  }

  public BsModel ID(String ID) {

    this.ID = ID;
    return this;
  }

  /**
   * BS profile ID
   * 
   * @return ID
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_I_D)

  public String getID() {
    return ID;
  }

  @JsonProperty(JSON_PROPERTY_I_D)
  public void setID(String ID) {
    this.ID = ID;
  }

  /**
   * BS profile name
   * 
   * @return commercialName
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_COMMERCIAL_NAME)

  public String getCommercialName() {
    return commercialName;
  }

  public BsModel ismBands(List<BsModelIsmBandsInner> ismBands) {

    this.ismBands = ismBands;
    return this;
  }

  public BsModel addIsmBandsItem(BsModelIsmBandsInner ismBandsItem) {
    if (this.ismBands == null) {
      this.ismBands = new ArrayList<>();
    }
    this.ismBands.add(ismBandsItem);
    return this;
  }

  /**
   * List of IMS band IDs associated with the BS profile. If default ISM bands are
   * defined for the network partner, the list is filtered to only keep ISM bands
   * matching the default ones.
   * 
   * @return ismBands
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ISM_BANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BsModelIsmBandsInner> getIsmBands() {
    return ismBands;
  }

  @JsonProperty(JSON_PROPERTY_ISM_BANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsmBands(List<BsModelIsmBandsInner> ismBands) {
    this.ismBands = ismBands;
  }

  /**
   * BS profile logo HREF
   * 
   * @return logo
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LOGO)

  public String getLogo() {
    return logo;
  }

  /**
   * RF hardware configuration of the BS profile: - &#x60;S1_A1_B1&#x60;: 1
   * sector, 1 antenna, 1 board (mono-sector 1\\*8 or 1\\*16) -
   * &#x60;S1_A2_B1&#x60;: 1 sector, 2 antennas, 1 board (mono-sector 2\\*8) -
   * &#x60;S1_A2_B2&#x60;: 1 sector, 2 antennas, 2 boards (mono-sector 2\\*16) -
   * &#x60;S1_A1_B4&#x60;: 1 sector, 1 antennas, 4 boards (mono-sector 1\\*64) -
   * &#x60;S3_A3_B3&#x60;: 3 sectors, 3 antennas, 3 boards (tri-sectors 1\\*8 or
   * 1\\*16)
   * 
   * @return rfHardwareConfig
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_RF_HARDWARE_CONFIG)

  public RfHardwareConfigEnum getRfHardwareConfig() {
    return rfHardwareConfig;
  }

  /**
   * Type of software executed on the Base Station: - LRR_LINUX: Actility LRR on
   * Linux OS - BASIC_STATION_LINUX: Semtech Basic Station on Linux OS -
   * LRR_FREERTOS: Actility LRR on FreeRTOS
   * 
   * @return softwareType
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SOFTWARE_TYPE)

  public SoftwareTypeEnum getSoftwareType() {
    return softwareType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BsModel bsModel = (BsModel) o;
    return Objects.equals(this.ID, bsModel.ID) && Objects.equals(this.commercialName, bsModel.commercialName)
            && Objects.equals(this.ismBands, bsModel.ismBands) && Objects.equals(this.logo, bsModel.logo)
            && Objects.equals(this.rfHardwareConfig, bsModel.rfHardwareConfig)
            && Objects.equals(this.softwareType, bsModel.softwareType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ID, commercialName, ismBands, logo, rfHardwareConfig, softwareType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BsModel {\n");
    sb.append("    ID: ").append(toIndentedString(ID)).append("\n");
    sb.append("    commercialName: ").append(toIndentedString(commercialName)).append("\n");
    sb.append("    ismBands: ").append(toIndentedString(ismBands)).append("\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("    rfHardwareConfig: ").append(toIndentedString(rfHardwareConfig)).append("\n");
    sb.append("    softwareType: ").append(toIndentedString(softwareType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
