/*
 * ThingPark things management Networks API
 * REST interface for networks management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.basestation;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Base Station health state: - INIT: The base station has been created, but has
 * never communicated with the network server - ACTIVE: The base station is
 * connected to the network, transmitting and receiving packets -
 * BACKHAUL_CNX_ERROR: The base station has backhaul connection issues, and
 * cannot communicate with the network server - RF_ERROR: The base station has
 * radio transmission issues, and cannot send or receive LoRaWAN packets to or
 * from a device - SUSPENDED: The base station has been administratively
 * suspended and is no more connected to the network server
 */
public enum BsHealthState {

  INIT("INIT"),

  ACTIVE("ACTIVE"),

  BACKHAUL_CNX_ERROR("BACKHAUL_CNX_ERROR"),

  RF_ERROR("RF_ERROR"),

  SUSPENDED("SUSPENDED");

  private String value;

  BsHealthState(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static BsHealthState fromValue(String value) {
    for (BsHealthState b : BsHealthState.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}
