/*
 * ThingPark things management Networks API
 * REST interface for networks management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.basestation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

import lora.ns.actility.api.model.common.Domain;
import lora.ns.actility.api.model.common.IsmBandID;

/**
 * BsBrief
 */
@JsonPropertyOrder({ BsBrief.JSON_PROPERTY_ACTIVATE_BEACON_TRANSMISSION,
    BsBrief.JSON_PROPERTY_ACTIVATE_R_X2_OPTIMIZATION, BsBrief.JSON_PROPERTY_ALARM1, BsBrief.JSON_PROPERTY_ALARM2,
    BsBrief.JSON_PROPERTY_ALARM3, BsBrief.JSON_PROPERTY_ALARM4, BsBrief.JSON_PROPERTY_ALARM5,
    BsBrief.JSON_PROPERTY_ALARM6, BsBrief.JSON_PROPERTY_ALARM_COUNT, BsBrief.JSON_PROPERTY_ALARM_LEVEL,
    BsBrief.JSON_PROPERTY_ALLOW_CLASS_B, BsBrief.JSON_PROPERTY_ALT, BsBrief.JSON_PROPERTY_ANTS,
    BsBrief.JSON_PROPERTY_APP_SERVERS, BsBrief.JSON_PROPERTY_BEACONS, BsBrief.JSON_PROPERTY_BS_SECURITY,
    BsBrief.JSON_PROPERTY_CLASS_B_STATE, BsBrief.JSON_PROPERTY_CNX_STATE, BsBrief.JSON_PROPERTY_CNX_STATE_SINCE,
    BsBrief.JSON_PROPERTY_CPU, BsBrief.JSON_PROPERTY_CREATION_DATE, BsBrief.JSON_PROPERTY_CUSTOMER_ADMIN_DATA,
    BsBrief.JSON_PROPERTY_CUSTOMS, BsBrief.JSON_PROPERTY_DOMAINS, BsBrief.JSON_PROPERTY_DW_FRAME,
    BsBrief.JSON_PROPERTY_GPS_RECEIVER_CONFIG, BsBrief.JSON_PROPERTY_GPS_SYNC, BsBrief.JSON_PROPERTY_HEALTH_STATE,
    BsBrief.JSON_PROPERTY_HREF, BsBrief.JSON_PROPERTY_INTS, BsBrief.JSON_PROPERTY_ISM_BAND,
    BsBrief.JSON_PROPERTY_LAST_REBOOT, BsBrief.JSON_PROPERTY_LAST_REPORT, BsBrief.JSON_PROPERTY_LAT,
    BsBrief.JSON_PROPERTY_LOCATION_TYPE, BsBrief.JSON_PROPERTY_LON, BsBrief.JSON_PROPERTY_LRR_I_D,
    BsBrief.JSON_PROPERTY_LRR_U_U_I_D, BsBrief.JSON_PROPERTY_MFS, BsBrief.JSON_PROPERTY_MODEL,
    BsBrief.JSON_PROPERTY_NAME, BsBrief.JSON_PROPERTY_POWER, BsBrief.JSON_PROPERTY_RAM,
    BsBrief.JSON_PROPERTY_RF_HARDWARE_CONFIG, BsBrief.JSON_PROPERTY_STATE, BsBrief.JSON_PROPERTY_STATE_SINCE,
    BsBrief.JSON_PROPERTY_TAGS, BsBrief.JSON_PROPERTY_TIME_SYNC, BsBrief.JSON_PROPERTY_UP_FRAME,
    BsBrief.JSON_PROPERTY_VENDOR, BsBrief.JSON_PROPERTY_VERSION, BsBrief.JSON_PROPERTY_RF_REGION_I_D })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-31T16:08:44.630492043+02:00[Europe/Paris]", comments = "Generator version: 7.6.0")
@JsonIgnoreProperties(ignoreUnknown = true)
public class BsBrief {
  public static final String JSON_PROPERTY_ACTIVATE_BEACON_TRANSMISSION = "activateBeaconTransmission";
  private Boolean activateBeaconTransmission;

  /**
   * Active RX2 optimization Note: Null is returned after the upgrade to ThingPark
   * 7.0 until the base station transmit one configuration report.
   */
  public enum ActivateRX2OptimizationEnum {
    NUMBER_0(0),

    NUMBER_1(1);

    private Integer value;

    ActivateRX2OptimizationEnum(Integer value) {
      this.value = value;
    }

    @JsonValue
    public Integer getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ActivateRX2OptimizationEnum fromValue(Integer value) {
      for (ActivateRX2OptimizationEnum b : ActivateRX2OptimizationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ACTIVATE_R_X2_OPTIMIZATION = "activateRX2Optimization";
  private ActivateRX2OptimizationEnum activateRX2Optimization;

  public static final String JSON_PROPERTY_ALARM1 = "alarm1";
  private Integer alarm1;

  public static final String JSON_PROPERTY_ALARM2 = "alarm2";
  private Integer alarm2;

  public static final String JSON_PROPERTY_ALARM3 = "alarm3";
  private Integer alarm3;

  public static final String JSON_PROPERTY_ALARM4 = "alarm4";
  private Integer alarm4;

  public static final String JSON_PROPERTY_ALARM5 = "alarm5";
  private Integer alarm5;

  public static final String JSON_PROPERTY_ALARM6 = "alarm6";
  private Integer alarm6;

  public static final String JSON_PROPERTY_ALARM_COUNT = "alarmCount";
  private Integer alarmCount;

  public static final String JSON_PROPERTY_ALARM_LEVEL = "alarmLevel";
  private Integer alarmLevel;

  public static final String JSON_PROPERTY_ALLOW_CLASS_B = "allowClassB";
  private Boolean allowClassB;

  public static final String JSON_PROPERTY_ALT = "alt";
  private Integer alt;

  public static final String JSON_PROPERTY_ANTS = "ants";
  private BsBriefAnts ants;

  public static final String JSON_PROPERTY_APP_SERVERS = "appServers";
  private List<BsAppServersInner> appServers = new ArrayList<>();

  public static final String JSON_PROPERTY_BEACONS = "beacons";
  private BsBriefBeacons beacons;

  public static final String JSON_PROPERTY_BS_SECURITY = "bsSecurity";
  private BsBriefBsSecurity bsSecurity;

  public static final String JSON_PROPERTY_CLASS_B_STATE = "classBState";
  private Integer classBState;

  /**
   * Base station connection state: - NEVERCNX: The BS has never been connected. -
   * CNX: The BS has an IEC link started with at least a LRC. - DISC: The BS is
   * disconnected from all LRCs. - UNKNOWN: The BS connection state is currently
   * undefined.
   */
  public enum CnxStateEnum {
    NEVERCNX("NEVERCNX"),

    CNX("CNX"),

    DISC("DISC"),

    UNKNOWN("UNKNOWN");

    private String value;

    CnxStateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CnxStateEnum fromValue(String value) {
      for (CnxStateEnum b : CnxStateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CNX_STATE = "cnxState";
  private CnxStateEnum cnxState;

  public static final String JSON_PROPERTY_CNX_STATE_SINCE = "cnxStateSince";
  private Long cnxStateSince;

  public static final String JSON_PROPERTY_CPU = "cpu";
  private Integer cpu;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private Long creationDate;

  public static final String JSON_PROPERTY_CUSTOMER_ADMIN_DATA = "customerAdminData";
  private String customerAdminData;

  public static final String JSON_PROPERTY_CUSTOMS = "customs";
  private BsBriefCustoms customs;

  public static final String JSON_PROPERTY_DOMAINS = "domains";
  private List<Domain> domains = new ArrayList<>();

  public static final String JSON_PROPERTY_DW_FRAME = "dwFrame";
  private BsBriefDwFrame dwFrame;

  /**
   * GPS receiver configuration: - PRESENT (i.e. Present and used) - ABSENT (i.e.
   * Absent or not used) Default: Inherited from the BS profile
   */
  public enum GpsReceiverConfigEnum {
    PRESENT("PRESENT"),

    ABSENT("ABSENT");

    private String value;

    GpsReceiverConfigEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GpsReceiverConfigEnum fromValue(String value) {
      for (GpsReceiverConfigEnum b : GpsReceiverConfigEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GPS_RECEIVER_CONFIG = "gpsReceiverConfig";
  private GpsReceiverConfigEnum gpsReceiverConfig;

  public static final String JSON_PROPERTY_GPS_SYNC = "gpsSync";
  private Integer gpsSync;

  public static final String JSON_PROPERTY_HEALTH_STATE = "healthState";
  private BsHealthState healthState;

  public static final String JSON_PROPERTY_HREF = "href";
  private String href;

  public static final String JSON_PROPERTY_INTS = "ints";
  private BsBriefInts ints;

  public static final String JSON_PROPERTY_ISM_BAND = "ismBand";
  private IsmBandID ismBand;

  public static final String JSON_PROPERTY_LAST_REBOOT = "lastReboot";
  private Long lastReboot;

  public static final String JSON_PROPERTY_LAST_REPORT = "lastReport";
  private Long lastReport;

  public static final String JSON_PROPERTY_LAT = "lat";
  private Float lat;

  public static final String JSON_PROPERTY_LOCATION_TYPE = "locationType";
  private Integer locationType;

  public static final String JSON_PROPERTY_LON = "lon";
  private Float lon;

  public static final String JSON_PROPERTY_LRR_I_D = "lrrID";
  private String lrrID;

  public static final String JSON_PROPERTY_LRR_U_U_I_D = "lrrUUID";
  private String lrrUUID;

  public static final String JSON_PROPERTY_MFS = "mfs";
  private List<BsMfsMfsInner> mfs = new ArrayList<>();

  public static final String JSON_PROPERTY_MODEL = "model";
  private BsBriefModel model;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_POWER = "power";
  private BsBriefPower power;

  public static final String JSON_PROPERTY_RAM = "ram";
  private Integer ram;

  /**
   * RF hardware configuration: - &#x60;S1_A1_B1&#x60;: 1 sector, 1 antenna, 1
   * board (mono-sector 1\\*8 or 1\\*16) - &#x60;S1_A2_B1&#x60;: 1 sector, 2
   * antennas, 1 board (mono-sector 2\\*8) - &#x60;S1_A2_B2&#x60;: 1 sector, 2
   * antennas, 2 boards (mono-sector 2\\*16) - &#x60;S1_A1_B4&#x60;: 1 sector, 1
   * antennas, 4 boards (mono-sector 1\\*64) - &#x60;S3_A3_B3&#x60;: 3 sectors, 3
   * antennas, 3 boards (tri-sectors 1\\*8 or 1\\*16) Note: Null is returned after
   * the upgrade to ThingPark 7.0 until the base station transmit one
   * configuration report.
   */
  public enum RfHardwareConfigEnum {
    S1_A1_B1("S1_A1_B1"),

    S1_A2_B1("S1_A2_B1"),

    S1_A2_B2("S1_A2_B2"),

    S1_A1_B4("S1_A1_B4"),

    S3_A3_B3("S3_A3_B3");

    private String value;

    RfHardwareConfigEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RfHardwareConfigEnum fromValue(String value) {
      for (RfHardwareConfigEnum b : RfHardwareConfigEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RF_HARDWARE_CONFIG = "rfHardwareConfig";
  private RfHardwareConfigEnum rfHardwareConfig;

  public static final String JSON_PROPERTY_STATE = "state";
  private BsState state;

  public static final String JSON_PROPERTY_STATE_SINCE = "stateSince";
  private Long stateSince;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<BsBriefTagsInner> tags = new ArrayList<>();

  public static final String JSON_PROPERTY_TIME_SYNC = "timeSync";
  private Integer timeSync;

  public static final String JSON_PROPERTY_UP_FRAME = "upFrame";
  private BsBriefUpFrame upFrame;

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private BsBriefVendor vendor;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public static final String JSON_PROPERTY_RF_REGION_I_D = "rfRegionID";
  private String rfRegionID;

  public BsBrief() {
  }

  public BsBrief activateBeaconTransmission(Boolean activateBeaconTransmission) {

    this.activateBeaconTransmission = activateBeaconTransmission;
    return this;
  }

  /**
   * Activate beacon transmission Note: Null is returned after the upgrade to
   * ThingPark 7.0 until the base station transmit one configuration report.
   * 
   * @return activateBeaconTransmission
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVATE_BEACON_TRANSMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActivateBeaconTransmission() {
    return activateBeaconTransmission;
  }

  @JsonProperty(JSON_PROPERTY_ACTIVATE_BEACON_TRANSMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivateBeaconTransmission(Boolean activateBeaconTransmission) {
    this.activateBeaconTransmission = activateBeaconTransmission;
  }

  public BsBrief activateRX2Optimization(ActivateRX2OptimizationEnum activateRX2Optimization) {

    this.activateRX2Optimization = activateRX2Optimization;
    return this;
  }

  /**
   * Active RX2 optimization Note: Null is returned after the upgrade to ThingPark
   * 7.0 until the base station transmit one configuration report.
   * 
   * @return activateRX2Optimization
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVATE_R_X2_OPTIMIZATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ActivateRX2OptimizationEnum getActivateRX2Optimization() {
    return activateRX2Optimization;
  }

  @JsonProperty(JSON_PROPERTY_ACTIVATE_R_X2_OPTIMIZATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivateRX2Optimization(ActivateRX2OptimizationEnum activateRX2Optimization) {
    this.activateRX2Optimization = activateRX2Optimization;
  }

  public BsBrief alarm1(Integer alarm1) {

    this.alarm1 = alarm1;
    return this;
  }

  /**
   * Number of CLEARED alarms not ACKED
   * 
   * @return alarm1
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAlarm1() {
    return alarm1;
  }

  @JsonProperty(JSON_PROPERTY_ALARM1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAlarm1(Integer alarm1) {
    this.alarm1 = alarm1;
  }

  public BsBrief alarm2(Integer alarm2) {

    this.alarm2 = alarm2;
    return this;
  }

  /**
   * Number of INDETERMINATE alarms not ACKED
   * 
   * @return alarm2
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM2)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAlarm2() {
    return alarm2;
  }

  @JsonProperty(JSON_PROPERTY_ALARM2)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAlarm2(Integer alarm2) {
    this.alarm2 = alarm2;
  }

  public BsBrief alarm3(Integer alarm3) {

    this.alarm3 = alarm3;
    return this;
  }

  /**
   * Number of WARNING alarms not ACKED
   * 
   * @return alarm3
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM3)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAlarm3() {
    return alarm3;
  }

  @JsonProperty(JSON_PROPERTY_ALARM3)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAlarm3(Integer alarm3) {
    this.alarm3 = alarm3;
  }

  public BsBrief alarm4(Integer alarm4) {

    this.alarm4 = alarm4;
    return this;
  }

  /**
   * Number of MINOR alarms not ACKED
   * 
   * @return alarm4
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM4)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAlarm4() {
    return alarm4;
  }

  @JsonProperty(JSON_PROPERTY_ALARM4)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAlarm4(Integer alarm4) {
    this.alarm4 = alarm4;
  }

  public BsBrief alarm5(Integer alarm5) {

    this.alarm5 = alarm5;
    return this;
  }

  /**
   * Number of MAJOR alarms not ACKED
   * 
   * @return alarm5
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM5)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAlarm5() {
    return alarm5;
  }

  @JsonProperty(JSON_PROPERTY_ALARM5)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAlarm5(Integer alarm5) {
    this.alarm5 = alarm5;
  }

  public BsBrief alarm6(Integer alarm6) {

    this.alarm6 = alarm6;
    return this;
  }

  /**
   * Number of CRITICAL alarms not ACKED
   * 
   * @return alarm6
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM6)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAlarm6() {
    return alarm6;
  }

  @JsonProperty(JSON_PROPERTY_ALARM6)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAlarm6(Integer alarm6) {
    this.alarm6 = alarm6;
  }

  public BsBrief alarmCount(Integer alarmCount) {

    this.alarmCount = alarmCount;
    return this;
  }

  /**
   * Total number of alarm not acked
   * 
   * @return alarmCount
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAlarmCount() {
    return alarmCount;
  }

  @JsonProperty(JSON_PROPERTY_ALARM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAlarmCount(Integer alarmCount) {
    this.alarmCount = alarmCount;
  }

  public BsBrief alarmLevel(Integer alarmLevel) {

    this.alarmLevel = alarmLevel;
    return this;
  }

  /**
   * Highest not acked alarm level (6 ... 1) or 0 when the BS is not associated
   * with not acked alarm
   * 
   * @return alarmLevel
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAlarmLevel() {
    return alarmLevel;
  }

  @JsonProperty(JSON_PROPERTY_ALARM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAlarmLevel(Integer alarmLevel) {
    this.alarmLevel = alarmLevel;
  }

  public BsBrief allowClassB(Boolean allowClassB) {

    this.allowClassB = allowClassB;
    return this;
  }

  /**
   * Allow Class B Note: Null is returned after the upgrade to ThingPark 7.0 until
   * the base station transmit one configuration report. This parameter must no
   * longer be used: it is ignored and always set to true.
   * 
   * @return allowClassB
   * @deprecated
   **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALLOW_CLASS_B)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowClassB() {
    return allowClassB;
  }

  @JsonProperty(JSON_PROPERTY_ALLOW_CLASS_B)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowClassB(Boolean allowClassB) {
    this.allowClassB = allowClassB;
  }

  public BsBrief alt(Integer alt) {

    this.alt = alt;
    return this;
  }

  /**
   * Network or administrative BS absolute altitude (according to the type of
   * location currently activated)
   * 
   * @return alt
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAlt() {
    return alt;
  }

  @JsonProperty(JSON_PROPERTY_ALT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlt(Integer alt) {
    this.alt = alt;
  }

  public BsBrief ants(BsBriefAnts ants) {

    this.ants = ants;
    return this;
  }

  /**
   * Get ants
   * 
   * @return ants
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsBriefAnts getAnts() {
    return ants;
  }

  @JsonProperty(JSON_PROPERTY_ANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnts(BsBriefAnts ants) {
    this.ants = ants;
  }

  public BsBrief appServers(List<BsAppServersInner> appServers) {

    this.appServers = appServers;
    return this;
  }

  public BsBrief addAppServersItem(BsAppServersInner appServersItem) {
    if (this.appServers == null) {
      this.appServers = new ArrayList<>();
    }
    this.appServers.add(appServersItem);
    return this;
  }

  /**
   * List of application servers associated with the base station for alarms
   * reporting purposes. Only supported if the partner&#39;s type is
   * &#x60;SUBSCRIBER&#x60;: associated applications servers must belong to the
   * same subscriber account and must be of type Kafka. If the authenticated user
   * has domain restrictions, only the following application servers can be
   * associated with a base station: - Application servers not associated with any
   * domain - Application servers associated with domains and matching the domain
   * restrictions
   * 
   * @return appServers
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_APP_SERVERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BsAppServersInner> getAppServers() {
    return appServers;
  }

  @JsonProperty(JSON_PROPERTY_APP_SERVERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppServers(List<BsAppServersInner> appServers) {
    this.appServers = appServers;
  }

  public BsBrief beacons(BsBriefBeacons beacons) {

    this.beacons = beacons;
    return this;
  }

  /**
   * Get beacons
   * 
   * @return beacons
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BEACONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsBriefBeacons getBeacons() {
    return beacons;
  }

  @JsonProperty(JSON_PROPERTY_BEACONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeacons(BsBriefBeacons beacons) {
    this.beacons = beacons;
  }

  public BsBrief bsSecurity(BsBriefBsSecurity bsSecurity) {

    this.bsSecurity = bsSecurity;
    return this;
  }

  /**
   * Get bsSecurity
   * 
   * @return bsSecurity
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BS_SECURITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsBriefBsSecurity getBsSecurity() {
    return bsSecurity;
  }

  @JsonProperty(JSON_PROPERTY_BS_SECURITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBsSecurity(BsBriefBsSecurity bsSecurity) {
    this.bsSecurity = bsSecurity;
  }

  public BsBrief classBState(Integer classBState) {

    this.classBState = classBState;
    return this;
  }

  /**
   * Class B state: - Not supported (0) - Supported but not operational (1) -
   * Supported and operational (2) - Unknown because of disconnected Base Station
   * (null)
   * 
   * @return classBState
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CLASS_B_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getClassBState() {
    return classBState;
  }

  @JsonProperty(JSON_PROPERTY_CLASS_B_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClassBState(Integer classBState) {
    this.classBState = classBState;
  }

  public BsBrief cnxState(CnxStateEnum cnxState) {

    this.cnxState = cnxState;
    return this;
  }

  /**
   * Base station connection state: - NEVERCNX: The BS has never been connected. -
   * CNX: The BS has an IEC link started with at least a LRC. - DISC: The BS is
   * disconnected from all LRCs. - UNKNOWN: The BS connection state is currently
   * undefined.
   * 
   * @return cnxState
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CNX_STATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CnxStateEnum getCnxState() {
    return cnxState;
  }

  @JsonProperty(JSON_PROPERTY_CNX_STATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCnxState(CnxStateEnum cnxState) {
    this.cnxState = cnxState;
  }

  public BsBrief cnxStateSince(Long cnxStateSince) {

    this.cnxStateSince = cnxStateSince;
    return this;
  }

  /**
   * Base station connection state reached since timestamp when the BS has already
   * been connected, epoch time in milliseconds.
   * 
   * @return cnxStateSince
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CNX_STATE_SINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCnxStateSince() {
    return cnxStateSince;
  }

  @JsonProperty(JSON_PROPERTY_CNX_STATE_SINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCnxStateSince(Long cnxStateSince) {
    this.cnxStateSince = cnxStateSince;
  }

  public BsBrief cpu(Integer cpu) {

    this.cpu = cpu;
    return this;
  }

  /**
   * CPU usage (%)
   * 
   * @return cpu
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CPU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCpu() {
    return cpu;
  }

  @JsonProperty(JSON_PROPERTY_CPU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCpu(Integer cpu) {
    this.cpu = cpu;
  }

  public BsBrief creationDate(Long creationDate) {

    this.creationDate = creationDate;
    return this;
  }

  /**
   * Base station creation date, epoch time in milliseconds.
   * 
   * @return creationDate
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getCreationDate() {
    return creationDate;
  }

  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreationDate(Long creationDate) {
    this.creationDate = creationDate;
  }

  public BsBrief customerAdminData(String customerAdminData) {

    this.customerAdminData = customerAdminData;
    return this;
  }

  /**
   * BS administrative info Note: Null is returned after the upgrade to ThingPark
   * 7.0 until the base station transmit one configuration report.
   * 
   * @return customerAdminData
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMER_ADMIN_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerAdminData() {
    return customerAdminData;
  }

  @JsonProperty(JSON_PROPERTY_CUSTOMER_ADMIN_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerAdminData(String customerAdminData) {
    this.customerAdminData = customerAdminData;
  }

  public BsBrief customs(BsBriefCustoms customs) {

    this.customs = customs;
    return this;
  }

  /**
   * Get customs
   * 
   * @return customs
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsBriefCustoms getCustoms() {
    return customs;
  }

  @JsonProperty(JSON_PROPERTY_CUSTOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustoms(BsBriefCustoms customs) {
    this.customs = customs;
  }

  public BsBrief domains(List<Domain> domains) {

    this.domains = domains;
    return this;
  }

  public BsBrief addDomainsItem(Domain domainsItem) {
    if (this.domains == null) {
      this.domains = new ArrayList<>();
    }
    this.domains.add(domainsItem);
    return this;
  }

  /**
   * List of domains associated with the Base Station. The list cannot contain
   * more than one domain for a given group. Only supported if the partner&#39;s
   * type is &#x60;SUBSCRIBER&#x60;.
   * 
   * @return domains
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOMAINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Domain> getDomains() {
    return domains;
  }

  @JsonProperty(JSON_PROPERTY_DOMAINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomains(List<Domain> domains) {
    this.domains = domains;
  }

  public BsBrief dwFrame(BsBriefDwFrame dwFrame) {

    this.dwFrame = dwFrame;
    return this;
  }

  /**
   * Get dwFrame
   * 
   * @return dwFrame
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DW_FRAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsBriefDwFrame getDwFrame() {
    return dwFrame;
  }

  @JsonProperty(JSON_PROPERTY_DW_FRAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDwFrame(BsBriefDwFrame dwFrame) {
    this.dwFrame = dwFrame;
  }

  public BsBrief gpsReceiverConfig(GpsReceiverConfigEnum gpsReceiverConfig) {

    this.gpsReceiverConfig = gpsReceiverConfig;
    return this;
  }

  /**
   * GPS receiver configuration: - PRESENT (i.e. Present and used) - ABSENT (i.e.
   * Absent or not used) Default: Inherited from the BS profile
   * 
   * @return gpsReceiverConfig
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GPS_RECEIVER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GpsReceiverConfigEnum getGpsReceiverConfig() {
    return gpsReceiverConfig;
  }

  @JsonProperty(JSON_PROPERTY_GPS_RECEIVER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGpsReceiverConfig(GpsReceiverConfigEnum gpsReceiverConfig) {
    this.gpsReceiverConfig = gpsReceiverConfig;
  }

  public BsBrief gpsSync(Integer gpsSync) {

    this.gpsSync = gpsSync;
    return this;
  }

  /**
   * GPS receiver synchronization status: - Locking/No signal (0) - Locked (1) -
   * Unknown because of disconnected Base Station (null)
   * 
   * @return gpsSync
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GPS_SYNC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGpsSync() {
    return gpsSync;
  }

  @JsonProperty(JSON_PROPERTY_GPS_SYNC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGpsSync(Integer gpsSync) {
    this.gpsSync = gpsSync;
  }

  public BsBrief healthState(BsHealthState healthState) {

    this.healthState = healthState;
    return this;
  }

  /**
   * Get healthState
   * 
   * @return healthState
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_HEALTH_STATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BsHealthState getHealthState() {
    return healthState;
  }

  @JsonProperty(JSON_PROPERTY_HEALTH_STATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHealthState(BsHealthState healthState) {
    this.healthState = healthState;
  }

  public BsBrief href(String href) {

    this.href = href;
    return this;
  }

  /**
   * Base station href
   * 
   * @return href
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHref() {
    return href;
  }

  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHref(String href) {
    this.href = href;
  }

  public BsBrief ints(BsBriefInts ints) {

    this.ints = ints;
    return this;
  }

  /**
   * Get ints
   * 
   * @return ints
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_INTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BsBriefInts getInts() {
    return ints;
  }

  @JsonProperty(JSON_PROPERTY_INTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInts(BsBriefInts ints) {
    this.ints = ints;
  }

  public BsBrief ismBand(IsmBandID ismBand) {

    this.ismBand = ismBand;
    return this;
  }

  /**
   * Get ismBand
   * 
   * @return ismBand
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ISM_BAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IsmBandID getIsmBand() {
    return ismBand;
  }

  @JsonProperty(JSON_PROPERTY_ISM_BAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsmBand(IsmBandID ismBand) {
    this.ismBand = ismBand;
  }

  public BsBrief lastReboot(Long lastReboot) {

    this.lastReboot = lastReboot;
    return this;
  }

  /**
   * Last reboot timestamp of the BS (**software uptime**), epoch time in
   * milliseconds
   * 
   * @return lastReboot
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_REBOOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getLastReboot() {
    return lastReboot;
  }

  @JsonProperty(JSON_PROPERTY_LAST_REBOOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastReboot(Long lastReboot) {
    this.lastReboot = lastReboot;
  }

  public BsBrief lastReport(Long lastReport) {

    this.lastReport = lastReport;
    return this;
  }

  /**
   * Last report timestamp, epoch time in milliseconds
   * 
   * @return lastReport
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getLastReport() {
    return lastReport;
  }

  @JsonProperty(JSON_PROPERTY_LAST_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastReport(Long lastReport) {
    this.lastReport = lastReport;
  }

  public BsBrief lat(Float lat) {

    this.lat = lat;
    return this;
  }

  /**
   * Network or administrative BS location (according to the type of location
   * currently activated)
   * 
   * @return lat
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLat() {
    return lat;
  }

  @JsonProperty(JSON_PROPERTY_LAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLat(Float lat) {
    this.lat = lat;
  }

  public BsBrief locationType(Integer locationType) {

    this.locationType = locationType;
    return this;
  }

  /**
   * Type of location currently activated (Unknown:0 or Administrative:1 or GPS:2)
   * 
   * @return locationType
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOCATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLocationType() {
    return locationType;
  }

  @JsonProperty(JSON_PROPERTY_LOCATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationType(Integer locationType) {
    this.locationType = locationType;
  }

  public BsBrief lon(Float lon) {

    this.lon = lon;
    return this;
  }

  /**
   * Network or administrative BS location (according to the type of location
   * currently activated)
   * 
   * @return lon
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLon() {
    return lon;
  }

  @JsonProperty(JSON_PROPERTY_LON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLon(Float lon) {
    this.lon = lon;
  }

  public BsBrief lrrID(String lrrID) {

    this.lrrID = lrrID;
    return this;
  }

  /**
   * LRR ID: 8 hexadecimal characters / always converted in upper case by the
   * server
   * 
   * @return lrrID
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LRR_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLrrID() {
    return lrrID;
  }

  @JsonProperty(JSON_PROPERTY_LRR_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLrrID(String lrrID) {
    this.lrrID = lrrID;
  }

  public BsBrief lrrUUID(String lrrUUID) {

    this.lrrUUID = lrrUUID;
    return this;
  }

  /**
   * BS LRR UUID: &lt;LRR-OUI&gt;-&lt;LRR-GID&gt; Where: - &lt;LRR-OUI&gt; is the
   * IEEE OUI of the Base station manufacturer (6 hexadecimal characters / always
   * converted in upper case by the server) - &lt;LRR-GID&gt; is the Base Station
   * identifier relatively to the vendor (maximum 48 hexadecimal characters /
   * always converted in upper case by the server)
   * 
   * @return lrrUUID
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LRR_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLrrUUID() {
    return lrrUUID;
  }

  @JsonProperty(JSON_PROPERTY_LRR_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLrrUUID(String lrrUUID) {
    this.lrrUUID = lrrUUID;
  }

  public BsBrief mfs(List<BsMfsMfsInner> mfs) {

    this.mfs = mfs;
    return this;
  }

  public BsBrief addMfsItem(BsMfsMfsInner mfsItem) {
    if (this.mfs == null) {
      this.mfs = new ArrayList<>();
    }
    this.mfs.add(mfsItem);
    return this;
  }

  /**
   * Mounted filesystems of the base station. Empty until the configuration is
   * reported by the base station.
   * 
   * @return mfs
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MFS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BsMfsMfsInner> getMfs() {
    return mfs;
  }

  @JsonProperty(JSON_PROPERTY_MFS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMfs(List<BsMfsMfsInner> mfs) {
    this.mfs = mfs;
  }

  public BsBrief model(BsBriefModel model) {

    this.model = model;
    return this;
  }

  /**
   * Get model
   * 
   * @return model
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MODEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BsBriefModel getModel() {
    return model;
  }

  @JsonProperty(JSON_PROPERTY_MODEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModel(BsBriefModel model) {
    this.model = model;
  }

  public BsBrief name(String name) {

    this.name = name;
    return this;
  }

  /**
   * BS name
   * 
   * @return name
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }

  public BsBrief power(BsBriefPower power) {

    this.power = power;
    return this;
  }

  /**
   * Get power
   * 
   * @return power
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POWER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsBriefPower getPower() {
    return power;
  }

  @JsonProperty(JSON_PROPERTY_POWER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPower(BsBriefPower power) {
    this.power = power;
  }

  public BsBrief ram(Integer ram) {

    this.ram = ram;
    return this;
  }

  /**
   * RAM usage (%)
   * 
   * @return ram
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RAM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRam() {
    return ram;
  }

  @JsonProperty(JSON_PROPERTY_RAM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRam(Integer ram) {
    this.ram = ram;
  }

  public BsBrief rfHardwareConfig(RfHardwareConfigEnum rfHardwareConfig) {

    this.rfHardwareConfig = rfHardwareConfig;
    return this;
  }

  /**
   * RF hardware configuration: - &#x60;S1_A1_B1&#x60;: 1 sector, 1 antenna, 1
   * board (mono-sector 1\\*8 or 1\\*16) - &#x60;S1_A2_B1&#x60;: 1 sector, 2
   * antennas, 1 board (mono-sector 2\\*8) - &#x60;S1_A2_B2&#x60;: 1 sector, 2
   * antennas, 2 boards (mono-sector 2\\*16) - &#x60;S1_A1_B4&#x60;: 1 sector, 1
   * antennas, 4 boards (mono-sector 1\\*64) - &#x60;S3_A3_B3&#x60;: 3 sectors, 3
   * antennas, 3 boards (tri-sectors 1\\*8 or 1\\*16) Note: Null is returned after
   * the upgrade to ThingPark 7.0 until the base station transmit one
   * configuration report.
   * 
   * @return rfHardwareConfig
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RF_HARDWARE_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RfHardwareConfigEnum getRfHardwareConfig() {
    return rfHardwareConfig;
  }

  @JsonProperty(JSON_PROPERTY_RF_HARDWARE_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRfHardwareConfig(RfHardwareConfigEnum rfHardwareConfig) {
    this.rfHardwareConfig = rfHardwareConfig;
  }

  public BsBrief state(BsState state) {

    this.state = state;
    return this;
  }

  /**
   * Get state
   * 
   * @return state
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BsState getState() {
    return state;
  }

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setState(BsState state) {
    this.state = state;
  }

  public BsBrief stateSince(Long stateSince) {

    this.stateSince = stateSince;
    return this;
  }

  /**
   * Base station admin state reached since timestamp, epoch time in milliseconds.
   * 
   * @return stateSince
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATE_SINCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getStateSince() {
    return stateSince;
  }

  @JsonProperty(JSON_PROPERTY_STATE_SINCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStateSince(Long stateSince) {
    this.stateSince = stateSince;
  }

  public BsBrief tags(List<BsBriefTagsInner> tags) {

    this.tags = tags;
    return this;
  }

  public BsBrief addTagsItem(BsBriefTagsInner tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags associated with the Base Station
   * 
   * @return tags
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BsBriefTagsInner> getTags() {
    return tags;
  }

  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTags(List<BsBriefTagsInner> tags) {
    this.tags = tags;
  }

  public BsBrief timeSync(Integer timeSync) {

    this.timeSync = timeSync;
    return this;
  }

  /**
   * Time synchronization status: - Local / Not synchronized (0) - NTP (1) - NTP
   * sync with GPS (2) - Radio sync with GPS (3) - Unknown because of disconnected
   * Base Station (null)
   * 
   * @return timeSync
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TIME_SYNC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTimeSync() {
    return timeSync;
  }

  @JsonProperty(JSON_PROPERTY_TIME_SYNC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeSync(Integer timeSync) {
    this.timeSync = timeSync;
  }

  public BsBrief upFrame(BsBriefUpFrame upFrame) {

    this.upFrame = upFrame;
    return this;
  }

  /**
   * Get upFrame
   * 
   * @return upFrame
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UP_FRAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsBriefUpFrame getUpFrame() {
    return upFrame;
  }

  @JsonProperty(JSON_PROPERTY_UP_FRAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpFrame(BsBriefUpFrame upFrame) {
    this.upFrame = upFrame;
  }

  public BsBrief vendor(BsBriefVendor vendor) {

    this.vendor = vendor;
    return this;
  }

  /**
   * Get vendor
   * 
   * @return vendor
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BsBriefVendor getVendor() {
    return vendor;
  }

  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(BsBriefVendor vendor) {
    this.vendor = vendor;
  }

  public BsBrief version(String version) {

    this.version = version;
    return this;
  }

  /**
   * Software version of the BS
   * 
   * @return version
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(String version) {
    this.version = version;
  }

  public BsBrief rfRegionID(String rfRegionID) {

    this.rfRegionID = rfRegionID;
    return this;
  }

  /**
   * RF Region provisioning ID
   * 
   * @return rfRegionID
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RF_REGION_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRfRegionID() {
    return rfRegionID;
  }

  @JsonProperty(JSON_PROPERTY_RF_REGION_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRfRegionID(String rfRegionID) {
    this.rfRegionID = rfRegionID;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BsBrief bsBrief = (BsBrief) o;
    return Objects.equals(this.activateBeaconTransmission, bsBrief.activateBeaconTransmission)
            && Objects.equals(this.activateRX2Optimization, bsBrief.activateRX2Optimization)
            && Objects.equals(this.alarm1, bsBrief.alarm1) && Objects.equals(this.alarm2, bsBrief.alarm2)
            && Objects.equals(this.alarm3, bsBrief.alarm3) && Objects.equals(this.alarm4, bsBrief.alarm4)
            && Objects.equals(this.alarm5, bsBrief.alarm5) && Objects.equals(this.alarm6, bsBrief.alarm6)
            && Objects.equals(this.alarmCount, bsBrief.alarmCount)
            && Objects.equals(this.alarmLevel, bsBrief.alarmLevel)
            && Objects.equals(this.allowClassB, bsBrief.allowClassB) && Objects.equals(this.alt, bsBrief.alt)
            && Objects.equals(this.ants, bsBrief.ants) && Objects.equals(this.appServers, bsBrief.appServers)
            && Objects.equals(this.beacons, bsBrief.beacons) && Objects.equals(this.bsSecurity, bsBrief.bsSecurity)
            && Objects.equals(this.classBState, bsBrief.classBState) && Objects.equals(this.cnxState, bsBrief.cnxState)
            && Objects.equals(this.cnxStateSince, bsBrief.cnxStateSince) && Objects.equals(this.cpu, bsBrief.cpu)
            && Objects.equals(this.creationDate, bsBrief.creationDate)
            && Objects.equals(this.customerAdminData, bsBrief.customerAdminData)
            && Objects.equals(this.customs, bsBrief.customs) && Objects.equals(this.domains, bsBrief.domains)
            && Objects.equals(this.dwFrame, bsBrief.dwFrame)
            && Objects.equals(this.gpsReceiverConfig, bsBrief.gpsReceiverConfig)
            && Objects.equals(this.gpsSync, bsBrief.gpsSync) && Objects.equals(this.healthState, bsBrief.healthState)
            && Objects.equals(this.href, bsBrief.href) && Objects.equals(this.ints, bsBrief.ints)
            && Objects.equals(this.ismBand, bsBrief.ismBand) && Objects.equals(this.lastReboot, bsBrief.lastReboot)
            && Objects.equals(this.lastReport, bsBrief.lastReport) && Objects.equals(this.lat, bsBrief.lat)
            && Objects.equals(this.locationType, bsBrief.locationType) && Objects.equals(this.lon, bsBrief.lon)
            && Objects.equals(this.lrrID, bsBrief.lrrID) && Objects.equals(this.lrrUUID, bsBrief.lrrUUID)
            && Objects.equals(this.mfs, bsBrief.mfs) && Objects.equals(this.model, bsBrief.model)
            && Objects.equals(this.name, bsBrief.name) && Objects.equals(this.power, bsBrief.power)
            && Objects.equals(this.ram, bsBrief.ram) && Objects.equals(this.rfHardwareConfig, bsBrief.rfHardwareConfig)
            && Objects.equals(this.state, bsBrief.state) && Objects.equals(this.stateSince, bsBrief.stateSince)
            && Objects.equals(this.tags, bsBrief.tags) && Objects.equals(this.timeSync, bsBrief.timeSync)
            && Objects.equals(this.upFrame, bsBrief.upFrame) && Objects.equals(this.vendor, bsBrief.vendor)
            && Objects.equals(this.version, bsBrief.version) && Objects.equals(this.rfRegionID, bsBrief.rfRegionID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activateBeaconTransmission, activateRX2Optimization, alarm1, alarm2, alarm3, alarm4, alarm5,
            alarm6, alarmCount, alarmLevel, allowClassB, alt, ants, appServers, beacons, bsSecurity, classBState,
            cnxState, cnxStateSince, cpu, creationDate, customerAdminData, customs, domains, dwFrame, gpsReceiverConfig,
            gpsSync, healthState, href, ints, ismBand, lastReboot, lastReport, lat, locationType, lon, lrrID, lrrUUID,
            mfs, model, name, power, ram, rfHardwareConfig, state, stateSince, tags, timeSync, upFrame, vendor, version,
            rfRegionID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BsBrief {\n");
    sb.append("    activateBeaconTransmission: ").append(toIndentedString(activateBeaconTransmission)).append("\n");
    sb.append("    activateRX2Optimization: ").append(toIndentedString(activateRX2Optimization)).append("\n");
    sb.append("    alarm1: ").append(toIndentedString(alarm1)).append("\n");
    sb.append("    alarm2: ").append(toIndentedString(alarm2)).append("\n");
    sb.append("    alarm3: ").append(toIndentedString(alarm3)).append("\n");
    sb.append("    alarm4: ").append(toIndentedString(alarm4)).append("\n");
    sb.append("    alarm5: ").append(toIndentedString(alarm5)).append("\n");
    sb.append("    alarm6: ").append(toIndentedString(alarm6)).append("\n");
    sb.append("    alarmCount: ").append(toIndentedString(alarmCount)).append("\n");
    sb.append("    alarmLevel: ").append(toIndentedString(alarmLevel)).append("\n");
    sb.append("    allowClassB: ").append(toIndentedString(allowClassB)).append("\n");
    sb.append("    alt: ").append(toIndentedString(alt)).append("\n");
    sb.append("    ants: ").append(toIndentedString(ants)).append("\n");
    sb.append("    appServers: ").append(toIndentedString(appServers)).append("\n");
    sb.append("    beacons: ").append(toIndentedString(beacons)).append("\n");
    sb.append("    bsSecurity: ").append(toIndentedString(bsSecurity)).append("\n");
    sb.append("    classBState: ").append(toIndentedString(classBState)).append("\n");
    sb.append("    cnxState: ").append(toIndentedString(cnxState)).append("\n");
    sb.append("    cnxStateSince: ").append(toIndentedString(cnxStateSince)).append("\n");
    sb.append("    cpu: ").append(toIndentedString(cpu)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    customerAdminData: ").append(toIndentedString(customerAdminData)).append("\n");
    sb.append("    customs: ").append(toIndentedString(customs)).append("\n");
    sb.append("    domains: ").append(toIndentedString(domains)).append("\n");
    sb.append("    dwFrame: ").append(toIndentedString(dwFrame)).append("\n");
    sb.append("    gpsReceiverConfig: ").append(toIndentedString(gpsReceiverConfig)).append("\n");
    sb.append("    gpsSync: ").append(toIndentedString(gpsSync)).append("\n");
    sb.append("    healthState: ").append(toIndentedString(healthState)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    ints: ").append(toIndentedString(ints)).append("\n");
    sb.append("    ismBand: ").append(toIndentedString(ismBand)).append("\n");
    sb.append("    lastReboot: ").append(toIndentedString(lastReboot)).append("\n");
    sb.append("    lastReport: ").append(toIndentedString(lastReport)).append("\n");
    sb.append("    lat: ").append(toIndentedString(lat)).append("\n");
    sb.append("    locationType: ").append(toIndentedString(locationType)).append("\n");
    sb.append("    lon: ").append(toIndentedString(lon)).append("\n");
    sb.append("    lrrID: ").append(toIndentedString(lrrID)).append("\n");
    sb.append("    lrrUUID: ").append(toIndentedString(lrrUUID)).append("\n");
    sb.append("    mfs: ").append(toIndentedString(mfs)).append("\n");
    sb.append("    model: ").append(toIndentedString(model)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    power: ").append(toIndentedString(power)).append("\n");
    sb.append("    ram: ").append(toIndentedString(ram)).append("\n");
    sb.append("    rfHardwareConfig: ").append(toIndentedString(rfHardwareConfig)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    stateSince: ").append(toIndentedString(stateSince)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    timeSync: ").append(toIndentedString(timeSync)).append("\n");
    sb.append("    upFrame: ").append(toIndentedString(upFrame)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    rfRegionID: ").append(toIndentedString(rfRegionID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
