/*
 * ThingPark things management Networks API
 * REST interface for networks management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.basestation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

import lora.ns.actility.api.model.common.Domain;
import lora.ns.actility.api.model.common.IsmBandID;
import lora.ns.actility.api.model.common.OccContext;

/**
 * Bs
 */
@JsonPropertyOrder({ Bs.JSON_PROPERTY_ACTIVATE_BEACON_TRANSMISSION, Bs.JSON_PROPERTY_ACTIVATE_R_X2_OPTIMIZATION,
    Bs.JSON_PROPERTY_ACTIVATE_SUPPORT_FOR802154, Bs.JSON_PROPERTY_ADMIN_ALT_GROUND, Bs.JSON_PROPERTY_ALARM1,
    Bs.JSON_PROPERTY_ALARM103, Bs.JSON_PROPERTY_ALARM2, Bs.JSON_PROPERTY_ALARM3, Bs.JSON_PROPERTY_ALARM4,
    Bs.JSON_PROPERTY_ALARM5, Bs.JSON_PROPERTY_ALARM6, Bs.JSON_PROPERTY_ALLOW_CLASS_B, Bs.JSON_PROPERTY_ANTENNAS_CONFIG,
    Bs.JSON_PROPERTY_APP_SERVERS, Bs.JSON_PROPERTY_BACKUP, Bs.JSON_PROPERTY_BS_SECURITY, Bs.JSON_PROPERTY_CLASS_B_STATE,
    Bs.JSON_PROPERTY_CNX_STATE, Bs.JSON_PROPERTY_CNX_STATE_SINCE, Bs.JSON_PROPERTY_CONTACT_INFO, Bs.JSON_PROPERTY_CPU,
    Bs.JSON_PROPERTY_CREATION_DATE, Bs.JSON_PROPERTY_CUSTOMER_ADMIN_DATA, Bs.JSON_PROPERTY_CUSTOMS,
    Bs.JSON_PROPERTY_DISK_CONFIG, Bs.JSON_PROPERTY_DOMAINS, Bs.JSON_PROPERTY_DW_FRAME, Bs.JSON_PROPERTY_FPGA_BOARDS,
    Bs.JSON_PROPERTY_GPS_ANTENNA_CONFIG, Bs.JSON_PROPERTY_GPS_RECEIVER_CONFIG, Bs.JSON_PROPERTY_GPS_SYNC,
    Bs.JSON_PROPERTY_HEALTH_STATE, Bs.JSON_PROPERTY_HOST, Bs.JSON_PROPERTY_IDENTIFICATION_MODE, Bs.JSON_PROPERTY_INTS,
    Bs.JSON_PROPERTY_ISM_BAND, Bs.JSON_PROPERTY_LAST_GEO_ALT, Bs.JSON_PROPERTY_LAST_GEO_LAT,
    Bs.JSON_PROPERTY_LAST_GEO_LON, Bs.JSON_PROPERTY_LAST_REBOOT, Bs.JSON_PROPERTY_LAST_REBOOT_CAUSE,
    Bs.JSON_PROPERTY_LAST_REPORT, Bs.JSON_PROPERTY_LAST_SYSTEM_REBOOT, Bs.JSON_PROPERTY_LOCATION_TYPE,
    Bs.JSON_PROPERTY_LOG, Bs.JSON_PROPERTY_LOGICAL_CHANNELS, Bs.JSON_PROPERTY_LRC_CONFIG, Bs.JSON_PROPERTY_LRCS,
    Bs.JSON_PROPERTY_LRR_I_D, Bs.JSON_PROPERTY_LRR_U_U_I_D, Bs.JSON_PROPERTY_MFS, Bs.JSON_PROPERTY_MODEL,
    Bs.JSON_PROPERTY_NAME, Bs.JSON_PROPERTY_NOW, Bs.JSON_PROPERTY_OCC_CONTEXT, Bs.JSON_PROPERTY_OWNER,
    Bs.JSON_PROPERTY_POWER, Bs.JSON_PROPERTY_POWER_CONFIG, Bs.JSON_PROPERTY_PUBLIC_KEY,
    Bs.JSON_PROPERTY_RF_COVERAGE_TYPE, Bs.JSON_PROPERTY_RAM, Bs.JSON_PROPERTY_REVERSE_SSH_STATE,
    Bs.JSON_PROPERTY_RF_HARDWARE_CONFIG, Bs.JSON_PROPERTY_RF_REGION_I_D, Bs.JSON_PROPERTY_RF_REGION_I_D_VERSION,
    Bs.JSON_PROPERTY_RF_REGION_NAME, Bs.JSON_PROPERTY_RF_REGION_HREF, Bs.JSON_PROPERTY_RF_SCAN_STATE,
    Bs.JSON_PROPERTY_RFCELL_STATE, Bs.JSON_PROPERTY_SMN, Bs.JSON_PROPERTY_STATE, Bs.JSON_PROPERTY_STATE_SINCE,
    Bs.JSON_PROPERTY_STATIC_ADDRESS, Bs.JSON_PROPERTY_TEMP, Bs.JSON_PROPERTY_TIME_SYNC, Bs.JSON_PROPERTY_UP_FRAME,
    Bs.JSON_PROPERTY_UPGRADE_POLICY, Bs.JSON_PROPERTY_VENDOR, Bs.JSON_PROPERTY_VERSION, Bs.JSON_PROPERTY_WAN_CONFIG })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-29T23:21:27.417438237+02:00[Europe/Paris]", comments = "Generator version: 7.6.0")
public class Bs {
  public static final String JSON_PROPERTY_ACTIVATE_BEACON_TRANSMISSION = "activateBeaconTransmission";
  private Boolean activateBeaconTransmission;

  /**
   * Active RX2 optimization
   */
  public enum ActivateRX2OptimizationEnum {
    NUMBER_0(0),

    NUMBER_1(1);

    private Integer value;

    ActivateRX2OptimizationEnum(Integer value) {
      this.value = value;
    }

    @JsonValue
    public Integer getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ActivateRX2OptimizationEnum fromValue(Integer value) {
      for (ActivateRX2OptimizationEnum b : ActivateRX2OptimizationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ACTIVATE_R_X2_OPTIMIZATION = "activateRX2Optimization";
  private ActivateRX2OptimizationEnum activateRX2Optimization;

  /**
   * Active Support for 802.15.4
   */
  public enum ActivateSupportFor802154Enum {
    NUMBER_0(0),

    NUMBER_1(1);

    private Integer value;

    ActivateSupportFor802154Enum(Integer value) {
      this.value = value;
    }

    @JsonValue
    public Integer getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ActivateSupportFor802154Enum fromValue(Integer value) {
      for (ActivateSupportFor802154Enum b : ActivateSupportFor802154Enum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ACTIVATE_SUPPORT_FOR802154 = "activateSupportFor802_15_4";
  private ActivateSupportFor802154Enum activateSupportFor802154;

  public static final String JSON_PROPERTY_ADMIN_ALT_GROUND = "adminAltGround";
  private Integer adminAltGround;

  public static final String JSON_PROPERTY_ALARM1 = "alarm1";
  private Integer alarm1;

  public static final String JSON_PROPERTY_ALARM103 = "alarm103";
  private String alarm103;

  public static final String JSON_PROPERTY_ALARM2 = "alarm2";
  private Integer alarm2;

  public static final String JSON_PROPERTY_ALARM3 = "alarm3";
  private Integer alarm3;

  public static final String JSON_PROPERTY_ALARM4 = "alarm4";
  private Integer alarm4;

  public static final String JSON_PROPERTY_ALARM5 = "alarm5";
  private Integer alarm5;

  public static final String JSON_PROPERTY_ALARM6 = "alarm6";
  private Integer alarm6;

  public static final String JSON_PROPERTY_ALLOW_CLASS_B = "allowClassB";
  private Boolean allowClassB;

  public static final String JSON_PROPERTY_ANTENNAS_CONFIG = "antennasConfig";
  private String antennasConfig;

  public static final String JSON_PROPERTY_APP_SERVERS = "appServers";
  private List<BsAppServersInner> appServers = new ArrayList<>();

  public static final String JSON_PROPERTY_BACKUP = "backup";
  private BsBackup backup;

  public static final String JSON_PROPERTY_BS_SECURITY = "bsSecurity";
  private BsBsSecurity bsSecurity;

  public static final String JSON_PROPERTY_CLASS_B_STATE = "classBState";
  private Integer classBState;

  /**
   * Base station connection state: - NEVERCNX: The BS has never been connected. -
   * CNX: The BS has an IEC link started with at least a LRC. - DISC: The BS is
   * disconnected from all LRCs. - UNKNOWN: The BS connection state is currently
   * undefined.
   */
  public enum CnxStateEnum {
    NEVERCNX("NEVERCNX"),

    CNX("CNX"),

    DISC("DISC"),

    UNKNOWN("UNKNOWN");

    private String value;

    CnxStateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CnxStateEnum fromValue(String value) {
      for (CnxStateEnum b : CnxStateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CNX_STATE = "cnxState";
  private CnxStateEnum cnxState;

  public static final String JSON_PROPERTY_CNX_STATE_SINCE = "cnxStateSince";
  private Long cnxStateSince;

  public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
  private String contactInfo = "Not set";

  public static final String JSON_PROPERTY_CPU = "cpu";
  private Integer cpu;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private Long creationDate;

  public static final String JSON_PROPERTY_CUSTOMER_ADMIN_DATA = "customerAdminData";
  private String customerAdminData = "Not set";

  public static final String JSON_PROPERTY_CUSTOMS = "customs";
  private BsCustoms customs;

  public static final String JSON_PROPERTY_DISK_CONFIG = "diskConfig";
  private String diskConfig;

  public static final String JSON_PROPERTY_DOMAINS = "domains";
  private List<Domain> domains = new ArrayList<>();

  public static final String JSON_PROPERTY_DW_FRAME = "dwFrame";
  private BsDwFrame dwFrame;

  public static final String JSON_PROPERTY_FPGA_BOARDS = "fpgaBoards";
  private List<BsFpgaBoardsInner> fpgaBoards;

  public static final String JSON_PROPERTY_GPS_ANTENNA_CONFIG = "gpsAntennaConfig";
  private String gpsAntennaConfig;

  /**
   * GPS receiver configuration reported by the base station: - PRESENT (i.e.
   * Present and used) - ABSENT (i.e. Absent or not used) Default: Inherited from
   * the BS profile Can no more be updated via API: ignored in requests.
   */
  public enum GpsReceiverConfigEnum {
    PRESENT("PRESENT"),

    ABSENT("ABSENT");

    private String value;

    GpsReceiverConfigEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GpsReceiverConfigEnum fromValue(String value) {
      for (GpsReceiverConfigEnum b : GpsReceiverConfigEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GPS_RECEIVER_CONFIG = "gpsReceiverConfig";
  private GpsReceiverConfigEnum gpsReceiverConfig;

  public static final String JSON_PROPERTY_GPS_SYNC = "gpsSync";
  private Integer gpsSync;

  public static final String JSON_PROPERTY_HEALTH_STATE = "healthState";
  private BsHealthState healthState;

  public static final String JSON_PROPERTY_HOST = "host";
  private BsHost host;

  /**
   * Base Station identification mode: - &#x60;LRR_ID&#x60;: The Base Station is
   * identified by its LRR ID. The LRR UUID can be updated. Then if the LRR UUID
   * is correctly reported by the Base Station, the identification mode moves to
   * &#x60;LRR_UUID&#x60;. - &#x60;LRR_UUID&#x60;: The Base Station is identified
   * by its LRR UUID. The LRR UUID cannot be updated. The &#x60;LRR_ID&#x60;
   * identification mode is deprecated and should not be used.
   */
  public enum IdentificationModeEnum {
    ID("LRR_ID"),

    UUID("LRR_UUID");

    private String value;

    IdentificationModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IdentificationModeEnum fromValue(String value) {
      for (IdentificationModeEnum b : IdentificationModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_IDENTIFICATION_MODE = "identificationMode";
  private IdentificationModeEnum identificationMode;

  public static final String JSON_PROPERTY_INTS = "ints";
  private BsInts ints;

  public static final String JSON_PROPERTY_ISM_BAND = "ismBand";
  private IsmBandID ismBand;

  public static final String JSON_PROPERTY_LAST_GEO_ALT = "lastGeoAlt";
  private Integer lastGeoAlt;

  public static final String JSON_PROPERTY_LAST_GEO_LAT = "lastGeoLat";
  private Float lastGeoLat;

  public static final String JSON_PROPERTY_LAST_GEO_LON = "lastGeoLon";
  private Float lastGeoLon;

  public static final String JSON_PROPERTY_LAST_REBOOT = "lastReboot";
  private Long lastReboot;

  public static final String JSON_PROPERTY_LAST_REBOOT_CAUSE = "lastRebootCause";
  private Integer lastRebootCause;

  public static final String JSON_PROPERTY_LAST_REPORT = "lastReport";
  private Long lastReport;

  public static final String JSON_PROPERTY_LAST_SYSTEM_REBOOT = "lastSystemReboot";
  private Long lastSystemReboot;

  public static final String JSON_PROPERTY_LOCATION_TYPE = "locationType";
  private Integer locationType;

  public static final String JSON_PROPERTY_LOG = "log";
  private BsLog log;

  public static final String JSON_PROPERTY_LOGICAL_CHANNELS = "logicalChannels";
  private BsLogicalChannels logicalChannels;

  public static final String JSON_PROPERTY_LRC_CONFIG = "lrcConfig";
  private String lrcConfig;

  public static final String JSON_PROPERTY_LRCS = "lrcs";
  private BsLrcs lrcs;

  public static final String JSON_PROPERTY_LRR_I_D = "lrrID";
  private String lrrID;

  public static final String JSON_PROPERTY_LRR_U_U_I_D = "lrrUUID";
  private String lrrUUID;

  public static final String JSON_PROPERTY_MFS = "mfs";
  private BsMfs mfs;

  public static final String JSON_PROPERTY_MODEL = "model";
  private BsModel model;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_NOW = "now";
  private Long now;

  public static final String JSON_PROPERTY_OCC_CONTEXT = "occContext";
  private OccContext occContext;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private BsOwner owner;

  public static final String JSON_PROPERTY_POWER = "power";
  private BsPower power;

  /**
   * Power source of the base station: - MAINS, - POE (Power over Ethernet), -
   * WBAT (Wind / Battery), - SBAT (Solar / Battery) Empty until the configuration
   * is reported by the base station. This parameter must no longer be used:
   * ignored in requests, the &#x60;power&#x60; property must be used in
   * responses.
   */
  public enum PowerConfigEnum {
    MAINS("MAINS"),

    POE("POE"),

    WBAT("WBAT"),

    SBAT("SBAT");

    private String value;

    PowerConfigEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PowerConfigEnum fromValue(String value) {
      for (PowerConfigEnum b : PowerConfigEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_POWER_CONFIG = "powerConfig";
  private PowerConfigEnum powerConfig;

  public static final String JSON_PROPERTY_PUBLIC_KEY = "publicKey";
  private String publicKey;

  /**
   * Specify if the RF coverage provided by the base station is permanent, or
   * temporary for recovery purposes. In case of temporary RF coverage, the base
   * station may be mobile or stationary. A base station used for temporary RF
   * coverage is not taken into account by adaptive data rate algorithm.
   * Additionally, a mobile base station is never selected for class B/C downlink
   * transmission.
   */
  public enum RfCoverageTypeEnum {
    PERMANENT("PERMANENT"),

    TEMPORARY_MOBILE("TEMPORARY_MOBILE"),

    TEMPORARY_STATIONARY("TEMPORARY_STATIONARY");

    private String value;

    RfCoverageTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RfCoverageTypeEnum fromValue(String value) {
      for (RfCoverageTypeEnum b : RfCoverageTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RF_COVERAGE_TYPE = "rfCoverageType";
  private RfCoverageTypeEnum rfCoverageType;

  public static final String JSON_PROPERTY_RAM = "ram";
  private Integer ram;

  public static final String JSON_PROPERTY_REVERSE_SSH_STATE = "reverseSshState";
  private Integer reverseSshState;

  /**
   * RF hardware configuration: - &#x60;S1_A1_B1&#x60;: 1 sector, 1 antenna, 1
   * board (mono-sector 1\\*8 or 1\\*16) - &#x60;S1_A2_B1&#x60;: 1 sector, 2
   * antennas, 1 board (mono-sector 2\\*8) - &#x60;S1_A2_B2&#x60;: 1 sector, 2
   * antennas, 2 boards (mono-sector 2\\*16) - &#x60;S1_A1_B4&#x60;: 1 sector, 1
   * antennas, 4 boards (mono-sector 1\\*64) - &#x60;S3_A3_B3&#x60;: 3 sectors, 3
   * antennas, 3 boards (tri-sectors 1\\*8 or 1\\*16) Default: Inherited from the
   * BS profile
   */
  public enum RfHardwareConfigEnum {
    S1_A1_B1("S1_A1_B1"),

    S1_A2_B1("S1_A2_B1"),

    S1_A2_B2("S1_A2_B2"),

    S1_A1_B4("S1_A1_B4"),

    S3_A3_B3("S3_A3_B3");

    private String value;

    RfHardwareConfigEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RfHardwareConfigEnum fromValue(String value) {
      for (RfHardwareConfigEnum b : RfHardwareConfigEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RF_HARDWARE_CONFIG = "rfHardwareConfig";
  private RfHardwareConfigEnum rfHardwareConfig;

  public static final String JSON_PROPERTY_RF_REGION_I_D = "rfRegionID";
  private String rfRegionID;

  public static final String JSON_PROPERTY_RF_REGION_I_D_VERSION = "rfRegionIDVersion";
  private Integer rfRegionIDVersion;

  public static final String JSON_PROPERTY_RF_REGION_NAME = "rfRegionName";
  private String rfRegionName;

  public static final String JSON_PROPERTY_RF_REGION_HREF = "rfRegionHref";
  private String rfRegionHref;

  public static final String JSON_PROPERTY_RF_SCAN_STATE = "rfScanState";
  private Integer rfScanState;

  public static final String JSON_PROPERTY_RFCELL_STATE = "rfcellState";
  private Integer rfcellState;

  public static final String JSON_PROPERTY_SMN = "smn";
  private String smn;

  public static final String JSON_PROPERTY_STATE = "state";
  private BsState state;

  public static final String JSON_PROPERTY_STATE_SINCE = "stateSince";
  private Long stateSince;

  public static final String JSON_PROPERTY_STATIC_ADDRESS = "staticAddress";
  private String staticAddress = "Not set";

  public static final String JSON_PROPERTY_TEMP = "temp";
  private Integer temp;

  public static final String JSON_PROPERTY_TIME_SYNC = "timeSync";
  private Integer timeSync;

  public static final String JSON_PROPERTY_UP_FRAME = "upFrame";
  private BsUpFrame upFrame;

  /**
   * Base station upgrade policy: MANUAL, TPK_POLICY This parameter must no longer
   * be used: the associated feature is no more available in the product.
   */
  public enum UpgradePolicyEnum {
    MANUAL("MANUAL"),

    TPK_POLICY("TPK_POLICY");

    private String value;

    UpgradePolicyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static UpgradePolicyEnum fromValue(String value) {
      for (UpgradePolicyEnum b : UpgradePolicyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_UPGRADE_POLICY = "upgradePolicy";
  private UpgradePolicyEnum upgradePolicy;

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private BsVendor vendor;

  public static final String JSON_PROPERTY_VERSION = "version";
  private BsVersion version;

  public static final String JSON_PROPERTY_WAN_CONFIG = "wanConfig";
  private String wanConfig;

  public Bs() {
  }

  @JsonCreator
  public Bs(@JsonProperty(JSON_PROPERTY_ACTIVATE_BEACON_TRANSMISSION) Boolean activateBeaconTransmission,
          @JsonProperty(JSON_PROPERTY_ACTIVATE_R_X2_OPTIMIZATION) ActivateRX2OptimizationEnum activateRX2Optimization,
          @JsonProperty(JSON_PROPERTY_ACTIVATE_SUPPORT_FOR802154) ActivateSupportFor802154Enum activateSupportFor802154,
          @JsonProperty(JSON_PROPERTY_ALARM1) Integer alarm1, @JsonProperty(JSON_PROPERTY_ALARM2) Integer alarm2,
          @JsonProperty(JSON_PROPERTY_ALARM3) Integer alarm3, @JsonProperty(JSON_PROPERTY_ALARM4) Integer alarm4,
          @JsonProperty(JSON_PROPERTY_ALARM5) Integer alarm5, @JsonProperty(JSON_PROPERTY_ALARM6) Integer alarm6,
          @JsonProperty(JSON_PROPERTY_ALLOW_CLASS_B) Boolean allowClassB,
          @JsonProperty(JSON_PROPERTY_CLASS_B_STATE) Integer classBState,
          @JsonProperty(JSON_PROPERTY_CNX_STATE) CnxStateEnum cnxState,
          @JsonProperty(JSON_PROPERTY_CNX_STATE_SINCE) Long cnxStateSince, @JsonProperty(JSON_PROPERTY_CPU) Integer cpu,
          @JsonProperty(JSON_PROPERTY_CREATION_DATE) Long creationDate,
          @JsonProperty(JSON_PROPERTY_GPS_SYNC) Integer gpsSync,
          @JsonProperty(JSON_PROPERTY_IDENTIFICATION_MODE) IdentificationModeEnum identificationMode,
          @JsonProperty(JSON_PROPERTY_LAST_GEO_ALT) Integer lastGeoAlt,
          @JsonProperty(JSON_PROPERTY_LAST_GEO_LAT) Float lastGeoLat,
          @JsonProperty(JSON_PROPERTY_LAST_GEO_LON) Float lastGeoLon,
          @JsonProperty(JSON_PROPERTY_LAST_REBOOT) Long lastReboot,
          @JsonProperty(JSON_PROPERTY_LAST_REBOOT_CAUSE) Integer lastRebootCause,
          @JsonProperty(JSON_PROPERTY_LAST_REPORT) Long lastReport,
          @JsonProperty(JSON_PROPERTY_LAST_SYSTEM_REBOOT) Long lastSystemReboot,
          @JsonProperty(JSON_PROPERTY_LOCATION_TYPE) Integer locationType, @JsonProperty(JSON_PROPERTY_NOW) Long now,
          @JsonProperty(JSON_PROPERTY_RAM) Integer ram,
          @JsonProperty(JSON_PROPERTY_REVERSE_SSH_STATE) Integer reverseSshState,
          @JsonProperty(JSON_PROPERTY_RF_REGION_I_D) String rfRegionID,
          @JsonProperty(JSON_PROPERTY_RF_REGION_I_D_VERSION) Integer rfRegionIDVersion,
          @JsonProperty(JSON_PROPERTY_RF_REGION_NAME) String rfRegionName,
          @JsonProperty(JSON_PROPERTY_RF_REGION_HREF) String rfRegionHref,
          @JsonProperty(JSON_PROPERTY_RF_SCAN_STATE) Integer rfScanState,
          @JsonProperty(JSON_PROPERTY_RFCELL_STATE) Integer rfcellState,
          @JsonProperty(JSON_PROPERTY_STATE_SINCE) Long stateSince, @JsonProperty(JSON_PROPERTY_TEMP) Integer temp,
          @JsonProperty(JSON_PROPERTY_TIME_SYNC) Integer timeSync,
          @JsonProperty(JSON_PROPERTY_UPGRADE_POLICY) UpgradePolicyEnum upgradePolicy) {
    this();
    this.activateBeaconTransmission = activateBeaconTransmission;
    this.activateRX2Optimization = activateRX2Optimization;
    this.activateSupportFor802154 = activateSupportFor802154;
    this.alarm1 = alarm1;
    this.alarm2 = alarm2;
    this.alarm3 = alarm3;
    this.alarm4 = alarm4;
    this.alarm5 = alarm5;
    this.alarm6 = alarm6;
    this.allowClassB = allowClassB;
    this.classBState = classBState;
    this.cnxState = cnxState;
    this.cnxStateSince = cnxStateSince;
    this.cpu = cpu;
    this.creationDate = creationDate;
    this.gpsSync = gpsSync;
    this.identificationMode = identificationMode;
    this.lastGeoAlt = lastGeoAlt;
    this.lastGeoLat = lastGeoLat;
    this.lastGeoLon = lastGeoLon;
    this.lastReboot = lastReboot;
    this.lastRebootCause = lastRebootCause;
    this.lastReport = lastReport;
    this.lastSystemReboot = lastSystemReboot;
    this.locationType = locationType;
    this.now = now;
    this.ram = ram;
    this.reverseSshState = reverseSshState;
    this.rfRegionID = rfRegionID;
    this.rfRegionIDVersion = rfRegionIDVersion;
    this.rfRegionName = rfRegionName;
    this.rfRegionHref = rfRegionHref;
    this.rfScanState = rfScanState;
    this.rfcellState = rfcellState;
    this.stateSince = stateSince;
    this.temp = temp;
    this.timeSync = timeSync;
    this.upgradePolicy = upgradePolicy;
  }

  /**
   * Activate beacon transmission
   * 
   * @return activateBeaconTransmission
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ACTIVATE_BEACON_TRANSMISSION)

  public Boolean getActivateBeaconTransmission() {
    return activateBeaconTransmission;
  }

  /**
   * Active RX2 optimization
   * 
   * @return activateRX2Optimization
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ACTIVATE_R_X2_OPTIMIZATION)

  public ActivateRX2OptimizationEnum getActivateRX2Optimization() {
    return activateRX2Optimization;
  }

  /**
   * Active Support for 802.15.4
   * 
   * @return activateSupportFor802154
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ACTIVATE_SUPPORT_FOR802154)

  public ActivateSupportFor802154Enum getActivateSupportFor802154() {
    return activateSupportFor802154;
  }

  public Bs adminAltGround(Integer adminAltGround) {

    this.adminAltGround = adminAltGround;
    return this;
  }

  /**
   * Administrative altitude of the BS above the ground Note: Always optional.
   * 
   * @return adminAltGround
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ADMIN_ALT_GROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAdminAltGround() {
    return adminAltGround;
  }

  @JsonProperty(JSON_PROPERTY_ADMIN_ALT_GROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdminAltGround(Integer adminAltGround) {
    this.adminAltGround = adminAltGround;
  }

  /**
   * Number of CLEARED alarms not ACKED
   * 
   * @return alarm1
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM1)

  public Integer getAlarm1() {
    return alarm1;
  }

  public Bs alarm103(String alarm103) {

    this.alarm103 = alarm103;
    return this;
  }

  /**
   * Two thresholds can be configured for the alarm 103 (no uplink activity) in an
   * XML document: - The root XML element is &#x60;alarm103&#x60; - The enclosed
   * &#x60;threshold1&#x60; self-closing XML element configures the first
   * threshold of the alarm - The enclosed &#x60;threshold2&#x60; self-closing XML
   * element configures the second threshold of the alarm - For each threshold XML
   * element the following attributes are available: - &#x60;status&#x60;:
   * &#x60;ENABLE&#x60; or &#x60;DISABLE&#x60; this threshold - &#x60;level&#x60;:
   * severity (2-6) of the alarm for this threshold - &#x60;duration&#x60;:
   * inactivity period (RFC 3339 duration between &#x60;PT1H&#x60; and
   * &#x60;P30D&#x60;) after which the alarm is triggered for this threshold - The
   * following constraints must be satisfied: - &#x60;threshold2@status&#x60; can
   * be set to &#x60;ENABLE&#x60; only if &#x60;threshold1@status&#x60; is
   * &#x60;ENABLE&#x60; - &#x60;threshold1@level&#x60; must be lower than
   * &#x60;threshold2@level&#x60; - &#x60;threshold1@duration&#x60; must be lower
   * than &#x60;threshold2@duration&#x60;
   * 
   * @return alarm103
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALARM103)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAlarm103() {
    return alarm103;
  }

  @JsonProperty(JSON_PROPERTY_ALARM103)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlarm103(String alarm103) {
    this.alarm103 = alarm103;
  }

  /**
   * Number of INDETERMINATE alarms not ACKED
   * 
   * @return alarm2
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM2)

  public Integer getAlarm2() {
    return alarm2;
  }

  /**
   * Number of WARNING alarms not ACKED
   * 
   * @return alarm3
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM3)

  public Integer getAlarm3() {
    return alarm3;
  }

  /**
   * Number of MINOR alarms not ACKED
   * 
   * @return alarm4
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM4)

  public Integer getAlarm4() {
    return alarm4;
  }

  /**
   * Number of MAJOR alarms not ACKED
   * 
   * @return alarm5
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM5)

  public Integer getAlarm5() {
    return alarm5;
  }

  /**
   * Number of CRITICAL alarms not ACKED
   * 
   * @return alarm6
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ALARM6)

  public Integer getAlarm6() {
    return alarm6;
  }

  /**
   * Allow Class B This parameter must no longer be used: it is ignored and always
   * set to true.
   * 
   * @return allowClassB
   * @deprecated
   **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALLOW_CLASS_B)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowClassB() {
    return allowClassB;
  }

  public Bs antennasConfig(String antennasConfig) {

    this.antennasConfig = antennasConfig;
    return this;
  }

  /**
   * Antennas configuration Default: Inherited from the BS profile This parameter
   * must no longer be used: the endpoint &#x60;GET
   * /partners/{partnerUid}/bss/{bsUid}/ants&#x60; must be used in replacement.
   * 
   * @return antennasConfig
   * @deprecated
   **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ANTENNAS_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAntennasConfig() {
    return antennasConfig;
  }

  @JsonProperty(JSON_PROPERTY_ANTENNAS_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAntennasConfig(String antennasConfig) {
    this.antennasConfig = antennasConfig;
  }

  public Bs appServers(List<BsAppServersInner> appServers) {

    this.appServers = appServers;
    return this;
  }

  public Bs addAppServersItem(BsAppServersInner appServersItem) {
    if (this.appServers == null) {
      this.appServers = new ArrayList<>();
    }
    this.appServers.add(appServersItem);
    return this;
  }

  /**
   * List of application servers associated with the base station for alarms
   * reporting purposes. Only supported if the partner&#39;s type is
   * &#x60;SUBSCRIBER&#x60;: associated applications servers must belong to the
   * same subscriber account and must be of type Kafka. If the authenticated user
   * has domain restrictions, only the following application servers can be
   * associated with a base station: - Application servers not associated with any
   * domain - Application servers associated with domains and matching the domain
   * restrictions
   * 
   * @return appServers
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_APP_SERVERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BsAppServersInner> getAppServers() {
    return appServers;
  }

  @JsonProperty(JSON_PROPERTY_APP_SERVERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppServers(List<BsAppServersInner> appServers) {
    this.appServers = appServers;
  }

  public Bs backup(BsBackup backup) {

    this.backup = backup;
    return this;
  }

  /**
   * Get backup
   * 
   * @return backup
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BACKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsBackup getBackup() {
    return backup;
  }

  @JsonProperty(JSON_PROPERTY_BACKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBackup(BsBackup backup) {
    this.backup = backup;
  }

  public Bs bsSecurity(BsBsSecurity bsSecurity) {

    this.bsSecurity = bsSecurity;
    return this;
  }

  /**
   * Get bsSecurity
   * 
   * @return bsSecurity
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BS_SECURITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsBsSecurity getBsSecurity() {
    return bsSecurity;
  }

  @JsonProperty(JSON_PROPERTY_BS_SECURITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBsSecurity(BsBsSecurity bsSecurity) {
    this.bsSecurity = bsSecurity;
  }

  /**
   * Class B state: - Not supported (0) - Supported but not operational (1) -
   * Supported and operational (2) - Unknown because of disconnected Base Station
   * (null)
   * 
   * @return classBState
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CLASS_B_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getClassBState() {
    return classBState;
  }

  /**
   * Base station connection state: - NEVERCNX: The BS has never been connected. -
   * CNX: The BS has an IEC link started with at least a LRC. - DISC: The BS is
   * disconnected from all LRCs. - UNKNOWN: The BS connection state is currently
   * undefined.
   * 
   * @return cnxState
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CNX_STATE)

  public CnxStateEnum getCnxState() {
    return cnxState;
  }

  /**
   * Base station connection state reached since timestamp when the BS has already
   * been connected, epoch time in milliseconds.
   * 
   * @return cnxStateSince
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CNX_STATE_SINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCnxStateSince() {
    return cnxStateSince;
  }

  public Bs contactInfo(String contactInfo) {

    this.contactInfo = contactInfo;
    return this;
  }

  /**
   * Contact information
   * 
   * @return contactInfo
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContactInfo() {
    return contactInfo;
  }

  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactInfo(String contactInfo) {
    this.contactInfo = contactInfo;
  }

  /**
   * CPU usage (%)
   * 
   * @return cpu
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CPU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCpu() {
    return cpu;
  }

  /**
   * Base station creation date, epoch time in milliseconds.
   * 
   * @return creationDate
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)

  public Long getCreationDate() {
    return creationDate;
  }

  public Bs customerAdminData(String customerAdminData) {

    this.customerAdminData = customerAdminData;
    return this;
  }

  /**
   * BS administrative info
   * 
   * @return customerAdminData
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMER_ADMIN_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerAdminData() {
    return customerAdminData;
  }

  @JsonProperty(JSON_PROPERTY_CUSTOMER_ADMIN_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerAdminData(String customerAdminData) {
    this.customerAdminData = customerAdminData;
  }

  public Bs customs(BsCustoms customs) {

    this.customs = customs;
    return this;
  }

  /**
   * Get customs
   * 
   * @return customs
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsCustoms getCustoms() {
    return customs;
  }

  @JsonProperty(JSON_PROPERTY_CUSTOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustoms(BsCustoms customs) {
    this.customs = customs;
  }

  public Bs diskConfig(String diskConfig) {

    this.diskConfig = diskConfig;
    return this;
  }

  /**
   * Mounted filesystems of the base station. Empty until the configuration is
   * reported by the base station. This parameter must no longer be used: ignored
   * in requests, the &#x60;mfs&#x60; property must be used in responses.
   * 
   * @return diskConfig
   * @deprecated
   **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISK_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDiskConfig() {
    return diskConfig;
  }

  @JsonProperty(JSON_PROPERTY_DISK_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiskConfig(String diskConfig) {
    this.diskConfig = diskConfig;
  }

  public Bs domains(List<Domain> domains) {

    this.domains = domains;
    return this;
  }

  public Bs addDomainsItem(Domain domainsItem) {
    if (this.domains == null) {
      this.domains = new ArrayList<>();
    }
    this.domains.add(domainsItem);
    return this;
  }

  /**
   * List of domains associated with the Base Station. The list cannot contain
   * more than one domain for a given group. Only supported if the partner&#39;s
   * type is &#x60;SUBSCRIBER&#x60;.
   * 
   * @return domains
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOMAINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Domain> getDomains() {
    return domains;
  }

  @JsonProperty(JSON_PROPERTY_DOMAINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomains(List<Domain> domains) {
    this.domains = domains;
  }

  public Bs dwFrame(BsDwFrame dwFrame) {

    this.dwFrame = dwFrame;
    return this;
  }

  /**
   * Get dwFrame
   * 
   * @return dwFrame
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DW_FRAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsDwFrame getDwFrame() {
    return dwFrame;
  }

  @JsonProperty(JSON_PROPERTY_DW_FRAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDwFrame(BsDwFrame dwFrame) {
    this.dwFrame = dwFrame;
  }

  public Bs fpgaBoards(List<BsFpgaBoardsInner> fpgaBoards) {

    this.fpgaBoards = fpgaBoards;
    return this;
  }

  public Bs addFpgaBoardsItem(BsFpgaBoardsInner fpgaBoardsItem) {
    if (this.fpgaBoards == null) {
      this.fpgaBoards = new ArrayList<>();
    }
    this.fpgaBoards.add(fpgaBoardsItem);
    return this;
  }

  /**
   * Get fpgaBoards
   * 
   * @return fpgaBoards
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_FPGA_BOARDS)

  public List<BsFpgaBoardsInner> getFpgaBoards() {
    return fpgaBoards;
  }

  @JsonProperty(JSON_PROPERTY_FPGA_BOARDS)
  public void setFpgaBoards(List<BsFpgaBoardsInner> fpgaBoards) {
    this.fpgaBoards = fpgaBoards;
  }

  public Bs gpsAntennaConfig(String gpsAntennaConfig) {

    this.gpsAntennaConfig = gpsAntennaConfig;
    return this;
  }

  /**
   * GPS antenna configuration.
   * 
   * @return gpsAntennaConfig
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GPS_ANTENNA_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGpsAntennaConfig() {
    return gpsAntennaConfig;
  }

  @JsonProperty(JSON_PROPERTY_GPS_ANTENNA_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGpsAntennaConfig(String gpsAntennaConfig) {
    this.gpsAntennaConfig = gpsAntennaConfig;
  }

  public Bs gpsReceiverConfig(GpsReceiverConfigEnum gpsReceiverConfig) {

    this.gpsReceiverConfig = gpsReceiverConfig;
    return this;
  }

  /**
   * GPS receiver configuration reported by the base station: - PRESENT (i.e.
   * Present and used) - ABSENT (i.e. Absent or not used) Default: Inherited from
   * the BS profile Can no more be updated via API: ignored in requests.
   * 
   * @return gpsReceiverConfig
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GPS_RECEIVER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GpsReceiverConfigEnum getGpsReceiverConfig() {
    return gpsReceiverConfig;
  }

  @JsonProperty(JSON_PROPERTY_GPS_RECEIVER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGpsReceiverConfig(GpsReceiverConfigEnum gpsReceiverConfig) {
    this.gpsReceiverConfig = gpsReceiverConfig;
  }

  /**
   * GPS receiver synchronization status: - Locking/No signal (0) - Locked (1) -
   * Unknown because of disconnected Base Station (null)
   * 
   * @return gpsSync
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GPS_SYNC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGpsSync() {
    return gpsSync;
  }

  public Bs healthState(BsHealthState healthState) {

    this.healthState = healthState;
    return this;
  }

  /**
   * Get healthState
   * 
   * @return healthState
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_HEALTH_STATE)

  public BsHealthState getHealthState() {
    return healthState;
  }

  @JsonProperty(JSON_PROPERTY_HEALTH_STATE)
  public void setHealthState(BsHealthState healthState) {
    this.healthState = healthState;
  }

  public Bs host(BsHost host) {

    this.host = host;
    return this;
  }

  /**
   * Get host
   * 
   * @return host
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_HOST)

  public BsHost getHost() {
    return host;
  }

  @JsonProperty(JSON_PROPERTY_HOST)
  public void setHost(BsHost host) {
    this.host = host;
  }

  /**
   * Base Station identification mode: - &#x60;LRR_ID&#x60;: The Base Station is
   * identified by its LRR ID. The LRR UUID can be updated. Then if the LRR UUID
   * is correctly reported by the Base Station, the identification mode moves to
   * &#x60;LRR_UUID&#x60;. - &#x60;LRR_UUID&#x60;: The Base Station is identified
   * by its LRR UUID. The LRR UUID cannot be updated. The &#x60;LRR_ID&#x60;
   * identification mode is deprecated and should not be used.
   * 
   * @return identificationMode
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_IDENTIFICATION_MODE)

  public IdentificationModeEnum getIdentificationMode() {
    return identificationMode;
  }

  public Bs ints(BsInts ints) {

    this.ints = ints;
    return this;
  }

  /**
   * Get ints
   * 
   * @return ints
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_INTS)

  public BsInts getInts() {
    return ints;
  }

  @JsonProperty(JSON_PROPERTY_INTS)
  public void setInts(BsInts ints) {
    this.ints = ints;
  }

  public Bs ismBand(IsmBandID ismBand) {

    this.ismBand = ismBand;
    return this;
  }

  /**
   * Get ismBand
   * 
   * @return ismBand
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ISM_BAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IsmBandID getIsmBand() {
    return ismBand;
  }

  @JsonProperty(JSON_PROPERTY_ISM_BAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsmBand(IsmBandID ismBand) {
    this.ismBand = ismBand;
  }

  /**
   * Network altitude of the BS when available
   * 
   * @return lastGeoAlt
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_GEO_ALT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLastGeoAlt() {
    return lastGeoAlt;
  }

  /**
   * Network location of the BS when available
   * 
   * @return lastGeoLat
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_GEO_LAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLastGeoLat() {
    return lastGeoLat;
  }

  /**
   * Network location of the BS when available
   * 
   * @return lastGeoLon
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_GEO_LON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLastGeoLon() {
    return lastGeoLon;
  }

  /**
   * Last reboot timestamp (**software uptime**), epoch time in milliseconds
   * 
   * @return lastReboot
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_REBOOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getLastReboot() {
    return lastReboot;
  }

  /**
   * - Last reboot restart root cause: Administrative (0) - Software crash (1)
   * 
   * @return lastRebootCause
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_REBOOT_CAUSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLastRebootCause() {
    return lastRebootCause;
  }

  /**
   * Last report timestamp, epoch time in milliseconds
   * 
   * @return lastReport
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getLastReport() {
    return lastReport;
  }

  /**
   * Last reboot timestamp (**system uptime**), epoch time in milliseconds
   * 
   * @return lastSystemReboot
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_SYSTEM_REBOOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getLastSystemReboot() {
    return lastSystemReboot;
  }

  /**
   * Type of location currently activated (Unknown:0 or Administrative:1 or GPS:2)
   * 
   * @return locationType
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LOCATION_TYPE)

  public Integer getLocationType() {
    return locationType;
  }

  public Bs log(BsLog log) {

    this.log = log;
    return this;
  }

  /**
   * Get log
   * 
   * @return log
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsLog getLog() {
    return log;
  }

  @JsonProperty(JSON_PROPERTY_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLog(BsLog log) {
    this.log = log;
  }

  public Bs logicalChannels(BsLogicalChannels logicalChannels) {

    this.logicalChannels = logicalChannels;
    return this;
  }

  /**
   * Get logicalChannels
   * 
   * @return logicalChannels
   * @deprecated
   **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOGICAL_CHANNELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsLogicalChannels getLogicalChannels() {
    return logicalChannels;
  }

  @JsonProperty(JSON_PROPERTY_LOGICAL_CHANNELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogicalChannels(BsLogicalChannels logicalChannels) {
    this.logicalChannels = logicalChannels;
  }

  public Bs lrcConfig(String lrcConfig) {

    this.lrcConfig = lrcConfig;
    return this;
  }

  /**
   * LRCs used by the base station. Empty until the configuration is reported by
   * the base station. This parameter must no longer be used: ignored in requests,
   * the &#x60;lrcs&#x60; property must be used in responses.
   * 
   * @return lrcConfig
   * @deprecated
   **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LRC_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLrcConfig() {
    return lrcConfig;
  }

  @JsonProperty(JSON_PROPERTY_LRC_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLrcConfig(String lrcConfig) {
    this.lrcConfig = lrcConfig;
  }

  public Bs lrcs(BsLrcs lrcs) {

    this.lrcs = lrcs;
    return this;
  }

  /**
   * Get lrcs
   * 
   * @return lrcs
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LRCS)

  public BsLrcs getLrcs() {
    return lrcs;
  }

  @JsonProperty(JSON_PROPERTY_LRCS)
  public void setLrcs(BsLrcs lrcs) {
    this.lrcs = lrcs;
  }

  public Bs lrrID(String lrrID) {

    this.lrrID = lrrID;
    return this;
  }

  /**
   * Base Station LRR ID: 8 hexadecimal characters / case insensitive but always
   * converted in upper case by the server. The value &#x60;00000000&#x60; and the
   * prefixes &#x60;FFFE&#x60; and &#x60;FFFF&#x60; are reserved and forbidden.
   * Forbidden in Create if LRR UUID is provided: - The identification mode is set
   * to &#x60;LRR_UUID&#x60; - The LRR ID is automatically allocated and returned
   * in response Mandatory in Create if LRR UUID is not provided: - The
   * identification mode is set to &#x60;LRR_ID&#x60; - This case is deprecated
   * and should not be used
   * 
   * @return lrrID
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LRR_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLrrID() {
    return lrrID;
  }

  @JsonProperty(JSON_PROPERTY_LRR_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLrrID(String lrrID) {
    this.lrrID = lrrID;
  }

  public Bs lrrUUID(String lrrUUID) {

    this.lrrUUID = lrrUUID;
    return this;
  }

  /**
   * Base Station LRR UUID: &#x60;&lt;LRR-OUI&gt;-&lt;LRR-GID&gt;&#x60; Where: -
   * &#x60;&lt;LRR-OUI&gt;&#x60; is the IEEE OUI of the Base station manufacturer
   * (6 hexadecimal characters / case insensitive but always converted in upper
   * case by the server) - &#x60;&lt;LRR-GID&gt;&#x60; is the Base Station
   * identifier relatively to the vendor (maximum 48 hexadecimal characters / case
   * insensitive but always converted in upper case by the server) Mandatory in
   * Create if LRR ID is not provided: - The identification mode is set to
   * &#x60;LRR_UUID&#x60; - The LRR ID is automatically allocated and returned in
   * response Forbidden in Create if LRR ID is provided: - The identification mode
   * is set to &#x60;LRR_ID&#x60; - This case is deprecated and should not be used
   * Forbidden in Update if BS identification mode is &#x60;LRR_UUID&#x60;
   * 
   * @return lrrUUID
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LRR_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLrrUUID() {
    return lrrUUID;
  }

  @JsonProperty(JSON_PROPERTY_LRR_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLrrUUID(String lrrUUID) {
    this.lrrUUID = lrrUUID;
  }

  public Bs mfs(BsMfs mfs) {

    this.mfs = mfs;
    return this;
  }

  /**
   * Get mfs
   * 
   * @return mfs
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MFS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsMfs getMfs() {
    return mfs;
  }

  @JsonProperty(JSON_PROPERTY_MFS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMfs(BsMfs mfs) {
    this.mfs = mfs;
  }

  public Bs model(BsModel model) {

    this.model = model;
    return this;
  }

  /**
   * Get model
   * 
   * @return model
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsModel getModel() {
    return model;
  }

  @JsonProperty(JSON_PROPERTY_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModel(BsModel model) {
    this.model = model;
  }

  public Bs name(String name) {

    this.name = name;
    return this;
  }

  /**
   * BS name Default: The name is generated
   * 
   * @return name
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Current time of the server, epoch time in milliseconds
   * 
   * @return now
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NOW)

  public Long getNow() {
    return now;
  }

  public Bs occContext(OccContext occContext) {

    this.occContext = occContext;
    return this;
  }

  /**
   * Get occContext
   * 
   * @return occContext
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OCC_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OccContext getOccContext() {
    return occContext;
  }

  @JsonProperty(JSON_PROPERTY_OCC_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOccContext(OccContext occContext) {
    this.occContext = occContext;
  }

  public Bs owner(BsOwner owner) {

    this.owner = owner;
    return this;
  }

  /**
   * Get owner
   * 
   * @return owner
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OWNER)

  public BsOwner getOwner() {
    return owner;
  }

  @JsonProperty(JSON_PROPERTY_OWNER)
  public void setOwner(BsOwner owner) {
    this.owner = owner;
  }

  public Bs power(BsPower power) {

    this.power = power;
    return this;
  }

  /**
   * Get power
   * 
   * @return power
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POWER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsPower getPower() {
    return power;
  }

  @JsonProperty(JSON_PROPERTY_POWER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPower(BsPower power) {
    this.power = power;
  }

  public Bs powerConfig(PowerConfigEnum powerConfig) {

    this.powerConfig = powerConfig;
    return this;
  }

  /**
   * Power source of the base station: - MAINS, - POE (Power over Ethernet), -
   * WBAT (Wind / Battery), - SBAT (Solar / Battery) Empty until the configuration
   * is reported by the base station. This parameter must no longer be used:
   * ignored in requests, the &#x60;power&#x60; property must be used in
   * responses.
   * 
   * @return powerConfig
   * @deprecated
   **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POWER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PowerConfigEnum getPowerConfig() {
    return powerConfig;
  }

  @JsonProperty(JSON_PROPERTY_POWER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPowerConfig(PowerConfigEnum powerConfig) {
    this.powerConfig = powerConfig;
  }

  public Bs publicKey(String publicKey) {

    this.publicKey = publicKey;
    return this;
  }

  /**
   * SSH public key used by the base station to authenticate to the Key installer.
   * This property is relevant only if bsSecurity is &#x60;IPSEC_X509&#x60;. The
   * public key must be provided in PEM PKCS8 format.
   * 
   * @return publicKey
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PUBLIC_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPublicKey() {
    return publicKey;
  }

  @JsonProperty(JSON_PROPERTY_PUBLIC_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublicKey(String publicKey) {
    this.publicKey = publicKey;
  }

  public Bs rfCoverageType(RfCoverageTypeEnum rfCoverageType) {

    this.rfCoverageType = rfCoverageType;
    return this;
  }

  /**
   * Specify if the RF coverage provided by the base station is permanent, or
   * temporary for recovery purposes. In case of temporary RF coverage, the base
   * station may be mobile or stationary. A base station used for temporary RF
   * coverage is not taken into account by adaptive data rate algorithm.
   * Additionally, a mobile base station is never selected for class B/C downlink
   * transmission.
   * 
   * @return rfCoverageType
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RF_COVERAGE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RfCoverageTypeEnum getRfCoverageType() {
    return rfCoverageType;
  }

  @JsonProperty(JSON_PROPERTY_RF_COVERAGE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRfCoverageType(RfCoverageTypeEnum rfCoverageType) {
    this.rfCoverageType = rfCoverageType;
  }

  /**
   * RAM usage (%)
   * 
   * @return ram
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RAM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRam() {
    return ram;
  }

  /**
   * Reverse SSH state: - Closed (0) - Opened (&gt;0)
   * 
   * @return reverseSshState
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REVERSE_SSH_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getReverseSshState() {
    return reverseSshState;
  }

  public Bs rfHardwareConfig(RfHardwareConfigEnum rfHardwareConfig) {

    this.rfHardwareConfig = rfHardwareConfig;
    return this;
  }

  /**
   * RF hardware configuration: - &#x60;S1_A1_B1&#x60;: 1 sector, 1 antenna, 1
   * board (mono-sector 1\\*8 or 1\\*16) - &#x60;S1_A2_B1&#x60;: 1 sector, 2
   * antennas, 1 board (mono-sector 2\\*8) - &#x60;S1_A2_B2&#x60;: 1 sector, 2
   * antennas, 2 boards (mono-sector 2\\*16) - &#x60;S1_A1_B4&#x60;: 1 sector, 1
   * antennas, 4 boards (mono-sector 1\\*64) - &#x60;S3_A3_B3&#x60;: 3 sectors, 3
   * antennas, 3 boards (tri-sectors 1\\*8 or 1\\*16) Default: Inherited from the
   * BS profile
   * 
   * @return rfHardwareConfig
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RF_HARDWARE_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RfHardwareConfigEnum getRfHardwareConfig() {
    return rfHardwareConfig;
  }

  @JsonProperty(JSON_PROPERTY_RF_HARDWARE_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRfHardwareConfig(RfHardwareConfigEnum rfHardwareConfig) {
    this.rfHardwareConfig = rfHardwareConfig;
  }

  /**
   * RF Region provisioning ID
   * 
   * @return rfRegionID
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RF_REGION_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRfRegionID() {
    return rfRegionID;
  }

  /**
   * RF Region version
   * 
   * @return rfRegionIDVersion
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RF_REGION_I_D_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRfRegionIDVersion() {
    return rfRegionIDVersion;
  }

  /**
   * RF Region name
   * 
   * @return rfRegionName
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RF_REGION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRfRegionName() {
    return rfRegionName;
  }

  /**
   * RF Region href
   * 
   * @return rfRegionHref
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RF_REGION_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRfRegionHref() {
    return rfRegionHref;
  }

  /**
   * RF scan state: - No started (0) - In progress (&gt;0)
   * 
   * @return rfScanState
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RF_SCAN_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRfScanState() {
    return rfScanState;
  }

  /**
   * RF cell state: - Stopped (0) - Downlink stopped (1) - Started (2) - Unknown
   * because of disconnected Base Station (null)
   * 
   * @return rfcellState
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RFCELL_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRfcellState() {
    return rfcellState;
  }

  public Bs smn(String smn) {

    this.smn = smn;
    return this;
  }

  /**
   * BS serial marketing number
   * 
   * @return smn
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SMN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSmn() {
    return smn;
  }

  @JsonProperty(JSON_PROPERTY_SMN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSmn(String smn) {
    this.smn = smn;
  }

  public Bs state(BsState state) {

    this.state = state;
    return this;
  }

  /**
   * Get state
   * 
   * @return state
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsState getState() {
    return state;
  }

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(BsState state) {
    this.state = state;
  }

  /**
   * Base station admin state reached since timestamp, epoch time in milliseconds.
   * 
   * @return stateSince
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATE_SINCE)

  public Long getStateSince() {
    return stateSince;
  }

  public Bs staticAddress(String staticAddress) {

    this.staticAddress = staticAddress;
    return this;
  }

  /**
   * BS address (static)
   * 
   * @return staticAddress
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATIC_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStaticAddress() {
    return staticAddress;
  }

  @JsonProperty(JSON_PROPERTY_STATIC_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStaticAddress(String staticAddress) {
    this.staticAddress = staticAddress;
  }

  /**
   * Temperature status: temperature (?C)
   * 
   * @return temp
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTemp() {
    return temp;
  }

  /**
   * Time synchronization status: - Local / Not synchronized (0) - NTP (1) - NTP
   * sync with GPS (2) - Radio sync with GPS (3) - Unknown because of disconnected
   * Base Station (null)
   * 
   * @return timeSync
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TIME_SYNC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTimeSync() {
    return timeSync;
  }

  public Bs upFrame(BsUpFrame upFrame) {

    this.upFrame = upFrame;
    return this;
  }

  /**
   * Get upFrame
   * 
   * @return upFrame
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UP_FRAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsUpFrame getUpFrame() {
    return upFrame;
  }

  @JsonProperty(JSON_PROPERTY_UP_FRAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpFrame(BsUpFrame upFrame) {
    this.upFrame = upFrame;
  }

  /**
   * Base station upgrade policy: MANUAL, TPK_POLICY This parameter must no longer
   * be used: the associated feature is no more available in the product.
   * 
   * @return upgradePolicy
   * @deprecated
   **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPGRADE_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UpgradePolicyEnum getUpgradePolicy() {
    return upgradePolicy;
  }

  public Bs vendor(BsVendor vendor) {

    this.vendor = vendor;
    return this;
  }

  /**
   * Get vendor
   * 
   * @return vendor
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_VENDOR)

  public BsVendor getVendor() {
    return vendor;
  }

  @JsonProperty(JSON_PROPERTY_VENDOR)
  public void setVendor(BsVendor vendor) {
    this.vendor = vendor;
  }

  public Bs version(BsVersion version) {

    this.version = version;
    return this;
  }

  /**
   * Get version
   * 
   * @return version
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BsVersion getVersion() {
    return version;
  }

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(BsVersion version) {
    this.version = version;
  }

  public Bs wanConfig(String wanConfig) {

    this.wanConfig = wanConfig;
    return this;
  }

  /**
   * WAN backhaul interfaces of the base station. Empty until the configuration is
   * reported by the base station. Only the imei, imsi and iccid attributes of a
   * GPRS interface can be updated. This parameter must no longer be used: the
   * &#x60;ints&#x60; property must be used in responses (IMEI, IMSI and ICCID are
   * now reported by the base station).
   * 
   * @return wanConfig
   * @deprecated
   **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WAN_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWanConfig() {
    return wanConfig;
  }

  @JsonProperty(JSON_PROPERTY_WAN_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWanConfig(String wanConfig) {
    this.wanConfig = wanConfig;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Bs bs = (Bs) o;
    return Objects.equals(this.activateBeaconTransmission, bs.activateBeaconTransmission)
            && Objects.equals(this.activateRX2Optimization, bs.activateRX2Optimization)
            && Objects.equals(this.activateSupportFor802154, bs.activateSupportFor802154)
            && Objects.equals(this.adminAltGround, bs.adminAltGround) && Objects.equals(this.alarm1, bs.alarm1)
            && Objects.equals(this.alarm103, bs.alarm103) && Objects.equals(this.alarm2, bs.alarm2)
            && Objects.equals(this.alarm3, bs.alarm3) && Objects.equals(this.alarm4, bs.alarm4)
            && Objects.equals(this.alarm5, bs.alarm5) && Objects.equals(this.alarm6, bs.alarm6)
            && Objects.equals(this.allowClassB, bs.allowClassB)
            && Objects.equals(this.antennasConfig, bs.antennasConfig) && Objects.equals(this.appServers, bs.appServers)
            && Objects.equals(this.backup, bs.backup) && Objects.equals(this.bsSecurity, bs.bsSecurity)
            && Objects.equals(this.classBState, bs.classBState) && Objects.equals(this.cnxState, bs.cnxState)
            && Objects.equals(this.cnxStateSince, bs.cnxStateSince) && Objects.equals(this.contactInfo, bs.contactInfo)
            && Objects.equals(this.cpu, bs.cpu) && Objects.equals(this.creationDate, bs.creationDate)
            && Objects.equals(this.customerAdminData, bs.customerAdminData) && Objects.equals(this.customs, bs.customs)
            && Objects.equals(this.diskConfig, bs.diskConfig) && Objects.equals(this.domains, bs.domains)
            && Objects.equals(this.dwFrame, bs.dwFrame) && Objects.equals(this.fpgaBoards, bs.fpgaBoards)
            && Objects.equals(this.gpsAntennaConfig, bs.gpsAntennaConfig)
            && Objects.equals(this.gpsReceiverConfig, bs.gpsReceiverConfig) && Objects.equals(this.gpsSync, bs.gpsSync)
            && Objects.equals(this.healthState, bs.healthState) && Objects.equals(this.host, bs.host)
            && Objects.equals(this.identificationMode, bs.identificationMode) && Objects.equals(this.ints, bs.ints)
            && Objects.equals(this.ismBand, bs.ismBand) && Objects.equals(this.lastGeoAlt, bs.lastGeoAlt)
            && Objects.equals(this.lastGeoLat, bs.lastGeoLat) && Objects.equals(this.lastGeoLon, bs.lastGeoLon)
            && Objects.equals(this.lastReboot, bs.lastReboot)
            && Objects.equals(this.lastRebootCause, bs.lastRebootCause)
            && Objects.equals(this.lastReport, bs.lastReport)
            && Objects.equals(this.lastSystemReboot, bs.lastSystemReboot)
            && Objects.equals(this.locationType, bs.locationType) && Objects.equals(this.log, bs.log)
            && Objects.equals(this.logicalChannels, bs.logicalChannels) && Objects.equals(this.lrcConfig, bs.lrcConfig)
            && Objects.equals(this.lrcs, bs.lrcs) && Objects.equals(this.lrrID, bs.lrrID)
            && Objects.equals(this.lrrUUID, bs.lrrUUID) && Objects.equals(this.mfs, bs.mfs)
            && Objects.equals(this.model, bs.model) && Objects.equals(this.name, bs.name)
            && Objects.equals(this.now, bs.now) && Objects.equals(this.occContext, bs.occContext)
            && Objects.equals(this.owner, bs.owner) && Objects.equals(this.power, bs.power)
            && Objects.equals(this.powerConfig, bs.powerConfig) && Objects.equals(this.publicKey, bs.publicKey)
            && Objects.equals(this.rfCoverageType, bs.rfCoverageType) && Objects.equals(this.ram, bs.ram)
            && Objects.equals(this.reverseSshState, bs.reverseSshState)
            && Objects.equals(this.rfHardwareConfig, bs.rfHardwareConfig)
            && Objects.equals(this.rfRegionID, bs.rfRegionID)
            && Objects.equals(this.rfRegionIDVersion, bs.rfRegionIDVersion)
            && Objects.equals(this.rfRegionName, bs.rfRegionName) && Objects.equals(this.rfRegionHref, bs.rfRegionHref)
            && Objects.equals(this.rfScanState, bs.rfScanState) && Objects.equals(this.rfcellState, bs.rfcellState)
            && Objects.equals(this.smn, bs.smn) && Objects.equals(this.state, bs.state)
            && Objects.equals(this.stateSince, bs.stateSince) && Objects.equals(this.staticAddress, bs.staticAddress)
            && Objects.equals(this.temp, bs.temp) && Objects.equals(this.timeSync, bs.timeSync)
            && Objects.equals(this.upFrame, bs.upFrame) && Objects.equals(this.upgradePolicy, bs.upgradePolicy)
            && Objects.equals(this.vendor, bs.vendor) && Objects.equals(this.version, bs.version)
            && Objects.equals(this.wanConfig, bs.wanConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activateBeaconTransmission, activateRX2Optimization, activateSupportFor802154, adminAltGround,
            alarm1, alarm103, alarm2, alarm3, alarm4, alarm5, alarm6, allowClassB, antennasConfig, appServers, backup,
            bsSecurity, classBState, cnxState, cnxStateSince, contactInfo, cpu, creationDate, customerAdminData,
            customs, diskConfig, domains, dwFrame, fpgaBoards, gpsAntennaConfig, gpsReceiverConfig, gpsSync,
            healthState, host, identificationMode, ints, ismBand, lastGeoAlt, lastGeoLat, lastGeoLon, lastReboot,
            lastRebootCause, lastReport, lastSystemReboot, locationType, log, logicalChannels, lrcConfig, lrcs, lrrID,
            lrrUUID, mfs, model, name, now, occContext, owner, power, powerConfig, publicKey, rfCoverageType, ram,
            reverseSshState, rfHardwareConfig, rfRegionID, rfRegionIDVersion, rfRegionName, rfRegionHref, rfScanState,
            rfcellState, smn, state, stateSince, staticAddress, temp, timeSync, upFrame, upgradePolicy, vendor, version,
            wanConfig);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Bs {\n");
    sb.append("    activateBeaconTransmission: ").append(toIndentedString(activateBeaconTransmission)).append("\n");
    sb.append("    activateRX2Optimization: ").append(toIndentedString(activateRX2Optimization)).append("\n");
    sb.append("    activateSupportFor802154: ").append(toIndentedString(activateSupportFor802154)).append("\n");
    sb.append("    adminAltGround: ").append(toIndentedString(adminAltGround)).append("\n");
    sb.append("    alarm1: ").append(toIndentedString(alarm1)).append("\n");
    sb.append("    alarm103: ").append(toIndentedString(alarm103)).append("\n");
    sb.append("    alarm2: ").append(toIndentedString(alarm2)).append("\n");
    sb.append("    alarm3: ").append(toIndentedString(alarm3)).append("\n");
    sb.append("    alarm4: ").append(toIndentedString(alarm4)).append("\n");
    sb.append("    alarm5: ").append(toIndentedString(alarm5)).append("\n");
    sb.append("    alarm6: ").append(toIndentedString(alarm6)).append("\n");
    sb.append("    allowClassB: ").append(toIndentedString(allowClassB)).append("\n");
    sb.append("    antennasConfig: ").append(toIndentedString(antennasConfig)).append("\n");
    sb.append("    appServers: ").append(toIndentedString(appServers)).append("\n");
    sb.append("    backup: ").append(toIndentedString(backup)).append("\n");
    sb.append("    bsSecurity: ").append(toIndentedString(bsSecurity)).append("\n");
    sb.append("    classBState: ").append(toIndentedString(classBState)).append("\n");
    sb.append("    cnxState: ").append(toIndentedString(cnxState)).append("\n");
    sb.append("    cnxStateSince: ").append(toIndentedString(cnxStateSince)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    cpu: ").append(toIndentedString(cpu)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    customerAdminData: ").append(toIndentedString(customerAdminData)).append("\n");
    sb.append("    customs: ").append(toIndentedString(customs)).append("\n");
    sb.append("    diskConfig: ").append(toIndentedString(diskConfig)).append("\n");
    sb.append("    domains: ").append(toIndentedString(domains)).append("\n");
    sb.append("    dwFrame: ").append(toIndentedString(dwFrame)).append("\n");
    sb.append("    fpgaBoards: ").append(toIndentedString(fpgaBoards)).append("\n");
    sb.append("    gpsAntennaConfig: ").append(toIndentedString(gpsAntennaConfig)).append("\n");
    sb.append("    gpsReceiverConfig: ").append(toIndentedString(gpsReceiverConfig)).append("\n");
    sb.append("    gpsSync: ").append(toIndentedString(gpsSync)).append("\n");
    sb.append("    healthState: ").append(toIndentedString(healthState)).append("\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    identificationMode: ").append(toIndentedString(identificationMode)).append("\n");
    sb.append("    ints: ").append(toIndentedString(ints)).append("\n");
    sb.append("    ismBand: ").append(toIndentedString(ismBand)).append("\n");
    sb.append("    lastGeoAlt: ").append(toIndentedString(lastGeoAlt)).append("\n");
    sb.append("    lastGeoLat: ").append(toIndentedString(lastGeoLat)).append("\n");
    sb.append("    lastGeoLon: ").append(toIndentedString(lastGeoLon)).append("\n");
    sb.append("    lastReboot: ").append(toIndentedString(lastReboot)).append("\n");
    sb.append("    lastRebootCause: ").append(toIndentedString(lastRebootCause)).append("\n");
    sb.append("    lastReport: ").append(toIndentedString(lastReport)).append("\n");
    sb.append("    lastSystemReboot: ").append(toIndentedString(lastSystemReboot)).append("\n");
    sb.append("    locationType: ").append(toIndentedString(locationType)).append("\n");
    sb.append("    log: ").append(toIndentedString(log)).append("\n");
    sb.append("    logicalChannels: ").append(toIndentedString(logicalChannels)).append("\n");
    sb.append("    lrcConfig: ").append(toIndentedString(lrcConfig)).append("\n");
    sb.append("    lrcs: ").append(toIndentedString(lrcs)).append("\n");
    sb.append("    lrrID: ").append(toIndentedString(lrrID)).append("\n");
    sb.append("    lrrUUID: ").append(toIndentedString(lrrUUID)).append("\n");
    sb.append("    mfs: ").append(toIndentedString(mfs)).append("\n");
    sb.append("    model: ").append(toIndentedString(model)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    now: ").append(toIndentedString(now)).append("\n");
    sb.append("    occContext: ").append(toIndentedString(occContext)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    power: ").append(toIndentedString(power)).append("\n");
    sb.append("    powerConfig: ").append(toIndentedString(powerConfig)).append("\n");
    sb.append("    publicKey: ").append(toIndentedString(publicKey)).append("\n");
    sb.append("    rfCoverageType: ").append(toIndentedString(rfCoverageType)).append("\n");
    sb.append("    ram: ").append(toIndentedString(ram)).append("\n");
    sb.append("    reverseSshState: ").append(toIndentedString(reverseSshState)).append("\n");
    sb.append("    rfHardwareConfig: ").append(toIndentedString(rfHardwareConfig)).append("\n");
    sb.append("    rfRegionID: ").append(toIndentedString(rfRegionID)).append("\n");
    sb.append("    rfRegionIDVersion: ").append(toIndentedString(rfRegionIDVersion)).append("\n");
    sb.append("    rfRegionName: ").append(toIndentedString(rfRegionName)).append("\n");
    sb.append("    rfRegionHref: ").append(toIndentedString(rfRegionHref)).append("\n");
    sb.append("    rfScanState: ").append(toIndentedString(rfScanState)).append("\n");
    sb.append("    rfcellState: ").append(toIndentedString(rfcellState)).append("\n");
    sb.append("    smn: ").append(toIndentedString(smn)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    stateSince: ").append(toIndentedString(stateSince)).append("\n");
    sb.append("    staticAddress: ").append(toIndentedString(staticAddress)).append("\n");
    sb.append("    temp: ").append(toIndentedString(temp)).append("\n");
    sb.append("    timeSync: ").append(toIndentedString(timeSync)).append("\n");
    sb.append("    upFrame: ").append(toIndentedString(upFrame)).append("\n");
    sb.append("    upgradePolicy: ").append(toIndentedString(upgradePolicy)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    wanConfig: ").append(toIndentedString(wanConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
