/*
 * ThingPark things management Devices API
 * REST interface for Devices management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.appserver;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * TpxIotFlow
 */
@JsonPropertyOrder({ TpxIotFlow.JSON_PROPERTY_CONNECTION_ID, TpxIotFlow.JSON_PROPERTY_STATE,
    TpxIotFlow.JSON_PROPERTY_CONNECTOR_ID, TpxIotFlow.JSON_PROPERTY_FLOW_ID })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-29T11:48:00.371272895+02:00[Europe/Paris]", comments = "Generator version: 7.6.0")
public class TpxIotFlow {
  public static final String JSON_PROPERTY_CONNECTION_ID = "connectionId";
  private String connectionId;

  /**
   * IoT Flow Connection state: - OPENED: the connection is up and running -
   * OPENING: the connection is currently opening - CLOSED: the connection is
   * closed - CLOSING: the connection is currently closing - AUTHENTICATING: the
   * connection is currently authenticating - AUTHENTICATION_FAILED: failed to
   * authenticate on the remote server with provided credentials - UNREACHABLE:
   * the remote server is unreachable and therefore the connection will be retried
   * - DEACTIVATED: the connection is deactivated
   */
  public enum StateEnum {
    OPENED("OPENED"),

    OPENING("OPENING"),

    CLOSED("CLOSED"),

    CLOSING("CLOSING"),

    AUTHENTICATING("AUTHENTICATING"),

    AUTHENTICATION_FAILED("AUTHENTICATION_FAILED"),

    UNREACHABLE("UNREACHABLE"),

    DEACTIVATED("DEACTIVATED");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_CONNECTOR_ID = "connectorId";
  private String connectorId;

  public static final String JSON_PROPERTY_FLOW_ID = "flowId";
  private String flowId;

  public TpxIotFlow() {
  }

  @JsonCreator
  public TpxIotFlow(@JsonProperty(JSON_PROPERTY_STATE) StateEnum state) {
    this();
    this.state = state;
  }

  public TpxIotFlow connectionId(String connectionId) {

    this.connectionId = connectionId;
    return this;
  }

  /**
   * ID of the associated Connection in TPX IoT Flow
   * 
   * @return connectionId
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CONNECTION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getConnectionId() {
    return connectionId;
  }

  @JsonProperty(JSON_PROPERTY_CONNECTION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setConnectionId(String connectionId) {
    this.connectionId = connectionId;
  }

  /**
   * IoT Flow Connection state: - OPENED: the connection is up and running -
   * OPENING: the connection is currently opening - CLOSED: the connection is
   * closed - CLOSING: the connection is currently closing - AUTHENTICATING: the
   * connection is currently authenticating - AUTHENTICATION_FAILED: failed to
   * authenticate on the remote server with provided credentials - UNREACHABLE:
   * the remote server is unreachable and therefore the connection will be retried
   * - DEACTIVATED: the connection is deactivated
   * 
   * @return state
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StateEnum getState() {
    return state;
  }

  public TpxIotFlow connectorId(String connectorId) {

    this.connectorId = connectorId;
    return this;
  }

  /**
   * ID of the associated Connector in TPX IoT Flow
   * 
   * @return connectorId
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CONNECTOR_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getConnectorId() {
    return connectorId;
  }

  @JsonProperty(JSON_PROPERTY_CONNECTOR_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setConnectorId(String connectorId) {
    this.connectorId = connectorId;
  }

  public TpxIotFlow flowId(String flowId) {

    this.flowId = flowId;
    return this;
  }

  /**
   * ID of the associated Flow in TPX IoT Flow
   * 
   * @return flowId
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_FLOW_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFlowId() {
    return flowId;
  }

  @JsonProperty(JSON_PROPERTY_FLOW_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFlowId(String flowId) {
    this.flowId = flowId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TpxIotFlow tpxIotFlow = (TpxIotFlow) o;
    return Objects.equals(this.connectionId, tpxIotFlow.connectionId) && Objects.equals(this.state, tpxIotFlow.state)
            && Objects.equals(this.connectorId, tpxIotFlow.connectorId)
            && Objects.equals(this.flowId, tpxIotFlow.flowId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connectionId, state, connectorId, flowId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TpxIotFlow {\n");
    sb.append("    connectionId: ").append(toIndentedString(connectionId)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    connectorId: ").append(toIndentedString(connectorId)).append("\n");
    sb.append("    flowId: ").append(toIndentedString(flowId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
