/*
 * ThingPark things management Devices API
 * REST interface for Devices management. 
 *
 * The version of the OpenAPI document: 7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package lora.ns.actility.api.model.appserver;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

import lora.ns.actility.api.model.common.Domain;
import lora.ns.actility.api.model.common.OccContext;

/**
 * AppServer
 */
@JsonPropertyOrder({ AppServer.JSON_PROPERTY_I_D, AppServer.JSON_PROPERTY_BASE_STATION_COUNT,
    AppServer.JSON_PROPERTY_CONTENT_TYPE, AppServer.JSON_PROPERTY_DESCRIPTION, AppServer.JSON_PROPERTY_DEVICE_COUNT,
    AppServer.JSON_PROPERTY_DOMAINS, AppServer.JSON_PROPERTY_DOWNLINK_SECURITY, AppServer.JSON_PROPERTY_HEALTH_STATE,
    AppServer.JSON_PROPERTY_MULTICAST_GROUP_COUNT, AppServer.JSON_PROPERTY_NAME, AppServer.JSON_PROPERTY_STATE,
    AppServer.JSON_PROPERTY_TYPE, AppServer.JSON_PROPERTY_VALIDATION_STATE, AppServer.JSON_PROPERTY_OCC_CONTEXT,
    AppServer.JSON_PROPERTY_CUSTOM_HTTP_HEADERS, AppServer.JSON_PROPERTY_DESTINATIONS,
    AppServer.JSON_PROPERTY_FLOW_MATCHER_TAGS, AppServer.JSON_PROPERTY_NOTIFICATION,
    AppServer.JSON_PROPERTY_TPX_IOT_FLOW })

public class AppServer {
  public static final String JSON_PROPERTY_I_D = "ID";
  private String ID;

  public static final String JSON_PROPERTY_BASE_STATION_COUNT = "baseStationCount";
  private Integer baseStationCount;

  /**
   * Content Type of messages sent by LRC on tunneling interface.
   */
  public enum ContentTypeEnum {
    XML("xml"),

    JSON("json"),

    JSONTYPED("jsontyped");

    private String value;

    ContentTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ContentTypeEnum fromValue(String value) {
      for (ContentTypeEnum b : ContentTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
  private ContentTypeEnum contentType = ContentTypeEnum.XML;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DEVICE_COUNT = "deviceCount";
  private Integer deviceCount;

  public static final String JSON_PROPERTY_DOMAINS = "domains";
  private List<Domain> domains = new ArrayList<>();

  public static final String JSON_PROPERTY_DOWNLINK_SECURITY = "downlinkSecurity";
  private DownlinkSecurity downlinkSecurity;

  /**
   * Application server health state: - ACTIVE: the application is up and running
   * - INIT: the application server is in a transient state, for example
   * connection is being established - ERROR: the application server is
   * unreachable - DEACTIVATED: the application server is deactivated
   */
  public enum HealthStateEnum {
    ACTIVE("ACTIVE"),

    INIT("INIT"),

    ERROR("ERROR"),

    DEACTIVATED("DEACTIVATED");

    private String value;

    HealthStateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static HealthStateEnum fromValue(String value) {
      for (HealthStateEnum b : HealthStateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_HEALTH_STATE = "healthState";
  private HealthStateEnum healthState;

  public static final String JSON_PROPERTY_MULTICAST_GROUP_COUNT = "multicastGroupCount";
  private Integer multicastGroupCount;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_STATE = "state";
  private AppServerState state;

  /**
   * AS type (&#x60;HTTP&#x60;, &#x60;HTTP_CELLULAR&#x60; or &#x60;KAFKA&#x60;)
   * &#x60;HTTP_CELLULAR&#x60; is only applicable to **ThingPark Wireless** if the
   * cellular connectivity is enabled by the Operator.
   */
  public enum TypeEnum {
    HTTP("HTTP"),

    HTTP_CELLULAR("HTTP_CELLULAR"),

    KAFKA("KAFKA");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  protected TypeEnum type = TypeEnum.HTTP;

  public static final String JSON_PROPERTY_VALIDATION_STATE = "validationState";
  private AppServerValidationState validationState;

  public static final String JSON_PROPERTY_OCC_CONTEXT = "occContext";
  private OccContext occContext;

  public static final String JSON_PROPERTY_CUSTOM_HTTP_HEADERS = "customHttpHeaders";
  private List<AppServerCustomHttpHeadersInner> customHttpHeaders = new ArrayList<>();

  public static final String JSON_PROPERTY_DESTINATIONS = "destinations";
  private List<AppServerHttpLorawanDestination> destinations = new ArrayList<>();

  public static final String JSON_PROPERTY_FLOW_MATCHER_TAGS = "flowMatcherTags";
  private List<String> flowMatcherTags = new ArrayList<>();

  public static final String JSON_PROPERTY_NOTIFICATION = "notification";
  private AppServerKafkaNotification notification;

  public static final String JSON_PROPERTY_TPX_IOT_FLOW = "tpxIotFlow";
  private TpxIotFlow tpxIotFlow;

  public AppServer() {
  }

  @JsonCreator
  public AppServer(@JsonProperty(JSON_PROPERTY_I_D) String ID,
          @JsonProperty(JSON_PROPERTY_BASE_STATION_COUNT) Integer baseStationCount,
          @JsonProperty(JSON_PROPERTY_DEVICE_COUNT) Integer deviceCount,
          @JsonProperty(JSON_PROPERTY_HEALTH_STATE) HealthStateEnum healthState,
          @JsonProperty(JSON_PROPERTY_MULTICAST_GROUP_COUNT) Integer multicastGroupCount,
          @JsonProperty(JSON_PROPERTY_VALIDATION_STATE) AppServerValidationState validationState) {
    this();
    this.ID = ID;
    this.baseStationCount = baseStationCount;
    this.deviceCount = deviceCount;
    this.healthState = healthState;
    this.multicastGroupCount = multicastGroupCount;
    this.validationState = validationState;
  }

  /**
   * ID of the AS (generated)
   * 
   * @return ID
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getID() {
    return ID;
  }

  /**
   * Number of Base Stations associated with the Application Server through direct
   * association. If the authenticated user has domain restrictions, only base
   * stations matching the domain restrictions are counted.
   * 
   * @return baseStationCount
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_BASE_STATION_COUNT)

  public Integer getBaseStationCount() {
    return baseStationCount;
  }

  public AppServer contentType(ContentTypeEnum contentType) {

    this.contentType = contentType;
    return this;
  }

  /**
   * Content Type of messages sent by LRC on tunneling interface.
   * 
   * @return contentType
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContentTypeEnum getContentType() {
    return contentType;
  }

  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContentType(ContentTypeEnum contentType) {
    this.contentType = contentType;
  }

  public AppServer description(String description) {

    this.description = description;
    return this;
  }

  /**
   * Application Server description
   * 
   * @return description
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Number of Devices associated with the Application Server through direct
   * association. Devices associated with the Application Server through AS
   * Routing Profiles are not taken into account. If the authenticated user has
   * domain restrictions, only devices matching the domain restrictions are
   * counted.
   * 
   * @return deviceCount
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DEVICE_COUNT)

  public Integer getDeviceCount() {
    return deviceCount;
  }

  public AppServer domains(List<Domain> domains) {

    this.domains = domains;
    return this;
  }

  public AppServer addDomainsItem(Domain domainsItem) {
    if (this.domains == null) {
      this.domains = new ArrayList<>();
    }
    this.domains.add(domainsItem);
    return this;
  }

  /**
   * List of associated domains. The list cannot contain more than one domain for
   * a given group.
   * 
   * @return domains
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOMAINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Domain> getDomains() {
    return domains;
  }

  @JsonProperty(JSON_PROPERTY_DOMAINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomains(List<Domain> domains) {
    this.domains = domains;
  }

  public AppServer downlinkSecurity(DownlinkSecurity downlinkSecurity) {

    this.downlinkSecurity = downlinkSecurity;
    return this;
  }

  /**
   * Get downlinkSecurity
   * 
   * @return downlinkSecurity
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOWNLINK_SECURITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DownlinkSecurity getDownlinkSecurity() {
    return downlinkSecurity;
  }

  @JsonProperty(JSON_PROPERTY_DOWNLINK_SECURITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDownlinkSecurity(DownlinkSecurity downlinkSecurity) {
    this.downlinkSecurity = downlinkSecurity;
  }

  /**
   * Application server health state: - ACTIVE: the application is up and running
   * - INIT: the application server is in a transient state, for example
   * connection is being established - ERROR: the application server is
   * unreachable - DEACTIVATED: the application server is deactivated
   * 
   * @return healthState
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_HEALTH_STATE)

  public HealthStateEnum getHealthState() {
    return healthState;
  }

  /**
   * Number of Multicast Groups associated with the Application Server through
   * direct association. Multicast Groups associated with the Application Server
   * through AS Routing Profiles are not taken into account. If the authenticated
   * user has domain restrictions, only multicast groups matching the domain
   * restrictions are counted.
   * 
   * @return multicastGroupCount
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MULTICAST_GROUP_COUNT)

  public Integer getMulticastGroupCount() {
    return multicastGroupCount;
  }

  public AppServer name(String name) {

    this.name = name;
    return this;
  }

  /**
   * Name of the AS
   * 
   * @return name
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  public AppServer state(AppServerState state) {

    this.state = state;
    return this;
  }

  /**
   * Get state
   * 
   * @return state
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AppServerState getState() {
    return state;
  }

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(AppServerState state) {
    this.state = state;
  }

  public AppServer type(TypeEnum type) {

    this.type = type;
    return this;
  }

  /**
   * AS type (&#x60;HTTP&#x60;, &#x60;HTTP_CELLULAR&#x60; or &#x60;KAFKA&#x60;)
   * &#x60;HTTP_CELLULAR&#x60; is only applicable to **ThingPark Wireless** if the
   * cellular connectivity is enabled by the Operator.
   * 
   * @return type
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Get validationState
   * 
   * @return validationState
   **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_VALIDATION_STATE)

  public AppServerValidationState getValidationState() {
    return validationState;
  }

  public AppServer occContext(OccContext occContext) {

    this.occContext = occContext;
    return this;
  }

  /**
   * Get occContext
   * 
   * @return occContext
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OCC_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OccContext getOccContext() {
    return occContext;
  }

  @JsonProperty(JSON_PROPERTY_OCC_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOccContext(OccContext occContext) {
    this.occContext = occContext;
  }

  public AppServer customHttpHeaders(List<AppServerCustomHttpHeadersInner> customHttpHeaders) {

    this.customHttpHeaders = customHttpHeaders;
    return this;
  }

  public AppServer addCustomHttpHeadersItem(AppServerCustomHttpHeadersInner customHttpHeadersItem) {
    if (this.customHttpHeaders == null) {
      this.customHttpHeaders = new ArrayList<>();
    }
    this.customHttpHeaders.add(customHttpHeadersItem);
    return this;
  }

  /**
   * A list of HTTP headers to be added in HTTP requests sent to the application.
   * Accept, Host, User-Agent, Content-Length and Content-Type headers cannot be
   * customized. A given HTTP header name can be configured only once (case
   * insensitive). This field is not returned if the authenticated user has domain
   * restrictions but does not have &#x60;&lt;Subscription&gt;/a&#x60; access
   * right.
   * 
   * @return customHttpHeaders
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_HTTP_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AppServerCustomHttpHeadersInner> getCustomHttpHeaders() {
    return customHttpHeaders;
  }

  @JsonProperty(JSON_PROPERTY_CUSTOM_HTTP_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomHttpHeaders(List<AppServerCustomHttpHeadersInner> customHttpHeaders) {
    this.customHttpHeaders = customHttpHeaders;
  }

  public AppServer destinations(List<AppServerHttpLorawanDestination> destinations) {

    this.destinations = destinations;
    return this;
  }

  public AppServer addDestinationsItem(AppServerHttpLorawanDestination destinationsItem) {
    if (this.destinations == null) {
      this.destinations = new ArrayList<>();
    }
    this.destinations.add(destinationsItem);
    return this;
  }

  /**
   * Application Server destination
   * 
   * @return destinations
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DESTINATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AppServerHttpLorawanDestination> getDestinations() {
    return destinations;
  }

  @JsonProperty(JSON_PROPERTY_DESTINATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinations(List<AppServerHttpLorawanDestination> destinations) {
    this.destinations = destinations;
  }

  public AppServer flowMatcherTags(List<String> flowMatcherTags) {

    this.flowMatcherTags = flowMatcherTags;
    return this;
  }

  public AppServer addFlowMatcherTagsItem(String flowMatcherTagsItem) {
    if (this.flowMatcherTags == null) {
      this.flowMatcherTags = new ArrayList<>();
    }
    this.flowMatcherTags.add(flowMatcherTagsItem);
    return this;
  }

  /**
   * IoT Flow matcher tags defined at Application Server level. When defined at
   * both Device level and Application Server level, the Device level information
   * has precedence over Application Server level information.
   * 
   * @return flowMatcherTags
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_MATCHER_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFlowMatcherTags() {
    return flowMatcherTags;
  }

  @JsonProperty(JSON_PROPERTY_FLOW_MATCHER_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowMatcherTags(List<String> flowMatcherTags) {
    this.flowMatcherTags = flowMatcherTags;
  }

  public AppServer notification(AppServerKafkaNotification notification) {

    this.notification = notification;
    return this;
  }

  /**
   * Get notification
   * 
   * @return notification
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NOTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AppServerKafkaNotification getNotification() {
    return notification;
  }

  @JsonProperty(JSON_PROPERTY_NOTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotification(AppServerKafkaNotification notification) {
    this.notification = notification;
  }

  public AppServer tpxIotFlow(TpxIotFlow tpxIotFlow) {

    this.tpxIotFlow = tpxIotFlow;
    return this;
  }

  /**
   * Get tpxIotFlow
   * 
   * @return tpxIotFlow
   **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TPX_IOT_FLOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TpxIotFlow getTpxIotFlow() {
    return tpxIotFlow;
  }

  @JsonProperty(JSON_PROPERTY_TPX_IOT_FLOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTpxIotFlow(TpxIotFlow tpxIotFlow) {
    this.tpxIotFlow = tpxIotFlow;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppServer appServer = (AppServer) o;
    return Objects.equals(this.ID, appServer.ID) && Objects.equals(this.baseStationCount, appServer.baseStationCount)
            && Objects.equals(this.contentType, appServer.contentType)
            && Objects.equals(this.description, appServer.description)
            && Objects.equals(this.deviceCount, appServer.deviceCount)
            && Objects.equals(this.domains, appServer.domains)
            && Objects.equals(this.downlinkSecurity, appServer.downlinkSecurity)
            && Objects.equals(this.healthState, appServer.healthState)
            && Objects.equals(this.multicastGroupCount, appServer.multicastGroupCount)
            && Objects.equals(this.name, appServer.name) && Objects.equals(this.state, appServer.state)
            && Objects.equals(this.type, appServer.type)
            && Objects.equals(this.validationState, appServer.validationState)
            && Objects.equals(this.occContext, appServer.occContext)
            && Objects.equals(this.customHttpHeaders, appServer.customHttpHeaders)
            && Objects.equals(this.destinations, appServer.destinations)
            && Objects.equals(this.flowMatcherTags, appServer.flowMatcherTags)
            && Objects.equals(this.notification, appServer.notification)
            && Objects.equals(this.tpxIotFlow, appServer.tpxIotFlow);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ID, baseStationCount, contentType, description, deviceCount, domains, downlinkSecurity,
            healthState, multicastGroupCount, name, state, type, validationState, occContext, customHttpHeaders,
            destinations, flowMatcherTags, notification, tpxIotFlow);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppServer {\n");
    sb.append("    ID: ").append(toIndentedString(ID)).append("\n");
    sb.append("    baseStationCount: ").append(toIndentedString(baseStationCount)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    deviceCount: ").append(toIndentedString(deviceCount)).append("\n");
    sb.append("    domains: ").append(toIndentedString(domains)).append("\n");
    sb.append("    downlinkSecurity: ").append(toIndentedString(downlinkSecurity)).append("\n");
    sb.append("    healthState: ").append(toIndentedString(healthState)).append("\n");
    sb.append("    multicastGroupCount: ").append(toIndentedString(multicastGroupCount)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    validationState: ").append(toIndentedString(validationState)).append("\n");
    sb.append("    occContext: ").append(toIndentedString(occContext)).append("\n");
    sb.append("    customHttpHeaders: ").append(toIndentedString(customHttpHeaders)).append("\n");
    sb.append("    destinations: ").append(toIndentedString(destinations)).append("\n");
    sb.append("    flowMatcherTags: ").append(toIndentedString(flowMatcherTags)).append("\n");
    sb.append("    notification: ").append(toIndentedString(notification)).append("\n");
    sb.append("    tpxIotFlow: ").append(toIndentedString(tpxIotFlow)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
