/*=============================================================================

  Library: CppMicroServices


Copyright Kevlin Henney, 2000, 2001, 2002. All rights reserved.
Extracted from Boost 1.46.1 and adapted for CppMicroServices.

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

=========================================================================*/

#ifndef CPPMICROSERVICES_SINGLEINVOKETASK_H
#define CPPMICROSERVICES_SINGLEINVOKETASK_H

#include <future>
#include <mutex>

namespace cppmicroservices::scrimpl
{
    using PostTask = std::packaged_task<void()>;
    class SingleInvokeTask
    {
      public:
        SingleInvokeTask() = default;
        SingleInvokeTask(SingleInvokeTask const& other) = delete;
        SingleInvokeTask& operator=(SingleInvokeTask const& other) = delete;
        SingleInvokeTask(SingleInvokeTask&& other) = delete;
        SingleInvokeTask& operator=(SingleInvokeTask&& other) = delete;
        ~SingleInvokeTask() = default;

        bool operator==(SingleInvokeTask const& rhs) const = delete;

        bool operator!=(SingleInvokeTask const& rhs) const = delete;

        bool operator<(SingleInvokeTask const& rhs) const = delete;

        void
        addTask(std::shared_ptr<PostTask> postedTask)
        {
            task = postedTask;
        }

        template <typename... Args>
        void
        operator()()
        {
            std::unique_lock<std::mutex> lock(l);
            if (executed)
            {
                return;
            }
            else
            {
                executed = true;
            }
            (*task)();
        }

      private:
        std::mutex l;
        bool executed = false;
        std::shared_ptr<PostTask> task;
    };
} // namespace cppmicroservices::scrimpl

#endif // CPPMICROSERVICES_SINGLEINVOKETASK_H
