# Awesome Stock Resources [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Build Status](https://api.travis-ci.org/neutraltone/awesome-stock-resources.svg?branch=master)](https://travis-ci.org/neutraltone/awesome-stock-resources) [![Support](https://img.shields.io/badge/Donate-PayPal-green.svg)](https://www.paypal.me/tonyphipps)

![Introductory images](/img/splash.jpg)

> A curated list of awesome stock photography, video and illustration websites.

I try my best to maintain this repository and keep it up-to-date but if you spot a broken link or a resource which isn't listed, please, feel free to make a pull request.

## Table of Contents

* [Photography](#photography)
  * [CC0-license](#cc0-license)
  * [Custom License / Usage](#custom-license--usage)
  * [Public Domain](#public-domain)
  * [Attribution required licenses](#attribution-required-licenses)
  * [Unspecified License](#unspecified-license)
* [Illustration](#illustration)
* [Vector Graphics](#vector-graphics)
* [Videos](#videos)
* [Patterns](#patterns)
* [Textures](#textures)
* [Fonts](#fonts)
* [Icons](#icons)
  * [Icon Fonts](#icon-fonts)
  * [Icons Packages and Collections](#icons-packages-and-collections)
* [Colors](#colors)
* [Aggregated Content](#aggregated-content)
* [HTML Templates](#html-templates)
* [Sounds & Music](#sounds--music)
* [Paid Resources](#paid-resources)
* [How to Contribute](#how-to-contribute)
* [How to Share](#how-to-share)
* [Donate](#donate-heart)
* [License](#license)

## Photography

### CC0-license

All the resources below have specifically specified that their content is 🌎 [:copyright: CC0-licensed](creativecommons.org/publicdomain/zero/1.0/).

* 🌎 [Altphotos](altphotos.com) - Handpicked free high-resolution photos added daily.
* 🌎 [Barn Images](barnimages.com/) - Barn Images offers you a collection of free high-resolution non-stock photography.
* [CC0.Photo](http://cc0.photo/) - CC0.photo is a project initiated by Raffael Herrmann, which serves you with free photos.
* [Crow the Stone](http://crowthestone.tumblr.com/) - Free photos to use any way you want.
* [Cupcake](http://cupcake.nilssonlee.se/) - Free do what ever you want photos by 🌎 [Jonas Nilsson Lee](twitter.com/nilsson_jonas).
* [FindA.Photo](http://finda.photo/) - search through thousands of CC0 photos by keyword and color.
* [Free Nature Stock](http://freenaturestock.com/) - Royalty-free, use them however you want, Nature Stock Photos.
* 🌎 [Freely Photos](freelyphotos.com/) - Totally free high quality Christian stock photography.
* 🌎 [Gratisography](gratisography.com/) - Free high-resolution pictures you can use on your personal and commercial projects. New pictures added weekly.
* [Jay Mantri](http://jaymantri.com/) - Free pics. Do anything. Make magic.
* [Jéshoots](http://jeshoots.com/) - Photos for business or personal use in high resolution for free.
* 🌎 [LibreShot](libreshot.com/) - A collection of hundreds of high quality free stock images for personal or commercial use.
* [Life of Pix](http://www.lifeofpix.com/) - Free high-resolution photos, no copyright restrictions. Photographs added weekly.
* [Little Visuals](http://littlevisuals.co/) - Hi-res images zipped up in your inbox. Use them anyway you want.
* 🌎 [Magdeleine](magdeleine.co/browse/) - A selection of free photos curated by 🌎 [Magdeleine](twitter.com/MagdeleinePhoto).
* 🌎 [MMT](mmtstock.com/) - New photos by [Jeffrey Betts](http://jeffreybetts.me/) added every week.
* [Moveast](http://moveast.me/) - This is a journey of a Portuguese guy moving.
* 🌎 [Negative Space](negativespace.co/) - Stock photos added every week.
* 🌎 [Openverse](openverse.org) - A meta search across several libraries to find adaptable / editable images and audio files.
* 🌎 [Pexels](www.pexels.com/) - 20 new high-quality photos daily.
* 🌎 [Photo Crops](www.photocrops.com/) - Five high resolution photos added every week, sometimes more.
* [Pickle Jar](http://www.picklejar.in/) - High-resolution images of everyday india. One new image every day.
* [Pickupimage](http://pickupimage.com/) - Free download high quality premium free stock images, public domain photos.
* 🌎 [Pixabay](pixabay.com) - Stock photos, illustrations, vectors and videos.
* 🌎 [Realgraphy](realgraphy.org/) - Authentic Non-Stock Photos for Free. Forever.
* [Realistic Shots](http://realisticshots.com/) - 7 new photos added every week.
* 🌎 [Skitter Photo](skitterphoto.com/) - Public domain pictures and stock photos for commercial use.
* [Skuawk](http://skuawk.com/) - Skuawk public domain photos, free, beautiful and artistically loud.
* 🌎 [Snappy Goat](snappygoat.com/) - Over 12 million public domain & CC0 licensed images.
* [Snapwire Snaps](http://snapwiresnaps.tumblr.com/) - Commissioned photos from 170,000 of the world's most talented photographers.
* 🌎 [SpaceX Photos](www.flickr.com/photos/spacex/) - Promotional SpaceX stock photography.
* [Splashbase](http://www.splashbase.co/) - Search & discover free, hi-resolution photos & videos.
* 🌎 [Stockified](www.stockified.com/) - Free pictures taken in India by Kiran BV and [Aditya G Bharadwaj](http://ab-dz.com/).
* 🌎 [Stocksnap](stocksnap.io/) - Hundreds of high resolution images added weekly.
* [Stokpic](http://stokpic.com/) - Free Stock Photos For Commercial Use.
* [Streetwill](http://streetwill.co/) - Free hi-resolution vintage photos to use any way you want.
* 🌎 [The Pic Pac](thepicpac.com/) - New pacs on Monday, free pics Tuesday - Sunday.
* [Travel Coffee Book](http://travelcoffeebook.com/) - Travel photography.
* 🌎 [Wesaturate](www.wesaturate.com/) - A collection of completely free CC0 images in RAW and JPG formats.

### Custom License / Usage

These following photography resources are those who have declared their own usage and restriction terms. These can be found by clicking the *(license)* link next to the resource.

* [Bara Art](http://www.bara-art.com/) - [:copyright:](http://www.bara-art.com/about/) The world always needs high quality photography! Here they are for you, so make something awesome out of them.
* [Compfight.com](http://compfight.com/) - 🌎 [:copyright:](www.flickr.com/creativecommons/) An image search engine tailored to efficiently locate images for blogs, comps, inspiration, and research.
* [Death to the Stock Photo](http://join.deathtothestockphoto.com/) - [:copyright:](http://www.mediafire.com/file/2ifplcw682487nz/Death+to+the+Stock+Photo+-+Photograph+End+User+License+%281-2014%29+%281%29.pdf) Free monthly photos for all your creative needs.
* [Designer Pics](http://www.designerspics.com) - [:copyright:](http://www.designerspics.com/faq-and-terms/) Free photographs for personal and commercial by 🌎 [Jeshu John](twitter.com/jeshujohn).
* 🌎 [Foodies Feed](www.foodiesfeed.com/) - Free food based images. 🌎 [:copyright:](www.foodiesfeed.com/faq/).
* 🌎 [Freerange](freerangestock.com/) - 🌎 [:copyright:](freerangestock.com/licensing.php) Quality stock photos for commercial and non-commercial use. For free.
* 🌎 [Good Stock Photos](goodstock.photos/) - 🌎 [:copyright:](goodstock.photos/about/) One free to use photo added everyday.
* 🌎 [ISO Republic](isorepublic.com/) - 🌎 [:copyright:](isorepublic.com/terms/) ISO Republic provides exclusive free stock photos for creatives.
* 🌎 [Kaboom Pics](kaboompics.com/) - 🌎 [:copyright:](kaboompics.com/page/license-and-faq) Great place to get breathtaking Free Pictures for business or personal projects.
* 🌎 [morgueFile](morguefile.com/) - 🌎 [:copyright:](morguefile.com/terms) Free photo archive by creatives, for creatives.
* 🌎 [Photober](www.photober.com/) - 🌎 [:copyright:](www.photober.com/terms/) Free of charge photo downloading site for personal or commercial use.
* [PhotoStockEditor](http://photostockeditor.com) - [:copyright:](http://photostockeditor.com/#small-dialog) High-resolution weekly images for Personal & Commercial use.
* 🌎 [Pic Jumbo](picjumbo.com/) - 🌎 [:copyright:](picjumbo.com/faq-and-terms/) Totally free photos for your commercial & personal works.
* 🌎 [Picography](picography.co/) - 🌎 [:copyright:](picography.co/terms/) Free hi-resolution photos. Use them however you like.
* 🌎 [Reshot](www.reshot.com/) - 🌎 [:copyright:](www.reshot.com/license) Handpicked, non-stocky images. Yours to use as you wish.
* 🌎 [Rawpixel](www.rawpixel.com/) - 🌎 [:copyright:](www.rawpixel.com/free-image-license) Redefining stock imagery with authentically styled and unique stock photos (Subscribe required).
* [Shutteroo](http://shutteroo.com/) - [:copyright:](http://shutteroo.com/about/) Free high-resolution travel images.
* 🌎 [Split Shire](www.splitshire.com/) - 🌎 [:copyright:](www.splitshire.com/about/) Real photos for commercial use with no copyright restrictions and a real look.
* [Startup Stock Photos](http://startupstockphotos.com/) - [:copyright:](http://startupstockphotos.com/terms-of-use) Startup based photography.
* 🌎 [Unsplash](unsplash.com/) - 🌎 [:copyright:](unsplash.com/license) User submitted, free high-resolution photos.

### Public Domain

A collection of links to public domain photography resources.

* 🌎 [Good Free Photos](www.goodfreephotos.com) - 🌎 [:copyright:](www.goodfreephotos.com/pages/creative-commons-license-terms) A large free stock photo site with thousands of public domain photos including landscapes, objects, animals, plants, textures, and many other free photos. All photos taken by 🌎 [the website owner](www.goodfreephotos.com/pages/about-me).
* 🌎 [Flickr Commons](www.flickr.com/commons) - 🌎 [:copyright:](www.flickr.com/commons/usage/) Flickr's catalogue of the worlds public photo archives.
* 🌎 [New Old Stock](nos.twnsnd.co/) - 🌎 [:copyright:](nos.twnsnd.co/rights-and-usage) Vintage photos from the public archive. of known copyright restrictions.
* 🌎 [NYPL Digital Collections](digitalcollections.nypl.org/) - 🌎 [:copyright:](www.nypl.org/help/about-nypl/legal-notices/website-terms-and-conditions) 180.000 items are Public Domain since January 6th 2016 🌎 [Public Domain Collections: Free to Share & Reuse](www.nypl.org/research/collections/digital-collections/public-domain)
* 🌎 [Project Apollo Archive](www.flickr.com/people/projectapolloarchive/?rb=1) - 🌎 [:copyright:](creativecommons.org/publicdomain/mark/1.0/) High-resolution Apollo imagery scanned by NASA's Johnson Space Center.
* [Public Domain Archive](http://publicdomainarchive.com/) - 🌎 [:copyright:](creativecommons.org/publicdomain/zero/1.0/) New stock photos every single week.

### Attribution Required licenses

The photographs on the following resources require Attribution unless otherwise stated on the website itself. These use a mixture of license, all of which have been linked to next to them.

* [Albumarium](http://albumarium.com/) - [:copyright:](http://albumarium.com/terms) The "best" place to find & share beautiful images.
* [BucketListly](http://photos.bucketlistly.com/) - A free creative common collection of travel photos anyone can use.
* [IM Creator](http://imcreator.com/free) - Also includes Website templates and icons. Some  🌎 [CC0-licensed](creativecommons.org/publicdomain/zero/1.0/)) works, check the license before use.
* 🌎 [NASA Jet Propulsion Laboratory](www.jpl.nasa.gov/spaceimages/) - 🌎 [:copyright:](www.jpl.nasa.gov/imagepolicy/) Graphics and photos of space and spaceflight.
* [PhotoEverywhere](http://photoeverywhere.co.uk/) - 🌎 [:copyright:](creativecommons.org/licenses/by/2.5/) Globe-trot our collection of high resolution Travel Stock Images More than 3600 photos that are Free to use and ready for instant download.
* 🌎 [Superfamous](superfamous.com/Images) - 🌎 [:copyright:](creativecommons.org/licenses/by/3.0/) Superfamous CC BY 3.0 licensed images by 🌎 [Folkert Gorter](twitter.com/folkertgorter).
* [UKBlackTech](http://ukblacktech.com/stockphotos/) - 🌎 [:copyright:](creativecommons.org/licenses/by/4.0/) Photographers of British based BAME (Black, Asian, and minority ethnic) people in tech.
* 🌎 [Women of Color in Tech](www.flickr.com/photos/wocintechchat/) - 🌎 [:copyright:](creativecommons.org/licenses/by/2.0/) Licensed picture from Women of Color in Tech.

### Unspecified License

These resources haven't specified any formal terms of use or licenses.

* [Freejpg](http://en.freejpg.com.ar/) - Free image bank for commercial and editorial use.
* [Function](http://wefunction.com/category/free-photos/) - High-resolution photos by Liam McKay.
* [Refe Real Life Photos](http://getrefe.tumblr.com) - Free real life photos from [REFE](http://getrefe.com/).
* [titania foto](http://www.titania-foto.com) - The free image database
* [Trunklog](http://trunklog.com/) - A collection of photos from photographer 🌎 [Magnus Jälthammar](twitter.com/jalthammar).
* 🌎 [Mockup World](www.mockupworld.co) - A mixture of free and premium mockup in-situation templates.
* [Wunderstock](http://www.Wunderstock.com/) - 670 (and counting) free HD images for your web and design projects.

## Illustration

A collection of illustration resources which contain a mixture of historical archive, contemporary and public domain assets.

* 🌎 [Biodiversity Heritage Library](www.flickr.com/people/biodivlibrary/) 🌎 [:copyright:](creativecommons.org/publicdomain/mark/1.0/) 🌎 [:copyright:](creativecommons.org/licenses/by/2.0/) A mix of Public Domain and Attribution (CC BY 2.0) licenses. Nearly 150,000 exquisite, historical illustrations of life on Earth.
* 🌎 [British Library Illustration Archive](www.flickr.com/photos/britishlibrary/) - [:copyright:](http://www.bl.uk/aboutus/terms/copyright/index.html) The British Library’s collections on Flickr Commons offer access to millions of public domain images.
* 🌎 [Old Book Illustrations](www.oldbookillustrations.com/) - 🌎 [:copyright:](www.oldbookillustrations.com/terms-of-use/) A massive collection of illustrations from old books.
* 🌎 [unDraw](undraw.co/) - 🌎 [:copyright:](undraw.co/license) Open-source illustrations for every project you can imagine and create.
* 🌎 [WooBro.design](woobro.design/) - 🌎 [:copyright:](creativecommons.org/licenses/by/4.0/) CC-BY licensed vector image illustrations with sources.

## Vector Graphics

A collection of resources which contain stock graphical elements which don't fit in the other sections.

* 🌎 [AMCharts - Free SVG Maps](www.amcharts.com/svg-maps/) - 🌎 [:copyright:](creativecommons.org/licenses/by-nc/4.0/) A directory of free non-commercial, attribution licensed SVG maps in two level of details: High and low.
* 🌎 [Bioicons](bioicons.com/) - 🌎 [:copyright:](creativecommons.org/licenses/by-sa/4.0/) High quality science illustrations.
* [Facebook Design Resource](http://facebook.design/) - [:copyright:](http://facebook.design/disclaimer.html) A collection for design resources from Facebook including iOS9 GUI and various popular device templates.
* 🌎 [Freepik](www.freepik.com/) - 🌎 [:copyright:](www.freepik.com/terms_of_use) Find free vectors, PSD, icons and photos.
* [FreeVectors.net](http://www.freeVectors.net) - [:copyright:](http://www.freevectors.net/terms) A fun little community of vector lovers who share free vector graphics.
* 🌎 [Humaans](www.humaaans.com/) - 🌎 [:copyright:](creativecommons.org/share-your-work/public-domain/cc0/) CC0 licensed clipart images of humans.
* [Logo Dust](http://logodust.com/) - 🌎 [:copyright:](creativecommons.org/licenses/by/4.0/) Free CC Attribution 4.0 logo designs for your projects.
* <b><code>&nbsp;&nbsp;&nbsp;494⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;68🍴</code></b> [Mega Doodles Pack](https://github.com/MariaLetta/mega-doodles-pack)) - 🌎 [:copyright:](creativecommons.org/licenses/by-sa/4.0/) Free and big CC Attribution-ShareAlike 4.0 vector pack with hand-drawn doodles for presentations, social media, blog posts and so on. 
* 🌎 [Open Doodles](www.opendoodles.com) - [:copyright:](http://creativecommons.org/publicdomain/zero/1.0/) CC-0-licensed vector sketches/cliparts with generator and compositions.
* 🌎 [Sketch Repo](sketchrepo.com/) - 🌎 [:copyright:](sketchrepo.com/about/) Sketch Repo is a great place to discover Sketch App resources for your next design project.
* 🌎 [Vecteezy](www.vecteezy.com/) - 🌎 [:copyright:](www.vecteezy.com/terms) Discover & download free vector art from a community of Illustrators.

## Videos

A selection of websites offering high quality video stock.

* [Coverr](http://coverr.co/) - 🌎 [:copyright:](creativecommons.org/publicdomain/zero/1.0/) Beautiful, free, CC0 licensed videos for your homepage. 7 new videos every Monday.
* 🌎 [FreeStockVideo](free-stock.video/) - 🌎 [:copyright:](creativecommons.org/publicdomain/zero/1.0/) Free Beautiful Video & Footage Clips.
* [Life of Vids](http://www.lifeofvids.com/) - 🌎 [:copyright:](creativecommons.org/publicdomain/zero/1.0/) Free royalty-free videos, clips & loops.
* [Mazwai](http://mazwai.com/) - Great collection of free creative commons HD video clips & footages. Check each video for licensing terms.
* 🌎 [Mixkit](mixkit.co/free-stock-video/) - 🌎 [:copyright:](mixkit.co/license/#videoFree) High-quality stock videos that are completely free.
* 🌎 [Pexels Videos](videos.pexels.com/) - 🌎 [:copyright:](creativecommons.org/publicdomain/zero/1.0/) Completely free, CC0 licensed stock videos.
* 🌎 [Pixabay](pixabay.com/videos/) - 🌎 [:copyright:](pixabay.com/service/license/) Thousands of free stock video clips & footage from community contributors.
* 🌎 [Videezy](www.videezy.com) - 🌎 [:copyright:](www.videezy.com/terms) Free stock videos, 4k footage, and free HD video clips.
* [Vidsplay](http://www.vidsplay.com/) - [:copyright:](http://www.vidsplay.com/terms.html) Free HD stock footage (Attribution required).
* [VYOO](http://www.veed.io/vyoo) - [:copyright:](http://www.veed.io/vyoo/terms) Beautiful, Free Vertical Videos.

## Patterns

A mixture of CSS and image based pattern resources.

* [CSS3 Patterns Gallery](http://lea.verou.me/css3patterns/) - CSS3 based repeatable patterns.
* 🌎 [Gradienta](gradienta.io/) - 🌎 [:copyright:](gradienta.io/license) Multicolor CSS Gradients, JPG Downloads, 100% Free!
* [Hero Patterns](http://www.heropatterns.com/) - A collection of free CC Attribution 4.0 repeatable SVG background patterns.
* 🌎 [Low Poly Images](digital.com/blog/best-low-poly-generators/) - Collection of low poly image generators.
* 🌎 [Subtle Patterns](www.toptal.com/designers/subtlepatterns/) - Image based background textures and patterns.
* [The Pattern Library](http://thepatternlibrary.com/) - A collection of bold, bright and funky repeatable patterns.
* 🌎 [UI Gradients](uigradients.com/) - Nice, subtle linear gradients to use in your designs.

## Textures

Websites offering images suitable for texturing objects for 3D graphics.

* 🌎 [TextureHaven](texturehaven.com) - 🌎 [:copyright: CC0-licensed](creativecommons.org/publicdomain/zero/1.0/) High quality set of textures with CC0 license.

## Fonts

A mixture of free and open source font resources.

* 🌎 [Beautiful Web Type](beautifulwebtype.com) - A showcase of the best typefaces from the Google web fonts directory.
* <b><code>&nbsp;&nbsp;2861⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;96🍴</code></b> [Brick](https://github.com/alfredxing/brick)) - Webfonts that actually look good.
* [Font Fabric](http://www.fontfabric.com/category/free/) - Font Fabric's free fonts.
* 🌎 [Font Squirrel](www.fontsquirrel.com) - Handpicked fonts free for commercial use.
* 🌎 [Google Fonts](fonts.google.com/) - Interactive directory of free hosted application programming interfaces for web fonts.
* [Open Type Foundry](http://open-foundry.com/hot30) - [:copyright:](http://open-foundry.com/about) A new platform for open-source fonts in a noise-free environment.
* 🌎 [The League of Movable Type](www.theleagueofmoveabletype.com/) - Open-source type foundry.

## Icons

### Icon Fonts

A collection for icon font resources, most of which also include SVGs, which can be used in your interface and website designs.

* [Appa Sariicon](http://code.sariina.com/appa-sariicon/) [:copyright:](http://scripts.sil.org/cms/scripts/page.php?site_id=nrsi&id=OFL&_sc=1) 147 8-bit retro style webfont icons for web and mobile
* [Batch Icons](http://adamwhitcroft.com/batch/) - <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [:copyright:](https://github.com/AdamWhitcroft/Batch/blob/master/License.txt)) Icon set of 300+ icons, which is part of <b><code>&nbsp;&nbsp;3829⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;412🍴</code></b> [inuit.css](https://github.com/csswizardry/inuit.css)).
* [Devicons](http://vorillaz.github.io/devicons/#/main) - 🌎 [:copyright:](choosealicense.com/licenses/mit/) Meet Devicons, an iconic font made for developers, code jedis, ninjas, HTTPsters, evangelists and nerds(sic). 100+ icons ready to use in your next project.
* 🌎 [Iconfinder](www.iconfinder.com/) - Iconfinder provides beautiful icons to millions of designers and developers. Most icons are available under attribution. See individual licenses for more details.
* [Font Awesome](http://fontawesome.io/) - 🌎 [:copyright:](choosealicense.com/licenses/mit/) MIT licensed icon font.
* [Fontello](http://fontello.com/) - <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [:copyright:](https://github.com/fontello/fontello/wiki/What-about-license%3F)) - Fontello is a tool to quickly pack vector images into webfonts. Also includes a section of stock icons.
* 🌎 [Foundation Icon Fonts 3](zurb.com/playground/foundation-icon-fonts-3) - 🌎 [:copyright:](choosealicense.com/licenses/mit/) An icon font from Zurb, the people behind the Foundation framework.
* 🌎 [IcoMoon](icomoon.io/) - 🌎 [:copyright:](creativecommons.org/licenses/by/4.0/) Custom built and crisp icon fonts, done right.
* 🌎 [Iconstore](iconstore.co/) - 🌎 [:copyright:](iconstore.co/license/) Free Icons by First-Class Designers.
* [Ionicons](http://ionicons.com/) - 🌎 [:copyright:](choosealicense.com/licenses/mit/) The premium icon font for Ionic Framework. 100% free and open source.
* [Ligature Symbols](http://kudakurage.com/ligature_symbols/) - [:copyright:](http://scripts.sil.org/cms/scripts/page.php?site_id=nrsi&id=OFL&_sc=1) Really clean icon set including all major topics.
* 🌎 [Material Design Icons](material.io/icons/) - 🌎 [:copyright:](creativecommons.org/licenses/by/4.0/) Google's Material Icons.
* 🌎 [Octicons](octicons.github.com/) - 🌎 [:copyright:](choosealicense.com/licenses/mit/) GitHub's Icons.
* 🌎 [Open Iconic](useiconic.com/open) - [:copyright: (font)](http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web&_sc=1) 🌎 [:copyright: (icons)](creativecommons.org/licenses/by-sa/3.0/) Icon set with 223 marks in SVG.
* 🌎 [Pathlove Icons](pathlove.com/icons/) - 🌎 [:copyright:](creativecommons.org/licenses/by-nc-nd/4.0/) 100+ cute and vibrant icons. Free for personal and commercial use; attribution required.
* 🌎 [Simple Icons](simpleicons.org/) -<b><code>&nbsp;21508⭐</code></b> <b><code>&nbsp;&nbsp;2702🍴</code></b> [:copyright:](https://github.com/simple-icons/simple-icons/blob/develop/LICENSE.md)) Free SVG icons for popular brands.
* [Social Stackicons](http://stackicons.com/) - 🌎 [:copyright:](choosealicense.com/licenses/mit/) Icon set with over 60 social brands.
* 🌎 [Standart](standart.io/) - Standart: free SVG icons for use in your project.
* 🌎 [To icon](www.toicon.com/) - 🌎 [:copyright:](www.toicon.com/license) Collection of SVG icons for your project.
* <b><code>&nbsp;&nbsp;&nbsp;257⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;56🍴</code></b> [Topcoat Icons](https://github.com/topcoat/icons)) - [:copyright:](http://www.apache.org/licenses/LICENSE-2.0) Icons by [Topcoat](http://topcoat.io/).
* [Typicons](http://s-ings.com/typicons/) - [:copyright: (font)](http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web&_sc=1) 🌎 [:copyright: (icons)](creativecommons.org/licenses/by-sa/3.0/) Rounded icon set with 336 icons.
* 🌎 [Weather Icons](erikflowers.github.io/weather-icons/) - Weather Icons is the only icon font and CSS with 222 weather themed icons.
* [WeLoveIconFonts](http://weloveiconfonts.com) – A free & open source icon fonts hosting service (like Google Web Fonts, but icon fonts only).

### Icons Packages and Collections

A collection for SVG icon resources which can be used in your interface and website designs.

* 🌎 [Atlas Icons](atlasicons.vectopus.com/) - 🌎 [:copyright:](opensource.org/licenses/MIT) 2,701 free consistent icons.
* 🌎 [BlendIcons](blendicons.com/) - 🌎 [:copyright:](blendicons.com/page/licence) Free, world top icons.
* 🌎 [Bootstrap Icons](icons.getbootstrap.com/) - <b><code>&nbsp;&nbsp;7471⭐</code></b> <b><code>&nbsp;&nbsp;1070🍴</code></b> [:copyright:](https://github.com/twbs/icons/blob/main/LICENSE.md)) Free, high quality, open source icon library with over 1,800 icons.
* 🌎 [Doodle Icons](khushmeen.com/icons.html) - 🌎 [:copyright:](creativecommons.org/publicdomain/zero/1.0/) 400+ handcrafted icons free for your next project.
* [Entypo](http://www.entypo.com/) - 🌎 [:copyright:](creativecommons.org/licenses/by-sa/3.0/) Carefully crafted iconset by [Daniel Bruce](http://www.danielbruce.se/).
* 🌎 [Flowbite](flowbite.com/icons/) - 🌎 [:copyright:](opensource.org/licenses/MIT) Free and open-source SVG icons.
* <b><code>&nbsp;&nbsp;6173⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;538🍴</code></b> [Fluent UI System Icons](https://github.com/microsoft/fluentui-system-icons)) - 🌎 [:copyright:](opensource.org/licenses/MIT) Fluent System Icons are a collection of familiar, friendly and modern icons from Microsoft.
* 🌎 [Free Icons](www.iconshock.com/freeicons/) - A collection from all the open source icon collections available.
* 🌎 [Free Icons](icons.download/) - 🌎 [:copyright:](icons.download/license) Open-source vector icons in 16 styles for any project.
* [Game Icons](http://game-icons.net/) - 🌎 [:copyright:](creativecommons.org/licenses/by/3.0/) A growing collection of SVG icons aimed mostly at video games.
* 🌎 [Heroicons](heroicons.com/) - 🌎 [:copyright:](opensource.org/licenses/MIT) Beautiful, free SVG icons from the makers of Tailwind CSS.
* 🌎 [Humbleicons](humbleicons.com/) - 🌎 [:copyright:](opensource.org/licenses/MIT) A pack of 227 simple, neutral, carefully crafted icons that you can use in your personal and commercial projects for free.
* 🌎 [Iconhunt](www.iconhunt.site/) - A search engine with 150.000+ free, open sources icons.
* 🌎 [Iconmonstr](iconmonstr.com/) - 🌎 [:copyright:](iconmonstr.com/license/) A huge selection of icons in SVG and PNG format.
* 🌎 [Iconoir](iconoir.com/) - 🌎 [:copyright:](opensource.org/licenses/MIT) A Simple and Definitive Open-Source Icons Library.
* 🌎 [Lucide](lucide.dev/) - 🌎 [:copyright:](lucide.dev/license) Beautiful & consistent icon toolkit made by the community.
* <b><code>&nbsp;&nbsp;2162⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;187🍴</code></b> [Maps Icon](https://github.com/djaiss/mapsicon)) - <b><code>&nbsp;&nbsp;2162⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;187🍴</code></b> [:copyright:](https://github.com/djaiss/mapsicon#license)) Mapsicon is a free collection of maps for nearly every country in the world, available in 11 different sizes, ranging from 16x16 pixels to 1024x1024 pixels, as well as .svg format.
* 🌎 [Material Design Icons](www.materialui.co/icons) - A collections of free, material design style icons.
* <b><code>&nbsp;21508⭐</code></b> <b><code>&nbsp;&nbsp;2702🍴</code></b> [Simple Icons](https://github.com/simple-icons/simple-icons)) - [:copyright:](http://artlibre.org/licence/lal/en/) SVG icons for popular brands.
* 🌎 [The Noun Project](thenounproject.com/) - 🌎 [:copyright:](thenounproject.com/accounts/pricing/) Over 150,000 icons designed by creators from around the world. Free users must give credit to the creator.
* 🌎 [Unicorn icons](unicornicons.com/) - 🌎 [:copyright:](unicornicons.com/license) 100+ playful animated and customizable icons, available in JSON and SVG format.

## Colors

A selection of websites offering color schemes.

* [0to255](http://www.0to255.com/) - A simple tool that helps web designers find variations of any color.
* [0xrgb](http://0xrgb.com/) - A minimalistic color picker for well-known palettes (Material, iOS, FlatUI, Metro, Tango, Solarized).
* [Bootflat](http://bootflat.github.io/color-picker.html) - Bootflat Flat UI color picker is a project digging the Flat Color Picker which gives you the perfect colors for flat designs.
* 🌎 [Brand Colors](brandcolors.net/) - Official color codes for the world's biggest brands.
* 🌎 [Branition Colors](branition.com/colors) - Hand-curated collection of color pallets best fitted for branding.
* [Color Hunt](http://colorhunt.co/) - A place to discover, create, and share color palettes.
* 🌎 [Colorful Gradients](colorfulgradients.tumblr.com/) - Gradients automatically created by a computer. 48 times daily.
* [Colour Lovers](http://www.colourlovers.com) - A creative community where people from around the world create and share colors, palettes and patterns.
* 🌎 [Coolhue 2.0](webkul.github.io/coolhue/) - Coolest handpicked Gradient Palette and Swatch for your next super amazing stuff.
* 🌎 [Coolors](coolors.co/) - The super fast color schemes generator for cool designers.
* 🌎 [Flat UI Colors](flatuicolors.com/) - Flat color picker which gives you the perfect colors for flat designs.
* 🌎 [Material Design Colors](www.materialui.co/colors) - Material ui color palette for Android, Web & iOS.
* 🌎 [Material Palette](www.materialpalette.com/) - Generate & export your Material Design color palette.

## Aggregated Content

A liberal mixture of content aggregated from other free resources and made available at one central point.

* [All The Free Stock](http://allthefreestock.com) - One stop resource for free stock images, videos, sounds and more.
* 🌎 [Avopix](avopix.com) - More than 15 000 absolutely free stock photos and vectors.
* [Libre Stock](http://librestock.com/) - Search engine for stock photo websites.
* 🌎 [Stock Up](www.sitebuilderreport.com/stock-up) - Searching 9,301 (and counting) free stock photos across 25 websites.
* [The Stocks](http://thestocks.im/) - The best royalty free stock photos in one place.

## HTML Templates

Various different websites offering free HTML templates and themes.

* 🌎 [Bootswatch](bootswatch.com/) - 🌎 [:copyright:](raw.githubusercontent.com/thomaspark/bootswatch/master/LICENSE) Free themes for Bootstrap.
* 🌎 [HTML5 Rocket](html5rocket.github.io/) - 🌎 [:copyright:](creativecommons.org/share-your-work/public-domain/cc0/) Free HTML5 site templates.
* 🌎 [HTML5 Up](html5up.net/) - 🌎 [:copyright:](creativecommons.org/licenses/by/3.0/) HTML5 UP makes spiffy HTML5 site templates.
* 🌎 [Start Bootstrap](startbootstrap.com/) - 🌎 [:copyright:](opensource.org/licenses/MIT) Free Bootstrap templates and themes.
* 🌎 [Templated](templated.co/) - 🌎 [:copyright:](templated.co/license) A collection of 850 free CSS and HTML5 site templates, designed & built by Cherry + AJ and released under the Creative Commons.
* 🌎 [Themezy](www.themezy.com/) - 🌎 [:copyright:](www.themezy.com/terms) Free WordPress themes and website templates.

## Sounds & Music

Free resources for stock sound and music to be used on creative projects

* 🌎 [Bensound](www.bensound.com) - 🌎 [:copyright:](www.bensound.com/licensing) Royalty free music by Bensound.
* [ccMixter](http://ccmixter.org/) - [:copyright:](http://ccmixter.org/how-to-attribute-ccmixter-tracks) ccMixter.org offers over 30,000 original tracks that can be used freely in YouTube videos, remixes, mobile apps, games, and more.
* [Free Loops](http://free-loops.com) - [:copyright:](http://free-loops.com/creative-commons-audio.php) Free loops and audio clip.
* [Free Music Archive](http://freemusicarchive.org/) - 🌎 [:copyright:](creativecommons.org/) An interactive library of high-quality, legal audio downloads directed by 🌎 [WFMU](wfmu.org/), the most renowned freeform radio station in America.
* 🌎 [Freesound](freesound.org/) - 🌎 [:copyright:](freesound.org/help/about/) Collaborative database of audio snippets, samples, recordings and bleeps.
* 🌎 [FreeSoundEffects](free-sound-effects.net/) - 🌎 [:copyright:](creativecommons.org/) For YouTube, filmmakers, games, podcasts and to use in your next video project, for free!
* 🌎 [Internet Archive’s Netlabels Collection](archive.org/details/netlabels) - 🌎 [:copyright:](creativecommons.org/) Netlabels collection hosts complete, freely downloadable/streamable.
* 🌎 [Jamendo](www.jamendo.com/start) - 🌎 [:copyright:](creativecommons.org/) Independent music community with a large collect of creative commons licensed music.
* 🌎 [Jukedeck](www.jukedeck.com) - 🌎 [:copyright:](www.jukedeck.com/licensing) Machine learning powered royalty-free original music.
* [Sound Image](http://soundimage.org/) - 🌎 [:copyright:](creativecommons.org/licenses/by/4.0/) Over 1000 tracks of free music and sound effects for your projects by Eric Matyas.
* [SoundBible](http://soundbible.com) - [:copyright:](http://soundbible.com/about.php) Thousands of free sound effects, sound clips, and straight up sounds.
* 🌎 [Tunetank](tunetank.com/) - 🌎 [:copyright:](tunetank.com/license/) Exclusive royalty free music for YouTube videos without copyright claims.
* 🌎 [Unminus](www.unminus.com/) - 🌎 [:copyright:](www.unminus.com/license) Download Royalty Free Music for YouTube Videos, Podcasts and Apps. No Copyright CC0 Music inspired by Unsplash.

## Paid Resources

And last, but not least, a selection of the best paid resources.

* 🌎 [Adobe Stock](stock.adobe.com/) - Photos, Illustrations, Vectors.
* 🌎 [Fotolia](us.fotolia.com/) - Photos, Illustrations, Vectors, Videos.
* 🌎 [Inky Deals](www.inkydeals.com/) - Premium resources at insane discounts.
* 🌎 [Shutterstock](www.shutterstock.com/) - Photos, Vectors, Editorial, Footages, Music.
* 🌎 [Stocksy](www.stocksy.com/) - "Cliché-free" Photos.
* 🌎 [Graphic River](graphicriver.net/) - Hand-reviewed graphic assets from a community of designers.
.



## How to Contribute

Please read [CONTRIBUTING](/CONTRIBUTING.md).

## How to Share

* 🌎 [Share on Twitter](twitter.com/home?status=Checkout%20this%20Awesome%20Stock%20Resources%20list%20from%20%40neutraltone.%20https%3A%2F%2Fgithub.com%2Fneutraltone%2Fawesome-stock-resources%20%23design)
* 🌎 [Share on Facebook](www.facebook.com/sharer/sharer.php?s=100&p[url]=https://github.com/correia-jpv/fucking-awesome-stock-resources&p[images][0]=&p[title]=Awesome%20Stock%20Resources&p[summary]=)
* 🌎 [Share on Google Plus](plus.google.com/share?url=https://github.com/correia-jpv/fucking-awesome-stock-resources)
* 🌎 [Share on LinkedIn](www.linkedin.com/shareArticle?mini=true&url=https://github.com/correia-jpv/fucking-awesome-stock-resources&title=Awesome%20Stock%20Resources&summary=&source=)


## Donate :heart:

And finally, if you appreciate this list and find it useful, please consider helping to support the ongoing maintenance by donating:

[![Support](https://img.shields.io/badge/Donate-PayPal-green.svg)](https://www.paypal.me/tonyphipps)

## License

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, 🌎 [Tony Phipps](twitter.com/neutraltone) has waived all copyright and related or neighboring rights to this work.

## Source
<b><code>&nbsp;13109⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;773🍴</code></b> [neutraltone/awesome-stock-resources](https://github.com/neutraltone/awesome-stock-resources))