

<p align="center">
    <img alt="CoreShoplogo" src="https://gitee.com/jianweie/images/raw/master/coreshop/images/Logo/logo.png" width="602" height="175" style="margin-bottom: 10px;">
</p>

<div align="center">

<h3 align="center">核心商城（CoreShop）Beta 版</h3>

<h4 align="center">支持可视化布局的.Net小程序商城</h4>

[![star](https://gitee.com/CoreUnion/CoreShop/badge/star.svg)](https://gitee.com/CoreUnion/CoreShop.git) [![fork](https://gitee.com/CoreUnion/CoreShop/badge/fork.svg)](https://gitee.com/CoreUnion/CoreShop.git)
[![GitHub stars](https://img.shields.io/github/stars/CoreUnion/CoreShop?logo=github)](https://github.com/CoreUnion/CoreShop) 
[![GitHub forks](https://img.shields.io/github/forks/CoreUnion/CoreShop?logo=github)](https://github.com/CoreUnion/CoreShop)
<a target="_blank" href="https://gitee.com/CoreUnion/CoreShop/blob/master/LICENSE"><img src="https://img.shields.io/github/license/CoreUnion/CoreShop.svg?logo=git&logoColor=red" ></img></a>



```shell
如果对您有帮助，您可以点右上角 “Star” 收藏一下 ，获取第一时间更新，谢谢！
```

------------------------------------------------------------------------

[![](https://img.shields.io/badge/官方网站-coreshop.com.cn-brightgreen)](https://www.corecms.net/)  [![](https://img.shields.io/badge/QQ群-70494974-red)](https://jq.qq.com/?_wv=1027&k=y83TiQC7)

------------------------------------------------------------------------

</div>

#### 💐 核心商城（CoreShop）介绍
> 核心小程序商城系统`（CoreShop）` 是基于 Asp.Net 5.0、Uni-App开发、支持可视化布局的小程序商城系统；前后端分离，支持分布式部署，跨平台运行；拥有分销、代理、团购秒杀、接龙、拼团、直播、优惠券、自定义表单等众多营销功能，拥有完整SKU、下单、售后、物流流程，支持可视化自定义首页模块布局效果。    

> 支持一套代码编译发布微信小程序版、H5版、Android版、iOS版、支付宝小程序版、百度小程序版、字节跳动小程序版、QQ小程序版、快应用、360小程序共10个平台。    

> 后台管理系统包含会员管理、商品管理、订单管理、服务商品、财务管理、促销中心、分销管理、代理管理、库存管理、报表统计、自定义表单、文章管理、广告管理、商城设置、后台管理、短信管理、日志管理等模块，强大的促销引擎，多种促销方式自由搭配，满足各种场景的促销方式需求，做活动更灵活简单，并且在促销的扩展上也非常方便。     

#### 🍔 功能介绍

- 商品管理：单规格、多规格商品管理；品牌、分类管理；商品属性、商品参数及类型管理；商品评价。
- 订单管理：订单列表，订单支付、发货、取消、售后等；划分发货单，提货单，售后单，退款单；支持购物单，配送单，联合单在线打印。
- 会员管理：会员列表、用户等级等
- 服务商品：服务商品为按次服务类商品，购买一个服务商品包，可以按次消费。
- 财务管理：支付方式设置，支付单、退款单、用户提现管理、用户账户资金流动情况、发票管理
- 促销中心：商品促销、订单促销、用户等级促销、商品品牌促销；优惠券、团购秒杀、拼团管理
- 分销管理：分销设置、分销等级、分销商管理、分销商订单
- 代理管理：代理设置、代理商品池管理、代理商等级、代理商列表、代理商订单
- 库存管理：库存盘点、商品出库入库、库存记录日志
- 统计报表：商品销量统计、财务收款统计、订单销量统计、用户收藏喜好统计
- 自定义表单：表单列表、表单统计报表、表单提交管理、表单小程序码等
- 文章管理：文章列表、文章分类
- 广告管理：广告位位置管理、广告列表
- 商城设置：首页布局管理、页面可视化操作、公告管理、商城服务细则设置、配送方式及运费设置、物流公司列表、行政三级区划
- 平台设置：防小程序审核失败开关、平台设置、分享设置、会员设置、商品库存报警、订单全局设置、积分设置、提现设置、邀请好友设置、阿里云OSS存储设置、腾讯云COS存储设置、腾讯地图设置、快递查询接口设置、快递100面单打印设置、百度统计代码设置
- 后台管理：后台登录用户管理、角色管理、后台菜单管理、字典管理、部门管理、代理生成辅助工具
- 短信管理：短信平台设置、短信发送记录日志
- 日志管理：后台操作日志、后台登录日志、全局日志管理、定时任务日志
- 门店管理：门店列表。门店核销、店员管理、提货单管理。
- 消息配合：消息提醒配置、微信小程序订阅消息设置
- 小票打印：对接易联云网络打印机
- 直播带货：微信视频号直播带货，微信视频号橱窗带货，微信直播发货。

#### 🥦 自定义表单说明  

- 自定义表单包含有：订单、付款码、留言、反馈、登记、调研这几种类型，可实现店铺收款、门店内扫码下单、活动预约、活动预定、会议登记、在线报名、上课签到等等。  
- 自定义表单可以为您的线上线下结合提供更强大的助力。

#### 🌞 服务商品说明  

- 服务商品，指当前新建的商品并不一定是实物商品，而可能是一种按次数兑换或消费的服务；服务商品可设置具体消费次数，生成对应的核销码，设置可核销的门店，进行店内核销或上门核销消费。
- 比如购买一个洗车包月套餐这个服务商品，这个服务商品内有10次兑换次数，支持在一定时间内进行10次线下洗车消费。
- 比如购买一个水果套餐，每个月份5次给客户提供上门配送次数的服务。
- 服务商品售卖核销功能能更好的增加用户粘性。

#### 🎃 前端介绍 

使用uni-app跨平台开发框架，结合ColorUI的美观、uViewUI的组件功能，实现更多交互细节，我们倾尽全力提供更加流畅舒爽的产品体验，实现一个后台，管理10个前端。同时又实现了一套前端代码，发布多个平台，为您的业务可以提供更加强有力的支撑！


#### 🎒 小程序截图

| 真机截图 |
|---------------------|
| ![小程序截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/WeChat/01.jpg)  |
| ![小程序截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/WeChat/02.jpg)  |
| ![小程序截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/WeChat/03.jpg)  |
| ![小程序截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/WeChat/04.jpg)  |
| ![小程序截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/WeChat/05.jpg)  |

#### 🎏 后端截图  

| 后端 | 截图 |
|---------------------|---------------------|
| ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/01.png)  | ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/02.png)  |
| ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/03.png)  | ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/04.png)  |
| ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/05.png)  | ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/06.png)  |
| ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/07.png)  | ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/08.png)  |
| ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/09.png)  | ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/10.png)  |
| ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/11.png)  | ![截图](https://gitee.com/jianweie/images/raw/master/coreshop/images/Admin/12.png)  |


#### 🎨 系统演示  

| 微信小程序演示 | H5演示（搁置开发） |
|---------------------|---------------------|
| ![微信小程序演示](https://gitee.com/jianweie/images/raw/master/coreshop/images/QRCode/wxqCode.jpg)  | ![h5演示](https://gitee.com/jianweie/images/raw/master/coreshop/images/QRCode/h5qCode.jpg)  |


1、H5网页演示地址：  
https://h5.demo.coreshop.cn  

2、后端管理演示地址：  
https://admin.demo.coreshop.cn  
账号：coreshop  
密码：coreshop  

3、后端接口文档地址：  
https://admin.demo.coreshop.cn/doc  


4、接口演示地址：  
为方便前端开发者在不部署前后端的清下调试uni-app，此演示接口已取消跨域限制，uni-app中可以作为测试接口接入。  
https://api.demo.coreshop.cn  


5、接口文档地址：  
https://api.demo.coreshop.cn/doc  

6、定时任务面板演示地址：  
https://api.demo.coreshop.cn/job  
账号：coreshop  
密码：coreshop 


### 🌈 技术选型

#### 🏢 后端框架结构说明  


| 技术 | 名称 | 版本 | 
| --- | --- | --- | 
| Asp.net Core MVC  | 应用框架 | [![nuget](https://img.shields.io/nuget/v/Microsoft.AspNetCore.Mvc.Core?cacheSeconds=10800)](https://www.nuget.org/packages/Microsoft.AspNetCore.Mvc.Core/)  [![nuget](https://img.shields.io/nuget/dt/Microsoft.AspNetCore.Mvc.Core)](https://www.nuget.org/packages/Microsoft.AspNetCore.Mvc.Core/) |  
| Asp.net Core WebApi  | Api框架 |  [![nuget](https://img.shields.io/nuget/v/Microsoft.AspNet.WebApi.Core?cacheSeconds=10800)](https://www.nuget.org/packages/Microsoft.AspNet.WebApi.Core/)  [![nuget](https://img.shields.io/nuget/dt/Microsoft.AspNet.WebApi.Core)](https://www.nuget.org/packages/Microsoft.AspNet.WebApi.Core/) |  
| Swagger2 | Api文档 | [![nuget](https://img.shields.io/nuget/v/Swashbuckle.AspNetCore?cacheSeconds=10800)](https://www.nuget.org/packages/Swashbuckle.AspNetCore/)  [![nuget](https://img.shields.io/nuget/dt/Swashbuckle.AspNetCore)](https://www.nuget.org/packages/Swashbuckle.AspNetCore/) |  
| AutoFac | IOC框架 |  [![nuget](https://img.shields.io/nuget/v/Autofac.Extensions.DependencyInjection?cacheSeconds=10800)](https://www.nuget.org/packages/Autofac.Extensions.DependencyInjection/)  [![nuget](https://img.shields.io/nuget/dt/Autofac.Extensions.DependencyInjection)](https://www.nuget.org/packages/Autofac.Extensions.DependencyInjection/) |  
| SqlSugar | ORM框架 |  [![nuget](https://img.shields.io/nuget/v/SqlSugar?cacheSeconds=10800)](https://www.nuget.org/packages/SqlSugar/)  [![nuget](https://img.shields.io/nuget/dt/SqlSugar)](https://www.nuget.org/packages/SqlSugar/) |  
| AutoMapper | 实体映射 |  [![nuget](https://img.shields.io/nuget/v/AutoMapper?cacheSeconds=10800)](https://www.nuget.org/packages/AutoMapper/)  [![nuget](https://img.shields.io/nuget/dt/AutoMapper)](https://www.nuget.org/packages/AutoMapper/) |  
| DotLiquid | 模板引擎 |  [![nuget](https://img.shields.io/nuget/v/DotLiquid?cacheSeconds=10800)](https://www.nuget.org/packages/DotLiquid/)  [![nuget](https://img.shields.io/nuget/dt/DotLiquid)](https://www.nuget.org/packages/DotLiquid/) |  
| Nlog | 日志组件 |  [![nuget](https://img.shields.io/nuget/v/NLog.Web.AspNetCore?cacheSeconds=10800)](https://www.nuget.org/packages/NLog.Web.AspNetCore/)  [![nuget](https://img.shields.io/nuget/dt/NLog.Web.AspNetCore)](https://www.nuget.org/packages/NLog.Web.AspNetCore/) |  
| Redis | 数据缓存 |   [![nuget](https://img.shields.io/nuget/v/StackExchange.Redis?cacheSeconds=10800)](https://www.nuget.org/packages/StackExchange.Redis/)  [![nuget](https://img.shields.io/nuget/dt/StackExchange.Redis)](https://www.nuget.org/packages/StackExchange.Redis/) |  
| Jwt | 授权认证 |  [![nuget](https://img.shields.io/nuget/v/IdentityModel?cacheSeconds=10800)](https://www.nuget.org/packages/IdentityModel/)  [![nuget](https://img.shields.io/nuget/dt/IdentityModel)](https://www.nuget.org/packages/IdentityModel/) |  
| HangFire | 定时任务 |  [![nuget](https://img.shields.io/nuget/v/HangFire?cacheSeconds=10800)](https://www.nuget.org/packages/HangFire/)  [![nuget](https://img.shields.io/nuget/dt/HangFire)](https://www.nuget.org/packages/HangFire/) |  
| Paylink  | 在线支付 |   [![nuget](https://img.shields.io/nuget/v/Essensoft.Paylink.WeChatPay?cacheSeconds=10800)](https://www.nuget.org/packages/Essensoft.Paylink.WeChatPay/)  [![nuget](https://img.shields.io/nuget/dt/Essensoft.Paylink.WeChatPay)](https://www.nuget.org/packages/Essensoft.Paylink.WeChatPay/) |  
| SKIT.FlurlHttpClient.Wechat | 微信SDK |   [![nuget](https://img.shields.io/nuget/v/SKIT.FlurlHttpClient.Wechat?cacheSeconds=10800)](https://www.nuget.org/packages/SKIT.FlurlHttpClient.Wechat/)  [![nuget](https://img.shields.io/nuget/dt/SKIT.FlurlHttpClient.Wechat)](https://www.nuget.org/packages/SKIT.FlurlHttpClient.Wechat/) |  
| LayUIAdmin | 后端管理UI框架 |  [![npm](https://img.shields.io/npm/v/layui.svg?sanitize=true)](https://www.layui.com/)  [![github](https://img.shields.io/github/stars/sentsin/layui.svg?style=social)](https://www.layui.com/) |  


#### 🍭 后端技术看点
- 前后端完全分离，接口与管理端为独立项目 (互不依赖、互不影响、开发效率高)
- 采用 最新的 Asp.Net 5.0 框架
- 采用 RBAC 基于角色的权限控制管理，可颗粒化配置用户、角色可访问的数据权限。
- 采用 LayuiAdmin（企业级中后台产品UI组件库）作为后端UI框架；
- 提供 Redis 做缓存和消息队列的处理；
- 使用 Swagger 做api文档；
- 使用 Automapper 处理对象映射；
- 使用 AutoFac 做依赖注入容器，并提供批量服务注入；
- 支持 CORS 跨域；
- 封装 JWT 自定义策略授权，支持集成IdentityServer4，实现基于OAuth2的登录体系；
- 使用 Nlog日志框架，集成原生 ILogger 接口做日志记录；
- 使用 HangFire 做定时任务处理；
- 已支持 SqlServer、MySql数据库，理论上支持所有数据库，并支持读写分离和多库操作；
- 使用 Paylink 作为支付宝支付、微信支付SDK;
- 使用 SKIT.FlurlHttpClient.Wechat 作为微信公众号及小程序对接组件;


#### 👒 前端框架  

| 技术 | 官网 | 版本 | 描述 |
| --- | --- | --- | --- |
| uni-app | https://uniapp.dcloud.io/ |  | 跨平台应用前端框架 | 
| uView UI | http://uviewui.com/ | v1.8.4 | 组件功能强丰富|
| Color UI | https://www.color-ui.com/ | V2.02 | 很漂亮的UI组件，专注于视觉 |


### 📀 开发环境

- Visual Studio 2019 16.8 +
- .NET 5 SDK +
- HBuilderX
- 微信开发者工具
- SQL Server Management Studio
- Navicat for MySQL / Sqlyog
- Redis Desktop Manager


### 💝 运维环境

- [x]  （必选）Windows IIS7.5+ / Docker / k8s等支持环境
- [x]  （必选）sqlserver 2012R2+ / MySQL 5.7+
- [x]  （必选）Redis 3.0+
- [x]  （必选）支持https协议的域名
- [x]  （可选）阿里云OSS/腾讯云COS
- [ ] （可选）易联云网络打印机

### ⛵ 安装及说明文档
- 由于文档内容较多，请加QQ群 【[70494974](https://jq.qq.com/?_wv=1027&k=y83TiQC7)】 后群附内下载多种文档，或git源代码从其目录【文档】中获取。   
- 已经支持linux下docker-compose部署，可实现一键部署coreshop应用、mysql、redis，请获取代码中【docker-compose.yaml】文件，


### ⚡ 进度及计划  
- 目前虽然完成了通用商城该有的功能开发，但是因为业务逻辑层面的功能繁多，不可否认存在一些较明显的bug。
- 近阶段我们主要工作重心放在修复Bug、完善测试、优化业务逻辑、编写文档及官网的建设。
- 开发计划及进度、更新日志等已经更新至gitee wiki板块，欢迎查阅【[点击前往](https://gitee.com/CoreUnion/CoreShop/wikis/%E5%BC%80%E5%8F%91%E8%AE%A1%E5%88%92?sort_id=4196460)】


### 🎏 版权须知
- 允许个人学习研究使用，支持二次开发。
- 允许商业用途，商用免费，但仅限自运营；如果商用必须保留版权信息，望自觉遵守。
- 不允许对程序代码以任何形式、任何目的的再发行或出售，否则将追究侵权者法律责任。
- 软件受国家计算机软件著作权保护（登记号：2020SR1224749）。
- 我们的团队水平有限，也是在探索中学习、改进。开源，是为了让认可我们的用户能自由的使用、学习软件的内部架构，让更多的人有机会阅读并发现Bug、对软件项目提出改进意见。


### 👏 贡献代码

1. 欢迎提交 [pull request](https://gitee.com/CoreUnion/CoreShop/pulls)，注意提交至 `develop` 分支
2. 欢迎提交 [issue](https://gitee.com/CoreUnion/CoreShop/issues)，请写清楚遇到问题的原因、开发环境、复显步骤以及期望达到的效果。


### 💘 支持开源
- 希望CoreShop对您有用，您的支持也是CoreShop开源的动力，CoreShop有你更精彩！
![感谢您的支持](https://gitee.com/jianweie/images/raw/master/coreshop/images/PayeeCode.jpg "PayeeCode.png")



### ☀️ 组织  
- CoreShop 项目已加入 [dotNET China](https://gitee.com/dotnetchina)  组织。

- ![dotnetchina](https://images.gitee.com/uploads/images/2021/0324/120117_2da9922c_416720.png "132645_21007ea0_974299.png")


### 🎉 鸣谢
感谢以下项目给我们提供了学习和思考的方向：
- LayUI（贤心）
- Blog.Core（老张）
- Crmeb
- Weshop
- Jshop
- Mall4j
- Niushop
- Shopro