using Autofac;
using AutoMapper;
using CoreCms.Net.Auth;
using CoreCms.Net.Configuration;
using CoreCms.Net.Core.AutoFac;
using CoreCms.Net.Core.Config;
using CoreCms.Net.Filter;
using CoreCms.Net.Loging;
using CoreCms.Net.Mapping;
using CoreCms.Net.Middlewares;
using CoreCms.Net.Swagger;
using CoreCms.Net.Task;
using Hangfire;
using Hangfire.Dashboard.BasicAuthorization;
using InitQ;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Controllers;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.DependencyInjection.Extensions;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Options;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using Qc.YilianyunSdk;
using System;
using System.Collections.Generic;
using System.Linq;
using CoreCms.Net.RedisMQ.Subscribe;
using CoreCms.Net.Utility.Extensions;
using Essensoft.Paylink.Alipay;
using Essensoft.Paylink.WeChatPay;

namespace CoreCms.Net.Web.WebApi
{
    /// <summary>
    /// 
    /// </summary>
    public class Startup
    {
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="configuration"></param>
        /// <param name="env"></param>
        public Startup(IConfiguration configuration, IWebHostEnvironment env)
        {
            Configuration = configuration;
            Env = env;
        }
        /// <summary>
        /// 
        /// </summary>
        public IConfiguration Configuration { get; }
        /// <summary>
        /// web
        /// </summary>
        public IWebHostEnvironment Env { get; }

        /// This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            //ӱ·ȡ֧
            services.AddSingleton(new AppSettingsHelper(Env.ContentRootPath));
            services.AddSingleton(new LogLockHelper(Env.ContentRootPath));

            //Memory
            services.AddMemoryCacheSetup();
            //Redis
            services.AddRedisCacheSetup();

            //ݿSqlSugarע֧
            services.AddSqlSugarSetup();
            //ÿCORS
            services.AddCorsSetup();


            //session֧(sessioncacheд洢)
            services.AddSession();
            // AutoMapper֧
            services.AddAutoMapper(typeof(AutoMapperConfiguration));

            //ʹ SignalR
            services.AddSignalR();

            //RedisϢ
            services.AddRedisMessageQueueSetup();

            // Payment ע(֧֧/΢֧)
            services.AddAlipay();
            services.AddWeChatPay();

            //  appsettings.json  ѡ
            services.Configure<WeChatPayOptions>(Configuration.GetSection("WeChatPay"));
            services.Configure<AlipayOptions>(Configuration.GetSection("Alipay"));


            //עԶ΢Žӿļ
            services.Configure<WeChat.Service.Options.WeChatOptions>(Configuration.GetSection(nameof(WeChat.Service.Options.WeChatOptions)));

            // ע빤 HTTP ͻ
            services.AddHttpClient();
            services.AddSingleton<WeChat.Service.HttpClients.IWeChatApiHttpClientFactory, WeChat.Service.HttpClients.WeChatApiHttpClientFactory>();


            //Swaggerӿĵע
            services.AddClientSwaggerSetup();

            //ƴӡ
            services.AddYiLianYunSetup();

            //עHangfireʱ
            services.AddHangFireSetup();


            //Ȩ֧ע
            services.AddAuthorizationSetupForClient();
            //ע
            services.AddHttpContextSetup();

            //мAutoFac滻
            services.Replace(ServiceDescriptor.Transient<IControllerActivator, ServiceBasedControllerActivator>());

            //עmvcעrazorͼ
            services.AddMvc(options =>
                {
                    //ʵ֤
                    options.Filters.Add<RequiredErrorForClent>();
                    //쳣
                    options.Filters.Add<GlobalExceptionsFilterForClent>();
                    //Swagger޳Ҫapiչʾб
                    options.Conventions.Add(new ApiExplorerIgnores());
                })
                .AddNewtonsoftJson(p =>
                {
                    //ݸʽĸСд ʹշ
                    p.SerializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                    //ʹշʽkey
                    //p.SerializerSettings.ContractResolver = new DefaultContractResolver();
                    //ѭ
                    p.SerializerSettings.ReferenceLoopHandling = ReferenceLoopHandling.Ignore;
                    //ʱʽʹyyyy/MM/ddʽΪiosϵͳ֧2018-03-29ʽʱ䣬ֻʶ2018/03/09ָʽ
                    p.SerializerSettings.DateFormatString = "yyyy/MM/dd HH:mm:ss";
                });



        }

        /// <summary>
        ///     Autofac
        /// </summary>
        /// <param name="builder"></param>
        public void ConfigureContainer(ContainerBuilder builder)
        {
            //ȡпͲʹע
            var controllerBaseType = typeof(ControllerBase);
            builder.RegisterAssemblyTypes(typeof(Program).Assembly)
                .Where(t => controllerBaseType.IsAssignableFrom(t) && t != controllerBaseType)
                .PropertiesAutowired();

            builder.RegisterModule(new AutofacModuleRegister());

        }

        // public void Configure(IApplicationBuilder app, IWebHostEnvironment env, IOptions<SenparcSetting> senparcSetting, IOptions<SenparcWeixinSetting> senparcWeixinSetting)
        /// <summary>
        ///  This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        /// </summary>
        /// <param name="app"></param>
        /// <param name="env"></param>
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            // ¼뷵 (ע⿪ȨޣȻ޷д)
            app.UseReuestResponseLog();
            // ûʼ¼(ŵ㣬Ȼ쳣ᱨΪܷ)(ע⿪ȨޣȻ޷д)
            app.UseRecordAccessLogsMildd();
            // ¼ip (ע⿪ȨޣȻ޷д)
            app.UseIpLogMildd();


            //ǿʾ
            System.Threading.Thread.CurrentThread.CurrentUICulture = new System.Globalization.CultureInfo("zh-CN");

            app.UseSwagger().UseSwaggerUI(c =>
            {
                //ݰ汾Ƶ չʾ
                typeof(CustomApiVersion.ApiVersions).GetEnumNames().OrderByDescending(e => e).ToList().ForEach(
                    version =>
                    {
                        c.SwaggerEndpoint($"/swagger/{version}/swagger.json", $"Doc {version}");
                    });
                //Ĭתswagger-ui
                c.RoutePrefix = "doc";
                //c.RoutePrefix = string.Empty;
            });


            #region Hangfireʱ

            var queues = new string[] { GlobalEnumVars.HangFireQueuesConfig.@default.ToString(), GlobalEnumVars.HangFireQueuesConfig.apis.ToString(), GlobalEnumVars.HangFireQueuesConfig.web.ToString(), GlobalEnumVars.HangFireQueuesConfig.recurring.ToString() };
            app.UseHangfireServer(new BackgroundJobServerOptions
            {
                ServerTimeout = TimeSpan.FromMinutes(4),
                SchedulePollingInterval = TimeSpan.FromSeconds(15),//뼶Ҫö̵㣬һĬʱ䣬Ĭ15
                ShutdownTimeout = TimeSpan.FromMinutes(30),//ʱʱ
                Queues = queues,//
                WorkerCount = Math.Max(Environment.ProcessorCount, 20)//߳ǰ̣߳Ĭ20
            });

            //Ȩ
            var filter = new BasicAuthAuthorizationFilter(
                new BasicAuthAuthorizationFilterOptions
                {
                    SslRedirect = false,
                    // Require secure connection for dashboard
                    RequireSsl = false,
                    // Case sensitive login checking
                    LoginCaseSensitive = false,
                    // Users
                    Users = new[]
                    {
                        new BasicAuthAuthorizationUser
                        {
                            Login = AppSettingsConstVars.HangFireLogin,
                            PasswordClear = AppSettingsConstVars.HangFirePassWord
                        }
                    }
                });
            var options = new DashboardOptions
            {
                AppPath = "/",//ʱתĵַ
                DisplayStorageConnectionString = false,//ǷʾݿϢ
                Authorization = new[]
                {
                    filter
                },
                IsReadOnlyFunc = Context =>
                {
                    return false;//Ƿֻ
                }
            };

            app.UseHangfireDashboard("/job", options); //ԸıDashboardurl
            HangfireDispose.HangfireService();

            #endregion




            //ʹ Session
            app.UseSession();

            if (env.IsDevelopment())
            {
                // ڿУʹ쳣ҳ棬Ա¶ջϢԲҪ
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Home/Error");
                // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
                app.UseHsts();
            }

            // CORS
            app.UseCors(AppSettingsConstVars.CorsPolicyName);

            // Routing
            app.UseRouting();

            // ʹþ̬ļ
            app.UseStaticFiles();
            // ȿ֤
            app.UseAuthentication();
            // ȻȨм
            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllerRoute(
                    "areas",
                    "{area:exists}/{controller=Default}/{action=Index}/{id?}"
                );

                //endpoints.MapControllers();
                endpoints.MapControllerRoute(
                    "default",
                    "{controller=Default}/{action=Index}/{id?}");
            });



            //Ĭʼҳdefault.html
            //˴·wwwrootļе·
            var defaultFilesOptions = new DefaultFilesOptions();
            defaultFilesOptions.DefaultFileNames.Clear();
            defaultFilesOptions.DefaultFileNames.Add("index.html");
            app.UseDefaultFiles(defaultFilesOptions);
            app.UseStaticFiles();

        }


    }
}