using System;
using Autofac.Extensions.DependencyInjection;
using CoreCms.Net.Loging;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using NLog.Web;
using LogLevel = NLog.LogLevel;

namespace CoreCms.Net.Web.WebApi
{
    /// <summary>
    /// 
    /// </summary>
    public class Program
    {
        /// <summary>
        ///     
        /// </summary>
        /// <param name="args"></param>
        public static void Main(string[] args)
        {
            var host = CreateHostBuilder(args).Build();
            try
            {
                //ȷNLog.configַappsettings.jsonͬ
                NLogUtil.EnsureNlogConfig("NLog.config");
                //ĿʱҪ
                NLogUtil.WriteAll(LogLevel.Trace, LogType.Web, "ӿ", "ӿɹ");

                host.Run();
            }
            catch (Exception ex)
            {
                //ʹnlogд־ļһݿû/ӳɹ
                NLogUtil.WriteFileLog(LogLevel.Error, LogType.ApiRequest, "ӿ", "ʼ쳣", ex);
                throw;
            }
        }

        /// <summary>
        ///     ֧
        /// </summary>
        /// <param name="args"></param>
        /// <returns></returns>
        public static IHostBuilder CreateHostBuilder(string[] args)
        {
            return Host.CreateDefaultBuilder(args)
                .UseServiceProviderFactory(new AutofacServiceProviderFactory()) //<--NOTE THIS
                .ConfigureLogging(logging =>
                {
                    logging.ClearProviders(); //ƳѾע־
                    logging.SetMinimumLevel(Microsoft.Extensions.Logging.LogLevel.Trace); //С־
                })
                .UseNLog() //NLog: Setup NLog for Dependency injection
                .ConfigureWebHostDefaults(webBuilder =>
                {
                    webBuilder
                        .ConfigureKestrel(serverOptions =>
                        {
                            serverOptions.AllowSynchronousIO = true; //ͬ IO
                        })
                        .UseStartup<Startup>();
                });
        }
    }
}