using System;
using System.IO;
using System.Linq;
using Autofac;
using CoreCms.Net.Auth;
using CoreCms.Net.Configuration;
using CoreCms.Net.Core.AutoFac;
using CoreCms.Net.Core.Config;
using CoreCms.Net.Filter;
using CoreCms.Net.Loging;
using CoreCms.Net.Mapping;
using CoreCms.Net.Middlewares;
using CoreCms.Net.Swagger;
using Essensoft.Paylink.Alipay;
using Essensoft.Paylink.WeChatPay;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Localization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Controllers;
using Microsoft.DotNet.PlatformAbstractions;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.DependencyInjection.Extensions;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Options;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;

namespace CoreCms.Net.Web.Admin
{
    /// <summary>
    ///     
    /// </summary>
    public class Startup
    {
        /// <summary>
        ///     캯
        /// </summary>
        /// <param name="configuration"></param>
        /// <param name="env"></param>
        public Startup(IConfiguration configuration, IWebHostEnvironment env)
        {
            Configuration = configuration;
            Env = env;
        }

        /// <summary>
        /// </summary>
        public IConfiguration Configuration { get; }

        /// <summary>
        /// </summary>
        public IWebHostEnvironment Env { get; }

        /// <summary>
        ///     This method gets called by the runtime. Use this method to add services to the container.
        /// </summary>
        /// <param name="services"></param>
        public void ConfigureServices(IServiceCollection services)
        {
            //ӱ·ȡ֧
            services.AddSingleton(new AppSettingsHelper(Env.ContentRootPath));
            services.AddSingleton(new LogLockHelper(Env.ContentRootPath));

            //Memory
            services.AddMemoryCacheSetup();
            //Redis
            services.AddRedisCacheSetup();


            //ݿSqlSugarע֧
            services.AddSqlSugarSetup();
            //ÿCORS
            services.AddCorsSetup();

            //session֧(sessioncacheд洢)
            services.AddSession();
            // AutoMapper֧
            services.AddAutoMapper(typeof(AutoMapperConfiguration));

            //ʹ SignalR
            services.AddSignalR();

            // Payment ע(֧֧/΢֧)
            services.AddAlipay();
            services.AddWeChatPay();

            //  appsettings.json  ѡ
            services.Configure<WeChatPayOptions>(Configuration.GetSection("WeChatPay"));
            services.Configure<AlipayOptions>(Configuration.GetSection("Alipay"));


            //עԶ΢Žӿļ
            services.Configure<WeChat.Service.Options.WeChatOptions>(Configuration.GetSection(nameof(WeChat.Service.Options.WeChatOptions)));

            // ע빤 HTTP ͻ
            services.AddHttpClient();
            services.AddSingleton<WeChat.Service.HttpClients.IWeChatApiHttpClientFactory, WeChat.Service.HttpClients.WeChatApiHttpClientFactory>();


            //Swaggerӿĵע
            services.AddAdminSwaggerSetup();

            //ƴӡ
            services.AddYiLianYunSetup();

            //jwtȨ֧ע
            services.AddAuthorizationSetupForAdmin();
            //ע
            services.AddHttpContextSetup();

            //мAutoFac滻
            services.Replace(ServiceDescriptor.Transient<IControllerActivator, ServiceBasedControllerActivator>());

            //עmvcעrazorͼ
            services.AddMvc(options =>
                {
                    //ʵ֤
                    options.Filters.Add<RequiredErrorForAdmin>();
                    //쳣
                    options.Filters.Add<GlobalExceptionsFilterForAdmin>();
                    //Swagger޳Ҫapiչʾб
                    options.Conventions.Add(new ApiExplorerIgnores());

                    options.EnableEndpointRouting = false;
                })
                .AddNewtonsoftJson(p =>
                {
                    //ݸʽĸСд ʹշ
                    p.SerializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                    //ʹշʽkey
                    //p.SerializerSettings.ContractResolver = new DefaultContractResolver();
                    //ѭ
                    p.SerializerSettings.ReferenceLoopHandling = ReferenceLoopHandling.Ignore;
                    //ʱʽ
                    p.SerializerSettings.DateFormatString = "yyyy-MM-dd HH:mm:ss";
                });

        }

        /// <summary>
        ///     Autofac
        /// </summary>
        /// <param name="builder"></param>
        public void ConfigureContainer(ContainerBuilder builder)
        {
            builder.RegisterModule(new AutofacModuleRegister());

            //ȡпͲʹע
            var controllerBaseType = typeof(ControllerBase);
            builder.RegisterAssemblyTypes(typeof(Program).Assembly)
                .Where(t => controllerBaseType.IsAssignableFrom(t) && t != controllerBaseType)
                .PropertiesAutowired();
        }

        /// <summary>
        ///     This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        /// </summary>
        /// <param name="app"></param>
        /// <param name="env"></param>
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            // ¼뷵 (ע⿪ȨޣȻ޷д)
            app.UseReuestResponseLog();
            // ûʼ¼(ŵ㣬Ȼ쳣ᱨΪܷ)(ע⿪ȨޣȻ޷д)
            app.UseRecordAccessLogsMildd();
            // ¼ip (ע⿪ȨޣȻ޷д)
            app.UseIpLogMildd();
            // signalr
            app.UseSignalRSendMildd();


            app.UseSwagger().UseSwaggerUI(c =>
            {
                //ݰ汾Ƶ չʾ
                typeof(CustomApiVersion.ApiVersions).GetEnumNames().OrderByDescending(e => e).ToList().ForEach(
                    version =>
                    {
                        c.SwaggerEndpoint($"/swagger/{version}/swagger.json", $"Doc {version}");
                    });
                c.RoutePrefix = "doc";
            });

            //ʹ Session
            app.UseSession();

            if (env.IsDevelopment())
            {
                // ڿУʹ쳣ҳ棬Ա¶ջϢԲҪ
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Home/Error");
                // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
                app.UseHsts();
            }

            // CORS
            app.UseCors(AppSettingsConstVars.CorsPolicyName);
            // תhttps
            //app.UseHttpsRedirection();
            // ʹþ̬ļ
            app.UseStaticFiles();
            // ʹcookie
            app.UseCookiePolicy();
            // ش
            app.UseStatusCodePages();
            // Routing
            app.UseRouting();
            // ȿ֤
            app.UseAuthentication();
            // ȻȨм
            app.UseAuthorization();
            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllerRoute(
                    "areas",
                    "{area:exists}/{controller=Default}/{action=Index}/{id?}"
                );

                endpoints.MapControllerRoute(
                    "default",
                    "{controller=Home}/{action=Index}/{id?}");
            });

            //Ĭʼҳdefault.html
            //˴·wwwrootļе·
            var defaultFilesOptions = new DefaultFilesOptions();
            defaultFilesOptions.DefaultFileNames.Clear();
            defaultFilesOptions.DefaultFileNames.Add("index.html");
            app.UseDefaultFiles(defaultFilesOptions);
            app.UseStaticFiles();
        }
    }
}