using Autofac.Extensions.DependencyInjection;
using CoreCms.Net.Loging;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using NLog.Web;
using System;

namespace CoreCms.Net.Web.Admin
{
    /// <summary>
    /// ʼ
    /// </summary>
    public class Program
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="args"></param>
        public static void Main(string[] args)
        {
            var host = CreateHostBuilder(args).Build();
            try
            {
                //ȷNLog.configַappsettings.jsonͬ
                NLogUtil.EnsureNlogConfig("NLog.config");
                //throw new Exception("쳣");//for test
                //ĿʱҪ
                NLogUtil.WriteAll(NLog.LogLevel.Trace, LogType.Web, "վ", "վɹ");

                host.Run();
            }
            catch (Exception ex)
            {
                //ʹnlogд־ļһݿû/ӳɹ
                NLogUtil.WriteFileLog(NLog.LogLevel.Error, LogType.Web, "վ", "ʼ쳣", ex);
                throw;
            }
        }

        /// <summary>
        /// ֧
        /// </summary>
        /// <param name="args"></param>
        /// <returns></returns>
        public static IHostBuilder CreateHostBuilder(string[] args) =>
            Host.CreateDefaultBuilder(args)
                .UseServiceProviderFactory(new AutofacServiceProviderFactory()) //<--NOTE THIS
                .ConfigureLogging(logging =>
                {
                    logging.ClearProviders(); //ƳѾע־
                    logging.SetMinimumLevel(Microsoft.Extensions.Logging.LogLevel.Trace); //С־
                })
                .UseNLog() //NLog: Setup NLog for Dependency injection
                .ConfigureWebHostDefaults(webBuilder =>
                {
                    webBuilder
                        .ConfigureKestrel(serverOptions =>
                        {
                            serverOptions.AllowSynchronousIO = true;//ͬ IO
                        })
                        .UseStartup<Startup>();
                });
    }
}