﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;

namespace CommunityToolkit.WinUI.Lottie.LottieData
{
    /// <summary>
    /// Issues.
    /// </summary>
    sealed class ValidationIssues
    {
        readonly HashSet<(string Code, string Description)> _issues = new HashSet<(string Code, string Description)>();
        readonly bool _throwOnIssue;

        internal ValidationIssues(bool throwOnIssue)
        {
            _throwOnIssue = throwOnIssue;
        }

        internal (string Code, string Description)[] GetIssues() => _issues.ToArray();

        internal void LayerHasInPointAfterOutPoint(string layerName) => Report("LV0001", $"Layer {layerName} has in-point after out-point.");

        internal void LayerInCycle(string layerName) => Report("LV0002", $"Layer {layerName} is in a cycle.");

        internal void InvalidLayerParent(string layerParent) => Report("LV0003", $"Invalid layer parent: {layerParent}.");

        internal void NonUniqueMarkerName(string markerName) => Report("LV0004", $"Marker name is not unique: {markerName}.");

        void Report(string code, string description)
        {
            _issues.Add((code, description));

            if (_throwOnIssue)
            {
                throw new NotSupportedException($"{code}: {description}");
            }
        }
    }
}
