﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

#nullable enable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace CommunityToolkit.WinUI.Lottie.GenericData
{
#if PUBLIC_LottieData
    public
#endif
    sealed class GenericDataList : GenericDataObject, IReadOnlyList<GenericDataObject?>
    {
        readonly IReadOnlyList<GenericDataObject?> _items;

        GenericDataList(IEnumerable<GenericDataObject?> items)
        {
            _items = items.ToArray();
        }

        public static GenericDataList Create(IEnumerable<GenericDataObject?> items)
        {
            var result = new GenericDataList(items);
            return result._items.Count == 0
                    ? Empty
                    : result;
        }

        public static GenericDataList Empty { get; } = new GenericDataList(Array.Empty<GenericDataObject?>());

        public GenericDataObject? this[int index] => _items[index];

        public override GenericDataObjectType Type => GenericDataObjectType.List;

        public int Count => _items.Count;

        public IEnumerator<GenericDataObject?> GetEnumerator() => _items.GetEnumerator();

        IEnumerator IEnumerable.GetEnumerator() => _items.GetEnumerator();

        public override string ToString()
            => Count == 0
                ? "[]"
                : $"[{string.Join(", ", _items.Select(x => ToString(x)))}]";

        public static implicit operator GenericDataList(GenericDataObject[] value) => Create(value);
    }
}