#include <errno.h>
#include <unistd.h>

#include "dius/system/system_call.h"

// https://pubs.opengroup.org/onlinepubs/9699919799/functions/write.html
extern "C" auto write(int fd, void const* buffer, size_t count) -> ssize_t {
    auto result = dius::system::system_call<ssize_t>(dius::system::Number::write, fd, buffer, count);
    if (!result) {
        errno = int(result.error());
        return -1;
    }
    return *result;
}
