#include <errno.h>
#include <unistd.h>

#include "dius/system/system_call.h"

// https://pubs.opengroup.org/onlinepubs/9699919799/functions/read.html
extern "C" auto read(int fd, void* buffer, size_t count) -> ssize_t {
    auto result = dius::system::system_call<ssize_t>(dius::system::Number::read, fd, buffer, count);
    if (!result) {
        errno = int(result.error());
        return -1;
    }
    return *result;
}
