#include <string.h>

#include "di/container/algorithm/prelude.h"
#include "di/container/string/prelude.h"

extern "C" auto strcmp(char const* lhs, char const* rhs) -> int {
    auto a = di::ZCUString((unsigned char const*) lhs);
    auto b = di::ZCUString((unsigned char const*) rhs);
    auto result = di::container::compare(a, b);
    if (result < 0) {
        return -1;
    }
    if (result > 0) {
        return 1;
    }

    return 0;
}
