<?php

declare(strict_types=1);

/*
 * Copyright Humbly Arrogant Software Limited 2020-2023.
 *
 * Use of this software is governed by the Business Source License included in the LICENSE file and at https://getparthenon.com/docs/next/license.
 *
 * Change Date: 26.06.2026 ( 3 years after 2.2.0 release )
 *
 * On the date above, in accordance with the Business Source License, use of this software will be governed by the open source license specified in the LICENSE file.
 */

namespace Parthenon\Athena;

use Parthenon\Athena\Entity\Link;
use Parthenon\Athena\Exception\NoSectionFoundException;
use PHPUnit\Framework\TestCase;

class SectionManagerTest extends TestCase
{
    public function testGetByEntity()
    {
        $section = $this->createMock(SectionInterface::class);
        $section->method('getEntity')->willReturn(new Link());

        $accessRightsManager = $this->createMock(AccessRightsManagerInterface::class);

        $sectionManager = new SectionManager($accessRightsManager);
        $sectionManager->addSection($section);

        $actual = $sectionManager->getByEntity(new Link());

        $this->assertSame($section, $actual);
    }

    public function testGetByEntityNotFound()
    {
        $this->expectException(NoSectionFoundException::class);
        $accessRightsManager = $this->createMock(AccessRightsManagerInterface::class);

        $sectionManager = new SectionManager($accessRightsManager);

        $sectionManager->getByEntity(new Link());
    }
}
