<?php

declare(strict_types=1);

namespace CodelyTv\Tests\Shared\Domain\Criteria;

use CodelyTv\Shared\Domain\Criteria\Order;
use CodelyTv\Shared\Domain\Criteria\OrderBy;
use CodelyTv\Shared\Domain\Criteria\OrderType;
use CodelyTv\Tests\Shared\Domain\RandomElementPicker;

final class OrderMother
{
    public static function create(?OrderBy $orderBy = null, ?OrderType $orderType = null): Order
    {
        return new Order($orderBy ?? OrderByMother::create(), $orderType ?? self::randomOrderType());
    }

    public static function none(): Order
    {
        return Order::none();
    }

    private static function randomOrderType(): OrderType
    {
        return RandomElementPicker::from(OrderType::ASC, OrderType::DESC, OrderType::NONE);
    }
}
