/*
Navicat MySQL Data Transfer

Source Server         : manba_test
Source Server Version : 80021
Source Host           : localhost:3306
Source Database       : mydb

Target Server Type    : MYSQL
Target Server Version : 80021
File Encoding         : 65001

Date: 2022-05-07 16:52:03
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for sp_attribute
-- ----------------------------
DROP TABLE IF EXISTS `sp_attribute`;
CREATE TABLE `sp_attribute` (
  `attr_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `attr_name` varchar(32) NOT NULL COMMENT '属性名称',
  `cat_id` smallint unsigned NOT NULL COMMENT '外键，类型id',
  `attr_sel` enum('only','many') NOT NULL DEFAULT 'only' COMMENT 'only:输入框(唯一)  many:后台下拉列表/前台单选框',
  `attr_write` enum('manual','list') NOT NULL DEFAULT 'manual' COMMENT 'manual:手工录入  list:从列表选择',
  `attr_vals` text NOT NULL COMMENT '可选值列表信息,例如颜色：白色,红色,绿色,多个可选值通过逗号分隔',
  `delete_time` int DEFAULT NULL COMMENT '删除时间标志',
  PRIMARY KEY (`attr_id`),
  KEY `type_id` (`cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3806 DEFAULT CHARSET=utf8 COMMENT='属性表';

-- ----------------------------
-- Records of sp_attribute
-- ----------------------------
INSERT INTO `sp_attribute` VALUES ('1', '主观参数-型号', '1191', 'only', 'manual', '00002', null);
INSERT INTO `sp_attribute` VALUES ('2', '实质参数-适用人群', '1191', 'only', 'manual', '女士', null);
INSERT INTO `sp_attribute` VALUES ('3', '颜色', '1191', 'many', 'list', '4条装高腰1662,4条装高腰1661,5条装中腰1305,5条装中腰2006,5条装高腰1665,5条装中腰1543,均码', null);
INSERT INTO `sp_attribute` VALUES ('4', '主观参数-型号', '1193', 'only', 'manual', 'NK1505', null);
INSERT INTO `sp_attribute` VALUES ('5', '实质参数-适用人群', '1193', 'only', 'manual', '女士', null);
INSERT INTO `sp_attribute` VALUES ('6', '颜色', '1193', 'many', 'list', '淡黄色,紫色,宝蓝,红色,肤色,黑色,白色,均码', null);
INSERT INTO `sp_attribute` VALUES ('7', '主观参数-品牌', '1195', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('8', '颜色', '1195', 'many', 'list', '组合A,组合B,组合C,组合D,组合E,组合F,组合G,组合H,组合I,组合J,组合K,L,XXL,M,XL,S', null);
INSERT INTO `sp_attribute` VALUES ('9', '主观参数-型号', '1196', 'only', 'manual', '111', null);
INSERT INTO `sp_attribute` VALUES ('10', '实质参数-适用性别', '1196', 'only', 'manual', '男', null);
INSERT INTO `sp_attribute` VALUES ('11', '颜色', '1196', 'many', 'list', '白色细条,粗条深灰,中灰细条,粗条浅灰,粗条白色,黑色细条,混色细条,粗条本灰,粗条混色,深灰细条,粗条黑色,藏青细条,均码', null);
INSERT INTO `sp_attribute` VALUES ('12', '主观参数-品牌', '1197', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('13', '实质参数-适用人群', '1197', 'only', 'manual', '情侣', null);
INSERT INTO `sp_attribute` VALUES ('14', '颜色', '1197', 'many', 'list', '590男袜白色5双,590男袜混色5双,590男袜深灰5双,船袜星条女5双,590男袜深色5双,590男袜黑色5双,船袜菱形男5双,船袜条纹男5双,船袜清爽条纹女5双,船袜波点女5双,590男袜浅灰5双,590男袜藏青5双,船袜素色男5双,船袜竹节男5双,船袜国旗男5双,船袜拼色男5双,船袜迷宫男5双装,船袜素色女5双,均码', null);
INSERT INTO `sp_attribute` VALUES ('15', '主观参数-品牌', '1199', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('16', '实质参数-适用人群', '1199', 'only', 'manual', '男士', null);
INSERT INTO `sp_attribute` VALUES ('17', '颜色', '1199', 'many', 'list', '黑色5双装,混色5双装,深色混色5双装,藏青5双装,浅灰5双装,白色5双装,深灰5双装,春夏中筒袜,秋冬中筒袜,船袜', null);
INSERT INTO `sp_attribute` VALUES ('18', '主体-品牌', '119', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('19', '功效-功效', '119', 'only', 'manual', '紧肤淡皱,提拉紧致,去妊娠纹', null);
INSERT INTO `sp_attribute` VALUES ('20', '规格-规格', '119', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('21', '类型', '119', 'many', 'list', '玫瑰精华油,止痒防疤修复精油', null);
INSERT INTO `sp_attribute` VALUES ('22', '主体-商品名称', '11', 'only', 'manual', 'PPTV智能电视32C3', null);
INSERT INTO `sp_attribute` VALUES ('23', '显示-曲面', '11', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('24', '系统-智能电视', '11', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('25', 'USB支持格式-USB支持视频格式', '11', 'only', 'manual', 'AVI,MPG,TS,MOV,MP4,RM,RMVB,VOB', null);
INSERT INTO `sp_attribute` VALUES ('26', '功耗-整机功率（W）', '11', 'only', 'manual', '55瓦特', null);
INSERT INTO `sp_attribute` VALUES ('27', '网络-网络连接方式', '11', 'only', 'manual', '有线+无线', null);
INSERT INTO `sp_attribute` VALUES ('28', '端口-USB2.0端口', '11', 'only', 'manual', '2个', null);
INSERT INTO `sp_attribute` VALUES ('29', '交互设备-语音控制', '11', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('30', '尺寸', '11', 'many', 'list', '32英寸 千元新旗舰,43英寸 LG硬屏（足球通）,55英寸 4K超高清金属机身,65英寸  客厅大屏', null);
INSERT INTO `sp_attribute` VALUES ('31', '主观参数-型号', '1200', 'only', 'manual', '1', null);
INSERT INTO `sp_attribute` VALUES ('32', '实质参数-适用性别', '1200', 'only', 'manual', '女', null);
INSERT INTO `sp_attribute` VALUES ('33', '颜色', '1200', 'many', 'list', '黑色踩脚【适合40至65kg】,肤色踩脚【适合40至65kg】,黑色连脚【适合40至65kg】,肤色连脚【适合40至65kg】,1200D薄绒【秋天5至15度】,2200D双层天鹅绒【3至15度】,2200D龙爪毛【2至15度】,320克加绒加厚【零下10至10度】,360克加绒加厚【零下5至6度】', null);
INSERT INTO `sp_attribute` VALUES ('34', '主观参数-品牌', '1203', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('35', '实质参数-适用人群', '1203', 'only', 'manual', '情侣', null);
INSERT INTO `sp_attribute` VALUES ('36', '颜色', '1203', 'many', 'list', '深灰男,大红女,藏青男,浅灰男,紫色女,黑色女,XXL,L,M,XL,XXXL', null);
INSERT INTO `sp_attribute` VALUES ('37', '主观参数-货号', '1204', 'only', 'manual', '6215350003', null);
INSERT INTO `sp_attribute` VALUES ('38', '实质参数-适用人群', '1204', 'only', 'manual', '情侣', null);
INSERT INTO `sp_attribute` VALUES ('39', '颜色', '1204', 'many', 'list', '紫罗兰女,深灰男,大红男,肤色女,大红女,藏青男,银灰男,玫红女,黑色男,水兰女,酒红男,L,XXL,M,XL,XXXL', null);
INSERT INTO `sp_attribute` VALUES ('40', '主观参数-货号', '1207', 'only', 'manual', '6215350003', null);
INSERT INTO `sp_attribute` VALUES ('41', '实质参数-适用人群', '1207', 'only', 'manual', '情侣', null);
INSERT INTO `sp_attribute` VALUES ('42', '颜色', '1207', 'many', 'list', '深灰男,大红男,红色女,肤色女,银灰男,藏青男,紫色女,玫红女,黑色女,水兰女,酒红男,深蓝男,粉色女,XXL,L,M,XL,XXXL', null);
INSERT INTO `sp_attribute` VALUES ('43', '主体-品牌', '120', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('44', '规格-规格', '120', 'only', 'manual', '240毫升', null);
INSERT INTO `sp_attribute` VALUES ('45', '功效-功效', '120', 'only', 'manual', '保湿补水', null);
INSERT INTO `sp_attribute` VALUES ('46', '主观参数-品牌', '1210', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('47', '实质参数-适用人群', '1210', 'only', 'manual', '男士', null);
INSERT INTO `sp_attribute` VALUES ('48', '颜色', '1210', 'many', 'list', '酒红加绒+围脖,卡其加绒+围脖,藏青加绒+围脖,咖啡加绒+围脖,灰色加绒+围脖,黑色加绒+围脖,酒红加绒,卡其加绒,藏青加绒,咖啡加绒,灰色加绒,黑色加绒', null);
INSERT INTO `sp_attribute` VALUES ('49', '主观参数-品牌', '1211', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('50', '实质参数-适用人群', '1211', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('51', '细节参数-形状', '1211', 'only', 'manual', '长方形', null);
INSERT INTO `sp_attribute` VALUES ('52', '颜色', '1211', 'many', 'list', '5501酒红色,5503驼色,5592中灰色,5533大红格,5510黑色,5506藏青色,5571橙灰色,5515浅灰色,5572红咖色,5577红蓝格,5509大红色,5507咖啡色', null);
INSERT INTO `sp_attribute` VALUES ('53', '基本参数-品牌', '1212', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('54', '外观参数-色系', '1212', 'only', 'manual', '黑色系', null);
INSERT INTO `sp_attribute` VALUES ('55', '主观参数-品牌', '1213', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('56', '实质参数-适用对象', '1213', 'only', 'manual', '青年', null);
INSERT INTO `sp_attribute` VALUES ('57', '细节参数-包装', '1213', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('58', '颜色', '1213', 'many', 'list', 'C号领带,H号领带,A号领带,B号领带,F号领带,Y号领带,K号领带,J号领带', null);
INSERT INTO `sp_attribute` VALUES ('59', '主观参数-品牌', '1214', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('60', '实质参数-适用人群', '1214', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('61', '颜色', '1214', 'many', 'list', '男款深灰色,男款黑色,男款咖啡色,女款黑色,女款红色,女款灰色,深女款紫色,女款玫红,女款咖啡色', null);
INSERT INTO `sp_attribute` VALUES ('62', '主体-品牌', '1215', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('63', '规格-产品重量', '1215', 'only', 'manual', '35克', null);
INSERT INTO `sp_attribute` VALUES ('64', '主观参数-品牌', '1216', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('65', '实质参数-文胸款式', '1216', 'only', 'manual', 'V型', null);
INSERT INTO `sp_attribute` VALUES ('66', '细节参数-包装', '1216', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('67', '颜色', '1216', 'many', 'list', '肤色,75B,80A,75C,85B,75A,80B,80C', null);
INSERT INTO `sp_attribute` VALUES ('68', '主观参数-型号', '1219', 'only', 'manual', 'L-XXXL', null);
INSERT INTO `sp_attribute` VALUES ('69', '实质参数-适用人群', '1219', 'only', 'manual', '男士', null);
INSERT INTO `sp_attribute` VALUES ('70', '颜色', '1219', 'many', 'list', '5370-3,5370-4,5324浅,5324深,5260A,5260B,5373款,5290款,5915款,5269款,5280款,5279款,5283款,L170,XL175,XXL180,XXXL185', null);
INSERT INTO `sp_attribute` VALUES ('71', '主体-品牌', '121', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('72', '规格-规格', '121', 'only', 'manual', '6# 10ml', null);
INSERT INTO `sp_attribute` VALUES ('73', '功效-功效', '121', 'only', 'manual', '美甲', null);
INSERT INTO `sp_attribute` VALUES ('74', '主观参数-品牌', '1220', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('75', '实质参数-适用人群', '1220', 'only', 'manual', '情侣', null);
INSERT INTO `sp_attribute` VALUES ('76', '颜色', '1220', 'many', 'list', '男士圆领麻灰,男士圆领深灰,男士圆领藏青,男士圆领大红,男士圆领中灰,女士圆领大红,女士圆领豆沙红,女士圆领玉色,女士圆领玫红,男士高领麻灰,男士高领深灰,男士高领中灰,男士高领大红,男士高领藏青,女士高领大红,女士高领玫红,女士高领豆沙红,女士高领玉色,V领大红,V领藏青,V领麻灰,165/90,170/95,175/100,180/105,185/110,M165/90,L170/95,XL175/100,XXL180/105,XXXL185/110', null);
INSERT INTO `sp_attribute` VALUES ('77', '主观参数-品牌', '1221', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('78', '实质参数-适用人群', '1221', 'only', 'manual', '情侣', null);
INSERT INTO `sp_attribute` VALUES ('79', '颜色', '1221', 'many', 'list', '男款-银灰,女款-夕阳红,男款-铁灰,男款-麻灰,女款-肤色,女款-紫罗兰,男款-藏青,160cm,185cm,170cm,165cm,175cm,180cm', null);
INSERT INTO `sp_attribute` VALUES ('80', '主观参数-品牌', '1222', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('81', '颜色', '1222', 'many', 'list', '4条礼盒装,L,XL,XXL,XXXL', null);
INSERT INTO `sp_attribute` VALUES ('82', '主观参数-品牌', '1224', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('83', '实质参数-袖长', '1224', 'only', 'manual', '长袖', null);
INSERT INTO `sp_attribute` VALUES ('84', '颜色', '1224', 'many', 'list', '8647款,8633款,8651款,8630款,女款L码,女款XL码,女款XXL码,女款M码', null);
INSERT INTO `sp_attribute` VALUES ('85', '主观参数-品牌', '1226', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('86', '颜色', '1226', 'many', 'list', '5条盒装随机色,小码适合80-110斤,大码适合110-130斤', null);
INSERT INTO `sp_attribute` VALUES ('87', '主观参数-型号', '1227', 'only', 'manual', '2K6331', null);
INSERT INTO `sp_attribute` VALUES ('88', '实质参数-适用人群', '1227', 'only', 'manual', '儿童', null);
INSERT INTO `sp_attribute` VALUES ('89', '颜色', '1227', 'many', 'list', '绿/粉/黄,均码', null);
INSERT INTO `sp_attribute` VALUES ('90', '主体-品牌', '1229', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('91', '规格-实物尺寸', '1229', 'only', 'manual', '11*10*9厘米', null);
INSERT INTO `sp_attribute` VALUES ('92', '颜色', '1229', 'many', 'list', '黑褐色,浅青色,随机+布书3件', null);
INSERT INTO `sp_attribute` VALUES ('93', '主体-品牌', '122', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('94', '规格-规格', '122', 'only', 'manual', '600ml', null);
INSERT INTO `sp_attribute` VALUES ('95', '功效-功效', '122', 'only', 'manual', '深层清洁', null);
INSERT INTO `sp_attribute` VALUES ('96', '功效', '122', 'many', 'list', '美白600ml,去烟渍[600ml+100ml],经典蜂胶款600ml,经典蜂胶款600ml*2', null);
INSERT INTO `sp_attribute` VALUES ('97', '主体-品牌', '1230', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('98', '规格-包装尺寸', '1230', 'only', 'manual', '40*30*3毫米', null);
INSERT INTO `sp_attribute` VALUES ('99', '主体-品牌', '1232', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('100', '规格-重量', '1232', 'only', 'manual', '1克', null);
INSERT INTO `sp_attribute` VALUES ('101', '关联', '1232', 'many', 'list', '乾坤闪影龙 - 送神龙2只+拆件器(137颗粒),疾刃火斧龙 - 送神龙2只+拆件器(115颗粒),烈天炽风龙 - 送神龙2只+拆件器(142颗粒),暗影赤练龙 - 送神龙2只+拆件器(136颗粒),空术神庙村送拆件器,酒红色(双翼冥火龙),藏青色(蓝魄飞焰龙),桔色(白银圣翼龙),米白(烈焰飞天龙),西瓜红(焱火霹雳龙),玄体拳水龙【289颗粒】,杏色(烈风圣翼龙),8600幻影系列【四套全】(共530颗粒),8400两款战甲套装【共729颗粒】,8400两款飞龙套装【共646颗粒】,8400战龙系列【四套共1375颗粒】,空术神庙村-双龙袭庙【送拆件器】,空术神庙村-四龙袭庙【送拆件器】,龙族四款随机单款', null);
INSERT INTO `sp_attribute` VALUES ('102', '主体-品牌', '1233', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('103', '规格-厚度', '1233', 'only', 'manual', '2mm', null);
INSERT INTO `sp_attribute` VALUES ('104', '颜色', '1233', 'many', 'list', '飞行棋单面游戏垫82*82CM,飞行棋+大福翁双面游戏垫116*96CM,飞行棋+大福翁单面游戏垫186*116CM', null);
INSERT INTO `sp_attribute` VALUES ('105', '主体-品牌', '1234', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('106', '材质-包装尺寸', '1234', 'only', 'manual', '115mm90mm36mm毫米', null);
INSERT INTO `sp_attribute` VALUES ('107', '规格-重量', '1234', 'only', 'manual', '0.5克', null);
INSERT INTO `sp_attribute` VALUES ('108', '充气游泳池', '1234', 'many', 'list', '122-90-40标准套餐,200-150-53-标准套餐,115-95-75豪华套餐,350-170-66标准套餐,152-108-51标准套餐,262-170-53标准版,122-90-40基础套餐,122-90-40豪华版,200-150-53豪华版,140-110-70标准版,182-145-60标准套餐,140-110-70豪华套餐,152-108-51豪华套餐,308-182-60豪华套餐,350-170-66豪华套餐,262-170-53豪华套餐,308-182-60标准版,182-145-60豪华版,115-95-75基础,115-95-75标准套餐,115*95*75cm标准套餐', null);
INSERT INTO `sp_attribute` VALUES ('109', '主体-品牌', '1235', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('110', '规格-实物尺寸', '1235', 'only', 'manual', '63.5*10*46厘米', null);
INSERT INTO `sp_attribute` VALUES ('111', '颜色', '1235', 'many', 'list', '声光安抚人鱼公主,声光安抚人鱼王子,多功能学习桌,奇幻森林摇椅,宝宝启蒙套装,森林钢琴健身架,活动健身架,音乐健身架', null);
INSERT INTO `sp_attribute` VALUES ('112', '主体-品牌', '1236', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('113', '材质-实物尺寸', '1236', 'only', 'manual', '3厘米', null);
INSERT INTO `sp_attribute` VALUES ('114', '大迷宫', '1236', 'many', 'list', 'DHA城市交通迷宫,DHA快乐农场迷宫', null);
INSERT INTO `sp_attribute` VALUES ('115', '主体-品牌', '1237', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('116', '规格-包装尺寸', '1237', 'only', 'manual', '250毫米', null);
INSERT INTO `sp_attribute` VALUES ('117', '配置', '1237', 'many', 'list', '37件简易装,103盒装+200片雪花片,800件收纳袋装+送100补充,668件收纳袋装+送100补充,558件收纳袋装+送100补充,828件礼盒装+送100补充包,628件礼盒装+送100补充包,518件礼盒装+送100补充包,428件礼盒装+送100补充包,358件礼盒装+送100补充包,468件收纳袋装+送100补充,370件收纳袋装+送100补充,268件收纳袋装+送100补充,208件收纳袋装+送100补充,140件磁力棒无赠品,268件', null);
INSERT INTO `sp_attribute` VALUES ('118', '主体-品牌', '1238', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('119', '材质-商品尺寸', '1238', 'only', 'manual', '其他尺寸', null);
INSERT INTO `sp_attribute` VALUES ('120', '颜色', '1238', 'many', 'list', '乐迪包裹造型挎包,乐迪圆形挎包,乐迪蛋壳背包,乐迪造型斗篷,小爱圆形挎包,小爱蛋壳背包', null);
INSERT INTO `sp_attribute` VALUES ('121', '主体-品牌', '1239', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('122', '规格-包装尺寸', '1239', 'only', 'manual', '900*360*200毫米', null);
INSERT INTO `sp_attribute` VALUES ('123', '颜色', '1239', 'many', 'list', '卡通小鹿粉蓝色,卡通小鹿黄绿色,卡通小鹿蓝桔色,卡通小鹿紫玫色,卡通小鹿粉玫色,卡通小鹿绿橘色', null);
INSERT INTO `sp_attribute` VALUES ('124', '主体-品牌', '123', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('125', '规格-规格', '123', 'only', 'manual', '250ml', null);
INSERT INTO `sp_attribute` VALUES ('126', '功效-功效', '123', 'only', 'manual', '清洁,淡化异味', null);
INSERT INTO `sp_attribute` VALUES ('127', '香型', '123', 'many', 'list', '洋甘菊,百合,蔓越莓', null);
INSERT INTO `sp_attribute` VALUES ('128', '主体-品牌', '1240', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('129', '规格-重量', '1240', 'only', 'manual', '0.8克', null);
INSERT INTO `sp_attribute` VALUES ('130', '颜色', '1240', 'many', 'list', '30个6.5CM海洋球,50个6.5CM海洋球,100个6.5CM海洋球', null);
INSERT INTO `sp_attribute` VALUES ('131', '主体-品牌', '1241', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('132', '材质-包装尺寸', '1241', 'only', 'manual', '630x310x380毫米', null);
INSERT INTO `sp_attribute` VALUES ('133', '颜色', '1241', 'many', 'list', '不倒翁979,健儿球 929,快乐摇马987,摇铃939,欢乐园717,跳跳椅696', null);
INSERT INTO `sp_attribute` VALUES ('134', '主体-品牌', '1242', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('135', '特性-包装尺寸', '1242', 'only', 'manual', '185*3*265毫米', null);
INSERT INTO `sp_attribute` VALUES ('136', '主体-品牌', '1243', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('137', '规格-包装尺寸', '1243', 'only', 'manual', '300*90*175毫米', null);
INSERT INTO `sp_attribute` VALUES ('138', '主体-品牌', '1244', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('139', '材质-实物尺寸', '1244', 'only', 'manual', '60*38*120+76厘米', null);
INSERT INTO `sp_attribute` VALUES ('140', '颜色', '1244', 'many', 'list', '童话游戏屋,投手球池,热带雨林帐篷三件套,星月球池,1.2米圆点球池,海豚投篮球池球池,萤火虫投篮球池,热带雨林隧道', null);
INSERT INTO `sp_attribute` VALUES ('141', '主体-品牌', '1245', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('142', '规格-实物尺寸', '1245', 'only', 'manual', '16厘米', null);
INSERT INTO `sp_attribute` VALUES ('143', '颜色', '1245', 'many', 'list', '橙色佩奇,蓝色乔治,粉色佩奇,乔治', null);
INSERT INTO `sp_attribute` VALUES ('144', '主体-品牌', '1247', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('145', '规格-实物尺寸', '1247', 'only', 'manual', '20-30cm', null);
INSERT INTO `sp_attribute` VALUES ('146', '颜色', '1247', 'many', 'list', '粉色海马,蓝色海马', null);
INSERT INTO `sp_attribute` VALUES ('147', '主体-类别', '1248', 'only', 'manual', '游戏叠叠乐', null);
INSERT INTO `sp_attribute` VALUES ('148', '规格-包装尺寸', '1248', 'only', 'manual', '285*80*80毫米', null);
INSERT INTO `sp_attribute` VALUES ('149', '51数字叠叠乐', '1248', 'many', 'list', '51数字叠叠乐+锤子,51数字叠叠乐,51数字叠叠乐+锤子,51数字叠叠乐', null);
INSERT INTO `sp_attribute` VALUES ('150', '主体-品牌', '1249', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('151', '规格-包装尺寸', '1249', 'only', 'manual', '250毫米', null);
INSERT INTO `sp_attribute` VALUES ('152', '主体参数-品牌', '124', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('153', '规格参数-包装', '124', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('154', '其他参数-产品标准号', '124', 'only', 'manual', '。', null);
INSERT INTO `sp_attribute` VALUES ('155', '特性参数-产品剂型', '124', 'only', 'manual', '片剂', null);
INSERT INTO `sp_attribute` VALUES ('156', '主体-品牌', '1251', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('157', '规格-重量', '1251', 'only', 'manual', '7克', null);
INSERT INTO `sp_attribute` VALUES ('158', '主体-适用年龄', '1252', 'only', 'manual', '1-3岁', null);
INSERT INTO `sp_attribute` VALUES ('159', '规格-包装尺寸', '1252', 'only', 'manual', '312*108*273毫米', null);
INSERT INTO `sp_attribute` VALUES ('160', '主体-品牌', '1253', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('161', '规格-包装尺寸', '1253', 'only', 'manual', '635.25毫米', null);
INSERT INTO `sp_attribute` VALUES ('162', '电源-充电', '1253', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('163', '颜色', '1253', 'many', 'list', '一辆装,二十辆装,五十辆装,十辆装', null);
INSERT INTO `sp_attribute` VALUES ('164', '主体-品牌', '1254', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('165', '规格-包装尺寸', '1254', 'only', 'manual', '270*90*440毫米', null);
INSERT INTO `sp_attribute` VALUES ('166', '电源-充电', '1254', 'only', 'manual', '非充电', null);
INSERT INTO `sp_attribute` VALUES ('167', '颜色分类', '1254', 'many', 'list', '蓝色钓鱼台,粉色钓鱼台', null);
INSERT INTO `sp_attribute` VALUES ('168', '主体-品牌', '1255', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('169', '主体-品牌', '1256', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('170', '规格-实物尺寸', '1256', 'only', 'manual', '130厘米', null);
INSERT INTO `sp_attribute` VALUES ('171', '主体-品牌', '1257', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('172', '规格-实物尺寸', '1257', 'only', 'manual', '17*14*18.5厘米', null);
INSERT INTO `sp_attribute` VALUES ('173', '颜色', '1257', 'many', 'list', '大鹏,安琪,皮皮,豆豆,金宝', null);
INSERT INTO `sp_attribute` VALUES ('174', '主体-品牌', '1258', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('175', '材质-材质', '1258', 'only', 'manual', '塑料', null);
INSERT INTO `sp_attribute` VALUES ('176', '颜色', '1258', 'many', 'list', '会讲故事的大号近程导弹车,会讲故事的大号反战舰导弹车,会讲故事的坦克,迷你军事单款随机,迷你军事小队6只装', null);
INSERT INTO `sp_attribute` VALUES ('177', '主体参数-品牌', '125', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('178', '规格参数-包装', '125', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('179', '特性参数-蓝帽标识', '125', 'only', 'manual', '普通膳食补充剂（非健字号）', null);
INSERT INTO `sp_attribute` VALUES ('180', '其他参数-适宜人群', '125', 'only', 'manual', '男女通用', null);
INSERT INTO `sp_attribute` VALUES ('181', '规格', '125', 'many', 'list', '双倍氨糖,单倍氨糖', null);
INSERT INTO `sp_attribute` VALUES ('182', '主体-品牌', '1260', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('183', '特色-风格', '1260', 'only', 'manual', '百搭', null);
INSERT INTO `sp_attribute` VALUES ('184', '面料-面料', '1260', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('185', '颜色', '1260', 'many', 'list', '浅黄色,浅粉色,天蓝色,80CM,90CM,100cm,110cm,120cm', null);
INSERT INTO `sp_attribute` VALUES ('186', '主体-品牌', '1261', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('187', '面料-面料', '1261', 'only', 'manual', '棉', null);
INSERT INTO `sp_attribute` VALUES ('188', '设计-是否带帽', '1261', 'only', 'manual', '有帽不可拆', null);
INSERT INTO `sp_attribute` VALUES ('189', '特色-风格', '1261', 'only', 'manual', '百搭', null);
INSERT INTO `sp_attribute` VALUES ('190', '颜色', '1261', 'many', 'list', '红-白花,黑-白花,黑-红花,120cm,130cm,140cm,150cm,160cm,170cm', null);
INSERT INTO `sp_attribute` VALUES ('191', '主体-品牌', '1262', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('192', '规格-领型', '1262', 'only', 'manual', '圆领', null);
INSERT INTO `sp_attribute` VALUES ('193', '特色-毛衣纱线', '1262', 'only', 'manual', '普通毛线', null);
INSERT INTO `sp_attribute` VALUES ('194', '颜色', '1262', 'many', 'list', '小熊高领白色,小熊高领黑色,小熊高领灰色,小熊高领黄色,小熊高领红色,圆领白色,高领黑色,圆领黑色,高领灰色,圆领灰色,高领红色,圆领红色,高领黄色,圆领黄色,高领粉色,圆领粉色,高领绿色,圆领绿色,90,100,110,120,130,140', null);
INSERT INTO `sp_attribute` VALUES ('195', '主体-品牌', '1263', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('196', '面料-面料', '1263', 'only', 'manual', '纯棉', null);
INSERT INTO `sp_attribute` VALUES ('197', '设计-性别', '1263', 'only', 'manual', '男宝宝', null);
INSERT INTO `sp_attribute` VALUES ('198', '特性-安全等级', '1263', 'only', 'manual', 'A', null);
INSERT INTO `sp_attribute` VALUES ('199', '颜色', '1263', 'many', 'list', '加厚深灰熊猫冬款哈衣,加厚灰色老虎连体款,加厚企鹅连体哈衣,愤怒小鸟哈衣,加厚老虎黄带帽哈衣,加厚小黄鸭带帽棉连体,加厚奶牛冬款哈衣,豹点虎连体款图色,73cm(73码建议身高52-68CM),90cm(90码建议身高85CM以内),80cm(80码建议身高68-78CM)', null);
INSERT INTO `sp_attribute` VALUES ('200', '主体-品牌', '1264', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('201', '面料-面料', '1264', 'only', 'manual', '纯棉', null);
INSERT INTO `sp_attribute` VALUES ('202', '设计-袖长', '1264', 'only', 'manual', '长袖', null);
INSERT INTO `sp_attribute` VALUES ('203', '颜色', '1264', 'many', 'list', '小黄鸭,米老鼠,小猴子,卡通猫,熊猫,小鹿,吉普车,酒红色云梯,橘色数字,卡其色米老鼠,蓝袖小狗,绿色仙人掌,黄色小红人,蓝色猴头,帽子女孩,浅紫棒棒糖,绿色熊头,纯白色,55#（适合身高80-90cm）,60#（适合身高90-100cm）,65#（适合身高100-110cm）,70#（适合身高110-120cm）,75#（适合身高120-130cm）,80#（适合身高130-140cm）', null);
INSERT INTO `sp_attribute` VALUES ('204', '主体-品牌', '1265', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('205', '特色-风格', '1265', 'only', 'manual', '百搭', null);
INSERT INTO `sp_attribute` VALUES ('206', '颜色', '1265', 'many', 'list', '5530卡其色,5530蓝色,73cm,90cm,100cm', null);
INSERT INTO `sp_attribute` VALUES ('207', '主体-品牌', '1266', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('208', '设计-衣门襟', '1266', 'only', 'manual', '拉链', null);
INSERT INTO `sp_attribute` VALUES ('209', '颜色', '1266', 'many', 'list', '棕色,米色,73cm,80cm,85cm,90cm,95cm,105cm', null);
INSERT INTO `sp_attribute` VALUES ('210', '主体-品牌', '1267', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('211', '特色-风格', '1267', 'only', 'manual', '百搭', null);
INSERT INTO `sp_attribute` VALUES ('212', '设计-衣门襟', '1267', 'only', 'manual', '拉链', null);
INSERT INTO `sp_attribute` VALUES ('213', '颜色', '1267', 'many', 'list', '粉红色,卡其色,绿色,浅蓝色的,90cm,100cm,110cm,120cm', null);
INSERT INTO `sp_attribute` VALUES ('214', '主体-品牌', '1268', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('215', '面料-面料', '1268', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('216', '颜色', '1268', 'many', 'list', '红色,咖啡色,姜黄色,灰色,粉色,天蓝色,14CM*14CM', null);
INSERT INTO `sp_attribute` VALUES ('217', '主体-品牌', '1269', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('218', '面料-面料', '1269', 'only', 'manual', '纯棉', null);
INSERT INTO `sp_attribute` VALUES ('219', '设计-性别', '1269', 'only', 'manual', '婴幼儿通用', null);
INSERT INTO `sp_attribute` VALUES ('220', '颜色', '1269', 'many', 'list', '黄色加厚款,黄色,蓝色加厚款,粉色加厚款,粉色,蓝色,59-66cm（适合0-12个月）', null);
INSERT INTO `sp_attribute` VALUES ('221', '主体参数-品牌', '126', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('222', '规格参数-包装', '126', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('223', '特性参数-蓝帽标识', '126', 'only', 'manual', '普通膳食补充剂（非健字号）', null);
INSERT INTO `sp_attribute` VALUES ('224', '其他参数-适宜人群', '126', 'only', 'manual', '男女通用', null);
INSERT INTO `sp_attribute` VALUES ('225', '主体-品牌', '1270', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('226', '特色-风格', '1270', 'only', 'manual', '百搭,公主', null);
INSERT INTO `sp_attribute` VALUES ('227', '颜色', '1270', 'many', 'list', '红色,粉色,110cm,120cm,130cm,140cm,150cm,160cm', null);
INSERT INTO `sp_attribute` VALUES ('228', '主体-品牌', '1271', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('229', '规格-适用季节', '1271', 'only', 'manual', '夏季', null);
INSERT INTO `sp_attribute` VALUES ('230', '颜色', '1271', 'many', 'list', '默认颜色,默认尺寸', null);
INSERT INTO `sp_attribute` VALUES ('231', '主体-品牌', '1272', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('232', '材质-鞋面材质', '1272', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('233', '颜色', '1272', 'many', 'list', '粉色,卡其色,驼色,蓝色,15码内长12.5cm/适合脚长11.5cm,16码内长13cm/适合脚长12cm,17码内长13.5cm/适合脚长12.5cm,18码内长14cm/适合脚长13cm,19码内长14.5cm/适合脚长13.5cm', null);
INSERT INTO `sp_attribute` VALUES ('234', '主体-品牌', '1274', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('235', '材质-鞋底材质', '1274', 'only', 'manual', '复合底', null);
INSERT INTO `sp_attribute` VALUES ('236', '设计-闭合方式', '1274', 'only', 'manual', '套筒', null);
INSERT INTO `sp_attribute` VALUES ('237', '功能-功能', '1274', 'only', 'manual', '保暖', null);
INSERT INTO `sp_attribute` VALUES ('238', '颜色', '1274', 'many', 'list', '樱红/葡萄紫,藏青/亮红,炫蓝/荧光橙黄,古蓝/藏青,26码,29码,28码,30码,31码,27码', null);
INSERT INTO `sp_attribute` VALUES ('239', '主体-品牌', '1275', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('240', '规格-款式', '1275', 'only', 'manual', '雪地靴', null);
INSERT INTO `sp_attribute` VALUES ('241', '材质-鞋底材质', '1275', 'only', 'manual', '牛筋', null);
INSERT INTO `sp_attribute` VALUES ('242', '设计-鞋头款式', '1275', 'only', 'manual', '圆头', null);
INSERT INTO `sp_attribute` VALUES ('243', '颜色', '1275', 'many', 'list', 'M740PK粉色,M740YB卡其色,M740BR棕色,M740PU紫色,M740RE红色,M740GY灰色,M740BK黑色,120码/内长12cm,125码/内长12.5cm,130码/内长13cm,135码/内长13.5cm,140码/内长14cm,145码/内长14.5cm,150码/内长15cm,155码/内长15.5cm,160码/内长16cm,165码/内长16.5cm,170码/内长17cm,175码/内长17.5cm', null);
INSERT INTO `sp_attribute` VALUES ('244', '主体-品牌', '1276', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('245', '材质-鞋底材质', '1276', 'only', 'manual', '千层底', null);
INSERT INTO `sp_attribute` VALUES ('246', '设计-鞋帮高度', '1276', 'only', 'manual', '1', null);
INSERT INTO `sp_attribute` VALUES ('247', '颜色', '1276', 'many', 'list', '枪色,大红,粉红色,37码/23cm,36码/22.4cm,35码/21.9cm,34码/21.4cm,33码/20.8cm,32码/20.1cm,31码/19.4cm,30码/18.9cm,29码/18cm,28码/17.4cm,27码/16.7cm,26码/16cm', null);
INSERT INTO `sp_attribute` VALUES ('248', '主体-品牌', '1277', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('249', '材质-鞋底材质', '1277', 'only', 'manual', '塑胶', null);
INSERT INTO `sp_attribute` VALUES ('250', '设计-鞋帮高度', '1277', 'only', 'manual', '低帮', null);
INSERT INTO `sp_attribute` VALUES ('251', '颜色', '1277', 'many', 'list', '黑色s88,红色s88,金色s88,21码内长13厘米,22码内长13.5厘米,23码内长14厘米,24码内长14.7厘米,25码内长15.1厘米,26码内长15.5厘米,27码内长16.1厘米,28码内长16.7厘米,29码内长17.4厘米,30码内长18厘米,31码内长19.3厘米,32码内长19.8厘米,33码内长20.5厘米,34码内长21.2厘米,35码内长21.8厘米,36码内长22.5厘米', null);
INSERT INTO `sp_attribute` VALUES ('252', '主体-品牌', '1278', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('253', '颜色', '1278', 'many', 'list', '871深兰桔,871军绿,851宝兰,851大红,817宝兰,817大红,40码/内长约26厘米,33码/内长约21.3厘米,37码/内长约24厘米,39码/内长约25.3厘米,29码/内长约18.7厘米,34码/内长约21.9厘米,32码/内长约20.7厘米,35码/内长约22.7厘米,30码/内长约19.4厘米,31码/内长约19.9厘米,36码/内长约23.3厘米,28码码内长约17.9厘米,38码/内长约24.7厘米', null);
INSERT INTO `sp_attribute` VALUES ('254', '主体-品牌', '1279', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('255', '颜色', '1279', 'many', 'list', '蓝色,玫红,咖啡,大红,18/19码内长15.5cm（适合2-3岁）,20/21码内长17cm（适合3-4岁）,22/23码内长18.5cm（适合5-6岁）,23码内长20cm（适合7-8岁）,24码内长21.5cm（适合8-9岁）,25码内长23cm（适合10-12岁）', null);
INSERT INTO `sp_attribute` VALUES ('256', '主体参数-国产/进口', '127', 'only', 'manual', '进口', null);
INSERT INTO `sp_attribute` VALUES ('257', '规格参数-包装', '127', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('258', '特性参数-蓝帽标识', '127', 'only', 'manual', '普通膳食补充剂（非健字号）', null);
INSERT INTO `sp_attribute` VALUES ('259', '主体-品牌', '1280', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('260', '颜色', '1280', 'many', 'list', '墨绿色,紫色,蓝色,36,39,38,37,41,40', null);
INSERT INTO `sp_attribute` VALUES ('261', '主体-品牌', '1283', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('262', '材质-材质', '1283', 'only', 'manual', '棉', null);
INSERT INTO `sp_attribute` VALUES ('263', '规格-厚薄', '1283', 'only', 'manual', '适中', null);
INSERT INTO `sp_attribute` VALUES ('264', '特色-款式', '1283', 'only', 'manual', '可脱胆', null);
INSERT INTO `sp_attribute` VALUES ('265', '产品说明-产地', '1283', 'only', 'manual', '中国河北保定市', null);
INSERT INTO `sp_attribute` VALUES ('266', '颜色', '1283', 'many', 'list', '清爽红格,梦想桔,清爽棕格,梦想紫,45*93cm棉花薄款,45*93cm蚕丝款,45*93cm棉花厚款', null);
INSERT INTO `sp_attribute` VALUES ('267', '主体-类别', '1284', 'only', 'manual', '隔尿垫', null);
INSERT INTO `sp_attribute` VALUES ('268', '颜色', '1284', 'many', 'list', '四层防水72*120cm,四层防水36*48cm,四层防水80*100cm,四层防水54*76cm,四层防水100*120cm', null);
INSERT INTO `sp_attribute` VALUES ('269', '主体-品牌', '1285', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('270', '规格-产品尺寸', '1285', 'only', 'manual', '48*26cm', null);
INSERT INTO `sp_attribute` VALUES ('271', '颜色', '1285', 'many', 'list', '粉色,蓝色,绿色+咖色枕套', null);
INSERT INTO `sp_attribute` VALUES ('272', '主体-品牌', '1286', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('273', '规格-产品尺寸', '1286', 'only', 'manual', '85*85', null);
INSERT INTO `sp_attribute` VALUES ('274', '产品说明-织造工艺', '1286', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('275', '颜色', '1286', 'many', 'list', 'A8016单色,85*85cm', null);
INSERT INTO `sp_attribute` VALUES ('276', '主体-品牌', '1287', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('277', '特性-产品尺寸', '1287', 'only', 'manual', '120*120CM', null);
INSERT INTO `sp_attribute` VALUES ('278', '颜色', '1287', 'many', 'list', '白色,粉色,黄色,蓝色,绿色,小熊,小风车', null);
INSERT INTO `sp_attribute` VALUES ('279', '主体-品牌', '1288', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('280', '规格-产品尺寸', '1288', 'only', 'manual', '110*60cm', null);
INSERT INTO `sp_attribute` VALUES ('281', '面料-面料', '1288', 'only', 'manual', '全棉', null);
INSERT INTO `sp_attribute` VALUES ('282', '产品说明-包装内容', '1288', 'only', 'manual', '床单/床褥,枕头,床围', null);
INSERT INTO `sp_attribute` VALUES ('283', '颜色', '1288', 'many', 'list', '彩棉四件套（床头+l型床围+床单+长床围）', null);
INSERT INTO `sp_attribute` VALUES ('284', '主体-品牌', '1289', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('285', '特性-材质', '1289', 'only', 'manual', '其它', null);
INSERT INTO `sp_attribute` VALUES ('286', '颜色', '1289', 'many', 'list', '高腰纯色款（防水）,低腰绿色条纹（不防水,低腰杏色条纹（不防水,低腰杏色条纹(防水）,低腰款绿色条纹（防水）,XL适合25-30斤,L适合18-25斤,M适合12-18斤,S适合5-12斤', null);
INSERT INTO `sp_attribute` VALUES ('287', '主体-品牌', '1290', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('288', '面料-面料', '1290', 'only', 'manual', '纯棉', null);
INSERT INTO `sp_attribute` VALUES ('289', '颜色', '1290', 'many', 'list', '白色', null);
INSERT INTO `sp_attribute` VALUES ('290', '主体-品牌', '1291', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('291', '规格-产品尺寸', '1291', 'only', 'manual', '70*120cm', null);
INSERT INTO `sp_attribute` VALUES ('292', '颜色', '1291', 'many', 'list', '蓝色,粉色,咖色,绿色,125*74cm', null);
INSERT INTO `sp_attribute` VALUES ('293', '主体-背带方式', '1292', 'only', 'manual', '双肩', null);
INSERT INTO `sp_attribute` VALUES ('294', '颜色', '1292', 'many', 'list', '湛蓝绿,胭脂粉,珊瑚橙,【透气款】高级灰,【透气款】湖水蓝,高级灰,蔷薇粉【透气款】,均码', null);
INSERT INTO `sp_attribute` VALUES ('295', '主体-适用季节', '1293', 'only', 'manual', '春季,夏季,秋季,冬季', null);
INSERT INTO `sp_attribute` VALUES ('296', '颜色', '1293', 'many', 'list', '灰色', null);
INSERT INTO `sp_attribute` VALUES ('297', '主体-品牌', '1294', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('298', '面料-面料', '1294', 'only', 'manual', '精梳棉', null);
INSERT INTO `sp_attribute` VALUES ('299', '设计-性别', '1294', 'only', 'manual', '男宝宝', null);
INSERT INTO `sp_attribute` VALUES ('300', '特性-安全等级', '1294', 'only', 'manual', 'A', null);
INSERT INTO `sp_attribute` VALUES ('301', '颜色', '1294', 'many', 'list', '蓝色,73cm,66cm,59cm', null);
INSERT INTO `sp_attribute` VALUES ('302', '主体-品牌', '1296', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('303', '颜色', '1296', 'many', 'list', '宝蓝,碳灰,31码/20.5cm,32码/21cm,33码/21.5cm,34码/22cm,35码/22.5cm,36码/23cm,37码/23.5cm,38码/24cm,39码/24.5cm,40码/25cm,41码/25.5cm', null);
INSERT INTO `sp_attribute` VALUES ('304', '主体-品牌', '1297', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('305', '材质-鞋底材质', '1297', 'only', 'manual', '橡胶', null);
INSERT INTO `sp_attribute` VALUES ('306', '设计-闭合方式', '1297', 'only', 'manual', '魔术贴', null);
INSERT INTO `sp_attribute` VALUES ('307', '功能-功能', '1297', 'only', 'manual', '防滑', null);
INSERT INTO `sp_attribute` VALUES ('308', '颜色', '1297', 'many', 'list', '红色,黑色,26码/16.6cm,27码/17.2cm,28码/17.8cm,29码/18.4cm,30码/19cm', null);
INSERT INTO `sp_attribute` VALUES ('309', '主体参数-品牌', '129', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('310', '规格参数-包装', '129', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('311', '特性参数-蓝帽标识', '129', 'only', 'manual', '普通膳食补充剂（非健字号）', null);
INSERT INTO `sp_attribute` VALUES ('312', 'Swisse鱼油', '129', 'many', 'list', '包邮包税鱼油双瓶装,包邮包税鱼油单瓶装', null);
INSERT INTO `sp_attribute` VALUES ('313', '版本', '12', 'many', 'list', '小米电视4A 32英寸,小米电视4A 43英寸,小米电视4A 49英寸 标准版,小米电视4A 55英寸 标准版,小米电视3S 55英寸,小米电视4  49英寸,小米电视4  55英寸,【新品】小米电视4C 43英寸,【新品】小米电视4C 55英寸,小米电视4A 65英寸 标准版', null);
INSERT INTO `sp_attribute` VALUES ('314', '主体-适用年龄', '1303', 'only', 'manual', '0-6个月', null);
INSERT INTO `sp_attribute` VALUES ('315', '规格-重量', '1303', 'only', 'manual', '1克', null);
INSERT INTO `sp_attribute` VALUES ('316', '主体-品牌', '1305', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('317', '规格-厚度', '1305', 'only', 'manual', '2CM', null);
INSERT INTO `sp_attribute` VALUES ('318', '颜色', '1305', 'many', 'list', '2CM厚卷筒A款米奇妙妙屋,2CM厚卷筒B款维尼戏水,2CM厚卷筒C款维尼乐园,1.2CM厚礼盒装A款米奇妙妙屋,1.2CM厚礼盒装B款维尼戏水,1.2CM厚礼盒装C款维尼乐园,0.5CM厚礼袋装A款米奇妙妙屋,0.5CM厚礼袋装B款维尼戏水,0.5CM厚礼袋装C款维尼乐园', null);
INSERT INTO `sp_attribute` VALUES ('319', '主体-适用年龄', '1306', 'only', 'manual', '3-6岁', null);
INSERT INTO `sp_attribute` VALUES ('320', '规格-包装尺寸', '1306', 'only', 'manual', '240*260*290毫米', null);
INSERT INTO `sp_attribute` VALUES ('321', '颜色', '1306', 'many', 'list', '19件套厨房玩具-袋装,60件套厨房玩具-礼盒装,3合1多功能过家家购物车-51件套（含10粒可切蔬果）,26件套声光医具-手提收纳盒,27件带医具收纳盒', null);
INSERT INTO `sp_attribute` VALUES ('322', '主体-品牌', '1307', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('323', '规格-实物尺寸', '1307', 'only', 'manual', '30-50cm', null);
INSERT INTO `sp_attribute` VALUES ('324', '颜色', '1307', 'many', 'list', '小提琴家,梦幻衣橱,梦幻衣橱BMC00,设计礼盒,闪亮度假屋', null);
INSERT INTO `sp_attribute` VALUES ('325', '主体-品牌', '1308', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('326', '规格-包装尺寸', '1308', 'only', 'manual', '565*240*140毫米', null);
INSERT INTO `sp_attribute` VALUES ('327', '电源-充电', '1308', 'only', 'manual', '可充电', null);
INSERT INTO `sp_attribute` VALUES ('328', '主体参数-品牌', '130', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('329', '规格参数-包装', '130', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('330', '特性参数-蓝帽标识', '130', 'only', 'manual', '普通膳食补充剂（非健字号）', null);
INSERT INTO `sp_attribute` VALUES ('331', '其他参数-适宜人群', '130', 'only', 'manual', '男女通用', null);
INSERT INTO `sp_attribute` VALUES ('332', '主体-品牌', '1310', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('333', '规格-成色', '1310', 'only', 'manual', 'Pt950', null);
INSERT INTO `sp_attribute` VALUES ('334', '描述-用途', '1310', 'only', 'manual', '送自己', null);
INSERT INTO `sp_attribute` VALUES ('335', '克重', '1310', 'many', 'list', '约3.7-3.8克（链长42cm）', null);
INSERT INTO `sp_attribute` VALUES ('336', '主体-品牌', '1312', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('337', '主体-品牌', '1313', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('338', '描述-支持定制', '1313', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('339', '颜色', '1313', 'many', 'list', '未羊,卯兔,子鼠,酉鸡,丑牛,午马,亥猪,戌狗,寅虎,辰龙,巳蛇,申猴', null);
INSERT INTO `sp_attribute` VALUES ('340', '主体-品牌', '1314', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('341', '规格-成色', '1314', 'only', 'manual', '足金', null);
INSERT INTO `sp_attribute` VALUES ('342', '描述-用途', '1314', 'only', 'manual', '投资', null);
INSERT INTO `sp_attribute` VALUES ('343', '克重', '1314', 'many', 'list', '10克联系客服拍下,30克/联系客服拍下,60克/联系客服拍下,100g/联系客服拍下', null);
INSERT INTO `sp_attribute` VALUES ('344', '主体-品牌', '1316', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('345', '规格-钻石颜色', '1316', 'only', 'manual', 'I-J级', null);
INSERT INTO `sp_attribute` VALUES ('346', '描述-用途', '1316', 'only', 'manual', '结婚', null);
INSERT INTO `sp_attribute` VALUES ('347', '尺码', '1316', 'many', 'list', '主钻5分系列(1克拉效果),主钻8分系列(2克拉效果),主钻14分系列(3克拉效果),系列套装(18K金女戒/耳钉/吊坠),定金单拍定金不发货，定制请联系客服,其他手寸请联系在线客服', null);
INSERT INTO `sp_attribute` VALUES ('348', '主体-品牌', '1317', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('349', '规格-形状', '1317', 'only', 'manual', '路路通', null);
INSERT INTO `sp_attribute` VALUES ('350', '描述-风格', '1317', 'only', 'manual', '复古', null);
INSERT INTO `sp_attribute` VALUES ('351', '颜色', '1317', 'many', 'list', '满金星小叶紫檀12颗*20mm,满金星小叶紫檀13颗*18mm,满金星小叶紫檀15颗*15mm,爆满金星20mm*12颗,爆满金星18mm*13颗,爆满金星15mm*15颗,吊坠可选弟子珠、圆柱、葫芦，需要更换可联系客服，默认发弟子珠', null);
INSERT INTO `sp_attribute` VALUES ('352', '主体-品牌', '1318', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('353', '描述-用途', '1318', 'only', 'manual', '送长辈', null);
INSERT INTO `sp_attribute` VALUES ('354', '规格-形状', '1318', 'only', 'manual', '扁圆', null);
INSERT INTO `sp_attribute` VALUES ('355', '颜色', '1318', 'many', 'list', '精选近正圆款,优雅近圆款,饱满包子圆款', null);
INSERT INTO `sp_attribute` VALUES ('356', '主体-品牌', '1319', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('357', '描述-用途', '1319', 'only', 'manual', '送恋人', null);
INSERT INTO `sp_attribute` VALUES ('358', '主体参数-国产/进口', '131', 'only', 'manual', '进口', null);
INSERT INTO `sp_attribute` VALUES ('359', '规格参数-包装', '131', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('360', '特性参数-蓝帽标识', '131', 'only', 'manual', '普通膳食补充剂（非健字号）', null);
INSERT INTO `sp_attribute` VALUES ('361', '主体-类别', '1320', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('362', '颜色', '1320', 'many', 'list', 'nc1207,nc12114,Cosm247,Cosm244,精选单克价格，3克起发货送工具包,nc12117,nc12119,39,Cosm234,nc1224,nc1220,cosm255蜜蜡,nc1211,Cosm258,2q07,SN95鸡油黄,SN96荔枝白,SN97蜜蜡,SN98蜜蜡全皮,SN99鸡油黄,SN100蜜蜡少珀,SN101鸡油黄,SN102蜜蜡,SN103金绞蜜全皮,SN104蜜蜡,SN105鸡油黄,SN106金绞蜜,SN107蜜蜡,SN108鸡油黄,SN109蜜蜡少珀,精选3-4g原石随机发,琥珀原石单颗2g-2块随机发送打磨工具,1-3g随机发,SN445,SN446,SN447,SN448,SN449,SN450,SN451,SN452,SN453,SN454,SN455,SN456,SN457,SN458,SN459,SN460', null);
INSERT INTO `sp_attribute` VALUES ('363', '主体-材质', '1321', 'only', 'manual', '银', null);
INSERT INTO `sp_attribute` VALUES ('364', '规格-成色', '1321', 'only', 'manual', '足银', null);
INSERT INTO `sp_attribute` VALUES ('365', '描述-用途', '1321', 'only', 'manual', '投资', null);
INSERT INTO `sp_attribute` VALUES ('366', '克重', '1321', 'many', 'list', '100克', null);
INSERT INTO `sp_attribute` VALUES ('367', '主体-品牌', '1322', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('368', '规格-形状', '1322', 'only', 'manual', '貔貅', null);
INSERT INTO `sp_attribute` VALUES ('369', '描述-证书', '1322', 'only', 'manual', '省级', null);
INSERT INTO `sp_attribute` VALUES ('370', '颜色', '1322', 'many', 'list', '貔貅', null);
INSERT INTO `sp_attribute` VALUES ('371', '主体-品牌', '1323', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('372', '规格-形状', '1323', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('373', '描述-风格', '1323', 'only', 'manual', '民族风', null);
INSERT INTO `sp_attribute` VALUES ('374', '主体-品牌', '1324', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('375', '规格-形状', '1324', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('376', '描述-风格', '1324', 'only', 'manual', '甜美', null);
INSERT INTO `sp_attribute` VALUES ('377', '颜色', '1324', 'many', 'list', 'S130菱形的爱手链', null);
INSERT INTO `sp_attribute` VALUES ('378', '描述-支持定制', '1325', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('379', '规格-成色', '1325', 'only', 'manual', '925银', null);
INSERT INTO `sp_attribute` VALUES ('380', '主体-品牌', '1325', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('381', '颜色', '1325', 'many', 'list', '四叶草手链', null);
INSERT INTO `sp_attribute` VALUES ('382', '主体-品牌', '1326', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('383', '规格-形状', '1326', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('384', '颜色', '1326', 'many', 'list', '默认颜色', null);
INSERT INTO `sp_attribute` VALUES ('385', '主体-品牌', '1328', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('386', '规格-形状', '1328', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('387', '描述-风格', '1328', 'only', 'manual', '民族风', null);
INSERT INTO `sp_attribute` VALUES ('388', '颜色', '1328', 'many', 'list', '黄金色,银色', null);
INSERT INTO `sp_attribute` VALUES ('389', '主体-品牌', '1329', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('390', '规格-形状', '1329', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('391', '描述-风格', '1329', 'only', 'manual', '日韩', null);
INSERT INTO `sp_attribute` VALUES ('392', '颜色', '1329', 'many', 'list', '白色,咖啡色,灰色,玫瑰红,粉色', null);
INSERT INTO `sp_attribute` VALUES ('393', '主体参数-品牌', '132', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('394', '规格参数-包装', '132', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('395', '特性参数-蓝帽标识', '132', 'only', 'manual', '普通膳食补充剂（非健字号）', null);
INSERT INTO `sp_attribute` VALUES ('396', '其他参数-储存方法', '132', 'only', 'manual', '阴凉处', null);
INSERT INTO `sp_attribute` VALUES ('397', '基本参数-产品剂型', '132', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('398', '主体-品牌', '1330', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('399', '规格-产品尺寸', '1330', 'only', 'manual', '27*27毫米', null);
INSERT INTO `sp_attribute` VALUES ('400', '二轮生肖币', '1330', 'many', 'list', '2015年羊年,2016年猴年,2017年鸡年', null);
INSERT INTO `sp_attribute` VALUES ('401', '主体-品牌', '1331', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('402', '主体-材质', '1332', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('403', '描述-证书', '1332', 'only', 'manual', '市级', null);
INSERT INTO `sp_attribute` VALUES ('404', '颜色', '1332', 'many', 'list', '核桃/一对+礼品盒,核桃一对/带底座,核桃一对/无底座,核桃/单个', null);
INSERT INTO `sp_attribute` VALUES ('405', '主体-品牌', '1333', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('406', '规格-产品尺寸', '1333', 'only', 'manual', '155*77毫米', null);
INSERT INTO `sp_attribute` VALUES ('407', '航天钞；航天币', '1333', 'many', 'list', '航天钞 单张,航天钞 十连,航天币 单枚', null);
INSERT INTO `sp_attribute` VALUES ('408', '主体-品牌', '1334', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('409', '规格-产品尺寸', '1334', 'only', 'manual', '40毫米', null);
INSERT INTO `sp_attribute` VALUES ('410', '主体-材质', '1336', 'only', 'manual', '黄金', null);
INSERT INTO `sp_attribute` VALUES ('411', '规格-成色', '1336', 'only', 'manual', '足金', null);
INSERT INTO `sp_attribute` VALUES ('412', '描述-用途', '1336', 'only', 'manual', '送朋友', null);
INSERT INTO `sp_attribute` VALUES ('413', '克重', '1336', 'many', 'list', '3.4g40cm,3.6g45cm,3.5g40cm,3.9g45cm,3.8g45cm', null);
INSERT INTO `sp_attribute` VALUES ('414', '主体-品牌', '1338', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('415', '规格-成色', '1338', 'only', 'manual', '18K金', null);
INSERT INTO `sp_attribute` VALUES ('416', '描述-用途', '1338', 'only', 'manual', '送自己', null);
INSERT INTO `sp_attribute` VALUES ('417', '克重', '1338', 'many', 'list', '【黄18K金】40CM,【黄18K金】45CM,【红18K金】40CM,【红18K金】45CM,【白18K金】40CM,【白18K金】45CM', null);
INSERT INTO `sp_attribute` VALUES ('418', '主体-品牌', '1339', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('419', '规格-成色', '1339', 'only', 'manual', '足金', null);
INSERT INTO `sp_attribute` VALUES ('420', '描述-用途', '1339', 'only', 'manual', '送自己', null);
INSERT INTO `sp_attribute` VALUES ('421', '克重', '1339', 'many', 'list', '5.41克（含工费180元）', null);
INSERT INTO `sp_attribute` VALUES ('422', '主体参数-品牌', '1340', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('423', '规格参数-包装', '1340', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('424', '其他参数-储存方法', '1340', 'only', 'manual', '干燥,通风,常温,阴凉处,防潮,防虫防蛀', null);
INSERT INTO `sp_attribute` VALUES ('425', '主体-品牌', '1341', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('426', '规格-成色', '1341', 'only', 'manual', '足金', null);
INSERT INTO `sp_attribute` VALUES ('427', '描述-用途', '1341', 'only', 'manual', '送客户', null);
INSERT INTO `sp_attribute` VALUES ('428', '克重', '1341', 'many', 'list', '重约34.25克（链长500mm）,重约33.10克（链长500mm）,重约33.47克（链长500mm）,重约33.97克（链长500mm）,重约31.21克（链长500mm）,重约34.78克（链长500mm）', null);
INSERT INTO `sp_attribute` VALUES ('429', '主体-材质', '1342', 'only', 'manual', '黄金', null);
INSERT INTO `sp_attribute` VALUES ('430', '规格-成色', '1342', 'only', 'manual', '足金', null);
INSERT INTO `sp_attribute` VALUES ('431', '描述-定价类型', '1342', 'only', 'manual', '计价', null);
INSERT INTO `sp_attribute` VALUES ('432', '克重', '1342', 'many', 'list', '10克', null);
INSERT INTO `sp_attribute` VALUES ('433', '主体-品牌', '1344', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('434', '描述-证书', '1344', 'only', 'manual', '市级', null);
INSERT INTO `sp_attribute` VALUES ('435', '颜色', '1344', 'many', 'list', '福袋', null);
INSERT INTO `sp_attribute` VALUES ('436', '主体-品牌', '1345', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('437', '规格-形状', '1345', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('438', '描述-风格', '1345', 'only', 'manual', '甜美', null);
INSERT INTO `sp_attribute` VALUES ('439', '颜色', '1345', 'many', 'list', '紫色—扭扭链长40,白钻—扭扭链长40,幸运天使吊坠,紫色爱心耳钉', null);
INSERT INTO `sp_attribute` VALUES ('440', '主体-品牌', '1346', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('441', '描述-支持定制', '1346', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('442', '颜色', '1346', 'many', 'list', '白金色/5289028,玫瑰金色/5289025', null);
INSERT INTO `sp_attribute` VALUES ('443', '描述-风格', '1347', 'only', 'manual', '欧美', null);
INSERT INTO `sp_attribute` VALUES ('444', '规格-成色', '1347', 'only', 'manual', '足银', null);
INSERT INTO `sp_attribute` VALUES ('445', '主体-品牌', '1347', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('446', '克重', '1347', 'many', 'list', '21克满天星手镯', null);
INSERT INTO `sp_attribute` VALUES ('447', '主体-材质', '1348', 'only', 'manual', '钻石', null);
INSERT INTO `sp_attribute` VALUES ('448', '规格-钻石颜色', '1348', 'only', 'manual', 'I-J级', null);
INSERT INTO `sp_attribute` VALUES ('449', '描述-证书', '1348', 'only', 'manual', '其他国内证书', null);
INSERT INTO `sp_attribute` VALUES ('450', '尺码', '1348', 'many', 'list', '1.5克拉效果H/SI,80分效果（现货闪发）,2克拉效果D-E/VVS,2克拉效果D-E/VS,1.6克拉效果D-E/VS,1.4克拉效果,1.6克拉效果D-E/VVS,1.6克拉效果F-G/SI,1.5克拉效果D-E/SI,1.6克拉效果D-E/SI,2克拉效果F-G/SI', null);
INSERT INTO `sp_attribute` VALUES ('451', '主体-品牌', '1349', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('452', '规格-成色', '1349', 'only', 'manual', '足金', null);
INSERT INTO `sp_attribute` VALUES ('453', '描述-用途', '1349', 'only', 'manual', '送恋人', null);
INSERT INTO `sp_attribute` VALUES ('454', '克重', '1349', 'many', 'list', '1.38-1.44克', null);
INSERT INTO `sp_attribute` VALUES ('455', '主体参数-品牌', '134', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('456', '规格参数-包装', '134', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('457', '其他参数-是否含糖', '134', 'only', 'manual', '不含糖', null);
INSERT INTO `sp_attribute` VALUES ('458', '基本参数-品牌', '1351', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('459', '云台参数-最大控制转速', '1351', 'only', 'manual', '270转/分', null);
INSERT INTO `sp_attribute` VALUES ('460', '相机参数-传感器尺寸', '1351', 'only', 'manual', '0.43英寸', null);
INSERT INTO `sp_attribute` VALUES ('461', '遥控器参数-最大通讯距离', '1351', 'only', 'manual', '7000米', null);
INSERT INTO `sp_attribute` VALUES ('462', 'APP应用参数-移动设备系统版本', '1351', 'only', 'manual', 'ios、安卓', null);
INSERT INTO `sp_attribute` VALUES ('463', '型号', '1351', 'many', 'list', '云台保护罩,全能套装,单机,单肩包,快拆折桨叶,收纳包,智能电池,电池管家,车载充电器', null);
INSERT INTO `sp_attribute` VALUES ('464', '主体参数-成分', '1353', 'only', 'manual', '镁合金高弹性车架', null);
INSERT INTO `sp_attribute` VALUES ('465', '类型', '1353', 'many', 'list', '云台相机,平衡车mini白色,平衡车mini黑色,平衡车plus白色,护具 M码,无人机套装,无人机连接器,滑板车高配版白色,滑板车高配版黑色,电折叠自行车白色,电折叠自行车黑色,自行车配件包,骑行头盔', null);
INSERT INTO `sp_attribute` VALUES ('466', '主体参数-型号', '1354', 'only', 'manual', '小米手环2', null);
INSERT INTO `sp_attribute` VALUES ('467', '屏幕显示-屏幕尺寸', '1354', 'only', 'manual', '0.42英寸', null);
INSERT INTO `sp_attribute` VALUES ('468', '特性功能-防水等级', '1354', 'only', 'manual', '50防水', null);
INSERT INTO `sp_attribute` VALUES ('469', '型号', '1354', 'many', 'list', '2代黑（单品）,光感版,标准黑,腕带绿,腕带蓝,腕带黑', null);
INSERT INTO `sp_attribute` VALUES ('470', '主体参数-型号', '1355', 'only', 'manual', '聚.VR1', null);
INSERT INTO `sp_attribute` VALUES ('471', '屏幕显示-屏幕尺寸', '1355', 'only', 'manual', '5.5英寸', null);
INSERT INTO `sp_attribute` VALUES ('472', '适配信息-适配设备', '1355', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('473', '技术支持-交互方式', '1355', 'only', 'manual', '触摸按键交互', null);
INSERT INTO `sp_attribute` VALUES ('474', '摄像功能-摄像头', '1355', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('475', '影音功能-视频播放', '1355', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('476', '特性功能-是否防水', '1355', 'only', 'manual', '不防水', null);
INSERT INTO `sp_attribute` VALUES ('477', '其他-尺寸', '1355', 'only', 'manual', '15厘米', null);
INSERT INTO `sp_attribute` VALUES ('478', '主体参数-品牌', '1356', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('479', '屏幕显示-屏幕材质', '1356', 'only', 'manual', 'Amoled 圆屏', null);
INSERT INTO `sp_attribute` VALUES ('480', '拍摄功能-摄像头', '1356', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('481', '娱乐生活-音乐播放', '1356', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('482', '特性功能-防水等级', '1356', 'only', 'manual', '50防水', null);
INSERT INTO `sp_attribute` VALUES ('483', '颜色', '1356', 'many', 'list', '4G版-橙色,4G版-黑色,pro版-钛银灰,保时捷版-黑色,蓝牙版-黑色', null);
INSERT INTO `sp_attribute` VALUES ('484', '主体-品牌', '1358', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('485', '功能-耳机频响范围', '1358', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('486', '规格-耳机灵敏度', '1358', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('487', '型号', '1358', 'many', 'list', '清新版,胶囊版,白色,银色,黑色', null);
INSERT INTO `sp_attribute` VALUES ('488', '主体-品牌', '1359', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('489', '视频参数-音频播放格式', '1359', 'only', 'manual', 'MP3', null);
INSERT INTO `sp_attribute` VALUES ('490', '音频参数-音频格式', '1359', 'only', 'manual', 'MP3/WMA/WAV', null);
INSERT INTO `sp_attribute` VALUES ('491', '功能参数-录音功能', '1359', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('492', '规格参数-容量', '1359', 'only', 'manual', '4GB', null);
INSERT INTO `sp_attribute` VALUES ('493', '颜色', '1359', 'many', 'list', '红色,银色,黑色', null);
INSERT INTO `sp_attribute` VALUES ('494', '主体参数-品牌', '135', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('495', '规格参数-包装', '135', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('496', '口味', '135', 'many', 'list', '原味,巧克力味,草莓味', null);
INSERT INTO `sp_attribute` VALUES ('497', '基本参数-型号', '1360', 'only', 'manual', 'Reflect mini BT', null);
INSERT INTO `sp_attribute` VALUES ('498', '特性参数-佩戴方式', '1360', 'only', 'manual', '入耳式', null);
INSERT INTO `sp_attribute` VALUES ('499', '规格参数-重量', '1360', 'only', 'manual', '0.025克', null);
INSERT INTO `sp_attribute` VALUES ('500', '颜色', '1360', 'many', 'list', '库里限量版,深蓝色,红色,青色,黑色', null);
INSERT INTO `sp_attribute` VALUES ('501', '基本参数-系列', '1361', 'only', 'manual', '不详', null);
INSERT INTO `sp_attribute` VALUES ('502', '特性参数-输出功率', '1361', 'only', 'manual', '2*8w', null);
INSERT INTO `sp_attribute` VALUES ('503', '颜色', '1361', 'many', 'list', '脉动2代-银色,脉动2代-黑色,脉动3代-典雅黑,脉动3代-珍珠白', null);
INSERT INTO `sp_attribute` VALUES ('504', '主体-品牌', '1362', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('505', '基本参数-波段', '1362', 'only', 'manual', '6-16(KHZ)', null);
INSERT INTO `sp_attribute` VALUES ('506', '功能参数-AM调幅', '1362', 'only', 'manual', '88-108(MHZ)', null);
INSERT INTO `sp_attribute` VALUES ('507', '规格参数-电源', '1362', 'only', 'manual', '直流6伏', null);
INSERT INTO `sp_attribute` VALUES ('508', '收音机', '1362', 'many', 'list', 'T-01 黑色,T-01 银色,T-03,T-04 黑色,T-04 灰色,T-09,T-13,T-15,T-16,T-19,T-26', null);
INSERT INTO `sp_attribute` VALUES ('509', '主体-品牌', '1363', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('510', '功能-传输接口', '1363', 'only', 'manual', 'USB2.0', null);
INSERT INTO `sp_attribute` VALUES ('511', '规格-电池', '1363', 'only', 'manual', '内置锂电池', null);
INSERT INTO `sp_attribute` VALUES ('512', '录音功能-录音时间', '1363', 'only', 'manual', '约136小时', null);
INSERT INTO `sp_attribute` VALUES ('513', '飞利浦专业录音笔', '1363', 'many', 'list', 'VTR5100 8G 经典锖,VTR5100 8G 中国红,VTR5100 8G 香槟金,VTR5200 8G 锖色,VTR5200 8G 蓝色,VTR5200 8G 金色,VTR5200 8G 粉红色,VTR5000,VTR5500,VTR5810 8G,VTR5800 8G 酒红,VTR6000,VTR6200 8G 黑色,VTR6200 8G 灰色,VTR6600 8G 锖色,VTR6600 8G 蓝色,VTR6600 8G 白色,VTR7100 8G,VTR8000 8G,VTR8010 16G 录像笔,VTR8800 16G,VTR9200语音转文字,DVT3000,DVT4000,DVT6000', null);
INSERT INTO `sp_attribute` VALUES ('514', '主体参数-品牌', '1364', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('515', '功能参数-适配系统', '1364', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('516', '其他参数-重量', '1364', 'only', 'manual', '2千克', null);
INSERT INTO `sp_attribute` VALUES ('517', '型号', '1364', 'many', 'list', '单机版-红古铜-左开门,单机版-红古铜-右开门,单机版-红古铜-无天地钩,单机尊贵版-红古铜-左开门,单机尊贵版-红古铜-右开门,全屋智能版-红古铜-左开门,全屋智能版-红古铜-右开门,全屋智能尊贵版-红古铜-左开门,全屋智能尊贵版-红古铜-右开门,单机版-装饰锁,尊贵版-装饰锁,单机版-霸王锁体,尊贵版-霸王锁体,全景摄像头', null);
INSERT INTO `sp_attribute` VALUES ('518', '主体参数-品牌', '1365', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('519', '规格参数-适配系统', '1365', 'only', 'manual', 'ios,Android', null);
INSERT INTO `sp_attribute` VALUES ('520', '其他参数-重量', '1365', 'only', 'manual', '0.23千克', null);
INSERT INTO `sp_attribute` VALUES ('521', '系列', '1365', 'many', 'list', '1080P夜视升级版,云台摄像机,小米版,摄像机2代,青春版,青春版+卡,1080P版,1080P版白,1080P版黑,女神粉,白色,经典黑,青春绿', null);
INSERT INTO `sp_attribute` VALUES ('522', '主体参数-品牌', '1366', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('523', '屏幕显示-屏幕材质', '1366', 'only', 'manual', '超白钢化玻璃', null);
INSERT INTO `sp_attribute` VALUES ('524', '特性功能-目标提醒功能', '1366', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('525', '型号', '1366', 'many', 'list', '【健康秤】体脂秤,【健康秤】体重秤,【台灯】米家led台灯,【台灯】飞利浦2代,【吸顶灯】飞利浦智睿版,【夜灯】米家感应夜灯,【床头灯】yeelight白色版,【床头灯】米家金色版,【插座】米家智能基础版,【摄像头】小方摄像头,【摄像头】小白摄像机大众版,【摄像头】米家1080P卡片机,【摄像头】米家云台720P,【摄像头】米家小白,【智能家庭套装】家庭礼品装,【智能音箱】小爱音箱,【灯泡】飞利浦智睿版,【相机】米家全景相机套装,【相机】米家小相机', null);
INSERT INTO `sp_attribute` VALUES ('526', '主体-品牌', '1368', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('527', '屏幕参数-屏幕尺寸', '1368', 'only', 'manual', '5.3英寸', null);
INSERT INTO `sp_attribute` VALUES ('528', '存储参数-扩展存储', '1368', 'only', 'manual', '16G', null);
INSERT INTO `sp_attribute` VALUES ('529', '功能参数-真人发音', '1368', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('530', '规格参数-电池', '1368', 'only', 'manual', '5号电池', null);
INSERT INTO `sp_attribute` VALUES ('531', '颜色', '1368', 'many', 'list', '水墨黑,伦敦蓝,蜜桃粉', null);
INSERT INTO `sp_attribute` VALUES ('532', '主体参数-品牌', '136', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('533', '规格参数-包装', '136', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('534', '其他参数-储存方法', '136', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('535', '口味', '136', 'many', 'list', '全脂,脱脂', null);
INSERT INTO `sp_attribute` VALUES ('536', '基本参数-型号', '1370', 'only', 'manual', 'YYD-5', null);
INSERT INTO `sp_attribute` VALUES ('537', '规格参数-电池', '1370', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('538', '型号', '1370', 'many', 'list', 'Y20A,Y50B,YYD-5,太空银,浩瀚灰,灵动粉,皓月白,精灵白,萌宠版套装,象牙白', null);
INSERT INTO `sp_attribute` VALUES ('539', '主体-品牌', '1371', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('540', '屏幕参数-屏幕尺寸', '1371', 'only', 'manual', '6英寸', null);
INSERT INTO `sp_attribute` VALUES ('541', '规格参数-外形尺寸', '1371', 'only', 'manual', '169 X 117X 9.1毫米', null);
INSERT INTO `sp_attribute` VALUES ('542', '型号', '1371', 'many', 'list', 'Kindle入门款升级版,Kindle入门款升级版+保护套,Kindle Paperwhite3经典版,Kindle Paperwhite3经典版+保护套,Paperwhite3漫画版32G+保护套,Kindle Voyage＋保护套,Kindle Oasis 2代,黑色,白色,KO 8G银灰色,KO 32G银灰色', null);
INSERT INTO `sp_attribute` VALUES ('543', '主体-品牌', '1373', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('544', '功能-整句翻译', '1373', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('545', '规格-手写', '1373', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('546', '型号', '1373', 'many', 'list', 'H8S (白),H9S (白),Kids,S1 Pro (金),S2 (金),S3 (金)', null);
INSERT INTO `sp_attribute` VALUES ('547', '主体-品牌', '1374', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('548', '屏幕参数-屏幕尺寸', '1374', 'only', 'manual', '2.8英寸', null);
INSERT INTO `sp_attribute` VALUES ('549', '存储参数-内存', '1374', 'only', 'manual', '4GB', null);
INSERT INTO `sp_attribute` VALUES ('550', '功能参数-真人发音', '1374', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('551', '规格参数-电池种类', '1374', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('552', '版式', '1374', 'many', 'list', 'T2,T500-S,T800-E', null);
INSERT INTO `sp_attribute` VALUES ('553', '主体-型号', '1376', 'only', 'manual', 'F385', null);
INSERT INTO `sp_attribute` VALUES ('554', '复读参数-适用人群', '1376', 'only', 'manual', '小学生,初中生,高中生,大学生,研究生', null);
INSERT INTO `sp_attribute` VALUES ('555', '功能参数-产品用途', '1376', 'only', 'manual', '教育,胎教,英语学习,高考听力,其他', null);
INSERT INTO `sp_attribute` VALUES ('556', '规格参数-调谐方式', '1376', 'only', 'manual', '数字显示', null);
INSERT INTO `sp_attribute` VALUES ('557', 'CD复读机', '1376', 'many', 'list', 'CD-880 蓝色 860升级版带蓝牙,CD-880 白色 860升级版带蓝牙,CD-880 红色 860升级版带蓝牙,CD-860 蓝色 (DVD/USB/TF卡/磁带),CD-860 绿色 (DVD/USB/TF卡/磁带),CD-860 红色 (DVD/USB/TF卡/磁带),CD-830 蓝色 (可插卡u盘带蓝牙),CD-830 红色 (可插卡u盘带蓝牙),CD-530 蓝色 (支持DVD/TF卡/USB带蓝牙),CD-530 红色 (支持DVD/TF卡/USB带蓝牙),CD-820 蓝色 TF版复读机,CD-820 绿色 TF版复读机,CD-820 红色 TF版复读机,CD-209 蓝色 CD复读机,CD-209 红色 CD复读机,CD-208 CD复读机,CD-790 带蓝牙DVD/USB/TF卡/磁带,F-385 便携DVD复读机,F-386 蓝色 便携(CD插卡U盘),F-386 红色 便携(CD插卡U盘),CD-350 蓝色 DVD复读机胎教机,CD-350 红色 DVD复读机胎教机', null);
INSERT INTO `sp_attribute` VALUES ('558', '主体参数-品牌', '137', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('559', '规格参数-包装', '137', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('560', '主体-品牌', '1380', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('561', '功能-是否有线控', '1380', 'only', 'manual', '无线控', null);
INSERT INTO `sp_attribute` VALUES ('562', '规格-适用机型', '1380', 'only', 'manual', '苹果iphone4,苹果iphone4s,苹果iphone5,苹果iphone5s,苹果iphone5c', null);
INSERT INTO `sp_attribute` VALUES ('563', '其他-发声原理', '1380', 'only', 'manual', '动圈', null);
INSERT INTO `sp_attribute` VALUES ('564', '颜色', '1380', 'many', 'list', 'urBeats黑色,urBeats深空灰,urBeats金色,urBeats玫瑰金,urBeats银色', null);
INSERT INTO `sp_attribute` VALUES ('565', '主体-品牌', '1381', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('566', '功能-耳机频响范围', '1381', 'only', 'manual', '其它', null);
INSERT INTO `sp_attribute` VALUES ('567', '规格-耳机灵敏度', '1381', 'only', 'manual', '其它', null);
INSERT INTO `sp_attribute` VALUES ('568', '主体-品牌', '1382', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('569', '规格-保修年限', '1382', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('570', '功能-特殊功能', '1382', 'only', 'manual', '日历', null);
INSERT INTO `sp_attribute` VALUES ('571', '其他-表壳材质', '1382', 'only', 'manual', '精钢', null);
INSERT INTO `sp_attribute` VALUES ('572', '颜色', '1382', 'many', 'list', '弧面·黑带黑面,弧面·黑带白面,弧面·金带白面,简约·银带白面,弧面·金带黑面,简约·黑带黑面,简约·银带黑面,幽灵·黑带黑面,幽灵·银带蓝面,幽灵·银带灰面,简约·金带金面,幽灵·银带白面,幽灵·银带黑面,弧面·银带黑面', null);
INSERT INTO `sp_attribute` VALUES ('573', '主体-品牌', '1384', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('574', '规格-保修年限', '1384', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('575', '其他-表壳材质', '1384', 'only', 'manual', '精钢', null);
INSERT INTO `sp_attribute` VALUES ('576', '颜色', '1384', 'many', 'list', '间玫金钢带,本色钢带,全玫金钢带,土豪金钢带', null);
INSERT INTO `sp_attribute` VALUES ('577', '主体-品牌', '1385', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('578', '规格-保修年限', '1385', 'only', 'manual', '2年', null);
INSERT INTO `sp_attribute` VALUES ('579', '其他-表壳材质', '1385', 'only', 'manual', '精钢', null);
INSERT INTO `sp_attribute` VALUES ('580', '颜色', '1385', 'many', 'list', 'AR1722/AR1725,AR1722/AR1726,AR1757/AR1758,AR5919/AR5920,AR1434/AR1435,男表AR1819,男表AR1677,AR0397/AR1600,男表AR5905,AR5859/AR5867,AR5905/AR5920,女表AR5920,AR1819/AR1682,AR1721/AR1725,AR1677/AR1683,AR5905/AR5906,女表AR1926,AR2434/AR2435,AR0398/AR1601,AR5995/AR5996,AR2440/AR2441,AR5890/AR5891,AR1745/AR1750', null);
INSERT INTO `sp_attribute` VALUES ('581', '主体-品牌', '1386', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('582', '规格-保修年限', '1386', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('583', '功能-特殊功能', '1386', 'only', 'manual', '日历', null);
INSERT INTO `sp_attribute` VALUES ('584', '其他-表壳材质', '1386', 'only', 'manual', '精钢', null);
INSERT INTO `sp_attribute` VALUES ('585', '颜色', '1386', 'many', 'list', '本色钢带黑面,黑色钢带黑面,本色皮带蓝面,间金钢带金面,本色皮带黑面,本色钢带蓝面,本色钢带白面,本色皮带白面,间金钢带蓝面,间金钢带白面,间金皮带蓝面,全金钢带金面', null);
INSERT INTO `sp_attribute` VALUES ('586', '主体-产地', '1388', 'only', 'manual', '中国上海上海市', null);
INSERT INTO `sp_attribute` VALUES ('587', '规格-保修年限', '1388', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('588', '其他-表壳材质', '1388', 'only', 'manual', '钢', null);
INSERT INTO `sp_attribute` VALUES ('589', '颜色', '1388', 'many', 'list', '本色钢带黑面,间金皮带黑面,间金钢带金面,本色皮带黑面,间金皮带白面,本色皮带白面,间金钢带白面,间金钢带黑面,【特别款】全金金面,【特别款】全金黑面,【特别款】全金白面', null);
INSERT INTO `sp_attribute` VALUES ('590', '主体-品牌', '1389', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('591', '规格-保修年限', '1389', 'only', 'manual', '2年', null);
INSERT INTO `sp_attribute` VALUES ('592', '功能-机芯类型', '1389', 'only', 'manual', '电子', null);
INSERT INTO `sp_attribute` VALUES ('593', '其他-表壳材质', '1389', 'only', 'manual', '钢', null);
INSERT INTO `sp_attribute` VALUES ('594', '颜色', '1389', 'many', 'list', 'T063.610.16.058.00,T063.610.36.038.00,T063.610.16.038.00,T063.610.11.038.00', null);
INSERT INTO `sp_attribute` VALUES ('595', '主体参数-品牌', '138', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('596', '规格参数-包装', '138', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('597', '其他参数-储存方法', '138', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('598', '规格', '138', 'many', 'list', 'UMF5+ 250g,UMF5+ 500g,优质黑糖,奇异果水果蜜,柠檬水果蜜,百里香500g,蔓越莓水果蜜,野生花蜜', null);
INSERT INTO `sp_attribute` VALUES ('599', '主体-品牌', '1390', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('600', '规格-重量', '1390', 'only', 'manual', '1千克', null);
INSERT INTO `sp_attribute` VALUES ('601', '其他-显示类型', '1390', 'only', 'manual', '数字', null);
INSERT INTO `sp_attribute` VALUES ('602', '颜色', '1390', 'many', 'list', '蓝色白灯温度版,白色白灯温度版,黑色白灯温度版,玫红白灯温度版,淡绿白灯温度版', null);
INSERT INTO `sp_attribute` VALUES ('603', '主体-型号', '1393', 'only', 'manual', 'H1284', null);
INSERT INTO `sp_attribute` VALUES ('604', '规格-产品重量', '1393', 'only', 'manual', '30克', null);
INSERT INTO `sp_attribute` VALUES ('605', '颜色', '1393', 'many', 'list', '配50-300度近视太阳镜,配300-500度近视太阳镜,枪框灰片P01', null);
INSERT INTO `sp_attribute` VALUES ('606', '主体-型号', '1394', 'only', 'manual', '5087', null);
INSERT INTO `sp_attribute` VALUES ('607', '规格-产品重量', '1394', 'only', 'manual', '23克', null);
INSERT INTO `sp_attribute` VALUES ('608', '颜色', '1394', 'many', 'list', '+400度,+350度,+300度,+250度,+200度,+150度,+100度,老化镜', null);
INSERT INTO `sp_attribute` VALUES ('609', '主体-型号', '1395', 'only', 'manual', 'BL2282', null);
INSERT INTO `sp_attribute` VALUES ('610', '规格-产品重量', '1395', 'only', 'manual', '25克', null);
INSERT INTO `sp_attribute` VALUES ('611', '颜色', '1395', 'many', 'list', 'A17镜框消光黑/镜片绿片,A15镜框枪色/镜片灰色（模特款）,A09镜框砂黑/镜片绿片,A19镜框枪色/镜片蓝色', null);
INSERT INTO `sp_attribute` VALUES ('612', '主体-品牌', '1396', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('613', '规格-产品重量', '1396', 'only', 'manual', '0.3克', null);
INSERT INTO `sp_attribute` VALUES ('614', '颜色', '1396', 'many', 'list', '黑框渐进灰,银框渐进灰,深枪框渐进灰', null);
INSERT INTO `sp_attribute` VALUES ('615', '主体-型号', '1398', 'only', 'manual', '8009', null);
INSERT INTO `sp_attribute` VALUES ('616', '规格-产品重量', '1398', 'only', 'manual', '25克', null);
INSERT INTO `sp_attribute` VALUES ('617', '颜色', '1398', 'many', 'list', '枪框渐灰片,黑框黑灰片,金边框G15片,银框反光膜天蓝片', null);
INSERT INTO `sp_attribute` VALUES ('618', '主体-品牌', '1399', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('619', '规格-产品重量', '1399', 'only', 'manual', '100克', null);
INSERT INTO `sp_attribute` VALUES ('620', '主体参数-品牌', '139', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('621', '规格参数-包装', '139', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('622', '其他参数-储存方法', '139', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('623', '口味', '139', 'many', 'list', '棉花糖牛奶巧克力,榛子巧克力,浓情巧克力,混合装巧克力,牛奶巧克力,特浓巧克力', null);
INSERT INTO `sp_attribute` VALUES ('624', '主体-商品名称', '13', 'only', 'manual', '长虹（CHANGHONG）55D3S 55英寸4K超高清HDR轻薄人工智能语音平板LED液晶电视机', null);
INSERT INTO `sp_attribute` VALUES ('625', '显示-曲面', '13', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('626', '系统-智能电视', '13', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('627', '外观-产品颜色', '13', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('628', 'USB支持格式-USB支持视频格式', '13', 'only', 'manual', 'AVI,MPG,TS,MKV,MOV,MP4,RM,RMVB,H.264,H.265', null);
INSERT INTO `sp_attribute` VALUES ('629', '功耗-整机功率（W）', '13', 'only', 'manual', '138瓦特', null);
INSERT INTO `sp_attribute` VALUES ('630', '规格-含底座尺寸（宽*高*', '13', 'only', 'manual', '1237mm×785mm×209mm毫米', null);
INSERT INTO `sp_attribute` VALUES ('631', '网络-网络连接方式', '13', 'only', 'manual', '有线+无线', null);
INSERT INTO `sp_attribute` VALUES ('632', '内容服务-内容资源', '13', 'only', 'manual', '腾讯', null);
INSERT INTO `sp_attribute` VALUES ('633', '端口-USB2.0端口', '13', 'only', 'manual', '1个', null);
INSERT INTO `sp_attribute` VALUES ('634', '音频-音频技术', '13', 'only', 'manual', 'Dolby', null);
INSERT INTO `sp_attribute` VALUES ('635', '交互设备-无线键鼠', '13', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('636', '互联互通-多屏互动', '13', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('637', '版式', '13', 'many', 'list', '100吋 人工智能激光影院,40英寸 全高清智能10核高配,43英寸 4K疾速人工智能语音,49英寸 4K疾速人工智能语音,49英寸 双64位4K超高清,55英寸 4K疾速人工智能语音,55英寸 双64位4K超高清,55英寸 曲面超薄人工智能,65英寸 UMAX巨幕人工智能曲面', null);
INSERT INTO `sp_attribute` VALUES ('638', '主体-型号', '1400', 'only', 'manual', '1696', null);
INSERT INTO `sp_attribute` VALUES ('639', '规格-产品重量', '1400', 'only', 'manual', '30克', null);
INSERT INTO `sp_attribute` VALUES ('640', '颜色', '1400', 'many', 'list', '亮黑框蓝片,黑框红片', null);
INSERT INTO `sp_attribute` VALUES ('641', '主体-型号', '1401', 'only', 'manual', 'j64159', null);
INSERT INTO `sp_attribute` VALUES ('642', '规格-产品重量', '1401', 'only', 'manual', '350克', null);
INSERT INTO `sp_attribute` VALUES ('643', '颜色', '1401', 'many', 'list', '香槟金,炫彩绿,动感蓝,经典灰', null);
INSERT INTO `sp_attribute` VALUES ('644', '主体-品牌', '1403', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('645', '规格-保修年限', '1403', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('646', '其他-表壳材质', '1403', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('647', '颜色', '1403', 'many', 'list', 'AR1932,AR0389,AR1648,AR0388,AR0387,AR0386,AR0390,AR1755,AR0385,AR0399,AR0398,AR1721,AR0397,AR1722,AR5905,AR1676,AR5919,AR5890,AR2433,AR2448,AR1647,AR1879,AR1881,AR2453,AR2434,AR2432,ar1732,AR1674', null);
INSERT INTO `sp_attribute` VALUES ('648', '主体-品牌', '1404', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('649', '规格-保修年限', '1404', 'only', 'manual', '2年', null);
INSERT INTO `sp_attribute` VALUES ('650', '功能-特殊功能', '1404', 'only', 'manual', '日历', null);
INSERT INTO `sp_attribute` VALUES ('651', '其他-表壳材质', '1404', 'only', 'manual', '精钢', null);
INSERT INTO `sp_attribute` VALUES ('652', '主体-品牌', '1406', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('653', '规格-保修年限', '1406', 'only', 'manual', '2年', null);
INSERT INTO `sp_attribute` VALUES ('654', '功能-特殊功能', '1406', 'only', 'manual', '日历,大三针', null);
INSERT INTO `sp_attribute` VALUES ('655', '其他-表壳材质', '1406', 'only', 'manual', '精钢', null);
INSERT INTO `sp_attribute` VALUES ('656', '颜色', '1406', 'many', 'list', '间金纹路L4.821.2.18.7,间金钢带L4.921.2.11.7,金色皮带L4.921.2.11.2,纹路表盘L4.921.4.18.6,条丁刻度L4.921.4.12.6,罗马刻度L4.921.4.11.6,真皮表带L4.921.4.11.2,黑盘条丁L4.921.4.52.6', null);
INSERT INTO `sp_attribute` VALUES ('657', '主体-品牌', '1407', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('658', '规格-保修年限', '1407', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('659', '其他-表壳材质', '1407', 'only', 'manual', '树脂/橡胶', null);
INSERT INTO `sp_attribute` VALUES ('660', '主体-品牌', '1408', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('661', '规格-保修年限', '1408', 'only', 'manual', '2年', null);
INSERT INTO `sp_attribute` VALUES ('662', '其他-表壳材质', '1408', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('663', '颜色', '1408', 'many', 'list', '白色表壳516732W01A,蓝色皮带516732W01B,玫瑰金表壳516732G01C', null);
INSERT INTO `sp_attribute` VALUES ('664', '主体参数-品牌', '140', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('665', '规格参数-包装', '140', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('666', '其他参数-储存方法', '140', 'only', 'manual', '防潮', null);
INSERT INTO `sp_attribute` VALUES ('667', '数量', '140', 'many', 'list', '1袋,2袋,3袋', null);
INSERT INTO `sp_attribute` VALUES ('668', '主体-品牌', '1411', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('669', '规格-保修年限', '1411', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('670', '其他-表壳材质', '1411', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('671', '颜色', '1411', 'many', 'list', '女表黑色,男表白色,男表黑色,女表白色', null);
INSERT INTO `sp_attribute` VALUES ('672', '主体-品牌', '1412', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('673', '规格-保修年限', '1412', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('674', '其他-表壳材质', '1412', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('675', '颜色', '1412', 'many', 'list', '0900DW/DW00100059,0901DW/DW00100060,0902DW/DW00100061,0903DW/DW00100062', null);
INSERT INTO `sp_attribute` VALUES ('676', '主体-产地', '1413', 'only', 'manual', '中国广东深圳市', null);
INSERT INTO `sp_attribute` VALUES ('677', '规格-保修年限', '1413', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('678', '功能-特殊功能', '1413', 'only', 'manual', '日历', null);
INSERT INTO `sp_attribute` VALUES ('679', '其他-表壳材质', '1413', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('680', '颜色', '1413', 'many', 'list', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('681', '主体-产地', '1414', 'only', 'manual', '瑞士', null);
INSERT INTO `sp_attribute` VALUES ('682', '规格-保修年限', '1414', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('683', '其他-表壳材质', '1414', 'only', 'manual', '精钢', null);
INSERT INTO `sp_attribute` VALUES ('684', '颜色', '1414', 'many', 'list', 'K2G211WL（绿盘绿带）,K2G23120（白面黄带女款）,K2G2G5C6（金色日历男款）,K2G21138（白面黄带男款）,K2G21629（玫瑰金男款）,K2G23620（玫瑰金女款）,K2G211C1（黑面黑带）,K2G23107（黑灰面女款）,K2G211C6（白面黑带男款）,K2G231C6（白面黑带女款）,K2G21107（黑灰面男款）', null);
INSERT INTO `sp_attribute` VALUES ('685', '主体-品牌', '1415', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('686', '规格-保修年限', '1415', 'only', 'manual', '1年', null);
INSERT INTO `sp_attribute` VALUES ('687', '功能-特殊功能', '1415', 'only', 'manual', '日历,防磁', null);
INSERT INTO `sp_attribute` VALUES ('688', '其他-表壳材质', '1415', 'only', 'manual', '精钢', null);
INSERT INTO `sp_attribute` VALUES ('689', '颜色', '1415', 'many', 'list', '7063D2,7061A9,7062A9,7063D9,7061A1,7061D9,7061D2,7062A1', null);
INSERT INTO `sp_attribute` VALUES ('690', '主体-产地', '1416', 'only', 'manual', '瑞士', null);
INSERT INTO `sp_attribute` VALUES ('691', '规格-保修年限', '1416', 'only', 'manual', '2年', null);
INSERT INTO `sp_attribute` VALUES ('692', '功能-特殊功能', '1416', 'only', 'manual', '大三针', null);
INSERT INTO `sp_attribute` VALUES ('693', '其他-表壳材质', '1416', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('694', '颜色', '1416', 'many', 'list', 'M007.207.36.036.00,M007.207.36.116.00,M007.207.36.291.00', null);
INSERT INTO `sp_attribute` VALUES ('695', '基本参数-品牌', '1417', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('696', '功能参数-锁具功能', '1417', 'only', 'manual', '密码锁', null);
INSERT INTO `sp_attribute` VALUES ('697', '外观参数-色系', '1417', 'only', 'manual', '黑色系,银色系', null);
INSERT INTO `sp_attribute` VALUES ('698', '颜色', '1417', 'many', 'list', '黑色,银色,24寸', null);
INSERT INTO `sp_attribute` VALUES ('699', '基本参数-品牌', '1418', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('700', '功能参数-内部结构', '1418', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('701', '外观参数-色系', '1418', 'only', 'manual', '红色系,蓝色系,黑色系,粉色系', null);
INSERT INTO `sp_attribute` VALUES ('702', '颜色', '1418', 'many', 'list', '玫红色小号,粉色小号,天蓝色小号,深蓝色小号,黑色小号,玫红色大号,粉色大号,天蓝色大号,深蓝色大号,黑色大号', null);
INSERT INTO `sp_attribute` VALUES ('703', '主体-品牌', '141', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('704', '外观-颜色', '141', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('705', '系统-手机操作系统', '141', 'only', 'manual', 'IOS', null);
INSERT INTO `sp_attribute` VALUES ('706', 'CPU-CPU核数', '141', 'only', 'manual', '以官网信息为准', null);
INSERT INTO `sp_attribute` VALUES ('707', '网络-4G网络制式', '141', 'only', 'manual', '移动4G,联通4G', null);
INSERT INTO `sp_attribute` VALUES ('708', '存储-机身内存', '141', 'only', 'manual', '256GB', null);
INSERT INTO `sp_attribute` VALUES ('709', '屏幕-屏幕尺寸', '141', 'only', 'manual', '5.8英寸', null);
INSERT INTO `sp_attribute` VALUES ('710', '拍照-前摄像头', '141', 'only', 'manual', '700万像素', null);
INSERT INTO `sp_attribute` VALUES ('711', '电池-电池容量', '141', 'only', 'manual', '2980mAh', null);
INSERT INTO `sp_attribute` VALUES ('712', '接口-蓝牙版本', '141', 'only', 'manual', '蓝牙5.0', null);
INSERT INTO `sp_attribute` VALUES ('713', '手机特性-重力传感器', '141', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('714', '其他-运营商标识', '141', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('715', '颜色', '141', 'many', 'list', '深空灰,银色,64GB,256GB', null);
INSERT INTO `sp_attribute` VALUES ('716', '基本参数-品牌', '1421', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('717', '功能参数-内部结构', '1421', 'only', 'manual', '拉链暗袋,手机袋,证件袋,夹层拉链袋,电脑插袋,其他', null);
INSERT INTO `sp_attribute` VALUES ('718', '外观参数-图案', '1421', 'only', 'manual', '纯色', null);
INSERT INTO `sp_attribute` VALUES ('719', '颜色', '1421', 'many', 'list', '黑色,银色,蓝色,粉色', null);
INSERT INTO `sp_attribute` VALUES ('720', '基本参数-品牌', '1422', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('721', '功能参数-有无夹层', '1422', 'only', 'manual', '有夹层', null);
INSERT INTO `sp_attribute` VALUES ('722', '外观参数-色系', '1422', 'only', 'manual', '黑色系', null);
INSERT INTO `sp_attribute` VALUES ('723', '颜色', '1422', 'many', 'list', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('724', '基本参数-品牌', '1423', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('725', '外观参数-色系', '1423', 'only', 'manual', '红色系,黑色系', null);
INSERT INTO `sp_attribute` VALUES ('726', '颜色', '1423', 'many', 'list', '绿色斜挎包+腰包【发2个】,折叠手提包+腰包【发2个】,腰包黑组合【发2个】,腰包黑+挎包玫红色【发2个】,双肩包黑色+腰包【发2个】,双肩包银色+腰包【发2个】,双肩包蓝色+腰包【发2个】,双肩包粉色+腰包【发2个】', null);
INSERT INTO `sp_attribute` VALUES ('727', '主体参数-品牌', '1424', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('728', '规格参数-类别', '1424', 'only', 'manual', '双肩背包', null);
INSERT INTO `sp_attribute` VALUES ('729', '颜色', '1424', 'many', 'list', '彩版（绿色）,彩版（玫红）,彩版（红色）,经典（玫红）,经典（黑色）,彩版（橘色）,经典（橘色）,经典（绿色）,经典（蓝色）,彩版（蓝色）,经典（红色）,彩版（黑色）', null);
INSERT INTO `sp_attribute` VALUES ('730', '基本参数-型号', '1426', 'only', 'manual', 'A004', null);
INSERT INTO `sp_attribute` VALUES ('731', '外观参数-色系', '1426', 'only', 'manual', '黑色系', null);
INSERT INTO `sp_attribute` VALUES ('732', '功能参数-内部结构', '1427', 'only', 'manual', '拉链暗袋,手机袋', null);
INSERT INTO `sp_attribute` VALUES ('733', '基本参数-品牌', '1427', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('734', '外观参数-色系', '1427', 'only', 'manual', '灰色系,黑色系,白色系,粉色系,棕色系,花色,卡其色系,米色系', null);
INSERT INTO `sp_attribute` VALUES ('735', '颜色', '1427', 'many', 'list', '亮蓝色,黑色,白卡其色,娇羞粉,米色,桃红色,亮桃色,珍珠灰,粉柚色,灰色拼色,米色桃紅色边', null);
INSERT INTO `sp_attribute` VALUES ('736', '基本参数-型号', '1429', 'only', 'manual', 'F36875 F58846', null);
INSERT INTO `sp_attribute` VALUES ('737', '功能参数-硬度', '1429', 'only', 'manual', '软', null);
INSERT INTO `sp_attribute` VALUES ('738', '外观参数-图案', '1429', 'only', 'manual', '纯色', null);
INSERT INTO `sp_attribute` VALUES ('739', '颜色', '1429', 'many', 'list', '热情红,高贵黑,鲜奶白', null);
INSERT INTO `sp_attribute` VALUES ('740', '主体-品牌', '142', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('741', '配置-操作系统', '142', 'only', 'manual', 'iOS', null);
INSERT INTO `sp_attribute` VALUES ('742', '显示-屏幕尺寸', '142', 'only', 'manual', '7.9英寸', null);
INSERT INTO `sp_attribute` VALUES ('743', '网络连接-WIFI功能', '142', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('744', '端口-USB端口', '142', 'only', 'manual', '1个', null);
INSERT INTO `sp_attribute` VALUES ('745', '音效-扬声器', '142', 'only', 'manual', '内置', null);
INSERT INTO `sp_attribute` VALUES ('746', '功能-摄像头', '142', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('747', '电源-电池类型', '142', 'only', 'manual', '聚合物锂', null);
INSERT INTO `sp_attribute` VALUES ('748', '规格-颜色', '142', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('749', '其他-选购热点', '142', 'only', 'manual', '完美音质', null);
INSERT INTO `sp_attribute` VALUES ('750', '颜色', '142', 'many', 'list', '金色,银色,灰色,128G', null);
INSERT INTO `sp_attribute` VALUES ('751', '功能参数-内部结构', '1431', 'only', 'manual', '零钱位,拉链格,钥匙位', null);
INSERT INTO `sp_attribute` VALUES ('752', '外观参数-钱夹折数', '1431', 'only', 'manual', '1折', null);
INSERT INTO `sp_attribute` VALUES ('753', '基本参数-品牌', '1431', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('754', '颜色', '1431', 'many', 'list', '黑色.,红色.', null);
INSERT INTO `sp_attribute` VALUES ('755', '基本参数-型号', '1433', 'only', 'manual', 'F53429 F54626 F58032', null);
INSERT INTO `sp_attribute` VALUES ('756', '功能参数-内部结构', '1433', 'only', 'manual', '证件袋', null);
INSERT INTO `sp_attribute` VALUES ('757', '外观参数-包体外形', '1433', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('758', '颜色', '1433', 'many', 'list', '红色,黑色,鲜奶白F58032', null);
INSERT INTO `sp_attribute` VALUES ('759', '功能参数-内部结构', '1434', 'only', 'manual', '相片位,零钱位,证件位,卡位', null);
INSERT INTO `sp_attribute` VALUES ('760', '外观参数-色系', '1434', 'only', 'manual', '黑色系', null);
INSERT INTO `sp_attribute` VALUES ('761', '基本参数-品牌', '1434', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('762', '颜色', '1434', 'many', 'list', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('763', '基本参数-品牌', '1435', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('764', '功能参数-有无夹层', '1435', 'only', 'manual', '有夹层', null);
INSERT INTO `sp_attribute` VALUES ('765', '外观参数-硬度', '1435', 'only', 'manual', '软', null);
INSERT INTO `sp_attribute` VALUES ('766', '颜色', '1435', 'many', 'list', '红色-大号,黑色-大号,红色-小号,黑色-小号', null);
INSERT INTO `sp_attribute` VALUES ('767', '功能参数-有无夹层', '1437', 'only', 'manual', '有夹层', null);
INSERT INTO `sp_attribute` VALUES ('768', '外观参数-流行元素', '1437', 'only', 'manual', '车缝线', null);
INSERT INTO `sp_attribute` VALUES ('769', '基本参数-品牌', '1437', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('770', '颜色', '1437', 'many', 'list', '黑色,啡色', null);
INSERT INTO `sp_attribute` VALUES ('771', '功能参数-折数', '1439', 'only', 'manual', '1折', null);
INSERT INTO `sp_attribute` VALUES ('772', '基本参数-品牌', '1439', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('773', '外观参数-色系', '1439', 'only', 'manual', '蓝色系,黑色系,棕色系', null);
INSERT INTO `sp_attribute` VALUES ('774', '颜色', '1439', 'many', 'list', '枪扫LOGO黑色,枪扫LOGO啡色,枪扫LOGO蓝色,古金LOGO黑色,古金LOGO啡色,古金LOGO蓝色', null);
INSERT INTO `sp_attribute` VALUES ('775', '基本参数-品牌', '143', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('776', '处理器-核心数', '143', 'only', 'manual', '双核心', null);
INSERT INTO `sp_attribute` VALUES ('777', '内存-内存容量', '143', 'only', 'manual', '8GB', null);
INSERT INTO `sp_attribute` VALUES ('778', '硬盘-硬盘容量', '143', 'only', 'manual', '128GB', null);
INSERT INTO `sp_attribute` VALUES ('779', '显卡-显卡类型', '143', 'only', 'manual', '集成显卡', null);
INSERT INTO `sp_attribute` VALUES ('780', '光驱-光驱类型', '143', 'only', 'manual', '无光驱', null);
INSERT INTO `sp_attribute` VALUES ('781', '显示屏-屏幕尺寸', '143', 'only', 'manual', '13.3英寸', null);
INSERT INTO `sp_attribute` VALUES ('782', '通信-蓝牙功能', '143', 'only', 'manual', '蓝牙4.0', null);
INSERT INTO `sp_attribute` VALUES ('783', '端口-USB2.0端口', '143', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('784', '多媒体设备-内置摄像头', '143', 'only', 'manual', 'HD摄像头', null);
INSERT INTO `sp_attribute` VALUES ('785', '输入设备-指取设备', '143', 'only', 'manual', '触摸板', null);
INSERT INTO `sp_attribute` VALUES ('786', '电源-电池类型', '143', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('787', '规格-厚度', '143', 'only', 'manual', '25毫米', null);
INSERT INTO `sp_attribute` VALUES ('788', '其他-厂商保修政策', '143', 'only', 'manual', '以官网为准', null);
INSERT INTO `sp_attribute` VALUES ('789', '产品', '143', 'many', 'list', 'GF2/i5/8G/128G,GG2/i5/8G/256G,D42/i5/8G/256G,D32/i5/8G/128G', null);
INSERT INTO `sp_attribute` VALUES ('790', '基本参数-品牌', '1440', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('791', '功能参数-内部结构', '1440', 'only', 'manual', '拉链暗袋,手机袋,证件袋,夹层拉链袋,电脑插袋,相机插袋', null);
INSERT INTO `sp_attribute` VALUES ('792', '外观参数-色系', '1440', 'only', 'manual', '蓝色系', null);
INSERT INTO `sp_attribute` VALUES ('793', '颜色', '1440', 'many', 'list', '送皮带,送手包', null);
INSERT INTO `sp_attribute` VALUES ('794', '基本参数-型号', '1443', 'only', 'manual', '1A3454021-02', null);
INSERT INTO `sp_attribute` VALUES ('795', '功能参数-有无夹层', '1443', 'only', 'manual', '有夹层', null);
INSERT INTO `sp_attribute` VALUES ('796', '外观参数-硬度', '1443', 'only', 'manual', '软', null);
INSERT INTO `sp_attribute` VALUES ('797', '颜色', '1443', 'many', 'list', '黑色大号,黑色小号,咖啡色小号,咖啡色大号', null);
INSERT INTO `sp_attribute` VALUES ('798', '基本参数-品牌', '1445', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('799', '外观参数-色系', '1445', 'only', 'manual', '红色系,橙色系,黑色系', null);
INSERT INTO `sp_attribute` VALUES ('800', '颜色', '1445', 'many', 'list', '橙色,黄色,黑色,110CM,115cm,120cm,125cm', null);
INSERT INTO `sp_attribute` VALUES ('801', '基本参数-品牌', '1446', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('802', '外观参数-色系', '1446', 'only', 'manual', '黑色系', null);
INSERT INTO `sp_attribute` VALUES ('803', '颜色', '1446', 'many', 'list', '黑色,110cm,115cm,120cm,125cm,130cm', null);
INSERT INTO `sp_attribute` VALUES ('804', '功能参数-内部结构', '1447', 'only', 'manual', '相片位,暗格,卡位', null);
INSERT INTO `sp_attribute` VALUES ('805', '外观参数-色系', '1447', 'only', 'manual', '红色系', null);
INSERT INTO `sp_attribute` VALUES ('806', '基本参数-品牌', '1447', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('807', '颜色', '1447', 'many', 'list', '2083A-黑色,2123A-黑色,2213A-黑色,2233A-黑色,2203A-黑色', null);
INSERT INTO `sp_attribute` VALUES ('808', '基本参数-品牌', '1448', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('809', '功能参数-有无夹层', '1448', 'only', 'manual', '有夹层', null);
INSERT INTO `sp_attribute` VALUES ('810', '外观参数-硬度', '1448', 'only', 'manual', '软', null);
INSERT INTO `sp_attribute` VALUES ('811', '颜色', '1448', 'many', 'list', '黑色大号,黑色小号', null);
INSERT INTO `sp_attribute` VALUES ('812', '基本参数-品牌', '1449', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('813', '外观参数-色系', '1449', 'only', 'manual', '黑色系,棕色系', null);
INSERT INTO `sp_attribute` VALUES ('814', '颜色', '1449', 'many', 'list', 'PL6130,PL6129,PL6132,PL6131,默认110-130随机发', null);
INSERT INTO `sp_attribute` VALUES ('815', '基本参数-品牌', '144', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('816', '规格参数-电池容量', '144', 'only', 'manual', '1810mAh', null);
INSERT INTO `sp_attribute` VALUES ('817', '型号', '144', 'many', 'list', 'iPhone4,iPhone4S,iPhone5,iPhone5s,iPhone6,iPhone6s,iPhone6plus,iPhone6splus,iPhone7,iPhone7plus', null);
INSERT INTO `sp_attribute` VALUES ('818', '基本参数-品牌', '1450', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('819', '功能参数-锁具功能', '1450', 'only', 'manual', '挂锁', null);
INSERT INTO `sp_attribute` VALUES ('820', '外观参数-色系', '1450', 'only', 'manual', '红色系', null);
INSERT INTO `sp_attribute` VALUES ('821', '基本参数-品牌', '1451', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('822', '功能参数-硬度', '1451', 'only', 'manual', '软', null);
INSERT INTO `sp_attribute` VALUES ('823', '外观参数-图案', '1451', 'only', 'manual', '卡通动漫', null);
INSERT INTO `sp_attribute` VALUES ('824', '颜色', '1451', 'many', 'list', 'F36702深棕黑,F36624紫色,F36702红边,F36702褐色,F36702暗橙,茶F36624水墨蓝,F36624米色,F36624红色,F36702粉色,F36624黑色,F36702暗紫边,F36702白色,F36624酒红色', null);
INSERT INTO `sp_attribute` VALUES ('825', '功能参数-内部结构', '1452', 'only', 'manual', '拉链暗袋,手机袋,证件袋', null);
INSERT INTO `sp_attribute` VALUES ('826', '基本参数-品牌', '1452', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('827', '外观参数-包袋大小', '1452', 'only', 'manual', '小（最长边20-30cm）', null);
INSERT INTO `sp_attribute` VALUES ('828', '颜色', '1452', 'many', 'list', '紫色,黑色,蓝色', null);
INSERT INTO `sp_attribute` VALUES ('829', '基本参数-品牌', '1453', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('830', '功能参数-硬度', '1453', 'only', 'manual', '软', null);
INSERT INTO `sp_attribute` VALUES ('831', '外观参数-色系', '1453', 'only', 'manual', '蓝色系,黑色系,粉色系,紫色系', null);
INSERT INTO `sp_attribute` VALUES ('832', '颜色', '1453', 'many', 'list', '粉色,黑色,紫色,黄色', null);
INSERT INTO `sp_attribute` VALUES ('833', '功能参数-内部结构', '1454', 'only', 'manual', '拉链暗袋,手机袋,证件袋', null);
INSERT INTO `sp_attribute` VALUES ('834', '基本参数-品牌', '1454', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('835', '外观参数-色系', '1454', 'only', 'manual', '红色系,黄色系,蓝色系,黑色系,棕色系,金色系,卡其色系', null);
INSERT INTO `sp_attribute` VALUES ('836', '颜色', '1454', 'many', 'list', '酒红,墨绿,灰色,黑色,天蓝,橘红,玫瑰粉,红色,深蓝色,橄榄绿,樱桃红', null);
INSERT INTO `sp_attribute` VALUES ('837', '主体-品牌', '1456', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('838', '规格-尺寸', '1456', 'only', 'manual', '100*90*110毫米', null);
INSERT INTO `sp_attribute` VALUES ('839', '其他-适用场景', '1456', 'only', 'manual', '婚庆,生日,情人节,圣诞节', null);
INSERT INTO `sp_attribute` VALUES ('840', '主体-品牌', '1457', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('841', '规格-重量', '1457', 'only', 'manual', '350千克', null);
INSERT INTO `sp_attribute` VALUES ('842', '其他-工艺', '1457', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('843', '主体-品牌', '1458', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('844', '规格-材质', '1458', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('845', '颜色', '1458', 'many', 'list', '原装日版2.4Plus三代白色,原装日版2.4Plus三代黑色,万宝路原味（浓）,万宝路薄荷味（浓）,百乐门原味,百乐门薄荷味,HEETS原味,HEETS薄荷味,万宝路薄荷味（淡）,万宝路蓝莓味,万宝路原味（淡）,原装日版2.4Plus三代钢铁侠版', null);
INSERT INTO `sp_attribute` VALUES ('846', '主体-品牌', '1459', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('847', '规格-产品尺寸', '1459', 'only', 'manual', '其他毫米', null);
INSERT INTO `sp_attribute` VALUES ('848', '基本参数-品牌', '145', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('849', '规格参数-声道', '145', 'only', 'manual', '5.1声道', null);
INSERT INTO `sp_attribute` VALUES ('850', '型号', '145', 'many', 'list', 'Companion50 C50(C5升级版),Companion 2 C2,Companion5 C5', null);
INSERT INTO `sp_attribute` VALUES ('851', '主体-品牌', '1460', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('852', '规格-尺寸', '1460', 'only', 'manual', '200*150毫米', null);
INSERT INTO `sp_attribute` VALUES ('853', '其他-适用场景', '1460', 'only', 'manual', '婚庆,生日,情人节,圣诞节,传统节庆,地方特色', null);
INSERT INTO `sp_attribute` VALUES ('854', '颜色', '1460', 'many', 'list', '粉色,蓝色', null);
INSERT INTO `sp_attribute` VALUES ('855', '主体-产地', '1462', 'only', 'manual', '中国浙江金华市', null);
INSERT INTO `sp_attribute` VALUES ('856', '规格-规格', '1462', 'only', 'manual', '军刀礼盒', null);
INSERT INTO `sp_attribute` VALUES ('857', '其他-材质', '1462', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('858', '颜色', '1462', 'many', 'list', '蓝色', null);
INSERT INTO `sp_attribute` VALUES ('859', '主体参数-品牌', '1465', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('860', '主要参数-商品名称', '146', 'only', 'manual', 'mini90', null);
INSERT INTO `sp_attribute` VALUES ('861', '功能参数-防抖功能', '146', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('862', '存储及输出参数-胶片尺寸', '146', 'only', 'manual', '其他毫米', null);
INSERT INTO `sp_attribute` VALUES ('863', '产品规格-适用相纸尺寸', '146', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('864', '主体-型号', '1470', 'only', 'manual', 'PX-160', null);
INSERT INTO `sp_attribute` VALUES ('865', '规格-材质', '1470', 'only', 'manual', 'PVC合成面板', null);
INSERT INTO `sp_attribute` VALUES ('866', '颜色', '1470', 'many', 'list', '香槟金色+原装木架+三踏板+标配,香槟金色单机+X架+单踏+套餐一,白色单机+X架+单踏+标配,白色单机+X架+单踏+套餐一,黑色单机+X架+单踏+标配,香槟金色+原装木架+单踏+套餐一,黑色+原装木架+三踏板+标配,白色+原装木架+单踏+套餐一,白色+原装木架+单踏+标配,白色+原装木架+三踏板+套餐一,黑色+原装木架+单踏+套餐一,香槟金色+原装木架+单踏+标配,黑色+原装木架+单踏+标配,白色+原装木架+三踏板+标配,香槟金色+X架+单踏+标配,黑色+原装木架+三踏板+套餐一,黑色单机+X架+单踏+套餐一,香槟金色+原装木架+三踏板+套餐一', null);
INSERT INTO `sp_attribute` VALUES ('867', '主体-品牌', '1471', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('868', '规格-材质', '1471', 'only', 'manual', '复合', null);
INSERT INTO `sp_attribute` VALUES ('869', '主体-品牌', '1472', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('870', '规格-材质', '1472', 'only', 'manual', '紫檀', null);
INSERT INTO `sp_attribute` VALUES ('871', '颜色', '1472', 'many', 'list', 'P26136,P26166,P26116,P26106,随机大纹蟒皮,随机小纹蟒皮', null);
INSERT INTO `sp_attribute` VALUES ('872', '主体-品牌', '1474', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('873', '规格-材质', '1474', 'only', 'manual', '桐木', null);
INSERT INTO `sp_attribute` VALUES ('874', '主体-品牌', '1475', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('875', '产品说明-材质', '1475', 'only', 'manual', '特氏古夷苏木', null);
INSERT INTO `sp_attribute` VALUES ('876', '规格-古筝琴弦', '1475', 'only', 'manual', '尼龙钢丝弦', null);
INSERT INTO `sp_attribute` VALUES ('877', '颜色', '1475', 'many', 'list', '原厂配置+套餐一,原厂配置+套餐二,原厂配置,原厂配置+套餐三', null);
INSERT INTO `sp_attribute` VALUES ('878', '主体-品牌', '1476', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('879', '规格-背侧板材质', '1476', 'only', 'manual', '沙 比利', null);
INSERT INTO `sp_attribute` VALUES ('880', '颜色', '1476', 'many', 'list', 'U-26A小吉他26寸,Totoro-U-24A尤克里里24寸,U-24A小吉他24寸', null);
INSERT INTO `sp_attribute` VALUES ('881', '主体-品牌', '1477', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('882', '规格-材质', '1477', 'only', 'manual', '金属', null);
INSERT INTO `sp_attribute` VALUES ('883', '主体-型号', '1478', 'only', 'manual', 'V005', null);
INSERT INTO `sp_attribute` VALUES ('884', '规格-外观尺寸', '1478', 'only', 'manual', '580毫米', null);
INSERT INTO `sp_attribute` VALUES ('885', '主体-品牌', '1479', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('886', '规格-材质', '1479', 'only', 'manual', '金属', null);
INSERT INTO `sp_attribute` VALUES ('887', '主体参数-品牌', '147', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('888', '屏幕显示-屏幕尺寸', '147', 'only', 'manual', '0英寸', null);
INSERT INTO `sp_attribute` VALUES ('889', '特性功能-是否防水', '147', 'only', 'manual', '防水', null);
INSERT INTO `sp_attribute` VALUES ('890', '摄像功能-摄像头', '147', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('891', '影音功能-视频播放', '147', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('892', '型号', '147', 'many', 'list', 'Oculus Rift CV1 现货,Oculus rift CV1+Touch 套装,Oculus rift Touch手柄', null);
INSERT INTO `sp_attribute` VALUES ('893', '主体-商品名称', '148', 'only', 'manual', '飞利浦(Philips) 旋转式三刀头电动剃须刀全身水洗 S5050【保税仓发货】', null);
INSERT INTO `sp_attribute` VALUES ('894', '刀头-刀头数量', '148', 'only', 'manual', '三刀头', null);
INSERT INTO `sp_attribute` VALUES ('895', '清洁-清洁方式', '148', 'only', 'manual', '全自动清洁', null);
INSERT INTO `sp_attribute` VALUES ('896', '电源-供电方式', '148', 'only', 'manual', '充电', null);
INSERT INTO `sp_attribute` VALUES ('897', '功能-鬓毛修剪器', '148', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('898', '规格参数-额定功率', '148', 'only', 'manual', '4瓦特', null);
INSERT INTO `sp_attribute` VALUES ('899', '型号', '148', 'many', 'list', 'AT600,AT610,S5050,S5070,S7320,S7370,S7510', null);
INSERT INTO `sp_attribute` VALUES ('900', '主体-商品名称', '149', 'only', 'manual', '戴森吸尘器', null);
INSERT INTO `sp_attribute` VALUES ('901', '功能参数-吸尘器功能', '149', 'only', 'manual', '地毯式,除螨,其它', null);
INSERT INTO `sp_attribute` VALUES ('902', '规格参数-充电时间', '149', 'only', 'manual', '5小时', null);
INSERT INTO `sp_attribute` VALUES ('903', '型号', '149', 'many', 'list', 'V8 Absolute 海外版6吸头 高配版,V8 animal 海外版5吸头 宠物版,V6 Animal 海外版4吸头 宠物版,V6 Total Clean 海外版5吸头,V6 Mattress 海外版4吸头,吸头4件装,V8 Total Clean海外版6吸头', null);
INSERT INTO `sp_attribute` VALUES ('904', '主体-商品名称', '14', 'only', 'manual', '康佳(KONKA) A55U', null);
INSERT INTO `sp_attribute` VALUES ('905', '显示-曲面', '14', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('906', '系统-智能电视', '14', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('907', '外观-产品颜色', '14', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('908', 'USB支持格式-USB支持视频格式', '14', 'only', 'manual', 'AVI,MPG,MKV,MOV,MP4,RM,RMVB,MPEG-1,4KH.265', null);
INSERT INTO `sp_attribute` VALUES ('909', '功耗-整机功率（W）', '14', 'only', 'manual', '180瓦特', null);
INSERT INTO `sp_attribute` VALUES ('910', '规格-含底座尺寸（宽*高*', '14', 'only', 'manual', '1242x241x763毫米', null);
INSERT INTO `sp_attribute` VALUES ('911', '网络-网络连接方式', '14', 'only', 'manual', '有线+无线', null);
INSERT INTO `sp_attribute` VALUES ('912', '端口-USB2.0端口', '14', 'only', 'manual', '1个', null);
INSERT INTO `sp_attribute` VALUES ('913', '音频-扬声器数量', '14', 'only', 'manual', '2个', null);
INSERT INTO `sp_attribute` VALUES ('914', '交互设备-无线键鼠', '14', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('915', '互联互通-多屏互动', '14', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('916', '尺寸', '14', 'many', 'list', '43英寸智能4K HDR,49英寸智能4K HDR,55英寸31核智能4K HDR,55英寸智能4K HDR,65英寸智能4K HDR', null);
INSERT INTO `sp_attribute` VALUES ('917', '主体参数-商品名称', '150', 'only', 'manual', '松下（Panasonic）智能电饭煲SR-ZE185 微电脑5L电饭煲', null);
INSERT INTO `sp_attribute` VALUES ('918', '功能-加热方式', '150', 'only', 'manual', '底盘加热', null);
INSERT INTO `sp_attribute` VALUES ('919', '材质-内胆材质', '150', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('920', '外观-颜色', '150', 'only', 'manual', '白色', null);
INSERT INTO `sp_attribute` VALUES ('921', '规格-容量', '150', 'only', 'manual', '5L', null);
INSERT INTO `sp_attribute` VALUES ('922', '电源参数-额定功率', '150', 'only', 'manual', '750瓦特', null);
INSERT INTO `sp_attribute` VALUES ('923', '容量', '150', 'many', 'list', 'SR-ZE105(3L),SR-ZE185(5L)', null);
INSERT INTO `sp_attribute` VALUES ('924', '主体-商品名称', '152', 'only', 'manual', '电吹风', null);
INSERT INTO `sp_attribute` VALUES ('925', '护发-护发功能', '152', 'only', 'manual', '负离子', null);
INSERT INTO `sp_attribute` VALUES ('926', '功率-功率', '152', 'only', 'manual', '1201W-1600W', null);
INSERT INTO `sp_attribute` VALUES ('927', '档位-产品档位', '152', 'only', 'manual', '3档', null);
INSERT INTO `sp_attribute` VALUES ('928', '功能参数-吹风机功能', '152', 'only', 'manual', '恒温设计,其他', null);
INSERT INTO `sp_attribute` VALUES ('929', '风嘴-风嘴样式', '152', 'only', 'manual', '集风嘴+散风嘴', null);
INSERT INTO `sp_attribute` VALUES ('930', '规格参数-电源线长度', '152', 'only', 'manual', '1.8米', null);
INSERT INTO `sp_attribute` VALUES ('931', '颜色', '152', 'many', 'list', '白色,紫红色,紫色', null);
INSERT INTO `sp_attribute` VALUES ('932', '主体参数-品牌', '153', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('933', '功能参数-咖啡机种类', '153', 'only', 'manual', '意式咖啡', null);
INSERT INTO `sp_attribute` VALUES ('934', '容量参数-咖啡容量', '153', 'only', 'manual', '5杯以下', null);
INSERT INTO `sp_attribute` VALUES ('935', '规格参数-产品尺寸(高*宽*深', '153', 'only', 'manual', '238*430*351毫米', null);
INSERT INTO `sp_attribute` VALUES ('936', 'ECAM', '153', 'many', 'list', 'ECAM 28.466.MB,ECAM 22.110.SB,ECAM21.117.SB,ECAM 23.420.SB,ECAM 22.360.S,ECAM 22.110.B,ECAM 28.466.M全金属', null);
INSERT INTO `sp_attribute` VALUES ('937', '主体-商品名称', '154', 'only', 'manual', '空气净化剂', null);
INSERT INTO `sp_attribute` VALUES ('938', '功能参数-空气净化器功能', '154', 'only', 'manual', '除苯,除氨,净化,除PM2.5,除烟尘,除甲醛', null);
INSERT INTO `sp_attribute` VALUES ('939', '规格参数-毛重', '154', 'only', 'manual', '0.4千克', null);
INSERT INTO `sp_attribute` VALUES ('940', '主体参数-个护健康类型', '155', 'only', 'manual', '电子美容仪', null);
INSERT INTO `sp_attribute` VALUES ('941', '功能参数-产品功能', '155', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('942', '适用范围-适用人群', '155', 'only', 'manual', '男士,女士', null);
INSERT INTO `sp_attribute` VALUES ('943', '电源-自动断电', '155', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('944', '规格参数-净重', '155', 'only', 'manual', '0.22千克', null);
INSERT INTO `sp_attribute` VALUES ('945', '型号', '155', 'many', 'list', '24K黄金棒,雅萌10T', null);
INSERT INTO `sp_attribute` VALUES ('946', '主体-商品名称', '156', 'only', 'manual', '博朗(BRAUN) 欧乐B DB4010 成人电动牙刷A 德国原装进口【保税仓发货】', null);
INSERT INTO `sp_attribute` VALUES ('947', '刷头-适用人群', '156', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('948', '电源-电源类型', '156', 'only', 'manual', '干电式', null);
INSERT INTO `sp_attribute` VALUES ('949', '功能-防水功能', '156', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('950', '规格参数-净重', '156', 'only', 'manual', '0.3千克', null);
INSERT INTO `sp_attribute` VALUES ('951', '型号', '156', 'many', 'list', 'Pro2500,儿童冰雪奇缘款,儿童星球大战款,儿童款,成人款', null);
INSERT INTO `sp_attribute` VALUES ('952', '基本参数-型号', '158', 'only', 'manual', 'F71723', null);
INSERT INTO `sp_attribute` VALUES ('953', '功能参数-有无夹层', '158', 'only', 'manual', '有夹层', null);
INSERT INTO `sp_attribute` VALUES ('954', '外观参数-色系', '158', 'only', 'manual', '黑色系,棕色系', null);
INSERT INTO `sp_attribute` VALUES ('955', '颜色', '158', 'many', 'list', '浅棕色,黑色,深棕色,沉静蓝,深棕色纯黑色背带', null);
INSERT INTO `sp_attribute` VALUES ('956', '基本参数-品牌', '159', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('957', '功能参数-内部结构', '159', 'only', 'manual', '拉链暗袋,手机袋,证件袋,夹层拉链袋', null);
INSERT INTO `sp_attribute` VALUES ('958', '外观参数-色系', '159', 'only', 'manual', '米色系', null);
INSERT INTO `sp_attribute` VALUES ('959', '颜色', '159', 'many', 'list', '牛仔蓝银色五金30F6SM9T3L,灰色銀色五金30F6SM9T3L,焦红色金色五金30F6GM9T3L,牡蛎色金色五金30F6GM9T3L,金色金色五金30H6MM9T3M,矢车菊蓝银色五金30F6SM9T3L,裸粉色金色五金30F6GM9T3L,栗子棕金色五金,亮红色银色五金30F6SM9T3L,经典黑銀色五金30F6SM9T3L,淡蓝色銀色五金30F6SM9T3L', null);
INSERT INTO `sp_attribute` VALUES ('960', '主体-商品名称', '15', 'only', 'manual', '三星电视UA65KUF30EJXXZ', null);
INSERT INTO `sp_attribute` VALUES ('961', '显示-曲面', '15', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('962', '系统-智能电视', '15', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('963', '功耗-整机功率（W）', '15', 'only', 'manual', '95瓦特', null);
INSERT INTO `sp_attribute` VALUES ('964', '网络-网络连接方式', '15', 'only', 'manual', '有线+无线', null);
INSERT INTO `sp_attribute` VALUES ('965', '交互设备-无线键鼠', '15', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('966', '版式', '15', 'many', 'list', '2017年新品 55吋 4K智能,2017年新品 55吋 4K智能 HDR,2017年新品 65吋 4K智能 HDR,40吋 4K智能 HDR,50吋 4K智能 HDR,55吋 4K智能 HDR,55吋 4K智能 热卖,65吋 4K智能 HDR', null);
INSERT INTO `sp_attribute` VALUES ('967', '主观参数-品牌', '161', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('968', '实质参数-袖长', '161', 'only', 'manual', '短袖', null);
INSERT INTO `sp_attribute` VALUES ('969', '细节参数-场合', '161', 'only', 'manual', '旅游,运动,日常,商务,休闲', null);
INSERT INTO `sp_attribute` VALUES ('970', '颜色', '161', 'many', 'list', '粉色,深红色,绿色,L,XS,M,S', null);
INSERT INTO `sp_attribute` VALUES ('971', '主观参数-品牌', '162', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('972', '实质参数-裤长', '162', 'only', 'manual', '长裤', null);
INSERT INTO `sp_attribute` VALUES ('973', '颜色', '162', 'many', 'list', '棕色,灰色,黑色,酒红色,肉色,蓝色,M-L,L-LL,S-M', null);
INSERT INTO `sp_attribute` VALUES ('974', '主体-品牌', '163', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('975', '规格-产品重量', '163', 'only', 'manual', '500克', null);
INSERT INTO `sp_attribute` VALUES ('976', '颜色', '163', 'many', 'list', 'GU6652-BLK2,GU6741BLK-35,GU6741GLDBN-1,GU6741GUN-3,GU6671-GUN3', null);
INSERT INTO `sp_attribute` VALUES ('977', '主观参数-品牌', '164', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('978', '实质参数-适用季节', '164', 'only', 'manual', '春季,秋季,冬季', null);
INSERT INTO `sp_attribute` VALUES ('979', '细节参数-鞋头款式', '164', 'only', 'manual', '圆头', null);
INSERT INTO `sp_attribute` VALUES ('980', '颜色', '164', 'many', 'list', '棕色15551,深褐色15550,11.5M,11M,10.5M,10M,9.5M,9M,8.5M,8M,7.5M,7M,6.5M', null);
INSERT INTO `sp_attribute` VALUES ('981', '主观参数-型号', '165', 'only', 'manual', 'UGG J&J', null);
INSERT INTO `sp_attribute` VALUES ('982', '实质参数-适用季节', '165', 'only', 'manual', '春季,秋季,冬季', null);
INSERT INTO `sp_attribute` VALUES ('983', '细节参数-鞋跟形状', '165', 'only', 'manual', '平跟', null);
INSERT INTO `sp_attribute` VALUES ('984', '颜色', '165', 'many', 'list', '棕色chocolate,栗色chestnut,35码,39码', null);
INSERT INTO `sp_attribute` VALUES ('985', '主体参数-品牌', '166', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('986', '规格参数-类别', '166', 'only', 'manual', '板鞋/休闲鞋', null);
INSERT INTO `sp_attribute` VALUES ('987', '颜色', '166', 'many', 'list', 'ADIDAS_BA8169,ADIDAS_BZ0190,36/220,36.5/225,37/230,38/235,38.5/240,39/245,40/250,40.5/255,41/260,42/265,42.5/270,43/275,44/280', null);
INSERT INTO `sp_attribute` VALUES ('988', '基本参数-品牌', '167', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('989', '功能参数-内部结构', '167', 'only', 'manual', '拉链暗袋,手机袋,证件袋', null);
INSERT INTO `sp_attribute` VALUES ('990', '外观参数-色系', '167', 'only', 'manual', '红色系,蓝色系,白色系', null);
INSERT INTO `sp_attribute` VALUES ('991', '颜色', '167', 'many', 'list', '红白蓝大号,红白蓝小号,白蓝大号,白蓝小号,黑红灰大号,黑红灰小号,红白大号,红白小号', null);
INSERT INTO `sp_attribute` VALUES ('992', '主体-品牌', '168', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('993', '规格-成色', '168', 'only', 'manual', '925银', null);
INSERT INTO `sp_attribute` VALUES ('994', '描述-风格', '168', 'only', 'manual', '甜美', null);
INSERT INTO `sp_attribute` VALUES ('995', '颜色', '168', 'many', 'list', '蓝色,绿色,白色,粉色', null);
INSERT INTO `sp_attribute` VALUES ('996', '主观参数-品牌', '169', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('997', '实质参数-适用季节', '169', 'only', 'manual', '春季,夏季,秋季,冬季', null);
INSERT INTO `sp_attribute` VALUES ('998', '颜色', '169', 'many', 'list', '黑色U4001,黑/白/灰U4001,白色U4001,S,M,L', null);
INSERT INTO `sp_attribute` VALUES ('999', '主体-商品名称', '16', 'only', 'manual', '飞利浦电视', null);
INSERT INTO `sp_attribute` VALUES ('1000', '显示-曲面', '16', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('1001', '系统-智能电视', '16', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('1002', '功耗-整机功率（W）', '16', 'only', 'manual', '55瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1003', '版式', '16', 'many', 'list', '新品爆款-50吋4K超高清,新品爆款-39吋智能高清,新品爆款-55吋4K超高清,新品爆款-65吋 4k超高清', null);
INSERT INTO `sp_attribute` VALUES ('1004', '主体-品牌', '170', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1005', '基本参数-笔芯颜色', '170', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('1006', '规格参数-包装数量', '170', 'only', 'manual', '1支', null);
INSERT INTO `sp_attribute` VALUES ('1007', '颜色', '170', 'many', 'list', '亮黑色,白色,德古拉红,黄色,磨砂黑,蓝色', null);
INSERT INTO `sp_attribute` VALUES ('1008', '主体参数-品牌', '171', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1009', '功能参数-功能', '171', 'only', 'manual', '防尘,防尾气,防花粉,其它', null);
INSERT INTO `sp_attribute` VALUES ('1010', '特性参数-适用人群', '171', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('1011', '规格参数-尺寸', '171', 'only', 'manual', '16.2x12.8厘米', null);
INSERT INTO `sp_attribute` VALUES ('1012', '颜色', '171', 'many', 'list', '灰色,白色', null);
INSERT INTO `sp_attribute` VALUES ('1013', '主体参数-品牌', '175', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1014', '规格参数-尺寸', '175', 'only', 'manual', '168*38毫米', null);
INSERT INTO `sp_attribute` VALUES ('1015', '主体参数-品牌', '177', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1016', '规格参数-香型', '177', 'only', 'manual', '有香味', null);
INSERT INTO `sp_attribute` VALUES ('1017', '特性参数-适用场景', '177', 'only', 'manual', '客厅,其他,厨房,地面,家具', null);
INSERT INTO `sp_attribute` VALUES ('1018', '主体参数-品牌', '179', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1019', '功能参数-香味', '179', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1020', '特性参数-产品尺寸', '179', 'only', 'manual', '大号(直径35mm、宽度55±2mm)', null);
INSERT INTO `sp_attribute` VALUES ('1021', '规格参数-包装', '179', 'only', 'manual', '单盒装', null);
INSERT INTO `sp_attribute` VALUES ('1022', '搭配', '179', 'many', 'list', '冈本001 3片,冈本豹纹12只,相模3片,相模5片', null);
INSERT INTO `sp_attribute` VALUES ('1023', '主体-商品名称', '17', 'only', 'manual', '索尼彩电KD-55X8000E', null);
INSERT INTO `sp_attribute` VALUES ('1024', '显示-曲面', '17', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('1025', '系统-智能电视', '17', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('1026', '外观-边框材质', '17', 'only', 'manual', '金属', null);
INSERT INTO `sp_attribute` VALUES ('1027', '功耗-整机功率（W）', '17', 'only', 'manual', '149瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1028', '版式', '17', 'many', 'list', '43英寸HDR智能,55英寸HDR智能,65英寸HDR智能,75英寸HDR智能', null);
INSERT INTO `sp_attribute` VALUES ('1029', '主体-品牌', '180', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1030', '功能参数-防水性能', '180', 'only', 'manual', '防水', null);
INSERT INTO `sp_attribute` VALUES ('1031', '特性参数-电源', '180', 'only', 'manual', 'USB接口供电', null);
INSERT INTO `sp_attribute` VALUES ('1032', '规格参数-产品尺寸', '180', 'only', 'manual', '170毫米', null);
INSERT INTO `sp_attribute` VALUES ('1033', '主体-品牌', '184', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1034', '外观-颜色', '184', 'only', 'manual', '灰色', null);
INSERT INTO `sp_attribute` VALUES ('1035', '系统-手机操作系统', '184', 'only', 'manual', 'IOS', null);
INSERT INTO `sp_attribute` VALUES ('1036', 'CPU-CPU核数', '184', 'only', 'manual', '以官网信息为准', null);
INSERT INTO `sp_attribute` VALUES ('1037', '网络-4G网络制式', '184', 'only', 'manual', '移动4G,联通4G,电信4G,全网通', null);
INSERT INTO `sp_attribute` VALUES ('1038', '存储-机身内存', '184', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1039', '屏幕-屏幕尺寸', '184', 'only', 'manual', '5.8英寸', null);
INSERT INTO `sp_attribute` VALUES ('1040', '拍照-前摄像头', '184', 'only', 'manual', '700万像素', null);
INSERT INTO `sp_attribute` VALUES ('1041', '电池-电池类型', '184', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('1042', '接口-蓝牙版本', '184', 'only', 'manual', '蓝牙5.0', null);
INSERT INTO `sp_attribute` VALUES ('1043', '手机特性-光线传感器', '184', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1044', '其他-选购热点', '184', 'only', 'manual', '屏幕大,拍照不错,反应快', null);
INSERT INTO `sp_attribute` VALUES ('1045', '颜色', '184', 'many', 'list', '深空灰,银色,256G,64G,裸机,裸机+电信无限流量,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1046', '主体-品牌', '186', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1047', '外观-颜色', '186', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('1048', '系统-手机操作系统', '186', 'only', 'manual', 'MIUI', null);
INSERT INTO `sp_attribute` VALUES ('1049', 'CPU-CPU核数', '186', 'only', 'manual', '八核', null);
INSERT INTO `sp_attribute` VALUES ('1050', '网络-4G网络制式', '186', 'only', 'manual', '移动4G,联通4G,电信4G', null);
INSERT INTO `sp_attribute` VALUES ('1051', '存储-机身内存', '186', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1052', '屏幕-屏幕尺寸', '186', 'only', 'manual', '5.5英寸', null);
INSERT INTO `sp_attribute` VALUES ('1053', '拍照-前摄像头', '186', 'only', 'manual', '1600万像素', null);
INSERT INTO `sp_attribute` VALUES ('1054', '电池-电池容量', '186', 'only', 'manual', '3500mAh', null);
INSERT INTO `sp_attribute` VALUES ('1055', '接口-蓝牙版本', '186', 'only', 'manual', '蓝牙5.0', null);
INSERT INTO `sp_attribute` VALUES ('1056', '手机特性-重力传感器', '186', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1057', '其他-运营商标识', '186', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1058', '颜色', '186', 'many', 'list', '亮蓝色,亮黑色,吴亦凡定制版,4GB  64GB,6GB  128GB,6GB  64GB,裸机,购机送1元800MB流量卡,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1059', '主体-品牌', '187', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1060', '外观-颜色', '187', 'only', 'manual', '蓝色', null);
INSERT INTO `sp_attribute` VALUES ('1061', '系统-手机操作系统', '187', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1062', 'CPU-CPU核数', '187', 'only', 'manual', '八核', null);
INSERT INTO `sp_attribute` VALUES ('1063', '网络-4G网络制式', '187', 'only', 'manual', '移动4G,联通4G,电信4G', null);
INSERT INTO `sp_attribute` VALUES ('1064', '存储-机身内存', '187', 'only', 'manual', '32GB', null);
INSERT INTO `sp_attribute` VALUES ('1065', '屏幕-屏幕尺寸', '187', 'only', 'manual', '5.65英寸', null);
INSERT INTO `sp_attribute` VALUES ('1066', '拍照-前摄像头', '187', 'only', 'manual', '1300万像素', null);
INSERT INTO `sp_attribute` VALUES ('1067', '电池-电池容量', '187', 'only', 'manual', '3000mAh', null);
INSERT INTO `sp_attribute` VALUES ('1068', '接口-耳机接口', '187', 'only', 'manual', '3.5mm', null);
INSERT INTO `sp_attribute` VALUES ('1069', '手机特性-重力传感器', '187', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1070', '其他-选购热点', '187', 'only', 'manual', '全面屏手机,后置双摄,前置双摄,玻璃机身', null);
INSERT INTO `sp_attribute` VALUES ('1071', 'CCC认证-CCC认证编号', '187', 'only', 'manual', '2017011606023756', null);
INSERT INTO `sp_attribute` VALUES ('1072', '版本', '187', 'many', 'list', '【预售】尊享版,【预售】标配版,【预售】高配版,尊享版,标配版,高配版,海鸥灰,珠光白,魅海蓝', null);
INSERT INTO `sp_attribute` VALUES ('1073', '主体-品牌', '188', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1074', '外观-颜色', '188', 'only', 'manual', '蓝色', null);
INSERT INTO `sp_attribute` VALUES ('1075', '系统-手机操作系统', '188', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1076', 'CPU-CPU核数', '188', 'only', 'manual', '八核', null);
INSERT INTO `sp_attribute` VALUES ('1077', '网络-4G网络制式', '188', 'only', 'manual', '移动4G,联通4G,电信4G', null);
INSERT INTO `sp_attribute` VALUES ('1078', '存储-机身内存', '188', 'only', 'manual', '128GB', null);
INSERT INTO `sp_attribute` VALUES ('1079', '屏幕-屏幕尺寸', '188', 'only', 'manual', '6.0英寸', null);
INSERT INTO `sp_attribute` VALUES ('1080', '拍照-前摄像头', '188', 'only', 'manual', '2000万像素', null);
INSERT INTO `sp_attribute` VALUES ('1081', '电池-电池容量', '188', 'only', 'manual', '3340mAh', null);
INSERT INTO `sp_attribute` VALUES ('1082', '接口-蓝牙版本', '188', 'only', 'manual', '蓝牙4.2', null);
INSERT INTO `sp_attribute` VALUES ('1083', '手机特性-重力传感器', '188', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1084', '其他-运营商标识', '188', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1085', 'CCC认证-CCC认证编号', '188', 'only', 'manual', '2017011606019009', null);
INSERT INTO `sp_attribute` VALUES ('1086', '颜色', '188', 'many', 'list', '曜石黑,浅艾蓝,银钻灰,4G+64G,6G+64G,张艺兴定制版', null);
INSERT INTO `sp_attribute` VALUES ('1087', '主体-品牌', '189', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1088', '外观-颜色', '189', 'only', 'manual', '金色', null);
INSERT INTO `sp_attribute` VALUES ('1089', '系统-手机操作系统', '189', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1090', 'CPU-CPU核数', '189', 'only', 'manual', '四核', null);
INSERT INTO `sp_attribute` VALUES ('1091', '网络-4G网络制式', '189', 'only', 'manual', '移动4G,联通4G,电信4G,全网通', null);
INSERT INTO `sp_attribute` VALUES ('1092', '存储-机身内存', '189', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1093', '屏幕-屏幕尺寸', '189', 'only', 'manual', '5.5英寸', null);
INSERT INTO `sp_attribute` VALUES ('1094', '拍照-前摄像头', '189', 'only', 'manual', '500万像素', null);
INSERT INTO `sp_attribute` VALUES ('1095', '电池-电池容量', '189', 'only', 'manual', '3600mAh', null);
INSERT INTO `sp_attribute` VALUES ('1096', '接口-蓝牙版本', '189', 'only', 'manual', '蓝牙4.2', null);
INSERT INTO `sp_attribute` VALUES ('1097', '手机特性-重力传感器', '189', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1098', '其他-运营商标识', '189', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1099', '颜色', '189', 'many', 'list', '曜岩黑,铂光金,S7,S7 edge 128G,S7 edge 64G,裸机,购机送1元800MB流量卡,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1100', '主体-商品名称', '18', 'only', 'manual', '先锋LED液晶电视机LED-32B760S', null);
INSERT INTO `sp_attribute` VALUES ('1101', '显示-曲面', '18', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('1102', '系统-智能电视', '18', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('1103', '外观-壁挂安装', '18', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1104', 'USB支持格式-USB支持视频格式', '18', 'only', 'manual', 'TS,MKV,MOV,RM,MPEG-1,H.264', null);
INSERT INTO `sp_attribute` VALUES ('1105', '功耗-整机功率（W）', '18', 'only', 'manual', '65瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1106', '规格-含底座重量（kg）', '18', 'only', 'manual', '4.8千克', null);
INSERT INTO `sp_attribute` VALUES ('1107', '网络-网络连接方式', '18', 'only', 'manual', '有线+无线', null);
INSERT INTO `sp_attribute` VALUES ('1108', '端口-HDMI1.4接口', '18', 'only', 'manual', '2个', null);
INSERT INTO `sp_attribute` VALUES ('1109', '音频-扬声器类型', '18', 'only', 'manual', '向下', null);
INSERT INTO `sp_attribute` VALUES ('1110', '交互设备-无线键鼠', '18', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1111', '互联互通-多屏互动', '18', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1112', '主体-品牌', '190', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1113', '外观-颜色', '190', 'only', 'manual', '银色', null);
INSERT INTO `sp_attribute` VALUES ('1114', '系统-手机操作系统', '190', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1115', 'CPU-CPU核数', '190', 'only', 'manual', '八核', null);
INSERT INTO `sp_attribute` VALUES ('1116', '网络-4G网络制式', '190', 'only', 'manual', '全网通', null);
INSERT INTO `sp_attribute` VALUES ('1117', '存储-机身内存', '190', 'only', 'manual', '32GB', null);
INSERT INTO `sp_attribute` VALUES ('1118', '屏幕-屏幕尺寸', '190', 'only', 'manual', '5.5英寸', null);
INSERT INTO `sp_attribute` VALUES ('1119', '拍照-前摄像头', '190', 'only', 'manual', '500万像素', null);
INSERT INTO `sp_attribute` VALUES ('1120', '电池-电池容量', '190', 'only', 'manual', '4000mAh', null);
INSERT INTO `sp_attribute` VALUES ('1121', '接口-蓝牙版本', '190', 'only', 'manual', '蓝牙4.1', null);
INSERT INTO `sp_attribute` VALUES ('1122', '手机特性-重力传感器', '190', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1123', '其他-运营商标识', '190', 'only', 'manual', '在内置应用', null);
INSERT INTO `sp_attribute` VALUES ('1124', '颜色', '190', 'many', 'list', '星空灰,月光银,香槟金,16G,16G礼盒版,32G,4G+ 全网通,移动全网通,裸机,购机送1元800MB流量卡,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1125', '主体-品牌', '191', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1126', '外观-颜色', '191', 'only', 'manual', '红色系', null);
INSERT INTO `sp_attribute` VALUES ('1127', '系统-手机操作系统', '191', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1128', 'CPU-CPU核数', '191', 'only', 'manual', '八核', null);
INSERT INTO `sp_attribute` VALUES ('1129', '网络-4G网络制式', '191', 'only', 'manual', '移动4G,联通4G,电信4G,双卡单4G,全网通', null);
INSERT INTO `sp_attribute` VALUES ('1130', '存储-机身内存', '191', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1131', '屏幕-屏幕尺寸', '191', 'only', 'manual', '6.01英寸', null);
INSERT INTO `sp_attribute` VALUES ('1132', '拍照-前摄像头', '191', 'only', 'manual', '2000万像素', null);
INSERT INTO `sp_attribute` VALUES ('1133', '电池-电池容量', '191', 'only', 'manual', '3205mAh', null);
INSERT INTO `sp_attribute` VALUES ('1134', '接口-蓝牙版本', '191', 'only', 'manual', '蓝牙4.2', null);
INSERT INTO `sp_attribute` VALUES ('1135', '手机特性-重力传感器', '191', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1136', '其他-运营商标识', '191', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1137', 'CCC认证-CCC认证编号', '191', 'only', 'manual', '2017011606006547', null);
INSERT INTO `sp_attribute` VALUES ('1138', '颜色', '191', 'many', 'list', '巴萨限量版,星幕新年红,红色,香槟色,黑色,R11 Plus （64G/6G）,R11s Plus（64G/6G）,R11s（ 128G/6G）,R11s（ 64G/4G）,定制版', null);
INSERT INTO `sp_attribute` VALUES ('1139', '主体-品牌', '192', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1140', '外观-颜色', '192', 'only', 'manual', '玫瑰金', null);
INSERT INTO `sp_attribute` VALUES ('1141', '系统-手机操作系统', '192', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1142', 'CPU-CPU核数', '192', 'only', 'manual', '八核', null);
INSERT INTO `sp_attribute` VALUES ('1143', '网络-4G网络制式', '192', 'only', 'manual', '移动4G,联通4G,电信4G', null);
INSERT INTO `sp_attribute` VALUES ('1144', '存储-机身内存', '192', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1145', '屏幕-屏幕尺寸', '192', 'only', 'manual', '6.01英寸', null);
INSERT INTO `sp_attribute` VALUES ('1146', '拍照-后摄像头', '192', 'only', 'manual', '2X1200万像素（2400万感光单元）万像素', null);
INSERT INTO `sp_attribute` VALUES ('1147', '电池-电池容量', '192', 'only', 'manual', '3245mAh', null);
INSERT INTO `sp_attribute` VALUES ('1148', '接口-蓝牙版本', '192', 'only', 'manual', '蓝牙5.0', null);
INSERT INTO `sp_attribute` VALUES ('1149', '手机特性-重力传感器', '192', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1150', '其他-运营商标识', '192', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1151', 'CCC认证-CCC认证编号', '192', 'only', 'manual', '2017011606992881', null);
INSERT INTO `sp_attribute` VALUES ('1152', '颜色', '192', 'many', 'list', '星耀红,玫瑰金,金色,黑色,X20plus,旗舰版,标配', null);
INSERT INTO `sp_attribute` VALUES ('1153', '主体-品牌', '193', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1154', '外观-颜色', '193', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('1155', '系统-手机操作系统', '193', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1156', 'CPU-CPU核数', '193', 'only', 'manual', '八核', null);
INSERT INTO `sp_attribute` VALUES ('1157', '网络-4G网络制式', '193', 'only', 'manual', '移动4G,联通4G,电信4G', null);
INSERT INTO `sp_attribute` VALUES ('1158', '存储-机身内存', '193', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1159', '屏幕-屏幕尺寸', '193', 'only', 'manual', '5.73英寸', null);
INSERT INTO `sp_attribute` VALUES ('1160', '拍照-前摄像头', '193', 'only', 'manual', '1000万像素', null);
INSERT INTO `sp_attribute` VALUES ('1161', '电池-电池容量', '193', 'only', 'manual', '3100mAh', null);
INSERT INTO `sp_attribute` VALUES ('1162', '接口-蓝牙版本', '193', 'only', 'manual', '蓝牙4.1', null);
INSERT INTO `sp_attribute` VALUES ('1163', '手机特性-重力传感器', '193', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1164', '其他-运营商标识', '193', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1165', '购买方式', '193', 'many', 'list', '裸机,裸机+电信无限流量,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1166', '主体-品牌', '194', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1167', '外观-外形尺寸', '194', 'only', 'manual', '155.9*71.0*9.3毫米', null);
INSERT INTO `sp_attribute` VALUES ('1168', '系统-手机操作系统', '194', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1169', 'CPU-CPU核数', '194', 'only', 'manual', '以官网信息为准', null);
INSERT INTO `sp_attribute` VALUES ('1170', '网络-4G网络制式', '194', 'only', 'manual', '全网通', null);
INSERT INTO `sp_attribute` VALUES ('1171', '存储-机身内存', '194', 'only', 'manual', '128GB', null);
INSERT INTO `sp_attribute` VALUES ('1172', '屏幕-屏幕尺寸', '194', 'only', 'manual', '5.2英寸', null);
INSERT INTO `sp_attribute` VALUES ('1173', '拍照-前摄像头', '194', 'only', 'manual', '1200万像素', null);
INSERT INTO `sp_attribute` VALUES ('1174', '电池-电池容量', '194', 'only', 'manual', '3100mAh', null);
INSERT INTO `sp_attribute` VALUES ('1175', '接口-蓝牙版本', '194', 'only', 'manual', '蓝牙4.1', null);
INSERT INTO `sp_attribute` VALUES ('1176', '手机特性-重力传感器', '194', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1177', '其他-选购热点', '194', 'only', 'manual', '女性手机,快速充电,拍照手机,前置双摄', null);
INSERT INTO `sp_attribute` VALUES ('1178', 'CCC认证-CCC认证编号', '194', 'only', 'manual', '2017011606998692', null);
INSERT INTO `sp_attribute` VALUES ('1179', '主体-品牌', '195', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1180', '外观-颜色', '195', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('1181', '系统-手机操作系统', '195', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1182', 'CPU-CPU核数', '195', 'only', 'manual', '八核', null);
INSERT INTO `sp_attribute` VALUES ('1183', '网络-4G网络制式', '195', 'only', 'manual', '移动4G,联通4G,电信4G,全网通', null);
INSERT INTO `sp_attribute` VALUES ('1184', '存储-机身内存', '195', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1185', '屏幕-屏幕尺寸', '195', 'only', 'manual', '5.2英寸', null);
INSERT INTO `sp_attribute` VALUES ('1186', '拍照-前摄像头', '195', 'only', 'manual', '500万像素', null);
INSERT INTO `sp_attribute` VALUES ('1187', '电池-电池容量', '195', 'only', 'manual', '3000mAh', null);
INSERT INTO `sp_attribute` VALUES ('1188', '接口-蓝牙版本', '195', 'only', 'manual', '蓝牙5.0', null);
INSERT INTO `sp_attribute` VALUES ('1189', '手机特性-重力传感器', '195', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1190', '其他-运营商标识', '195', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1191', 'CCC认证-CCC认证编号', '195', 'only', 'manual', '2017011606998636', null);
INSERT INTO `sp_attribute` VALUES ('1192', '颜色', '195', 'many', 'list', '白色,黑色,裸机,裸机+电信无限流量,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1193', '主体-品牌', '196', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1194', '外观-颜色', '196', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('1195', '系统-手机操作系统', '196', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1196', 'CPU-CPU核数', '196', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1197', '网络-4G网络制式', '196', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1198', '存储-机身内存', '196', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1199', '屏幕-屏幕尺寸', '196', 'only', 'manual', '1.77英寸', null);
INSERT INTO `sp_attribute` VALUES ('1200', '拍照-前摄像头', '196', 'only', 'manual', '0万像素', null);
INSERT INTO `sp_attribute` VALUES ('1201', '电池-电池类型', '196', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('1202', '接口-蓝牙版本', '196', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1203', '手机特性-重力传感器', '196', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1204', '其他-运营商标识', '196', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1205', '颜色', '196', 'many', 'list', '烈焰红,石墨黑', null);
INSERT INTO `sp_attribute` VALUES ('1206', '主体-品牌', '197', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1207', '外观-颜色', '197', 'only', 'manual', '金色', null);
INSERT INTO `sp_attribute` VALUES ('1208', '系统-手机操作系统', '197', 'only', 'manual', 'IOS', null);
INSERT INTO `sp_attribute` VALUES ('1209', 'CPU-CPU核数', '197', 'only', 'manual', '以官网信息为准', null);
INSERT INTO `sp_attribute` VALUES ('1210', '网络-4G网络制式', '197', 'only', 'manual', '移动4G,联通4G,电信4G,全网通', null);
INSERT INTO `sp_attribute` VALUES ('1211', '存储-机身内存', '197', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1212', '屏幕-屏幕尺寸', '197', 'only', 'manual', '5.5英寸', null);
INSERT INTO `sp_attribute` VALUES ('1213', '拍照-前摄像头', '197', 'only', 'manual', '700万像素', null);
INSERT INTO `sp_attribute` VALUES ('1214', '电池-电池类型', '197', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('1215', '接口-蓝牙版本', '197', 'only', 'manual', '蓝牙5.0', null);
INSERT INTO `sp_attribute` VALUES ('1216', '手机特性-光线传感器', '197', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1217', '其他-选购热点', '197', 'only', 'manual', '安全性好,音质不错,反应快,指纹识别', null);
INSERT INTO `sp_attribute` VALUES ('1218', '颜色', '197', 'many', 'list', '深空灰,金色,银色,256G,64G,裸机,购机送1元800MB流量卡,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1219', '主体-品牌', '198', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1220', '外观-颜色', '198', 'only', 'manual', '金色', null);
INSERT INTO `sp_attribute` VALUES ('1221', '系统-手机操作系统', '198', 'only', 'manual', 'IOS', null);
INSERT INTO `sp_attribute` VALUES ('1222', 'CPU-CPU核数', '198', 'only', 'manual', '以官网信息为准', null);
INSERT INTO `sp_attribute` VALUES ('1223', '网络-4G网络制式', '198', 'only', 'manual', '移动4G,联通4G,电信4G,全网通', null);
INSERT INTO `sp_attribute` VALUES ('1224', '存储-机身内存', '198', 'only', 'manual', '32GB', null);
INSERT INTO `sp_attribute` VALUES ('1225', '屏幕-屏幕尺寸', '198', 'only', 'manual', '4.7英寸', null);
INSERT INTO `sp_attribute` VALUES ('1226', '拍照-前摄像头', '198', 'only', 'manual', '120万像素', null);
INSERT INTO `sp_attribute` VALUES ('1227', '电池-电池类型', '198', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1228', '接口-蓝牙版本', '198', 'only', 'manual', '蓝牙4.0', null);
INSERT INTO `sp_attribute` VALUES ('1229', '手机特性-重力传感器', '198', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1230', '其他-运营商标识', '198', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1231', 'CCC认证-CCC认证编号', '198', 'only', 'manual', '2014011606717032', null);
INSERT INTO `sp_attribute` VALUES ('1232', '购买方式', '198', 'many', 'list', '裸机,购机送1元800MB流量卡,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1233', '主体-品牌', '19', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1234', '音响-音箱连接', '19', 'only', 'manual', '无线', null);
INSERT INTO `sp_attribute` VALUES ('1235', '接口-麦克风', '19', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1236', '特性-麦克风支持', '19', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1237', '规格-总功率', '19', 'only', 'manual', '100瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1238', '其他-主机尺寸', '19', 'only', 'manual', '1230 *57* 78毫米', null);
INSERT INTO `sp_attribute` VALUES ('1239', '主体-品牌', '202', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1240', '外观-颜色', '202', 'only', 'manual', '银色', null);
INSERT INTO `sp_attribute` VALUES ('1241', '系统-手机操作系统', '202', 'only', 'manual', 'IOS', null);
INSERT INTO `sp_attribute` VALUES ('1242', 'CPU-CPU核数', '202', 'only', 'manual', '以官网信息为准', null);
INSERT INTO `sp_attribute` VALUES ('1243', '网络-4G网络制式', '202', 'only', 'manual', '移动4G,联通4G,全网通', null);
INSERT INTO `sp_attribute` VALUES ('1244', '存储-机身内存', '202', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1245', '屏幕-屏幕尺寸', '202', 'only', 'manual', '5.8英寸', null);
INSERT INTO `sp_attribute` VALUES ('1246', '拍照-前摄像头', '202', 'only', 'manual', '700万像素', null);
INSERT INTO `sp_attribute` VALUES ('1247', '电池-电池类型', '202', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('1248', '接口-蓝牙版本', '202', 'only', 'manual', '蓝牙5.0', null);
INSERT INTO `sp_attribute` VALUES ('1249', '手机特性-重力传感器', '202', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1250', '其他-运营商标识', '202', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1251', 'CCC认证-CCC认证编号', '202', 'only', 'manual', '2017011606002397', null);
INSERT INTO `sp_attribute` VALUES ('1252', '颜色', '202', 'many', 'list', '银色,深空灰,64GB,256GB', null);
INSERT INTO `sp_attribute` VALUES ('1253', '主体-品牌', '203', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1254', '外观-颜色', '203', 'only', 'manual', '银色', null);
INSERT INTO `sp_attribute` VALUES ('1255', '系统-手机操作系统', '203', 'only', 'manual', 'IOS', null);
INSERT INTO `sp_attribute` VALUES ('1256', 'CPU-CPU核数', '203', 'only', 'manual', '以官网信息为准', null);
INSERT INTO `sp_attribute` VALUES ('1257', '网络-4G网络制式', '203', 'only', 'manual', '移动4G,联通4G,电信4G,全网通', null);
INSERT INTO `sp_attribute` VALUES ('1258', '存储-机身内存', '203', 'only', 'manual', '64GB', null);
INSERT INTO `sp_attribute` VALUES ('1259', '屏幕-屏幕尺寸', '203', 'only', 'manual', '5.5英寸', null);
INSERT INTO `sp_attribute` VALUES ('1260', '拍照-前摄像头', '203', 'only', 'manual', '700万像素', null);
INSERT INTO `sp_attribute` VALUES ('1261', '电池-电池类型', '203', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('1262', '接口-蓝牙版本', '203', 'only', 'manual', '蓝牙5.0', null);
INSERT INTO `sp_attribute` VALUES ('1263', '手机特性-光线传感器', '203', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1264', '其他-选购热点', '203', 'only', 'manual', '安全性好,音质不错,反应快,指纹识别', null);
INSERT INTO `sp_attribute` VALUES ('1265', '颜色', '203', 'many', 'list', '深空灰,金色,银色,256G,64G,裸机,购机送1元800MB流量卡,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1266', '主体-品牌', '205', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1267', '外观-颜色', '205', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('1268', '系统-手机操作系统', '205', 'only', 'manual', 'Android', null);
INSERT INTO `sp_attribute` VALUES ('1269', 'CPU-CPU核数', '205', 'only', 'manual', '八核', null);
INSERT INTO `sp_attribute` VALUES ('1270', '网络-4G网络制式', '205', 'only', 'manual', '全网通', null);
INSERT INTO `sp_attribute` VALUES ('1271', '存储-机身内存', '205', 'only', 'manual', '32GB', null);
INSERT INTO `sp_attribute` VALUES ('1272', '屏幕-屏幕尺寸', '205', 'only', 'manual', '5.2英寸', null);
INSERT INTO `sp_attribute` VALUES ('1273', '拍照-前摄像头', '205', 'only', 'manual', '800万像素', null);
INSERT INTO `sp_attribute` VALUES ('1274', '电池-电池容量', '205', 'only', 'manual', '3000mAh', null);
INSERT INTO `sp_attribute` VALUES ('1275', '接口-蓝牙版本', '205', 'only', 'manual', '蓝牙4.1', null);
INSERT INTO `sp_attribute` VALUES ('1276', '手机特性-重力传感器', '205', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1277', '其他-选购热点', '205', 'only', 'manual', '金属机身,国货精品,外观漂亮', null);
INSERT INTO `sp_attribute` VALUES ('1278', '颜色', '205', 'many', 'list', '幻夜黑,极光蓝,铂光金,魅焰红,标配版（3+32G）,高配版（4+32G）,裸机,裸机+电信无限流量,1元800MB版,无限流量版', null);
INSERT INTO `sp_attribute` VALUES ('1279', '基本参数-品牌', '209', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1280', '特性参数-电池容量', '209', 'only', 'manual', '10000mAh', null);
INSERT INTO `sp_attribute` VALUES ('1281', '规格参数-重量', '209', 'only', 'manual', '228克', null);
INSERT INTO `sp_attribute` VALUES ('1282', '特性-USB接口', '209', 'only', 'manual', '1个', null);
INSERT INTO `sp_attribute` VALUES ('1283', '颜色', '209', 'many', 'list', '白色,银色,锖色,高配版灰色,高配版金色,10000毫安,2万新品', null);
INSERT INTO `sp_attribute` VALUES ('1284', '主体-品牌', '20', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1285', '功能-频率响应', '20', 'only', 'manual', '0', null);
INSERT INTO `sp_attribute` VALUES ('1286', '接口-USB接口数量', '20', 'only', 'manual', '1个', null);
INSERT INTO `sp_attribute` VALUES ('1287', '规格-音箱重量', '20', 'only', 'manual', '1千克', null);
INSERT INTO `sp_attribute` VALUES ('1288', '其他-使用场景', '20', 'only', 'manual', '卧室', null);
INSERT INTO `sp_attribute` VALUES ('1289', '基本参数-品牌', '213', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1290', '规格参数-输出电压/电流', '213', 'only', 'manual', '5', null);
INSERT INTO `sp_attribute` VALUES ('1291', '基本参数-品牌', '214', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1292', '规格参数-产品尺寸', '214', 'only', 'manual', '146.2×70×0.3', null);
INSERT INTO `sp_attribute` VALUES ('1293', '尺码', '214', 'many', 'list', '4.7寸-苹果8/7全屏白,4.7寸-苹果8/7全屏黑,5.5寸-8Plus/7Plus全屏白,5.5寸-8Plus/7Plus全屏黑,iPhone8/7/6/4.7钢化膜,iPhone8Plus/7Plus/6Plus5.5钢化膜', null);
INSERT INTO `sp_attribute` VALUES ('1294', '基本参数-品牌', '215', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1295', '规格参数-线长', '215', 'only', 'manual', '1米', null);
INSERT INTO `sp_attribute` VALUES ('1296', '款式', '215', 'many', 'list', '安卓,苹果,Type-C,合金版-安卓,合金版-苹果,合金版-Type-C,合金版-3合1,伸缩版-安卓,伸缩版-苹果,伸缩版-Type-C,收纳款-3合1,钥匙扣款-3合1,白色(1米),白色(2米),白色(3米),金色(1米),金色(2米),银色(1米),银色(2米),黑色(1米),银色', null);
INSERT INTO `sp_attribute` VALUES ('1297', '基本参数-品牌', '216', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1298', '特性参数-容量', '216', 'only', 'manual', '32GB', null);
INSERT INTO `sp_attribute` VALUES ('1299', '型号', '216', 'many', 'list', '128G内存卡 100MB/s 升级版+,256G内存卡 100MB/s 升级版+,32G内存卡 48MB/s,32G内存卡 80MB/s 升级版+,32G内存卡 95MB/s 升级版,32G内存卡 95MB/s 升级版+,64G内存卡 100MB/s 升级版,64G内存卡 100MB/s 升级版+,64G内存卡 80MB/s 升级版+', null);
INSERT INTO `sp_attribute` VALUES ('1300', '基本参数-品牌', '217', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1301', '规格参数-重量', '217', 'only', 'manual', '5克', null);
INSERT INTO `sp_attribute` VALUES ('1302', '颜色', '217', 'many', 'list', '苹果7【4.7寸】黑色,苹果7【4.7寸】红色,苹果7【4.7寸】蓝色,苹果7【4.7寸】土豪金,苹果7【4.7寸】玫瑰金,苹果7Plus【5.5寸】黑色,苹果7Plus【5.5寸】红色,苹果7Plus【5.5寸】蓝色,苹果7Plus【5.5寸】玫瑰金,苹果7Plus【5.5寸】土豪金,苹果6/6s【4.7寸】黑色,苹果6/6s【4.7寸】红色,苹果6/6s【4.7寸】蓝色,苹果6/6s【4.7寸】土豪金,苹果6/6s【4.7寸】玫瑰金,苹果6Plus【5.5寸】黑色,苹果6Plus【5.5寸】红色,苹果6Plus【5.5寸】蓝色,苹果6Plus【5.5寸】土豪金,苹果6Plus【5.5寸】玫瑰金,苹果8【4.7寸】黑色,苹果8【4.7寸】红色,苹果8【4.7寸】蓝色,苹果8【4.7寸】土豪金,苹果8【4.7寸】玫瑰金,苹果8Plus【5.5寸】黑色,苹果8Plus【5.5寸】红色,苹果8Plus【5.5寸】蓝色,苹果8Plus【5.5寸】土豪金,苹果8Plus【5.5寸】玫瑰金', null);
INSERT INTO `sp_attribute` VALUES ('1303', '基本参数-产品类型', '218', 'only', 'manual', '蓝牙自拍杆', null);
INSERT INTO `sp_attribute` VALUES ('1304', '规格', '218', 'many', 'list', '线控自拍杆,蓝牙自拍杆,黑色,蓝色,玫红', null);
INSERT INTO `sp_attribute` VALUES ('1305', '基本参数-品牌', '219', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1306', '主体-品牌', '21', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1307', '基本参数-视频解码', '21', 'only', 'manual', 'H.265', null);
INSERT INTO `sp_attribute` VALUES ('1308', '规格参数-其他特性', '21', 'only', 'manual', '软件升级,安卓播放器', null);
INSERT INTO `sp_attribute` VALUES ('1309', '接口参数-其他接口', '21', 'only', 'manual', 'USB 2.0；网络接口；无线WIFI', null);
INSERT INTO `sp_attribute` VALUES ('1310', '版式', '21', 'many', 'list', '4K超高清迷你魔盒（4GB版）,4K超高清迷你魔盒（8GB版）,金属质感 看球追剧必选', null);
INSERT INTO `sp_attribute` VALUES ('1311', '基本参数-品牌', '220', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1312', '规格参数-USB接口类型', '220', 'only', 'manual', 'USB3.0', null);
INSERT INTO `sp_attribute` VALUES ('1313', '型号', '220', 'many', 'list', '128G U360苹果手机U盘 金色,16G U286安卓手机U盘 蓝色,32G U286安卓手机U盘 蓝色,32G U360苹果手机U盘 金色,32G U368苹果U盘银色,64G U360苹果手机U盘 金色,64G U366苹果手机U盘 银色,忆捷32GB金属U盘,忆捷64GB 苹果U盘', null);
INSERT INTO `sp_attribute` VALUES ('1314', '主体-品牌', '225', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1315', '外观-颜色', '225', 'only', 'manual', '金色', null);
INSERT INTO `sp_attribute` VALUES ('1316', '系统-手机操作系统', '225', 'only', 'manual', 'IOS', null);
INSERT INTO `sp_attribute` VALUES ('1317', 'CPU-CPU核数', '225', 'only', 'manual', '四核', null);
INSERT INTO `sp_attribute` VALUES ('1318', '网络-4G网络制式', '225', 'only', 'manual', '全网通', null);
INSERT INTO `sp_attribute` VALUES ('1319', '存储-机身内存', '225', 'only', 'manual', '128GB', null);
INSERT INTO `sp_attribute` VALUES ('1320', '屏幕-屏幕尺寸', '225', 'only', 'manual', '5.5英寸', null);
INSERT INTO `sp_attribute` VALUES ('1321', '拍照-前摄像头', '225', 'only', 'manual', '700万像素', null);
INSERT INTO `sp_attribute` VALUES ('1322', '电池-电池类型', '225', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1323', '接口-蓝牙版本', '225', 'only', 'manual', '蓝牙4.2', null);
INSERT INTO `sp_attribute` VALUES ('1324', '手机特性-重力传感器', '225', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1325', '其他-运营商标识', '225', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1326', '颜色', '225', 'many', 'list', '亮黑色,玫瑰金色,红色,金色,黑色,全网通128G,全网通32G', null);
INSERT INTO `sp_attribute` VALUES ('1327', '基本参数-品牌', '22', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1328', '技术参数-匹数', '22', 'only', 'manual', '1.5匹', null);
INSERT INTO `sp_attribute` VALUES ('1329', '能效参数-变频/定频', '22', 'only', 'manual', '定频', null);
INSERT INTO `sp_attribute` VALUES ('1330', '适用面积-制冷面积', '22', 'only', 'manual', '15-23平方米', null);
INSERT INTO `sp_attribute` VALUES ('1331', '分贝参数-室内噪音', '22', 'only', 'manual', '24-41分贝', null);
INSERT INTO `sp_attribute` VALUES ('1332', '规格参数-电源', '22', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1333', '特色功能-自动清洁', '22', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1334', '其他参数-商品特性', '22', 'only', 'manual', '静音,准确控温,独立除湿,智能操控,电辅加热,外观轻薄', null);
INSERT INTO `sp_attribute` VALUES ('1335', '匹数颜色', '22', 'many', 'list', '1.5匹定频挂机,大1匹定频挂机', null);
INSERT INTO `sp_attribute` VALUES ('1336', '基本参数-品牌', '230', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1337', '屏幕参数-显示屏类型', '230', 'only', 'manual', '液晶屏,触摸屏,翻转屏,高清屏', null);
INSERT INTO `sp_attribute` VALUES ('1338', '镜头参数-镜头类型', '230', 'only', 'manual', '标准变焦', null);
INSERT INTO `sp_attribute` VALUES ('1339', '曝光参数-曝光模式', '230', 'only', 'manual', '程序自动曝光(P)，光圈优先(A)，快门优先(S)，手动曝光(M)', null);
INSERT INTO `sp_attribute` VALUES ('1340', '性能参数-快门类型', '230', 'only', 'manual', '电子控制焦平面快门', null);
INSERT INTO `sp_attribute` VALUES ('1341', '视频参数-视频格式', '230', 'only', 'manual', 'MP4', null);
INSERT INTO `sp_attribute` VALUES ('1342', '闪光参数-有效闪光范围', '230', 'only', 'manual', '约17mm镜头视角', null);
INSERT INTO `sp_attribute` VALUES ('1343', '存储参数-存储介质', '230', 'only', 'manual', 'SD卡,SDHC卡,SDXC卡', null);
INSERT INTO `sp_attribute` VALUES ('1344', '电源参数-电池型号', '230', 'only', 'manual', 'LP-E17', null);
INSERT INTO `sp_attribute` VALUES ('1345', '外观参数-产品尺寸', '230', 'only', 'manual', '约131.9×100.9×77.8毫米毫米', null);
INSERT INTO `sp_attribute` VALUES ('1346', '规格', '230', 'many', 'list', '16-300腾龙镜头,17-40套机,18-135+50/1.8双镜头套机,18-135+75-300双镜头套机,18-135套机,18-200腾龙镜头,18-270腾龙镜头,18-55+50/1.8双镜头套机,18-55+75-300双镜头套机,18-55套机,24-105套机,50/1.8套机,55-250套机,75-300套机,单机身', null);
INSERT INTO `sp_attribute` VALUES ('1347', '基本参数-品牌', '231', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1348', '屏幕参数-显示屏尺寸', '231', 'only', 'manual', '3英寸', null);
INSERT INTO `sp_attribute` VALUES ('1349', '镜头参数-镜头类型', '231', 'only', 'manual', 'APS-C画幅标准变焦镜头', null);
INSERT INTO `sp_attribute` VALUES ('1350', '曝光控制-曝光模式', '231', 'only', 'manual', '程序自动曝光(全自动、闪光灯禁用、创意自动、人像、风光、微距、运动、夜景人像、程序)，快门优先自动曝光，光圈优先自动曝光，手动曝光，B门曝光', null);
INSERT INTO `sp_attribute` VALUES ('1351', '性能参数-快门类型', '231', 'only', 'manual', '电子控制、纵向式焦平快门', null);
INSERT INTO `sp_attribute` VALUES ('1352', '视频参数-视频格式', '231', 'only', 'manual', 'AVCHD,MP4', null);
INSERT INTO `sp_attribute` VALUES ('1353', '闪光灯参数-闪光灯类型', '231', 'only', 'manual', '内置闪光灯', null);
INSERT INTO `sp_attribute` VALUES ('1354', '存储及连接参数-存储介质', '231', 'only', 'manual', 'SD卡,SDXC卡,MS记忆棒', null);
INSERT INTO `sp_attribute` VALUES ('1355', '附件及电源参数-电池型号', '231', 'only', 'manual', 'NP-FW50', null);
INSERT INTO `sp_attribute` VALUES ('1356', '外观参数-产品尺寸', '231', 'only', 'manual', '120*66.9*45.1毫米', null);
INSERT INTO `sp_attribute` VALUES ('1357', '颜色', '231', 'many', 'list', '灰色,白色,黑色,5100L加包卡电池套装,6000L/55210双镜头套装,6000L包卡套机,6000L标准套机,6300L/18105苏宁特供套装,6300L标准套机,6500L/18105苏宁特供套装,6500单机身,7K标准套机,7M2/24240苏宁特供套装,7M2K标准套机,7RM2/2470苏宁特供套装,7RM2单机身', null);
INSERT INTO `sp_attribute` VALUES ('1358', '主体参数-品牌', '232', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1359', '屏幕参数-显示屏类型', '232', 'only', 'manual', '液晶屏', null);
INSERT INTO `sp_attribute` VALUES ('1360', '镜头参数-镜头类型', '232', 'only', 'manual', '伸缩式', null);
INSERT INTO `sp_attribute` VALUES ('1361', '性能参数-防抖功能', '232', 'only', 'manual', '光学防抖', null);
INSERT INTO `sp_attribute` VALUES ('1362', '存储与连接参数-机身内存', '232', 'only', 'manual', '20MB', null);
INSERT INTO `sp_attribute` VALUES ('1363', '附件及电源参数-电池类型', '232', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('1364', '外观参数-产品尺寸', '232', 'only', 'manual', '99.5x60.0x27.4毫米', null);
INSERT INTO `sp_attribute` VALUES ('1365', '特性-WIFI功能', '232', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1366', '颜色', '232', 'many', 'list', '白色,金色,黑色', null);
INSERT INTO `sp_attribute` VALUES ('1367', '主要参数-品牌', '233', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1368', '显示参数-显示屏尺寸', '233', 'only', 'manual', '3英寸', null);
INSERT INTO `sp_attribute` VALUES ('1369', '功能参数-显示屏像素', '233', 'only', 'manual', '46万像素', null);
INSERT INTO `sp_attribute` VALUES ('1370', '颜色', '233', 'many', 'list', '棕色,白色,红色', null);
INSERT INTO `sp_attribute` VALUES ('1371', '基本参数-品牌', '235', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1372', '光学参数-焦距范围', '235', 'only', 'manual', '24-70mm毫米', null);
INSERT INTO `sp_attribute` VALUES ('1373', '规格参数-滤镜口径', '235', 'only', 'manual', '82mm', null);
INSERT INTO `sp_attribute` VALUES ('1374', '版式', '235', 'many', 'list', '15-85mm f/3.5-5.6,17-55mm f/2.8,18-135mm f/3.5-5.6,24-70mm f/2.8L,24-70mm f/4L,24-105mm f/4L,24-105mm f/3.5-5.6', null);
INSERT INTO `sp_attribute` VALUES ('1375', '主要参数-商品名称', '236', 'only', 'manual', '富士mini7s粉色相机路人版 美颜自拍神器LOMO胶片相机礼物 官方正品', null);
INSERT INTO `sp_attribute` VALUES ('1376', '功能参数-防抖功能', '236', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1377', '产品规格-适用相纸尺寸', '236', 'only', 'manual', '54*86mm（小）', null);
INSERT INTO `sp_attribute` VALUES ('1378', '存储及输出参数-胶片尺寸', '236', 'only', 'manual', '54*86毫米', null);
INSERT INTO `sp_attribute` VALUES ('1379', '基本参数-品牌', '237', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1380', '规格参数-存储介质', '237', 'only', 'manual', 'SD卡', null);
INSERT INTO `sp_attribute` VALUES ('1381', '扩展属性-WIFI功能', '237', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1382', '型号', '237', 'many', 'list', '【健康秤】体脂秤,【健康秤】体重秤,【台灯】米家led台灯,【台灯】飞利浦2代,【吸顶灯】飞利浦智睿版,【夜灯】米家感应夜灯,【床头灯】yeelight白色版,【床头灯】米家金色版,【插座】米家智能基础版,【摄像头】小方摄像头,【摄像头】小白摄像机大众版,【摄像头】米家1080P卡片机,【摄像头】米家云台720P,【摄像头】米家小白,【智能家庭套装】家庭礼品装,【智能音箱】小爱音箱,【灯泡】飞利浦智睿版,【相机】米家全景相机套装,【相机】米家小相机', null);
INSERT INTO `sp_attribute` VALUES ('1383', '基本参数-品牌', '239', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1384', '屏幕参数-显示屏类型', '239', 'only', 'manual', '非翻转屏,非触摸屏', null);
INSERT INTO `sp_attribute` VALUES ('1385', '镜头参数-镜头类型', '239', 'only', 'manual', '标准变焦', null);
INSERT INTO `sp_attribute` VALUES ('1386', '曝光参数-曝光模式', '239', 'only', 'manual', '自动模式（自动；自动（闪光灯关闭））；带有柔性程序的程序自动（P）；快门优先自动（S）；光圈优先自动（A）；手动（M）；场景模式（人像；风景；儿童照；运动；近摄；夜间人像；夜景；宴会/室内；海滩/雪景', null);
INSERT INTO `sp_attribute` VALUES ('1387', '性能参数-快门类型', '239', 'only', 'manual', '电子控制纵走式焦平面快门', null);
INSERT INTO `sp_attribute` VALUES ('1388', '视频参数-视频格式', '239', 'only', 'manual', 'MOV', null);
INSERT INTO `sp_attribute` VALUES ('1389', '闪光参数-闪光灯类型', '239', 'only', 'manual', '内置闪光灯', null);
INSERT INTO `sp_attribute` VALUES ('1390', '存储参数-存储介质', '239', 'only', 'manual', 'SD卡', null);
INSERT INTO `sp_attribute` VALUES ('1391', '电源参数-电池型号', '239', 'only', 'manual', '锂离子电池组 EN-EL15', null);
INSERT INTO `sp_attribute` VALUES ('1392', '外观参数-机身材质', '239', 'only', 'manual', '工程塑料外壳+金属骨架', null);
INSERT INTO `sp_attribute` VALUES ('1393', '规格', '239', 'many', 'list', '16-80套机,16-85套机,18-105&55-300双头套机,18-105套机,18-140&35 1.8G双头套机,18-140&55-300双头套机,18-200套机,18-300套机,【热销】18-140套机,【特惠】18-105&35 1.8G双头套机,腾龙16-300套机,腾龙18-200套机,腾龙18-270套机', null);
INSERT INTO `sp_attribute` VALUES ('1394', '基本参数-品牌', '23', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1395', '技术参数-匹数', '23', 'only', 'manual', '1.5匹', null);
INSERT INTO `sp_attribute` VALUES ('1396', '能效参数-变频/定频', '23', 'only', 'manual', '变频', null);
INSERT INTO `sp_attribute` VALUES ('1397', '适用面积-制冷面积', '23', 'only', 'manual', '15-23平方米', null);
INSERT INTO `sp_attribute` VALUES ('1398', '分贝参数-室内噪音', '23', 'only', 'manual', '18-42分贝', null);
INSERT INTO `sp_attribute` VALUES ('1399', '规格参数-电源', '23', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1400', '特色功能-自动清洁', '23', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1401', '其他参数-商品特性', '23', 'only', 'manual', '自动清洁,静音,准确控温,独立除湿,智能操控,电辅加热,外观轻薄', null);
INSERT INTO `sp_attribute` VALUES ('1402', '颜色', '23', 'many', 'list', '', null);
INSERT INTO `sp_attribute` VALUES ('1403', '主要参数-品牌', '240', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1404', '镜头参数-焦距（相当于35mm', '240', 'only', 'manual', '动态模式：f=29.8-298.0mm(16:9)；静态模式：f=26.8-268.0mm(16:9),f=32.8-328.0mm(4:3)', null);
INSERT INTO `sp_attribute` VALUES ('1405', '显示参数-触摸屏', '240', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1406', '曝光参数-自动背光修正', '240', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1407', '音效-内置麦克风', '240', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1408', '存储及输出参数-存储介质', '240', 'only', 'manual', 'SD/SDHC/SDXC', null);
INSERT INTO `sp_attribute` VALUES ('1409', '功能参数-显示屏像素', '240', 'only', 'manual', '92.1万像素', null);
INSERT INTO `sp_attribute` VALUES ('1410', '其他参数-电池类型', '240', 'only', 'manual', '可重复充电电池', null);
INSERT INTO `sp_attribute` VALUES ('1411', '主要参数-品牌', '242', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1412', '显示参数-显示屏尺寸', '242', 'only', 'manual', '3英寸', null);
INSERT INTO `sp_attribute` VALUES ('1413', '功能参数-防抖功能', '242', 'only', 'manual', '光学防抖', null);
INSERT INTO `sp_attribute` VALUES ('1414', '版本', '242', 'many', 'list', '会议套装,单机,婚庆套装,标配套装,HM170 4K,HM200 4K,HM360,HM600,HM85,HM850,HM890,HM95,LS2,LS300 4K', null);
INSERT INTO `sp_attribute` VALUES ('1415', '主体-商品名称', '243', 'only', 'manual', '宾得（PENTAX） 8X21 UCF R 双筒望远镜', null);
INSERT INTO `sp_attribute` VALUES ('1416', '技术参数-功能', '243', 'only', 'manual', '目镜望远镜', null);
INSERT INTO `sp_attribute` VALUES ('1417', '规格-单筒直径', '243', 'only', 'manual', '-', null);
INSERT INTO `sp_attribute` VALUES ('1418', '基本参数-品牌', '244', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1419', '屏幕参数-显示屏尺寸', '244', 'only', 'manual', '3英寸', null);
INSERT INTO `sp_attribute` VALUES ('1420', '镜头参数-镜头类型', '244', 'only', 'manual', '变焦镜头', null);
INSERT INTO `sp_attribute` VALUES ('1421', '性能参数-快门类型', '244', 'only', 'manual', '电子快门', null);
INSERT INTO `sp_attribute` VALUES ('1422', '视频参数-视频格式', '244', 'only', 'manual', 'MOV (MPEG-4AVC / H.264) , AVI (Motion JPEG)', null);
INSERT INTO `sp_attribute` VALUES ('1423', '存储及连接参数-存储介质', '244', 'only', 'manual', 'SD卡,SDHC卡,SDXC卡', null);
INSERT INTO `sp_attribute` VALUES ('1424', '附件及电源参数-电池型号', '244', 'only', 'manual', 'BLS50', null);
INSERT INTO `sp_attribute` VALUES ('1425', '颜色', '244', 'many', 'list', '优雅银,炫酷黑,EM1 Mark II 12-40套装,EM1 Mark II 单机身,EM10 MarkII 电动套装,EM10 MarkIII电动套装,EM5 MarkII 12-40套装,EM5 MarkII 12-50套装,EM5 MarkII 单机身,PEN-F 1718套装,PEN-F 单机身', null);
INSERT INTO `sp_attribute` VALUES ('1426', '主体参数-品牌', '245', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1427', '屏幕参数-显示屏类型', '245', 'only', 'manual', '液晶屏', null);
INSERT INTO `sp_attribute` VALUES ('1428', '镜头参数-镜头类型', '245', 'only', 'manual', '伸缩式', null);
INSERT INTO `sp_attribute` VALUES ('1429', '曝光控制-曝光补偿', '245', 'only', 'manual', '正负2.0EV，间隔为1/3EV', null);
INSERT INTO `sp_attribute` VALUES ('1430', '性能参数-防抖功能', '245', 'only', 'manual', '光学防抖', null);
INSERT INTO `sp_attribute` VALUES ('1431', '存储与连接参数-存储介质', '245', 'only', 'manual', 'SD卡；SDHC卡；SDXC卡', null);
INSERT INTO `sp_attribute` VALUES ('1432', '附件及电源参数-电池类型', '245', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('1433', '外观参数-产品尺寸', '245', 'only', 'manual', '108.4 x 69.9 x 32.8毫米', null);
INSERT INTO `sp_attribute` VALUES ('1434', '特性-WIFI功能', '245', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1435', '型号', '245', 'many', 'list', '15倍长焦FZ152,42倍长焦AZ421,65倍长焦AZ651', null);
INSERT INTO `sp_attribute` VALUES ('1436', '主要参数-商品名称', '247', 'only', 'manual', '徕卡(Leica) SOFORT相机一次成像立拍立得相机 白色19100+单包彩色相纸', null);
INSERT INTO `sp_attribute` VALUES ('1437', '功能参数-防抖功能', '247', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1438', '产品规格-适用相纸尺寸', '247', 'only', 'manual', '54*86mm（小）', null);
INSERT INTO `sp_attribute` VALUES ('1439', '存储及输出参数-胶片尺寸', '247', 'only', 'manual', '60毫米', null);
INSERT INTO `sp_attribute` VALUES ('1440', '镜头参数-镜头类型', '247', 'only', 'manual', '伸缩式', null);
INSERT INTO `sp_attribute` VALUES ('1441', '颜色', '247', 'many', 'list', '橘色,白色,粉色,薄荷绿', null);
INSERT INTO `sp_attribute` VALUES ('1442', '主体参数-品牌', '248', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1443', '屏幕参数-显示屏类型', '248', 'only', 'manual', '液晶屏,触摸屏', null);
INSERT INTO `sp_attribute` VALUES ('1444', '镜头参数-镜头类型', '248', 'only', 'manual', '伸缩式', null);
INSERT INTO `sp_attribute` VALUES ('1445', '性能参数-防抖功能', '248', 'only', 'manual', '光学防抖', null);
INSERT INTO `sp_attribute` VALUES ('1446', '存储与连接参数-机身内存', '248', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1447', '附件及电源参数-电池类型', '248', 'only', 'manual', '锂电池', null);
INSERT INTO `sp_attribute` VALUES ('1448', '外观参数-产品尺寸', '248', 'only', 'manual', '106毫米', null);
INSERT INTO `sp_attribute` VALUES ('1449', '特性-WIFI功能', '248', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1450', '基本参数-品牌', '249', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1451', '规格参数-存储介质', '249', 'only', 'manual', 'SD卡', null);
INSERT INTO `sp_attribute` VALUES ('1452', '型号', '249', 'many', 'list', 'Blink 白色,V3 星空黑,充电器,头戴,头盔固定带,收纳盒,电池,胸带,风扇外框,骑行车把', null);
INSERT INTO `sp_attribute` VALUES ('1453', '主体-品牌', '24', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1454', '功能参数-匹数', '24', 'only', 'manual', '2匹', null);
INSERT INTO `sp_attribute` VALUES ('1455', '规格参数-电源', '24', 'only', 'manual', '220-1-50伏特', null);
INSERT INTO `sp_attribute` VALUES ('1456', '能耗', '24', 'many', 'list', '圆筒智行两匹三级能效,圆筒智行三匹三级能效,风尊两匹升降面板手机遥控wife链接,风尊三匹升降面板手机遥控wife链接,圆筒制冷王两匹一级能效,圆筒制冷王三匹一级能效,圆筒智能王两匹一级能效,圆筒智能王三匹一级能效', null);
INSERT INTO `sp_attribute` VALUES ('1457', '基本参数-品牌', '250', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1458', '规格参数-容量', '250', 'only', 'manual', '22800', null);
INSERT INTO `sp_attribute` VALUES ('1459', '版式', '250', 'many', 'list', 'NG 1146 数位相机包,NG 1153迷你型微单包,NG 4475斜挎微单包,NG 4476小型腰包,NG 2342小型相机包,NG 2344迷你型单肩包,NG 2346小型单肩包,NG 2476中型单肩包,NG 2478大型单肩背包,NG 5158小型双肩背包,NG 5160中型双肩背包', null);
INSERT INTO `sp_attribute` VALUES ('1460', '基本参数-型号', '251', 'only', 'manual', '云腾-668', null);
INSERT INTO `sp_attribute` VALUES ('1461', '特性参数-最大承重量', '251', 'only', 'manual', '3千克', null);
INSERT INTO `sp_attribute` VALUES ('1462', '规格参数-重量', '251', 'only', 'manual', '1.25千克', null);
INSERT INTO `sp_attribute` VALUES ('1463', '基本参数-品牌', '253', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1464', '规格参数-滤镜口径', '253', 'only', 'manual', '67mm', null);
INSERT INTO `sp_attribute` VALUES ('1465', '尺寸', '253', 'many', 'list', '52mm,55mm,58mm,62mm,67mm,72mm,77mm,82mm,95mm,NCUV滤镜,圆形偏振', null);
INSERT INTO `sp_attribute` VALUES ('1466', '基本参数-品牌', '254', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1467', '功能参数-读写速度', '254', 'only', 'manual', '80MB/S 读取', null);
INSERT INTO `sp_attribute` VALUES ('1468', '读取速度', '254', 'many', 'list', '48M/S,80M/S,90M/S,128G,16G,32G,64G', null);
INSERT INTO `sp_attribute` VALUES ('1469', '基本参数-型号', '255', 'only', 'manual', '600EX II', null);
INSERT INTO `sp_attribute` VALUES ('1470', '规格参数-闪光范围', '255', 'only', 'manual', '普通闪光：约0.5 - 27.8米', null);
INSERT INTO `sp_attribute` VALUES ('1471', '基本参数-品牌', '256', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1472', '功能参数-读写速度', '256', 'only', 'manual', '100MB/s', null);
INSERT INTO `sp_attribute` VALUES ('1473', '内存容量', '256', 'many', 'list', '128G,32G,64G', null);
INSERT INTO `sp_attribute` VALUES ('1474', '基本参数-品牌', '259', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1475', '光学参数-焦距范围', '259', 'only', 'manual', '17-50mm毫米', null);
INSERT INTO `sp_attribute` VALUES ('1476', '规格参数-滤镜口径', '259', 'only', 'manual', '72mm', null);
INSERT INTO `sp_attribute` VALUES ('1477', '版式', '259', 'many', 'list', '佳能口,尼康口', null);
INSERT INTO `sp_attribute` VALUES ('1478', '基本参数-品牌', '260', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1479', '光学参数-最近对焦距离', '260', 'only', 'manual', '30cm', null);
INSERT INTO `sp_attribute` VALUES ('1480', '规格参数-滤镜口径', '260', 'only', 'manual', '67mm', null);
INSERT INTO `sp_attribute` VALUES ('1481', '尺寸', '260', 'many', 'list', '20,24,35,50,85,佳能口,尼康口,适马口', null);
INSERT INTO `sp_attribute` VALUES ('1482', '基本参数-型号', '261', 'only', 'manual', '700D', null);
INSERT INTO `sp_attribute` VALUES ('1483', '特性参数-最大承重量', '261', 'only', 'manual', '4千克', null);
INSERT INTO `sp_attribute` VALUES ('1484', '规格参数-重量', '261', 'only', 'manual', '0.8千克', null);
INSERT INTO `sp_attribute` VALUES ('1485', '基本参数-品牌', '262', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1486', '规格参数-滤镜口径', '262', 'only', 'manual', '67mm', null);
INSERT INTO `sp_attribute` VALUES ('1487', '基本参数-品牌', '263', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1488', '特性参数-最大承重量', '263', 'only', 'manual', '10千克', null);
INSERT INTO `sp_attribute` VALUES ('1489', '规格参数-重量', '263', 'only', 'manual', '1.82千克', null);
INSERT INTO `sp_attribute` VALUES ('1490', '基本参数-系列', '264', 'only', 'manual', '相机/摄像机内存卡', null);
INSERT INTO `sp_attribute` VALUES ('1491', '功能参数-内存容量', '264', 'only', 'manual', '64G', null);
INSERT INTO `sp_attribute` VALUES ('1492', '基本参数-品牌', '265', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1493', '功能参数-读写速度', '265', 'only', 'manual', '读98Mb/s', null);
INSERT INTO `sp_attribute` VALUES ('1494', '内存容量', '265', 'many', 'list', '16G,32G,64G', null);
INSERT INTO `sp_attribute` VALUES ('1495', '基本参数-品牌', '266', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1496', '规格参数-滤镜口径', '266', 'only', 'manual', '67mm', null);
INSERT INTO `sp_attribute` VALUES ('1497', '类型', '266', 'many', 'list', 'Air入门级,37,40.5,43,46,52,55,58,62,67,72,77,82', null);
INSERT INTO `sp_attribute` VALUES ('1498', '基本参数-品牌', '267', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1499', '规格参数-容量', '267', 'only', 'manual', '1机3镜', null);
INSERT INTO `sp_attribute` VALUES ('1500', '基本参数-品牌', '268', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1501', '规格参数-滤镜口径', '268', 'only', 'manual', '77mm', null);
INSERT INTO `sp_attribute` VALUES ('1502', '尺寸', '268', 'many', 'list', '37mm,40.5mm,43mm,46mm,49mm,52mm,55mm,58mm,62mm,67mm,72mm,77mm,82mm', null);
INSERT INTO `sp_attribute` VALUES ('1503', '基本参数-品牌', '269', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1504', '规格参数-产品尺寸', '269', 'only', 'manual', '200*50*60', null);
INSERT INTO `sp_attribute` VALUES ('1505', '基本参数-品牌', '272', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1506', '特性参数-最大承重量', '272', 'only', 'manual', '15千克', null);
INSERT INTO `sp_attribute` VALUES ('1507', '基本参数-品牌', '274', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1508', '规格参数-滤镜口径', '274', 'only', 'manual', '77mm', null);
INSERT INTO `sp_attribute` VALUES ('1509', '版式', '274', 'many', 'list', '60mm,49mm,52mm,55mm,58mm,62mm,77mm,82mm,39mm,86mm', null);
INSERT INTO `sp_attribute` VALUES ('1510', '基本参数-品牌', '276', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1511', '基本参数-品牌', '277', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1512', '规格参数-滤镜口径', '277', 'only', 'manual', '67mm', null);
INSERT INTO `sp_attribute` VALUES ('1513', '基本参数-品牌', '278', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1514', '基本参数-品牌', '279', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1515', '规格参数-口径', '279', 'only', 'manual', '52mm', null);
INSERT INTO `sp_attribute` VALUES ('1516', '版式', '279', 'many', 'list', 'HB-45,EW-78E', null);
INSERT INTO `sp_attribute` VALUES ('1517', '基本参数-品牌', '27', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1518', '技术参数-匹数', '27', 'only', 'manual', '3匹', null);
INSERT INTO `sp_attribute` VALUES ('1519', '能效参数-变频/定频', '27', 'only', 'manual', '变频', null);
INSERT INTO `sp_attribute` VALUES ('1520', '适用面积-制冷面积', '27', 'only', 'manual', '45平方米', null);
INSERT INTO `sp_attribute` VALUES ('1521', '分贝参数-室内噪音', '27', 'only', 'manual', '40/32/29分贝', null);
INSERT INTO `sp_attribute` VALUES ('1522', '规格参数-电源', '27', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1523', '白色', '27', 'many', 'list', '3P变频风管机,1.5P变频风管机,1P变频风管机,2P变频风管机,5.5P定速风管机,5P定速风管机,小3P定速', null);
INSERT INTO `sp_attribute` VALUES ('1524', '基本参数-品牌', '280', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1525', '规格参数-线长', '280', 'only', 'manual', '1.5米', null);
INSERT INTO `sp_attribute` VALUES ('1526', '基本参数-品牌', '281', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1527', '处理器-核心数', '281', 'only', 'manual', '双核心', null);
INSERT INTO `sp_attribute` VALUES ('1528', '内存-内存容量', '281', 'only', 'manual', '8GB', null);
INSERT INTO `sp_attribute` VALUES ('1529', '硬盘-硬盘容量', '281', 'only', 'manual', '128GB', null);
INSERT INTO `sp_attribute` VALUES ('1530', '显卡-显卡类型', '281', 'only', 'manual', '核芯显卡', null);
INSERT INTO `sp_attribute` VALUES ('1531', '光驱-光驱类型', '281', 'only', 'manual', '无光驱', null);
INSERT INTO `sp_attribute` VALUES ('1532', '显示屏-屏幕尺寸', '281', 'only', 'manual', '13.3英寸', null);
INSERT INTO `sp_attribute` VALUES ('1533', '通信-蓝牙功能', '281', 'only', 'manual', '蓝牙4.0', null);
INSERT INTO `sp_attribute` VALUES ('1534', '端口-USB2.0端口', '281', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1535', '多媒体设备-内置摄像头', '281', 'only', 'manual', 'HD摄像头', null);
INSERT INTO `sp_attribute` VALUES ('1536', '输入设备-指取设备', '281', 'only', 'manual', '触摸板', null);
INSERT INTO `sp_attribute` VALUES ('1537', '电源-电池类型', '281', 'only', 'manual', '聚合物电池', null);
INSERT INTO `sp_attribute` VALUES ('1538', '规格-厚度', '281', 'only', 'manual', '3–17毫米', null);
INSERT INTO `sp_attribute` VALUES ('1539', '其他-厂商保修政策', '281', 'only', 'manual', '符合国家三包', null);
INSERT INTO `sp_attribute` VALUES ('1540', '版式', '281', 'many', 'list', '【定制】双核i7/8G内存/256G,【定制】双核i7/8G内存/512G,【新品】双核i5/8G内存/128G,【新品】双核i5/8G内存/256G', null);
INSERT INTO `sp_attribute` VALUES ('1541', '基本参数-品牌', '282', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1542', '处理器-核心数', '282', 'only', 'manual', '四核心', null);
INSERT INTO `sp_attribute` VALUES ('1543', '内存-内存容量', '282', 'only', 'manual', '8GB', null);
INSERT INTO `sp_attribute` VALUES ('1544', '硬盘-硬盘容量', '282', 'only', 'manual', '128GB+1TB', null);
INSERT INTO `sp_attribute` VALUES ('1545', '显卡-显卡类型', '282', 'only', 'manual', '独立显卡', null);
INSERT INTO `sp_attribute` VALUES ('1546', '光驱-光驱类型', '282', 'only', 'manual', '无光驱', null);
INSERT INTO `sp_attribute` VALUES ('1547', '显示屏-屏幕尺寸', '282', 'only', 'manual', '15.6英寸', null);
INSERT INTO `sp_attribute` VALUES ('1548', '通信-蓝牙功能', '282', 'only', 'manual', '蓝牙4.0', null);
INSERT INTO `sp_attribute` VALUES ('1549', '端口-USB2.0端口', '282', 'only', 'manual', '0个', null);
INSERT INTO `sp_attribute` VALUES ('1550', '多媒体设备-内置摄像头', '282', 'only', 'manual', '30万像素摄像头', null);
INSERT INTO `sp_attribute` VALUES ('1551', '输入设备-键盘', '282', 'only', 'manual', '背光键盘', null);
INSERT INTO `sp_attribute` VALUES ('1552', '电源-电池类型', '282', 'only', 'manual', '4芯锂电池', null);
INSERT INTO `sp_attribute` VALUES ('1553', '规格-厚度', '282', 'only', 'manual', '24.5 mm毫米', null);
INSERT INTO `sp_attribute` VALUES ('1554', '其他-随机附件', '282', 'only', 'manual', '电池、电源适配器、说明书、保修卡', null);
INSERT INTO `sp_attribute` VALUES ('1555', '板式', '282', 'many', 'list', '【光影精灵Ⅲ 新品】【7代】i5+8G+1TB+128G+黑绿,【光影精灵Ⅲ 新品】【7代】i7+8G+1TB+128G+黑绿,【光影精灵Ⅲ 新品】【7代】i7+8G+1TB+黑绿', null);
INSERT INTO `sp_attribute` VALUES ('1556', '基本参数-品牌', '286', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1557', '处理器-核心数', '286', 'only', 'manual', '双核心', null);
INSERT INTO `sp_attribute` VALUES ('1558', '内存-内存类型', '286', 'only', 'manual', 'DDR4', null);
INSERT INTO `sp_attribute` VALUES ('1559', '硬盘-硬盘类型', '286', 'only', 'manual', '机械硬盘', null);
INSERT INTO `sp_attribute` VALUES ('1560', '显卡-显卡类型', '286', 'only', 'manual', '独立显卡', null);
INSERT INTO `sp_attribute` VALUES ('1561', '光驱-光驱类型', '286', 'only', 'manual', '无光驱', null);
INSERT INTO `sp_attribute` VALUES ('1562', '通信-局域网', '286', 'only', 'manual', '10/100/1000Mbps', null);
INSERT INTO `sp_attribute` VALUES ('1563', '端口-USB2.0端口', '286', 'only', 'manual', '2个', null);
INSERT INTO `sp_attribute` VALUES ('1564', '规格-颜色', '286', 'only', 'manual', '烟灰', null);
INSERT INTO `sp_attribute` VALUES ('1565', '其他-厂商保修政策', '286', 'only', 'manual', '全国联保', null);
INSERT INTO `sp_attribute` VALUES ('1566', '配置', '286', 'many', 'list', 'G3900/4G/1T/独显/WIFI/19.5/W10/黑,G3900/4G/1T/集显/WIFI/19.5/W10/黑,G3900/4G/1T/集显/19.5/WIN10/黑,G4560/4G/1T/WIFI/集显/19.5/W10/黑,G4560/4G/1T/集显/19.5/WIN10/黑,i3/4G/1T/集显/19.5/WIN10/黑,i3/4G/1T/集显/WIFI/19.5/WIN10/黑,i3/4G/1T/2G独显/WIFI/19.5/W10/黑,i5/4G/1T/2G独显/WIFI/19.5/W10/黑,i3/4G/1T/集显/WIFI/19.5/WIN10/银,I5/8G/1T/独显/WIFI/19.5/WIN10/银', null);
INSERT INTO `sp_attribute` VALUES ('1567', '基本参数-品牌', '287', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1568', '处理器-CPU类型', '287', 'only', 'manual', 'Intel i3', null);
INSERT INTO `sp_attribute` VALUES ('1569', '内存-内存类型', '287', 'only', 'manual', 'DDR4', null);
INSERT INTO `sp_attribute` VALUES ('1570', '显卡-显卡类型', '287', 'only', 'manual', '独立显卡', null);
INSERT INTO `sp_attribute` VALUES ('1571', '硬盘-硬盘类型', '287', 'only', 'manual', '机械硬盘', null);
INSERT INTO `sp_attribute` VALUES ('1572', '光驱-光驱类型', '287', 'only', 'manual', '无光驱', null);
INSERT INTO `sp_attribute` VALUES ('1573', '显示器-屏幕类型', '287', 'only', 'manual', 'IPS', null);
INSERT INTO `sp_attribute` VALUES ('1574', '多媒体设备-内置扬声器', '287', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1575', '通信-蓝牙功能', '287', 'only', 'manual', '蓝牙4.0', null);
INSERT INTO `sp_attribute` VALUES ('1576', '端口-音频端口', '287', 'only', 'manual', 'audio', null);
INSERT INTO `sp_attribute` VALUES ('1577', '规格-颜色', '287', 'only', 'manual', '黑曜金', null);
INSERT INTO `sp_attribute` VALUES ('1578', '其他-厂商保修政策', '287', 'only', 'manual', '全国联保', null);
INSERT INTO `sp_attribute` VALUES ('1579', '版本', '287', 'many', 'list', '奔腾/1TB/独显/白色,六代I3//1TB/独显/黑色,六代I3//1TB/独显/白色,六代I3/固态独显/黑,七代I3/1TB/集成/黑色,七代I3/固态/集成/黑色,七代I3/固态/独显/黑,七代I5/1TB/独显/黑色,七代I5/固态/独显/黑色,七代I5/固态/独显/白,八代I5/双硬盘/独显/黑,七代I5-7300/GTX1050,七代I7-7700/GTX1050', null);
INSERT INTO `sp_attribute` VALUES ('1580', '商品总览-品牌', '288', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1581', '处理器-CPU品牌', '288', 'only', 'manual', 'Intel', null);
INSERT INTO `sp_attribute` VALUES ('1582', '存储设备-内存品牌', '288', 'only', 'manual', '影驰', null);
INSERT INTO `sp_attribute` VALUES ('1583', '机电外观-电源品牌', '288', 'only', 'manual', 'TT', null);
INSERT INTO `sp_attribute` VALUES ('1584', '板卡信息-主板品牌', '288', 'only', 'manual', '华硕', null);
INSERT INTO `sp_attribute` VALUES ('1585', '热卖主机', '288', 'many', 'list', 'i5 7500/GTX1060 6G,i7 7700/GTX1060 6G,i5 7500/GTX1060 3G,i7 7700/GTX1060 3G,i7 7700K/GTX1060 6G,i7 7700/GTX1070 8G', null);
INSERT INTO `sp_attribute` VALUES ('1586', '基本参数-型号', '28', 'only', 'manual', 'KY-26B', null);
INSERT INTO `sp_attribute` VALUES ('1587', '技术参数-匹数', '28', 'only', 'manual', '1匹', null);
INSERT INTO `sp_attribute` VALUES ('1588', '能效参数-变频/定频', '28', 'only', 'manual', '定频', null);
INSERT INTO `sp_attribute` VALUES ('1589', '适用面积-制冷面积', '28', 'only', 'manual', '8-16平方米', null);
INSERT INTO `sp_attribute` VALUES ('1590', '规格参数-电源', '28', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1591', '特色功能-自动清洁', '28', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1592', '其他参数-扫风方式', '28', 'only', 'manual', '左右扫风', null);
INSERT INTO `sp_attribute` VALUES ('1593', '基本参数-品牌', '293', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1594', '规格参数-供电模式', '293', 'only', 'manual', '七号电池', null);
INSERT INTO `sp_attribute` VALUES ('1595', '颜色', '293', 'many', 'list', '金色,银色', null);
INSERT INTO `sp_attribute` VALUES ('1596', '基本参数-品牌', '294', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1597', '规格参数-键盘接口', '294', 'only', 'manual', 'PS/2', null);
INSERT INTO `sp_attribute` VALUES ('1598', '特性-产品特色', '294', 'only', 'manual', '铝合金面壳', null);
INSERT INTO `sp_attribute` VALUES ('1599', '基本参数-品牌', '295', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1600', '键盘规格-背光灯', '295', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1601', '鼠标规格-最高分辨率', '295', 'only', 'manual', '1600', null);
INSERT INTO `sp_attribute` VALUES ('1602', '特性-产品特色', '295', 'only', 'manual', '无线', null);
INSERT INTO `sp_attribute` VALUES ('1603', '无线套装C50颜色', '295', 'many', 'list', '白色,黑色,C20,8200', null);
INSERT INTO `sp_attribute` VALUES ('1604', '基本参数-品牌', '296', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1605', '规格参数-容量', '296', 'only', 'manual', '1TB', null);
INSERT INTO `sp_attribute` VALUES ('1606', '特性-指示灯', '296', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1607', '板式', '296', 'many', 'list', '新E元素,高端炫彩（橙色版）,高端炫彩（白色）,高端炫彩（红色版）,高端炫彩（蓝色版）,高端炫彩（黄色版）,高端炫彩（黑色版）,1TB,2TB,4TB', null);
INSERT INTO `sp_attribute` VALUES ('1608', '基本参数-品牌', '297', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1609', '规格参数-声道', '297', 'only', 'manual', '立体声', null);
INSERT INTO `sp_attribute` VALUES ('1610', '版本和颜色选择', '297', 'many', 'list', 'V-191黑木纹,V-191黄木纹,A1插卡蓝牙（红木纹）,A1插卡蓝牙（黑木纹）', null);
INSERT INTO `sp_attribute` VALUES ('1611', '基本参数-品牌', '299', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1612', '详细参数-接口类型', '299', 'only', 'manual', 'SATA接口', null);
INSERT INTO `sp_attribute` VALUES ('1613', '系列', '299', 'many', 'list', '850 EVO M.2,850 EVO SATA3,850 mSata,850 PRO SATA3,960 EVO M.2,960 pro  M.2,120G,1TB,250G,256G,500G,512G', null);
INSERT INTO `sp_attribute` VALUES ('1614', '基本参数-品牌', '29', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1615', '技术参数-匹数', '29', 'only', 'manual', '1.5匹', null);
INSERT INTO `sp_attribute` VALUES ('1616', '能效参数-变频/定频', '29', 'only', 'manual', '变频', null);
INSERT INTO `sp_attribute` VALUES ('1617', '适用面积-制冷面积', '29', 'only', 'manual', '16-24平方米', null);
INSERT INTO `sp_attribute` VALUES ('1618', '分贝参数-室内噪音', '29', 'only', 'manual', '22-37分贝', null);
INSERT INTO `sp_attribute` VALUES ('1619', '规格参数-电源', '29', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1620', '特色功能-自动清洁', '29', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1621', '其他参数-商品特性', '29', 'only', 'manual', '静音,准确控温,独立除湿,智能操控,电辅加热,节能', null);
INSERT INTO `sp_attribute` VALUES ('1622', '匹数颜色', '29', 'many', 'list', '1.5匹变频,2匹冷暖方柜,2匹变频方柜,3匹冷暖方柜,3匹变频方柜,大1.5匹智能,大1匹变频,大1匹智能,小1匹空调', null);
INSERT INTO `sp_attribute` VALUES ('1623', '基本参数-品牌', '300', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1624', '面板规格-显示器尺寸', '300', 'only', 'manual', '23.8英寸', null);
INSERT INTO `sp_attribute` VALUES ('1625', '硬件参数-响应时间', '300', 'only', 'manual', '8毫秒', null);
INSERT INTO `sp_attribute` VALUES ('1626', '外观-接口类型', '300', 'only', 'manual', 'HDMI*2 DP*2 mDP*1 USB3.0*5', null);
INSERT INTO `sp_attribute` VALUES ('1627', '其他-随机附件', '300', 'only', 'manual', '带支架的显示器', null);
INSERT INTO `sp_attribute` VALUES ('1628', '版式', '300', 'many', 'list', '23.8英寸【U2414H】,23.8英寸【U2417H】,25英寸【U2515D】,25英寸【U2515H】,25英寸【U2518DR】,27英寸【U2715H】,27英寸【U2717D】,27英寸【UP2718Q】,30英寸【U3014】,30英寸【UP3017】,31.5英寸【UP3216Q】,34英寸【U3415W】,37.5英寸【U3818DW】', null);
INSERT INTO `sp_attribute` VALUES ('1629', '基本参数-CPU品牌', '301', 'only', 'manual', 'Intel', null);
INSERT INTO `sp_attribute` VALUES ('1630', '详细参数-三级缓存', '301', 'only', 'manual', '6MB', null);
INSERT INTO `sp_attribute` VALUES ('1631', '显卡参数-集成显卡', '301', 'only', 'manual', '是', null);
INSERT INTO `sp_attribute` VALUES ('1632', '技术参数-64位处理器', '301', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1633', 'CPU内核-线程数', '301', 'only', 'manual', '4', null);
INSERT INTO `sp_attribute` VALUES ('1634', '型号', '301', 'many', 'list', '七代赛扬双核【 G3930  】,七代酷睿双核【i3-7100 】,七代酷睿双核【i3-7350K】,七代酷睿四核【i5-7500 】', null);
INSERT INTO `sp_attribute` VALUES ('1635', '基本参数-品牌', '302', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1636', '核心参数-芯片品牌', '302', 'only', 'manual', 'NVIDIA', null);
INSERT INTO `sp_attribute` VALUES ('1637', '显存参数-显存类型', '302', 'only', 'manual', 'GDDR5', null);
INSERT INTO `sp_attribute` VALUES ('1638', '接口-DVI接口', '302', 'only', 'manual', '1个', null);
INSERT INTO `sp_attribute` VALUES ('1639', '扩展-SLI', '302', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1640', '其他-建议电源', '302', 'only', 'manual', '400瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1641', '型号', '302', 'many', 'list', '旗舰游戏显卡【GTX1070Ti-8G】,极客游戏显卡【GTX1070Ti-8G】,烈焰战神U-TOP【GTX1060-3GB】,烈焰战神U-TOP【GTX1060-6GB】,烈焰战神U-TOP【GTX1070-8GB】,烈焰战神U-TOP【GTX1080-8GB】,烈焰战神U显卡【GTX1050-2GB】,烈焰战神U显卡【GTX1050Ti4G】,烈焰战神U显卡【GTX1060-3GB】,烈焰战神U显卡【GTX1060-6GB】,烈焰战神X-TOP【GTX1060-6GB】,骨灰游戏显卡【GTX1080Ti11G】', null);
INSERT INTO `sp_attribute` VALUES ('1642', '基本参数-品牌', '303', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1643', '详细参数-接口类型', '303', 'only', 'manual', 'SATA接口', null);
INSERT INTO `sp_attribute` VALUES ('1644', '基本参数-上市时间', '304', 'only', 'manual', '2016-4-20', null);
INSERT INTO `sp_attribute` VALUES ('1645', '硬件参数-内存类型', '304', 'only', 'manual', 'DDR4', null);
INSERT INTO `sp_attribute` VALUES ('1646', '版本', '304', 'many', 'list', 'Fury系列（台式机）D3 1600频,Fury系列（台式机）D3 1866频,Fury系列（台式机）D4 2133频,Fury系列（台式机）D4 2400频,Impact系列（笔记本）D3 1600频,Impact系列（笔记本）D4 2133频,Impact系列（笔记本）D4 2400频,Savage系列（台式机）D4 2400频,Savage系列（台式机）D4 2800频,Savage系列（台式机）D4 3000频,台式机（低压）D4 2133频,台式机（低压）D4 2400频,台式机（标压）D3 1333频,台式机（标压）D3 1600频,笔记本（低压）D3 1600频,笔记本（低压）D4 2133频,笔记本（低压）D4 2400频,笔记本（标压）D3 1600频,单条【16G】,单条【4G】,单条【8G】,双条【16G】', null);
INSERT INTO `sp_attribute` VALUES ('1647', '基本参数-品牌', '305', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1648', '芯片组-主/北桥芯片', '305', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1649', '存储设备-IDE', '305', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('1650', '声卡网卡-声卡类型', '305', 'only', 'manual', 'Realtek® ALC892', null);
INSERT INTO `sp_attribute` VALUES ('1651', 'I/O接口-USB扩展接口', '305', 'only', 'manual', '4', null);
INSERT INTO `sp_attribute` VALUES ('1652', '其他-板型结构', '305', 'only', 'manual', 'ATX（标准）', null);
INSERT INTO `sp_attribute` VALUES ('1653', '基本参数-品牌', '306', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1654', '详细数据-额定功率', '306', 'only', 'manual', '500W', null);
INSERT INTO `sp_attribute` VALUES ('1655', '型号', '306', 'many', 'list', '航嘉电源Super     系列  【300W】,航嘉电源Super     系列  【400W】,航嘉电源Super     系列  【500W】,航嘉电源多核WD 系列 【400W】,航嘉电源多核WD 系列 【500W】,航嘉电源多核WD系列 【600W】,航嘉电源模组MVP系列【500W】,航嘉电源模组MVP系列【600W】', null);
INSERT INTO `sp_attribute` VALUES ('1656', '主体-品牌', '307', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1657', '产品参数-接口类型', '307', 'only', 'manual', '*', null);
INSERT INTO `sp_attribute` VALUES ('1658', '规格参数-安装方式', '307', 'only', 'manual', '内置', null);
INSERT INTO `sp_attribute` VALUES ('1659', '其他型号', '307', 'many', 'list', 'Audigy 5,Audigy 4 II,Digital Music Premium HD,SB X-Fi Surround 5.1 Pro,Sound Blaster ZX', null);
INSERT INTO `sp_attribute` VALUES ('1660', '主体-品牌', '309', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1661', '功能-天线', '309', 'only', 'manual', '多天线', null);
INSERT INTO `sp_attribute` VALUES ('1662', '规格-网络协议', '309', 'only', 'manual', 'IEEE 802.11g,IEEE 802.11b,IEEE 802.3,IEEE 802.11n,IEEE 802.3u', null);
INSERT INTO `sp_attribute` VALUES ('1663', '其他-附件', '309', 'only', 'manual', '用户手册 电源适配器', null);
INSERT INTO `sp_attribute` VALUES ('1664', '板式', '309', 'many', 'list', '【11AC双频路由】1200M,【11AC双频路由】900M,【150M】迷你,【300M】经典款,【300M无线扩展器】,【450M旗舰】宝蓝,【450M旗舰】水蓝,【全金属机身】450M,【双频无线】1300M,宝蓝,水蓝,白色,绿色,金属黑,黑色', null);
INSERT INTO `sp_attribute` VALUES ('1665', '基本参数-品牌', '30', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1666', '技术参数-匹数', '30', 'only', 'manual', '1.5匹', null);
INSERT INTO `sp_attribute` VALUES ('1667', '能效参数-变频/定频', '30', 'only', 'manual', '变频', null);
INSERT INTO `sp_attribute` VALUES ('1668', '适用面积-制冷面积', '30', 'only', 'manual', '15~22平方米', null);
INSERT INTO `sp_attribute` VALUES ('1669', '分贝参数-室内噪音', '30', 'only', 'manual', '23~40分贝', null);
INSERT INTO `sp_attribute` VALUES ('1670', '规格参数-电源', '30', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1671', '特色功能-自动清洁', '30', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1672', '其他参数-商品特性', '30', 'only', 'manual', '静音,准确控温,独立除湿,节能,合资精选', null);
INSERT INTO `sp_attribute` VALUES ('1673', '匹数颜色', '30', 'many', 'list', '1.5匹二级,1.5匹变频二级,1匹二级,1匹变频二级', null);
INSERT INTO `sp_attribute` VALUES ('1674', '主体-品牌', '310', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1675', '功能参数-连接方式', '310', 'only', 'manual', '无线网卡', null);
INSERT INTO `sp_attribute` VALUES ('1676', '规格参数-传输速率', '310', 'only', 'manual', '150Mbps', null);
INSERT INTO `sp_attribute` VALUES ('1677', '主体-品牌', '311', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1678', '功能-天线', '311', 'only', 'manual', '多天线', null);
INSERT INTO `sp_attribute` VALUES ('1679', '规格-网络协议', '311', 'only', 'manual', 'IEEE 802.11g,IEEE 802.11b,IEEE 802.3,IEEE 802.11ac,IEEE 802.11n,IEEE 802.3u', null);
INSERT INTO `sp_attribute` VALUES ('1680', '型号', '311', 'many', 'list', '【双频爆款】1200M珍珠白,【双频新品】1200M雅典绿,【双频 千兆端口】1200M,【双频 全新外观】1200M,【双频高配·6天线】1750M,【双频·6天线 千兆端口】1750M,【双频·7天线 百兆端口】2200M,【双频·7天线 千兆端口】2200M,【双频·8天线 千兆端口】2600M,【三频·8天线 千兆端口】2600M', null);
INSERT INTO `sp_attribute` VALUES ('1681', '主体-品牌', '312', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1682', '功能-天线', '312', 'only', 'manual', '多天线', null);
INSERT INTO `sp_attribute` VALUES ('1683', '规格-网络协议', '312', 'only', 'manual', 'IEEE 802.11g,IEEE 802.11b,IEEE 802.3,IEEE 802.11ac,IEEE 802.11n,IEEE 802.3u', null);
INSERT INTO `sp_attribute` VALUES ('1684', '规格', '312', 'many', 'list', '【双频爆款】1200M,【千兆网口】1300M,【双频经典】1750M,【板阵天线】2600M', null);
INSERT INTO `sp_attribute` VALUES ('1685', '基本参数-品牌', '313', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1686', '主体-品牌', '314', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1687', '功能-交换方式', '314', 'only', 'manual', '存储转发', null);
INSERT INTO `sp_attribute` VALUES ('1688', '规格-重量', '314', 'only', 'manual', '0.15千克', null);
INSERT INTO `sp_attribute` VALUES ('1689', '主体-品牌', '317', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1690', '光学参数-最大显示分辨率', '317', 'only', 'manual', '2K / 4K', null);
INSERT INTO `sp_attribute` VALUES ('1691', '投影功能-变焦类型', '317', 'only', 'manual', '定焦', null);
INSERT INTO `sp_attribute` VALUES ('1692', '规格-最小屏幕尺寸', '317', 'only', 'manual', '30寸', null);
INSERT INTO `sp_attribute` VALUES ('1693', '其他-产品特色', '317', 'only', 'manual', '5大提升：1100ANSI流明、哈曼卡顿音响升级、全自动对焦、1.2：1投射比、左右梯形校正角度更大', null);
INSERT INTO `sp_attribute` VALUES ('1694', '板式', '317', 'many', 'list', 'A1 Pro 【1080P全高清 含100英寸抗光幕布】,A1【哈曼卡顿音响  3D巨幕影院】,CC【长时续航  萌系微投】,CC极光【侧投能看 带便携包】,H1S【1080P旗舰新品 5大升级】,H1【1080P真高清 哈曼卡顿加持】,Imea早教版【AR智慧早教系统 儿童视力防护】,Z4Air【高效办公 轻薄机身】,Z4X【经典设计 手势操控】,Z4极光【高端低调 配3D眼镜】,Z5【震撼新品 真千流明7大升级】', null);
INSERT INTO `sp_attribute` VALUES ('1695', '主体-品牌', '318', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1696', '功能参数-幅面尺寸', '318', 'only', 'manual', 'A3', null);
INSERT INTO `sp_attribute` VALUES ('1697', '打印功能-功能', '318', 'only', 'manual', '扫描', null);
INSERT INTO `sp_attribute` VALUES ('1698', '复印功能-复印分辨率', '318', 'only', 'manual', '600×600dpi', null);
INSERT INTO `sp_attribute` VALUES ('1699', '扫描功能-扫描类型', '318', 'only', 'manual', '平板', null);
INSERT INTO `sp_attribute` VALUES ('1700', '规格参数-内存容量', '318', 'only', 'manual', '256MB', null);
INSERT INTO `sp_attribute` VALUES ('1701', 'A3复合机', '318', 'many', 'list', 'S2011N标配,S2011N标配+ 自动输稿器,S2011N标配+ 双面打印,S2011N标配+输稿器+第二纸盒,S2011NDA（输稿器+双面）,S2011NDA（输稿器+双面）+双层纸盒,2011N标配,新款2110N标配,新款2110NDA（输稿器+双面）', null);
INSERT INTO `sp_attribute` VALUES ('1702', '主体-型号', '319', 'only', 'manual', 'dypt45s2', null);
INSERT INTO `sp_attribute` VALUES ('1703', '基本参数-显示屏', '319', 'only', 'manual', 'LED触摸宽屏控制', null);
INSERT INTO `sp_attribute` VALUES ('1704', '规格参数-门型', '319', 'only', 'manual', '单开门', null);
INSERT INTO `sp_attribute` VALUES ('1705', '颜色', '319', 'many', 'list', '土豪金,土豪金指纹,咖啡金新指纹,爵士黑', null);
INSERT INTO `sp_attribute` VALUES ('1706', '基本参数-品牌', '31', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1707', '技术参数-匹数', '31', 'only', 'manual', '1匹', null);
INSERT INTO `sp_attribute` VALUES ('1708', '能效参数-变频/定频', '31', 'only', 'manual', '定频', null);
INSERT INTO `sp_attribute` VALUES ('1709', '适用面积-制冷面积', '31', 'only', 'manual', '11-18平方米', null);
INSERT INTO `sp_attribute` VALUES ('1710', '分贝参数-室内噪音', '31', 'only', 'manual', '29-37分贝', null);
INSERT INTO `sp_attribute` VALUES ('1711', '规格参数-电源', '31', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1712', '特色功能-自动清洁', '31', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1713', '其他参数-商品特性', '31', 'only', 'manual', '自动清洁,静音,独立除湿,电辅加热', null);
INSERT INTO `sp_attribute` VALUES ('1714', '匹数颜色', '31', 'many', 'list', '1.5匹冷暖挂机,1.5匹变频挂机,1匹冷暖挂机,2匹冷暖挂机,大1匹变频挂机', null);
INSERT INTO `sp_attribute` VALUES ('1715', '主体-品牌', '324', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1716', '基本参数-书写粗细', '324', 'only', 'manual', '中等', null);
INSERT INTO `sp_attribute` VALUES ('1717', '规格参数-包装数量', '324', 'only', 'manual', '12支', null);
INSERT INTO `sp_attribute` VALUES ('1718', '颜色', '324', 'many', 'list', '黑色◈12支笔+12支笔芯,S52（黑色30支）,6901笔芯（黑色20支/盒）,6901笔芯（红色20支/盒）,6901笔芯（蓝色20支/盒）', null);
INSERT INTO `sp_attribute` VALUES ('1719', '主体-品牌', '326', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1720', '功能参数-适用范围', '326', 'only', 'manual', '订书机系列', null);
INSERT INTO `sp_attribute` VALUES ('1721', '规格参数-包装数量', '326', 'only', 'manual', '1', null);
INSERT INTO `sp_attribute` VALUES ('1722', '型号', '326', 'many', 'list', '0487/80页(送60页订书针一盒),0394/80页(送60页订书针一盒),0391/60页(送60页订书针一盒),0486/120页(送60页订书针一盒),0399/210页{送60页订书针一盒},0414,0368,0325,0307,0329,0314,0416,0305,0390/80页{送60页订书针一盒},0485/210页{送60页订书针一盒}', null);
INSERT INTO `sp_attribute` VALUES ('1723', '主体-型号', '327', 'only', 'manual', '橙拷贝可乐70g A4 5包装', null);
INSERT INTO `sp_attribute` VALUES ('1724', '基本参数-幅面尺寸', '327', 'only', 'manual', 'A4', null);
INSERT INTO `sp_attribute` VALUES ('1725', '规格参数-包装数量', '327', 'only', 'manual', '5', null);
INSERT INTO `sp_attribute` VALUES ('1726', '版式', '327', 'many', 'list', '精品拷贝72g A4,红百旺100g A4,苏宁独家包销 70g A4,苏宁独家包销 80g A4,蓝百旺70g A4,蓝百旺80g A4', null);
INSERT INTO `sp_attribute` VALUES ('1727', '主体-品牌', '328', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1728', '主体-品牌', '329', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1729', '颜色', '329', 'many', 'list', '10页资料册,20页资料册,30页资料册,40页资料册,60页资料册,80页资料册,100页资料册', null);
INSERT INTO `sp_attribute` VALUES ('1730', '基本参数-品牌', '32', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1731', '技术参数-匹数', '32', 'only', 'manual', '1.5匹', null);
INSERT INTO `sp_attribute` VALUES ('1732', '能效参数-变频/定频', '32', 'only', 'manual', '变频', null);
INSERT INTO `sp_attribute` VALUES ('1733', '适用面积-制冷面积', '32', 'only', 'manual', '15-22平方米', null);
INSERT INTO `sp_attribute` VALUES ('1734', '分贝参数-室内噪音', '32', 'only', 'manual', '20-41分贝', null);
INSERT INTO `sp_attribute` VALUES ('1735', '规格参数-电源', '32', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1736', '特色功能-自动清洁', '32', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1737', '其他参数-商品特性', '32', 'only', 'manual', '自动清洁,静音,独立除湿,智能操控,电辅加热,节能', null);
INSERT INTO `sp_attribute` VALUES ('1738', '匹数', '32', 'many', 'list', '1.5匹冷暖,1.5匹变频,1匹冷暖,2匹冷暖,大1匹变频', null);
INSERT INTO `sp_attribute` VALUES ('1739', '主体-品牌', '330', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1740', '基本参数-是否可粘贴', '330', 'only', 'manual', '不可粘贴', null);
INSERT INTO `sp_attribute` VALUES ('1741', '规格参数-装帧', '330', 'only', 'manual', '简装', null);
INSERT INTO `sp_attribute` VALUES ('1742', '颜色', '330', 'many', 'list', '25K/120页-玫红色,25K/120页-深蓝色,25K/120页-黑色,25K/120页-草绿色,25K/120页-卡其色,25K/120页-深棕色', null);
INSERT INTO `sp_attribute` VALUES ('1743', '主体-商品名称', '331', 'only', 'manual', 'A.O.史密斯60X1储水式电热水器60L', null);
INSERT INTO `sp_attribute` VALUES ('1744', '规格参数-加热类别', '331', 'only', 'manual', '多功率加热', null);
INSERT INTO `sp_attribute` VALUES ('1745', '特性参数-水温调节', '331', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1746', '其他-生产企业名称', '331', 'only', 'manual', 'A.O.史密斯（中国）热水器有限公司', null);
INSERT INTO `sp_attribute` VALUES ('1747', '系列', '331', 'many', 'list', '多功率速热系列X0,【新品】双棒速热型NX1,速热增容简约系列X1,智能养护简约系列X2,速热增容遥控系列X3,智能养护遥控系列X4,智能养护至尊系列X5,高端免换镁棒系列EJ,50升,60升,80升', null);
INSERT INTO `sp_attribute` VALUES ('1748', '主体-商品名称', '333', 'only', 'manual', '美的电热水器F50-21S1 防电墙 8年包修', null);
INSERT INTO `sp_attribute` VALUES ('1749', '规格参数-加热类别', '333', 'only', 'manual', '整胆加热', null);
INSERT INTO `sp_attribute` VALUES ('1750', '特性参数-水温调节', '333', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1751', '其他-生产企业名称', '333', 'only', 'manual', '芜湖美的厨卫电器制造有限公司', null);
INSERT INTO `sp_attribute` VALUES ('1752', '升数', '333', 'many', 'list', '50L,60L,【安全防电墙】,【全网经典爆款】,4倍增容遥控月销5000台', null);
INSERT INTO `sp_attribute` VALUES ('1753', '主体-商品名称', '334', 'only', 'manual', '万和燃气热水器 JSQ24-318W12 (天然气）', null);
INSERT INTO `sp_attribute` VALUES ('1754', '规格参数-额定输入功率', '334', 'only', 'manual', '36瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1755', '特性参数-是否防冻', '334', 'only', 'manual', '非防冻型', null);
INSERT INTO `sp_attribute` VALUES ('1756', '其他-上市时间', '334', 'only', 'manual', '2015年11月', null);
INSERT INTO `sp_attribute` VALUES ('1757', '型号', '334', 'many', 'list', '318香槟金恒温,338玫瑰金恒温,350玫瑰金恒温,350自适温恒温,368碳烷双防,388WIFI恒温,538水气双调,ET10恒温爆款,L7零冷水,ST26水气双调,机械强排,10L,12L,13L,16L,8L', null);
INSERT INTO `sp_attribute` VALUES ('1758', '主体-品牌', '336', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1759', '规格参数-容积', '336', 'only', 'manual', '6.6升', null);
INSERT INTO `sp_attribute` VALUES ('1760', '特性参数-防水等级', '336', 'only', 'manual', 'IPX4', null);
INSERT INTO `sp_attribute` VALUES ('1761', '其他-CCC认证编号', '336', 'only', 'manual', '2011010706488931', null);
INSERT INTO `sp_attribute` VALUES ('1762', '颜色', '336', 'many', 'list', '3秒速热,5升上出水,6.6升上出水,三挡出水,不锈钢,海尔统帅6.6升', null);
INSERT INTO `sp_attribute` VALUES ('1763', '主体-上市时间', '337', 'only', 'manual', '2016', null);
INSERT INTO `sp_attribute` VALUES ('1764', '特性参数-控制方式', '337', 'only', 'manual', '微电脑式', null);
INSERT INTO `sp_attribute` VALUES ('1765', '规格参数-电线截面要求', '337', 'only', 'manual', '4平方毫米', null);
INSERT INTO `sp_attribute` VALUES ('1766', '其他-特性', '337', 'only', 'manual', '即开即热 水电分离安全保护 智能恒温变频 热水器', null);
INSERT INTO `sp_attribute` VALUES ('1767', '主体-品牌', '338', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1768', '特性参数-是否可浴室安装', '338', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('1769', '规格参数-能效等级', '338', 'only', 'manual', '1级', null);
INSERT INTO `sp_attribute` VALUES ('1770', '型号', '338', 'many', 'list', '#双舱两用#140L_18管(建议2-3人),#双舱两用#155L_20管(建议3-4人),#双舱两用#180L_24管(建议4-5人),#双舱两用#220L_30管(建议5-7人),#双舱两用#265L_36管(建议6-8人)', null);
INSERT INTO `sp_attribute` VALUES ('1771', '主体-商品名称', '339', 'only', 'manual', '智米智能马桶盖ZNMTG01ZM 白色', null);
INSERT INTO `sp_attribute` VALUES ('1772', '功能参数-水压调节', '339', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1773', '规格参数-功率', '339', 'only', 'manual', '1340瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1774', '基本参数-品牌', '33', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1775', '技术参数-匹数', '33', 'only', 'manual', '1匹', null);
INSERT INTO `sp_attribute` VALUES ('1776', '能效参数-变频/定频', '33', 'only', 'manual', '定频', null);
INSERT INTO `sp_attribute` VALUES ('1777', '适用面积-制冷面积', '33', 'only', 'manual', '13-17平方米', null);
INSERT INTO `sp_attribute` VALUES ('1778', '分贝参数-室内噪音', '33', 'only', 'manual', '23-36分贝', null);
INSERT INTO `sp_attribute` VALUES ('1779', '规格参数-电源', '33', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1780', '特色功能-自动清洁', '33', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1781', '其他参数-商品特性', '33', 'only', 'manual', '自动清洁,静音,准确控温,独立除湿,电辅加热,外观轻薄,节能,节能', null);
INSERT INTO `sp_attribute` VALUES ('1782', '匹数颜色', '33', 'many', 'list', '1.5匹冷暖变频挂机,1.5匹冷暖挂机,大1匹冷暖变频挂机,大1匹冷暖挂机', null);
INSERT INTO `sp_attribute` VALUES ('1783', '主体-品牌', '340', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1784', '规格-适用商品型号', '340', 'only', 'manual', 'H-CS0014-B1D.W', null);
INSERT INTO `sp_attribute` VALUES ('1785', '其他-特性', '340', 'only', 'manual', '可升降、节水、无铅', null);
INSERT INTO `sp_attribute` VALUES ('1786', '主体-商品名称', '341', 'only', 'manual', '华帝股份 百得 厨电套装 触控式欧式18m³风量 抽油烟机不锈钢 油烟机 燃气灶套餐DY22+DZ28B 天然气/液化气', null);
INSERT INTO `sp_attribute` VALUES ('1787', '油烟机规格-烟机面板材质', '341', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('1788', '燃气灶规格-气源', '341', 'only', 'manual', '天然气', null);
INSERT INTO `sp_attribute` VALUES ('1789', '消毒柜规格-控制方式', '341', 'only', 'manual', '机械式', null);
INSERT INTO `sp_attribute` VALUES ('1790', '颜色', '341', 'many', 'list', '【1599送工具箱】强劲吸力+猛火灶,【1799】强劲吸力+0秒启动钢玻灶,【升级灶仅2999】烟灶热三件套,【升级灶仅2799】烟灶消三件套', null);
INSERT INTO `sp_attribute` VALUES ('1791', '主体-商品名称', '343', 'only', 'manual', '康宝（Canbo) CXW-218-DJ118A 侧吸式 抽油烟机 吸油烟机 油烟机', null);
INSERT INTO `sp_attribute` VALUES ('1792', '规格参数-最大风压', '343', 'only', 'manual', '270帕', null);
INSERT INTO `sp_attribute` VALUES ('1793', '特性参数-照明功能', '343', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1794', '其他-CCC认证字', '343', 'only', 'manual', '2015010716808969', null);
INSERT INTO `sp_attribute` VALUES ('1795', '颜色', '343', 'many', 'list', 'A58 17.6立方欧式单烟机,DJ118A  四维立体拢烟侧吸,BE36B 侧吸热干洗烟机,17.5m³侧吸式烟灶套装,A106欧式顶吸大吸力,顶吸式不锈钢单烟机,B7中式小户型单烟机,BE51 侧吸四重油烟分离', null);
INSERT INTO `sp_attribute` VALUES ('1796', '主体-品牌', '344', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1797', '规格参数-净重', '344', 'only', 'manual', '9千克', null);
INSERT INTO `sp_attribute` VALUES ('1798', '特性参数-熄保装置', '344', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1799', '面板', '344', 'many', 'list', '拉丝不锈钢,黑晶防爆钢化玻璃,管道天然气,瓶装液化气,管道人工煤气', null);
INSERT INTO `sp_attribute` VALUES ('1800', '主体-商品名称', '345', 'only', 'manual', 'RTD108Q-A1', null);
INSERT INTO `sp_attribute` VALUES ('1801', '特性参数-安装方式', '345', 'only', 'manual', '嵌入式', null);
INSERT INTO `sp_attribute` VALUES ('1802', '规格参数-外形尺寸', '345', 'only', 'manual', '长595*宽450*高630毫米', null);
INSERT INTO `sp_attribute` VALUES ('1803', '类目', '345', 'many', 'list', '嵌入式消毒柜,二星消毒 不锈钢层架,二星消毒 中温烘干,物理杀菌 高温二星级消毒,臭氧紫外线烘干,高温变频 触控童锁,高温消毒 黑晶面板,高温烘干 分层控制,高温臭氧 童锁预约', null);
INSERT INTO `sp_attribute` VALUES ('1804', '主体-商品名称', '346', 'only', 'manual', '意大利daogrs/迪奥格斯 S8 蒸烤箱 嵌入式 蒸箱烤箱二合一 58升 蒸汽烤箱 电蒸箱 电烤箱 微波炉', null);
INSERT INTO `sp_attribute` VALUES ('1805', '规格参数-操作方式', '346', 'only', 'manual', '触控式', null);
INSERT INTO `sp_attribute` VALUES ('1806', '系列', '346', 'many', 'list', '蒸烤一体机,蒸箱烤箱两件套,纯烤箱,S8热卖,M8热卖,S1热卖,M9,S9,G5,D10+ZD6T,X1+Z6,9T+X3,X1+Z1,D7+Z1,D10,X1,D7,X3', null);
INSERT INTO `sp_attribute` VALUES ('1807', '主体-商品名称', '347', 'only', 'manual', '西门子(SIEMENS) SN23E831TI 立嵌两用洗碗机13套', null);
INSERT INTO `sp_attribute` VALUES ('1808', '规格参数-噪音级别', '347', 'only', 'manual', '48分贝', null);
INSERT INTO `sp_attribute` VALUES ('1809', '特性参数-洗碗篮高度可调', '347', 'only', 'manual', '可调', null);
INSERT INTO `sp_attribute` VALUES ('1810', '洗碗机', '347', 'many', 'list', '13套全嵌式,13套立嵌两用洗碗机,8套嵌入式540TI,8套嵌入式610TI,8套嵌入式810TI,全新升级6套台嵌洗碗机,升级版8套嵌入式E810', null);
INSERT INTO `sp_attribute` VALUES ('1811', '主体-商品名称', '348', 'only', 'manual', 'TCL自动清洗 集成灶 JC10A 抽油烟机 燃气灶 消毒柜套装 18侧吸下排 集成灶厨房 烟灶套餐 支持天然气/液化气', null);
INSERT INTO `sp_attribute` VALUES ('1812', '消毒/碗柜规格-烟机面板材质', '348', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('1813', '灶具规格-控制方式', '348', 'only', 'manual', '微电脑式', null);
INSERT INTO `sp_attribute` VALUES ('1814', '烟机规格-熄保装置', '348', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1815', '特性参数-触摸键', '348', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1816', '规格参数-出风口径(mm)', '348', 'only', 'manual', '175毫米', null);
INSERT INTO `sp_attribute` VALUES ('1817', '机型', '348', 'many', 'list', 'JC50A自动清洗,JC11A双电机 自动清洗,JC18A 双电机 自动清洗,JC10A 高温清洗,JC10B一电一气', null);
INSERT INTO `sp_attribute` VALUES ('1818', '主体-商品名称', '349', 'only', 'manual', 'lecon 乐创 全自动4盆6盆8盆10盆12盆电热蒸饭柜燃气全发泡蒸饭车蒸鱼蒸菜蒸饭蒸饭机商用', null);
INSERT INTO `sp_attribute` VALUES ('1819', '规格参数-电压', '349', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1820', '属性', '349', 'many', 'list', '普通电热,定时电热,燃气,电气两用,4盘,6盘,8盘,10盘,12盘,24盘', null);
INSERT INTO `sp_attribute` VALUES ('1821', '基本参数-品牌', '34', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1822', '技术参数-匹数', '34', 'only', 'manual', '1.5匹', null);
INSERT INTO `sp_attribute` VALUES ('1823', '能效参数-变频/定频', '34', 'only', 'manual', '定频', null);
INSERT INTO `sp_attribute` VALUES ('1824', '适用面积-制冷面积', '34', 'only', 'manual', '16-24平方米', null);
INSERT INTO `sp_attribute` VALUES ('1825', '分贝参数-室内噪音', '34', 'only', 'manual', '39分贝', null);
INSERT INTO `sp_attribute` VALUES ('1826', '规格参数-电源', '34', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1827', '特色功能-自动清洁', '34', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1828', '其他参数-商品特性', '34', 'only', 'manual', '自动清洁,静音,准确控温,电辅加热', null);
INSERT INTO `sp_attribute` VALUES ('1829', '房间', '34', 'many', 'list', '主卧1.5匹,客厅圆柱柜机,次卧大1匹,2匹冷暖二级,2匹变频二级,3匹冷暖二级,3匹变频二级,冷暖（爆款）,变频一级能效,变频二级能效,变频（爆款）', null);
INSERT INTO `sp_attribute` VALUES ('1830', '主体-商品名称', '350', 'only', 'manual', '贝克巴斯(BECBAS)E50 厨房家用食物垃圾处理器 厨余垃圾粉碎机 无线开关免打孔', null);
INSERT INTO `sp_attribute` VALUES ('1831', '特性参数-隔音系统', '350', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('1832', '规格参数-外形尺寸', '350', 'only', 'manual', '379*218*218毫米', null);
INSERT INTO `sp_attribute` VALUES ('1833', '型号', '350', 'many', 'list', '480轻松碎骨实用款（带安全磁环）,DM280家庭常备适用款,E30高效研磨舒适款（带安全磁环）,E50无线开关高配款（带安全磁环）,F5感应开关碎骨静音升级款,防溅罩', null);
INSERT INTO `sp_attribute` VALUES ('1834', '主体-商品名称', '352', 'only', 'manual', '安吉尔angel净水器J2375-ROB12家用厨房直饮高端纯水机RO反渗透自来水过滤器', null);
INSERT INTO `sp_attribute` VALUES ('1835', '功能参数-RO膜清洗功能', '352', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1836', '规格参数-外形尺寸', '352', 'only', 'manual', '397*190*472毫米', null);
INSERT INTO `sp_attribute` VALUES ('1837', '特性参数-是否直饮', '352', 'only', 'manual', '直饮', null);
INSERT INTO `sp_attribute` VALUES ('1838', '净水精度', '352', 'many', 'list', '陶氏RO膜双出水,新款500G（V系列）,双膜双出水,双膜双出水（Plus）,三膜双出水,四膜双出水（Plus）,明星款陶氏RO膜500G（A6）,新款V3（专利节水技术）', null);
INSERT INTO `sp_attribute` VALUES ('1839', '主体-商品名称', '353', 'only', 'manual', '沁园（QINYUAN）立式饮水机YL9766WZ', null);
INSERT INTO `sp_attribute` VALUES ('1840', '功能参数-冰箱功能', '353', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1841', '规格参数-功率', '353', 'only', 'manual', '1000瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1842', '其他-CCC认证编号', '353', 'only', 'manual', '2017010717016472', null);
INSERT INTO `sp_attribute` VALUES ('1843', '型号', '353', 'many', 'list', '新品智能冷热型,新品智能温热型,新品茶吧机,白色冷热型,白色温热型', null);
INSERT INTO `sp_attribute` VALUES ('1844', '主体-商品名称', '355', 'only', 'manual', '史密斯（A.O.SMITH）牌DR50-D2型直饮水机', null);
INSERT INTO `sp_attribute` VALUES ('1845', '特性参数-消毒功能', '355', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1846', '规格参数-功率', '355', 'only', 'manual', '32瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1847', '功能-RO膜清洗功能', '355', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1848', '颜色', '355', 'many', 'list', '50加仑智能升级,50加仑爆款,75加仑爆款', null);
INSERT INTO `sp_attribute` VALUES ('1849', '主体-商品名称', '357', 'only', 'manual', '沁园净水器RO-185 家用直饮反渗透升级版 厨下式 净水机', null);
INSERT INTO `sp_attribute` VALUES ('1850', '功能参数-RO膜清洗功能', '357', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1851', '规格参数-外形尺寸', '357', 'only', 'manual', '383*185*475毫米', null);
INSERT INTO `sp_attribute` VALUES ('1852', '特性参数-是否直饮', '357', 'only', 'manual', '直饮', null);
INSERT INTO `sp_attribute` VALUES ('1853', '颜色', '357', 'many', 'list', '185智控升级版,400加仑大通量', null);
INSERT INTO `sp_attribute` VALUES ('1854', '主体-商品名称', '358', 'only', 'manual', '3M DWS2500-CN', null);
INSERT INTO `sp_attribute` VALUES ('1855', '功能参数-RO膜清洗功能', '358', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('1856', '规格参数-外形尺寸', '358', 'only', 'manual', '长255×宽255×深255毫米', null);
INSERT INTO `sp_attribute` VALUES ('1857', '特性参数-是否直饮', '358', 'only', 'manual', '直饮', null);
INSERT INTO `sp_attribute` VALUES ('1858', '净享系列', '358', 'many', 'list', '净享2500标配,净享2500全新升级款,全屋净水超值套装,净享2500 2年套装', null);
INSERT INTO `sp_attribute` VALUES ('1859', '主体-商品名称', '359', 'only', 'manual', '美的（Midea）净水器MRO101A-5全新升级版', null);
INSERT INTO `sp_attribute` VALUES ('1860', '功能参数-RO膜清洗功能', '359', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1861', '规格参数-功率', '359', 'only', 'manual', '30瓦特', null);
INSERT INTO `sp_attribute` VALUES ('1862', '特性参数-是否直饮', '359', 'only', 'manual', '直饮', null);
INSERT INTO `sp_attribute` VALUES ('1863', '颜色', '359', 'many', 'list', '全屋水路净水器,无罐大通量,超高性价比', null);
INSERT INTO `sp_attribute` VALUES ('1864', '基本参数-品牌', '35', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1865', '技术参数-匹数', '35', 'only', 'manual', '1.5匹', null);
INSERT INTO `sp_attribute` VALUES ('1866', '能效参数-变频/定频', '35', 'only', 'manual', '定频', null);
INSERT INTO `sp_attribute` VALUES ('1867', '适用面积-制冷面积', '35', 'only', 'manual', '16-24平方米', null);
INSERT INTO `sp_attribute` VALUES ('1868', '分贝参数-室内噪音', '35', 'only', 'manual', '39分贝', null);
INSERT INTO `sp_attribute` VALUES ('1869', '规格参数-电源', '35', 'only', 'manual', '220V～/50Hz伏特', null);
INSERT INTO `sp_attribute` VALUES ('1870', '特色功能-自动清洁', '35', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('1871', '其他参数-商品特性', '35', 'only', 'manual', '自动清洁,静音,电辅加热,节能', null);
INSERT INTO `sp_attribute` VALUES ('1872', '匹数颜色', '35', 'many', 'list', '1.5匹冷暖挂机,大1匹冷暖挂机', null);
INSERT INTO `sp_attribute` VALUES ('1873', '主体参数-品牌', '361', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1874', '规格参数-包装', '361', 'only', 'manual', '礼盒装', null);
INSERT INTO `sp_attribute` VALUES ('1875', '特性参数-白酒香型', '361', 'only', 'manual', '浓香型', null);
INSERT INTO `sp_attribute` VALUES ('1876', '其他参数-储存方法', '361', 'only', 'manual', '避光', null);
INSERT INTO `sp_attribute` VALUES ('1877', '系列', '361', 'many', 'list', '【单瓶】35度500mL,【单瓶】39度500mL,【单瓶】45度500mL,【单瓶】52度500mL,【单瓶】52度交杯500mL,【单瓶】68度500mL,【整箱】35度500mL*6,【整箱】39度500mL*6,【整箱】52度500mL*6', null);
INSERT INTO `sp_attribute` VALUES ('1878', '主体参数-品牌', '362', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1879', '规格参数-包装', '362', 'only', 'manual', '箱装', null);
INSERT INTO `sp_attribute` VALUES ('1880', '特性参数-产区', '362', 'only', 'manual', '波尔多产区', null);
INSERT INTO `sp_attribute` VALUES ('1881', '主体参数-国产/进口', '363', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('1882', '规格参数-包装', '363', 'only', 'manual', '罐装', null);
INSERT INTO `sp_attribute` VALUES ('1883', '特性参数-酒精度', '363', 'only', 'manual', '4度', null);
INSERT INTO `sp_attribute` VALUES ('1884', '其他参数-储存方法', '363', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('1885', '系列', '363', 'many', 'list', '冰醇8度500ml*12罐,奥古特12度500ml*12罐,小棕金296ml*24瓶,崂山8度330ml*24罐,深夜食堂精炼1903 500ml*12罐,白啤500ml*12罐,纯生8度330ml*24罐,纯生8度500ml*12罐,经典10度500ml*12罐,经典11度330ml*24罐,经典1903（10度）330ml*24罐,银罐7度330ml*24罐,黑啤500ml*12罐', null);
INSERT INTO `sp_attribute` VALUES ('1886', '主体参数-配料', '364', 'only', 'manual', '米酒、鹿茸、鹿骨胶、龟板胶', null);
INSERT INTO `sp_attribute` VALUES ('1887', '规格参数-净含量', '364', 'only', 'manual', '500-1000ml', null);
INSERT INTO `sp_attribute` VALUES ('1888', '特性参数-酒精度', '364', 'only', 'manual', '35度以下', null);
INSERT INTO `sp_attribute` VALUES ('1889', '其他参数-储存方法', '364', 'only', 'manual', '干燥,通风,避光', null);
INSERT INTO `sp_attribute` VALUES ('1890', '主体参数-品牌', '365', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1891', '规格参数-包装', '365', 'only', 'manual', '箱装', null);
INSERT INTO `sp_attribute` VALUES ('1892', '特性参数-等级', '365', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1893', '其他参数-储存方法', '365', 'only', 'manual', '干燥,通风,避光', null);
INSERT INTO `sp_attribute` VALUES ('1894', '系列', '365', 'many', 'list', '黄酒 350ML*6瓶,黄酒.350ML*6瓶,黄酒2.55L*1瓶,黄酒350ML*1瓶,黄酒350ML*1瓶.,黄酒500ML*1瓶,黄酒500ML*1瓶.,黄酒500ML*6瓶.', null);
INSERT INTO `sp_attribute` VALUES ('1895', '主体参数-品牌', '366', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1896', '规格参数-包装', '366', 'only', 'manual', '罐装', null);
INSERT INTO `sp_attribute` VALUES ('1897', '特性参数-等级', '366', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1898', '其他参数-储存方法', '366', 'only', 'manual', '避光', null);
INSERT INTO `sp_attribute` VALUES ('1899', '主体参数-品牌', '367', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1900', '规格参数-包装', '367', 'only', 'manual', '箱装', null);
INSERT INTO `sp_attribute` VALUES ('1901', '特性参数-是否有机', '367', 'only', 'manual', '非有机', null);
INSERT INTO `sp_attribute` VALUES ('1902', '其他参数-储存方法', '367', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('1903', '规格', '367', 'many', 'list', '全脂1L*12盒,全脂200ml*24盒,脱脂1L*12盒,脱脂200ml*24盒', null);
INSERT INTO `sp_attribute` VALUES ('1904', '主体参数-国产/进口', '368', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('1905', '规格参数-包装', '368', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('1906', '特性参数-含钙量', '368', 'only', 'manual', '普通', null);
INSERT INTO `sp_attribute` VALUES ('1907', '其他参数-储存方法', '368', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('1908', '系列', '368', 'many', 'list', '原味12*205g,原味16*205g,蓝莓风味12*205g,蓝莓风味8*205g,香草风味12*205g,香草风味8*205g', null);
INSERT INTO `sp_attribute` VALUES ('1909', '基本参数-品牌', '36', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1910', '技术参数-运转模式', '36', 'only', 'manual', '普通', null);
INSERT INTO `sp_attribute` VALUES ('1911', '规格参数-电源', '36', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('1912', '其他参数-功能描述', '36', 'only', 'manual', '除烟除尘', null);
INSERT INTO `sp_attribute` VALUES ('1913', '主体参数-品牌', '370', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1914', '规格参数-包装', '370', 'only', 'manual', '箱装', null);
INSERT INTO `sp_attribute` VALUES ('1915', '其他参数-储存方法', '370', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('1916', '基本参数-是否含糖', '370', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1917', '规格', '370', 'many', 'list', '原麦早餐奶250ml×16盒,核桃早餐奶250ml×16盒,红枣早餐奶250ml×16盒,红谷早餐奶250ml×12盒,黑谷早餐奶250ml×12盒', null);
INSERT INTO `sp_attribute` VALUES ('1918', '主体参数-国产/进口', '371', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('1919', '规格参数-包装', '371', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('1920', '其他参数-储存方法', '371', 'only', 'manual', '置于阴凉干燥处', null);
INSERT INTO `sp_attribute` VALUES ('1921', '特性参数-成分特点', '371', 'only', 'manual', '高钙,高铁', null);
INSERT INTO `sp_attribute` VALUES ('1922', '系列', '371', 'many', 'list', '中老年高钙400g,中老年高钙900g,女士高钙高铁400g,学生高钙高锌400g,学生高钙高锌900g,焕轻舒活中老年900g,焕轻骨力中老年900g', null);
INSERT INTO `sp_attribute` VALUES ('1923', '主体参数-国产/进口', '372', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('1924', '规格参数-包装', '372', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('1925', '特性参数-等级', '372', 'only', 'manual', '一级', null);
INSERT INTO `sp_attribute` VALUES ('1926', '主体参数-国产/进口', '373', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('1927', '规格参数-包装', '373', 'only', 'manual', '箱装', null);
INSERT INTO `sp_attribute` VALUES ('1928', '其他参数-储存方法', '373', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('1929', '主体参数-品牌', '374', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1930', '规格参数-包装', '374', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('1931', '其他参数-储存方法', '374', 'only', 'manual', '阴凉干燥密封储存', null);
INSERT INTO `sp_attribute` VALUES ('1932', '规格', '374', 'many', 'list', '原味100条,原味20条,原味7条,奶香30条,奶香7条,无糖30条,无糖7条,特浓30条,特浓7条,特浓90条', null);
INSERT INTO `sp_attribute` VALUES ('1933', '主体参数-品牌', '375', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1934', '规格参数-包装', '375', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('1935', '其他参数-储存方法', '375', 'only', 'manual', '干燥,避光,常温', null);
INSERT INTO `sp_attribute` VALUES ('1936', '主体参数-品牌', '376', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1937', '规格参数-包装', '376', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('1938', '其他参数-是否即食', '376', 'only', 'manual', '即食', null);
INSERT INTO `sp_attribute` VALUES ('1939', '类别', '376', 'many', 'list', '即食1478克,即食1000克,即食700克,即食400克,即食1kg罐,快熟1000克,快熟700克,快熟400克', null);
INSERT INTO `sp_attribute` VALUES ('1940', '主体参数-品牌', '378', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1941', '规格参数-包装', '378', 'only', 'manual', '简装', null);
INSERT INTO `sp_attribute` VALUES ('1942', '其他参数-保存状态', '378', 'only', 'manual', '冷冻', null);
INSERT INTO `sp_attribute` VALUES ('1943', '主体参数-品牌', '379', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1944', '规格参数-包装', '379', 'only', 'manual', '简装', null);
INSERT INTO `sp_attribute` VALUES ('1945', '其他参数-品种', '379', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1946', '服务类别', '37', 'many', 'list', '先买后约家电医保卡,即买即约服务商品,1年洗1台,1年洗3台,1次洗1台,1次洗2台,1次洗3台', null);
INSERT INTO `sp_attribute` VALUES ('1947', '主体参数-品牌', '380', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1948', '规格参数-包装', '380', 'only', 'manual', '简装', null);
INSERT INTO `sp_attribute` VALUES ('1949', '特性参数-是否有机', '380', 'only', 'manual', '非有机', null);
INSERT INTO `sp_attribute` VALUES ('1950', '其他参数-烹饪建议', '380', 'only', 'manual', '炒菜', null);
INSERT INTO `sp_attribute` VALUES ('1951', '主体参数-品牌', '381', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1952', '规格参数-包装', '381', 'only', 'manual', '简装', null);
INSERT INTO `sp_attribute` VALUES ('1953', '其他参数-储存方法', '381', 'only', 'manual', '冷冻', null);
INSERT INTO `sp_attribute` VALUES ('1954', '主体参数-品牌', '382', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1955', '规格参数-包装', '382', 'only', 'manual', '礼盒装', null);
INSERT INTO `sp_attribute` VALUES ('1956', '其他参数-加工方式', '382', 'only', 'manual', '鲜蛋', null);
INSERT INTO `sp_attribute` VALUES ('1957', '主体参数-品牌', '384', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1958', '规格参数-包装', '384', 'only', 'manual', '简装', null);
INSERT INTO `sp_attribute` VALUES ('1959', '其他参数-储存方法', '384', 'only', 'manual', '冷冻', null);
INSERT INTO `sp_attribute` VALUES ('1960', '主体参数-品牌', '385', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1961', '规格参数-包装', '385', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('1962', '口味', '385', 'many', 'list', '香脆杏仁,香脆核桃,香脆腰果,高纤消化,高纤煎麸,高纤粗粮,108g,800g', null);
INSERT INTO `sp_attribute` VALUES ('1963', '主体参数-品牌', '386', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1964', '规格参数-包装', '386', 'only', 'manual', '碗装', null);
INSERT INTO `sp_attribute` VALUES ('1965', '特性参数-可可脂含量', '386', 'only', 'manual', '40%以下', null);
INSERT INTO `sp_attribute` VALUES ('1966', '其他参数-制作工艺', '386', 'only', 'manual', '非手工巧克力', null);
INSERT INTO `sp_attribute` VALUES ('1967', '主体参数-品牌', '387', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1968', '规格参数-包装', '387', 'only', 'manual', '礼盒装', null);
INSERT INTO `sp_attribute` VALUES ('1969', '特性参数-口味', '387', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1970', '其他参数-是否含糖', '387', 'only', 'manual', '无糖', null);
INSERT INTO `sp_attribute` VALUES ('1971', '主体参数-品牌', '388', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1972', '规格参数-包装', '388', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('1973', '特性参数-可可脂含量', '388', 'only', 'manual', '40%以下', null);
INSERT INTO `sp_attribute` VALUES ('1974', '主体参数-国产/进口', '389', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('1975', '规格参数-包装', '389', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('1976', '特性参数-口味', '389', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('1977', '其他参数-储存方法', '389', 'only', 'manual', '常温干燥处放置', null);
INSERT INTO `sp_attribute` VALUES ('1978', '主体参数-品牌', '390', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1979', '规格参数-包装', '390', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('1980', '其他参数-食品添加剂', '390', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('1981', '主体参数-品牌', '391', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1982', '规格参数-包装', '391', 'only', 'manual', '箱装', null);
INSERT INTO `sp_attribute` VALUES ('1983', '其他参数-储存方法', '391', 'only', 'manual', '干燥,通风,常温,恒温', null);
INSERT INTO `sp_attribute` VALUES ('1984', '主体参数-品牌', '392', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1985', '规格参数-包装', '392', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('1986', '其他参数-储存方法', '392', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('1987', '特性参数-是否添加蔗糖', '392', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('1988', '口味', '392', 'many', 'list', '56g,清爽西瓜味,清爽草莓味,香浓蜜瓜味,冰凉薄荷味,沁香蓝莓味,香橙薄荷味,柠檬香梨味,清香蜜柚味', null);
INSERT INTO `sp_attribute` VALUES ('1989', '主体参数-品牌', '393', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1990', '规格参数-包装', '393', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('1991', '特性参数-口味', '393', 'only', 'manual', '原味', null);
INSERT INTO `sp_attribute` VALUES ('1992', '其他参数-储存方法', '393', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('1993', '颜色', '393', 'many', 'list', '原味,咖喱牛肉味,大波浪鱿鱼味,大波浪鸡翅味,海苔味,烤肉味,烧烤味,番茄味,红烧肉味,红烩味,羊排味,萌萌鸡味,逗乐薯烤肉味,逗乐薯番茄味,酸奶味,青柠味,鱿鱼味,黄瓜味,104g,145g,70g', null);
INSERT INTO `sp_attribute` VALUES ('1994', '主体参数-品牌', '395', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1995', '规格参数-包装', '395', 'only', 'manual', '桶装', null);
INSERT INTO `sp_attribute` VALUES ('1996', '特性参数-加工工艺', '395', 'only', 'manual', '浸出', null);
INSERT INTO `sp_attribute` VALUES ('1997', '规格', '395', 'many', 'list', '1.8L,1.8L非转,4L,5L非转,花生油5L,葵花籽油 5L,黄金比例调和油5L', null);
INSERT INTO `sp_attribute` VALUES ('1998', '主体参数-品牌', '396', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('1999', '规格参数-包装', '396', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2000', '特性参数-等级', '396', 'only', 'manual', '特级', null);
INSERT INTO `sp_attribute` VALUES ('2001', '其他参数-储存方法', '396', 'only', 'manual', '防潮', null);
INSERT INTO `sp_attribute` VALUES ('2002', '主体参数-品牌', '397', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2003', '规格参数-包装', '397', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2004', '其他参数-储存方法', '397', 'only', 'manual', '防潮', null);
INSERT INTO `sp_attribute` VALUES ('2005', '系列', '397', 'many', 'list', '原味粉,多用途麦芯粉,手擀面,清水面,雪花粉煮制用,雪花粉蒸制用,鸡蛋面,鸡蛋麦芯面,鸡蛋龙须面,麦芯面,麦香粉,龙须面,1kg,2.5kg,5kg,800g', null);
INSERT INTO `sp_attribute` VALUES ('2006', '主体参数-品牌', '398', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2007', '规格参数-包装', '398', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2008', '其他参数-储存方法', '398', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('2009', '颜色', '398', 'many', 'list', '原味挂面,原味面,宝宝钙锌面,宝宝鸡蛋面,家用面粉,牛肉烩面,羊肉烩面,金丝蛋面,香菇面,鸡蛋挂面,鸡蛋爽滑面,鸡蛋长寿面,鸡蛋面,鸡蛋面片,龙须面,1000g,180g,236g,2500g,250g,260g,5000g,5kg,700g,900g', null);
INSERT INTO `sp_attribute` VALUES ('2010', '主体参数-类别', '399', 'only', 'manual', '桂圆', null);
INSERT INTO `sp_attribute` VALUES ('2011', '规格参数-包装', '399', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2012', '其他参数-储存方法', '399', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('2013', '主体参数-类别', '400', 'only', 'manual', '红枣', null);
INSERT INTO `sp_attribute` VALUES ('2014', '规格参数-包装', '400', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2015', '其他参数-储存方法', '400', 'only', 'manual', '干燥', null);
INSERT INTO `sp_attribute` VALUES ('2016', '主体参数-品牌', '404', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2017', '规格参数-包装', '404', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2018', '特性参数-等级', '404', 'only', 'manual', '二级', null);
INSERT INTO `sp_attribute` VALUES ('2019', '其他参数-储存方法', '404', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('2020', '类别', '404', 'many', 'list', '上品茉莉香米5KG,茉莉香米5KG', null);
INSERT INTO `sp_attribute` VALUES ('2021', '主体参数-品牌', '405', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2022', '规格参数-包装', '405', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('2023', '特性参数-加工工艺', '405', 'only', 'manual', '压榨', null);
INSERT INTO `sp_attribute` VALUES ('2024', '其他参数-资质认证', '405', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2025', '主体参数-品牌', '407', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2026', '规格参数-包装', '407', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2027', '其他参数-储存方法', '407', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('2028', '口味', '407', 'many', 'list', '红烧牛肉面 五连包,鲜虾鱼板面 五连包,香辣牛肉面 五连包,老坛酸菜牛肉面 五连包,红烧排骨面 五连包,辣卤牛肉面 五连包', null);
INSERT INTO `sp_attribute` VALUES ('2029', '主体参数-品牌', '409', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2030', '规格参数-包装', '409', 'only', 'manual', '礼盒装', null);
INSERT INTO `sp_attribute` VALUES ('2031', '特性参数-种类', '409', 'only', 'manual', '黄桃', null);
INSERT INTO `sp_attribute` VALUES ('2032', '主体参数-品牌', '410', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2033', '规格参数-包装', '410', 'only', 'manual', '罐装', null);
INSERT INTO `sp_attribute` VALUES ('2034', '其他参数-储存方法', '410', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('2035', '主体参数-品牌', '412', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2036', '规格参数-包装', '412', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('2037', '其他参数-储存方法', '412', 'only', 'manual', '存放于阴凉干燥通风处，开盖后需冷藏', null);
INSERT INTO `sp_attribute` VALUES ('2038', '规格', '412', 'many', 'list', '280g,275g,80g,260g,60g,188g,160g,210g,风味豆豉,辣三丁油辣椒,肉丝豆豉油辣椒,香辣脆油辣椒,油辣椒,植物油火锅底料,红油腐乳,风味腐乳,香辣菜', null);
INSERT INTO `sp_attribute` VALUES ('2039', '主体参数-品牌', '413', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2040', '规格参数-包装', '413', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2041', '其他参数-储存方法', '413', 'only', 'manual', '冷藏', null);
INSERT INTO `sp_attribute` VALUES ('2042', '主体参数-品牌', '414', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2043', '规格参数-包装', '414', 'only', 'manual', '桶装', null);
INSERT INTO `sp_attribute` VALUES ('2044', '特性参数-加工工艺', '414', 'only', 'manual', '酿造酱油', null);
INSERT INTO `sp_attribute` VALUES ('2045', '其他参数-储存方法', '414', 'only', 'manual', '冷藏', null);
INSERT INTO `sp_attribute` VALUES ('2046', '主体参数-国产/进口', '415', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('2047', '规格参数-包装', '415', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('2048', '其他参数-储存方法', '415', 'only', 'manual', '置于阴凉干燥处，常温保存', null);
INSERT INTO `sp_attribute` VALUES ('2049', '系列', '415', 'many', 'list', '八年老陈醋,精酿老陈醋,精酿陈醋,镇江陈醋(一级）,镇江陈醋（优级）,2250ml,500ml,800ml', null);
INSERT INTO `sp_attribute` VALUES ('2050', '主体参数-品牌', '416', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2051', '规格参数-包装', '416', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2052', '其他参数-储存方法', '416', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('2053', '规格', '416', 'many', 'list', '125g,196g,43g,186g,200ml,500ml,100g,400g,160g,200g,110g,150g,300g,500g,220g,芥末酱,火锅蘸料海鲜味,火锅蘸料美味,火锅蘸料麻辣味,火锅蘸料鲜辣味,元贞糖,火锅底料鸡汁味,火锅底料麻辣味,火锅底料麻辣味（硬板）,精研醋,火锅蘸料组合装（四联包）,料酒方瓶,乌龙醋,清油火锅底料,菌汤汤料,火锅底料,麻辣香锅,羊肉涮火锅蘸料香辣,鲜羊涮火锅蘸料原味,清汤火锅汤料,番茄火锅底料,上汤三鲜,羊肉涮香辣,鲜羊涮微辣,羊肉涮清汤,辣汤,麻辣烫,烤鱼料,菌汤火锅,干锅料,剁椒蒸鱼王,寿司醋,十年火锅底料,寿司本造鲜,清油火锅,火锅底料清汤', null);
INSERT INTO `sp_attribute` VALUES ('2054', '主体参数-品牌', '417', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2055', '规格参数-包装', '417', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2056', '其他参数-储存方法', '417', 'only', 'manual', '常温', null);
INSERT INTO `sp_attribute` VALUES ('2057', '主体参数-类别', '418', 'only', 'manual', '有芯卷纸', null);
INSERT INTO `sp_attribute` VALUES ('2058', '规格参数-层数', '418', 'only', 'manual', '三层', null);
INSERT INTO `sp_attribute` VALUES ('2059', '特性参数-香型', '418', 'only', 'manual', '无味', null);
INSERT INTO `sp_attribute` VALUES ('2060', '规格', '418', 'many', 'list', '3层*245段*10卷,3层*245段*24卷', null);
INSERT INTO `sp_attribute` VALUES ('2061', '主体参数-商品名称', '41', 'only', 'manual', '西门子洗衣机XQG80-WD12G4681W', null);
INSERT INTO `sp_attribute` VALUES ('2062', '基本参数-水温调节范围', '41', 'only', 'manual', '冷水~90℃', null);
INSERT INTO `sp_attribute` VALUES ('2063', '功能参数-童锁功能', '41', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2064', '规格参数-产品重量', '41', 'only', 'manual', '78千克', null);
INSERT INTO `sp_attribute` VALUES ('2065', '样式', '41', 'many', 'list', '7.5公斤 1400高转速 空气冷凝,8公斤 1400高转速 变频,8公斤 1400高转速 空气冷凝,8公斤 热风除菌 变频,白色,银色', null);
INSERT INTO `sp_attribute` VALUES ('2066', '主体参数-品牌', '420', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2067', '规格参数-层数', '420', 'only', 'manual', '三层', null);
INSERT INTO `sp_attribute` VALUES ('2068', '特性参数-香型', '420', 'only', 'manual', '无味', null);
INSERT INTO `sp_attribute` VALUES ('2069', '规格', '420', 'many', 'list', '136抽*6包,140抽*18包,140抽*24包,140抽*3包,140抽*8包', null);
INSERT INTO `sp_attribute` VALUES ('2070', '主体参数-品牌', '421', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2071', '规格参数-层数', '421', 'only', 'manual', '三层', null);
INSERT INTO `sp_attribute` VALUES ('2072', '特性参数-香型', '421', 'only', 'manual', '无味', null);
INSERT INTO `sp_attribute` VALUES ('2073', '主体参数-品牌', '422', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2074', '规格参数-包数', '422', 'only', 'manual', '2包(卷)', null);
INSERT INTO `sp_attribute` VALUES ('2075', '特性参数-敏感人群', '422', 'only', 'manual', '普通产品', null);
INSERT INTO `sp_attribute` VALUES ('2076', '规格', '422', 'many', 'list', '75张*2卷,厨房湿巾40片', null);
INSERT INTO `sp_attribute` VALUES ('2077', '主体-品牌', '423', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2078', '规格参数-层数', '423', 'only', 'manual', '其它', null);
INSERT INTO `sp_attribute` VALUES ('2079', '特性参数-香型', '423', 'only', 'manual', '无味', null);
INSERT INTO `sp_attribute` VALUES ('2080', '主体参数-类别', '424', 'only', 'manual', '湿巾纸', null);
INSERT INTO `sp_attribute` VALUES ('2081', '规格参数-单包片数', '424', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2082', '特性参数-香型', '424', 'only', 'manual', '无味', null);
INSERT INTO `sp_attribute` VALUES ('2083', '功能参数-功能', '424', 'only', 'manual', '润肤', null);
INSERT INTO `sp_attribute` VALUES ('2084', '规格', '424', 'many', 'list', '婴儿护肤（80片*1包）,婴儿湿巾抽纸组合装,婴儿绵柔（150抽*18包）,婴儿绵柔（150抽*6包）,手口可用（20片*1包）,手口可用（80片*1包）,远离红屁屁（80片*1包）', null);
INSERT INTO `sp_attribute` VALUES ('2085', '主体参数-品牌', '425', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2086', '功能参数-香型', '425', 'only', 'manual', '香味', null);
INSERT INTO `sp_attribute` VALUES ('2087', '规格参数-规格', '425', 'only', 'manual', '3kg以上升', null);
INSERT INTO `sp_attribute` VALUES ('2088', '特性参数-适用范围', '425', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2089', '主体参数-品牌', '426', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2090', '功能参数-香型', '426', 'only', 'manual', '有香味', null);
INSERT INTO `sp_attribute` VALUES ('2091', '规格参数-包装', '426', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('2092', '特性参数-适用范围', '426', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2093', '规格', '426', 'many', 'list', '1.2kg,2.38kg,508g', null);
INSERT INTO `sp_attribute` VALUES ('2094', '主体参数-品牌', '428', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2095', '功能参数-功能类别', '428', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2096', '特性参数-香型', '428', 'only', 'manual', '有香味', null);
INSERT INTO `sp_attribute` VALUES ('2097', '规格参数-包装', '428', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('2098', '规格', '428', 'many', 'list', '1290g,2000g,500g', null);
INSERT INTO `sp_attribute` VALUES ('2099', '主体参数-品牌', '429', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2100', '功能参数-适用人群', '429', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2101', '规格参数-香型', '429', 'only', 'manual', '无味', null);
INSERT INTO `sp_attribute` VALUES ('2102', '特性参数-适用场景', '429', 'only', 'manual', '客厅,其他,卫浴,厨房,地面,家具,衣物', null);
INSERT INTO `sp_attribute` VALUES ('2103', '规格', '429', 'many', 'list', '1.15L*2,1.5L*2,1.8L*2', null);
INSERT INTO `sp_attribute` VALUES ('2104', '主体参数-商品名称', '42', 'only', 'manual', '海尔洗衣机XQB55-M12699X', null);
INSERT INTO `sp_attribute` VALUES ('2105', '特性参数-DD电机', '42', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('2106', '功能参数-洗衣程序', '42', 'only', 'manual', '洗涤、漂洗、脱水、桶干燥、常用、超净洗、冲浪洗、速洗', null);
INSERT INTO `sp_attribute` VALUES ('2107', '规格参数-洗净比', '42', 'only', 'manual', '0.8', null);
INSERT INTO `sp_attribute` VALUES ('2108', '公斤数', '42', 'many', 'list', '5.5公斤漂甩二合一,6.5公斤漂甩二合一,7.5公斤漂甩二合一,7公斤漂甩二合一', null);
INSERT INTO `sp_attribute` VALUES ('2109', '主体-品牌', '430', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2110', '特性参数-状态', '430', 'only', 'manual', '液体', null);
INSERT INTO `sp_attribute` VALUES ('2111', '规格参数-包装', '430', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('2112', '香型', '430', 'many', 'list', '强效版清香,柠檬草香,淡雅清新,除菌版淡雅清香,除菌版草本,500g*2双瓶装,600g*2双瓶装,600g*4瓶装 送洁厕块*2,600g瓶装,750g*2双瓶装,750g*4瓶装 送洁厕块*2', null);
INSERT INTO `sp_attribute` VALUES ('2113', '主体-品牌', '431', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2114', '规格参数-尺寸', '431', 'only', 'manual', '47*27*24厘米', null);
INSERT INTO `sp_attribute` VALUES ('2115', '颜色', '431', 'many', 'list', '分离桶【极速杆+2个拖头】', null);
INSERT INTO `sp_attribute` VALUES ('2116', '主体参数-品牌', '432', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2117', '规格参数-规格', '432', 'only', 'manual', '11×7cm×2片入', null);
INSERT INTO `sp_attribute` VALUES ('2118', '主体-品牌', '433', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2119', '规格参数-容量', '433', 'only', 'manual', '15升', null);
INSERT INTO `sp_attribute` VALUES ('2120', '规格数量', '433', 'many', 'list', '45x55厘米x90只,50x60厘米x60只', null);
INSERT INTO `sp_attribute` VALUES ('2121', '主体参数-品牌', '434', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2122', '功能参数-保质期', '434', 'only', 'manual', '3年数', null);
INSERT INTO `sp_attribute` VALUES ('2123', '规格参数-尺寸', '434', 'only', 'manual', '25×16.5×0.5厘米', null);
INSERT INTO `sp_attribute` VALUES ('2124', '数量', '434', 'many', 'list', '背心型特大号100只,背心型大号140只,背心型中号200只,抽取式大号50只,抽取式中号70只,点断式大号150只,点断式中号200只,点断式小号250只,点断式大号80只,点断式中号100只,点断式小号120只,点断式2合1特惠装,点断式3合1超值装,密实袋', null);
INSERT INTO `sp_attribute` VALUES ('2125', '主体参数-品牌', '435', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2126', '功能参数-保质期', '435', 'only', 'manual', '5年数', null);
INSERT INTO `sp_attribute` VALUES ('2127', '特性参数-耐热温度', '435', 'only', 'manual', '-60℃-100℃', null);
INSERT INTO `sp_attribute` VALUES ('2128', '规格参数-重量', '435', 'only', 'manual', '100克', null);
INSERT INTO `sp_attribute` VALUES ('2129', '规格', '435', 'many', 'list', '20cm×20m,30cmx100m,30cmx30mx2卷,30cm×20m,30cm×30m', null);
INSERT INTO `sp_attribute` VALUES ('2130', '主体-类别', '436', 'only', 'manual', '擦玻璃器', null);
INSERT INTO `sp_attribute` VALUES ('2131', '规格参数-尺寸', '436', 'only', 'manual', '81厘米', null);
INSERT INTO `sp_attribute` VALUES ('2132', '主体参数-品牌', '437', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2133', '功能参数-功能', '437', 'only', 'manual', '防尘', null);
INSERT INTO `sp_attribute` VALUES ('2134', '特性参数-适用人群', '437', 'only', 'manual', '成人', null);
INSERT INTO `sp_attribute` VALUES ('2135', '规格参数-尺寸', '437', 'only', 'manual', '见图·厘米', null);
INSERT INTO `sp_attribute` VALUES ('2136', '主体参数-品牌', '438', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2137', '规格参数-尺寸', '438', 'only', 'manual', '10*13厘米', null);
INSERT INTO `sp_attribute` VALUES ('2138', '系列', '438', 'many', 'list', '100片盒装,10片装,30片礼盒装,50片礼盒装,参姜30片礼盒装,暖宫贴3片装,暖手袋30片礼盒装,暖足30片礼盒装,益母草60片礼盒装,芦荟30片礼盒装,远红外30片礼盒装,迷你贴30片礼盒装', null);
INSERT INTO `sp_attribute` VALUES ('2139', '主体参数-商品名称', '43', 'only', 'manual', '海尔滚筒洗衣机EG8012B29WC', null);
INSERT INTO `sp_attribute` VALUES ('2140', '特性参数-变频', '43', 'only', 'manual', '变频', null);
INSERT INTO `sp_attribute` VALUES ('2141', '功能参数-童锁功能', '43', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2142', '规格参数-产品重量', '43', 'only', 'manual', '70千克', null);
INSERT INTO `sp_attribute` VALUES ('2143', '系列', '43', 'many', 'list', '10公斤变频滚筒,7公斤变频滚筒,8公斤变频滚筒,8公斤洗烘一体', null);
INSERT INTO `sp_attribute` VALUES ('2144', '主体-品牌', '440', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2145', '规格参数-型号', '440', 'only', 'manual', 'KC20BK1', null);
INSERT INTO `sp_attribute` VALUES ('2146', '颜色', '440', 'many', 'list', 'KC20BK1晨曦白,KC20BK1星空黑,KC16BK1晨曦白,KC16BK1星空黑', null);
INSERT INTO `sp_attribute` VALUES ('2147', '主体参数-品牌', '441', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2148', '规格参数-直径', '441', 'only', 'manual', '7厘米', null);
INSERT INTO `sp_attribute` VALUES ('2149', '特性参数-保温功能', '441', 'only', 'manual', '保温', null);
INSERT INTO `sp_attribute` VALUES ('2150', '颜色', '441', 'many', 'list', '380ml旖旎红,380ml梦幻蓝,380ml魔力黑,380ml甜蜜粉,450ml旖旎红,450ml梦幻蓝,450ml魔力黑,450ml甜蜜粉', null);
INSERT INTO `sp_attribute` VALUES ('2151', '主体参数-类别', '442', 'only', 'manual', '储物箱', null);
INSERT INTO `sp_attribute` VALUES ('2152', '规格参数-容量', '442', 'only', 'manual', '58升', null);
INSERT INTO `sp_attribute` VALUES ('2153', '特色参数-是否带滑轮', '442', 'only', 'manual', '带滑轮', null);
INSERT INTO `sp_attribute` VALUES ('2154', '颜色', '442', 'many', 'list', '彩色,悦巧彩色,米桶,透明,20斤,35L,55L,58L,80L', null);
INSERT INTO `sp_attribute` VALUES ('2155', '主体参数-品牌', '443', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2156', '特性参数-类别', '443', 'only', 'manual', '晾衣架', null);
INSERT INTO `sp_attribute` VALUES ('2157', '规格参数-规格', '443', 'only', 'manual', 'MM', null);
INSERT INTO `sp_attribute` VALUES ('2158', '颜色', '443', 'many', 'list', 'V3双杆伸缩（香槟金）+不安装,V6香槟金+led,Q6银色+led,X6香槟金+led,V8香槟金+led+杀菌消毒,Q8银色+led+杀菌消毒,X8香槟金+led+杀菌消毒,V10香槟金+led+循环风干+杀菌消毒,Q10银色+led+循环风干+杀菌消毒,X10香槟金+led+双风机风干+杀菌消毒+负离子,V12香槟金+led+循环烘干+杀菌消毒,Q12银色+led+循环烘干+杀菌消毒,X12香槟金+led+双机烘干+杀菌+负离子+手机APP,X12W玫瑰金+LED+双机风干烘干+消毒+负离子+阿里智能,J6玫瑰金+led,J8玫瑰金+led+杀菌消毒,J10玫瑰金+led+循环风干+杀菌消毒,J12玫瑰金+led+循环烘干+杀菌消毒', null);
INSERT INTO `sp_attribute` VALUES ('2159', '主体参数-品牌', '444', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2160', '规格参数-国产/进口', '444', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('2161', '系列', '444', 'many', 'list', '10包/15㎡,1kg/20包/26㎡,2kg/40包/60㎡,3年免晒/快除醛,快捷检测 易操作,红色叹炭鸟', null);
INSERT INTO `sp_attribute` VALUES ('2162', '主体参数-品牌', '446', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2163', '规格参数-容量', '446', 'only', 'manual', '180毫升', null);
INSERT INTO `sp_attribute` VALUES ('2164', '特性参数-是否一次性使用', '446', 'only', 'manual', '非一次性使用', null);
INSERT INTO `sp_attribute` VALUES ('2165', '其他参数-适用场景', '446', 'only', 'manual', '客厅,餐桌,熬夜/加班,出游,厨房', null);
INSERT INTO `sp_attribute` VALUES ('2166', '颜色', '446', 'many', 'list', '1300ml立式长,1600ml长,2600ml长,360ml长,1000ml长,700ml圆,300ml圆,850ml长,1000ml带格挡,4500ml长,1300ml立式,2000ml长,1400ml圆,600ml长,600ml方,470ml长,1000ml长A,860ml方,180ml*2长,800ml长带格挡,600ml圆,3900ml长,350ml长,800ml长', null);
INSERT INTO `sp_attribute` VALUES ('2167', '主体-类别', '450', 'only', 'manual', '被子', null);
INSERT INTO `sp_attribute` VALUES ('2168', '材质-适用季节', '450', 'only', 'manual', '春秋被,冬被', null);
INSERT INTO `sp_attribute` VALUES ('2169', '规格-款式细节', '450', 'only', 'manual', '见详情', null);
INSERT INTO `sp_attribute` VALUES ('2170', '特色-适用床尺寸', '450', 'only', 'manual', '1.8m床', null);
INSERT INTO `sp_attribute` VALUES ('2171', '颜色', '450', 'many', 'list', '羊羔绒驼色,羊羔绒米白,150x200cm/5斤,180x220cm/6斤,200x230cm/7斤', null);
INSERT INTO `sp_attribute` VALUES ('2172', '主体参数-品牌', '451', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2173', '特性参数-图案类型', '451', 'only', 'manual', '纯色', null);
INSERT INTO `sp_attribute` VALUES ('2174', '规格参数-功能分类', '451', 'only', 'manual', '助眠枕', null);
INSERT INTO `sp_attribute` VALUES ('2175', '颜色', '451', 'many', 'list', '双边（高枕）,双边（中枕）,双边（低枕）,【一只装】48*74cm', null);
INSERT INTO `sp_attribute` VALUES ('2176', '主体参数-品牌', '454', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2177', '特性参数-家装风格', '454', 'only', 'manual', '简约风', null);
INSERT INTO `sp_attribute` VALUES ('2178', '规格参数-适用床尺寸', '454', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2179', '颜色', '454', 'many', 'list', '粉色,蓝色,灰色,驼色,酒红色,紫色,150×200cm【约4.0斤】,180×200cm【约重4.8斤】,200×230cm【约重5.8斤】', null);
INSERT INTO `sp_attribute` VALUES ('2180', '主体-品牌', '456', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2181', '功能参数-适应犬种', '456', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2182', '规格参数-尺寸', '456', 'only', 'manual', '29*12*21厘米', null);
INSERT INTO `sp_attribute` VALUES ('2183', '口味', '456', 'many', 'list', '牛肉鱼油口味*1,鸡肉果蔬口味*1,牛肉钙奶口味*1,混合口味*3', null);
INSERT INTO `sp_attribute` VALUES ('2184', '主体-品牌', '457', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2185', '功能参数-适应犬种', '457', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2186', '规格参数-尺寸', '457', 'only', 'manual', '20', null);
INSERT INTO `sp_attribute` VALUES ('2187', '主体参数-品牌', '459', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2188', '规格参数-毛重', '459', 'only', 'manual', '0.2千克', null);
INSERT INTO `sp_attribute` VALUES ('2189', '功能参数-使用方法', '459', 'only', 'manual', '内服', null);
INSERT INTO `sp_attribute` VALUES ('2190', '特性参数-形态', '459', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2191', '主体参数-品牌', '460', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2192', '功能参数-功能分类', '460', 'only', 'manual', '除蚤灭蚤,杀螨除菌,杀菌除臭,消炎止痒,防脱', null);
INSERT INTO `sp_attribute` VALUES ('2193', '规格参数-包装', '460', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('2194', '主体参数-品牌', '461', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2195', '功能参数-适用宠物', '461', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2196', '规格参数-包装', '461', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2197', '颜色', '461', 'many', 'list', '大红-胸背带式印花牵引绳,粉色-胸背带式印花牵引绳,天蓝色-胸背带式印花牵引绳,咖啡色-胸背带式印花牵引绳,黄色-胸背带式印花牵引绳,黑色-胸背带式印花牵引绳,深蓝色-胸背带式印花牵引绳,紫色-胸背带式印花牵引绳,玫红色-胸背带式印花牵引绳,草绿色-胸背带式印花牵引绳,橙色-胸背带式印花牵引绳,光秃天使牵引粉色,光秃天使牵引大红色,光秃天使牵引天蓝色,光秃天使牵引黄色,光秃天使牵引紫色,彩色-胸背带式牵引绳,带宽1.0cm,带款1.5cm', null);
INSERT INTO `sp_attribute` VALUES ('2198', '主体参数-品牌', '462', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2199', '特性参数-生产许可证', '462', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2200', '规格参数-容量', '462', 'only', 'manual', '5L', null);
INSERT INTO `sp_attribute` VALUES ('2201', '种类', '462', 'many', 'list', '膨润土猫砂,豆腐猫砂,松木猫砂', null);
INSERT INTO `sp_attribute` VALUES ('2202', '主体参数-商品名称', '463', 'only', 'manual', '九阳 电饭煲JYF-40FE65', null);
INSERT INTO `sp_attribute` VALUES ('2203', '功能-加热方式', '463', 'only', 'manual', '底盘加热', null);
INSERT INTO `sp_attribute` VALUES ('2204', '材质-内胆材质', '463', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2205', '外观-颜色', '463', 'only', 'manual', '棕色', null);
INSERT INTO `sp_attribute` VALUES ('2206', '规格-容量', '463', 'only', 'manual', '4L', null);
INSERT INTO `sp_attribute` VALUES ('2207', '电源参数-额定功率', '463', 'only', 'manual', '860瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2208', '颜色', '463', 'many', 'list', '土灶原釜（咖）,土灶原釜（粽）,土灶原釜（香槟金）,土灶铁釜（香槟金）,大火铜匠厚釜（褐）,智能柴火煲（咖）,经典六万好评,轻奢IH铁釜,铜匠厚釜（黑）', null);
INSERT INTO `sp_attribute` VALUES ('2209', '主体-商品名称', '464', 'only', 'manual', '美的（Midea）WCS5025 一锅双胆 立体加压智能预约微电脑式5L电压力锅 黑色', null);
INSERT INTO `sp_attribute` VALUES ('2210', '外观/材质-颜色', '464', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('2211', '功能参数-预约功能', '464', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2212', '智能类型-控制方式', '464', 'only', 'manual', '微电脑按键式', null);
INSERT INTO `sp_attribute` VALUES ('2213', '规格参数-容量', '464', 'only', 'manual', '5L', null);
INSERT INTO `sp_attribute` VALUES ('2214', '颜色', '464', 'many', 'list', '5L微电脑双胆,5L浓香翻滚双胆,5L经典双胆,5L酒红色双胆,5L韩式双胆', null);
INSERT INTO `sp_attribute` VALUES ('2215', '主体-商品名称', '465', 'only', 'manual', '美的（Midea)SN2105T大功率多功能电磁炉', null);
INSERT INTO `sp_attribute` VALUES ('2216', '外观/材质-面板材质', '465', 'only', 'manual', '微晶面板', null);
INSERT INTO `sp_attribute` VALUES ('2217', '火力档位-火力档位', '465', 'only', 'manual', '8档', null);
INSERT INTO `sp_attribute` VALUES ('2218', '控制方式-控制方式', '465', 'only', 'manual', '触控式', null);
INSERT INTO `sp_attribute` VALUES ('2219', '功能-防水功能', '465', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2220', '规格参数-能效等级', '465', 'only', 'manual', '3级', null);
INSERT INTO `sp_attribute` VALUES ('2221', '外观', '465', 'many', 'list', '匀火纤薄,纤薄款,经典热销,经典爆款,蓝魅款', null);
INSERT INTO `sp_attribute` VALUES ('2222', '主体-商品名称', '466', 'only', 'manual', '九阳豆浆机 DJ13B-D08D 全自动家用五谷免滤豆浆机', null);
INSERT INTO `sp_attribute` VALUES ('2223', '外观/材质-颜色', '466', 'only', 'manual', '白色', null);
INSERT INTO `sp_attribute` VALUES ('2224', '功能参数-保温功能', '466', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2225', '技术参数-研磨技术', '466', 'only', 'manual', '精磨器', null);
INSERT INTO `sp_attribute` VALUES ('2226', '规格参数-容量', '466', 'only', 'manual', '1.3L', null);
INSERT INTO `sp_attribute` VALUES ('2227', '颜色', '466', 'many', 'list', '免滤畅销7年,全钢小容量,全钢破壁3.0,升级免滤3.0,破壁轻奢款,约时间约温度,高端破壁4.0', null);
INSERT INTO `sp_attribute` VALUES ('2228', '主体-品牌', '467', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2229', '功能参数-自动断电', '467', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2230', '外观-结构', '467', 'only', 'manual', '一体式', null);
INSERT INTO `sp_attribute` VALUES ('2231', '内胆-内胆材质', '467', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2232', '规格参数-净重', '467', 'only', 'manual', '2.5千克', null);
INSERT INTO `sp_attribute` VALUES ('2233', '型号', '467', 'many', 'list', '4升电热锅,4升韩式锅,5.5升鸳鸯火锅,5升电火锅,5升鸳鸯锅,6升大容量,6升电火锅,7升大容量', null);
INSERT INTO `sp_attribute` VALUES ('2234', '主体-商品名称', '468', 'only', 'manual', '利仁(Liven)2018H 电饼铛', null);
INSERT INTO `sp_attribute` VALUES ('2235', '功能参数-电饼铛功能', '468', 'only', 'manual', '烤', null);
INSERT INTO `sp_attribute` VALUES ('2236', '规格参数-烤盘深度', '468', 'only', 'manual', '15毫米', null);
INSERT INTO `sp_attribute` VALUES ('2237', '版式', '468', 'many', 'list', '30CM橙色电脑版,侧开系列液晶显示,炫彩系列可定时,烤盘可拆三挡火力,经典爆款自动恒温,速热系列双盘可拆', null);
INSERT INTO `sp_attribute` VALUES ('2238', '主体-商品名称', '469', 'only', 'manual', '美的电水壶 WH517E2g', null);
INSERT INTO `sp_attribute` VALUES ('2239', '外观/材质-颜色', '469', 'only', 'manual', '蓝色', null);
INSERT INTO `sp_attribute` VALUES ('2240', '功能参数-保温功能', '469', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2241', '技术参数-温控器类型', '469', 'only', 'manual', '国产温控器', null);
INSERT INTO `sp_attribute` VALUES ('2242', '规格参数-容量', '469', 'only', 'manual', '1.6-2L', null);
INSERT INTO `sp_attribute` VALUES ('2243', '颜色', '469', 'many', 'list', '1.5L红玉,1.7l初见,1.7L情书,1.7L白玉,1.7L糖果,1.7L蓝玉', null);
INSERT INTO `sp_attribute` VALUES ('2244', '主体-厨房小家电类型', '470', 'only', 'manual', '电蒸锅', null);
INSERT INTO `sp_attribute` VALUES ('2245', '功能参数-产品功能', '470', 'only', 'manual', '涮,火锅,炖,焖,煮,蒸', null);
INSERT INTO `sp_attribute` VALUES ('2246', '控制调节-控制方式', '470', 'only', 'manual', '微电脑式', null);
INSERT INTO `sp_attribute` VALUES ('2247', '蒸笼规格-层数', '470', 'only', 'manual', '三层', null);
INSERT INTO `sp_attribute` VALUES ('2248', '材质-蒸笼材质', '470', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('2249', '技术规格-额定功率', '470', 'only', 'manual', '1500瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2250', '颜色', '470', 'many', 'list', '10L大容量,一机多能', null);
INSERT INTO `sp_attribute` VALUES ('2251', '主体-商品名称', '471', 'only', 'manual', '荣事达YSH1860养生壶', null);
INSERT INTO `sp_attribute` VALUES ('2252', '外观/材质-颜色', '471', 'only', 'manual', '黑色+金色', null);
INSERT INTO `sp_attribute` VALUES ('2253', '功能参数-保温功能', '471', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2254', '技术参数-温控器类型', '471', 'only', 'manual', '国产温控器', null);
INSERT INTO `sp_attribute` VALUES ('2255', '规格参数-容量', '471', 'only', 'manual', '1.8L', null);
INSERT INTO `sp_attribute` VALUES ('2256', '颜色', '471', 'many', 'list', '1.2L套装壶,1.5L背光源面板,1.7L背光源面板,1.8L快速加热,1.8L无极旋钮,1.8L智能APP,1.8L玻璃面板,2.0L液晶面板', null);
INSERT INTO `sp_attribute` VALUES ('2257', '主体-厨房小家电类型', '472', 'only', 'manual', '电陶炉', null);
INSERT INTO `sp_attribute` VALUES ('2258', '功能参数-定时功能', '472', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2259', '规格参数-面板材质', '472', 'only', 'manual', '黑晶面板', null);
INSERT INTO `sp_attribute` VALUES ('2260', '东果DUVOG电陶炉', '472', 'many', 'list', 'DG-EC2401电陶炉,DG-EC2601电陶炉,DG-EC2801电陶炉,2400W烧烤板,2600W-2800W烧烤板,DG-EC10双灶电陶炉', null);
INSERT INTO `sp_attribute` VALUES ('2261', '主体-品牌', '475', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2262', '功能-电热饭盒功能', '475', 'only', 'manual', '加热,蒸煮,真空保鲜,冷藏保鲜', null);
INSERT INTO `sp_attribute` VALUES ('2263', '规格参数-层数', '475', 'only', 'manual', '3层', null);
INSERT INTO `sp_attribute` VALUES ('2264', '材质-内胆材质', '475', 'only', 'manual', '不锈钢内胆', null);
INSERT INTO `sp_attribute` VALUES ('2265', '功能参数-控制方式', '475', 'only', 'manual', '机械式', null);
INSERT INTO `sp_attribute` VALUES ('2266', '技术规格-额定功率', '475', 'only', 'manual', '270瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2267', '容量', '475', 'many', 'list', '1.2L陶瓷内胆,1.3L升级保鲜,1.3L高效热饭,1.4L双层紫红,1.5L双层等量,2.0L三层加热,2.0L三层紫黑,2.0L三重保鲜,2.0L不锈钢胆', null);
INSERT INTO `sp_attribute` VALUES ('2268', '主体-品牌', '476', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2269', '功能参数-控制方式', '476', 'only', 'manual', '微电脑式', null);
INSERT INTO `sp_attribute` VALUES ('2270', '外观-外观材质', '476', 'only', 'manual', '其它', null);
INSERT INTO `sp_attribute` VALUES ('2271', '内胆-内胆数量', '476', 'only', 'manual', '单胆', null);
INSERT INTO `sp_attribute` VALUES ('2272', '规格参数-净重', '476', 'only', 'manual', '4.7千克', null);
INSERT INTO `sp_attribute` VALUES ('2273', '颜色', '476', 'many', 'list', '健康有道,均衡密炖,天然养生,红陶内胆,营养炖健康,隔水炖锅', null);
INSERT INTO `sp_attribute` VALUES ('2274', '主体-商品名称', '478', 'only', 'manual', '九阳（Joyoung）料理机JYL-C91T', null);
INSERT INTO `sp_attribute` VALUES ('2275', '功能参数-档位', '478', 'only', 'manual', '1档', null);
INSERT INTO `sp_attribute` VALUES ('2276', '规格参数-果汁杯容量', '478', 'only', 'manual', '600毫升', null);
INSERT INTO `sp_attribute` VALUES ('2277', '颜色', '478', 'many', 'list', '双杯送滤网,多功能三杯,多功能四杯（大容量）,多能双杯好洗,实惠经典单杯,超微精磨三杯', null);
INSERT INTO `sp_attribute` VALUES ('2278', '主体-商品名称', '479', 'only', 'manual', '苏泊尔电压力锅CYSB50YC6B-100金属色', null);
INSERT INTO `sp_attribute` VALUES ('2279', '外观/材质-颜色', '479', 'only', 'manual', '黑色', null);
INSERT INTO `sp_attribute` VALUES ('2280', '功能参数-预约功能', '479', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2281', '智能类型-控制方式', '479', 'only', 'manual', '微电脑按键式', null);
INSERT INTO `sp_attribute` VALUES ('2282', '规格参数-容量', '479', 'only', 'manual', '5L', null);
INSERT INTO `sp_attribute` VALUES ('2283', '颜色', '479', 'many', 'list', 'WIFI智能,一锅双胆,双球釜味觉大师,智能控压,智能球斧,精准温控,紫色帅锅', null);
INSERT INTO `sp_attribute` VALUES ('2284', '主体参数-商品名称', '47', 'only', 'manual', '艾思玛(AisimaRo) XPB42-688蓝色 4.2kg单桶小型迷你洗衣机 半自动婴儿小洗衣机 适合单身贵族 单缸', null);
INSERT INTO `sp_attribute` VALUES ('2285', '基本参数-变频', '47', 'only', 'manual', '非变频', null);
INSERT INTO `sp_attribute` VALUES ('2286', '功能参数-洗衣程序', '47', 'only', 'manual', '标准', null);
INSERT INTO `sp_attribute` VALUES ('2287', '规格参数-洗净比', '47', 'only', 'manual', '0.81', null);
INSERT INTO `sp_attribute` VALUES ('2288', '主体参数-商品名称', '482', 'only', 'manual', '格兰仕微波炉P70F20CN3P-N9(W0)', null);
INSERT INTO `sp_attribute` VALUES ('2289', '类别-类别', '482', 'only', 'manual', '微波炉', null);
INSERT INTO `sp_attribute` VALUES ('2290', '底盘-底盘类型', '482', 'only', 'manual', '平板', null);
INSERT INTO `sp_attribute` VALUES ('2291', '容量-容量', '482', 'only', 'manual', '20升', null);
INSERT INTO `sp_attribute` VALUES ('2292', '功能-功能', '482', 'only', 'manual', '微波,烧烤,其他', null);
INSERT INTO `sp_attribute` VALUES ('2293', '开门设置-开门方式', '482', 'only', 'manual', '侧拉式', null);
INSERT INTO `sp_attribute` VALUES ('2294', '控制方式-控制方式', '482', 'only', 'manual', '微电脑式', null);
INSERT INTO `sp_attribute` VALUES ('2295', '内胆材质-内胆材质', '482', 'only', 'manual', '纳米银内胆', null);
INSERT INTO `sp_attribute` VALUES ('2296', '能效参数-国家能效等级', '482', 'only', 'manual', '2级', null);
INSERT INTO `sp_attribute` VALUES ('2297', '规格参数-腔体尺寸(高*宽*深', '482', 'only', 'manual', '180*315*329毫米', null);
INSERT INTO `sp_attribute` VALUES ('2298', '颜色', '482', 'many', 'list', '20L-电脑版中国红,32L-紫色电烤箱,下拉门R6K(R9),光波烧烤B8,家用机械转盘G5(W0),平板烧烤DG(W0),手机APPC2(C0),手机APPC2(C3)', null);
INSERT INTO `sp_attribute` VALUES ('2299', '主体参数-品牌', '484', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2300', '加热方式-普通加热', '484', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2301', '控制范围-温控范围', '484', 'only', 'manual', '0℃-220℃度', null);
INSERT INTO `sp_attribute` VALUES ('2302', '功能参数-旋转烤叉', '484', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2303', '商品材质-外观材质', '484', 'only', 'manual', '其它', null);
INSERT INTO `sp_attribute` VALUES ('2304', '规格参数-净重', '484', 'only', 'manual', '7千克', null);
INSERT INTO `sp_attribute` VALUES ('2305', '型号', '484', 'many', 'list', '10升迷你烤箱,32L性价比推荐,360度旋转烤叉,38升WIFI智能,时尚粉色烘焙,独立温控银色,红色热销爆款', null);
INSERT INTO `sp_attribute` VALUES ('2306', '主体-商品名称', '486', 'only', 'manual', '九阳（Joyoung）料理机JYL-C50T', null);
INSERT INTO `sp_attribute` VALUES ('2307', '功能参数-操作方式', '486', 'only', 'manual', '按键式', null);
INSERT INTO `sp_attribute` VALUES ('2308', '规格参数-刀头数量', '486', 'only', 'manual', '2个', null);
INSERT INTO `sp_attribute` VALUES ('2309', '包装参数-毛重', '486', 'only', 'manual', '2.25千克', null);
INSERT INTO `sp_attribute` VALUES ('2310', '电源参数-额定功率', '486', 'only', 'manual', '250瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2311', '其他-适用人数', '486', 'only', 'manual', '3人以下', null);
INSERT INTO `sp_attribute` VALUES ('2312', '颜色', '486', 'many', 'list', '双杯送滤网,多功能三杯,多功能四杯（大容量）,多能双杯好洗,实惠经典单杯,超微精磨三杯', null);
INSERT INTO `sp_attribute` VALUES ('2313', '主体参数-品牌', '488', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2314', '加热方式-单发热管加热', '488', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2315', '功能参数-是否保温', '488', 'only', 'manual', '保温', null);
INSERT INTO `sp_attribute` VALUES ('2316', '商品材质-外观材质', '488', 'only', 'manual', '不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('2317', '规格参数-产品尺寸(高*宽*深', '488', 'only', 'manual', '235*368*320mm毫米', null);
INSERT INTO `sp_attribute` VALUES ('2318', '功能', '488', 'many', 'list', '全钢撒果料,彩钢高颜值,智能WIFI,智能撒果料,爆款推荐,粉色撒果料,粉色爆款,高性价比,高端热风系统,高端热风驱动', null);
INSERT INTO `sp_attribute` VALUES ('2319', '主体-厨房小家电类型', '489', 'only', 'manual', '空气炸锅', null);
INSERT INTO `sp_attribute` VALUES ('2320', '功能参数-产品功能', '489', 'only', 'manual', '炸', null);
INSERT INTO `sp_attribute` VALUES ('2321', '规格参数-控制方式', '489', 'only', 'manual', '微电脑式', null);
INSERT INTO `sp_attribute` VALUES ('2322', '主体参数-商品名称', '48', 'only', 'manual', 'TP80-JDS903', null);
INSERT INTO `sp_attribute` VALUES ('2323', '基本参数-国家能效等级', '48', 'only', 'manual', '3级', null);
INSERT INTO `sp_attribute` VALUES ('2324', '功能参数-转速', '48', 'only', 'manual', '1000转/分', null);
INSERT INTO `sp_attribute` VALUES ('2325', '规格参数-标准程序耗电量', '48', 'only', 'manual', '0.18度', null);
INSERT INTO `sp_attribute` VALUES ('2326', '主体参数-品牌', '490', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2327', '功能参数-咖啡机种类', '490', 'only', 'manual', '美式咖啡', null);
INSERT INTO `sp_attribute` VALUES ('2328', '容量参数-咖啡容量', '490', 'only', 'manual', '11-15杯', null);
INSERT INTO `sp_attribute` VALUES ('2329', '规格参数-产品尺寸(高*宽*深', '490', 'only', 'manual', '170*320*360毫米', null);
INSERT INTO `sp_attribute` VALUES ('2330', '主体-品牌', '491', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2331', '酸奶机功能-酸奶机功能', '491', 'only', 'manual', '酸奶', null);
INSERT INTO `sp_attribute` VALUES ('2332', '功能参数-定时功能', '491', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2333', '材质-内胆材质', '491', 'only', 'manual', '其它内胆,食品级塑料内胆', null);
INSERT INTO `sp_attribute` VALUES ('2334', '规格参数-内胆数量', '491', 'only', 'manual', '单胆', null);
INSERT INTO `sp_attribute` VALUES ('2335', '主体-商品名称', '492', 'only', 'manual', '小熊（Bear）DDQ-B01K1打蛋器电动家用打奶油烘焙迷你搅拌打蛋机手持', null);
INSERT INTO `sp_attribute` VALUES ('2336', '功能参数-料理功能', '492', 'only', 'manual', '搅拌,打蛋', null);
INSERT INTO `sp_attribute` VALUES ('2337', '规格参数-刀头数量', '492', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('2338', '主体-厨房小家电类型', '493', 'only', 'manual', '烧烤炉', null);
INSERT INTO `sp_attribute` VALUES ('2339', '烧烤炉功能-烧烤炉功能', '493', 'only', 'manual', '烤,煎', null);
INSERT INTO `sp_attribute` VALUES ('2340', '功能参数-导油槽', '493', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2341', '材质-加热管材质', '493', 'only', 'manual', '其它', null);
INSERT INTO `sp_attribute` VALUES ('2342', '规格参数-适用环境', '493', 'only', 'manual', '室内', null);
INSERT INTO `sp_attribute` VALUES ('2343', '主体-厨房小家电类型', '494', 'only', 'manual', '多士炉', null);
INSERT INTO `sp_attribute` VALUES ('2344', '功能参数-多士炉功能', '494', 'only', 'manual', '烘烤,加热', null);
INSERT INTO `sp_attribute` VALUES ('2345', '规格参数-面包槽数', '494', 'only', 'manual', '2个', null);
INSERT INTO `sp_attribute` VALUES ('2346', '颜色', '494', 'many', 'list', '全钢身烘焙,可爱粉钢身,多能无敌机,小巧不占地,机智黄单烤,魅力紫烘烤', null);
INSERT INTO `sp_attribute` VALUES ('2347', '主体-商品名称', '495', 'only', 'manual', '美的榨汁机WBL25B26', null);
INSERT INTO `sp_attribute` VALUES ('2348', '功能参数-档位', '495', 'only', 'manual', '1档', null);
INSERT INTO `sp_attribute` VALUES ('2349', '规格参数-果汁杯容量', '495', 'only', 'manual', '1250毫升', null);
INSERT INTO `sp_attribute` VALUES ('2350', '颜色', '495', 'many', 'list', '一机三杯,一机双杯,智能二合一,经典不锈钢,经典多功能', null);
INSERT INTO `sp_attribute` VALUES ('2351', '主体参数-商品名称', '496', 'only', 'manual', '格兰仕（Galanz） P70D20N1P-G5(W0)机械转盘微波炉 操作简单老少咸宜 20L 白玫瑰', null);
INSERT INTO `sp_attribute` VALUES ('2352', '类别-类别', '496', 'only', 'manual', '微波炉', null);
INSERT INTO `sp_attribute` VALUES ('2353', '底盘-底盘类型', '496', 'only', 'manual', '转盘', null);
INSERT INTO `sp_attribute` VALUES ('2354', '容量-容量', '496', 'only', 'manual', '20升', null);
INSERT INTO `sp_attribute` VALUES ('2355', '功能-功能', '496', 'only', 'manual', '微波,其他', null);
INSERT INTO `sp_attribute` VALUES ('2356', '开门设置-开门方式', '496', 'only', 'manual', '按门式', null);
INSERT INTO `sp_attribute` VALUES ('2357', '控制方式-控制方式', '496', 'only', 'manual', '机械式', null);
INSERT INTO `sp_attribute` VALUES ('2358', '内胆材质-内胆材质', '496', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2359', '能效参数-国家能效等级', '496', 'only', 'manual', '4级', null);
INSERT INTO `sp_attribute` VALUES ('2360', '规格参数-腔体尺寸(高*宽*深', '496', 'only', 'manual', '210*329*315毫米', null);
INSERT INTO `sp_attribute` VALUES ('2361', '颜色', '496', 'many', 'list', '20L-电脑版中国红,32L-紫色电烤箱,下拉门R6K(R9),光波烧烤B8,家用机械转盘G5(W0),平板烧烤DG(W0),手机APPC2(C0),手机APPC2(C3)', null);
INSERT INTO `sp_attribute` VALUES ('2362', '主体参数-品牌', '499', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2363', '加热方式-普通加热', '499', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2364', '控制范围-温控范围', '499', 'only', 'manual', '室温-250度', null);
INSERT INTO `sp_attribute` VALUES ('2365', '功能参数-旋转烤叉', '499', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2366', '商品材质-外观材质', '499', 'only', 'manual', '冷轧板', null);
INSERT INTO `sp_attribute` VALUES ('2367', '规格参数-净重', '499', 'only', 'manual', '9千克', null);
INSERT INTO `sp_attribute` VALUES ('2368', '规格', '499', 'many', 'list', '32L-APP智能烤箱,32L-不沾内胆烤箱,32L-家用专业烤箱,32L-热销爆款,格兰仕爆款入门烤箱', null);
INSERT INTO `sp_attribute` VALUES ('2369', '主体参数-商品名称', '49', 'only', 'manual', '倍科(beko)DCY7402GXB1 欧洲原装进口冷凝式干衣机 全自动滚筒式烘干衣机（白色）', null);
INSERT INTO `sp_attribute` VALUES ('2370', '基本参数-上市时间', '49', 'only', 'manual', '2015年6月', null);
INSERT INTO `sp_attribute` VALUES ('2371', '功能参数-标准程序耗电量', '49', 'only', 'manual', '0.7度', null);
INSERT INTO `sp_attribute` VALUES ('2372', '规格参数-产品重量', '49', 'only', 'manual', '38.5千克', null);
INSERT INTO `sp_attribute` VALUES ('2373', '颜色', '49', 'many', 'list', '原装进口直排式7公斤（白色）,原装进口冷凝式7公斤（白色）,原装进口冷凝式7公斤（银色）,原装进口热泵式8公斤（银色）', null);
INSERT INTO `sp_attribute` VALUES ('2374', '主体-商品名称', '500', 'only', 'manual', '空气净化器', null);
INSERT INTO `sp_attribute` VALUES ('2375', '新国标参数-颗粒物CADR值', '500', 'only', 'manual', '220m3/h', null);
INSERT INTO `sp_attribute` VALUES ('2376', '外观-颜色', '500', 'only', 'manual', '金色系', null);
INSERT INTO `sp_attribute` VALUES ('2377', '功能-适用面积', '500', 'only', 'manual', '20-30㎡平方米', null);
INSERT INTO `sp_attribute` VALUES ('2378', '滤网-是否有多层滤网', '500', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2379', '规格参数-毛重', '500', 'only', 'manual', '7.3千克', null);
INSERT INTO `sp_attribute` VALUES ('2380', '净化器', '500', 'many', 'list', 'TKJ303F-C1,TKJ206F-A3,TKJ-F220B,303过滤网,206过滤网,220过滤网,TKJ510-A1', null);
INSERT INTO `sp_attribute` VALUES ('2381', '主体参数-商品名称', '501', 'only', 'manual', '格力电热油汀NDY13-X6121', null);
INSERT INTO `sp_attribute` VALUES ('2382', '功能选项-支持功能', '501', 'only', 'manual', '恒温功能', null);
INSERT INTO `sp_attribute` VALUES ('2383', '功能参数-定时功能', '501', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2384', '技术参数-控制方式', '501', 'only', 'manual', '机械版', null);
INSERT INTO `sp_attribute` VALUES ('2385', '产品配置-档位', '501', 'only', 'manual', '3档', null);
INSERT INTO `sp_attribute` VALUES ('2386', '规格参数-净重', '501', 'only', 'manual', '17.05千克', null);
INSERT INTO `sp_attribute` VALUES ('2387', '主体参数-商品名称', '502', 'only', 'manual', '艾美特欧式快热炉 取暖器HC22132-W', null);
INSERT INTO `sp_attribute` VALUES ('2388', '功能选项-支持功能', '502', 'only', 'manual', '防水功能', null);
INSERT INTO `sp_attribute` VALUES ('2389', '技术参数-适用面积', '502', 'only', 'manual', '21-30㎡', null);
INSERT INTO `sp_attribute` VALUES ('2390', '产品配置-加热片数量', '502', 'only', 'manual', '15片以上', null);
INSERT INTO `sp_attribute` VALUES ('2391', '规格参数-净重', '502', 'only', 'manual', '6.3千克', null);
INSERT INTO `sp_attribute` VALUES ('2392', '颜色', '502', 'many', 'list', '2000W银光闪耀,2200W智能遥控,2200W苏宁爆款,2200W银光闪耀,高端立体取暖', null);
INSERT INTO `sp_attribute` VALUES ('2393', '主体-商品名称', '503', 'only', 'manual', '小熊（Bear）加湿器JSQ-B40T6', null);
INSERT INTO `sp_attribute` VALUES ('2394', '功能参数-价格', '503', 'only', 'manual', '100-199', null);
INSERT INTO `sp_attribute` VALUES ('2395', '规格参数-出雾口数量', '503', 'only', 'manual', '1个', null);
INSERT INTO `sp_attribute` VALUES ('2396', '容量', '503', 'many', 'list', '0.2L高雅格调,3.0L品尚白莲,3.0L薄荷清新,4.0L匠心之作,4.0L升级恒湿,4.0L呵护升级,4.0L触控面板', null);
INSERT INTO `sp_attribute` VALUES ('2397', '主体-商品名称', '506', 'only', 'manual', '美的/midea暖风机NTH20-17LW家用办公室静音摇头省电恒温塔式', null);
INSERT INTO `sp_attribute` VALUES ('2398', '功能参数-加热方式', '506', 'only', 'manual', '陶瓷发热', null);
INSERT INTO `sp_attribute` VALUES ('2399', '规格参数-档位', '506', 'only', 'manual', '2档', null);
INSERT INTO `sp_attribute` VALUES ('2400', '型号', '506', 'many', 'list', 'NTH20-17LW  爆款主推,NTB20-15LW 挂壁两用', null);
INSERT INTO `sp_attribute` VALUES ('2401', '主体参数-商品名称', '507', 'only', 'manual', '赛亿（shinee）取暖器RHD-500F', null);
INSERT INTO `sp_attribute` VALUES ('2402', '功能选项-支持功能', '507', 'only', 'manual', '倾倒断电', null);
INSERT INTO `sp_attribute` VALUES ('2403', '技术参数-加热方式', '507', 'only', 'manual', '石英管加热', null);
INSERT INTO `sp_attribute` VALUES ('2404', '产品配置-档位', '507', 'only', 'manual', '2档', null);
INSERT INTO `sp_attribute` VALUES ('2405', '主体-商品名称', '508', 'only', 'manual', '德业DYD-A20A3除湿机', null);
INSERT INTO `sp_attribute` VALUES ('2406', '功能参数-定时功能', '508', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2407', '规格参数-排水方式', '508', 'only', 'manual', '水箱排水', null);
INSERT INTO `sp_attribute` VALUES ('2408', '除湿量', '508', 'many', 'list', '12L/D 小面积用,20L/D 经典热销,20L/D 净化除湿,30L/D 高端家用,50L/D 大功率型,138L/D 工业除湿', null);
INSERT INTO `sp_attribute` VALUES ('2409', '主体参数-生活小家电类型', '509', 'only', 'manual', '干衣机', null);
INSERT INTO `sp_attribute` VALUES ('2410', '功能选项javascript:void(0)-支持功能', '509', 'only', 'manual', '定时功能', null);
INSERT INTO `sp_attribute` VALUES ('2411', '功能参数-干衣机功能', '509', 'only', 'manual', '干衣,取暖,杀菌', null);
INSERT INTO `sp_attribute` VALUES ('2412', '产品配置-适用人数', '509', 'only', 'manual', '2-4人', null);
INSERT INTO `sp_attribute` VALUES ('2413', '规格参数-电源线长度', '509', 'only', 'manual', '1.5米', null);
INSERT INTO `sp_attribute` VALUES ('2414', '颜色', '509', 'many', 'list', '1000W粉色方形,1000W红色方形,1000W黄色方形,1350W鹿纹方形,900W蓝色方形,迪士尼合作新品', null);
INSERT INTO `sp_attribute` VALUES ('2415', '主体参数-商品名称', '510', 'only', 'manual', '先锋（singfun）油汀DS9411', null);
INSERT INTO `sp_attribute` VALUES ('2416', '功能选项-支持功能', '510', 'only', 'manual', '恒温功能', null);
INSERT INTO `sp_attribute` VALUES ('2417', '功能参数-定时功能', '510', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2418', '技术参数-控制方式', '510', 'only', 'manual', '机械版', null);
INSERT INTO `sp_attribute` VALUES ('2419', '产品配置-档位', '510', 'only', 'manual', '3档', null);
INSERT INTO `sp_attribute` VALUES ('2420', '规格参数-净重', '510', 'only', 'manual', '11.8千克', null);
INSERT INTO `sp_attribute` VALUES ('2421', '颜色', '510', 'many', 'list', '13片爆款,13片高端S型,爆款11片S型,经典11片直板,经典12片直板,高端热浪11片', null);
INSERT INTO `sp_attribute` VALUES ('2422', '主体参数-商品名称', '512', 'only', 'manual', '美的(Midea) NY2513-16J1W 油汀 取暖器', null);
INSERT INTO `sp_attribute` VALUES ('2423', '功能选项-支持功能', '512', 'only', 'manual', '倾倒断电', null);
INSERT INTO `sp_attribute` VALUES ('2424', '功能参数-定时功能', '512', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2425', '技术参数-控制方式', '512', 'only', 'manual', '机械版', null);
INSERT INTO `sp_attribute` VALUES ('2426', '产品配置-档位', '512', 'only', 'manual', '3档', null);
INSERT INTO `sp_attribute` VALUES ('2427', '规格参数-净重', '512', 'only', 'manual', '12.6千克', null);
INSERT INTO `sp_attribute` VALUES ('2428', '颜色', '512', 'many', 'list', '11片爆款,13片爆款,专利散热片,超大散热片,速暖油汀', null);
INSERT INTO `sp_attribute` VALUES ('2429', '主体-商品名称', '515', 'only', 'manual', '小熊(Bear) 加湿器JSQ-A40A2（金色）', null);
INSERT INTO `sp_attribute` VALUES ('2430', '功能参数-价格', '515', 'only', 'manual', '99以下', null);
INSERT INTO `sp_attribute` VALUES ('2431', '规格参数-出雾口数量', '515', 'only', 'manual', '1个', null);
INSERT INTO `sp_attribute` VALUES ('2432', '容量', '515', 'many', 'list', '0.2L高雅格调,3.0L品尚白莲,3.0L薄荷清新,4.0L匠心之作,4.0L升级恒湿,4.0L呵护升级,4.0L触控面板', null);
INSERT INTO `sp_attribute` VALUES ('2433', '主体参数-商品名称', '516', 'only', 'manual', '米家压力IH电饭煲', null);
INSERT INTO `sp_attribute` VALUES ('2434', '功能-加热方式', '516', 'only', 'manual', 'IH电磁加热', null);
INSERT INTO `sp_attribute` VALUES ('2435', '材质-内胆材质', '516', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2436', '外观-颜色', '516', 'only', 'manual', '白色', null);
INSERT INTO `sp_attribute` VALUES ('2437', '规格-容量', '516', 'only', 'manual', '3L', null);
INSERT INTO `sp_attribute` VALUES ('2438', '电源参数-额定功率', '516', 'only', 'manual', '1100瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2439', '型号', '516', 'many', 'list', '小米（MI）米家IH电饭煲,小米（MI）米家IH电饭煲 4L,小米（MI）米家压力IH电饭煲,小米（MI）米家恒温电水壶,小米（MI）米家电水壶', null);
INSERT INTO `sp_attribute` VALUES ('2440', '主体-商品名称', '517', 'only', 'manual', '莱克吸尘器家用M7 大吸力无线手持吸尘器 无耗材除螨吸尘器', null);
INSERT INTO `sp_attribute` VALUES ('2441', '功能参数-吸尘器功能', '517', 'only', 'manual', '地毯式,干式,除螨,其它', null);
INSERT INTO `sp_attribute` VALUES ('2442', '规格参数-充电时间', '517', 'only', 'manual', '6小时', null);
INSERT INTO `sp_attribute` VALUES ('2443', '功能', '517', 'many', 'list', '带电动床刷款,250W数码电机,2017无线新品,380W大功率升级版,手持吸尘器', null);
INSERT INTO `sp_attribute` VALUES ('2444', '主体-商品名称', '518', 'only', 'manual', 'Proscenic P1S 智能扫地机器人', null);
INSERT INTO `sp_attribute` VALUES ('2445', '功能参数-吸尘器功能', '518', 'only', 'manual', '地毯式,干湿两用式,干式,自动清扫,湿用,吸水', null);
INSERT INTO `sp_attribute` VALUES ('2446', '规格参数-充电时间', '518', 'only', 'manual', '4小时', null);
INSERT INTO `sp_attribute` VALUES ('2447', '型号', '518', 'many', 'list', 'P1S-珍珠白,P2S-土豪金', null);
INSERT INTO `sp_attribute` VALUES ('2448', '主体参数-商品名称', '520', 'only', 'manual', '松下(Panasonic)蒸汽挂烫机', null);
INSERT INTO `sp_attribute` VALUES ('2449', '功能参数-缺水提示功能', '520', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2450', '规格参数-支架材质', '520', 'only', 'manual', '铝合金', null);
INSERT INTO `sp_attribute` VALUES ('2451', '颜色', '520', 'many', 'list', '人气推荐,双重蒸汽,宝石橙,宝石蓝,时尚粉金,清新绿,科技蓝', null);
INSERT INTO `sp_attribute` VALUES ('2452', '主体-商品名称', '521', 'only', 'manual', '戴森(Dyson) HP03冷暖净化风扇 白色', null);
INSERT INTO `sp_attribute` VALUES ('2453', '功能参数-定时功能', '521', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2454', '规格参数-扇叶片数', '521', 'only', 'manual', '0片', null);
INSERT INTO `sp_attribute` VALUES ('2455', '型号&颜色', '521', 'many', 'list', 'HP00【白色】,HP00【蓝色】,HP02【美版白色】,HP02【蓝色】,HP03【白色】,HP03【蓝色】,HP02【欧版白色升级版】', null);
INSERT INTO `sp_attribute` VALUES ('2456', '主体-商品名称', '522', 'only', 'manual', '科沃斯(ECOVACS) 智能吸尘器DT87G BW（灰耀白）', null);
INSERT INTO `sp_attribute` VALUES ('2457', '功能参数-吸尘器功能', '522', 'only', 'manual', '自动清扫,其它', null);
INSERT INTO `sp_attribute` VALUES ('2458', '规格参数-充电时间', '522', 'only', 'manual', '3-4小时', null);
INSERT INTO `sp_attribute` VALUES ('2459', '型号', '522', 'many', 'list', '2017年新品DT87G（规划扫拖 省心省力）,扫擦搭档 省时省力,魔镜S升级款（APP智控 千帕吸力）', null);
INSERT INTO `sp_attribute` VALUES ('2460', '主体-商品名称', '524', 'only', 'manual', '小狗（puppy）干湿吹三用大功率桶式商用家用吸尘器D-807', null);
INSERT INTO `sp_attribute` VALUES ('2461', '功能参数-吸尘器功能', '524', 'only', 'manual', '干湿两用式', null);
INSERT INTO `sp_attribute` VALUES ('2462', '规格参数-充电时间', '524', 'only', 'manual', '0小时', null);
INSERT INTO `sp_attribute` VALUES ('2463', '主体-商品名称', '525', 'only', 'manual', '飞利浦剃须刀 S5078', null);
INSERT INTO `sp_attribute` VALUES ('2464', '刀头-刀头数量', '525', 'only', 'manual', '三刀头', null);
INSERT INTO `sp_attribute` VALUES ('2465', '清洁-清洁方式', '525', 'only', 'manual', '全身水洗', null);
INSERT INTO `sp_attribute` VALUES ('2466', '电源-供电方式', '525', 'only', 'manual', '充电', null);
INSERT INTO `sp_attribute` VALUES ('2467', '功能-鬓毛修剪器', '525', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2468', '规格参数-额定功率', '525', 'only', 'manual', '9瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2469', '型号', '525', 'many', 'list', '剃须刀 S5077/03,剃须刀 S5078/04,剃须刀 S5079/04,剃须刀 S5081/04,剃须刀 S5082/61,剃须刀 S5091/50,剃须刀 S5095/58', null);
INSERT INTO `sp_attribute` VALUES ('2470', '主体-商品名称', '527', 'only', 'manual', '飞利浦(Philips) 电吹风HP8230', null);
INSERT INTO `sp_attribute` VALUES ('2471', '护发-护发功能', '527', 'only', 'manual', '恒温设计', null);
INSERT INTO `sp_attribute` VALUES ('2472', '功率-功率', '527', 'only', 'manual', '2000W以上', null);
INSERT INTO `sp_attribute` VALUES ('2473', '档位-产品档位', '527', 'only', 'manual', '2档', null);
INSERT INTO `sp_attribute` VALUES ('2474', '功能参数-吹风机功能', '527', 'only', 'manual', '恒温设计', null);
INSERT INTO `sp_attribute` VALUES ('2475', '风嘴-风嘴样式', '527', 'only', 'manual', '单集风嘴', null);
INSERT INTO `sp_attribute` VALUES ('2476', '规格参数-电源线长度', '527', 'only', 'manual', '1.8米', null);
INSERT INTO `sp_attribute` VALUES ('2477', '颜色', '527', 'many', 'list', '淡雅白HP8230/65,神秘黑HP8230/00', null);
INSERT INTO `sp_attribute` VALUES ('2478', '主体-个护健康类型', '529', 'only', 'manual', '电子美容仪,美颜仪,脸部保养清洁', null);
INSERT INTO `sp_attribute` VALUES ('2479', '规格参数-自动断电', '529', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2480', '规格', '529', 'many', 'list', '233白色,233粉色', null);
INSERT INTO `sp_attribute` VALUES ('2481', '主体参数-个护健康类型', '530', 'only', 'manual', '多功能美发器', null);
INSERT INTO `sp_attribute` VALUES ('2482', '功能参数-预热时间', '530', 'only', 'manual', '20s以上', null);
INSERT INTO `sp_attribute` VALUES ('2483', '电源-电源类型', '530', 'only', 'manual', '电源式', null);
INSERT INTO `sp_attribute` VALUES ('2484', '规格参数-电源线长度', '530', 'only', 'manual', '1-2米', null);
INSERT INTO `sp_attribute` VALUES ('2485', '主体-个护健康类型', '531', 'only', 'manual', '剃毛器', null);
INSERT INTO `sp_attribute` VALUES ('2486', '功能参数-清洁方式', '531', 'only', 'manual', '全身水洗', null);
INSERT INTO `sp_attribute` VALUES ('2487', '规格参数-电源类型', '531', 'only', 'manual', 'USB', null);
INSERT INTO `sp_attribute` VALUES ('2488', '颜色', '531', 'many', 'list', '粉色4支装,蓝色5支装,玫红色,紫色', null);
INSERT INTO `sp_attribute` VALUES ('2489', '主体-个护健康类型', '532', 'only', 'manual', '脱毛器', null);
INSERT INTO `sp_attribute` VALUES ('2490', '功能-除毛部位', '532', 'only', 'manual', '全身,比基尼线,手臂,腋下,腿部', null);
INSERT INTO `sp_attribute` VALUES ('2491', '规格参数-额定功率', '532', 'only', 'manual', '36瓦', null);
INSERT INTO `sp_attribute` VALUES ('2492', '规格', '532', 'many', 'list', '主机标配脱毛,主机配脱毛+嫩肤,主机配脱毛+嫩肤+淡痘', null);
INSERT INTO `sp_attribute` VALUES ('2493', '主体-个护健康类型', '533', 'only', 'manual', '成人,成人', null);
INSERT INTO `sp_attribute` VALUES ('2494', '电源-充电时间', '533', 'only', 'manual', '12小时', null);
INSERT INTO `sp_attribute` VALUES ('2495', '适用人群-适用人群', '533', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2496', '功能-清洁方式', '533', 'only', 'manual', '无水洗', null);
INSERT INTO `sp_attribute` VALUES ('2497', '规格参数-产品尺寸(高*宽*深', '533', 'only', 'manual', '142*66*212毫米', null);
INSERT INTO `sp_attribute` VALUES ('2498', '型号', '533', 'many', 'list', 'FC5802,FC5803,FC5806,FC5808,FC5902,玫瑰金,白色,蓝黑,金黄,黑白', null);
INSERT INTO `sp_attribute` VALUES ('2499', '主体参数-型号', '534', 'only', 'manual', 'TRIMMER NT3160', null);
INSERT INTO `sp_attribute` VALUES ('2500', '功能参数-干湿两用', '534', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2501', '规格参数-电源类型', '534', 'only', 'manual', '干电式', null);
INSERT INTO `sp_attribute` VALUES ('2502', '刀片参数-精密研磨刀片', '534', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('2503', '电源参数-净重', '534', 'only', 'manual', '0.2千克', null);
INSERT INTO `sp_attribute` VALUES ('2504', '型号', '534', 'many', 'list', '3100,3300,NT3160,5100', null);
INSERT INTO `sp_attribute` VALUES ('2505', '主体-商品名称', '535', 'only', 'manual', '飞利浦 电动剃须刀S1560/04', null);
INSERT INTO `sp_attribute` VALUES ('2506', '刀头-刀头数量', '535', 'only', 'manual', '三刀头', null);
INSERT INTO `sp_attribute` VALUES ('2507', '清洁-清洁方式', '535', 'only', 'manual', '全身水洗', null);
INSERT INTO `sp_attribute` VALUES ('2508', '电源-供电方式', '535', 'only', 'manual', '充电', null);
INSERT INTO `sp_attribute` VALUES ('2509', '功能-鬓毛修剪器', '535', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2510', '规格参数-赠品清单', '535', 'only', 'manual', '****', null);
INSERT INTO `sp_attribute` VALUES ('2511', '主体参数-个护健康类型', '537', 'only', 'manual', '电子美容仪,美颜仪,脸部保养清洁', null);
INSERT INTO `sp_attribute` VALUES ('2512', '功能参数-产品功能', '537', 'only', 'manual', '震动按摩,超声波,其他', null);
INSERT INTO `sp_attribute` VALUES ('2513', '适用范围-适用人群', '537', 'only', 'manual', '男士,女士', null);
INSERT INTO `sp_attribute` VALUES ('2514', '电源-自动断电', '537', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2515', '规格参数-净重', '537', 'only', 'manual', '0.093千克', null);
INSERT INTO `sp_attribute` VALUES ('2516', '颜色', '537', 'many', 'list', '樱桃红,粉红,向日葵黄,海军蓝,午夜黑,樱桃红洗面奶套装', null);
INSERT INTO `sp_attribute` VALUES ('2517', '主体-商品名称', '539', 'only', 'manual', '松下电吹风', null);
INSERT INTO `sp_attribute` VALUES ('2518', '护发-护发功能', '539', 'only', 'manual', '负离子', null);
INSERT INTO `sp_attribute` VALUES ('2519', '功率-功率', '539', 'only', 'manual', '1601-2000W', null);
INSERT INTO `sp_attribute` VALUES ('2520', '档位-产品档位', '539', 'only', 'manual', '5档', null);
INSERT INTO `sp_attribute` VALUES ('2521', '功能参数-吹风机功能', '539', 'only', 'manual', '负离子,纳米水离子', null);
INSERT INTO `sp_attribute` VALUES ('2522', '风嘴-风嘴样式', '539', 'only', 'manual', '其他风嘴', null);
INSERT INTO `sp_attribute` VALUES ('2523', '规格参数-电源线长度', '539', 'only', 'manual', '1米', null);
INSERT INTO `sp_attribute` VALUES ('2524', 'NA系列', '539', 'many', 'list', 'NA10,NA98,NA61,NA45', null);
INSERT INTO `sp_attribute` VALUES ('2525', '主体参数-个护健康类型', '540', 'only', 'manual', '卷/直发二合一', null);
INSERT INTO `sp_attribute` VALUES ('2526', '功能参数-预热时间', '540', 'only', 'manual', '10-20s', null);
INSERT INTO `sp_attribute` VALUES ('2527', '电源-电源类型', '540', 'only', 'manual', '电源式', null);
INSERT INTO `sp_attribute` VALUES ('2528', '规格参数-电源线长度', '540', 'only', 'manual', '1-2米', null);
INSERT INTO `sp_attribute` VALUES ('2529', '主体-商品名称', '541', 'only', 'manual', '博朗（BRAUN）3系301s电动剃须刀5408', null);
INSERT INTO `sp_attribute` VALUES ('2530', '刀头-刀头数量', '541', 'only', 'manual', '三刀头', null);
INSERT INTO `sp_attribute` VALUES ('2531', '清洁-清洁方式', '541', 'only', 'manual', '全身水洗', null);
INSERT INTO `sp_attribute` VALUES ('2532', '电源-供电方式', '541', 'only', 'manual', '充电', null);
INSERT INTO `sp_attribute` VALUES ('2533', '功能-鬓毛修剪器', '541', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('2534', '规格参数-额定功率', '541', 'only', 'manual', '9瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2535', '型号', '541', 'many', 'list', '博朗301S,博朗3020S,博朗3040S+BT32造型梳,博朗3050CC自带清洁中心,博朗3080S,博朗3090CC自带清洁中心,博朗H310S', null);
INSERT INTO `sp_attribute` VALUES ('2536', '主体-商品名称', '542', 'only', 'manual', '飞利浦(Philips) 声波震动牙刷HX6730', null);
INSERT INTO `sp_attribute` VALUES ('2537', '刷头-适用人群', '542', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2538', '电源-电源类型', '542', 'only', 'manual', '充电式', null);
INSERT INTO `sp_attribute` VALUES ('2539', '功能-防水功能', '542', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2540', '规格参数-产品尺寸(高*宽*深', '542', 'only', 'manual', '236*171*95毫米', null);
INSERT INTO `sp_attribute` VALUES ('2541', '颜色', '542', 'many', 'list', '人气经典雾白HX6730,樱花粉HX6761,灵动绿HX6213,炫感冰蓝HX6616', null);
INSERT INTO `sp_attribute` VALUES ('2542', '主体-个护健康类型', '543', 'only', 'manual', '牙刷头', null);
INSERT INTO `sp_attribute` VALUES ('2543', '规格参数-适配型号', '543', 'only', 'manual', 'HX6730HX6761HX6511HX3130', null);
INSERT INTO `sp_attribute` VALUES ('2544', '牙刷头型号', '543', 'many', 'list', '【标准型1支装】HX6011,【标准型3支装】HX6013,【迷你刷头1支装】HX6021,【标准型6支装】HX6016,【牙菌斑*御型1支装】HX9021,【牙菌斑*御型3支装】HX9023,【亮白型白3支装】HX6063,【亮白型黑3支装】HX6063,【亮白迷你型3支装】HX6073,【舌苔清洁刷2支装】HX8072,【儿童款标准2支装】HX6042,【牙龈护理型3只装】HX9033,【E系列一支装（售后简装）】HX7001,【E系列两支装（售后简装）】HX7001,【儿童款迷你2支装】HX6032,【智臻亮白刷头3支装】HX9063白,【智臻亮白刷头3支装】HX9063黑,【亮白大小刷头搭配6支装】HX6066,【柔软刷毛1支装】HX9031,【电动牙刷充电器】HX6100适合大部分牙刷', null);
INSERT INTO `sp_attribute` VALUES ('2545', '主体参数-个护健康类型', '544', 'only', 'manual', '冲牙器', null);
INSERT INTO `sp_attribute` VALUES ('2546', '功能参数-防水功能', '544', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2547', '规格参数-适用人群', '544', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2548', '适用范围-水箱容量', '544', 'only', 'manual', '0.16升', null);
INSERT INTO `sp_attribute` VALUES ('2549', '功能', '544', 'many', 'list', '智能冲牙器5002,旅行便携冲牙器5008,高容量全家冲牙器5101,多档水压家庭冲牙器5102', null);
INSERT INTO `sp_attribute` VALUES ('2550', '主体-商品名称', '546', 'only', 'manual', '小荷电动牙刷HOB 成人无线充电式声波震动智能电动牙刷 防水自动智能美白 苏宁自营 品质保证 两年免费换新', null);
INSERT INTO `sp_attribute` VALUES ('2551', '刷头-适用人群', '546', 'only', 'manual', '通用', null);
INSERT INTO `sp_attribute` VALUES ('2552', '电源-电源类型', '546', 'only', 'manual', '充电式', null);
INSERT INTO `sp_attribute` VALUES ('2553', '功能-防水功能', '546', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2554', '规格参数-包装尺寸', '546', 'only', 'manual', '208*130*45毫米', null);
INSERT INTO `sp_attribute` VALUES ('2555', '规格', '546', 'many', 'list', 'HOB  象牙白,HO1  天空蓝,H9-OA白色,H9-OA蓝色,H9-OA粉色', null);
INSERT INTO `sp_attribute` VALUES ('2556', '主体-商品名称', '547', 'only', 'manual', '拜尔(Baier)K3儿童电动牙刷自动声波震动宝宝刷头软毛充电式3-6-12岁小孩防水 苹果绿', null);
INSERT INTO `sp_attribute` VALUES ('2557', '刷头-适用人群', '547', 'only', 'manual', '儿童', null);
INSERT INTO `sp_attribute` VALUES ('2558', '电源-电源类型', '547', 'only', 'manual', '充电式', null);
INSERT INTO `sp_attribute` VALUES ('2559', '功能-防水功能', '547', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2560', '规格参数-包装尺寸', '547', 'only', 'manual', '245*245*50毫米', null);
INSERT INTO `sp_attribute` VALUES ('2561', '颜色', '547', 'many', 'list', '儿童牙刷人气款-柠檬黄,儿童牙刷人气款-樱桃红,儿童牙刷人气款-苹果绿,儿童牙刷入门级-亮黄,儿童牙刷入门级-炫绿,儿童牙刷入门级-玫红,儿童牙刷标准款-红蓝,儿童牙刷标准款-蓝红', null);
INSERT INTO `sp_attribute` VALUES ('2562', '主体-个护健康类型', '548', 'only', 'manual', '按摩椅', null);
INSERT INTO `sp_attribute` VALUES ('2563', '功能参数-记忆功能', '548', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2564', '规格参数-按摩部位', '548', 'only', 'manual', '颈部,背部,足部,腿部,肩部,全身,头部,腰部,手臂,臀部', null);
INSERT INTO `sp_attribute` VALUES ('2565', '颜色', '548', 'many', 'list', '棕色,黑色,红色,咖啡色,蓝绿色,蓝棕色,SM-750,SM-750S', null);
INSERT INTO `sp_attribute` VALUES ('2566', '主体-个护健康类型', '549', 'only', 'manual', '背背佳', null);
INSERT INTO `sp_attribute` VALUES ('2567', '规格参数-使用部位', '549', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2568', '款式', '549', 'many', 'list', 'R1(加热款）,R2（加热震动款）', null);
INSERT INTO `sp_attribute` VALUES ('2569', '主体参数-商品名称', '54', 'only', 'manual', '小天鹅洗衣机TG100VN02DG5', null);
INSERT INTO `sp_attribute` VALUES ('2570', '特性参数-变频', '54', 'only', 'manual', '变频', null);
INSERT INTO `sp_attribute` VALUES ('2571', '功能参数-童锁功能', '54', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2572', '规格参数-产品重量', '54', 'only', 'manual', '71千克', null);
INSERT INTO `sp_attribute` VALUES ('2573', '主体-个护健康类型', '551', 'only', 'manual', '健康秤', null);
INSERT INTO `sp_attribute` VALUES ('2574', '功能参数-超载提示', '551', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2575', '规格参数-最小称量', '551', 'only', 'manual', '6千克', null);
INSERT INTO `sp_attribute` VALUES ('2576', '主体-商品名称', '554', 'only', 'manual', 'YK-638C全自动足浴盆', null);
INSERT INTO `sp_attribute` VALUES ('2577', '功能参数-足浴盆功能', '554', 'only', 'manual', '磨脚石,冲浪,杀菌', null);
INSERT INTO `sp_attribute` VALUES ('2578', '规格参数-排水方式', '554', 'only', 'manual', '手动式', null);
INSERT INTO `sp_attribute` VALUES ('2579', '型号', '554', 'many', 'list', 'YK-638A,YK-638B,YK-638C', null);
INSERT INTO `sp_attribute` VALUES ('2580', '主体-个护健康类型', '555', 'only', 'manual', '按摩椅', null);
INSERT INTO `sp_attribute` VALUES ('2581', '功能参数-记忆功能', '555', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2582', '规格参数-按摩部位', '555', 'only', 'manual', '颈部,背部,足部,腿部,肩部,腰部,手臂,臀部', null);
INSERT INTO `sp_attribute` VALUES ('2583', '颜色', '555', 'many', 'list', '酒红色,宝蓝色,咖啡色', null);
INSERT INTO `sp_attribute` VALUES ('2584', '主体-商品名称', '556', 'only', 'manual', '金泰昌全自动按摩足浴盆TC-9058', null);
INSERT INTO `sp_attribute` VALUES ('2585', '功能参数-足浴盆功能', '556', 'only', 'manual', '冲浪', null);
INSERT INTO `sp_attribute` VALUES ('2586', '规格参数-排水方式', '556', 'only', 'manual', '手动式', null);
INSERT INTO `sp_attribute` VALUES ('2587', '主体-个护健康类型', '557', 'only', 'manual', '按摩披肩/肩背敲敲乐', null);
INSERT INTO `sp_attribute` VALUES ('2588', '功能参数-按摩部位', '557', 'only', 'manual', '肩部', null);
INSERT INTO `sp_attribute` VALUES ('2589', '规格参数-净重', '557', 'only', 'manual', '2.25千克', null);
INSERT INTO `sp_attribute` VALUES ('2590', '颜色', '557', 'many', 'list', '豪华升级版,瘦身纤体带,刮痧按摩器,离子震动美容棒,眼保仪,电动丰胸器,三合一按摩靠垫,按摩披肩,多功能按摩靠垫,脊柱保', null);
INSERT INTO `sp_attribute` VALUES ('2591', '主体-个护健康类型', '558', 'only', 'manual', '按摩椅', null);
INSERT INTO `sp_attribute` VALUES ('2592', '功能参数-记忆功能', '558', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2593', '规格参数-按摩部位', '558', 'only', 'manual', '颈部,背部,足部,腿部,肩部,全身,头部,腰部,手臂,臀部', null);
INSERT INTO `sp_attribute` VALUES ('2594', '颜色', '558', 'many', 'list', '贵宾棕,贵宾金,深咖色,白色,DE-T06,DE-A19L,DE-T07', null);
INSERT INTO `sp_attribute` VALUES ('2595', '主体-厨房小家电类型', '559', 'only', 'manual', '套锅', null);
INSERT INTO `sp_attribute` VALUES ('2596', '规格参数-直径', '559', 'only', 'manual', '30厘米', null);
INSERT INTO `sp_attribute` VALUES ('2597', '乔迁送礼必备', '559', 'many', 'list', '不粘锅套装,铁锅套装无压力锅,铁锅套装,铁锅套装十五件套,铁锅套装十四件套,不粘锅套装十五件套,不锈钢套装十九件套,不粘锅三件套,不粘锅4件套,不锈钢套装十八件套,火红点套装,铁锅电磁通用11件套,不粘燃气专用11件套,不粘电磁通用11件套,炒锅双炒10件套,不粘套装10件套,套装4件套,不粘套装9件套', null);
INSERT INTO `sp_attribute` VALUES ('2598', '主体参数-商品名称', '55', 'only', 'manual', '西门子冰箱BCD-610W(KA92NV02TI)', null);
INSERT INTO `sp_attribute` VALUES ('2599', '基本参数-电压/频率', '55', 'only', 'manual', '220V/50Hz', null);
INSERT INTO `sp_attribute` VALUES ('2600', '功能参数-童锁功能', '55', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2601', '规格参数-产品重量', '55', 'only', 'manual', '108千克', null);
INSERT INTO `sp_attribute` VALUES ('2602', '样式', '55', 'many', 'list', '569升 零度保鲜,598升 玻璃面板,608升 主动增湿保鲜,610升 旋转制冰盒,610升 无霜 变频,不锈钢色,浅金色,白色,金棕色,银色', null);
INSERT INTO `sp_attribute` VALUES ('2603', '主体-厨房小家电类型', '560', 'only', 'manual', '炒锅', null);
INSERT INTO `sp_attribute` VALUES ('2604', '显示参数-直径', '560', 'only', 'manual', '32厘米', null);
INSERT INTO `sp_attribute` VALUES ('2605', '颜色', '560', 'many', 'list', '30cm明火专用,30cm电磁炉明火通用,32cm明火专用,32cm电磁炉明火通用', null);
INSERT INTO `sp_attribute` VALUES ('2606', '主体参数-厨房小家电类型', '561', 'only', 'manual', '蒸锅', null);
INSERT INTO `sp_attribute` VALUES ('2607', '显示参数-直径', '561', 'only', 'manual', '28厘米', null);
INSERT INTO `sp_attribute` VALUES ('2608', '颜色', '561', 'many', 'list', 'ST26Y1,SZ22S1,SZ26B2,SZ26B4,SZ26B5,SZ28B2,SZ28B5,SZ30B5', null);
INSERT INTO `sp_attribute` VALUES ('2609', '主体-厨房小家电类型', '562', 'only', 'manual', '煎锅', null);
INSERT INTO `sp_attribute` VALUES ('2610', '主体参数-厨房小家电类型', '563', 'only', 'manual', '压力锅', null);
INSERT INTO `sp_attribute` VALUES ('2611', '显示参数-直径', '563', 'only', 'manual', '24厘米', null);
INSERT INTO `sp_attribute` VALUES ('2612', '主体-厨房小家电类型', '564', 'only', 'manual', '奶锅', null);
INSERT INTO `sp_attribute` VALUES ('2613', '规格参数-直径', '564', 'only', 'manual', '16厘米', null);
INSERT INTO `sp_attribute` VALUES ('2614', '不锈钢不粘锅', '564', 'many', 'list', '好帮手不锈钢奶锅 ST16H3,好帮手不锈钢奶锅 ST18H3,炫彩不粘奶锅 ET16KP01-R,炫彩不粘奶锅 ET16KP01-B', null);
INSERT INTO `sp_attribute` VALUES ('2615', '主体参数-商品名称', '565', 'only', 'manual', '爱仕达（ASD) 30CM不锈钢锅一锅多用汤锅煮锅蒸锅炖锅焖锅电磁炉通用 HP1730', null);
INSERT INTO `sp_attribute` VALUES ('2616', '规格参数-直径', '565', 'only', 'manual', '30cm及以上', null);
INSERT INTO `sp_attribute` VALUES ('2617', '包装参数-毛重', '565', 'only', 'manual', '1.955千克', null);
INSERT INTO `sp_attribute` VALUES ('2618', '颜色', '565', 'many', 'list', 'ZP1720,LG1722,C1722,HP1730,NG1720,NG1722,NG1724', null);
INSERT INTO `sp_attribute` VALUES ('2619', '主体-厨房小家电类型', '566', 'only', 'manual', '炖锅', null);
INSERT INTO `sp_attribute` VALUES ('2620', '规格参数-直径', '566', 'only', 'manual', '10厘米', null);
INSERT INTO `sp_attribute` VALUES ('2621', '主体-厨房小家电类型', '567', 'only', 'manual', '火锅', null);
INSERT INTO `sp_attribute` VALUES ('2622', '规格参数-直径', '567', 'only', 'manual', '34厘米', null);
INSERT INTO `sp_attribute` VALUES ('2623', '主体参数-厨房小家电类型', '569', 'only', 'manual', '套锅', null);
INSERT INTO `sp_attribute` VALUES ('2624', '规格参数-产品材质', '569', 'only', 'manual', '合金', null);
INSERT INTO `sp_attribute` VALUES ('2625', '包装参数-净重', '569', 'only', 'manual', '5.9千克', null);
INSERT INTO `sp_attribute` VALUES ('2626', '型号', '569', 'many', 'list', 'EC03CTJ,PL03G1RWG,PL03G2RWG,PL03Y3WT,PL04A1WG,WG03CTJ2,WG03CTJS', null);
INSERT INTO `sp_attribute` VALUES ('2627', '主体参数-品牌', '570', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2628', '功能参数-是否一次性使用', '570', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('2629', '规格参数-规格', '570', 'only', 'manual', '玻璃', null);
INSERT INTO `sp_attribute` VALUES ('2630', '型号', '570', 'many', 'list', '16B-EC-CS,16B-EH-CS,16B-FT-CS,16B-LV-CS,16B-PU-CS,20-EC,20-EH,20-LV,6-LV', null);
INSERT INTO `sp_attribute` VALUES ('2631', '主体-厨房小家电类型', '571', 'only', 'manual', '炒锅', null);
INSERT INTO `sp_attribute` VALUES ('2632', '显示参数-直径', '571', 'only', 'manual', '32厘米', null);
INSERT INTO `sp_attribute` VALUES ('2633', '类型', '571', 'many', 'list', '传世铸铁32cm,经典不粘30cm,经典不粘32cm,养生麦饭石30cm,养生麦饭石32cm,大容量无烟34cm,至尊不粘32cm,黑曜石麦饭石30cm,靓彩煎锅28cm,无烟燃气罩专用32cm,铸铁世家一号30cm,钛晶炒锅32CM,36cm老式大铁锅,新款黑曜石夜焰30cm', null);
INSERT INTO `sp_attribute` VALUES ('2634', '主体参数-厨房小家电类型', '573', 'only', 'manual', '套锅', null);
INSERT INTO `sp_attribute` VALUES ('2635', '规格参数-产品材质', '573', 'only', 'manual', '304不锈钢', null);
INSERT INTO `sp_attribute` VALUES ('2636', '包装参数-净重', '573', 'only', 'manual', '5.000千克', null);
INSERT INTO `sp_attribute` VALUES ('2637', '主体-厨房小家电类型', '574', 'only', 'manual', '炒锅', null);
INSERT INTO `sp_attribute` VALUES ('2638', '显示参数-直径', '574', 'only', 'manual', '30厘米', null);
INSERT INTO `sp_attribute` VALUES ('2639', '类型', '574', 'many', 'list', '26cm 煎锅+玻璃盖 01000203,26cm 煎锅无盖 01000207,30cm 炒锅+玻璃盖 01000204,30cm 炒锅无盖 01000208', null);
INSERT INTO `sp_attribute` VALUES ('2640', '主体-厨房小家电类型', '575', 'only', 'manual', '炒锅', null);
INSERT INTO `sp_attribute` VALUES ('2641', '显示参数-直径', '575', 'only', 'manual', '36厘米', null);
INSERT INTO `sp_attribute` VALUES ('2642', '主体参数-厨房小家电类型', '576', 'only', 'manual', '压力锅', null);
INSERT INTO `sp_attribute` VALUES ('2643', '显示参数-直径', '576', 'only', 'manual', '20厘米', null);
INSERT INTO `sp_attribute` VALUES ('2644', '主体-厨房小家电类型', '578', 'only', 'manual', '炒锅', null);
INSERT INTO `sp_attribute` VALUES ('2645', '显示参数-直径', '578', 'only', 'manual', '32厘米', null);
INSERT INTO `sp_attribute` VALUES ('2646', '主体参数-类别', '579', 'only', 'manual', '全套厨房刀具', null);
INSERT INTO `sp_attribute` VALUES ('2647', '规格参数-尺寸', '579', 'only', 'manual', '350*190*90毫米', null);
INSERT INTO `sp_attribute` VALUES ('2648', '主体参数-品牌', '581', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2649', '规格参数-分类', '581', 'only', 'manual', '其它', null);
INSERT INTO `sp_attribute` VALUES ('2650', '包装参数-毛重', '581', 'only', 'manual', '3千克', null);
INSERT INTO `sp_attribute` VALUES ('2651', '主体参数-品牌', '582', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2652', '规格参数-尺寸', '582', 'only', 'manual', '100毫米', null);
INSERT INTO `sp_attribute` VALUES ('2653', '主体参数-品牌', '583', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2654', '规格参数-尺寸', '583', 'only', 'manual', '100*40*10毫米', null);
INSERT INTO `sp_attribute` VALUES ('2655', '主体参数-类别', '585', 'only', 'manual', '瓜果刀', null);
INSERT INTO `sp_attribute` VALUES ('2656', '规格参数-尺寸', '585', 'only', 'manual', '3毫米', null);
INSERT INTO `sp_attribute` VALUES ('2657', '削皮刀', '585', 'many', 'list', 'GP-1,GP-2,GP-3,GP-4,GP-5,GP-7,GP-8', null);
INSERT INTO `sp_attribute` VALUES ('2658', '主体参数-品牌', '586', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2659', '特性参数-形状', '586', 'only', 'manual', '长方形', null);
INSERT INTO `sp_attribute` VALUES ('2660', '规格参数-尺寸', '586', 'only', 'manual', '34毫米', null);
INSERT INTO `sp_attribute` VALUES ('2661', '主体参数-类别', '587', 'only', 'manual', '全套厨房刀具', null);
INSERT INTO `sp_attribute` VALUES ('2662', '规格参数-尺寸', '587', 'only', 'manual', '180*80*30毫米', null);
INSERT INTO `sp_attribute` VALUES ('2663', '主体参数-品牌', '588', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2664', '规格参数-尺寸', '588', 'only', 'manual', '205*105*355毫米', null);
INSERT INTO `sp_attribute` VALUES ('2665', '主体参数-商品名称', '58', 'only', 'manual', '西门子冰箱KM48EA60TI', null);
INSERT INTO `sp_attribute` VALUES ('2666', '基本参数-电压/频率', '58', 'only', 'manual', '220V/50Hz', null);
INSERT INTO `sp_attribute` VALUES ('2667', '功能参数-童锁功能', '58', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('2668', '规格参数-产品重量', '58', 'only', 'manual', '121千克', null);
INSERT INTO `sp_attribute` VALUES ('2669', '样式', '58', 'many', 'list', '452升 十字门设计,454升 零度保鲜,484升 快速冷冻,浅金色,珍珠灰色,银色', null);
INSERT INTO `sp_attribute` VALUES ('2670', '主体参数-品牌', '590', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2671', '特性参数-是否一次性使用', '590', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('2672', '颜色', '590', 'many', 'list', 'VJ雅紫色,AW雅蓝色,PX香槟色,TM棕黑色', null);
INSERT INTO `sp_attribute` VALUES ('2673', '主体参数-品牌', '592', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2674', '规格参数-是否一次性使用', '592', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('2675', '规格', '592', 'many', 'list', '六孔杯架,七孔杯架,十二孔杯架,十三孔杯架', null);
INSERT INTO `sp_attribute` VALUES ('2676', '主体参数-品牌', '594', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2677', '规格参数-直径', '594', 'only', 'manual', '9.7厘米', null);
INSERT INTO `sp_attribute` VALUES ('2678', '特性参数-保温功能', '594', 'only', 'manual', '保温', null);
INSERT INTO `sp_attribute` VALUES ('2679', '颜色', '594', 'many', 'list', '长颈鹿CG,小狮子EL,小老虎CT,小熊猫CP', null);
INSERT INTO `sp_attribute` VALUES ('2680', '主体-型号', '595', 'only', 'manual', '6927355501867', null);
INSERT INTO `sp_attribute` VALUES ('2681', '功能参数-是否带光源', '595', 'only', 'manual', '带光源', null);
INSERT INTO `sp_attribute` VALUES ('2682', '特性参数-工艺', '595', 'only', 'manual', '亚克力', null);
INSERT INTO `sp_attribute` VALUES ('2683', '规格参数-重量', '595', 'only', 'manual', '8.7千克', null);
INSERT INTO `sp_attribute` VALUES ('2684', '颜色', '595', 'many', 'list', '中卧室调光带遥控20瓦45*45cm适8-15平,中卧室正白光24瓦45*45cm适12-18平,中客厅正白光54瓦65*65cm适15-25平,超大客厅调光带遥控72瓦93*65cm适20-30平,中客厅调光带遥控54瓦65*65cm适15-25平,大客厅调光带遥控72w93*65cm莲花款,超大客厅正白光72瓦93*65cm适20-30平,大客厅调光带遥控64瓦82*65cm适18-28平,小客厅正白光27瓦65*43cm适10-16平,小客厅调光带遥控27瓦65*43cm适10-16平,中卧室正白光30瓦53*53cm适12-18平,中卧室调光带遥控30瓦53*53cm适12-18平,TCL网关接收器1个,小客厅白光二室一厅-A,客厅调光四室二厅-B,客厅白光三室二厅-D,客厅调光三室两厅-E,客厅调光四室二厅-H,全屋调光三室一厅-I,客厅调光三室二厅-N,客厅调光三室二厅-Q', null);
INSERT INTO `sp_attribute` VALUES ('2685', '主体-品牌', '596', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2686', '功能参数-是否带光源', '596', 'only', 'manual', '带光源', null);
INSERT INTO `sp_attribute` VALUES ('2687', '特性参数-工艺', '596', 'only', 'manual', '电镀', null);
INSERT INTO `sp_attribute` VALUES ('2688', '规格参数-重量', '596', 'only', 'manual', '15千克', null);
INSERT INTO `sp_attribute` VALUES ('2689', '颜色', '596', 'many', 'list', '套餐1一室一厅【到手价688元】,套餐2一室一厅【到手价799元】,套餐4二室一厅【到手价999】,套餐3二室一厅【到手价999】,套餐8二室二厅【到手价1299】,套餐5二室一厅【到手价1199】,套餐6二室一厅【到手价1499】,套餐7二室二厅【到手价1338】,套餐9二室二厅【到手价1499】,套餐10二室二厅【到手价1518】,套餐11三室二厅【到手价1399】,套餐12三室二厅【到手价1498】,套餐13三室二厅【到手价1599】,套餐14三室二厅【到手价2198】,套餐15四室二厅【到手价1668】,套餐16四室二厅【到手价1999】,套餐17四室二厅【到手价1999】', null);
INSERT INTO `sp_attribute` VALUES ('2690', '主体-品牌', '597', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2691', '功能参数-是否带光源', '597', 'only', 'manual', '带光源', null);
INSERT INTO `sp_attribute` VALUES ('2692', '特性参数-工艺', '597', 'only', 'manual', '电镀', null);
INSERT INTO `sp_attribute` VALUES ('2693', '规格参数-重量', '597', 'only', 'manual', '14千克', null);
INSERT INTO `sp_attribute` VALUES ('2694', '颜色', '597', 'many', 'list', '套餐A(包安装)【到手价1199】,套餐B(包安装)【到手价1199】,套餐C(包安装)【到手价1199】,套餐D(包安装)【到手价1199】,套餐E（三室两厅）【特大】,套餐F（三室两厅）【特大】,套餐G(两室两厅)【包安装】,套餐H(两室两厅)【包安装】,套餐I(三室一厅)【包安装】,套餐J(三室一厅)【包安装】,套餐K（包安装）【到手价1259】,套餐L（两室一厅）,套餐M（两室一厅）,简约版50x50cm三色分段,简约版50x50cm三色遥控,简约版60x40cm三色遥控,简约版80x60cm三色遥控,简约版95x75cm三色分段,简约版95x75cm三色遥控,简约版120x80cm三色遥控,孔雀版50x50cm三色分段,孔雀版65x43cm三色分段,孔雀版65x43cm三色遥控,孔雀版80x60cm三色分段,孔雀版80x60cm三色遥控,孔雀版95x75cm三色分段,孔雀版95x75cm三色遥控,孔雀版110*80cm三色遥控,白色', null);
INSERT INTO `sp_attribute` VALUES ('2695', '主体-品牌', '598', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2696', '特性参数-工艺', '598', 'only', 'manual', '烤漆', null);
INSERT INTO `sp_attribute` VALUES ('2697', '规格参数-电压', '598', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('2698', '颜色', '598', 'many', 'list', '3头黑色,3头白色,6头黑色,6头白色,8头黑色,8头白色,10黑色,10头白色', null);
INSERT INTO `sp_attribute` VALUES ('2699', '主体参数-商品名称', '59', 'only', 'manual', '海尔冰箱BCD-258WDPM', null);
INSERT INTO `sp_attribute` VALUES ('2700', '基本参数-电压/频率', '59', 'only', 'manual', '220V/50Hz', null);
INSERT INTO `sp_attribute` VALUES ('2701', '功能参数-是否支持开门转换', '59', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('2702', '规格参数-产品重量', '59', 'only', 'manual', '75千克', null);
INSERT INTO `sp_attribute` VALUES ('2703', '颜色', '59', 'many', 'list', '228升 匀冷冰箱（白色）,258升 风冷冰箱（银灰色）,260升 彩晶冰箱（白色）', null);
INSERT INTO `sp_attribute` VALUES ('2704', '主体-商品名称', '5', 'only', 'manual', '海信电视LED55EC520UA', null);
INSERT INTO `sp_attribute` VALUES ('2705', '显示-曲面', '5', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('2706', '系统-智能电视', '5', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('2707', '外观-产品颜色', '5', 'only', 'manual', '高光黑', null);
INSERT INTO `sp_attribute` VALUES ('2708', 'USB支持格式-USB支持视频格式', '5', 'only', 'manual', 'AVI,MPG,TS,MKV,MOV,MP4,RM,RMVB', null);
INSERT INTO `sp_attribute` VALUES ('2709', '功耗-整机功率（W）', '5', 'only', 'manual', '170瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2710', '规格-含底座尺寸（宽*高*', '5', 'only', 'manual', '1244×773×268毫米', null);
INSERT INTO `sp_attribute` VALUES ('2711', '网络-网络连接方式', '5', 'only', 'manual', '有线+无线', null);
INSERT INTO `sp_attribute` VALUES ('2712', '端口-USB2.0端口', '5', 'only', 'manual', '2个', null);
INSERT INTO `sp_attribute` VALUES ('2713', '音频-扬声器数量', '5', 'only', 'manual', '2', null);
INSERT INTO `sp_attribute` VALUES ('2714', '交互设备-无线键鼠', '5', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2715', '互联互通-多屏互动', '5', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('2716', '包装清单-包装清单', '5', 'only', 'manual', '产品说明书*1，遥控器*1，电源线*1，螺钉*N', null);
INSERT INTO `sp_attribute` VALUES ('2717', '版式', '5', 'many', 'list', '43英寸 4K智能,43英寸 4K观影神器,49英寸 4K智能,49英寸 4K超高清,49英寸 4K金属超薄,50英寸 4K观影神器,55英寸 4K智能,55英寸 4K观影神器,60英寸 4K观影神器,65英寸 4K观影神器', null);
INSERT INTO `sp_attribute` VALUES ('2718', '主体-品牌', '600', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2719', '功能参数-适用空间', '600', 'only', 'manual', '客厅', null);
INSERT INTO `sp_attribute` VALUES ('2720', '特性参数-工艺', '600', 'only', 'manual', '铁', null);
INSERT INTO `sp_attribute` VALUES ('2721', '规格参数-电压', '600', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('2722', '颜色', '600', 'many', 'list', '美式壁灯【送E27的灯泡*1】,美式三头【送E27的灯泡*3】,美式六头【送E27的灯泡*6】,美式八头【送E27灯泡*8】,美式十头【送E27的灯泡*10】,美式两室一厅,美式两室两厅A,美式两室两厅B,美式三室两厅', null);
INSERT INTO `sp_attribute` VALUES ('2723', '主体-品牌', '601', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2724', '功能参数-适用空间', '601', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2725', '特性参数-工艺', '601', 'only', 'manual', '冲压 电脑冲孔 镀金 打磨', null);
INSERT INTO `sp_attribute` VALUES ('2726', '规格参数-电压', '601', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('2727', '主体-品牌', '602', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2728', '功能参数-适用空间', '602', 'only', 'manual', '客厅', null);
INSERT INTO `sp_attribute` VALUES ('2729', '特性参数-工艺', '602', 'only', 'manual', '雕刻', null);
INSERT INTO `sp_attribute` VALUES ('2730', '规格参数-电压', '602', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('2731', '颜色', '602', 'many', 'list', '双环直径43+25CM白光LED光源,双环直径43+25CM暧光LED光源,双环直径43+25CM无极调光LED光源,双环直径52+34CM白光LED光源,双环直径52+34CM暧光LED光源,双环直径52+34CM无极调光LED光源,三环直径64+43+25CM白光LED光源,三环直径64+43+25CM暧光LED光源,三环直径64+43+25CM无极调光LED光源,三环直径74+52+34CM白光LED光源,三环直径74+52+34CM暧光LED光源,三环直径74+52+34CM无极调光LED光源,四环直径88+64+43+25CM白光LED光源,四环直径88+64+43+25CM暧光LED光源,四环直径88+64+43+25CM无极调光LED光源,四环直径100+74+52+34CM白光LED光源,四环直径100+74+52+34CM暧光LED光源,四环直径100+74+52+34CM无极调光LED光源', null);
INSERT INTO `sp_attribute` VALUES ('2732', '主体-类型', '603', 'only', 'manual', '风扇吊灯', null);
INSERT INTO `sp_attribute` VALUES ('2733', '功能参数-适用空间', '603', 'only', 'manual', '客厅', null);
INSERT INTO `sp_attribute` VALUES ('2734', '特性参数-工艺', '603', 'only', 'manual', '铁', null);
INSERT INTO `sp_attribute` VALUES ('2735', '规格参数-电压', '603', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('2736', '颜色', '603', 'many', 'list', '【灵风】隐形扇叶Φ91*40.5CM遥控智控24瓦双色分控,【醇风】隐形扇叶Φ90*43CM遥控18瓦LED白光,【旭风】隐形扇叶Φ90*43CM遥控18瓦LED白光,【双银款】隐形扇叶Φ90*44CM遥控18瓦LED白光,【荷莲】隐形扇叶Φ91*43CM遥控24瓦调色,【鸟巢】隐形扇叶Φ91*42.5CM遥控24瓦调色,【凉风】隐形扇叶Φ90*38CM遥控18瓦调光调色,【凉风】隐形扇叶Φ106.6*40CM遥控24瓦调光调色,【凌风】隐形扇叶Φ90*59CM遥控18瓦双色光源,【清风】木艺扇叶Φ132*50CM拉控三挡风速送3瓦暖黄光源,【闪亮风】木艺扇叶Φ129*42CM遥控三挡风速8瓦白光,【雪风】木艺扇叶Φ132*38CM遥控三挡风速21瓦白光,【自由风】木艺扇叶Φ120*50CM遥控三挡风速8瓦白光,【炫彩】儿童房Φ90*57CM18瓦双色光源,【风姿】简约型Φ44*120CM25瓦白光', null);
INSERT INTO `sp_attribute` VALUES ('2737', '主体-品牌', '604', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2738', '功能参数-适用空间', '604', 'only', 'manual', '客厅', null);
INSERT INTO `sp_attribute` VALUES ('2739', '特性参数-工艺', '604', 'only', 'manual', '烤漆', null);
INSERT INTO `sp_attribute` VALUES ('2740', '规格参数-电压', '604', 'only', 'manual', '240伏特', null);
INSERT INTO `sp_attribute` VALUES ('2741', '颜色', '604', 'many', 'list', '单头壁灯+led光源,6头吊灯+led光源,8头吊灯+led光源,10头吊灯+led光源,15头吊灯+led光源', null);
INSERT INTO `sp_attribute` VALUES ('2742', '主体-品牌', '605', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2743', '特性参数-家装风格', '605', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2744', '规格参数-重量', '605', 'only', 'manual', '2千克', null);
INSERT INTO `sp_attribute` VALUES ('2745', '颜色', '605', 'many', 'list', 'LED护眼台灯', null);
INSERT INTO `sp_attribute` VALUES ('2746', '主体-品牌', '606', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2747', '功能参数-适用空间', '606', 'only', 'manual', '卧室', null);
INSERT INTO `sp_attribute` VALUES ('2748', '特性参数-家装风格', '606', 'only', 'manual', '田园', null);
INSERT INTO `sp_attribute` VALUES ('2749', '规格参数-光源功率', '606', 'only', 'manual', '5-9W', null);
INSERT INTO `sp_attribute` VALUES ('2750', '颜色', '606', 'many', 'list', 'A款按键开关,B款按键开关,C款按键开关,D款按键开关,E款按键开关,G款按键开关', null);
INSERT INTO `sp_attribute` VALUES ('2751', '主体-品牌', '607', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2752', '功能参数-是否带光源', '607', 'only', 'manual', '不带光源', null);
INSERT INTO `sp_attribute` VALUES ('2753', '特性参数-光源类型', '607', 'only', 'manual', 'LED光源', null);
INSERT INTO `sp_attribute` VALUES ('2754', '规格参数-色温', '607', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2755', '主体参数-品牌', '608', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2756', '功能参数-适用空间', '608', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2757', '特性参数-家装风格', '608', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2758', '规格参数-功率', '608', 'only', 'manual', '1-45W瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2759', '主体-品牌', '609', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2760', '功能参数-是否带光源', '609', 'only', 'manual', '带光源', null);
INSERT INTO `sp_attribute` VALUES ('2761', '特性参数-光源类型', '609', 'only', 'manual', 'LED光源', null);
INSERT INTO `sp_attribute` VALUES ('2762', '规格参数-电压', '609', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('2763', '颜色', '609', 'many', 'list', '5W暖白,5W冷白,3W暖白,3W冷白,3W自然色', null);
INSERT INTO `sp_attribute` VALUES ('2764', '主体-型号', '610', 'only', 'manual', '筒灯', null);
INSERT INTO `sp_attribute` VALUES ('2765', '功能参数-是否带光源', '610', 'only', 'manual', '带光源', null);
INSERT INTO `sp_attribute` VALUES ('2766', '特性参数-工艺', '610', 'only', 'manual', '·', null);
INSERT INTO `sp_attribute` VALUES ('2767', '规格参数-重量', '610', 'only', 'manual', '0.5千克', null);
INSERT INTO `sp_attribute` VALUES ('2768', '颜色', '610', 'many', 'list', '亮白金5W暖白,亮白金3W暖白,高光银5W正白,烤漆白5W正白,烤漆白5W暖白,亮白金3W正白,高光银5W暖白,烤漆白3W正白,烤漆白3W暖白,亮白金5W正白,高光银3W正白,高光银3W暖白', null);
INSERT INTO `sp_attribute` VALUES ('2769', '主体参数-品牌', '611', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2770', '特性参数-家装风格', '611', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2771', '规格参数-电压', '611', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('2772', '颜色', '611', 'many', 'list', '3528暖白,3528正白,5058暖白,5058正白,3528电源线,5058电源线', null);
INSERT INTO `sp_attribute` VALUES ('2773', '主体参数-品牌', '612', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2774', '功能参数-适用空间', '612', 'only', 'manual', '客厅', null);
INSERT INTO `sp_attribute` VALUES ('2775', '特性参数-家装风格', '612', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2776', '规格参数-功率', '612', 'only', 'manual', '0-5W瓦特', null);
INSERT INTO `sp_attribute` VALUES ('2777', '主体参数-型号', '614', 'only', 'manual', '11173', null);
INSERT INTO `sp_attribute` VALUES ('2778', '功能参数-盖板是否缓冲', '614', 'only', 'manual', '缓冲', null);
INSERT INTO `sp_attribute` VALUES ('2779', '特性参数-冲水按键类型', '614', 'only', 'manual', '上按两段式', null);
INSERT INTO `sp_attribute` VALUES ('2780', '规格参数-安装方式', '614', 'only', 'manual', '固定', null);
INSERT INTO `sp_attribute` VALUES ('2781', '主体参数-品牌', '615', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2782', '特性参数-花洒形状', '615', 'only', 'manual', '圆形', null);
INSERT INTO `sp_attribute` VALUES ('2783', '规格参数-毛重', '615', 'only', 'manual', '3.5千克', null);
INSERT INTO `sp_attribute` VALUES ('2784', '颜色', '615', 'many', 'list', '魅童款-精铜喷枪-包入户安装,魅童款-全铜喷枪-覆盖区包入户', null);
INSERT INTO `sp_attribute` VALUES ('2785', '主体参数-品牌', '617', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2786', '特性参数-类别', '617', 'only', 'manual', '厨盆/水槽', null);
INSERT INTO `sp_attribute` VALUES ('2787', '规格参数-槽体深度', '617', 'only', 'manual', '200毫米', null);
INSERT INTO `sp_attribute` VALUES ('2788', '主体参数-品牌', '618', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2789', '特性参数-风格', '618', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2790', '规格参数-体积', '618', 'only', 'manual', '150000.000', null);
INSERT INTO `sp_attribute` VALUES ('2791', '颜色', '618', 'many', 'list', '50公分，送龙头角阀软管下水器组合，顺丰发货,60公分，送龙头角阀软管下水器组合，顺丰发货,80公分右侧柜，送龙头角阀软管下水器组合，顺丰发货,70公分，送龙头角阀软管下水器组合，顺丰发货,80公分右盆，送龙头角阀软管下水器组合，顺丰发货,默认尺寸', null);
INSERT INTO `sp_attribute` VALUES ('2792', '主体参数-品牌', '619', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2793', '特性参数-花洒形状', '619', 'only', 'manual', '圆形', null);
INSERT INTO `sp_attribute` VALUES ('2794', '规格参数-净重', '619', 'only', 'manual', '3千克', null);
INSERT INTO `sp_attribute` VALUES ('2795', '主体参数-商品名称', '61', 'only', 'manual', '海尔冰箱BCD-160TMPQ', null);
INSERT INTO `sp_attribute` VALUES ('2796', '基本参数-电压/频率', '61', 'only', 'manual', '220V/50Hz', null);
INSERT INTO `sp_attribute` VALUES ('2797', '功能参数-速冷速冻', '61', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2798', '规格参数-产品重量', '61', 'only', 'manual', '42千克', null);
INSERT INTO `sp_attribute` VALUES ('2799', '颜色', '61', 'many', 'list', '133升 双门冰箱（白色）,248升 双门冰箱（银灰色）,225升 双门冰箱（银灰色）,160升 双门冰箱（灰色）', null);
INSERT INTO `sp_attribute` VALUES ('2800', '主体-型号', '620', 'only', 'manual', 'ZY-3649', null);
INSERT INTO `sp_attribute` VALUES ('2801', '规格参数-重量', '620', 'only', 'manual', '0.3克', null);
INSERT INTO `sp_attribute` VALUES ('2802', '颜色', '620', 'many', 'list', '免打孔双层铝板转角,双层铝板转角', null);
INSERT INTO `sp_attribute` VALUES ('2803', '主体参数-品牌', '621', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2804', '特性参数-产品尺寸', '621', 'only', 'manual', '默认值毫米', null);
INSERT INTO `sp_attribute` VALUES ('2805', '规格参数-龙头款式', '621', 'only', 'manual', '单把单孔', null);
INSERT INTO `sp_attribute` VALUES ('2806', '颜色', '621', 'many', 'list', '32150-126,32150-341', null);
INSERT INTO `sp_attribute` VALUES ('2807', '主体参数-品牌', '622', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2808', '功能参数-功能', '622', 'only', 'manual', '防臭防虫地漏', null);
INSERT INTO `sp_attribute` VALUES ('2809', '规格参数-规格', '622', 'only', 'manual', '套', null);
INSERT INTO `sp_attribute` VALUES ('2810', '颜色', '622', 'many', 'list', '通用沐浴TK40-10,通用套餐6,通用洗衣机XTF40-10,通用马桶旁TF40-10', null);
INSERT INTO `sp_attribute` VALUES ('2811', '主体-品牌', '623', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2812', '功能参数-功能', '623', 'only', 'manual', '洗澡', null);
INSERT INTO `sp_attribute` VALUES ('2813', '特性参数-款式', '623', 'only', 'manual', 'null', null);
INSERT INTO `sp_attribute` VALUES ('2814', '规格参数-长度', '623', 'only', 'manual', '≈1.7m', null);
INSERT INTO `sp_attribute` VALUES ('2815', '主体参数-品牌', '624', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2816', '功能参数-盖板是否缓冲', '624', 'only', 'manual', '缓冲', null);
INSERT INTO `sp_attribute` VALUES ('2817', '规格参数-安装方式', '624', 'only', 'manual', '自助式', null);
INSERT INTO `sp_attribute` VALUES ('2818', '主体参数-型号', '625', 'only', 'manual', 'F301F302', null);
INSERT INTO `sp_attribute` VALUES ('2819', '功能参数-功能', '625', 'only', 'manual', '进水开关', null);
INSERT INTO `sp_attribute` VALUES ('2820', '规格参数-包装尺寸', '625', 'only', 'manual', '10.5.3厘米', null);
INSERT INTO `sp_attribute` VALUES ('2821', '颜色', '625', 'many', 'list', '3蓝2红,1个蓝色,1个红色,1蓝1红,2蓝1红,4蓝3红,镀铬无色', null);
INSERT INTO `sp_attribute` VALUES ('2822', '主体参数-品牌', '626', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2823', '功能参数-是否内含蒸汽', '626', 'only', 'manual', '不含蒸汽', null);
INSERT INTO `sp_attribute` VALUES ('2824', '规格参数-净重', '626', 'only', 'manual', '25克', null);
INSERT INTO `sp_attribute` VALUES ('2825', '颜色', '626', 'many', 'list', '900*900*1850,1000*1000*1850', null);
INSERT INTO `sp_attribute` VALUES ('2826', '主体参数-品牌', '627', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2827', '功能参数-功能', '627', 'only', 'manual', '台下式', null);
INSERT INTO `sp_attribute` VALUES ('2828', '规格参数-净重', '627', 'only', 'manual', '2千克', null);
INSERT INTO `sp_attribute` VALUES ('2829', '主体参数-品牌', '628', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2830', '规格参数-净重', '628', 'only', 'manual', '20千克', null);
INSERT INTO `sp_attribute` VALUES ('2831', '主体参数-品牌', '629', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2832', '功能参数-下水配置', '629', 'only', 'manual', '下水手动', null);
INSERT INTO `sp_attribute` VALUES ('2833', '规格参数-产品尺寸', '629', 'only', 'manual', '450*400*660厘米', null);
INSERT INTO `sp_attribute` VALUES ('2834', '颜色', '629', 'many', 'list', '覆盖区域内送货上门（不包安装）,覆盖区域内送货上门（包安装）', null);
INSERT INTO `sp_attribute` VALUES ('2835', '主体参数-商品名称', '62', 'only', 'manual', '海尔冷柜BC/BD-201HZA', null);
INSERT INTO `sp_attribute` VALUES ('2836', '基本参数-制冷方式', '62', 'only', 'manual', '直冷', null);
INSERT INTO `sp_attribute` VALUES ('2837', '功能参数-是否带锁', '62', 'only', 'manual', '不带锁', null);
INSERT INTO `sp_attribute` VALUES ('2838', '规格参数-产品重量', '62', 'only', 'manual', '40千克', null);
INSERT INTO `sp_attribute` VALUES ('2839', '版式', '62', 'many', 'list', '101升冷藏冷冻转换柜,103升低霜冷藏冷冻转换柜,103升彩晶低霜冷藏冷冻转换柜,103升彩晶低霜冷藏冷冻转换柜（黄）,120升立卧组合单温冷冻柜,120升立卧组合单温冷冻柜黄色,141升冷藏冷冻转换柜,142升彩晶低霜冷藏冷冻转换柜,201升冷藏冷冻转换柜,203升彩晶低霜冷藏冷冻转换柜,456升风冷对开门冰箱,518升风冷对开门冰箱,66升冷藏冷冻转换迷你柜', null);
INSERT INTO `sp_attribute` VALUES ('2840', '主体参数-品牌', '630', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2841', '功能参数-电子电工类型', '630', 'only', 'manual', '86型', null);
INSERT INTO `sp_attribute` VALUES ('2842', '规格参数-产品重量', '630', 'only', 'manual', '5克', null);
INSERT INTO `sp_attribute` VALUES ('2843', '颜色', '630', 'many', 'list', '三USB五孔3只装,正五孔10只组合套装,斜5孔10只组合套装,19只组合套装,24只组合套装开关,32只组合套装,一开单控,一开双控,二开单控,二开双控,三开单控,三开双控,四开双控,四孔,三孔10A,三孔16A,五孔10A,斜五孔10A,单控三孔16A（大功率）,双控五孔10A,USB五孔插座,一位电脑,一位电视,一位电话,电脑电视,白板,防溅盒,暗装底盒,一位空调插座25A,四孔插座,墙壁开关/插座', null);
INSERT INTO `sp_attribute` VALUES ('2844', '主体-品牌', '631', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2845', '规格参数-插孔数', '631', 'only', 'manual', '二三插', null);
INSERT INTO `sp_attribute` VALUES ('2846', '颜色', '631', 'many', 'list', '错位五孔,正位五孔,10只五孔套餐,一开单控,一开双控,一开多控,二开单控,二开双控,三开单控,三开双控,四开单控,四开双控,空调16A,一开三孔,一开五孔,电视插座,电脑插座,电话插座,电视电脑,电话电脑,电视电话,空白面板,金色防水盒,金色地插,CD520香槟金', null);
INSERT INTO `sp_attribute` VALUES ('2847', '主体参数-品牌', '632', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2848', '规格参数-包装尺寸', '632', 'only', 'manual', '20厘米', null);
INSERT INTO `sp_attribute` VALUES ('2849', '颜色', '632', 'many', 'list', '黄色,红色,黄绿色,蓝色,BV6²50米,BV1.5²100米,BV2.5²100米,BV4²100米', null);
INSERT INTO `sp_attribute` VALUES ('2850', '主体参数-类别', '633', 'only', 'manual', '空气开关', null);
INSERT INTO `sp_attribute` VALUES ('2851', '功能参数-灭弧方式', '633', 'only', 'manual', '磁吹断路器', null);
INSERT INTO `sp_attribute` VALUES ('2852', '规格参数-额定电流', '633', 'only', 'manual', '63A', null);
INSERT INTO `sp_attribute` VALUES ('2853', '极数', '633', 'many', 'list', '1P,2P,3P,4P,10A,16A,20A,25A,32A,40A,63A', null);
INSERT INTO `sp_attribute` VALUES ('2854', '主体参数-品牌', '634', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2855', '功能参数-把手材质', '634', 'only', 'manual', '锌合金', null);
INSERT INTO `sp_attribute` VALUES ('2856', '规格参数-用途', '634', 'only', 'manual', '室内门锁', null);
INSERT INTO `sp_attribute` VALUES ('2857', '颜色', '634', 'many', 'list', '金间黑单把锁,黄古铜单把锁+三片字母合页+一个门吸,黄古铜单把锁,黄古铜单把锁+两片平开合页+一个门吸,黄古铜单把锁+三片平开合页+一个门吸,黄古铜单把锁+两片字母合页+一个门吸,金间黑单把锁+两片字母合页+一个门吸,金间黑单把锁+三片字母合页+一个门吸,金间黑单把锁+两片平开合页+一个门吸,金间黑单把锁+三片平开合页+一个门吸,通用型', null);
INSERT INTO `sp_attribute` VALUES ('2858', '主体-类型', '635', 'only', 'manual', '成套监控系统', null);
INSERT INTO `sp_attribute` VALUES ('2859', '特性参数-告知', '635', 'only', 'manual', '不含硬盘，显示器', null);
INSERT INTO `sp_attribute` VALUES ('2860', '规格参数-产品尺寸', '635', 'only', 'manual', '59*290*370毫米', null);
INSERT INTO `sp_attribute` VALUES ('2861', '线素', '635', 'many', 'list', '960P双灯,1080P双灯,1080P四灯,1路,2路,3路,4路,6路,8路,16路', null);
INSERT INTO `sp_attribute` VALUES ('2862', '主体参数-品牌', '636', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2863', '特性参数-电源类型', '636', 'only', 'manual', '交流', null);
INSERT INTO `sp_attribute` VALUES ('2864', '规格参数-电源电压', '636', 'only', 'manual', '220伏特', null);
INSERT INTO `sp_attribute` VALUES ('2865', '颜色', '636', 'many', 'list', 'GI550RE,至尊豪华版GI550RE-Plus', null);
INSERT INTO `sp_attribute` VALUES ('2866', '主体参数-品牌', '637', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2867', '规格参数-规格', '637', 'only', 'manual', 'ET-DZ82', null);
INSERT INTO `sp_attribute` VALUES ('2868', '主体-类别', '639', 'only', 'manual', '电动螺丝批', null);
INSERT INTO `sp_attribute` VALUES ('2869', '功能参数-功能', '639', 'only', 'manual', '拧螺丝、钻孔', null);
INSERT INTO `sp_attribute` VALUES ('2870', '特性参数-电源类型', '639', 'only', 'manual', '直流电', null);
INSERT INTO `sp_attribute` VALUES ('2871', '规格参数-包装方式', '639', 'only', 'manual', '纸箱', null);
INSERT INTO `sp_attribute` VALUES ('2872', '主体参数-商品名称', '63', 'only', 'manual', '雪花（SNOWFLK）LCD-120 1.2米双机 冷藏冷冻冰柜 点菜柜 麻辣烫柜 保鲜柜 冷藏柜 展示柜冷藏 商用冷柜', null);
INSERT INTO `sp_attribute` VALUES ('2873', '基本参数-制冷方式', '63', 'only', 'manual', '直冷', null);
INSERT INTO `sp_attribute` VALUES ('2874', '功能参数-是否带锁', '63', 'only', 'manual', '不带锁', null);
INSERT INTO `sp_attribute` VALUES ('2875', '规格参数-产品重量', '63', 'only', 'manual', '108千克', null);
INSERT INTO `sp_attribute` VALUES ('2876', '雪花点菜柜', '63', 'many', 'list', '1.2米双门上冷藏下冷冻,1.4米双门上冷藏下冷冻,1.6米双门上冷藏下冷冻,1.8米双门上冷藏下冷冻,2米三门上冷藏下冷冻', null);
INSERT INTO `sp_attribute` VALUES ('2877', '主体参数-品牌', '640', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2878', '规格参数-净重', '640', 'only', 'manual', '0.5千克', null);
INSERT INTO `sp_attribute` VALUES ('2879', '主体-建材材质', '641', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2880', '功能参数-测距距离', '641', 'only', 'manual', '60', null);
INSERT INTO `sp_attribute` VALUES ('2881', '规格参数-类别', '641', 'only', 'manual', '激光测距仪', null);
INSERT INTO `sp_attribute` VALUES ('2882', '主体参数-品牌', '642', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2883', '功能参数-适配系统', '642', 'only', 'manual', 'ios,Android', null);
INSERT INTO `sp_attribute` VALUES ('2884', '其他参数-重量', '642', 'only', 'manual', '6千克', null);
INSERT INTO `sp_attribute` VALUES ('2885', '型号', '642', 'many', 'list', 'DL-502,DL-533,DL-805,DL-810', null);
INSERT INTO `sp_attribute` VALUES ('2886', '主体-类别', '647', 'only', 'manual', '地板垫', null);
INSERT INTO `sp_attribute` VALUES ('2887', '特性-国产/进口', '647', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('2888', '主体-品牌', '648', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2889', '功能-是否包同色踢脚线', '648', 'only', 'manual', '不包', null);
INSERT INTO `sp_attribute` VALUES ('2890', '特性-企口类型', '648', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2891', '规格-地板厚度', '648', 'only', 'manual', '18毫米', null);
INSERT INTO `sp_attribute` VALUES ('2892', '主体-类别', '649', 'only', 'manual', '强化复合地板', null);
INSERT INTO `sp_attribute` VALUES ('2893', '功能-是否包同色踢脚线', '649', 'only', 'manual', '不包', null);
INSERT INTO `sp_attribute` VALUES ('2894', '特性-企口类型', '649', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2895', '规格-地板厚度', '649', 'only', 'manual', '20毫米', null);
INSERT INTO `sp_attribute` VALUES ('2896', '颜色', '649', 'many', 'list', '地垫宝,1.08m²', null);
INSERT INTO `sp_attribute` VALUES ('2897', '主体-类别', '650', 'only', 'manual', '内墙乳胶漆', null);
INSERT INTO `sp_attribute` VALUES ('2898', '功能参数-是否可调色', '650', 'only', 'manual', '可调色', null);
INSERT INTO `sp_attribute` VALUES ('2899', '规格参数-容量', '650', 'only', 'manual', '18升', null);
INSERT INTO `sp_attribute` VALUES ('2900', '主体-类别', '652', 'only', 'manual', '木器漆', null);
INSERT INTO `sp_attribute` VALUES ('2901', '特性-附加功能', '652', 'only', 'manual', '防锈,防霉', null);
INSERT INTO `sp_attribute` VALUES ('2902', '规格-容量', '652', 'only', 'manual', '2.5升', null);
INSERT INTO `sp_attribute` VALUES ('2903', '颜色', '652', 'many', 'list', 'A814-68205清底漆,A814-68202清面漆,2.5KG', null);
INSERT INTO `sp_attribute` VALUES ('2904', '主体-类别', '653', 'only', 'manual', '无纺布墙纸', null);
INSERT INTO `sp_attribute` VALUES ('2905', '特性参数-家装风格', '653', 'only', 'manual', '欧式', null);
INSERT INTO `sp_attribute` VALUES ('2906', '规格参数-计价单位', '653', 'only', 'manual', '元/卷', null);
INSERT INTO `sp_attribute` VALUES ('2907', '颜色', '653', 'many', 'list', '法国高端无缝绸缎布/平方米,美国透气无纺布/平方米,法国宫廷无缝油画布/平方米,英国皇家无缝丝绸布/平方米,瑞士无缝珠光布/平方米,5D无缝新工艺/平方米,德国环保无缝宣绒布/平方米', null);
INSERT INTO `sp_attribute` VALUES ('2908', '主体-品牌', '654', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2909', '特性参数-工艺', '654', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('2910', '规格参数-规格', '654', 'only', 'manual', '米', null);
INSERT INTO `sp_attribute` VALUES ('2911', '颜色', '654', 'many', 'list', '3D感--青灰砖0.6米宽长1米,牛货--花岗砖0.6米宽长1米,浅黄砖--0.6米宽长1米,复古彩砖-0.6米宽长1米', null);
INSERT INTO `sp_attribute` VALUES ('2912', '主体-型号', '655', 'only', 'manual', 'E8016', null);
INSERT INTO `sp_attribute` VALUES ('2913', '特性参数-国产/进口', '655', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('2914', '规格参数-尺寸', '655', 'only', 'manual', '80x80厘米', null);
INSERT INTO `sp_attribute` VALUES ('2915', '特性参数-是否可调节', '656', 'only', 'manual', '不可调节', null);
INSERT INTO `sp_attribute` VALUES ('2916', '主体参数-类别', '656', 'only', 'manual', '床', null);
INSERT INTO `sp_attribute` VALUES ('2917', '规格参数-适用范围', '656', 'only', 'manual', '卧室', null);
INSERT INTO `sp_attribute` VALUES ('2918', '颜色', '656', 'many', 'list', '1.5米-单床【排骨架】,1.5米-单床【高箱款】,1.8米-单床【排骨架】,1.8米-单床【高箱款】,1.5米-床+床头柜*2【排骨架】,1.5米-床+床头柜*2【高箱款】,1.8米-床+床头柜*2【排骨架】,1.8米-床+床头柜*2【高箱款】,1.5米-床+床垫+床头柜*1【排骨架】,1.5米-床+床垫+床头柜*1【高箱款】,1.8米-床+床垫+床头柜*1【排骨架】,1.8米-床+床垫+床头柜*1【高箱款】,1.5米-床+床垫+床头柜*2【排骨架】,1.5米-床+床垫+床头柜*2【高箱款】,1.8米-床+床垫+床头柜*2【排骨架】,1.8米-床+床垫+床头柜*2【高箱款】', null);
INSERT INTO `sp_attribute` VALUES ('2919', '主体参数-品牌', '657', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2920', '功能参数-是否可定制', '657', 'only', 'manual', '不可定制', null);
INSERT INTO `sp_attribute` VALUES ('2921', '特性参数-适用范围', '657', 'only', 'manual', '卧室', null);
INSERT INTO `sp_attribute` VALUES ('2922', '规格参数-外形尺寸', '657', 'only', 'manual', '200厘米', null);
INSERT INTO `sp_attribute` VALUES ('2923', '颜色', '657', 'many', 'list', '1.5*2*0.1米,1.2*1.9*0.1米,1.35*2*0.1米,1.5*1.9*0.1米,1.8*2*0.1米,1.35*1.9*0.1米,1.2*2*0.1米', null);
INSERT INTO `sp_attribute` VALUES ('2924', '主体参数-型号', '658', 'only', 'manual', '601', null);
INSERT INTO `sp_attribute` VALUES ('2925', '特性参数-适用范围', '658', 'only', 'manual', '卧室', null);
INSERT INTO `sp_attribute` VALUES ('2926', '规格参数-高度', '658', 'only', 'manual', '200厘米', null);
INSERT INTO `sp_attribute` VALUES ('2927', '颜色', '658', 'many', 'list', '两门衣柜,三门衣柜,四门衣柜,五门衣柜,六门衣柜,两门【带顶柜】,三门【带顶柜】,四门【带顶柜】,五门衣柜【带顶柜】,六门【带顶柜】,两门【带转角柜（默认不带抽屉）】,三门【带转角柜（默认不带抽屉）】,四门【带转角柜（默认不带抽屉）】,五门【带转角柜（默认不带抽屉）】,六门【带转角柜（默认不带抽屉）】,两门【带顶柜+转角柜（默认不带抽屉）+角柜】,三门【带顶柜+转角柜（默认不带抽屉）+角柜】,四门【带顶柜+转角柜（默认不带抽屉）+角柜】,五门【带顶柜+转角柜（默认不带抽屉）+角柜】,六门【带顶柜+转角柜（默认不带抽屉）+角柜】', null);
INSERT INTO `sp_attribute` VALUES ('2928', '主体参数-商品名称', '65', 'only', 'manual', '海尔冰箱BCD-452WDPF', null);
INSERT INTO `sp_attribute` VALUES ('2929', '基本参数-电压/频率', '65', 'only', 'manual', '220V/50Hz', null);
INSERT INTO `sp_attribute` VALUES ('2930', '功能参数-童锁功能', '65', 'only', 'manual', '无', null);
INSERT INTO `sp_attribute` VALUES ('2931', '规格参数-产品重量', '65', 'only', 'manual', '92千克', null);
INSERT INTO `sp_attribute` VALUES ('2932', '海尔对开门', '65', 'many', 'list', '【双变频】香槟金649升,【变频升级】风冷576升,【旗舰双变频】彩晶590升,【热销超薄】452升,【爆款】香槟金642升', null);
INSERT INTO `sp_attribute` VALUES ('2933', '主体参数-品牌', '660', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2934', '规格参数-家装风格', '660', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2935', '颜色', '660', 'many', 'list', '床头柜', null);
INSERT INTO `sp_attribute` VALUES ('2936', '主体参数-型号', '661', 'only', 'manual', 'D404', null);
INSERT INTO `sp_attribute` VALUES ('2937', '特性参数-是否可定制', '661', 'only', 'manual', '不可定制', null);
INSERT INTO `sp_attribute` VALUES ('2938', '规格参数-体积', '661', 'only', 'manual', '0.5', null);
INSERT INTO `sp_attribute` VALUES ('2939', '颜色', '661', 'many', 'list', 'B款白色,D款粉色,C款粉色,A款粉色,C款白色,A款银色,C款红木色,D款白色,A款白色,D款红木色', null);
INSERT INTO `sp_attribute` VALUES ('2940', '主体参数-品牌', '662', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2941', '功能参数-是否带镜', '662', 'only', 'manual', '带镜', null);
INSERT INTO `sp_attribute` VALUES ('2942', '特性参数-家装风格', '662', 'only', 'manual', '欧式', null);
INSERT INTO `sp_attribute` VALUES ('2943', '规格参数-体积', '662', 'only', 'manual', '体积立方米', null);
INSERT INTO `sp_attribute` VALUES ('2944', '颜色', '662', 'many', 'list', '象牙白精品四抽送凳子T,象牙白收纳梳妆台送凳子T,纯白新款四抽送凳子T,纯白精品四抽送凳子T,纯白欧式七抽送凳子T,象牙白欧式七抽送凳子T,象牙白新款四抽送凳子T,纯白收纳梳妆台送凳子T', null);
INSERT INTO `sp_attribute` VALUES ('2945', '特性参数-是否可调节', '663', 'only', 'manual', '可调节', null);
INSERT INTO `sp_attribute` VALUES ('2946', '主体参数-品牌', '663', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2947', '规格参数-适用范围', '663', 'only', 'manual', '卧室', null);
INSERT INTO `sp_attribute` VALUES ('2948', '颜色', '663', 'many', 'list', '1.5m雕花排骨架,1.8m雕花排骨架,1.5m雕花高箱床,1.8m雕花高箱床,1.5m雕花排骨架+床头柜+床垫,1.8m雕花排骨架+床头柜+床垫,1.5m雕花排骨架+2床头柜,1.8雕花排骨架+2床头柜,1.5m雕花高箱床+床头柜+床垫,1.8m雕花高箱床+床头柜+床垫,1.5m雕花高箱床+2床头柜,1.8m雕花高箱床+2床头柜,1.5m皮床尾（排骨架）,1.8m皮床尾（排骨架）,1.5m皮床尾(高箱）,1.8m皮床尾(高箱）,1.5m皮床尾+床头柜+床垫(排骨架）,1.8m皮床尾+床头柜+床垫(排骨架）,1.5m皮床尾+2床头柜(排骨架）,1.8m皮床尾+2床头柜(排骨架）,1.5m皮床尾+床头柜+床垫(高箱）,1.8m皮床尾+床头柜+床垫(高箱）,1.5m皮床尾+2床头柜(高箱）,1.8m皮床尾+2床头柜(高箱）,1.5m平床尾排骨架,1.8m平尾排骨架,1.5m平尾高箱床,1.8m平尾高箱床,1.5m平尾排骨架+床头柜+床垫,1.8m平尾排骨架+床头柜+床垫,1.5m平尾排骨架+2床头柜,1.8m平尾排骨架+2床头柜,1.5m平尾高箱床+床头柜+床垫,1.8m平尾高箱床+床头柜+床垫,1.5m平尾高箱床+2床头柜,1.8m平尾高箱床+2床头柜,1.5m排骨架,1.8米排骨架,1.5m雕花排骨架+床头柜*2+床垫,1.8m雕花排骨架+床头柜*2+床垫,1.5m雕花高箱床+床头柜*2+床垫,1.8m高箱床+床头柜*2+床垫,1.5m皮床尾+床头柜*2+床垫(排骨架）,1.8m皮床尾+床头柜*2+床垫(排骨架）,1.5m皮床尾+床头柜*2+床垫(高箱）,1.8m皮床尾+床头柜*2+床垫(高箱）,1.5m平尾排骨架+床头柜*2+床垫,1.8m平尾排骨架+床头柜*2+床垫,1.5m平尾高箱床+床头柜*2+床垫,1.8m平尾高箱床+床头柜*2+床垫', null);
INSERT INTO `sp_attribute` VALUES ('2949', '主体参数-品牌', '666', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2950', '功能参数-是否可定制', '666', 'only', 'manual', '不可定制', null);
INSERT INTO `sp_attribute` VALUES ('2951', '特性参数-适用范围', '666', 'only', 'manual', '卧室', null);
INSERT INTO `sp_attribute` VALUES ('2952', '规格参数-外形尺寸', '666', 'only', 'manual', '21厘米', null);
INSERT INTO `sp_attribute` VALUES ('2953', '颜色', '666', 'many', 'list', '1.8*2*0.21米,1.5*2*0.21米,1.5*1.9*0.21米', null);
INSERT INTO `sp_attribute` VALUES ('2954', '主体参数-品牌', '668', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2955', '特性参数-是否可定制', '668', 'only', 'manual', '不可定制', null);
INSERT INTO `sp_attribute` VALUES ('2956', '规格参数-体积', '668', 'only', 'manual', '1.1', null);
INSERT INTO `sp_attribute` VALUES ('2957', '颜色', '668', 'many', 'list', '1.5m床（升级高箱咨询客服）,1.8m床（升级高箱咨询客服）,1.5m床+左床头柜,1.5m床+右床头柜,1.8m床+左床头柜,1.8m床+右床头柜,1.5m床+床头柜*2,1.8m床+床头柜*2,1.5m床+左床头柜+床垫,1.5m床+右床头柜+床垫,1.8m床+左床头柜+床垫,1.8m床+右床头柜+床垫,1.5m床+床头柜*2+床垫,1.8m床+床头柜*2+床垫,1.5m床+床头柜*2+床垫+四门衣柜,1.8m床+床头柜*2+床垫+五门衣柜,1.8m床+床头柜*2+床垫+四门衣柜,1.5m床+床头柜*2+床垫+五门衣柜,1.8m床+床头柜*2+四门衣柜+妆台（含妆凳）,1.5m床+床头柜*2+四门衣柜+妆台（含妆凳）', null);
INSERT INTO `sp_attribute` VALUES ('2958', '主体参数-品牌', '670', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2959', '特性参数-家装风格', '670', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2960', '规格参数-尺寸', '670', 'only', 'manual', '400厘米', null);
INSERT INTO `sp_attribute` VALUES ('2961', '颜色', '670', 'many', 'list', '双人+贵妃乳胶款沉稳灰,双人+贵妃乳胶款浅杏色,双人+贵妃乳胶款湖水蓝,双人+贵妃乳胶款咖啡褐,双人+单人+贵妃乳胶款沉稳灰,双人+单人+贵妃乳胶款浅杏色,双人+单人+贵妃乳胶款湖水蓝,双人+单人+贵妃乳胶款咖啡褐,双人+贵妃普通款沉稳灰,双人+贵妃普通款浅杏色,双人+贵妃普通款湖水蓝,双人+贵妃普通款咖啡褐,双人+单人+贵妃普通款沉稳灰,双人+单人+贵妃普通款浅杏色,双人+单人+贵妃普通款湖水蓝,双人+单人+贵妃普通款咖啡褐', null);
INSERT INTO `sp_attribute` VALUES ('2962', '主体参数-品牌', '671', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2963', '特性参数-是否可定制', '671', 'only', 'manual', '不可定制', null);
INSERT INTO `sp_attribute` VALUES ('2964', '规格参数-尺寸', '671', 'only', 'manual', '180厘米', null);
INSERT INTO `sp_attribute` VALUES ('2965', '颜色', '671', 'many', 'list', '茶几+电视柜【火烧石/胡桃色】,电视柜【火烧石/原木色】,茶几+电视柜+二斗柜+层架+餐桌+餐椅*6【台面/层架/颜色,电视柜【火烧石/胡桃色】,茶几+电视柜+二斗柜【火烧石/原木色】,茶几+电视柜+二斗柜【火烧石/胡桃色】,茶几+电视柜【火烧石/原木色】,茶几+电视柜+二斗柜+层架【台面/层架/颜色可选】,电视柜【大理石/胡桃色】,电视柜【大理石/原木色】,茶几+电视柜【大理石/原木色】,茶几+电视柜【大理石/胡桃色】,茶几+电视柜+二斗柜【大理石/原木色】,茶几+电视柜+二斗柜【大理石/胡桃色】', null);
INSERT INTO `sp_attribute` VALUES ('2966', '主体参数-品牌', '672', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2967', '功能参数-是否带储物功能', '672', 'only', 'manual', '带储物功能', null);
INSERT INTO `sp_attribute` VALUES ('2968', '特性参数-是否可定制', '672', 'only', 'manual', '不可定制', null);
INSERT INTO `sp_attribute` VALUES ('2969', '规格参数-高度', '672', 'only', 'manual', '400毫米', null);
INSERT INTO `sp_attribute` VALUES ('2970', '颜色', '672', 'many', 'list', '茶几+电视柜【火烧石/胡桃色】,茶几+电视柜+二斗柜+层架+餐桌+餐椅*6【台面/层架/颜色,茶几+电视柜+二斗柜【火烧石/原木色】,茶几+电视柜+二斗柜【火烧石/胡桃色】,茶几【火烧石/胡桃色】,茶几【火烧石/原木色】,茶几+电视柜【火烧石/原木色】,茶几+电视柜+二斗柜+层架【台面/层架/颜色可选】,茶几【大理石/胡桃色】,茶几【大理石/原木色】,茶几+电视柜【大理石/原木色】,茶几+电视柜【大理石/胡桃色】,茶几+电视柜+二斗柜【大理石/原木色】,茶几+电视柜+二斗柜【大理石/胡桃色】', null);
INSERT INTO `sp_attribute` VALUES ('2971', '主体参数-品牌', '673', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2972', '特性参数-家装风格', '673', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2973', '规格参数-尺寸', '673', 'only', 'manual', '400厘米', null);
INSERT INTO `sp_attribute` VALUES ('2974', '颜色', '673', 'many', 'list', '双人+贵妃,双人+贵妃+脚踏,双人+单人+贵妃,双人+单人+贵妃+脚踏,双人+贵妃+边几,双人+单人+贵妃+边几,双人+单人+贵妃+脚踏+边几', null);
INSERT INTO `sp_attribute` VALUES ('2975', '主体参数-品牌', '674', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2976', '特性参数-家装风格', '674', 'only', 'manual', '现代中式', null);
INSERT INTO `sp_attribute` VALUES ('2977', '规格参数-尺寸', '674', 'only', 'manual', '400厘米', null);
INSERT INTO `sp_attribute` VALUES ('2978', '颜色', '674', 'many', 'list', '四人位+贵妃位（含坐垫送抱枕）,四人位+贵妃位+茶几（含坐垫送抱枕）,四人位+贵妃位+拉床（含坐垫送抱枕）,四人位+贵妃位+拉床+茶几（含坐垫送抱枕）,四人位（含坐垫送抱枕）', null);
INSERT INTO `sp_attribute` VALUES ('2979', '主体参数-品牌', '675', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2980', '特性参数-家装风格', '675', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2981', '规格参数-尺寸', '675', 'only', 'manual', '见页面厘米', null);
INSERT INTO `sp_attribute` VALUES ('2982', '颜色', '675', 'many', 'list', '单人+双人+贵妃+茶几【颜色可选】,时尚灰【单人+双人+贵妃】,单人+双人+贵妃+茶几+电视柜+餐桌+椅*6+二斗柜+三斗柜,米黄色【单人+双人+贵妃】,单人+双人+贵妃+茶几+电视柜+餐桌+餐椅*6【颜色可选】,单人+双人+贵妃+茶几+电视柜【颜色可选】,双人+贵妃【颜色可选】,经典咖【单人+双人+贵妃】,双扶手单人位【配套购买】', null);
INSERT INTO `sp_attribute` VALUES ('2983', '主体参数-品牌', '676', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2984', '特性参数-家装风格', '676', 'only', 'manual', '现代中式', null);
INSERT INTO `sp_attribute` VALUES ('2985', '规格参数-外形尺寸', '676', 'only', 'manual', '30*30厘米', null);
INSERT INTO `sp_attribute` VALUES ('2986', '颜色', '676', 'many', 'list', '30*30*60,30*30*70,30*30*80,30*30*90', null);
INSERT INTO `sp_attribute` VALUES ('2987', '主体参数-品牌', '677', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2988', '特性参数-家装风格', '677', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('2989', '规格参数-尺寸', '677', 'only', 'manual', '200*40*38厘米', null);
INSERT INTO `sp_attribute` VALUES ('2990', '颜色', '677', 'many', 'list', '【彩色款】电视柜,【黑白款】电视柜+层架,【彩色款】茶几+电视柜+层架,【黑白款】电视柜,【木纹款】茶几+电视柜+层架,【木纹款】电视柜+层架,【彩色款】电视柜+层架,【黑白款】茶几+电视柜+层架,【木纹款】电视柜,【木纹色】电视柜+茶几,【黑白款】电视柜+茶几,【彩色款】电视柜+茶几', null);
INSERT INTO `sp_attribute` VALUES ('2991', '主体参数-品牌', '679', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('2992', '特性参数-是否可定制', '679', 'only', 'manual', '可定制', null);
INSERT INTO `sp_attribute` VALUES ('2993', '规格参数-产品尺寸', '679', 'only', 'manual', '1200*600*750毫米', null);
INSERT INTO `sp_attribute` VALUES ('2994', '颜色', '679', 'many', 'list', '单桌1.2米（双抽）原木色,单桌1.2米（双抽）胡桃色,单桌1米（单抽）原木色,单桌1米（单抽）胡桃色', null);
INSERT INTO `sp_attribute` VALUES ('2995', '主体参数-商品名称', '67', 'only', 'manual', '容声冰箱BCD-526WD11HY（珍珠白）', null);
INSERT INTO `sp_attribute` VALUES ('2996', '基本参数-电压/频率', '67', 'only', 'manual', '220V/50Hz', null);
INSERT INTO `sp_attribute` VALUES ('2997', '功能参数-童锁功能', '67', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('2998', '规格参数-产品重量', '67', 'only', 'manual', '94千克', null);
INSERT INTO `sp_attribute` VALUES ('2999', '板式', '67', 'many', 'list', '【新品】452升 纤薄风冷（莱茵咖）,526升 超薄风冷对开（珍珠白）,529升 变频风冷爆款（沐光金）,535升 变频超薄对开（沐光金）,【爆款】589升 变频纤薄（钛空金）,639升 智能风冷对开（典雅金）', null);
INSERT INTO `sp_attribute` VALUES ('3000', '主体参数-型号', '680', 'only', 'manual', 'A416书柜', null);
INSERT INTO `sp_attribute` VALUES ('3001', '特性参数-适用范围', '680', 'only', 'manual', '客厅', null);
INSERT INTO `sp_attribute` VALUES ('3002', '规格参数-外形尺寸', '680', 'only', 'manual', '39.4*140厘米', null);
INSERT INTO `sp_attribute` VALUES ('3003', '颜色', '680', 'many', 'list', 'A款浅胡桃色,A款黄梨木色,A款白色,B款浅胡桃色,B款黄梨木色,B款白色,C款浅胡桃色,C款黄梨木色,C款白色,D款浅胡桃色,D款黄梨木色,D款白色,E款浅胡桃色,E款黄梨木色,E款白色,F款浅胡桃色,F款黄梨木色,F款白色,G款浅胡桃色,G款黄梨木色,G款白色,H款浅胡桃色,H款黄梨木色,24cm白色,24cm粉色,24cm加勒比木色,48cm白色,48cm粉色,48cm加勒比木色', null);
INSERT INTO `sp_attribute` VALUES ('3004', '主体参数-品牌', '682', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3005', '功能参数-是否可定制', '682', 'only', 'manual', '不可定制', null);
INSERT INTO `sp_attribute` VALUES ('3006', '特性参数-家装风格', '682', 'only', 'manual', '田园', null);
INSERT INTO `sp_attribute` VALUES ('3007', '规格参数-体积', '682', 'only', 'manual', '0.4立方米', null);
INSERT INTO `sp_attribute` VALUES ('3008', '颜色', '682', 'many', 'list', '象白牙右转角,象白牙左转角', null);
INSERT INTO `sp_attribute` VALUES ('3009', '主体-颜色', '683', 'only', 'manual', '白色', null);
INSERT INTO `sp_attribute` VALUES ('3010', '特性参数-是否可定制', '683', 'only', 'manual', '可定制', null);
INSERT INTO `sp_attribute` VALUES ('3011', '规格参数-产品尺寸', '683', 'only', 'manual', '1毫米', null);
INSERT INTO `sp_attribute` VALUES ('3012', '颜色', '683', 'many', 'list', '红色可躺无搁脚,浅绿可躺无搁脚,浅灰可躺+搁脚,桔色可躺+搁脚,浅灰可躺无搁脚,黑色可躺+搁脚,浅蓝可躺无搁脚,桔色可躺无搁脚,浅蓝可躺+搁脚,黑色可躺无搁脚,浅绿可躺+搁脚,红色可躺+搁脚', null);
INSERT INTO `sp_attribute` VALUES ('3013', '主体参数-型号', '684', 'only', 'manual', '1', null);
INSERT INTO `sp_attribute` VALUES ('3014', '功能参数-功能', '684', 'only', 'manual', '拆装', null);
INSERT INTO `sp_attribute` VALUES ('3015', '特性参数-是否可定制', '684', 'only', 'manual', '可定制', null);
INSERT INTO `sp_attribute` VALUES ('3016', '规格参数-包装尺寸', '684', 'only', 'manual', '标准毫米', null);
INSERT INTO `sp_attribute` VALUES ('3017', '颜色', '684', 'many', 'list', '单层--800*400*750,单层--800*500*750,单层--800*600*750,单层-1000*400*750,单层-1000*500*750,单层-1000*600*750,单层-1100*600*750,单层-1200*300*750,单层-1200*350*750,单层-1200*400*750,单层-1200*500*750,单层-1200*600*750,双层--800*400*750,双层--800*500*750,双层--800*600*750,双层-1000*600*750,双层-1200*600*750,双层-1200*500*750,双层-1200*400*750,批量定做尺寸10个起订.', null);
INSERT INTO `sp_attribute` VALUES ('3018', '主体参数-品牌', '685', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3019', '功能参数-功能', '685', 'only', 'manual', '旋转', null);
INSERT INTO `sp_attribute` VALUES ('3020', '特性参数-家装风格', '685', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('3021', '规格参数-适用范围', '685', 'only', 'manual', '餐厅', null);
INSERT INTO `sp_attribute` VALUES ('3022', '颜色', '685', 'many', 'list', '大理石圆餐桌送转盘+椅子*4,大理石圆餐桌送转盘,大理石圆餐桌送转盘+椅子*6', null);
INSERT INTO `sp_attribute` VALUES ('3023', '主体参数-品牌', '687', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3024', '特性参数-抽屉轨道类型', '687', 'only', 'manual', '木质', null);
INSERT INTO `sp_attribute` VALUES ('3025', '规格参数-高度', '687', 'only', 'manual', '78厘米', null);
INSERT INTO `sp_attribute` VALUES ('3026', '颜色', '687', 'many', 'list', '餐边柜', null);
INSERT INTO `sp_attribute` VALUES ('3027', '主体参数-品牌', '688', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3028', '特性参数-款式定位', '688', 'only', 'manual', '经济型', null);
INSERT INTO `sp_attribute` VALUES ('3029', '规格参数-体积', '688', 'only', 'manual', '0.5', null);
INSERT INTO `sp_attribute` VALUES ('3030', '颜色', '688', 'many', 'list', '631款,650款,615款', null);
INSERT INTO `sp_attribute` VALUES ('3031', '主体-品牌', '689', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3032', '特性参数-家装风格', '689', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('3033', '颜色', '689', 'many', 'list', '一桌六椅,一桌四椅', null);
INSERT INTO `sp_attribute` VALUES ('3034', '主体参数-商品名称', '68', 'only', 'manual', '美菱冰箱BCD-206L3CT', null);
INSERT INTO `sp_attribute` VALUES ('3035', '基本参数-电压/频率', '68', 'only', 'manual', '220V/50Hz', null);
INSERT INTO `sp_attribute` VALUES ('3036', '功能参数-是否支持开门转换', '68', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('3037', '规格参数-产品重量', '68', 'only', 'manual', '54千克', null);
INSERT INTO `sp_attribute` VALUES ('3038', '型号', '68', 'many', 'list', '206升直冷畅销爆款,218升金色风冷电脑,220升红色玻璃面板,249升双精度变频风冷 新国标一级,251升风冷电脑 宽幅变温,271升精控变频风冷 新国标一级', null);
INSERT INTO `sp_attribute` VALUES ('3039', '主体参数-型号', '690', 'only', 'manual', 'A1115', null);
INSERT INTO `sp_attribute` VALUES ('3040', '特性参数-适用范围', '690', 'only', 'manual', '客厅', null);
INSERT INTO `sp_attribute` VALUES ('3041', '规格参数-尺寸', '690', 'only', 'manual', '148*47厘米', null);
INSERT INTO `sp_attribute` VALUES ('3042', '颜色', '690', 'many', 'list', '60cm白色,90cm欣欣向荣（微光耐磨面）,90cm白框+欣欣向荣,90cm白框+格桑淡彩,100cm黑框+闲适爱莲,100cm黑框+格桑淡彩,100cm白框+欣欣向荣,100cm白框+黑花,100cm白框+蒲公英,100cm欣欣向荣（微光耐磨面）,120cm白框+格桑淡彩（微光耐磨面）,120cm幻蝶恋影（微光耐磨面）,120cm黑框+格桑淡彩（微光耐磨面）,120cm白框+欣欣向荣,120cm黑框+闲适爱莲,120cm黑框+欣欣向荣,140cm白框+欣欣向荣,140cm黑框+闲适爱莲,140cm黑框+格桑淡彩,140cm白框+黑花,140cm幻蝶恋影（微光耐磨面）,新款90cm欣欣向荣,新款90cm加勒比松木色,新款90cm原野橡木色,新款120cm欣欣向荣,新款120cm加勒比松木色,新款120cm原野橡木色', null);
INSERT INTO `sp_attribute` VALUES ('3043', '主体参数-型号', '691', 'only', 'manual', 'N326', null);
INSERT INTO `sp_attribute` VALUES ('3044', '特性参数-适用范围', '691', 'only', 'manual', '客厅', null);
INSERT INTO `sp_attribute` VALUES ('3045', '颜色', '691', 'many', 'list', '60cm白架+黑（四层）,60cm红叶枫木（四层）,60cm白架+黑（五层）,60cm红叶枫木（五层）,60cm白架+黑（六层）,60cm红叶枫木（六层）,75cm白架+黑（五层）,75cm红叶枫木（五层）,75cm白架+黑（六层）,75cm红叶枫木（六层）,75cm白架+黑（七层）,75cm红叶枫木（七层）', null);
INSERT INTO `sp_attribute` VALUES ('3046', '主体参数-品牌', '692', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3047', '特性参数-适用范围', '692', 'only', 'manual', '客厅', null);
INSERT INTO `sp_attribute` VALUES ('3048', '规格参数-高度', '692', 'only', 'manual', '175厘米', null);
INSERT INTO `sp_attribute` VALUES ('3049', '颜色', '692', 'many', 'list', '树杈款-纯净白,树杈款-咖啡色,树杈款-原色,树杈款-西瓜红,十字款-纯净白,十字款--咖啡色,十字款--原色,十字款--西瓜红', null);
INSERT INTO `sp_attribute` VALUES ('3050', '主体参数-品牌', '693', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3051', '特性参数-是否可定制', '693', 'only', 'manual', '不可定制', null);
INSERT INTO `sp_attribute` VALUES ('3052', '规格参数-体积', '693', 'only', 'manual', '1立方米', null);
INSERT INTO `sp_attribute` VALUES ('3053', '颜色', '693', 'many', 'list', '玄关', null);
INSERT INTO `sp_attribute` VALUES ('3054', '主体参数-品牌', '694', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3055', '特性参数-家装风格', '694', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('3056', '规格参数-宽度', '694', 'only', 'manual', '100厘米', null);
INSERT INTO `sp_attribute` VALUES ('3057', '主体-品牌', '695', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3058', '功能-供暖方式', '695', 'only', 'manual', '自采暖、集中供暖', null);
INSERT INTO `sp_attribute` VALUES ('3059', '规格-重量', '695', 'only', 'manual', '0.373千克', null);
INSERT INTO `sp_attribute` VALUES ('3060', '配件种类多，咨询客服', '695', 'many', 'list', 'ppr专用4分直阀,ppr专用6分直阀,ppr专用1寸直阀,ppr专用4分角阀,ppr专用6分角阀,ppr专用1寸角阀', null);
INSERT INTO `sp_attribute` VALUES ('3061', '主体-品牌', '697', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3062', '特性参数-工艺', '697', 'only', 'manual', '烤漆', null);
INSERT INTO `sp_attribute` VALUES ('3063', '颜色', '697', 'many', 'list', '005玛瑙红,005时尚白,005香槟色', null);
INSERT INTO `sp_attribute` VALUES ('3064', '特性参数-品牌', '698', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3065', '规格参数-价格', '698', 'only', 'manual', '1元', null);
INSERT INTO `sp_attribute` VALUES ('3066', '特性参数-类别', '699', 'only', 'manual', '装修施工服务', null);
INSERT INTO `sp_attribute` VALUES ('3067', '规格参数-价格', '699', 'only', 'manual', '1.99元', null);
INSERT INTO `sp_attribute` VALUES ('3068', '主体-商品名称', '6', 'only', 'manual', 'TCL电视 55A950C', null);
INSERT INTO `sp_attribute` VALUES ('3069', '显示-曲面', '6', 'only', 'manual', '是', null);
INSERT INTO `sp_attribute` VALUES ('3070', '系统-智能电视', '6', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('3071', '外观-壁挂安装', '6', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('3072', '功耗-整机功率（W）', '6', 'only', 'manual', '120瓦特', null);
INSERT INTO `sp_attribute` VALUES ('3073', '端口-模拟RF接口', '6', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('3074', '音频-扬声器数量', '6', 'only', 'manual', '2个', null);
INSERT INTO `sp_attribute` VALUES ('3075', '交互设备-无线键鼠', '6', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('3076', '互联互通-多屏互动', '6', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('3077', '版式', '6', 'many', 'list', '49吋4K超薄曲面 人工智能,55吋4K观影曲面 30核HDR,55吋4K超薄曲面 人工智能,65吋4K超薄曲面 人工智能', null);
INSERT INTO `sp_attribute` VALUES ('3078', '特性参数-品牌', '700', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3079', '规格参数-价格', '700', 'only', 'manual', '988元', null);
INSERT INTO `sp_attribute` VALUES ('3080', '特性参数-品牌', '701', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3081', '规格参数-价格', '701', 'only', 'manual', '1元', null);
INSERT INTO `sp_attribute` VALUES ('3082', '主体参数-品牌', '702', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3083', '规格参数-建筑面积', '702', 'only', 'manual', '90㎡（含）-120㎡（不含）', null);
INSERT INTO `sp_attribute` VALUES ('3084', '特性参数-是否可调节', '704', 'only', 'manual', '不可调节', null);
INSERT INTO `sp_attribute` VALUES ('3085', '主体参数-品牌', '704', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3086', '规格参数-适用范围', '704', 'only', 'manual', '卧室', null);
INSERT INTO `sp_attribute` VALUES ('3087', '颜色', '704', 'many', 'list', '1.5米排骨架,1.8米排骨架,1.5米排骨架+2床头柜,1.8米排骨架+2床头柜,1.5米排骨架+床头柜+床垫,1.8米排骨架+床头柜+床垫,1.5米排骨架+2床头柜+床垫,1.8米排骨架+2床头柜+床垫', null);
INSERT INTO `sp_attribute` VALUES ('3088', '主体参数-品牌', '705', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3089', '特性参数-家装风格', '705', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('3090', '规格参数-尺寸', '705', 'only', 'manual', '2830厘米', null);
INSERT INTO `sp_attribute` VALUES ('3091', '颜色', '705', 'many', 'list', '四人位+脚踏（A20米黄色）,单独四人位（A107青灰色）,四人位+脚踏（A220深咖色）,单独四人位（A20米黄色）,单独四人位（A220深咖色）,四人位+脚踏（A107青灰色）', null);
INSERT INTO `sp_attribute` VALUES ('3092', '主体参数-型号', '706', 'only', 'manual', '1088', null);
INSERT INTO `sp_attribute` VALUES ('3093', '特性参数-家装风格', '706', 'only', 'manual', '简约现代', null);
INSERT INTO `sp_attribute` VALUES ('3094', '规格参数-尺寸', '706', 'only', 'manual', '以实际尺寸为准，软体家具会存在3cm-10cm的误差厘米', null);
INSERT INTO `sp_attribute` VALUES ('3095', '颜色', '706', 'many', 'list', '米白+绿色【六件套】,银灰+灰色【三件套】,米黄+红色【六件套】,米白+绿色【两件套】,米黄+红色【三件套】,米灰+深蓝【三件套】,米灰+深蓝【两件套】,米黄+红色【两件套】,米白+天蓝【六件套】,米白+咖色【六件套】,米白+绿色【三件套】,银灰+灰色【两件套】,米白+天蓝【三件套】,米白+天蓝【两件套】,银灰+灰色【六件套】,米灰+深蓝【六件套】,米白+咖色【三件套】,米白+咖色【两件套】', null);
INSERT INTO `sp_attribute` VALUES ('3096', '主体参数-品牌', '707', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3097', '特性参数-是否可定制', '707', 'only', 'manual', '不可定制', null);
INSERT INTO `sp_attribute` VALUES ('3098', '规格参数-体积', '707', 'only', 'manual', '1.5', null);
INSERT INTO `sp_attribute` VALUES ('3099', '颜色', '707', 'many', 'list', '1.5五件（床+床头柜*2+舒梦+13M1四门衣柜）,1.8五件（床+床头柜*2+舒梦+13M1四门衣柜）,1.8三件（床+床头柜*2）,1.5四件（床+床头柜*2+舒梦）,1.5三件（床+床头柜*2）,1.5米床,1.8米床,1.8四件（床+床头柜*2+舒梦）', null);
INSERT INTO `sp_attribute` VALUES ('3100', '主体-品牌', '709', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3101', '功能参数-是否带光源', '709', 'only', 'manual', '带光源', null);
INSERT INTO `sp_attribute` VALUES ('3102', '特性参数-工艺', '709', 'only', 'manual', '压铸', null);
INSERT INTO `sp_attribute` VALUES ('3103', '规格参数-重量', '709', 'only', 'manual', '1.5千克', null);
INSERT INTO `sp_attribute` VALUES ('3104', '主体-品牌', '711', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3105', '功能参数-是否带光源', '711', 'only', 'manual', '带光源', null);
INSERT INTO `sp_attribute` VALUES ('3106', '特性参数-工艺', '711', 'only', 'manual', '铁艺', null);
INSERT INTO `sp_attribute` VALUES ('3107', '规格参数-重量', '711', 'only', 'manual', '8.34千克', null);
INSERT INTO `sp_attribute` VALUES ('3108', '颜色', '711', 'many', 'list', '【三室两厅一阳台】浪漫装饰风,【三室两厅一阳台】炫蜂简约风,【两室一厅】赫墨拉套餐,【两室两厅】赫墨拉套餐,【两室两厅】祥云套餐,【三室两厅】浪漫装饰风,【三室两厅】燕归巢套餐,【三室两厅】炫蜂套餐,【三室两厅】大气简约风,【三室两厅】精致轻奢风,【三室两厅】美式风格吊灯,【三室两厅】黑白主义,【三室两厅】日式木艺风,【三室两厅】蜂之恋套餐,【三室一厅】轻奢水晶风,【三室两厅】格子几何套餐', null);
INSERT INTO `sp_attribute` VALUES ('3109', '主体-品牌', '712', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3110', '特性参数-工艺', '712', 'only', 'manual', '简约', null);
INSERT INTO `sp_attribute` VALUES ('3111', '规格参数-重量', '712', 'only', 'manual', '10.8千克', null);
INSERT INTO `sp_attribute` VALUES ('3112', '颜色', '712', 'many', 'list', '28W带灯罩适合10-20平方,70W长方形适合25-40平方,38W带灯罩适合15-25平方,38W无灯罩适合15-25平方,50W正方形适合20-30平方', null);
INSERT INTO `sp_attribute` VALUES ('3113', '主体-类别', '714', 'only', 'manual', '电源插座', null);
INSERT INTO `sp_attribute` VALUES ('3114', '规格参数-插孔数', '714', 'only', 'manual', '二三插', null);
INSERT INTO `sp_attribute` VALUES ('3115', '主体-品牌', '715', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3116', '规格参数-插孔数', '715', 'only', 'manual', '二三插', null);
INSERT INTO `sp_attribute` VALUES ('3117', '主体参数-品牌', '717', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3118', '特性参数-花洒形状', '717', 'only', 'manual', '圆形', null);
INSERT INTO `sp_attribute` VALUES ('3119', '规格参数-毛重', '717', 'only', 'manual', '5.6千克', null);
INSERT INTO `sp_attribute` VALUES ('3120', '主体参数-品牌', '718', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3121', '特性参数-花洒形状', '718', 'only', 'manual', '圆形', null);
INSERT INTO `sp_attribute` VALUES ('3122', '规格参数-毛重', '718', 'only', 'manual', '4.5千克', null);
INSERT INTO `sp_attribute` VALUES ('3123', '主体参数-品牌', '720', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3124', '功能参数-是否有前挡水', '720', 'only', 'manual', '无前挡水', null);
INSERT INTO `sp_attribute` VALUES ('3125', '特性参数-蹲便器下水方向', '720', 'only', 'manual', '前排水', null);
INSERT INTO `sp_attribute` VALUES ('3126', '规格参数-净重', '720', 'only', 'manual', '5千克', null);
INSERT INTO `sp_attribute` VALUES ('3127', '颜色', '720', 'many', 'list', 'ALD507+水箱套装【(带)存水弯前冲水前排污】,ALD507G+水箱套装【(带)存水弯后冲水后排污】,箭牌ALD507CG+水箱套装【不带存水弯后冲水后排污】,箭牌ALD507C+水箱套装【不带存水弯后冲水前排污】', null);
INSERT INTO `sp_attribute` VALUES ('3128', '主体-品牌', '722', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3129', '规格-年龄段', '722', 'only', 'manual', '0-3月,3-6月', null);
INSERT INTO `sp_attribute` VALUES ('3130', 'a2系列奶粉', '722', 'many', 'list', 'a2一段,a2三段,a2二段,a2四段,a2成人', null);
INSERT INTO `sp_attribute` VALUES ('3131', '主体-品牌', '723', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3132', '规格-年龄段', '723', 'only', 'manual', '6-9月,9-12月', null);
INSERT INTO `sp_attribute` VALUES ('3133', '颜色', '723', 'many', 'list', '6-12月 400克盒装,6-12月 600克X3,6-12月 900克罐装,6-12月+送贝亲湿巾', null);
INSERT INTO `sp_attribute` VALUES ('3134', '主体-品牌', '724', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3135', '规格-年龄段', '724', 'only', 'manual', '12-18月,18-24月,24-30月,30-36月', null);
INSERT INTO `sp_attribute` VALUES ('3136', '规格', '724', 'many', 'list', '3段1200g,3段1200g*3,3段33g*4,3段900g,3段900g*12', null);
INSERT INTO `sp_attribute` VALUES ('3137', '主体-品牌', '725', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3138', '规格-年龄段', '725', 'only', 'manual', '4岁,5岁,6岁,7岁,3岁', null);
INSERT INTO `sp_attribute` VALUES ('3139', '颜色', '725', 'many', 'list', '3岁或以上900克罐装,3岁或以上 400克X3,3岁或以上400克盒装', null);
INSERT INTO `sp_attribute` VALUES ('3140', '主体-品牌', '726', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3141', '规格-年龄段', '726', 'only', 'manual', '孕早,孕中,孕晚', null);
INSERT INTO `sp_attribute` VALUES ('3142', '主体-产地', '727', 'only', 'manual', '德国', null);
INSERT INTO `sp_attribute` VALUES ('3143', '规格-年龄段', '727', 'only', 'manual', '9-12月', null);
INSERT INTO `sp_attribute` VALUES ('3144', '主体-品牌', '729', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3145', '规格-纸尿裤型号', '729', 'only', 'manual', 'NB（新生儿）', null);
INSERT INTO `sp_attribute` VALUES ('3146', '系列', '729', 'many', 'list', '拉拉裤,纸尿裤,中号M64片,加大号xl44,大号L44片,大号L54片,小号S82片,新生儿NB90片,特大号XL38片', null);
INSERT INTO `sp_attribute` VALUES ('3147', '主体-品牌', '72', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3148', '规格-规格', '72', 'only', 'manual', '1.3g', null);
INSERT INTO `sp_attribute` VALUES ('3149', '功效-功效', '72', 'only', 'manual', '显色', null);
INSERT INTO `sp_attribute` VALUES ('3150', '色号', '72', 'many', 'list', '1#,13#,52#,17#,202#,208#', null);
INSERT INTO `sp_attribute` VALUES ('3151', '主体-品牌', '732', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3152', '规格-纸尿裤型号', '732', 'only', 'manual', 'M号', null);
INSERT INTO `sp_attribute` VALUES ('3153', '系列', '732', 'many', 'list', '拉拉裤,纸尿裤,中号M64片,加大号xl44,大号L44片,大号L54片,小号S82片,新生儿NB90片,特大号XL38片', null);
INSERT INTO `sp_attribute` VALUES ('3154', '主体-品牌', '733', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3155', '规格-纸尿裤型号', '733', 'only', 'manual', 'L号', null);
INSERT INTO `sp_attribute` VALUES ('3156', '花王Merries', '733', 'many', 'list', 'L54片(9-14kg),M64片（6-11kg）,NB90片（0-5kg）,S82片（4-8kg）,拉拉裤L44片(9-14kg),拉拉裤XL38片(12-22kg)', null);
INSERT INTO `sp_attribute` VALUES ('3157', '主体-品牌', '734', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3158', '规格-型号', '734', 'only', 'manual', 'XL号', null);
INSERT INTO `sp_attribute` VALUES ('3159', '规格', '734', 'many', 'list', 'L码34片,M码40片,S码44片,XL码29片', null);
INSERT INTO `sp_attribute` VALUES ('3160', '主体-品牌', '735', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3161', '规格-纸尿裤型号', '735', 'only', 'manual', 'XXL号', null);
INSERT INTO `sp_attribute` VALUES ('3162', '裤型', '735', 'many', 'list', '金装成长裤,金装纸尿裤,铂金装成长裤,铂金装纸尿裤,银装成长裤,银装纸尿裤,中号M160片,中号M162片,中号M58+2片,中号M72片,中号M92片,初生号NB66+12片,初生号NB70+10片,初生号NB84片,加加大号42片,加加大号XXL28片,加加大号XXL40片,加加大号XXL66片,加大号72片,加大号XL104片,加大号XL105片,加大号XL44片,加大号XL64+12片,加大号XL64片,加大号XL64片（女）,加大号XL64片（男）,大号88片,大号L128片,大号L129片,大号L58片,大号L76片,大号L76片（女）,大号L76片（男）,大号L84+16片,小号S120片,小号S148片,小号S60+12片,小号S60+8片,小号S76片,小号S96片', null);
INSERT INTO `sp_attribute` VALUES ('3163', '主体-品牌', '736', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3164', '规格-纸尿裤型号', '736', 'only', 'manual', 'XL号', null);
INSERT INTO `sp_attribute` VALUES ('3165', '系列', '736', 'many', 'list', '拉拉裤,纸尿裤,中号M64片,加大号xl44,大号L44片,大号L54片,小号S82片,新生儿NB90片,特大号XL38片', null);
INSERT INTO `sp_attribute` VALUES ('3166', '主体-品牌', '737', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3167', '规格-型号', '737', 'only', 'manual', 'L号', null);
INSERT INTO `sp_attribute` VALUES ('3168', '规格', '737', 'many', 'list', 'L码34片,M码40片,S码44片,XL码29片', null);
INSERT INTO `sp_attribute` VALUES ('3169', '主体-产地', '738', 'only', 'manual', '中国福建漳州市', null);
INSERT INTO `sp_attribute` VALUES ('3170', '规格-规格', '738', 'only', 'manual', '80抽', null);
INSERT INTO `sp_attribute` VALUES ('3171', '功能-包装', '738', 'only', 'manual', '婴儿湿巾独立装', null);
INSERT INTO `sp_attribute` VALUES ('3172', '主体-品牌', '739', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3173', '规格-保质期', '739', 'only', 'manual', '24个月', null);
INSERT INTO `sp_attribute` VALUES ('3174', '其他-产品包装材质', '739', 'only', 'manual', '铁罐', null);
INSERT INTO `sp_attribute` VALUES ('3175', '颜色', '739', 'many', 'list', '番茄牛肉,燕麦,菠菜,钙铁锌,营养,燕麦西梅,豌豆,胡萝卜,南瓜,缤纷水果', null);
INSERT INTO `sp_attribute` VALUES ('3176', '主体-品牌', '73', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3177', '规格-规格', '73', 'only', 'manual', '25ml', null);
INSERT INTO `sp_attribute` VALUES ('3178', '功效-功效', '73', 'only', 'manual', '保湿补水,滋润营养', null);
INSERT INTO `sp_attribute` VALUES ('3179', '主体-品牌', '741', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3180', '规格-保质期', '741', 'only', 'manual', '24个月', null);
INSERT INTO `sp_attribute` VALUES ('3181', '其他-包装', '741', 'only', 'manual', '套装', null);
INSERT INTO `sp_attribute` VALUES ('3182', '主体-品牌', '742', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3183', '规格-保质期', '742', 'only', 'manual', '12个月', null);
INSERT INTO `sp_attribute` VALUES ('3184', '其他-包装', '742', 'only', 'manual', '单瓶装', null);
INSERT INTO `sp_attribute` VALUES ('3185', '主体-品牌', '743', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3186', '规格-保质期', '743', 'only', 'manual', '15个月', null);
INSERT INTO `sp_attribute` VALUES ('3187', '其他-包装', '743', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('3188', '主体-品牌', '744', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3189', '规格-规格', '744', 'only', 'manual', '120g', null);
INSERT INTO `sp_attribute` VALUES ('3190', '主体-品牌', '745', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3191', '规格-国产/进口', '745', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('3192', '其他-产地', '745', 'only', 'manual', '中国广东东莞市', null);
INSERT INTO `sp_attribute` VALUES ('3193', '主体-适用年龄', '746', 'only', 'manual', '6个月以上', null);
INSERT INTO `sp_attribute` VALUES ('3194', '规格-包装', '746', 'only', 'manual', '桶装', null);
INSERT INTO `sp_attribute` VALUES ('3195', '口味', '746', 'many', 'list', '苹果草莓味,香蕉味,蓝莓味,桃子味,香草味,番薯味', null);
INSERT INTO `sp_attribute` VALUES ('3196', '主体-品牌', '747', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3197', '规格-保质期', '747', 'only', 'manual', '24个月', null);
INSERT INTO `sp_attribute` VALUES ('3198', '其他-国产/进口', '747', 'only', 'manual', '进口', null);
INSERT INTO `sp_attribute` VALUES ('3199', '主体-品牌', '748', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3200', '规格-保质期', '748', 'only', 'manual', '36个月', null);
INSERT INTO `sp_attribute` VALUES ('3201', '其他-包装', '748', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('3202', '补充信息-国产/进口', '748', 'only', 'manual', '进口', null);
INSERT INTO `sp_attribute` VALUES ('3203', '主体-品牌', '749', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3204', '规格-保质期', '749', 'only', 'manual', '730天', null);
INSERT INTO `sp_attribute` VALUES ('3205', '其他-包装', '749', 'only', 'manual', '瓶装', null);
INSERT INTO `sp_attribute` VALUES ('3206', '补充信息-注意事项', '749', 'only', 'manual', '阴凉避光处保存，开封后冷藏', null);
INSERT INTO `sp_attribute` VALUES ('3207', '主体-品牌', '74', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3208', '规格-规格', '74', 'only', 'manual', '25ml*10片', null);
INSERT INTO `sp_attribute` VALUES ('3209', '功效-功效', '74', 'only', 'manual', '美白,保湿补水,紧肤淡皱,收缩毛孔,提拉紧致', null);
INSERT INTO `sp_attribute` VALUES ('3210', '规格', '74', 'many', 'list', '黄春雨10片-补水滋润,黑春雨10片-轻透补水,白春雨10片-焕白保湿', null);
INSERT INTO `sp_attribute` VALUES ('3211', '主体-品牌', '750', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3212', '规格-保质期', '750', 'only', 'manual', '36个月', null);
INSERT INTO `sp_attribute` VALUES ('3213', '其他-国产/进口', '750', 'only', 'manual', '进口', null);
INSERT INTO `sp_attribute` VALUES ('3214', '颜色', '750', 'many', 'list', '纯牛初乳粉60袋,益生元型牛初乳粉30袋,骨健乐调制乳粉150g', null);
INSERT INTO `sp_attribute` VALUES ('3215', '主体-品牌', '751', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3216', '规格-保质期', '751', 'only', 'manual', '36个月', null);
INSERT INTO `sp_attribute` VALUES ('3217', '其他-国产/进口', '751', 'only', 'manual', '进口', null);
INSERT INTO `sp_attribute` VALUES ('3218', '主体-品牌', '752', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3219', '规格-保质期', '752', 'only', 'manual', '24个月', null);
INSERT INTO `sp_attribute` VALUES ('3220', '主体-品牌', '753', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3221', '规格-适用年龄', '753', 'only', 'manual', '0-2岁', null);
INSERT INTO `sp_attribute` VALUES ('3222', '其他-国产/进口', '753', 'only', 'manual', '进口', null);
INSERT INTO `sp_attribute` VALUES ('3223', '年龄', '753', 'many', 'list', '婴儿0-1岁,1岁以上', null);
INSERT INTO `sp_attribute` VALUES ('3224', '主体-品牌', '754', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3225', '规格-保质期', '754', 'only', 'manual', '24个月', null);
INSERT INTO `sp_attribute` VALUES ('3226', '其他-产品包装材质', '754', 'only', 'manual', '铁罐', null);
INSERT INTO `sp_attribute` VALUES ('3227', '主体-品牌', '755', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3228', '规格-规格', '755', 'only', 'manual', '23ml', null);
INSERT INTO `sp_attribute` VALUES ('3229', '补充信息-注意事项', '755', 'only', 'manual', '常温存放', null);
INSERT INTO `sp_attribute` VALUES ('3230', '特性-商品特色', '755', 'only', 'manual', '孕妇护肤品', null);
INSERT INTO `sp_attribute` VALUES ('3231', '规格', '755', 'many', 'list', '五羊吸乳器礼包,产后护理大礼包,产褥卫生巾L码,产褥卫生巾M码,产褥卫生巾S码,产褥期护理垫4片,双边电动吸奶器 FR118,垫100片*2+防溢乳垫50片,孕产护齿漱口水（蓝莓味）,孕妇保湿3件套,孕妇保湿水150ml,月子牙刷30支/盒,电动吸奶器 FR108,防溢乳垫100片盒装,防溢乳垫倍柔型100片,防溢乳垫倍柔型30片,雪肌孕妇面膜（单片）,雪肌面膜15片+水肌面膜15片,雪肌面膜23ml*30片', null);
INSERT INTO `sp_attribute` VALUES ('3232', '主体-品牌', '756', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3233', '名称', '756', 'many', 'list', '七果洗发沐浴露 550g,沐浴液200g,洁发宝200g', null);
INSERT INTO `sp_attribute` VALUES ('3234', '主体-品牌', '757', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3235', '规格-规格', '757', 'only', 'manual', '200ml', null);
INSERT INTO `sp_attribute` VALUES ('3236', '功能-注意事项', '757', 'only', 'manual', '放置阴凉处，避免阳光直射', null);
INSERT INTO `sp_attribute` VALUES ('3237', '婴儿系列', '757', 'many', 'list', '儿童洗发液 500ml（HKP),儿童洗发液150ml,儿童洗发液250ml,婴儿护唇膏4.8g （HKP）,婴儿护臀膏100ml（HKP）,婴儿护面霜100ml （HKP）,婴儿护面霜50ml （HKP）,婴儿泡泡沐浴露200ml,婴儿泡泡沐浴露500ml,婴儿泡泡浴露1000ml 宝宝沐浴露,婴儿泡泡浴露200ml（HKP),婴儿洁肤浴露1000m（HKP）,婴儿洁肤浴露400ml,婴儿洁肤浴露400ml（HKP）,婴儿洁肤皂100g,婴儿润肤乳100ml,婴儿润肤乳200ml,施巴 婴儿泡泡浴露500ml（HKP),洁肤沐浴露20ml', null);
INSERT INTO `sp_attribute` VALUES ('3238', '主体-品牌', '758', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3239', '规格-规格', '758', 'only', 'manual', '2kg*6袋', null);
INSERT INTO `sp_attribute` VALUES ('3240', '功能-香型', '758', 'only', 'manual', '有香味', null);
INSERT INTO `sp_attribute` VALUES ('3241', '规格', '758', 'many', 'list', '2.5kg飘香桂花,208g*2块内衣皂,内衣洗衣液瓶装720g,多功能1kg瓶+500g*9袋补充装,多功能2KG*6,多功能洗衣液袋装1.5kg,多功能洗衣液袋装2kg,天然草香1L瓶装+500ml*6袋,天然草香500*3,婴儿专用皂粉450g,富氧净低泡洗衣液2kg*3袋装,富氧净洗衣液瓶装4kg,成人内衣专用皂粉450g,柔顺剂500ml袋装水蜜桃香,洗衣凝珠375g,洗衣液200g袋装,洗衣液草香500ml袋装,清淡果香1L瓶装+500ml*6袋,清淡果香500*3,清香莲花2.5KG,玫瑰香90G旅行装,紫罗兰香2KG,酵素洗衣液洁净花香1.88kg,香皂120G*4块', null);
INSERT INTO `sp_attribute` VALUES ('3242', '主体-品牌', '759', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3243', '规格-规格', '759', 'only', 'manual', '120克', null);
INSERT INTO `sp_attribute` VALUES ('3244', '功能-香型', '759', 'only', 'manual', '有香味', null);
INSERT INTO `sp_attribute` VALUES ('3245', '规格', '759', 'many', 'list', '清新柠檬草*1+优雅紫罗兰*1+温馨阳光*1,清新柠檬草*1+优雅紫罗兰*1+温馨阳光*2,清新柠檬草*2+优雅紫罗兰*2+温馨阳光*4,清新柠檬草香型120g,温馨阳光香型120g', null);
INSERT INTO `sp_attribute` VALUES ('3246', '主体-品牌', '761', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3247', '规格-保质期', '761', 'only', 'manual', '1095天', null);
INSERT INTO `sp_attribute` VALUES ('3248', '规格', '761', 'many', 'list', '二合一沐浴洗发露50ml,哈罗闪婴儿二合一洗发沐浴露50ml护肤霜20ml,哈罗闪柔润护肤乳50ml二合一洗发沐浴露50ml,哈罗闪柔润护肤乳50ml护肤霜20ml,哈罗闪超值旅行装三件套装,护肤霜20ml,晚安沐浴露50ml,柔润护肤乳50ml,沐浴露50ml', null);
INSERT INTO `sp_attribute` VALUES ('3249', '主体-品牌', '762', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3250', '规格-容量', '762', 'only', 'manual', '200ml', null);
INSERT INTO `sp_attribute` VALUES ('3251', '功能-产品特性', '762', 'only', 'manual', '含有高保湿成分，令宝宝娇嫩肌肤柔软滋润，触感清爽不油腻，与皮肤具有良好的亲和性，品质纯正温和。', null);
INSERT INTO `sp_attribute` VALUES ('3252', '规格', '762', 'many', 'list', '润肤油100ml,润肤油200ml,润肤霜(滋润型)35g,润肤露120g,润肤露（清爽型）200ml,润肤露（滋润型）100ml,润肤露（滋润型）200ml', null);
INSERT INTO `sp_attribute` VALUES ('3253', '主体-品牌', '763', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3254', '规格-规格', '763', 'only', 'manual', '180克', null);
INSERT INTO `sp_attribute` VALUES ('3255', '其他-产品特性', '763', 'only', 'manual', '玉米粉', null);
INSERT INTO `sp_attribute` VALUES ('3256', '名称', '763', 'many', 'list', '玉米热痱粉180g,玉米爽身粉180g', null);
INSERT INTO `sp_attribute` VALUES ('3257', '主体-品牌', '764', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3258', '规格-容量', '764', 'only', 'manual', '140G', null);
INSERT INTO `sp_attribute` VALUES ('3259', '规格', '764', 'many', 'list', '婴儿爽身粉140g(芦荟精华),婴儿爽身粉饼40g(无滑石粉型),婴儿祛痱粉120g(甘草精华),婴儿草本清凉凝露50g,婴儿草本清凉凝露50g新包装,婴儿草本清凉液100ml,婴儿防晒霜SPF30+ PA++ 30g,婴儿防晒露30g', null);
INSERT INTO `sp_attribute` VALUES ('3260', '主体-品牌', '765', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3261', '规格-规格', '765', 'only', 'manual', '200ml', null);
INSERT INTO `sp_attribute` VALUES ('3262', '主体-品牌', '766', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3263', '规格-容量', '766', 'only', 'manual', '59ml', null);
INSERT INTO `sp_attribute` VALUES ('3264', '主体-分类', '767', 'only', 'manual', '牙刷', null);
INSERT INTO `sp_attribute` VALUES ('3265', '规格-规格', '767', 'only', 'manual', '单支装', null);
INSERT INTO `sp_attribute` VALUES ('3266', '颜色', '767', 'many', 'list', '橙绿色,紫粉色,蓝绿色,黄绿色', null);
INSERT INTO `sp_attribute` VALUES ('3267', '主体-品牌', '768', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3268', '特性-口径', '768', 'only', 'manual', '标准口径', null);
INSERT INTO `sp_attribute` VALUES ('3269', 'PPSU', '768', 'many', 'list', '绿色 180ML,粉色  180ML,蓝色  180ML,绿色 260ML,粉色  260ML,蓝色  260ML', null);
INSERT INTO `sp_attribute` VALUES ('3270', '主体-品牌', '769', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3271', '规格-数量', '769', 'only', 'manual', '2只', null);
INSERT INTO `sp_attribute` VALUES ('3272', '规格', '769', 'many', 'list', '宽口径L号Y字孔,宽口径L号Y字孔2只装,宽口径M号Y字孔,宽口径M号Y字孔2只装,宽口径SS号小圆孔,宽口径S号小圆孔,宽口径S号小圆孔2只装', null);
INSERT INTO `sp_attribute` VALUES ('3273', '主体-品牌', '770', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3274', '规格-规格', '770', 'only', 'manual', '套装', null);
INSERT INTO `sp_attribute` VALUES ('3275', '主体-品牌', '771', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3276', '颜色', '771', 'many', 'list', '双边吸奶器,吸乳器XB-8615,吸乳器XB-8617,调奶器XB-8627,暖奶消毒器XB-8608', null);
INSERT INTO `sp_attribute` VALUES ('3277', '主体-品牌', '772', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3278', '主体-产地', '773', 'only', 'manual', '中国江苏常州市', null);
INSERT INTO `sp_attribute` VALUES ('3279', '规格-规格', '773', 'only', 'manual', '个', null);
INSERT INTO `sp_attribute` VALUES ('3280', '特性-功能', '773', 'only', 'manual', '清洁奶瓶', null);
INSERT INTO `sp_attribute` VALUES ('3281', '主体-品牌', '774', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3282', '型号', '774', 'many', 'list', '吉米浴盆 RK-8001,吉米浴盆RK-3626,奶牛粉白 大,奶牛粉白 小,奶牛蓝白大,奶牛蓝白小,奶牛黑白大,奶牛黑白小,宝宝清洗盆厚,小摇铃,康康熊浴桶粉色,康康熊浴桶蓝色,母子鸭,浣熊浴桶咖啡色,浮水玩具,网状沐浴床,花洒水舀,贝比浴盆 RK-3691,戏水玩具,浴桶,浴盆,澡盆周边,脸盆脚盆', null);
INSERT INTO `sp_attribute` VALUES ('3283', '主体-品牌', '775', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3284', '规格-规格', '775', 'only', 'manual', '27.5*11.8*14.2', null);
INSERT INTO `sp_attribute` VALUES ('3285', '主体-品牌', '776', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3286', '规格-规格', '776', 'only', 'manual', '45ML*5', null);
INSERT INTO `sp_attribute` VALUES ('3287', '规格', '776', 'many', 'list', '120片蚊香片2器,45ml*1驱蚊液,45ml*5液加1器,45ml7液加2器,薄荷膏10g*2,驱蚊喷雾+薄荷膏套装,驱蚊喷雾50ml*3,驱蚊手环3条,驱蚊贴48片', null);
INSERT INTO `sp_attribute` VALUES ('3288', '主体-品牌', '778', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3289', '规格-规格', '778', 'only', 'manual', '1张', null);
INSERT INTO `sp_attribute` VALUES ('3290', '主体-品牌', '779', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3291', '规格-是否带手柄', '779', 'only', 'manual', '不带手柄', null);
INSERT INTO `sp_attribute` VALUES ('3292', '水杯', '779', 'many', 'list', '功夫红熊猫600ml,功夫蓝熊猫600ml,小浣熊480ml,小猴子600ml,小粉兔600ml,小酷羊600ml,小青蛇600ml,小马驹600ml,杯具熊600ml,独角兽600ml,粉色独角兽600ml,蜘蛛侠480ml,金鸡600ml,青蛙480ml', null);
INSERT INTO `sp_attribute` VALUES ('3293', '主体-品牌', '77', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3294', '规格-包装尺寸', '77', 'only', 'manual', '100*60*80毫米', null);
INSERT INTO `sp_attribute` VALUES ('3295', '类型', '77', 'many', 'list', '小黄鸭,三个装小鸭子,两个装漂浮水球', null);
INSERT INTO `sp_attribute` VALUES ('3296', '主体-品牌', '780', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3297', '规格-颜色', '780', 'only', 'manual', '白色', null);
INSERT INTO `sp_attribute` VALUES ('3298', '型号', '780', 'many', 'list', '格朗  EW-2,格朗  EW-7,格朗  EW-7S,格朗 EW-10,格朗 EW-4S,格朗 EW-8,格朗 W-2,格朗4P,格朗FT-1,格朗W-3,体温计,耳/额温枪,退热贴', null);
INSERT INTO `sp_attribute` VALUES ('3299', '主体-品牌', '781', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3300', '规格-规格', '781', 'only', 'manual', 'L形', null);
INSERT INTO `sp_attribute` VALUES ('3301', '颜色', '781', 'many', 'list', '粉色,浅绿色,白色,米白色,2米装（防撞条L形）,2米装（防撞条U形）', null);
INSERT INTO `sp_attribute` VALUES ('3302', '主体-品牌', '782', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3303', '规格-型号', '782', 'only', 'manual', 'SK-2', null);
INSERT INTO `sp_attribute` VALUES ('3304', '主体-品牌', '783', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3305', '规格-型号', '783', 'only', 'manual', 'FP-8012', null);
INSERT INTO `sp_attribute` VALUES ('3306', '规格', '783', 'many', 'list', '3合1保温杯(绿色),3合1保温杯(黄色),吸管保温杯(粉色),吸管保温杯(绿色),吸管保温杯(蓝色),吸管保温杯(黄色)', null);
INSERT INTO `sp_attribute` VALUES ('3307', '主体-适用年龄', '785', 'only', 'manual', '6-12个月', null);
INSERT INTO `sp_attribute` VALUES ('3308', '材质-包装尺寸', '785', 'only', 'manual', '112*103*45毫米', null);
INSERT INTO `sp_attribute` VALUES ('3309', '颜色', '785', 'many', 'list', '彩绘小鸟529,电子琴669,节奏棒817,音乐琴927', null);
INSERT INTO `sp_attribute` VALUES ('3310', '主体-品牌', '789', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3311', '规格-实物尺寸', '789', 'only', 'manual', '170*63厘米', null);
INSERT INTO `sp_attribute` VALUES ('3312', '颜色', '789', 'many', 'list', 'pvc红,pvc红+手柄,pvc红+手柄+按摩,pvc红发光+手柄+按摩,pu靓紫+手柄+按摩,pu玫红+手柄+按摩,pu酷灰+手柄+按摩,pu靓紫发光+手柄+按摩,pu玫红发光+手柄+按摩,pu酷灰发光+手柄+按摩', null);
INSERT INTO `sp_attribute` VALUES ('3313', '主体-品牌', '78', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3314', '规格-产品尺寸', '78', 'only', 'manual', '27*19*2', null);
INSERT INTO `sp_attribute` VALUES ('3315', '面料-面料', '78', 'only', 'manual', '硅胶', null);
INSERT INTO `sp_attribute` VALUES ('3316', '颜色', '78', 'many', 'list', '蓝色印花61112000,灰色6196000,蓝色6128800,灰色印花61111900,灰/绿61118900,蓝/绿6186002,灰/蓝61118800,粉/绿6185901,绿色6128900,两件装,单件装', null);
INSERT INTO `sp_attribute` VALUES ('3317', '主体-品牌', '790', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3318', '材质-包装尺寸', '790', 'only', 'manual', '435*90*260毫米', null);
INSERT INTO `sp_attribute` VALUES ('3319', '智恩堡钓鱼台', '790', 'many', 'list', '方形蓝色,方形粉色', null);
INSERT INTO `sp_attribute` VALUES ('3320', '主体-适用年龄', '791', 'only', 'manual', '6-12个月', null);
INSERT INTO `sp_attribute` VALUES ('3321', '规格-实物尺寸', '791', 'only', 'manual', '10*10厘米', null);
INSERT INTO `sp_attribute` VALUES ('3322', '主体-品牌', '792', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3323', '规格-包装', '792', 'only', 'manual', '收纳盒', null);
INSERT INTO `sp_attribute` VALUES ('3324', '主体-适用年龄', '793', 'only', 'manual', '1-3岁', null);
INSERT INTO `sp_attribute` VALUES ('3325', '材质-实物尺寸', '793', 'only', 'manual', '31*30*19厘米', null);
INSERT INTO `sp_attribute` VALUES ('3326', '客机', '793', 'many', 'list', '客机 5911,客机 5922,客机 5933', null);
INSERT INTO `sp_attribute` VALUES ('3327', '主体-品牌', '795', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3328', '规格-包装尺寸', '795', 'only', 'manual', '160*125*170毫米', null);
INSERT INTO `sp_attribute` VALUES ('3329', '颜色', '795', 'many', 'list', '乐迪,包警长,卡文,多多,小爱,小青,淘淘,米莉,胡须爷爷,酷雷,酷飞,金刚', null);
INSERT INTO `sp_attribute` VALUES ('3330', '主体-适用年龄', '796', 'only', 'manual', '6-14岁', null);
INSERT INTO `sp_attribute` VALUES ('3331', '材质-实物尺寸', '796', 'only', 'manual', '5.6X5.6X5.6厘米', null);
INSERT INTO `sp_attribute` VALUES ('3332', '234阶魔方永骏', '796', 'many', 'list', '三阶魔方冠龙黑+底座说明,三阶魔方冠龙白+底座说明,四阶魔方御速白+底座说明,四阶魔方御速黑+底座说明,四阶魔方御速粉+底座说明,二阶冠破黑+底座说明,二阶冠破白+底座说明', null);
INSERT INTO `sp_attribute` VALUES ('3333', '主体-品牌', '797', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3334', '规格-净重', '797', 'only', 'manual', '12千克', null);
INSERT INTO `sp_attribute` VALUES ('3335', '特性-座椅有效宽度', '797', 'only', 'manual', '35cm', null);
INSERT INTO `sp_attribute` VALUES ('3336', '颜色', '797', 'many', 'list', '美国队长后防【土豪金管】,宝石红后防【土豪金管】,珊瑚蓝后防【土豪金管】,富贵紫后防【土豪金管】,玫瑰红后防【玫瑰金铝管】,加州阳光后防【土豪金管】', null);
INSERT INTO `sp_attribute` VALUES ('3337', '主体-品牌', '798', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3338', '规格-产品尺寸', '798', 'only', 'manual', '120*60cm', null);
INSERT INTO `sp_attribute` VALUES ('3339', '特性-功能', '798', 'only', 'manual', '可折叠,带滚轮,带摇篮,可游戏', null);
INSERT INTO `sp_attribute` VALUES ('3340', '颜色', '798', 'many', 'list', '海湖蓝,梦幻紫,卡其色,115*60', null);
INSERT INTO `sp_attribute` VALUES ('3341', '主体-品牌', '799', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3342', '规格-产品尺寸', '799', 'only', 'manual', '14寸', null);
INSERT INTO `sp_attribute` VALUES ('3343', '特性-功能', '799', 'only', 'manual', '带辅助轮', null);
INSERT INTO `sp_attribute` VALUES ('3344', '颜色', '799', 'many', 'list', '豪华款-圣湖蓝(折叠车把石英表双碟刹),豪华款-极光黄(折叠车把石英表双碟刹),豪华款-香槟金(折叠车把石英表双碟刹),豪华款-公主粉(折叠车把石英表双碟刹),经典款-香槟金(后轮碟刹),经典款-极光黄(后轮碟刹),经典款-圣湖蓝(后轮碟刹),经典款-公主粉(后轮碟刹),12寸,14寸,16寸', null);
INSERT INTO `sp_attribute` VALUES ('3345', '主体-品牌', '800', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3346', '规格-净重', '800', 'only', 'manual', '14.5千克', null);
INSERT INTO `sp_attribute` VALUES ('3347', '功能-功能', '800', 'only', 'manual', '可遥控', null);
INSERT INTO `sp_attribute` VALUES ('3348', '颜色', '800', 'many', 'list', '中国红（原漆）,天空蓝（原漆）,皓月白（原漆）', null);
INSERT INTO `sp_attribute` VALUES ('3349', '主体-型号', '802', 'only', 'manual', 'K05', null);
INSERT INTO `sp_attribute` VALUES ('3350', '规格-净重', '802', 'only', 'manual', '8千克', null);
INSERT INTO `sp_attribute` VALUES ('3351', '特性-功能', '802', 'only', 'manual', '可折叠,靠背可调,带餐盘,高度可调,有安全带,便携式', null);
INSERT INTO `sp_attribute` VALUES ('3352', '颜色', '802', 'many', 'list', '沉醉咖,清新蓝,葡萄紫,藏青色,阳光橙', null);
INSERT INTO `sp_attribute` VALUES ('3353', '主体-品牌', '803', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3354', '材质-座椅骨架材质', '803', 'only', 'manual', '高强度金属骨架', null);
INSERT INTO `sp_attribute` VALUES ('3355', '规格-产品尺寸（长*宽*高', '803', 'only', 'manual', '450*450*600', null);
INSERT INTO `sp_attribute` VALUES ('3356', '颜色', '803', 'many', 'list', '经典黑红,尊贵紫,机灵斑马,优雅蓝,耀眼红', null);
INSERT INTO `sp_attribute` VALUES ('3357', '主体-适用年龄', '804', 'only', 'manual', '6-18个月', null);
INSERT INTO `sp_attribute` VALUES ('3358', '规格-产品尺寸', '804', 'only', 'manual', '720*610*910毫米', null);
INSERT INTO `sp_attribute` VALUES ('3359', '颜色', '804', 'many', 'list', '蓝色小马款,蓝色兔子款,米黄色小象款,粉色兔子款', null);
INSERT INTO `sp_attribute` VALUES ('3360', '主体参数-品牌', '805', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3361', '规格参数-车轮材质', '805', 'only', 'manual', 'PU', null);
INSERT INTO `sp_attribute` VALUES ('3362', '颜色', '805', 'many', 'list', 'A蓝色米奇（不分码）,B粉红米妮（不分码）,Q浅蓝冰雪奇缘（不分码）,D粉红公主（不分码）', null);
INSERT INTO `sp_attribute` VALUES ('3363', '主体-品牌', '806', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3364', '特性-最大承重量', '806', 'only', 'manual', '18kg', null);
INSERT INTO `sp_attribute` VALUES ('3365', '颜色', '806', 'many', 'list', '粉红色', null);
INSERT INTO `sp_attribute` VALUES ('3366', '主体-品牌', '807', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3367', '颜色', '807', 'many', 'list', '黑色,湖蓝色,灰白色,粉色,银灰色,L,XL', null);
INSERT INTO `sp_attribute` VALUES ('3368', '主体-品牌', '808', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3369', '颜色', '808', 'many', 'list', '浅灰色,灰色,黑色,藏青色,红色,浅咖啡,深咖啡', null);
INSERT INTO `sp_attribute` VALUES ('3370', '主体-品牌', '809', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3371', '颜色', '809', 'many', 'list', '宝蓝色,灰绿色,85D,75D,75B,85C,90C,75C,85B,90B,80B,80C,80D', null);
INSERT INTO `sp_attribute` VALUES ('3372', '主体-品牌', '810', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3373', '规格-规格', '810', 'only', 'manual', '竹炭U型', null);
INSERT INTO `sp_attribute` VALUES ('3374', '特性-是否可拆洗', '810', 'only', 'manual', '可拆洗', null);
INSERT INTO `sp_attribute` VALUES ('3375', '颜色', '810', 'many', 'list', '粉色,咖色,绿色', null);
INSERT INTO `sp_attribute` VALUES ('3376', '主体-品牌', '811', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3377', '规格-鞋面材质', '811', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('3378', '颜色', '811', 'many', 'list', '爱心蓝,红色,紫色,爱心紫,爱心红,蓝色,36/37,40/41,38/39', null);
INSERT INTO `sp_attribute` VALUES ('3379', '主体-品牌', '812', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3380', '颜色', '812', 'many', 'list', '.', null);
INSERT INTO `sp_attribute` VALUES ('3381', '主体-品牌', '813', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3382', '功能-特色功能', '813', 'only', 'manual', '空间多', null);
INSERT INTO `sp_attribute` VALUES ('3383', '颜色', '813', 'many', 'list', '乳白色宝蓝班花', null);
INSERT INTO `sp_attribute` VALUES ('3384', '主体-品牌', '815', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3385', '颜色', '815', 'many', 'list', '湖水蓝,松石绿,蔷薇粉', null);
INSERT INTO `sp_attribute` VALUES ('3386', '主体-品牌', '816', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3387', '面料-厚薄', '816', 'only', 'manual', '薄款', null);
INSERT INTO `sp_attribute` VALUES ('3388', '颜色', '816', 'many', 'list', '.,XL.,XXL,L.', null);
INSERT INTO `sp_attribute` VALUES ('3389', '主体-品牌', '817', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3390', '颜色', '817', 'many', 'list', 'XL码8片,L码10片', null);
INSERT INTO `sp_attribute` VALUES ('3391', '主体-品牌', '820', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3392', '宝宝性别', '820', 'many', 'list', '男宝宝,女宝宝,套餐A,套餐B,套餐C,套餐D,套餐A 10份,套餐E', null);
INSERT INTO `sp_attribute` VALUES ('3393', '主体-品牌', '821', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3394', '主体-品牌', '824', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3395', '规格-年龄段', '824', 'only', 'manual', '0-3月,3-6月,6-9月,9-12月', null);
INSERT INTO `sp_attribute` VALUES ('3396', '颜色', '824', 'many', 'list', '超级能恩1段800克,超级能恩2段800克,超级能恩3段800克', null);
INSERT INTO `sp_attribute` VALUES ('3397', '主体-品牌', '826', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3398', '规格-年龄段', '826', 'only', 'manual', '12-18月,18-24月,24-30月,30-36月', null);
INSERT INTO `sp_attribute` VALUES ('3399', '段位', '826', 'many', 'list', '1段1200克旗舰版,1段400克旗舰版,1段900克旗舰版,2段1200克旗舰版,2段900克旗舰版,3段1200克旗舰版,3段200克旗舰版,3段900克旗舰版,3段960克旗舰版,4段1200克旗舰版,4段900克旗舰版', null);
INSERT INTO `sp_attribute` VALUES ('3400', '主体-品牌', '827', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3401', '规格-年龄段', '827', 'only', 'manual', '24-30月,30-36月,4岁,5岁', null);
INSERT INTO `sp_attribute` VALUES ('3402', '德国爱他美', '827', 'many', 'list', '安心罐1+段(1-2岁),安心罐1段(0-6个月),安心罐2+段(2岁以上),安心罐2段(6-10个月),安心罐3段(10-12个月),安心罐PRE段(0-6个月),白金版1段(0-6个月),白金版2段(6-10个月),白金版PRE段(0-6个月)', null);
INSERT INTO `sp_attribute` VALUES ('3403', '主体-品牌', '828', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3404', '规格-年龄段', '828', 'only', 'manual', '24-30月,30-36月', null);
INSERT INTO `sp_attribute` VALUES ('3405', '英国牛栏', '828', 'many', 'list', '1段(0-6个月),2段(6-12个月),3段(1-2岁),4段(2-3岁)', null);
INSERT INTO `sp_attribute` VALUES ('3406', '主体-品牌', '829', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3407', '规格-保质期', '829', 'only', 'manual', '1095', null);
INSERT INTO `sp_attribute` VALUES ('3408', '其他-包装', '829', 'only', 'manual', '罐装', null);
INSERT INTO `sp_attribute` VALUES ('3409', '补充信息-国产/进口', '829', 'only', 'manual', '进口', null);
INSERT INTO `sp_attribute` VALUES ('3410', '颜色', '829', 'many', 'list', '益生菌儿童型30g,益生菌成人型30粒,DHA儿童型进口90粒,DHA孕成型进口60粒,DHA儿童型进口30粒,DHA孕成型进口30粒,DHA儿童型90粒,DHA孕成型60粒', null);
INSERT INTO `sp_attribute` VALUES ('3411', '主体-产地', '830', 'only', 'manual', '中国浙江杭州市', null);
INSERT INTO `sp_attribute` VALUES ('3412', '规格-包装', '830', 'only', 'manual', '盒装', null);
INSERT INTO `sp_attribute` VALUES ('3413', '其他-国产/进口', '830', 'only', 'manual', '国产', null);
INSERT INTO `sp_attribute` VALUES ('3414', '主体-品牌', '831', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3415', '规格-保质期', '831', 'only', 'manual', '18个月', null);
INSERT INTO `sp_attribute` VALUES ('3416', '类别', '831', 'many', 'list', 'DHA藻油低糖夹心软糖,佳铁元低糖夹心软糖,佳铁元复合微晶粉（小儿型）,富锌元复合微晶粉（小儿型）,维生素D3+钙复合微晶粉（婴儿型）,蜂蜜菊花植物固体饮料,金配多乳钙4盒装,金银花植物与香橙山楂草本固体饮料套装,钙铁锌复合微晶粉（小儿型）,香橙山楂草本固体饮料,鳕鱼肝油软胶囊4盒装,鳕鱼肝油软胶囊单盒装', null);
INSERT INTO `sp_attribute` VALUES ('3417', '主体-品牌', '834', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3418', '规格-保质期', '834', 'only', 'manual', '365 天', null);
INSERT INTO `sp_attribute` VALUES ('3419', '其他-包装', '834', 'only', 'manual', '袋装', null);
INSERT INTO `sp_attribute` VALUES ('3420', '口味', '834', 'many', 'list', '香蕉泥,西梅泥,苹果蓝莓泥,苹果草莓香蕉泥,西梅苹果泥,一段,二段', null);
INSERT INTO `sp_attribute` VALUES ('3421', '主体-品牌', '836', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3422', '规格-纸尿裤型号', '836', 'only', 'manual', 'L号', null);
INSERT INTO `sp_attribute` VALUES ('3423', '尤妮佳Moony', '836', 'many', 'list', 'L54片(9-14kg),M64片（6-11kg）,NB90片（0-5kg）,S84片（4-8kg）,拉拉裤L44片 女 (9-14kg),拉拉裤L44片 男 (9-14kg),拉拉裤XL38片 女 (12-22kg),拉拉裤XL38片 男 (12-22kg),拉拉裤XXL26片 女 （13-25kg）,拉拉裤XXL26片 男 （13-25kg）', null);
INSERT INTO `sp_attribute` VALUES ('3424', '主体-品牌', '838', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3425', '规格-纸尿裤型号', '838', 'only', 'manual', 'L号', null);
INSERT INTO `sp_attribute` VALUES ('3426', '型号', '838', 'many', 'list', 'L164片,L84片,M192片,M94片,S164片,XL128片,XL72片,XXL50片,初生NB96片,敏感肌肤56片,自然纯净64片,拉拉裤,湿巾,超薄干爽', null);
INSERT INTO `sp_attribute` VALUES ('3427', '主体-尿裤系列', '840', 'only', 'manual', '森林王子', null);
INSERT INTO `sp_attribute` VALUES ('3428', '规格-纸尿裤型号', '840', 'only', 'manual', 'L号', null);
INSERT INTO `sp_attribute` VALUES ('3429', '型号', '840', 'many', 'list', 'L号,M号,NB号,S号,XL号', null);
INSERT INTO `sp_attribute` VALUES ('3430', '主体-品牌', '841', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3431', '规格-型号', '841', 'only', 'manual', 'L号', null);
INSERT INTO `sp_attribute` VALUES ('3432', '型号', '841', 'many', 'list', '乐动学步裤,天才拉拉裤,手口护理巾,柔润金棉,柔润金棉出口装,柔薄乐动,薄&引力,薄快吸尿片,薄快吸尿裤,薄快吸拉拉裤,试用装,100片,L104,L108,L120,L136,L2,L22,L42,L60,L68,L92,M116,M128,M160,M24,M27,M52,M64,M70,M84,M96,S108,S168,S33,S64,S68,S80,S84,XL100,XL104,XL112,XL18,XL2,XL20,XL36,XL50,XL52,XL58,XL84,XL92,XXL18,XXL76,XXL92', null);
INSERT INTO `sp_attribute` VALUES ('3433', '主体-品牌', '842', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3434', '规格-纸尿裤型号', '842', 'only', 'manual', 'S号', null);
INSERT INTO `sp_attribute` VALUES ('3435', '主体-品牌', '843', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3436', '规格-纸尿裤型号', '843', 'only', 'manual', 'XL号', null);
INSERT INTO `sp_attribute` VALUES ('3437', '系列', '843', 'many', 'list', '智能干爽,智能棉柔,极柔柔软,瞬吸棉柔,超薄干爽,L21片,L23片,L46片,L60片,M23片,M26片,M52片,M66片,S34片,S68片,S78片,XL18片,XL21片,XL42片,XL52片,XXL16片', null);
INSERT INTO `sp_attribute` VALUES ('3438', '主体-品牌', '844', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3439', '特性-口径', '844', 'only', 'manual', '宽口径', null);
INSERT INTO `sp_attribute` VALUES ('3440', '类型', '844', 'many', 'list', 'Hello Kitty,Hello Kitty（2支装）,Hello Kitty（组合装）,迪士尼维尼,150ml+300ml+安抚奶嘴（0-6月）,150ml（带0-6月硅胶奶嘴）,300ml（带0-6月硅胶奶嘴）,300ml（带6-18月硅胶奶嘴）', null);
INSERT INTO `sp_attribute` VALUES ('3441', '主体-品牌', '845', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3442', '规格-型号', '845', 'only', 'manual', 'NA14', null);
INSERT INTO `sp_attribute` VALUES ('3443', '主体-品牌', '846', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3444', '洗发沐浴露', '846', 'many', 'list', '口手湿巾（开心食刻）80片,天然舒润滋养沐浴露400ml,婴儿牛奶沐浴露300ml,婴儿舒眠沐浴露1000ml,方洗发沐浴露400ml（柔泡型）,无泪配方清凉沐浴露1000ml,无泪配方清凉沐浴露300ml,洗发露100ml,洗发露200g,润肤油200ml,清凉沐浴露1000ml加300ml,牛奶沐浴露1000ml,牛奶沐浴露1000ml*2瓶,牛奶沐浴露1L+300ml,牛奶沐浴露500ml,牛奶润肤露 400ml,香桃沐浴露1L,香桃沐浴露300ml', null);
INSERT INTO `sp_attribute` VALUES ('3445', '主体-品牌', '850', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3446', '规格-净重', '850', 'only', 'manual', '1050克', null);
INSERT INTO `sp_attribute` VALUES ('3447', '种类', '850', 'many', 'list', '七巧板拼图（大）,七巧板拼图（小）,十五音木敲琴,卡通益智益智数独,声东击西打桩台,彩虹宝塔,桌游叠叠乐,认知动物串珠,音乐敲球台', null);
INSERT INTO `sp_attribute` VALUES ('3448', '主体-适用年龄', '852', 'only', 'manual', '1-3岁', null);
INSERT INTO `sp_attribute` VALUES ('3449', '规格-重量', '852', 'only', 'manual', '1克', null);
INSERT INTO `sp_attribute` VALUES ('3450', '颜色', '852', 'many', 'list', '49件套体验装+教材书+收纳箱+益智贴纸,109件套(4个车轮+摩天轮)+教材书+贴纸,169件套(6个车轮+摩天轮)+教材书+贴纸,225件套(6个车轮+摩天轮)+教材书+贴纸,302件套(8个车轮+摩天轮)+教材书+贴', null);
INSERT INTO `sp_attribute` VALUES ('3451', '主体-品牌', '854', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3452', '规格-净重', '854', 'only', 'manual', '0.000千克', null);
INSERT INTO `sp_attribute` VALUES ('3453', '特性-功能', '854', 'only', 'manual', '可折叠,前扶手,靠背可调,避震,可半躺', null);
INSERT INTO `sp_attribute` VALUES ('3454', '颜色', '854', 'many', 'list', '蜜桃粉（0-36个月）,薄荷绿（0-36个月）,粉红豹（0-36个月）,星空蓝（6-36个月）,牛仔（0-36个月）,粉红豹（6-36个月）,莱茵河（0-36个月）,莱茵河（6-36个月）,牛仔（6-36个月）', null);
INSERT INTO `sp_attribute` VALUES ('3455', '主体-品牌', '855', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3456', '材质-座椅骨架材质', '855', 'only', 'manual', '德国工业特制塑料底座', null);
INSERT INTO `sp_attribute` VALUES ('3457', '规格-产品尺寸（长*宽*高', '855', 'only', 'manual', '47*60*52', null);
INSERT INTO `sp_attribute` VALUES ('3458', '颜色', '855', 'many', 'list', '斑马,热情红,红色,皇室蓝,长颈鹿,闪耀紫,黑色,曜石黑', null);
INSERT INTO `sp_attribute` VALUES ('3459', '主体-品牌', '856', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3460', '颜色', '856', 'many', 'list', '藏青色,粉红色,暗紫色,XL,L', null);
INSERT INTO `sp_attribute` VALUES ('3461', '主体-品牌', '858', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3462', '颜色', '858', 'many', 'list', '白色,L', null);
INSERT INTO `sp_attribute` VALUES ('3463', '主观参数-品牌', '859', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3464', '实质参数-填充物', '859', 'only', 'manual', '白鸭绒51%-60%', null);
INSERT INTO `sp_attribute` VALUES ('3465', '细节参数-功能性', '859', 'only', 'manual', '无功能性', null);
INSERT INTO `sp_attribute` VALUES ('3466', '颜色', '859', 'many', 'list', '【黑色】,灰色,黑色,L,XXL,M,XL,3XL', null);
INSERT INTO `sp_attribute` VALUES ('3467', '主观参数-品牌', '860', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3468', '实质参数-适用人群', '860', 'only', 'manual', '男', null);
INSERT INTO `sp_attribute` VALUES ('3469', '细节参数-场合', '860', 'only', 'manual', '上班', null);
INSERT INTO `sp_attribute` VALUES ('3470', '颜色', '860', 'many', 'list', '黑色,土黄色,咖啡色,L,2XL,4XL,M,XL,3XL', null);
INSERT INTO `sp_attribute` VALUES ('3471', '主观参数-品牌', '861', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3472', '实质参数-材质成份', '861', 'only', 'manual', '聚酯纤维', null);
INSERT INTO `sp_attribute` VALUES ('3473', '颜色', '861', 'many', 'list', 'G2201,G2202,G2203,G2205,G2206,G2207,G2208,G2209,G2210,G2211,G2212,G2213,G2215,G2216,G2217,G2218,G2219,G2220,G2221,S/37,M/38,L/39,XL/40,XXL/41,3XL/42,4XL/43,5XL/44', null);
INSERT INTO `sp_attribute` VALUES ('3474', '主观参数-面料主材质（男）', '862', 'only', 'manual', '涤纶', null);
INSERT INTO `sp_attribute` VALUES ('3475', '实质参数-材质成份', '862', 'only', 'manual', '粘纤', null);
INSERT INTO `sp_attribute` VALUES ('3476', '细节参数-适用场景', '862', 'only', 'manual', '居家,休闲', null);
INSERT INTO `sp_attribute` VALUES ('3477', '颜色', '862', 'many', 'list', 'M02款红色加绒,M02款蓝色加绒,M02款橘色加绒,M01款黄色加绒,M01款蓝色加绒,M01款红色加绒,M01款橘色加绒,666款橘色薄款,666款军绿色薄款,666款红色薄款,760款军绿色薄款,760款蓝色薄款,760款红色薄款,XXL,L,M,XL,3XL', null);
INSERT INTO `sp_attribute` VALUES ('3478', '主观参数-面料主材质（男）', '864', 'only', 'manual', '涤纶', null);
INSERT INTO `sp_attribute` VALUES ('3479', '实质参数-场合', '864', 'only', 'manual', '日常,上班,休闲', null);
INSERT INTO `sp_attribute` VALUES ('3480', '细节参数-衣门襟', '864', 'only', 'manual', '单排扣', null);
INSERT INTO `sp_attribute` VALUES ('3481', '颜色', '864', 'many', 'list', '藏青加绒,灰色加绒,蓝色加绒,灰色,黑色加绒,黑色,藏青,卡其,蓝色,卡其加绒,L,2XL,4XL,M,XL,3XL,5XL', null);
INSERT INTO `sp_attribute` VALUES ('3482', '主观参数-品牌', '865', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3483', '实质参数-适用对象', '865', 'only', 'manual', '青年', null);
INSERT INTO `sp_attribute` VALUES ('3484', '颜色', '865', 'many', 'list', '黑色单款,藏青色单款,白色单款,浅灰色单款,白色加绒款,黑色加绒款,藏青色加绒款,浅灰色加绒款,M,L,XL,XXL,3XL,4XL,5XL', null);
INSERT INTO `sp_attribute` VALUES ('3485', '主观参数-品牌', '867', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3486', '实质参数-材质成分含量', '867', 'only', 'manual', '4%', null);
INSERT INTO `sp_attribute` VALUES ('3487', '细节参数-花型图案', '867', 'only', 'manual', '纯色', null);
INSERT INTO `sp_attribute` VALUES ('3488', '颜色', '867', 'many', 'list', '黑色1,灰色1,28,34,29,30,36,33,31,32', null);
INSERT INTO `sp_attribute` VALUES ('3489', '主观参数-货号', '868', 'only', 'manual', '20', null);
INSERT INTO `sp_attribute` VALUES ('3490', '实质参数-裤长', '868', 'only', 'manual', '长裤', null);
INSERT INTO `sp_attribute` VALUES ('3491', '颜色', '868', 'many', 'list', '087款,604款,不加绒浅蓝色,不加绒深蓝色,32(2尺5),40(3尺4),33(2尺6),36(2尺9),38(3尺1),29(2尺2),28(2尺1),30(2尺3),34(2尺7),31(2尺4)', null);
INSERT INTO `sp_attribute` VALUES ('3492', '主观参数-品牌', '869', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3493', '实质参数-场合', '869', 'only', 'manual', '日常', null);
INSERT INTO `sp_attribute` VALUES ('3494', '细节参数-衣门襟', '869', 'only', 'manual', '拉链', null);
INSERT INTO `sp_attribute` VALUES ('3495', '颜色', '869', 'many', 'list', '灰色,黑色,藏青色,L,2XL,4XL,M,XL,3XL,5XL', null);
INSERT INTO `sp_attribute` VALUES ('3496', '主体-商品名称', '86', 'only', 'manual', 'A.O.史密斯空气净化器KJ400F-B11', null);
INSERT INTO `sp_attribute` VALUES ('3497', '新国标参数-颗粒物CADR值', '86', 'only', 'manual', '400m3/h', null);
INSERT INTO `sp_attribute` VALUES ('3498', '外观-颜色', '86', 'only', 'manual', '灰色系', null);
INSERT INTO `sp_attribute` VALUES ('3499', '功能-适用面积', '86', 'only', 'manual', '(0.07～0.12)*CADR平方米', null);
INSERT INTO `sp_attribute` VALUES ('3500', '滤网-是否有多层滤网', '86', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('3501', '规格参数-毛重', '86', 'only', 'manual', '20千克', null);
INSERT INTO `sp_attribute` VALUES ('3502', '型号', '86', 'many', 'list', '净霾实时数显420CADR,净霾智能实时数显350CADR,净霾智能实时数显545CADR,卧室适用长效过滤350CADR,新居除甲醛适用400CADR,新居除醛智能数显400CADR,新居除醛智能数显560CADR', null);
INSERT INTO `sp_attribute` VALUES ('3503', '主观参数-品牌', '870', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3504', '实质参数-裤长', '870', 'only', 'manual', '长裤', null);
INSERT INTO `sp_attribute` VALUES ('3505', '细节参数-场合', '870', 'only', 'manual', '居家,旅游,日常,商务,上班,休闲,宴会,婚礼', null);
INSERT INTO `sp_attribute` VALUES ('3506', '颜色', '870', 'many', 'list', '黑色,27,28,34,29,30,38,35,36,33,31,32', null);
INSERT INTO `sp_attribute` VALUES ('3507', '主观参数-品牌', '882', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3508', '实质参数-材质成份', '882', 'only', 'manual', '聚酯纤维', null);
INSERT INTO `sp_attribute` VALUES ('3509', '颜色', '882', 'many', 'list', '666款红色,666款军绿色,666款橘色,760款军绿色,760款蓝色,760款红色,M,L,XL,XXL,3XL', null);
INSERT INTO `sp_attribute` VALUES ('3510', '主观参数-品牌', '886', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3511', '实质参数-适用人群', '886', 'only', 'manual', '男', null);
INSERT INTO `sp_attribute` VALUES ('3512', '细节参数-场合', '886', 'only', 'manual', '休闲', null);
INSERT INTO `sp_attribute` VALUES ('3513', '颜色', '886', 'many', 'list', '102(深蓝),001(黑色),185/100A/XXXL,170/88A/L,180/96A/XXL,165/84A/M,175/92A/XL', null);
INSERT INTO `sp_attribute` VALUES ('3514', '主观参数-品牌', '887', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3515', '实质参数-适用人群', '887', 'only', 'manual', '男', null);
INSERT INTO `sp_attribute` VALUES ('3516', '细节参数-场合', '887', 'only', 'manual', '居家,商务', null);
INSERT INTO `sp_attribute` VALUES ('3517', '颜色', '887', 'many', 'list', '02C蓝灰,05C宝蓝,01C黑色,03C深灰,L,XXL,M,XL,S,XXXL', null);
INSERT INTO `sp_attribute` VALUES ('3518', '主观参数-货号', '888', 'only', 'manual', '5QXC014', null);
INSERT INTO `sp_attribute` VALUES ('3519', '实质参数-适用人群', '888', 'only', 'manual', '男士', null);
INSERT INTO `sp_attribute` VALUES ('3520', '细节参数-场合', '888', 'only', 'manual', '日常,商务,上班,其他休闲', null);
INSERT INTO `sp_attribute` VALUES ('3521', '颜色', '888', 'many', 'list', '藏青,军绿,165,170,175,180,185,190', null);
INSERT INTO `sp_attribute` VALUES ('3522', '主观参数-品牌', '889', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3523', '实质参数-材质成份', '889', 'only', 'manual', '纯棉', null);
INSERT INTO `sp_attribute` VALUES ('3524', '颜色', '889', 'many', 'list', 'SDP19002BBA,38码,39码,40码,41码,42码,43码', null);
INSERT INTO `sp_attribute` VALUES ('3525', '主观参数-货号', '890', 'only', 'manual', 'HWJ8J3140', null);
INSERT INTO `sp_attribute` VALUES ('3526', '实质参数-适用人群', '890', 'only', 'manual', '男', null);
INSERT INTO `sp_attribute` VALUES ('3527', '细节参数-场合', '890', 'only', 'manual', '日常,商务,上班', null);
INSERT INTO `sp_attribute` VALUES ('3528', '颜色', '890', 'many', 'list', 'B5藏青,180/96A,185/100A,190/104B,170/88A,175/92A,165/84A', null);
INSERT INTO `sp_attribute` VALUES ('3529', '主观参数-品牌', '891', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3530', '实质参数-适用人群', '891', 'only', 'manual', '男', null);
INSERT INTO `sp_attribute` VALUES ('3531', '细节参数-场合', '891', 'only', 'manual', '日常,休闲', null);
INSERT INTO `sp_attribute` VALUES ('3532', '颜色', '891', 'many', 'list', '浅蓝色,红色,深蓝色,黑色,深卡其,XXL(180/96A),M(165/84A),XL(175/92A),3XL(185/100A),L(170/88A),4XL(190/104A)', null);
INSERT INTO `sp_attribute` VALUES ('3533', '主观参数-品牌', '893', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3534', '实质参数-填充物', '893', 'only', 'manual', '白鹅绒', null);
INSERT INTO `sp_attribute` VALUES ('3535', '细节参数-功能性', '893', 'only', 'manual', '双面穿', null);
INSERT INTO `sp_attribute` VALUES ('3536', '颜色', '893', 'many', 'list', '米灰03,黑色09,酒红18,L,2XL,4XL,M,XL,3XL,S,5XL', null);
INSERT INTO `sp_attribute` VALUES ('3537', '主观参数-品牌', '894', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3538', '实质参数-适用人群', '894', 'only', 'manual', '男', null);
INSERT INTO `sp_attribute` VALUES ('3539', '细节参数-场合', '894', 'only', 'manual', '运动', null);
INSERT INTO `sp_attribute` VALUES ('3540', '颜色', '894', 'many', 'list', '默认颜色,165,175,180,170', null);
INSERT INTO `sp_attribute` VALUES ('3541', '主观参数-品牌', '895', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3542', '实质参数-适用人群', '895', 'only', 'manual', '男', null);
INSERT INTO `sp_attribute` VALUES ('3543', '细节参数-场合', '895', 'only', 'manual', '日常', null);
INSERT INTO `sp_attribute` VALUES ('3544', '颜色', '895', 'many', 'list', '原色,深蓝,黑色,180/100A,185/104B,175/96A,170/92A,165/88A', null);
INSERT INTO `sp_attribute` VALUES ('3545', '主观参数-品牌', '898', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3546', '实质参数-适用人群', '898', 'only', 'manual', '男', null);
INSERT INTO `sp_attribute` VALUES ('3547', '细节参数-场合', '898', 'only', 'manual', '休闲', null);
INSERT INTO `sp_attribute` VALUES ('3548', '颜色', '898', 'many', 'list', '黑色,185/XXL,190/XXXL,165/S,170/M,175/L,180/XL', null);
INSERT INTO `sp_attribute` VALUES ('3549', '主观参数-品牌', '899', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3550', '实质参数-适用季节', '899', 'only', 'manual', '春季', null);
INSERT INTO `sp_attribute` VALUES ('3551', '细节参数-风格', '899', 'only', 'manual', '商务', null);
INSERT INTO `sp_attribute` VALUES ('3552', '颜色', '899', 'many', 'list', '杏色,棕色,43码,44码,38码,39码,41码,42码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3553', '主体-商品名称', '8', 'only', 'manual', '夏普彩电(sharp)LCD-70TX85A单机(优酷）', null);
INSERT INTO `sp_attribute` VALUES ('3554', '显示-曲面', '8', 'only', 'manual', '否', null);
INSERT INTO `sp_attribute` VALUES ('3555', '系统-智能电视', '8', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('3556', '功耗-整机功率（W）', '8', 'only', 'manual', '245瓦特', null);
INSERT INTO `sp_attribute` VALUES ('3557', '主观参数-型号', '900', 'only', 'manual', 'A632374110', null);
INSERT INTO `sp_attribute` VALUES ('3558', '实质参数-适用季节', '900', 'only', 'manual', '春季,秋季', null);
INSERT INTO `sp_attribute` VALUES ('3559', '细节参数-功能', '900', 'only', 'manual', '耐磨', null);
INSERT INTO `sp_attribute` VALUES ('3560', '颜色', '900', 'many', 'list', '黄棕,古铜,43码,44码,38码,39码,41码,42码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3561', '主观参数-型号', '902', 'only', 'manual', '7822809', null);
INSERT INTO `sp_attribute` VALUES ('3562', '实质参数-适用季节', '902', 'only', 'manual', '秋季,冬季', null);
INSERT INTO `sp_attribute` VALUES ('3563', '细节参数-功能', '902', 'only', 'manual', '耐磨', null);
INSERT INTO `sp_attribute` VALUES ('3564', '颜色', '902', 'many', 'list', '蓝色,桔色,绿色,43码,44码,39码,41码,42码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3565', '主观参数-品牌', '903', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3566', '实质参数-适用季节', '903', 'only', 'manual', '冬季', null);
INSERT INTO `sp_attribute` VALUES ('3567', '细节参数-图案', '903', 'only', 'manual', '纯色', null);
INSERT INTO `sp_attribute` VALUES ('3568', '颜色', '903', 'many', 'list', '黑色,红棕,43码,44码,38码,39码,41码,42码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3569', '主观参数-型号', '905', 'only', 'manual', 'DJC-16001', null);
INSERT INTO `sp_attribute` VALUES ('3570', '实质参数-适用季节', '905', 'only', 'manual', '冬季', null);
INSERT INTO `sp_attribute` VALUES ('3571', '细节参数-鞋头款式', '905', 'only', 'manual', '方头', null);
INSERT INTO `sp_attribute` VALUES ('3572', '颜色', '905', 'many', 'list', '黑色,46,39,38,44,43,42,41,40', null);
INSERT INTO `sp_attribute` VALUES ('3573', '主观参数-品牌', '907', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3574', '实质参数-适用季节', '907', 'only', 'manual', '春季,秋季,冬季', null);
INSERT INTO `sp_attribute` VALUES ('3575', '细节参数-功能', '907', 'only', 'manual', '保暖', null);
INSERT INTO `sp_attribute` VALUES ('3576', '颜色', '907', 'many', 'list', '卡其色,蓝色,黑色,39码,40码,41码,42码,43码,44码', null);
INSERT INTO `sp_attribute` VALUES ('3577', '主观参数-型号', '908', 'only', 'manual', '132491SM', null);
INSERT INTO `sp_attribute` VALUES ('3578', '实质参数-适用季节', '908', 'only', 'manual', '秋季,冬季', null);
INSERT INTO `sp_attribute` VALUES ('3579', '细节参数-鞋跟形状', '908', 'only', 'manual', '平跟', null);
INSERT INTO `sp_attribute` VALUES ('3580', '颜色', '908', 'many', 'list', 'N30-卡其,MS19-黑色,N30黑色,N30蓝色,MS28黑色,MS28卡其,39码,40码,41码,42码,43码,44码,39,40,41,42,43,44', null);
INSERT INTO `sp_attribute` VALUES ('3581', '主观参数-型号', '909', 'only', 'manual', 'DA12602', null);
INSERT INTO `sp_attribute` VALUES ('3582', '实质参数-适用季节', '909', 'only', 'manual', '春季,秋季', null);
INSERT INTO `sp_attribute` VALUES ('3583', '细节参数-功能', '909', 'only', 'manual', '轻质', null);
INSERT INTO `sp_attribute` VALUES ('3584', '颜色', '909', 'many', 'list', '黑色,红棕,39,38,44,43,42,41,40', null);
INSERT INTO `sp_attribute` VALUES ('3585', '主体-品牌', '90', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3586', '规格-规格', '90', 'only', 'manual', '400', null);
INSERT INTO `sp_attribute` VALUES ('3587', '功效-功效', '90', 'only', 'manual', '清爽', null);
INSERT INTO `sp_attribute` VALUES ('3588', '主观参数-型号', '910', 'only', 'manual', '9-01', null);
INSERT INTO `sp_attribute` VALUES ('3589', '实质参数-适用季节', '910', 'only', 'manual', '夏季', null);
INSERT INTO `sp_attribute` VALUES ('3590', '细节参数-功能', '910', 'only', 'manual', '透气', null);
INSERT INTO `sp_attribute` VALUES ('3591', '颜色', '910', 'many', 'list', '黑白色,纯黑,红色,白黑色,蓝色,纯黑【加绒】,黑白色【加绒】,43码,44码,38码,37码,39码,41码,42码,36码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3592', '主观参数-型号', '911', 'only', 'manual', '1', null);
INSERT INTO `sp_attribute` VALUES ('3593', '实质参数-适用季节', '911', 'only', 'manual', '春季,秋季', null);
INSERT INTO `sp_attribute` VALUES ('3594', '细节参数-功能', '911', 'only', 'manual', '轻质', null);
INSERT INTO `sp_attribute` VALUES ('3595', '颜色', '911', 'many', 'list', '棕,黑,39,38,44,43,42,41,40', null);
INSERT INTO `sp_attribute` VALUES ('3596', '主观参数-品牌', '913', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3597', '实质参数-适用季节', '913', 'only', 'manual', '冬季', null);
INSERT INTO `sp_attribute` VALUES ('3598', '细节参数-图案', '913', 'only', 'manual', '纯色', null);
INSERT INTO `sp_attribute` VALUES ('3599', '颜色', '913', 'many', 'list', '浅棕色,黑色,39,38,44,43,42,41,40', null);
INSERT INTO `sp_attribute` VALUES ('3600', '主观参数-品牌', '914', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3601', '细节参数-鞋头款式', '914', 'only', 'manual', '圆头', null);
INSERT INTO `sp_attribute` VALUES ('3602', '其他-上市时间', '914', 'only', 'manual', '2017年', null);
INSERT INTO `sp_attribute` VALUES ('3603', '颜色', '914', 'many', 'list', '黑色,红色,33码,34码码,35码码,36码码,37码码,38码码,39码码,40码码', null);
INSERT INTO `sp_attribute` VALUES ('3604', '主观参数-品牌', '915', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3605', '实质参数-适用季节', '915', 'only', 'manual', '春季', null);
INSERT INTO `sp_attribute` VALUES ('3606', '细节参数-鞋跟', '915', 'only', 'manual', '平跟', null);
INSERT INTO `sp_attribute` VALUES ('3607', '颜色', '915', 'many', 'list', '棕色,黑色,43码,44码,38码,45码,37码,39码,41码,46码,42码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3608', '主观参数-品牌', '919', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3609', '实质参数-适用季节', '919', 'only', 'manual', '春季,秋季,冬季', null);
INSERT INTO `sp_attribute` VALUES ('3610', '细节参数-功能', '919', 'only', 'manual', '透气', null);
INSERT INTO `sp_attribute` VALUES ('3611', '颜色', '919', 'many', 'list', '白色,深蓝,黑色,卡其,DA75132-2白色,DA75132-2黑色,43码,44码,45码,39码,41码,42码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3612', '主体-品牌', '91', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3613', '规格-规格', '91', 'only', 'manual', '罐装50ML', null);
INSERT INTO `sp_attribute` VALUES ('3614', '功效-功效', '91', 'only', 'manual', '美白,清爽,修护,淡斑,淡化疤痕,保湿补水,滋润营养,淡化干纹,紧肤淡皱,提拉紧致', null);
INSERT INTO `sp_attribute` VALUES ('3615', '主观参数-品牌', '922', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3616', '实质参数-适用季节', '922', 'only', 'manual', '春季,夏季,冬季,秋季', null);
INSERT INTO `sp_attribute` VALUES ('3617', '细节参数-图案', '922', 'only', 'manual', '纯色', null);
INSERT INTO `sp_attribute` VALUES ('3618', '颜色', '922', 'many', 'list', '棕色,黑色,41(正常皮鞋码),40(正常皮鞋码),38(正常皮鞋码),44(正常皮鞋码),42(正常皮鞋码),43(正常皮鞋码),39(正常皮鞋码)', null);
INSERT INTO `sp_attribute` VALUES ('3619', '主观参数-品牌', '923', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3620', '实质参数-填充物', '923', 'only', 'manual', '白鹅绒', null);
INSERT INTO `sp_attribute` VALUES ('3621', '细节参数-含绒量', '923', 'only', 'manual', '95%', null);
INSERT INTO `sp_attribute` VALUES ('3622', '颜色', '923', 'many', 'list', '黑色,灰色,粉色,S,M,L,XL', null);
INSERT INTO `sp_attribute` VALUES ('3623', '主观参数-品牌', '924', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3624', '实质参数-适用人群', '924', 'only', 'manual', '女士', null);
INSERT INTO `sp_attribute` VALUES ('3625', '颜色', '924', 'many', 'list', '军绿色,深灰色,红色,藏青色,均码', null);
INSERT INTO `sp_attribute` VALUES ('3626', '商品参数-货号', '925', 'only', 'manual', '6608', null);
INSERT INTO `sp_attribute` VALUES ('3627', '颜色', '925', 'many', 'list', '黑色,S,M,L,XL,XXL', null);
INSERT INTO `sp_attribute` VALUES ('3628', '商品参数-货号', '926', 'only', 'manual', '172002', null);
INSERT INTO `sp_attribute` VALUES ('3629', '颜色', '926', 'many', 'list', '焦糖色,黑色,酒红色,L,2XL,M,XL', null);
INSERT INTO `sp_attribute` VALUES ('3630', '商品参数-货号', '928', 'only', 'manual', 'jb7109#', null);
INSERT INTO `sp_attribute` VALUES ('3631', '棉衣参数-材质成份', '928', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('3632', '颜色', '928', 'many', 'list', '粉色,红色,灰色,黑色,军绿,蓝色,XXL,L,M,XL,XXXL,S', null);
INSERT INTO `sp_attribute` VALUES ('3633', '主观参数-品牌', '929', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3634', '实质参数-组合形式', '929', 'only', 'manual', '单件', null);
INSERT INTO `sp_attribute` VALUES ('3635', '细节参数-版型', '929', 'only', 'manual', '直筒', null);
INSERT INTO `sp_attribute` VALUES ('3636', '颜色', '929', 'many', 'list', '粉色,L,M,S', null);
INSERT INTO `sp_attribute` VALUES ('3637', '主观参数-品牌', '930', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3638', '实质参数-裙长', '930', 'only', 'manual', '短裙', null);
INSERT INTO `sp_attribute` VALUES ('3639', '颜色', '930', 'many', 'list', '灰色格子,咖啡格子,L,2XL,M,XL,S', null);
INSERT INTO `sp_attribute` VALUES ('3640', '主观参数-品牌', '931', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3641', '实质参数-袖长', '931', 'only', 'manual', '长袖', null);
INSERT INTO `sp_attribute` VALUES ('3642', '颜色', '931', 'many', 'list', '蓝色,L,M,S', null);
INSERT INTO `sp_attribute` VALUES ('3643', '商品参数-货号', '932', 'only', 'manual', '1873061300', null);
INSERT INTO `sp_attribute` VALUES ('3644', '颜色', '932', 'many', 'list', '灰色,深宝蓝,军绿,卡其色,L,M,XL,S', null);
INSERT INTO `sp_attribute` VALUES ('3645', '主观参数-品牌', '933', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3646', '实质参数-裤长', '933', 'only', 'manual', '长裤', null);
INSERT INTO `sp_attribute` VALUES ('3647', '颜色', '933', 'many', 'list', '加绒业2316黑色,加绒业2316深蓝色,26码,27码,28码,29码,30码,31码,32码', null);
INSERT INTO `sp_attribute` VALUES ('3648', '主观参数-品牌', '934', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3649', '实质参数-适用人群', '934', 'only', 'manual', '女士', null);
INSERT INTO `sp_attribute` VALUES ('3650', '细节参数-衣门襟', '934', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('3651', '颜色', '934', 'many', 'list', '杏色,黑色,军绿色,L,XXL,M,XL,XXXL', null);
INSERT INTO `sp_attribute` VALUES ('3652', '主观参数-货号', '935', 'only', 'manual', 'V5029556068', null);
INSERT INTO `sp_attribute` VALUES ('3653', '实质参数-适用人群', '935', 'only', 'manual', '女士', null);
INSERT INTO `sp_attribute` VALUES ('3654', '颜色', '935', 'many', 'list', '黑色,红色,XXL,XL,L,M', null);
INSERT INTO `sp_attribute` VALUES ('3655', '商品参数-货号', '936', 'only', 'manual', '6109', null);
INSERT INTO `sp_attribute` VALUES ('3656', '颜色', '936', 'many', 'list', '黑色,焦糖色,矿灰色,驼色,M,L,XL,XXL,XXXL', null);
INSERT INTO `sp_attribute` VALUES ('3657', '商品参数-品牌', '937', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3658', '颜色', '937', 'many', 'list', '杏色,黑色,灰色,S,M,L,XL,XXL', null);
INSERT INTO `sp_attribute` VALUES ('3659', '主观参数-品牌', '939', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3660', '实质参数-裤长', '939', 'only', 'manual', '长裤', null);
INSERT INTO `sp_attribute` VALUES ('3661', '颜色', '939', 'many', 'list', '黑色,墨绿,咖啡,灰色,藏青,酒红,均码', null);
INSERT INTO `sp_attribute` VALUES ('3662', '主观参数-型号', '940', 'only', 'manual', '111', null);
INSERT INTO `sp_attribute` VALUES ('3663', '实质参数-袖长', '940', 'only', 'manual', '其他', null);
INSERT INTO `sp_attribute` VALUES ('3664', '细节参数-风格', '940', 'only', 'manual', '简约', null);
INSERT INTO `sp_attribute` VALUES ('3665', '颜色', '940', 'many', 'list', '兰花,码数偏小建议拍大一码,S,M,L,XL,XXL', null);
INSERT INTO `sp_attribute` VALUES ('3666', '主观参数-货号', '941', 'only', 'manual', 'RALOS-0.7', null);
INSERT INTO `sp_attribute` VALUES ('3667', '实质参数-适用人群', '941', 'only', 'manual', '女士', null);
INSERT INTO `sp_attribute` VALUES ('3668', '细节参数-衣门襟', '941', 'only', 'manual', '一粒扣', null);
INSERT INTO `sp_attribute` VALUES ('3669', '颜色', '941', 'many', 'list', '黄色,白色,粉色,蓝色,玫红,XXL,L,M,XL,XXXL', null);
INSERT INTO `sp_attribute` VALUES ('3670', '主观参数-品牌', '942', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3671', '实质参数-填充物', '942', 'only', 'manual', '白鹅绒', null);
INSERT INTO `sp_attribute` VALUES ('3672', '细节参数-含绒量', '942', 'only', 'manual', '80%', null);
INSERT INTO `sp_attribute` VALUES ('3673', '颜色', '942', 'many', 'list', '米黄2.0,米黄,L,M,XL,S,XXL', null);
INSERT INTO `sp_attribute` VALUES ('3674', '商品参数-货号', '943', 'only', 'manual', '8530110306', null);
INSERT INTO `sp_attribute` VALUES ('3675', '颜色', '943', 'many', 'list', '白色,天蓝色,L,M,S', null);
INSERT INTO `sp_attribute` VALUES ('3676', '商品参数-品牌', '944', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3677', '颜色', '944', 'many', 'list', '米白色,2XL,4XL,6XL,XL,3XL,5XL', null);
INSERT INTO `sp_attribute` VALUES ('3678', '商品参数-货号', '945', 'only', 'manual', 'NG8201', null);
INSERT INTO `sp_attribute` VALUES ('3679', '颜色', '945', 'many', 'list', '白色,粉色,L,M,S', null);
INSERT INTO `sp_attribute` VALUES ('3680', '主观参数-品牌', '947', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3681', '实质参数-适用人群', '947', 'only', 'manual', '女士', null);
INSERT INTO `sp_attribute` VALUES ('3682', '颜色', '947', 'many', 'list', '暗紫色,XXXL现货,XL现货,XXL现货,M现货,S现货,L现货', null);
INSERT INTO `sp_attribute` VALUES ('3683', '主观参数-品牌', '948', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3684', '实质参数-适用人群', '948', 'only', 'manual', '女士', null);
INSERT INTO `sp_attribute` VALUES ('3685', '颜色', '948', 'many', 'list', '姜黄色,L,2XL,M,XL,S', null);
INSERT INTO `sp_attribute` VALUES ('3686', '主观参数-货号', '949', 'only', 'manual', '00000', null);
INSERT INTO `sp_attribute` VALUES ('3687', '实质参数-袖长', '949', 'only', 'manual', '长袖', null);
INSERT INTO `sp_attribute` VALUES ('3688', '颜色', '949', 'many', 'list', '白色,粉色,黑色,L,XXL,M,XL,S,XXXL', null);
INSERT INTO `sp_attribute` VALUES ('3689', '主体参数-品牌', '94', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3690', '规格参数-包装', '94', 'only', 'manual', '箱装', null);
INSERT INTO `sp_attribute` VALUES ('3691', '规格', '94', 'many', 'list', '330ml 原味,330ml青柠味,330ml柠檬味,500ml 青柠味,250ml青柠味,250ml原味,500ml橘子,500ml西柚,500ml柠檬,500ml原味', null);
INSERT INTO `sp_attribute` VALUES ('3692', '主观参数-品牌', '951', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3693', '实质参数-适用年龄', '951', 'only', 'manual', '25-30岁', null);
INSERT INTO `sp_attribute` VALUES ('3694', '细节参数-衣门襟', '951', 'only', 'manual', '套头', null);
INSERT INTO `sp_attribute` VALUES ('3695', '颜色', '951', 'many', 'list', '宝兰色混白色,幻彩黄混白,S,M,L,XL', null);
INSERT INTO `sp_attribute` VALUES ('3696', '主观参数-品牌', '962', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3697', '实质参数-适用季节', '962', 'only', 'manual', '秋季,冬季', null);
INSERT INTO `sp_attribute` VALUES ('3698', '细节参数-鞋跟形状', '962', 'only', 'manual', '平跟', null);
INSERT INTO `sp_attribute` VALUES ('3699', '颜色', '962', 'many', 'list', '79粉色（标准码）,79黑色（标准码）,79白色（标准码）,909白色（标准码）,909黑色（标准码）,35码,38码,37码,39码,36码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3700', '主观参数-品牌', '966', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3701', '细节参数-鞋头款式', '966', 'only', 'manual', '包头', null);
INSERT INTO `sp_attribute` VALUES ('3702', '颜色', '966', 'many', 'list', '白色,黑色,33码,34码,35码,36码,37码,38码,39码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3703', '主观参数-品牌', '967', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3704', '细节参数-鞋头款式', '967', 'only', 'manual', '圆头', null);
INSERT INTO `sp_attribute` VALUES ('3705', '其他-上市时间', '967', 'only', 'manual', '2017年', null);
INSERT INTO `sp_attribute` VALUES ('3706', '颜色', '967', 'many', 'list', '白/兰色,白/浅绿,白/粉色,白/金色,白/绿色,白/红色,白/黑色,33码,34码,35码,36码,37码,38码,39码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3707', '主观参数-品牌', '968', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3708', '细节参数-鞋头款式', '968', 'only', 'manual', '露趾', null);
INSERT INTO `sp_attribute` VALUES ('3709', '颜色', '968', 'many', 'list', '金色,灰色,银色,33码,34码,35码,36码,37码,38码,39码,40码', null);
INSERT INTO `sp_attribute` VALUES ('3710', '主观参数-品牌', '969', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3711', '细节参数-鞋头款式', '969', 'only', 'manual', '圆头', null);
INSERT INTO `sp_attribute` VALUES ('3712', '其他-上市时间', '969', 'only', 'manual', '2017年', null);
INSERT INTO `sp_attribute` VALUES ('3713', '颜色', '969', 'many', 'list', '白色,黑色,35,36,37,38,39', null);
INSERT INTO `sp_attribute` VALUES ('3714', '主体-品牌', '970', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3715', '规格-动力类型', '970', 'only', 'manual', '汽油', null);
INSERT INTO `sp_attribute` VALUES ('3716', '颜色', '970', 'many', 'list', '白色,黑色,灰色', null);
INSERT INTO `sp_attribute` VALUES ('3717', '主体-品牌', '971', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3718', '规格-发动机类型', '971', 'only', 'manual', '单缸', null);
INSERT INTO `sp_attribute` VALUES ('3719', '颜色', '971', 'many', 'list', '（鼓刹、手刹）基本款荧光红/灰黑9980元,（鼓刹、手刹）基本款白色/黑色9980元,（鼓刹、手刹）基本款黑灰9980元,（鼓刹、手刹）基本款黄黑9980元,（鼓刹、手刹）基本款灰黑9980元,【碟刹、手刹款】荧光红/灰黑10580元,【碟刹、手刹款】白色/黑色10580元,【碟刹、手刹款】黑灰10580元,【碟刹、手刹款】黄黑10580元,【碟刹、手刹款】灰黑10580元,碟刹、CBS款荧光红/灰黑10980元,碟刹、CBS款白色/黑色10980元,碟刹、CBS款黑灰10980元', null);
INSERT INTO `sp_attribute` VALUES ('3720', '主体-型号', '973', 'only', 'manual', 'CHZX-5W40-4L', null);
INSERT INTO `sp_attribute` VALUES ('3721', '规格-容量', '973', 'only', 'manual', '4升', null);
INSERT INTO `sp_attribute` VALUES ('3722', '粘度', '973', 'many', 'list', '嘉护专享10W-40,极护 0W-40,极护 5W-30,极护 5W-40,极护专享5W-40,极护宝马专享5W-30,磁护 5W-40,磁护专享,路虎专享 5W-30,金嘉护10W-40,金嘉护5W-30,1L,4L', null);
INSERT INTO `sp_attribute` VALUES ('3723', '主体-品牌', '974', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3724', '功能参数-功能', '974', 'only', 'manual', '清洁保护,动力提升,节油', null);
INSERT INTO `sp_attribute` VALUES ('3725', '规格-容量', '974', 'only', 'manual', '80毫升', null);
INSERT INTO `sp_attribute` VALUES ('3726', '规格', '974', 'many', 'list', '500ml,5X高效版218ml,铂金尊享装80ml*10', null);
INSERT INTO `sp_attribute` VALUES ('3727', '主体-类别', '976', 'only', 'manual', '加油卡', null);
INSERT INTO `sp_attribute` VALUES ('3728', '地区', '976', 'many', 'list', '全国', null);
INSERT INTO `sp_attribute` VALUES ('3729', '主体-品牌', '978', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3730', '规格-产品尺寸（长*宽*高', '978', 'only', 'manual', '44*15*12', null);
INSERT INTO `sp_attribute` VALUES ('3731', '颜色', '978', 'many', 'list', 'E02-带充气泵-香槟金,E02-带充气泵-炫酷黑,E02-带充气泵-黑色家车两用,E02-带充气泵-金色家车两用,E02-数显带充气泵-黑色,E02-数显带充气泵-香槟金,E05-带充气泵-银色无线款,E09-带充气泵-黑色无线款', null);
INSERT INTO `sp_attribute` VALUES ('3732', '主体-品牌', '979', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3733', '规格-额定容量', '979', 'only', 'manual', '60', null);
INSERT INTO `sp_attribute` VALUES ('3734', '主体-品牌', '980', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3735', '规格-产品尺寸（长*宽*高', '980', 'only', 'manual', '30', null);
INSERT INTO `sp_attribute` VALUES ('3736', '尺码', '980', 'many', 'list', '18寸,24寸,14寸,19寸,16寸,22寸,20寸,17寸,21寸,26寸,28寸', null);
INSERT INTO `sp_attribute` VALUES ('3737', '主体-品牌', '981', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3738', '规格-重量', '981', 'only', 'manual', '1克', null);
INSERT INTO `sp_attribute` VALUES ('3739', '主体-品牌', '982', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3740', '规格-产品尺寸（长*宽*高', '982', 'only', 'manual', '150*100*60mm', null);
INSERT INTO `sp_attribute` VALUES ('3741', '主体-品牌', '983', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3742', '规格-轮胎规格', '983', 'only', 'manual', '205/55R16', null);
INSERT INTO `sp_attribute` VALUES ('3743', '主体-品牌', '985', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3744', '规格-产品尺寸（长*宽*高', '985', 'only', 'manual', '看描述', null);
INSERT INTO `sp_attribute` VALUES ('3745', '主体-品牌', '986', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3746', '功能参数-显示类型', '986', 'only', 'manual', '双显', null);
INSERT INTO `sp_attribute` VALUES ('3747', '规格-产品尺寸（长*宽*高', '986', 'only', 'manual', '57*61*27', null);
INSERT INTO `sp_attribute` VALUES ('3748', '款式', '986', 'many', 'list', '外置款,内置款', null);
INSERT INTO `sp_attribute` VALUES ('3749', '主体-品牌', '987', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3750', '规格-重量', '987', 'only', 'manual', '0.3克', null);
INSERT INTO `sp_attribute` VALUES ('3751', '款式', '987', 'many', 'list', '磁性支架-土豪金,磁性支架-气质银,多功能手机支架', null);
INSERT INTO `sp_attribute` VALUES ('3752', '主体-品牌', '988', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3753', '规格-容量', '988', 'only', 'manual', '0升', null);
INSERT INTO `sp_attribute` VALUES ('3754', '主体-型号', '989', 'only', 'manual', '-30℃-2L/1瓶', null);
INSERT INTO `sp_attribute` VALUES ('3755', '功能参数-功能', '989', 'only', 'manual', '玻璃清洗', null);
INSERT INTO `sp_attribute` VALUES ('3756', '规格-容量', '989', 'only', 'manual', '2L', null);
INSERT INTO `sp_attribute` VALUES ('3757', '规格', '989', 'many', 'list', '-2℃/1.5L/1瓶,-2℃/1.5L/2瓶,-2℃/1.5L/6瓶,-2℃/1.5L/12瓶,-2℃/2L/1瓶,-2℃/2L/2瓶,-2℃/2L/4瓶,-2℃/2L/8瓶,-30℃/1.5L/1瓶,-30℃/1.5L/2瓶,-30℃/1.5L/6瓶,-30℃/1.5L/12瓶,-30℃/2L/1瓶,-30℃/2L/2瓶,-30℃/2L/4瓶,-30℃/2L/8瓶,-40℃/2L/1瓶,-40℃/2L/2瓶,-40℃/2L/4瓶,-40℃/2L/8瓶', null);
INSERT INTO `sp_attribute` VALUES ('3758', '主体-品牌', '990', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3759', '规格-容量', '990', 'only', 'manual', '1', null);
INSERT INTO `sp_attribute` VALUES ('3760', '补漆笔套装等', '990', 'many', 'list', '单支补漆笔+砂纸,简易套装,标准套装,完美套装', null);
INSERT INTO `sp_attribute` VALUES ('3761', '主体-品牌', '991', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3762', '规格-容量', '991', 'only', 'manual', '200g', null);
INSERT INTO `sp_attribute` VALUES ('3763', '主体-品牌', '992', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3764', '功能参数-功能', '992', 'only', 'manual', '清洁', null);
INSERT INTO `sp_attribute` VALUES ('3765', '规格-容量', '992', 'only', 'manual', '120毫升', null);
INSERT INTO `sp_attribute` VALUES ('3766', '主体-型号', '993', 'only', 'manual', '汽车掸子', null);
INSERT INTO `sp_attribute` VALUES ('3767', '规格-重量', '993', 'only', 'manual', '420克', null);
INSERT INTO `sp_attribute` VALUES ('3768', '主体-品牌', '994', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3769', '功能参数-停车监测', '994', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('3770', '规格-电池', '994', 'only', 'manual', '有', null);
INSERT INTO `sp_attribute` VALUES ('3771', '型号', '994', 'many', 'list', '一代升级版,一代尊享版,二代美猴王白,二代美猴王黑,二代领航版,双镜头后视镜,胎压,含32G卡+车充,含16G卡+车充,含32G卡+车充,含64G卡+车充,含车充,胎压监测器', null);
INSERT INTO `sp_attribute` VALUES ('3772', '主体-品牌', '995', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3773', '功能参数-测速类型', '995', 'only', 'manual', '流动测速', null);
INSERT INTO `sp_attribute` VALUES ('3774', '规格-重量', '995', 'only', 'manual', '1克', null);
INSERT INTO `sp_attribute` VALUES ('3775', '规格', '995', 'many', 'list', 'L300,L800,L70,LD20,LD30,LD70,LD80,L5,H200(云在线升级）,H300(云在线升级）,H500', null);
INSERT INTO `sp_attribute` VALUES ('3776', '主体-品牌', '996', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3777', '功能参数-制冷类型', '996', 'only', 'manual', '冷暖冰箱', null);
INSERT INTO `sp_attribute` VALUES ('3778', '规格-容量', '996', 'only', 'manual', '7.5升', null);
INSERT INTO `sp_attribute` VALUES ('3779', '规格', '996', 'many', 'list', '7.5L升级版,4L车家两用,20L车家两用,家用转换器,8L保温箱', null);
INSERT INTO `sp_attribute` VALUES ('3780', '主体-品牌', '997', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3781', '规格-输入电压', '997', 'only', 'manual', '12', null);
INSERT INTO `sp_attribute` VALUES ('3782', '规格', '997', 'many', 'list', '双USB电压监测-金色,双USB电压监测-灰色,金色套装-车充+支架+线,金属款双USB电压监测-银色', null);
INSERT INTO `sp_attribute` VALUES ('3783', '主体-品牌', '998', 'only', 'manual', '', null);
INSERT INTO `sp_attribute` VALUES ('3784', '功能参数-附加功能', '998', 'only', 'manual', '除臭功能,杀菌功能,滤尘功能,芳香功能', null);
INSERT INTO `sp_attribute` VALUES ('3785', '规格-产品尺寸（长*宽*高', '998', 'only', 'manual', '17*12.5*3.8', null);
INSERT INTO `sp_attribute` VALUES ('3786', '颜色', '998', 'many', 'list', '红色,白色,土豪金', null);
INSERT INTO `sp_attribute` VALUES ('3787', '主体参数-个护健康类型', '99', 'only', 'manual', '电子美容仪', null);
INSERT INTO `sp_attribute` VALUES ('3788', '功能参数-产品功能', '99', 'only', 'manual', '微电波', null);
INSERT INTO `sp_attribute` VALUES ('3789', '适用范围-适用人群', '99', 'only', 'manual', '男士,女士', null);
INSERT INTO `sp_attribute` VALUES ('3790', '电源-自动断电', '99', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('3791', '规格参数-净重', '99', 'only', 'manual', '0.19千克', null);
INSERT INTO `sp_attribute` VALUES ('3792', '型号', '99', 'many', 'list', '3D刮痧款,V脸神器典雅黑,V脸神器纯净白,两轮升级款,减压球激光白,减压球磨砂黑,双柄珍珠黑,双柄钻石白,四轮升级款,头部按摩款,指揉眼部加强款,温唇保湿仪,球面祛纹款,男士加强款,空压眼部按摩仪,经典两轮款,身体专用款,钻石瘦脸款', null);
INSERT INTO `sp_attribute` VALUES ('3793', '主体参数-商品名称', '9', 'only', 'manual', '创维电视55M5E', null);
INSERT INTO `sp_attribute` VALUES ('3794', '基本参数-电视3D功能', '9', 'only', 'manual', '不支持', null);
INSERT INTO `sp_attribute` VALUES ('3795', '显示参数-亮度', '9', 'only', 'manual', '//cd/m2', null);
INSERT INTO `sp_attribute` VALUES ('3796', '音频参数-扬声器数量', '9', 'only', 'manual', '2个', null);
INSERT INTO `sp_attribute` VALUES ('3797', 'USB音视图参数-USB支持视频格式', '9', 'only', 'manual', 'RM/RMVB等', null);
INSERT INTO `sp_attribute` VALUES ('3798', '端口参数-接口类型', '9', 'only', 'manual', '有线电视x1,AV输出x1,AV输入x1,HDMI1.4x2,USB2.0x2,网络接口x1', null);
INSERT INTO `sp_attribute` VALUES ('3799', '特性参数-网络连接', '9', 'only', 'manual', '支持', null);
INSERT INTO `sp_attribute` VALUES ('3800', '功耗参数-电源电压', '9', 'only', 'manual', '220V', null);
INSERT INTO `sp_attribute` VALUES ('3801', '规格参数-外形尺寸(含底座)', '9', 'only', 'manual', '1241*265*769毫米', null);
INSERT INTO `sp_attribute` VALUES ('3802', '智能应用-智能电视', '9', 'only', 'manual', '智能电视', null);
INSERT INTO `sp_attribute` VALUES ('3803', '颜色1', '6', 'many', 'list', '', '1640683568');
INSERT INTO `sp_attribute` VALUES ('3804', 'ccc', '6', 'only', 'manual', '', '1640683692');
INSERT INTO `sp_attribute` VALUES ('3805', '颜色', '6', 'many', 'list', '黑色', null);

-- ----------------------------
-- Table structure for sp_category
-- ----------------------------
DROP TABLE IF EXISTS `sp_category`;
CREATE TABLE `sp_category` (
  `cat_id` int NOT NULL AUTO_INCREMENT COMMENT '分类唯一ID',
  `cat_name` varchar(255) DEFAULT NULL COMMENT '分类名称',
  `cat_pid` int DEFAULT NULL COMMENT '分类父ID',
  `cat_level` int DEFAULT NULL COMMENT '分类层级 0: 顶级 1:二级 2:三级',
  `cat_deleted` int DEFAULT '0' COMMENT '是否删除 1为删除',
  `cat_icon` varchar(255) DEFAULT NULL,
  `cat_src` text,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1506 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sp_category
-- ----------------------------
INSERT INTO `sp_category` VALUES ('1', '大家电', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('3', '电视', '1', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('4', '空调', '1', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('5', '4K超高清', '1482', '2', '0', 'full/fd99414907afb2e0382456b55ae051e51f9816f5.jpg', '/list/243505-1344991.html');
INSERT INTO `sp_category` VALUES ('6', '曲面电视', '3', '2', '0', 'full/2fb113b32f7a2b161f5ee4096c319afedc3fd5a1.jpg', '/list/243505-914942.html');
INSERT INTO `sp_category` VALUES ('7', '海信', '3', '2', '0', 'full/5e38cf9e6e7c46a17fe1c597a883ae627977b296.jpg', '/list/243505-10005.html');
INSERT INTO `sp_category` VALUES ('8', '夏普', '3', '2', '0', 'full/cece39bd7e9654c20043e4af71696e1f838d4a22.jpg', '/list/243505-10070.html');
INSERT INTO `sp_category` VALUES ('9', '创维', '3', '2', '0', 'full/f62eba98423af3311487f3331c6798d8f099c893.jpg', '/list/243505-11164.html');
INSERT INTO `sp_category` VALUES ('10', 'TCL', '3', '2', '0', 'full/86832cc37db8474ac07853c835009f9873eaec89.jpg', '/list/243505-10415.html');
INSERT INTO `sp_category` VALUES ('11', 'PPTV', '3', '2', '0', 'full/41c169f14680b3ebf88b4a37ea09085ed731c985.jpg', '/list/243505-14501.html');
INSERT INTO `sp_category` VALUES ('12', '小米', '3', '2', '0', 'full/5c282c3ec283fbc092107f8c7b86f212365acdfa.jpg', '/list/243505-12121.html');
INSERT INTO `sp_category` VALUES ('13', '长虹', '3', '2', '0', 'full/14291787e1f9f0215816048e813e4ec4fbb3dffe.jpg', '/list/243505-10075.html');
INSERT INTO `sp_category` VALUES ('14', '康佳', '3', '2', '0', 'full/de58455691bc7b85351055c220f1a5410ab15693.jpg', '/list/243505-10149.html');
INSERT INTO `sp_category` VALUES ('15', '三星', '3', '2', '0', 'full/8b36730c09815e90de1f86664baef8690c89e979.jpg', '/list/243505-10011.html');
INSERT INTO `sp_category` VALUES ('16', '飞利浦', '3', '2', '0', 'full/7643c31541df41da21c9e734bd2d9a18fed2a2aa.jpg', '/list/243505-1253445.html');
INSERT INTO `sp_category` VALUES ('17', '索尼', '3', '2', '0', 'full/e8c76dd2bb103a620929bcb4ad5c5431d62418d3.jpg', '/list/243505-10028.html');
INSERT INTO `sp_category` VALUES ('18', '先锋', '3', '2', '0', 'full/5a46bef92bf32f0157b4d5a6d9a35ca8a5615aca.jpg', '/list/243505-10328.html');
INSERT INTO `sp_category` VALUES ('19', '家庭影院', '3', '2', '0', 'full/5fae60f2cc05c53eaf43075db7eb82bfc9bba9b4.jpg', '/list/244010-0.html');
INSERT INTO `sp_category` VALUES ('20', '音响', '3', '2', '0', 'full/5515d491f88587084e59aac50010458bb916ee17.jpg', '/list/244011-0.html');
INSERT INTO `sp_category` VALUES ('21', '盒子', '3', '2', '0', 'full/e65bab9fcb64c336a3f5fba3b2174fef41f12330.jpg', '//m.suning.com/search/%E7%9B%92%E5%AD%90/?adTypeCode=1023&adId=%E7%9B%92%E5%AD%90');
INSERT INTO `sp_category` VALUES ('22', '家用空调', '1482', '2', '0', 'full/8ba61feee8f4a8333efee8ed00ce3f327e66367c.jpg', '/list/431505-0.html');
INSERT INTO `sp_category` VALUES ('23', '变频空调', '4', '2', '0', 'full/994977fac8f4fa6cea5eb413cd64ddac24a97600.jpg', '/list/431505-125483.html');
INSERT INTO `sp_category` VALUES ('24', '立柜空调', '4', '2', '0', 'full/19fc040b41b4c821c16748529545265f5feb34fa.jpg', '/list/431505-262043.html');
INSERT INTO `sp_category` VALUES ('25', '挂壁空调', '4', '2', '0', 'full/7f3dfec1efdb2559d7fba1ea39d901f4763fae21.jpg', '/list/431505-615804.html');
INSERT INTO `sp_category` VALUES ('26', '洗衣机', '1', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('27', '中央空调', '4', '2', '0', 'full/47a417ea3c71e5b88a261729e43706611da4ae7e.jpg', '/list/431506-0.html');
INSERT INTO `sp_category` VALUES ('28', '移动空调', '4', '2', '0', 'full/b9f06f11815deebf5417636cf6967d859956e8bf.jpg', '/list/431507-0.html');
INSERT INTO `sp_category` VALUES ('29', '海尔', '4', '2', '0', 'full/528517c1f5c49a15f4558be03f46e27f23d379ba.jpg', '/list/431505-10010.html');
INSERT INTO `sp_category` VALUES ('30', '三菱重工', '4', '2', '0', 'full/3ae5b4e47f663b3889edc694c95bf098b7893316.jpg', '/list/431505-10174.html');
INSERT INTO `sp_category` VALUES ('31', '志高', '4', '2', '0', 'full/4d5fd81e6e2e45a9a55d187c2326dea57ef90f9d.jpg', '/list/431505-10181.html');
INSERT INTO `sp_category` VALUES ('32', '奥克斯', '4', '2', '0', 'full/9ec815cf683ef384f74c0b1c6011891da20589f9.jpg', '/list/431504-10132.html');
INSERT INTO `sp_category` VALUES ('33', '长虹', '4', '2', '0', 'full/74547903a7193d252f4a1643849cc707981affa2.jpg', '/list/431504-10075.html');
INSERT INTO `sp_category` VALUES ('34', '科龙', '4', '2', '0', 'full/85ac1aecafb4f25158d2e08d213e6f617307a323.jpg', '/list/431504-10278.html');
INSERT INTO `sp_category` VALUES ('35', '海信', '4', '2', '0', 'full/2079cb1725672419834c3624d52b6abaea8be308.jpg', '/list/431505-10005.html');
INSERT INTO `sp_category` VALUES ('36', '惠而浦', '4', '2', '0', 'full/33774cdd0a4b866bc3f56c0fc55a0063d1f15892.jpg', '/list/431504-10034.html');
INSERT INTO `sp_category` VALUES ('37', '空调清洗', '4', '2', '0', 'full/f4836d9ba4831e4d81ab275cff4ab50677076a2b.jpg', '/list/500723-0.html');
INSERT INTO `sp_category` VALUES ('38', '空调维修', '4', '2', '0', 'full/19ed844b023720a49792de3c1397e614c9bb260b.jpg', '//assss.suning.com/assss-web/wap/afterService/toServBookingOrders_0.do');
INSERT INTO `sp_category` VALUES ('39', '空调安装', '4', '2', '0', 'full/f216557789c6d87ac6b31845e0a8c47186d6521a.jpg', '//c.m.suning.com/anzhuangfw.html');
INSERT INTO `sp_category` VALUES ('40', '空调回收', '4', '2', '0', 'full/da07de0ac2f01b18a9ec206fd44a51cf117cf987.jpg', '//hx.m.suning.com/wap/home.htm');
INSERT INTO `sp_category` VALUES ('41', '洗干一体机', '1482', '2', '0', 'full/a83bfb2ac4b291f04b07274de9bf1e6f49e14027.jpg', '/list/244006-782345.html');
INSERT INTO `sp_category` VALUES ('42', '洗衣机', '26', '2', '0', 'full/d33bc76faf761d86692f6b79dbd5bdb007a6c060.jpg', '/list/244006-0.html');
INSERT INTO `sp_category` VALUES ('43', '滚筒洗衣机', '26', '2', '0', 'full/4f083927b8062beb2e2a8e5fbcb956e07231e644.jpg', '/list/244006-782291.html');
INSERT INTO `sp_category` VALUES ('44', '波轮洗衣机', '26', '2', '0', 'full/2333a004401004514d43fc56bf3a08de3d6dee44.jpg', '/list/244006-782289.html');
INSERT INTO `sp_category` VALUES ('45', '冰箱', '1', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('46', '大容量洗衣机', '26', '2', '0', 'full/e2459762678fe83b75b10dab705d9be2570d014c.jpg', '/list/244006-1199982.html');
INSERT INTO `sp_category` VALUES ('47', '迷你洗衣机', '26', '2', '0', 'full/1fa57f855d15370a93c16c12b856fae164458c5b.jpg', '/list/244006-782346.html');
INSERT INTO `sp_category` VALUES ('48', '双缸洗衣机', '26', '2', '0', 'full/d8549a361e957132f07d7a9ebcee9bcf9adc12a1.jpg', '/list/244006-782287.html');
INSERT INTO `sp_category` VALUES ('49', '干衣机', '26', '2', '0', 'full/259207618f9cb1fda1fcb8f4ce16280bde8959de.jpg', '/list/244006-782362.html');
INSERT INTO `sp_category` VALUES ('50', '洗衣机服务', '26', '2', '0', 'full/ac69da199d085a7c59360686310697565ef8083e.jpg', 'https://cuxiao.m.suning.com/xiyijifuwu.html');
INSERT INTO `sp_category` VALUES ('51', '西门子', '26', '2', '0', 'full/b7c7741303e60a58bbc5ea6ad6679cd0c7f08ce7.jpg', '/list/244006-10002.html');
INSERT INTO `sp_category` VALUES ('52', '热门推荐', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('53', '海尔', '26', '2', '0', 'full/d2a002e5912a0cf8e74352a9ea38e17e165ccc8d.jpg', '/list/244006-10010.html');
INSERT INTO `sp_category` VALUES ('54', '小天鹅', '26', '2', '0', 'full/3732a28271acaadbdedefb7445efae3aac1c3c81.jpg', '/list/244006-10001.html');
INSERT INTO `sp_category` VALUES ('55', '冰箱', '1482', '2', '0', 'full/5086527c207d479c04a851bf0aeb24580c7f7d7a.jpg', '/list/244005-0.html');
INSERT INTO `sp_category` VALUES ('56', '对开门冰箱', '45', '2', '0', 'full/4b6bfa1646ca0beeb0acda07f77149bc1e3e7185.jpg', '/list/244005-782324.html');
INSERT INTO `sp_category` VALUES ('58', '多门冰箱', '45', '2', '0', 'full/51a4c3435e9445093fc172b65309089e6f8b2262.jpg', '/list/244005-782301.html');
INSERT INTO `sp_category` VALUES ('59', '三门冰箱', '45', '2', '0', 'full/9b4ef20a87083e32b189c49417c55d1e6d297c9a.jpg', '/list/244005-782288.html');
INSERT INTO `sp_category` VALUES ('60', '十字对开门', '45', '2', '0', 'full/941952a7134b6b1e342f25e774f2d926ce35f6a5.jpg', '/list/244005-782301.html');
INSERT INTO `sp_category` VALUES ('61', '双门冰箱', '45', '2', '0', 'full/ba282e17cf2bbbdac501aefc5be6fbd180bcd62c.jpg', '/list/244005-782304.html');
INSERT INTO `sp_category` VALUES ('62', '冷柜/冰吧', '45', '2', '0', 'full/30cc729fd6ec23960ef02786d7f9ed3e6527a349.jpg', '/list/244008-0.html');
INSERT INTO `sp_category` VALUES ('63', '商用冷柜', '45', '2', '0', 'full/53f4290298db81aed79bd8b4cc97c019da49eb1b.jpg', '/list/244008-1206638.html');
INSERT INTO `sp_category` VALUES ('64', '圣诞狂欢', '52', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('65', '海尔', '45', '2', '0', 'full/d2a002e5912a0cf8e74352a9ea38e17e165ccc8d.jpg', '/list/244005-10010.html');
INSERT INTO `sp_category` VALUES ('66', '西门子', '45', '2', '0', 'full/b7c7741303e60a58bbc5ea6ad6679cd0c7f08ce7.jpg', '/list/244005-10002.html');
INSERT INTO `sp_category` VALUES ('67', '容声', '45', '2', '0', 'full/722b97ed263f975f3dc25e8ac94084c79cd44962.jpg', '/list/244005-40441.html');
INSERT INTO `sp_category` VALUES ('68', '美菱', '45', '2', '1', 'full/e55f3b4c84ebe797397537e2d92e4fd31482d398.jpg', '/list/244005-10008.html');
INSERT INTO `sp_category` VALUES ('69', '黄金', '1482', '2', '0', 'full/b7b4cb7dc25bc7a6ea79c9c31c6c71c91869739e.jpg', '//m.suning.com/search/黄金/?adTypeCode=1023&adId=黄金');
INSERT INTO `sp_category` VALUES ('70', '海外购', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('72', '口红', '1482', '2', '0', 'full/54af1b428dab75fbb19e0f0602db2fb288ae77b9.jpg', 'https://m.suning.com/search/%E5%8F%A3%E7%BA%A2/&ch=hwg');
INSERT INTO `sp_category` VALUES ('73', '护肤套装', '64', '2', '0', 'full/37e2413fad20445374180542fce4d06d0cb38545.jpg', '/list/330021-0.html');
INSERT INTO `sp_category` VALUES ('74', '面膜', '64', '2', '0', 'full/7ca57e495705e7b60ac5cfc3f5c4d71d12341d72.jpg', '/list/362506-0.html');
INSERT INTO `sp_category` VALUES ('75', '国际名牌', '70', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('76', '巧克力', '64', '2', '0', 'full/8d73f842d376174d88137fbe350bf59ac767477b.jpg', '/list/500506-0.html');
INSERT INTO `sp_category` VALUES ('77', '儿童玩具', '64', '2', '0', 'full/9eec1c64ccbdd837606184ed00c2a611e5a0a2c2.jpg', 'https://m.suning.com/list/313118-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('78', '童装童鞋', '64', '2', '0', 'full/75fece9ce4698857628e2c42a0e752a26a50fb18.jpg', 'https://m.suning.com/list/315053-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('79', '平板电脑', '64', '2', '0', 'full/d2a821ebd29bad4bf687dc84cc6e092a1792c66f.jpg', '/list/258006-0.html');
INSERT INTO `sp_category` VALUES ('80', '笔记本', '64', '2', '0', 'full/fd85e32427cfb12e312e4a1022898b3aa3321822.jpg', '/list/258004-0.html');
INSERT INTO `sp_category` VALUES ('81', '苹果手机', '64', '2', '0', 'full/b4033ffe4dca02026431fe654aa929304defbc2e.jpg', '/list/20006-10103.html');
INSERT INTO `sp_category` VALUES ('82', '小米手机', '64', '2', '0', 'full/b0fef388cd035694eac75d7b53e4a1eebf041cf3.jpg', '/list/20006-12121.html');
INSERT INTO `sp_category` VALUES ('83', '数码相机', '64', '2', '0', 'full/8bd047f8eed61c47305dff3373890a7ef33e785f.jpg', '/list/20063-0.html');
INSERT INTO `sp_category` VALUES ('84', '耳机耳麦', '64', '2', '0', 'full/cec82af42e24d626d82017f1698a3497038e9ebf.jpg', '/list/232003-0.html');
INSERT INTO `sp_category` VALUES ('85', '挂机空调', '64', '2', '0', 'full/4b6f5f2964874da6851c1d96bcefaf3840c96d01.jpg', '/list/431505-615804.html');
INSERT INTO `sp_category` VALUES ('86', '空气净化器', '64', '2', '0', 'full/c28dbf9b72eeaf7150c5a2bade7dc35873db6e8e.jpg', '/list/20394-0.html');
INSERT INTO `sp_category` VALUES ('87', '洗衣机', '64', '2', '0', 'full/5027b6e3f593d4625001644b419a24fffeb68191.jpg', '/list/244006-0.html');
INSERT INTO `sp_category` VALUES ('88', '4K超高清', '64', '2', '0', 'full/fd99414907afb2e0382456b55ae051e51f9816f5.jpg', '/list/243505-1344991.html');
INSERT INTO `sp_category` VALUES ('89', '洗碗机', '64', '2', '0', 'full/23001b342737d8952e135bdaf2eaa0a8a71c2fd5.jpg', '/list/337506-0.html');
INSERT INTO `sp_category` VALUES ('90', '兰蔻', '1482', '2', '0', 'full/08c847b2c60a43552cae9a49440f827e9025ea4b.jpg', '//m.suning.com/list/330004-42131.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('91', '雅诗兰黛', '1482', '2', '0', 'full/dc4188ed1d69bd4f6f285423cb675d6ac261b5de.jpg', '//m.suning.com/list/330004-42133.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('92', 'swisse', '75', '2', '0', 'full/b16f183fd75dc9ef23040bf1ecb79986961687bc.jpg', 'https://m.suning.com/list/501108-258563.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('93', '母婴儿童', '70', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('94', '巴黎水', '75', '2', '0', 'full/cd62542f233606dba918579a8de11e042501eefb.jpg', 'https://m.suning.com/list/500475-13427.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('95', '爱他美', '75', '2', '0', 'full/bf88a25a9bf591d91a5a1aab2ddaa3bfd7a43e34.jpg', 'https://m.suning.com/list/313004-21541.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('96', '美妆', '70', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('97', '花王', '75', '2', '0', 'full/fa40f059bba735204287f296bd005511084a7c67.jpg', 'https://m.suning.com/list/313107-216549.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('98', '戴森', '75', '2', '0', 'full/40c36744b446ee350cd651a2e07c12f0f44af246.jpg', 'https://m.suning.com/list/20366-46081.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('99', 'ReFa', '75', '2', '0', 'full/2fa6a29fb7fc3b861184d3c9b7203fb6825e708b.jpg', 'https://m.suning.com/search/refa/&ch=hwg');
INSERT INTO `sp_category` VALUES ('100', 'MK', '75', '2', '0', 'full/0b4c9e1a708f24902e018da4bd1d88f24a94e2da.jpg', 'https://m.suning.com/list/344250-131923.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('101', '奶粉', '1482', '2', '0', 'full/5b859d271355da33156ae7eb25edaec8a76db120.jpg', 'https://m.suning.com/list/313004-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('102', '纸尿裤', '93', '2', '0', 'full/35e3e3c3bcd957a3392f9a2ef029da2007f523ca.jpg', 'https://m.suning.com/list/313106-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('103', '营养辅食', '93', '2', '0', 'full/492847b81ffce8ed38691555538a7858f9cd7815.jpg', 'https://m.suning.com/list/313013-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('104', '婴儿用品', '93', '2', '0', 'full/2cc770dbd3677f1423b9ebcee2aae936b5d8847d.jpg', 'https://m.suning.com/list/313037-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('105', '婴儿洗护', '93', '2', '0', 'full/90b975b5f6d5110c3a8dc67ca4bfdba6de5441ea.jpg', 'https://m.suning.com/list/313087-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('106', '童车童床', '93', '2', '0', 'full/0d33fddf2010a8c0114855012c7f61fb01a50940.jpg', 'https://m.suning.com/list/315111-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('107', '儿童玩具', '93', '2', '0', 'full/9eec1c64ccbdd837606184ed00c2a611e5a0a2c2.jpg', 'https://m.suning.com/list/313118-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('108', '童装童鞋', '93', '2', '0', 'full/75fece9ce4698857628e2c42a0e752a26a50fb18.jpg', 'https://m.suning.com/list/315053-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('109', '面部护理', '1482', '2', '0', 'full/920914b097bee73e59454cc13b7941b4a64e6fc9.jpg', 'https://m.suning.com/list/330004-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('110', '面膜', '96', '2', '0', 'full/2579da906e61146322293d2aa5f4a9facbdc2495.jpg', 'https://m.suning.com/search/%E9%9D%A2%E8%86%9C/&ch=hwg');
INSERT INTO `sp_category` VALUES ('111', '口红', '96', '2', '0', 'full/54af1b428dab75fbb19e0f0602db2fb288ae77b9.jpg', 'https://m.suning.com/search/%E5%8F%A3%E7%BA%A2/&ch=hwg');
INSERT INTO `sp_category` VALUES ('112', '彩妆', '96', '2', '0', 'full/231f73f37ce5ca9036d1e9d4168efb4523070875.jpg', 'https://m.suning.com/list/315579-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('113', '个护', '70', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('114', '护肤套装', '96', '2', '0', 'full/d2e1fd5c05c143214cd3a235a85b785e464644a1.jpg', 'https://m.suning.com/list/330021-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('115', '营养保健', '70', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('116', '香水香氛', '96', '2', '0', 'full/cf8ef95a8a4de25738e9b319a147927ef3472796.jpg', 'https://m.suning.com/list/315581-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('117', '洁面仪', '96', '2', '0', 'full/2ef285fb3ffbffe1351a074be69a8e4c29837184.jpg', 'https://m.suning.com/search/%E6%B4%81%E9%9D%A2%E4%BB%AA/&ch=hwg');
INSERT INTO `sp_category` VALUES ('118', '卸妆', '96', '2', '0', 'full/e9c82968002a79e1c4aae6d842029d4c01819950.jpg', 'https://m.suning.com/list/329504-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('119', '身体沐浴', '1482', '2', '0', 'full/157266744c5b0f194fda113c49e7f0d0a85d0117.jpg', 'https://m.suning.com/list/315588-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('120', '美发护发', '113', '2', '0', 'full/2611fb97c4a328f9034a464bcb027ebecadf78b9.jpg', 'https://m.suning.com/list/316546-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('121', '美甲', '113', '2', '0', 'full/9e4839859a99de33020b11892c6273b306dce065.jpg', 'https://m.suning.com/search/%E7%BE%8E%E7%94%B2/&ch=hwg');
INSERT INTO `sp_category` VALUES ('122', '口腔护理', '113', '2', '0', 'full/873b02dcbcb3c45b03cb64a5a442227f7d9f1a1b.jpg', 'https://m.suning.com/list/316549-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('123', '女性护理', '113', '2', '0', 'full/b57ef9462836fc252fa021e98a612d31c50d94d1.jpg', 'https://m.suning.com/list/315589-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('124', '膳食补充剂', '1482', '2', '0', 'full/55f39b9c9ec4ea31a22957e953b775d1a838f26f.jpg', 'https://m.suning.com/list/501108-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('125', '提高免疫', '115', '2', '0', 'full/b263c6b2a8c5bcb2ce1520dae869b1c813ef51e9.jpg', 'https://m.suning.com/list/501103-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('126', '维生素/矿物质', '115', '2', '0', 'full/6a6af5285b99e6b888f5cd964c9f49b417120e95.jpg', 'https://m.suning.com/list/501107-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('127', '美容养颜', '115', '2', '0', 'full/3e7f67dc1f56174b5a4c1c201e9520d5d9492d6d.jpg', 'https://m.suning.com/list/501105-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('128', '食品', '70', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('129', '调节三高', '115', '2', '0', 'full/c2eb768b6b45ba7787ce03b497561e5a0e7b086f.jpg', 'https://m.suning.com/list/501106-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('130', '减肥瘦身', '115', '2', '0', 'full/0c374f272ac0cccf404bdd32844042b2b428a965.jpg', 'https://m.suning.com/list/501102-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('131', '胶原蛋白', '115', '2', '0', 'full/0fc2579681f7fa832f7be0037501122e3f7580e1.jpg', 'https://m.suning.com/list/502285-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('132', '补肾强身', '115', '2', '0', 'full/9605017e4a15c9109e73f9108d69f616515c87b8.jpg', 'https://m.suning.com/list/501104-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('133', '数码家电', '70', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('134', '养生茶饮', '115', '2', '0', 'full/0ad5d56114db00681065db0de9fcc42df57a2ed5.jpg', 'https://m.suning.com/list/502286-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('135', '休闲食品', '1482', '2', '0', 'full/f52648005f660384a898a516b75f9657ec03a36b.jpg', 'https://m.suning.com/list/500360-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('136', '牛奶乳品', '128', '2', '0', 'full/0aedbfb18977ce0e96ed58c4994c9782699f5b5e.jpg', 'https://m.suning.com/list/500356-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('137', '方便速食', '128', '2', '0', 'full/54d4960d119f9487d5721bd26b40281d4d20f972.jpg', 'https://m.suning.com/list/500359-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('138', '进口酒水', '128', '2', '0', 'full/39f741fd5865e1916c78e8217bbd26fe7f448b4f.jpg', 'https://m.suning.com/list/500355-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('139', '进口粮油', '128', '2', '0', 'full/458a8785865396601f4ffaa80c2c08aba0eaaa25.jpg', 'https://m.suning.com/list/500357-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('140', '厨房调料', '128', '2', '0', 'full/f7683c852d19e80707aa5ab8ccdcd4fcd6266e16.jpg', 'https://m.suning.com/list/500358-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('141', '手机', '1482', '2', '0', 'full/c4e70d6494b0e55e86830c02e6b0cb1ba4c22c33.jpg', 'https://m.suning.com/list/20002-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('142', '平板电脑', '133', '2', '0', 'full/504c710242f95ade05e91a4ef2a6f5b383a08f38.jpg', 'https://m.suning.com/list/258006-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('143', '笔记本电脑', '133', '2', '0', 'full/da3c18503de16c8e42365e8c395c1797af6f3851.jpg', 'https://m.suning.com/list/258004-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('144', '手机配件', '133', '2', '0', 'full/dc692a9c1dc46a69f7106e16438d926e6ef3f578.jpg', 'https://m.suning.com/list/20016-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('145', '音箱音响', '133', '2', '0', 'full/33712c9d09be722a1442d2d740147ca9482157bd.jpg', 'https://m.suning.com/list/157243-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('146', '摄影摄像', '133', '2', '0', 'full/d641c12b1fa94f95add6a9a57a0c4a03234aeaad.jpg', 'https://m.suning.com/list/20062-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('147', '智能设备', '133', '2', '0', 'full/44582ae863d5ad0bd5a7ea2c1c809d7d7cf0cd96.jpg', 'https://m.suning.com/list/410503-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('148', '剃须刀', '133', '2', '0', 'full/497d8413617f183f168289f61dc57916bc621d59.jpg', 'https://m.suning.com/list/20360-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('149', '吸尘器', '133', '2', '0', 'full/94c6c58577f346587e2ec3885a2c1c2dcb717078.jpg', 'https://m.suning.com/list/20390-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('150', '电饭煲', '133', '2', '0', 'full/d156c668fb76e75b32872d14f3c7b151679bc377.jpg', 'https://m.suning.com/list/20329-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('151', '服饰箱包', '70', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('152', '电吹风', '133', '2', '0', 'full/b0067c1505383e3d254a66dbf664eea8e0e26f0d.jpg', 'https://m.suning.com/list/20362-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('153', '咖啡机', '133', '2', '0', 'full/02dcd16ca42d372d1c3715b390261e8ec9800a9f.jpg', 'https://m.suning.com/list/20339-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('154', '空气净化器', '133', '2', '0', 'full/efb8cd9f0d9c31b0e54c165ed88ca60ac3c769b7.jpg', 'https://m.suning.com/list/20394-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('155', '美容仪', '133', '2', '0', 'full/6fe8aba50b3a9320c4233acdaba77279ab250932.jpg', 'https://m.suning.com/list/337510-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('156', '电动牙刷', '133', '2', '0', 'full/0f3933dfe9f6e83d6aca5cfd186a135b4889c2dc.jpg', 'https://m.suning.com/list/20363-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('157', '家居日用', '70', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('158', '经典男包', '1482', '2', '0', 'full/d7e772c391cccfb868a5a07406545dfe42ce8413.jpg', 'https://m.suning.com/list/344248-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('159', '潮流女包', '151', '2', '0', 'full/d1ac34b87e2de6c665026b9375b251efcf7d7bb4.jpg', 'https://m.suning.com/list/344250-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('160', '钟表眼镜', '151', '2', '0', 'full/ef87924304d6dd40316e1d663e9d603f77710457.jpg', 'https://m.suning.com/list/253003-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('161', '男装', '151', '2', '0', 'full/52cdb6c9843592fc54b8e8737db0fbd2c71a6342.jpg', 'https://m.suning.com/list/161004-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('162', '女装', '151', '2', '0', 'full/76c938e518e39d3ff3fc41d9fac9ca12a92d5b84.jpg', 'https://m.suning.com/list/161007-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('163', '配饰', '151', '2', '0', 'full/e0ecacfba747eaac79bb2d4dac962a9fd9a45910.jpg', 'https://m.suning.com/list/164010-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('164', '男鞋', '151', '2', '0', 'full/d0964328c3b51b78065f4d1c1561dc8a792189ea.jpg', 'https://m.suning.com/list/340548-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('165', '女鞋', '151', '2', '0', 'full/4effec52fbca64a39350ddb71504896476ca6ca8.jpg', 'https://m.suning.com/list/340557-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('166', '运动鞋', '151', '2', '0', 'full/e8cd5db85d571d8fa9c776a2c8688d29925b9f7a.jpg', 'https://m.suning.com/list/420004-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('167', '功能箱包', '151', '2', '0', 'full/acfbb05c611f0d8677037e56934c83a4fc00916d.jpg', 'https://m.suning.com/list/344246-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('168', '珠宝饰品', '151', '2', '0', 'full/1faf9fbdeac723373df33af5a4eb90fe6f57bbb7.jpg', 'https://m.suning.com/list/500193-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('169', '内衣', '151', '2', '0', 'full/604102a51a9502daf437f97c3fcbb1103a141bfb.jpg', 'https://m.suning.com/list/233003-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('170', '办公文具', '1482', '2', '0', 'full/64bdea916402006e19ee617fca880f74a78481cc.jpg', 'https://m.suning.com/list/157133-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('171', '生活日用', '157', '2', '0', 'full/fd30b69ebba3eacf75001358e8a84ae2b925c603.jpg', 'https://m.suning.com/list/161649-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('172', '苏宁房产', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('173', '苏宁房产', '172', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('174', '手机相机', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('175', '餐厨用具', '157', '2', '0', 'full/896dac3175bc4922256740c5df51987e21adf823.jpg', 'https://m.suning.com/list/251027-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('177', '清洁用品', '157', '2', '0', 'full/a1f264d05d7299fd0c94d16501fb719aa790dd13.jpg', 'https://m.suning.com/list/161657-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('178', '大牌推荐', '174', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('179', '安全避孕', '157', '2', '0', 'full/e8f6da81dda8ff550e35742fc033c2f27d66bcdc.jpg', 'https://m.suning.com/list/501101-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('180', '情趣用品', '157', '2', '0', 'full/aeb56b5e816d4de7c36b70ce39b925493ba9a2c3.jpg', 'https://m.suning.com/list/500882-0.html?ch=hwg');
INSERT INTO `sp_category` VALUES ('181', '苏宁置业', '172', '2', '0', 'full/7b76d481a3d2433ee25dd513dff794242e5ac1bf.jpg', 'https://shop.m.suning.com/70082947.html');
INSERT INTO `sp_category` VALUES ('182', '恒大地产', '1482', '2', '0', 'full/f058210a19dfe15bcc9b0cc07548489b5653091c.jpg', '//shop.m.suning.com/70177579.html');
INSERT INTO `sp_category` VALUES ('183', '恒大旅游', '173', '2', '0', 'full/2f552f38faa19856c8f9c276d17a7853c829bb96.jpg', '//shop.m.suning.com/70178970.html');
INSERT INTO `sp_category` VALUES ('184', '苹果', '1482', '2', '0', 'full/ebe0d90985b3d382bc45629988172097afc5b78a.jpg', '/list/20006-10103.html');
INSERT INTO `sp_category` VALUES ('185', '搞机达人', '174', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('186', '小米', '1482', '2', '0', 'full/25caeab8bf076d748959ff2b9220f5bdc4f39653.jpg', '/list/20006-12121.html');
INSERT INTO `sp_category` VALUES ('187', '荣耀', '178', '2', '0', 'full/1b18668a6d4f39ee2913ea18ee3b6f82f27822c8.jpg', '/list/20006-964259.html');
INSERT INTO `sp_category` VALUES ('188', '华为', '178', '2', '0', 'full/06c2d4c4b52235d1f961cffcc0af5256c975c87b.jpg', '/list/20006-11635.html');
INSERT INTO `sp_category` VALUES ('189', '三星', '178', '2', '0', 'full/e4f79511bc69306e30d99474f93f3c06f84fa9ea.jpg', '/list/20006-10011.html');
INSERT INTO `sp_category` VALUES ('190', '魅族', '178', '2', '0', 'full/0e57d878d58382250d25e67d3d6448679adc12c5.jpg', '/list/20006-13706.html');
INSERT INTO `sp_category` VALUES ('191', 'OPPO', '178', '2', '0', 'full/5a2ff3eb1fe65a5cd2d78e98a562b587594edcc0.jpg', '/list/20006-12256.html');
INSERT INTO `sp_category` VALUES ('192', 'vivo', '178', '2', '0', 'full/6a6c0d7322da220ed1b9ffc4775d616dda83512d.jpg', '/list/20006-19311.html');
INSERT INTO `sp_category` VALUES ('193', '努比亚', '178', '2', '0', 'full/2ff38b6f53b3b1264d5c5aa32cf43abc86eb07d4.jpg', '/list/20006-55831.html');
INSERT INTO `sp_category` VALUES ('194', '美图', '178', '2', '0', 'full/e1a2c5db660a5771fd1dce1320f2a04ffdc486cb.jpg', '/list/20006-47980.html');
INSERT INTO `sp_category` VALUES ('195', '诺基亚', '178', '2', '0', 'full/9ca26d88bab3daa557b31b638b5586eb9c86ce9e.jpg', '/list/20006-10167.html');
INSERT INTO `sp_category` VALUES ('196', '飞利浦', '178', '2', '0', 'full/8b641b9d804d3f6fb199c7c08561b7c64de67059.jpg', '/list/20006-10015.html');
INSERT INTO `sp_category` VALUES ('197', '全部手机', '1482', '2', '0', 'full/76ecb2fa0feaa7e46366aac6ba327f7913b2b7de.jpg', '/list/20006-0.html');
INSERT INTO `sp_category` VALUES ('198', '拍照手机', '185', '2', '0', 'full/1b6c8dda71b1a5dac97ff251c90034eeafb62510.jpg', '//m.suning.com/search/拍照手机/?adTypeCode=1023&adId=拍照手机');
INSERT INTO `sp_category` VALUES ('199', '手机配件', '174', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('200', '游戏手机', '185', '2', '0', 'full/2fb07443707bbaa13c83cf46be0efca2e10328c0.jpg', '//m.suning.com/search/游戏手机/?adTypeCode=1023&adId=游戏手机');
INSERT INTO `sp_category` VALUES ('201', '好评过万', '185', '2', '0', 'full/118351b22394107e210b2b29c779dc85c3f54557.jpg', '//m.suning.com/search/好评过万手机/?adTypeCode=1023&adId=好评过万手机');
INSERT INTO `sp_category` VALUES ('202', '全面屏手机', '185', '2', '0', 'full/302b6ad0cc733dc9d8d6e8a01ab21319b5543de1.jpg', '//m.suning.com/search/全面屏手机/?adTypeCode=1023&adId=全面屏手机');
INSERT INTO `sp_category` VALUES ('203', '大屏手机', '185', '2', '0', 'full/d6ad572646a030377db1218ebf871235a1cc92eb.jpg', '//m.suning.com/search/大屏手机/?adTypeCode=1023&adId=大屏手机');
INSERT INTO `sp_category` VALUES ('204', '老人机', '185', '2', '0', 'full/c9d721aad7cd514d27029c482855f769003de7df.jpg', '//m.suning.com/search/老人机/?adTypeCode=1023&adId=老人机');
INSERT INTO `sp_category` VALUES ('205', '长续航手机', '185', '2', '0', 'full/d75d3bbcdd2a1e08eb60c30f7f662aa97aed6750.jpg', '//m.suning.com/search/长续航手机/?adTypeCode=1023&adId=长续航手机');
INSERT INTO `sp_category` VALUES ('206', '指纹手机', '185', '2', '0', 'full/b307c21fbe9ff34a0c196debed7a5fd9b836ec93.jpg', '/list/20006-897438.html');
INSERT INTO `sp_category` VALUES ('207', '手机服务', '174', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('208', '蓝牙耳机', '1482', '2', '0', 'full/19de6308238f81bfa01c867d6cc1bdfb4f1a0111.jpg', '/list/308503-0.html');
INSERT INTO `sp_category` VALUES ('209', '移动电源', '199', '2', '0', 'full/ca66280c286e04a8c0439ca13490b7fa4220b0d2.jpg', '/list/179001-0.html');
INSERT INTO `sp_category` VALUES ('210', '苹果周边', '199', '2', '0', 'full/f98999c40e5b56f3119ce3d819c5927b63425811.jpg', '/list/20016-10103.html');
INSERT INTO `sp_category` VALUES ('211', '运营商', '174', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('212', '手机耳机', '199', '2', '0', 'full/18d3369e1205702795a5fe98eb54c9b15b7c857e.jpg', '/list/20011-0.html');
INSERT INTO `sp_category` VALUES ('213', '充电器', '199', '2', '0', 'full/bf799cbf4413cabfbf83888416ed73eeecc5aa07.jpg', '/list/336523-0.html');
INSERT INTO `sp_category` VALUES ('214', '手机膜', '199', '2', '0', 'full/8498edd9a6aed043f17e6df9734a9bb78942a4bf.jpg', '/list/249514-0.html');
INSERT INTO `sp_category` VALUES ('215', '数据线', '199', '2', '0', 'full/2a4a35ce3c66edf9088b7ee1cd8a06b577de0ab7.jpg', '/list/336521-0.html');
INSERT INTO `sp_category` VALUES ('216', '手机存储卡', '199', '2', '0', 'full/b08be6fa786963687e0c5a6c3fd10f33b38fab32.jpg', '/list/20025-0.html');
INSERT INTO `sp_category` VALUES ('217', '手机壳', '199', '2', '0', 'full/70d2d342795d246cba840fa538ac56e75721d312.jpg', '/list/249513-0.html');
INSERT INTO `sp_category` VALUES ('218', '自拍杆', '199', '2', '0', 'full/ee9a5b6ef57f8f357e892c020c5535ac95dda3b2.jpg', '/list/500676-0.html');
INSERT INTO `sp_category` VALUES ('219', '手机支架', '199', '2', '0', 'full/98ee7b51d951dda258dc53c7c3d8b17d137497f8.jpg', '/list/336522-0.html');
INSERT INTO `sp_category` VALUES ('220', '手机U盘', '199', '2', '0', 'full/97d77712196dda085895c12f83dbf373d7bb6eda.jpg', '/list/500688-0.html');
INSERT INTO `sp_category` VALUES ('221', '以旧换新', '1482', '2', '0', 'full/c5e87b47b3c04c86190dc2818a4a88068e7c8b55.jpg', 'https://hx.m.suning.com/wap/home.htm');
INSERT INTO `sp_category` VALUES ('222', '手机维修', '207', '2', '0', 'full/4711ade17b97f05bccab128fd3378cb50dab82e9.jpg', '//pindao.suning.com/WX_wap.htm');
INSERT INTO `sp_category` VALUES ('223', '摄影摄像', '174', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('224', '二手优品', '207', '2', '0', 'full/8ebe43664371967338592d27935a3adbe42d195a.jpg', 'https://pindao.suning.com/shp_wap.htm');
INSERT INTO `sp_category` VALUES ('225', '合约机', '1482', '2', '0', 'full/23642af6871e9e43705e3600f6d660e800f2d661.jpg', '//m.suning.com/search/%E8%B4%AD%E6%9C%BA%E8%B5%A0%E8%B4%B9/');
INSERT INTO `sp_category` VALUES ('226', '话费充值', '211', '2', '0', 'full/c8225b69e5d5de1a257a6bc571e75f26380ec4a0.jpg', '//m.suning.com?adTypeCode=1108&adId=0');
INSERT INTO `sp_category` VALUES ('227', '流量订购', '211', '2', '0', 'full/6e8a7cac88e406c305dc78f4b634526c2522ecd4.jpg', '//cdoss.suning.com/newFourPageService/choosePkg.hs?provId=100&cityId=9173&sku=123');
INSERT INTO `sp_category` VALUES ('228', '苏宁网厅', '211', '2', '0', 'full/26e2652f05b513366920b186ff94979f9fd533b6.jpg', '//c.m.suning.com/yysnew.html');
INSERT INTO `sp_category` VALUES ('229', '超值靓号', '211', '2', '0', 'full/35fe18929f91fccdcf0cb7af5710ec042c6cb45d.jpg', '//c.m.suning.com/cuxiaohl.html');
INSERT INTO `sp_category` VALUES ('230', '单反相机', '1482', '2', '0', 'full/fe0eeff09a03cf7c0823fb4ad65c65fe1b706359.jpg', '/list/20064-0.html');
INSERT INTO `sp_category` VALUES ('231', '微单相机', '223', '2', '0', 'full/e7e3a0a93c0a16c562d0edb2be871acd01a7f67b.jpg', '/list/243003-0.html');
INSERT INTO `sp_category` VALUES ('232', '数码相机', '223', '2', '0', 'full/8bd047f8eed61c47305dff3373890a7ef33e785f.jpg', '/list/20063-0.html');
INSERT INTO `sp_category` VALUES ('233', '摄像机', '223', '2', '0', 'full/2e833366d1f480d68bbaa799555194805bf8e1fd.jpg', '/list/196502-0.html');
INSERT INTO `sp_category` VALUES ('234', '航拍无人机', '223', '2', '0', 'full/c4542e12907e10fd91f4327136eb3f8a28f6908e.jpg', '/list/500316-0.html');
INSERT INTO `sp_category` VALUES ('235', '镜头', '223', '2', '0', 'full/31cb74f89eff7ce1f990092ae085ee089f7e4368.jpg', '/list/20068-0.html');
INSERT INTO `sp_category` VALUES ('236', '拍立得', '223', '2', '0', 'full/eeb547daddec59237b23579bbbbb36ee472dc7e0.jpg', '/list/247003-0.html');
INSERT INTO `sp_category` VALUES ('237', '运动相机', '223', '2', '0', 'full/f5c32674f9ee15089131c3e32ea0ea4ff4ac159f.jpg', '/list/452003-0.html');
INSERT INTO `sp_category` VALUES ('238', '佳能', '223', '2', '0', 'full/8d99af0078802d5f597cfba57efb6f078a74fcab.jpg', '/list/20062-10035.html');
INSERT INTO `sp_category` VALUES ('239', '尼康', '223', '2', '0', 'full/e8c2a718a7ab79deacb840aadc5001f545509a0a.jpg', '/list/20062-10029.html');
INSERT INTO `sp_category` VALUES ('240', '索尼', '223', '2', '0', 'full/e42c598e09aabfb94fb1c12ddbe2066b94876601.jpg', '/list/20062-10028.html');
INSERT INTO `sp_category` VALUES ('241', '富士', '223', '2', '0', 'full/c92a6d8c4b6a931ad33f1cbe938eacdb44a4b006.jpg', '/list/20062-45511.html');
INSERT INTO `sp_category` VALUES ('242', 'JVC', '223', '2', '0', 'full/d3bf032c4bb94af9bf43047c690d2ae5772cc09b.jpg', '/list/20062-10066.html');
INSERT INTO `sp_category` VALUES ('243', '宾得', '223', '2', '0', 'full/c1e7122bbf6239f24250e97a6ea9972d06453b50.jpg', '/list/20062-10198.html');
INSERT INTO `sp_category` VALUES ('244', '奥林巴斯', '223', '2', '0', 'full/2b79c579db434f4d108e97de1d77269599036096.jpg', '/list/20062-10441.html');
INSERT INTO `sp_category` VALUES ('245', '柯达', '223', '2', '0', 'full/44dfabd3b6bc9248ff7120d1f1f9c5aaf7ed3445.jpg', '/list/20062-10834.html');
INSERT INTO `sp_category` VALUES ('246', '相机配件', '174', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('247', '徕卡', '223', '2', '0', 'full/6bfa08c384ac5c040dc2e19305c365146ed9b808.jpg', '/list/20062-12355.html');
INSERT INTO `sp_category` VALUES ('248', '松下', '223', '2', '0', 'full/9d8ce200b89131d98816093e02b63c6140ffc720.jpg', '/list/20063-10000.html');
INSERT INTO `sp_category` VALUES ('249', '喜爱', '223', '2', '0', 'full/eb718f4423054b6c911d46ae89212e55f2af0671.jpg', '/list/452003-2422302.html');
INSERT INTO `sp_category` VALUES ('250', '相机包', '1482', '2', '0', 'full/9d8276899a3ab14ff7ad0260a69a4faa574e05db.jpg', '/list/199004-0.html');
INSERT INTO `sp_category` VALUES ('251', '三脚架', '246', '2', '0', 'full/edee9230b53e1952ba866bef295cc2e1c2e27c7d.jpg', '/list/198504-0.html');
INSERT INTO `sp_category` VALUES ('252', '数据线', '246', '2', '0', 'full/f8041c0c74487ade2f909d469616ea0c05924c03.jpg', '/list/336521-0.html');
INSERT INTO `sp_category` VALUES ('253', '滤镜', '246', '2', '0', 'full/d69d829c6d6d8b798f56dc9bb993c190278ac640.jpg', '/list/20073-0.html');
INSERT INTO `sp_category` VALUES ('254', '相机存储卡', '246', '2', '0', 'full/c39b5ce07fe87cfcc9ccd9b35935fd158ef52b9f.jpg', '/list/25507-0.html');
INSERT INTO `sp_category` VALUES ('255', '闪光灯', '246', '2', '0', 'full/8967d1531f15fb8f8348a14403cd1a3d43f71c58.jpg', '/list/20070-0.html');
INSERT INTO `sp_category` VALUES ('256', '三星', '246', '2', '0', 'full/f299567eeae6824af23d37f221a5c249fbae0bcd.jpg', '/list/20084-10011.html');
INSERT INTO `sp_category` VALUES ('257', '影棚器材', '246', '2', '0', 'full/08815068357f9e08d2f138bdb56ded3d82847dbd.jpg', '//m.suning.com/search/摄影棚/?adTypeCode=1023&adId=摄影棚');
INSERT INTO `sp_category` VALUES ('258', '国家地理', '246', '2', '0', 'full/40b1b0156b46c99a2d2c79a3626775ecb2df5793.jpg', '/list/20084-10361.html');
INSERT INTO `sp_category` VALUES ('259', '腾龙', '246', '2', '0', 'full/644afd656a48349008edb9486407ed83d1854caf.jpg', '/list/20062-11376.html');
INSERT INTO `sp_category` VALUES ('260', '适马', '246', '2', '0', 'full/e523b81ff64415ca189faf679aa48bd8056b6f22.jpg', '/list/20062-11377.html');
INSERT INTO `sp_category` VALUES ('261', '英特迈', '246', '2', '0', 'full/100e73533afe7c6dba37f1e7d8b52e0fc0ebe281.jpg', '/list/20084-45528.html');
INSERT INTO `sp_category` VALUES ('262', '品胜', '246', '2', '0', 'full/41b5b9d273b71d03090d2ea690e23116c0509414.jpg', '/list/20084-17643.html');
INSERT INTO `sp_category` VALUES ('263', '百诺', '246', '2', '0', 'full/b3c2077c76b34355c0b16022ff5ba98f2e54a33a.jpg', '/list/20084-10358.html');
INSERT INTO `sp_category` VALUES ('264', '金士顿', '246', '2', '0', 'full/8f2aa65c9d902a09dae40193d9db94c8a362d65b.jpg', '/list/20084-10038.html');
INSERT INTO `sp_category` VALUES ('265', '闪迪', '246', '2', '0', 'full/068ce963e4df64065c7bd87849ff1186973dd4fe.jpg', '/list/20084-10109.html');
INSERT INTO `sp_category` VALUES ('266', '肯高', '246', '2', '0', 'full/da4eadd72d5bb645a5d2bb073e2e0d24d47a8a19.jpg', '/list/20084-10189.html');
INSERT INTO `sp_category` VALUES ('267', '曼富图', '246', '2', '0', 'full/0f933fc3bb366180aa1a508b70326c8df1f8e184.jpg', '/list/20084-10360.html');
INSERT INTO `sp_category` VALUES ('268', '卡色', '246', '2', '0', 'full/f47fdf8bcffdf2c094e66775b82d727e2b328e50.jpg', '/list/20084-17642.html');
INSERT INTO `sp_category` VALUES ('269', '神牛', '246', '2', '0', 'full/6490a02286adeab1821cde73e7f30f9c9c72c026.jpg', '/list/20084-742677.html');
INSERT INTO `sp_category` VALUES ('270', '电脑办公', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('272', '思锐', '246', '2', '0', 'full/b22a8c62e8cd87bc2a4f9cf6fbd4ccd924f50725.jpg', '/list/20084-11178.html');
INSERT INTO `sp_category` VALUES ('273', '电脑整机', '270', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('274', '施耐德', '246', '2', '0', 'full/97929982887238f9c648868c7a56384ef4ecea3d.jpg', '/list/20084-819512.html');
INSERT INTO `sp_category` VALUES ('275', '金贝', '246', '2', '0', 'full/8e5c49ca98d5d259028d3bf458a265730142866d.jpg', '/list/20084-14972.html');
INSERT INTO `sp_category` VALUES ('276', '飞毛腿', '246', '2', '0', 'full/46083cf0b0d3f88737ac088bfe5205c1213652c8.jpg', '/list/20084-10114.html');
INSERT INTO `sp_category` VALUES ('277', '耐司', '246', '2', '0', 'full/5949e5ae856a59fa72fd2c928dd160bdd193e24c.jpg', '/list/20084-18194.html');
INSERT INTO `sp_category` VALUES ('278', '沣标', '246', '2', '0', 'full/bdb1813ecca5e1e5922a47ae35a7b41b1ff3ef47.jpg', '/list/20084-10026.html');
INSERT INTO `sp_category` VALUES ('279', '迪比科', '246', '2', '0', 'full/dc38a4b802b19f0861b1d7867ca29178bd3b3ade.jpg', '/list/20084-45463.html');
INSERT INTO `sp_category` VALUES ('280', '斯丹德', '246', '2', '0', 'full/e05b4d22cd299fad1730d6bae8a4ff3f8d46eae7.jpg', '/list/20084-10299.html');
INSERT INTO `sp_category` VALUES ('281', '笔记本', '1482', '2', '0', 'full/dbbe1e2f0c6b2105dd9fb1f038449f1e856d08cc.jpg', '/list/258004-0.html');
INSERT INTO `sp_category` VALUES ('282', '游戏本', '1482', '2', '0', 'full/978288d1925add69291e82cad6930262356d2aeb.jpg', '/list/336003-0.html');
INSERT INTO `sp_category` VALUES ('283', '电脑外设', '270', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('284', '轻薄本', '273', '2', '0', 'full/7097160f74842e8640660218a051ec5efdbf3dd9.jpg', '/list/258007-0.html');
INSERT INTO `sp_category` VALUES ('285', '平板电脑', '273', '2', '0', 'full/d2a821ebd29bad4bf687dc84cc6e092a1792c66f.jpg', '/list/258006-0.html');
INSERT INTO `sp_category` VALUES ('286', '台式机', '273', '2', '0', 'full/983bd8d8d8370e33e324f59f217e06d9e3e8adef.jpg', '/list/258009-0.html');
INSERT INTO `sp_category` VALUES ('287', '一体机', '273', '2', '0', 'full/66c8b38b6bd038ead0f5616add22885a84bdbca8.jpg', '/list/258005-0.html');
INSERT INTO `sp_category` VALUES ('288', '组装机', '273', '2', '0', 'full/c11e1b875f382b4042e93b6bf378883bee27b5a9.jpg', '/list/376503-0.html');
INSERT INTO `sp_category` VALUES ('289', '电脑清洗', '273', '2', '0', 'full/67f6c8d715d139f7cce33773f45cb0c7a9280532.jpg', '//m.suning.com/product/520500021.html');
INSERT INTO `sp_category` VALUES ('290', 'DIY硬件', '270', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('291', '电脑维修', '273', '2', '0', 'full/7f78fc06610fbbf0db01f69df116bd2d372505d0.jpg', '//assss.suning.com/assss-web/wap/afterService/toServBookingOrders_0.do');
INSERT INTO `sp_category` VALUES ('292', 'U盘', '1482', '2', '0', 'full/037a8c051fc480f3d2bd97180b90904ef0e223f7.jpg', 'https://m.suning.com/search/u%E7%9B%98/');
INSERT INTO `sp_category` VALUES ('293', '鼠标', '283', '2', '0', 'full/24fbb82fa40cf47451b5fd3218805e234434f4c5.jpg', '/list/157250-0.html');
INSERT INTO `sp_category` VALUES ('294', '键盘', '283', '2', '0', 'full/ebb03e4c4b7ad3a60a49a2f65514ec33b1fd0870.jpg', '/list/157244-0.html');
INSERT INTO `sp_category` VALUES ('295', '键鼠套装', '283', '2', '0', 'full/ef56c29bddd48beeb07e21e33457726b2436948b.jpg', '/list/157246-0.html');
INSERT INTO `sp_category` VALUES ('296', '移动硬盘', '283', '2', '0', 'full/89b08b5aa47a5f5845c2606b08ec64e63de8e403.jpg', '/list/157252-0.html');
INSERT INTO `sp_category` VALUES ('297', '电脑音箱', '283', '2', '0', 'full/ebb4576fecf0c4db7e1138dbecb911afe4016262.jpg', '/list/157243-0.html');
INSERT INTO `sp_category` VALUES ('298', '网络设备', '270', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('299', '固态硬盘', '1482', '2', '0', 'full/50ab9aa3a792dd3956a8e7aaa7e0cf4cb86e6690.jpg', '/list/500677-0.html');
INSERT INTO `sp_category` VALUES ('300', '显示器', '290', '2', '0', 'full/6227510f6ac6f3b8d3a41d5d66c347240f5439a0.jpg', '/list/258011-0.html');
INSERT INTO `sp_category` VALUES ('301', 'CPU', '290', '2', '0', 'full/9a903c9d3d95c41e0051bd94377db1e1e60a23a8.jpg', '/list/221503-0.html');
INSERT INTO `sp_category` VALUES ('302', '显卡', '290', '2', '0', 'full/f1c57339501b81934d68e6a37b2ae4ddb1542cbe.jpg', '/list/186002-0.html');
INSERT INTO `sp_category` VALUES ('303', '硬盘', '290', '2', '0', 'full/7eb888d17f30d8b1804437f21546b756853cfe0b.jpg', '/list/186008-0.html');
INSERT INTO `sp_category` VALUES ('304', '内存', '290', '2', '0', 'full/37e04a0bfad18b4e2d3d852332079416ee04b9fa.jpg', '/list/169502-0.html');
INSERT INTO `sp_category` VALUES ('305', '主板', '290', '2', '0', 'full/6a59dc752fa14d9584f080ac1157b95223625379.jpg', '/list/186001-0.html');
INSERT INTO `sp_category` VALUES ('306', '电源', '290', '2', '0', 'full/3e484541efdd28be659cc4030081cef799e48a4a.jpg', '/list/186005-0.html');
INSERT INTO `sp_category` VALUES ('307', '声卡', '290', '2', '0', 'full/6a82b5eef2c0274da7f718c209fa935c1002964b.jpg', '/list/304504-0.html');
INSERT INTO `sp_category` VALUES ('308', '办公设备', '270', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('309', '路由器', '1482', '2', '0', 'full/6e54173e77ef109df3104003d238fc2848390ad1.jpg', '/list/157162-0.html');
INSERT INTO `sp_category` VALUES ('310', '无线网卡', '298', '2', '0', 'full/f8dd09258977c58a8c9ed629f8ac14eae853b926.jpg', '/list/157161-0.html');
INSERT INTO `sp_category` VALUES ('311', '信号放大器', '298', '2', '0', 'full/812653d0a548c47fc8ddc185a0b5ecbaf216b7ae.jpg', '//m.suning.com/search/wifi%E4%BF%A1%E5%8F%B7%E6%94%BE%E5%A4%A7%E5%99%A8/');
INSERT INTO `sp_category` VALUES ('312', '随身wifi', '298', '2', '0', 'full/d6434fbafee7952ddd5c6caedbf589d65e7b3b98.jpg', '//m.suning.com/search/%E9%9A%8F%E8%BA%ABwifi/?adTypeCode=1023&adId=%E9%9A%8F%E8%BA%ABwifi');
INSERT INTO `sp_category` VALUES ('313', '网线', '298', '2', '0', 'full/d33876c89c98388845c8229494bbf26145276387.jpg', '/list/244020-0.html');
INSERT INTO `sp_category` VALUES ('314', '交换机', '298', '2', '0', 'full/797b26f92bfc60f85291c1a1c200546478db75fe.jpg', '/list/157160-0.html');
INSERT INTO `sp_category` VALUES ('315', '文具用品', '270', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('316', '打印机', '1482', '2', '0', 'full/910f62b8649d98e707eda8a8112ad085c1586945.jpg', '/list/157127-0.html');
INSERT INTO `sp_category` VALUES ('317', '投影仪', '308', '2', '0', 'full/b774ce8ddaedc4b53a3340b1f5fd4f50383907cc.jpg', '/list/157124-0.html');
INSERT INTO `sp_category` VALUES ('318', '复印机', '308', '2', '0', 'full/693c3fba50665ed2f1aea3f7891a3e0684aec7a7.jpg', '/list/185002-0.html');
INSERT INTO `sp_category` VALUES ('319', '保险柜', '308', '2', '0', 'full/606d606ffcbf17163a36afafbf59e44ee4fe3436.jpg', '/list/195005-0.html');
INSERT INTO `sp_category` VALUES ('320', '厨卫电器', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('321', '投影仪吊装', '308', '2', '0', 'full/46c05f6dac39b700f2b9dd0117d489dce66a170e.jpg', '//m.suning.com/product/520000382.html');
INSERT INTO `sp_category` VALUES ('323', '打印机安装', '308', '2', '0', 'full/91686b0776c8c2dc9ce9b65356d83bb8b5d754cf.jpg', '//m.suning.com/product/520000176.html');
INSERT INTO `sp_category` VALUES ('324', '笔类', '1482', '2', '0', 'full/de0d6450d04a28537849da7e8dc00403b549a614.jpg', '/list/235003-0.html');
INSERT INTO `sp_category` VALUES ('325', '卫浴电器', '320', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('326', '办公文具', '315', '2', '0', 'full/3530fefa23582da2fcb83d5439b1156a634041c6.jpg', '/list/235005-0.html');
INSERT INTO `sp_category` VALUES ('327', '办公用纸', '315', '2', '0', 'full/7c767cfe1bf51e41896cfe300f0a60aadfc8f8c8.jpg', '/list/178508-0.html');
INSERT INTO `sp_category` VALUES ('328', '学生文具', '315', '2', '0', 'full/8b3a6bc1d735ba55a82a54bdda87c1ca57a1242c.jpg', '/list/336012-0.html');
INSERT INTO `sp_category` VALUES ('329', '文件管理', '315', '2', '0', 'full/5910563bb4fd6f9f8dad300a67cf59407b85d297.jpg', '/list/235006-0.html');
INSERT INTO `sp_category` VALUES ('330', '本册/便签', '315', '2', '0', 'full/90e5c6a1365e6a22b73821152aca09f1c468140e.jpg', '/list/235004-0.html');
INSERT INTO `sp_category` VALUES ('331', '热水器', '1482', '2', '0', 'full/fd892b39cd863847e65fa1f9c8befdd035e8488f.jpg', '/list/20344-0.html');
INSERT INTO `sp_category` VALUES ('332', '厨房大电', '320', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('333', '电热水器', '1482', '2', '0', 'full/914833920c114673a220a36827f9fd4562d11fc6.jpg', '/list/20344-22935.html');
INSERT INTO `sp_category` VALUES ('334', '燃气热水器', '325', '2', '0', 'full/fe1622d89fe15ebfb00e2c7e3a1c3227b55fbafa.jpg', '/list/20344-22741.html');
INSERT INTO `sp_category` VALUES ('335', '浴霸', '325', '2', '0', 'full/be084f477390de43ff9817a8cb678f91ec3fc5fe.jpg', '/list/218503-0.html');
INSERT INTO `sp_category` VALUES ('336', '厨宝', '325', '2', '0', 'full/a77fa2f48f8dc816d7f2461ab9d6cbde8990586d.jpg', '/list/20344-25910.html');
INSERT INTO `sp_category` VALUES ('337', '即热式', '325', '2', '0', 'full/6577ce5bb31822d6d961cd48922b262b0d8baf04.jpg', '/list/20344-24643.html');
INSERT INTO `sp_category` VALUES ('338', '太阳能', '325', '2', '0', 'full/ee8d17803441b3fa4826a7fe0e0af085d04a31dc.jpg', '/list/20344-26159.html');
INSERT INTO `sp_category` VALUES ('339', '智能马桶盖', '325', '2', '0', 'full/95b58b13ffe747ec99a0233d65bbb03fa884b925.jpg', '/list/20352-0.html');
INSERT INTO `sp_category` VALUES ('340', '卫浴家电配件', '325', '2', '0', 'full/f14ba71cbf3c33cb74c77b62df8736dcf952da4f.jpg', '/list/501292-0.html');
INSERT INTO `sp_category` VALUES ('341', '烟灶套餐', '1482', '2', '0', 'full/5419f5972cc257bcc9c4ad6f0b1d1b3b9762f4b3.jpg', '/list/337026-0.html');
INSERT INTO `sp_category` VALUES ('342', '净水设备', '320', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('343', '油烟机', '332', '2', '0', 'full/63b106162a56a62c3384075fa1442424959a6633.jpg', '/list/337026-2256697.html');
INSERT INTO `sp_category` VALUES ('344', '燃气灶', '332', '2', '0', 'full/9cf2de1a77fa45dd87e839436292d58a28d669fe.jpg', '/list/337026-2256696.html');
INSERT INTO `sp_category` VALUES ('345', '消毒柜', '332', '2', '0', 'full/9af274b26eb2334b4bc798c0dea3395ae89ac50c.jpg', '/list/20323-0.html');
INSERT INTO `sp_category` VALUES ('346', '嵌入式厨电', '332', '2', '0', 'full/c65801e755c41bdbb9c22a3d0f9d15950a2375c2.jpg', '/list/368004-0.html');
INSERT INTO `sp_category` VALUES ('347', '洗碗机', '332', '2', '0', 'full/23001b342737d8952e135bdaf2eaa0a8a71c2fd5.jpg', '/list/337506-0.html');
INSERT INTO `sp_category` VALUES ('348', '集成灶', '332', '2', '0', 'full/d8e0a8e9e4139347075a44a895b8f92af6ecc07b.jpg', '/list/337026-2256732.html');
INSERT INTO `sp_category` VALUES ('349', '商用厨房电器', '332', '2', '0', 'full/c36bed57e9082202a50655d5968c4aa0df9fba7c.jpg', '/list/501425-0.html');
INSERT INTO `sp_category` VALUES ('350', '垃圾处理器', '332', '2', '0', 'full/d9ad64cf837fe96c32d9522795c9d26454e61424.jpg', '/list/261503-0.html');
INSERT INTO `sp_category` VALUES ('351', '食品酒水', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('352', '净水器', '1482', '2', '0', 'full/c469a1b84323b3d6282b64804700aa9ee49fc8e6.jpg', '/list/20356-0.html');
INSERT INTO `sp_category` VALUES ('353', '饮水机', '342', '2', '0', 'full/178fb0cc1b611fa2d1ee3cb937369e333b2dd387.jpg', '/list/20354-0.html');
INSERT INTO `sp_category` VALUES ('355', 'AO史密斯', '342', '2', '0', 'full/04066248b72a9705ff717fdb61c62c21e378cda0.jpg', '/list/20356-10016.html');
INSERT INTO `sp_category` VALUES ('356', '中外名酒', '351', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('357', '沁园', '342', '2', '0', 'full/66577579d3b7abe924317b4acb3e0cac253b5cf4.jpg', '/list/20356-42113.html');
INSERT INTO `sp_category` VALUES ('358', '3M', '342', '2', '0', 'full/74a8cfb238473b73e5df543d852caff2ef0c87ba.jpg', '/list/20356-10239.html');
INSERT INTO `sp_category` VALUES ('359', '美的', '342', '2', '0', 'full/7c1eadc8cb4103f14e68bd699a5d0ab720cdc039.jpg', '/list/20356-10018.html');
INSERT INTO `sp_category` VALUES ('360', '牛奶冲调', '351', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('361', '白酒', '1482', '2', '0', 'full/c73cddf4272d7e835e96120d6907940daa3ffc6e.jpg', '/list/500394-0.html');
INSERT INTO `sp_category` VALUES ('362', '葡萄酒', '1482', '2', '0', 'full/d30a0a9b707eb8ff69a8ffbb0495453ebe7da427.jpg', '/list/500395-0.html');
INSERT INTO `sp_category` VALUES ('363', '啤酒', '356', '2', '0', 'full/e14bb8e9bdbdfb23edcff7f9363285438bc37274.jpg', '/list/500398-0.html');
INSERT INTO `sp_category` VALUES ('364', '保健酒', '356', '2', '0', 'full/fcfc45355d83b0fb85b6fd06a12bcec8326ca82d.jpg', '/list/500399-0.html');
INSERT INTO `sp_category` VALUES ('365', '黄酒', '356', '2', '0', 'full/2ae496bf8cb468aaf612f31abc20d3eedafaf38c.jpg', '/list/500396-0.html');
INSERT INTO `sp_category` VALUES ('366', '预调酒', '356', '2', '0', 'full/3dca9959b4d0bc4de87118f36cbc770f55cf4fae.jpg', '/list/500400-0.html');
INSERT INTO `sp_category` VALUES ('367', '纯牛奶', '1482', '2', '0', 'full/0aa884fdc925220dccb1b00ecc4cc076d1e0d908.jpg', '/list/500478-0.html');
INSERT INTO `sp_category` VALUES ('368', '酸牛奶', '360', '2', '0', 'full/bd7be6eb9ac0175107176717ba10c9f18c57c44e.jpg', '/list/500479-0.html');
INSERT INTO `sp_category` VALUES ('369', '生鲜蔬果', '351', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('370', '风味奶', '360', '2', '0', 'full/8fcfcbbc427e1f875738f19c58dc87d71977396f.jpg', '/list/500480-0.html');
INSERT INTO `sp_category` VALUES ('371', '成人奶粉', '360', '2', '0', 'full/0a4353ca5489bcdfbc4f537ed34be49101c7b236.jpg', '/list/500461-0.html');
INSERT INTO `sp_category` VALUES ('372', '茗茶', '360', '2', '0', 'full/849f65822fb80a379c409c119fc316c326c608f6.jpg', '/list/500375-0.html');
INSERT INTO `sp_category` VALUES ('373', '饮用水', '360', '2', '0', 'full/9c904931081feb625e65d54907d4d963696534d1.jpg', '/list/500440-0.html');
INSERT INTO `sp_category` VALUES ('374', '咖啡', '360', '2', '0', 'full/da8320f385793aa37acd2945968e52d7577ad0ad.jpg', '/list/500374-0.html');
INSERT INTO `sp_category` VALUES ('375', '蜂蜜', '360', '2', '0', 'full/830d9b022a1763b5f3e43543422ae21aa3685878.jpg', '/list/500467-0.html');
INSERT INTO `sp_category` VALUES ('376', '麦片', '360', '2', '0', 'full/dcf2c76f43002a9c99008f4237309a3563623d17.jpg', '/list/500466-0.html');
INSERT INTO `sp_category` VALUES ('377', '休闲食品', '351', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('378', '鲜肉', '1482', '2', '0', 'full/26a53addab819d2cdd82d7e59bc49550a565881c.jpg', '/list/500533-0.html');
INSERT INTO `sp_category` VALUES ('379', '水果', '369', '2', '0', 'full/093c6dc187e2d948bbcf62e1bc731696d6d8d22f.jpg', '/list/500529-0.html');
INSERT INTO `sp_category` VALUES ('380', '蔬菜', '369', '2', '0', 'full/e223c0b2d7eefc0bde34d47f51dcaca52052e396.jpg', '/list/500531-0.html');
INSERT INTO `sp_category` VALUES ('381', '海鲜水产', '369', '2', '0', 'full/e0f0fd72c2da21c3239529614f13bbeaae453aa2.jpg', '/list/500535-0.html');
INSERT INTO `sp_category` VALUES ('382', '蛋类', '369', '2', '0', 'full/7655bdc50da1b7a44d3384e563e87c793d720d44.jpg', '/list/500534-0.html');
INSERT INTO `sp_category` VALUES ('383', '粮油干货', '351', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('384', '速冻食品', '369', '2', '0', 'full/e225758ea2fa6df7aaa3c2c2bbe2d86589d5479b.jpg', '/list/500537-0.html');
INSERT INTO `sp_category` VALUES ('385', '饼干', '1482', '2', '0', 'full/75e5b284b2d9a5775992989d61066077f94fbdb3.jpg', '/list/500517-0.html');
INSERT INTO `sp_category` VALUES ('386', '巧克力', '377', '2', '0', 'full/8d73f842d376174d88137fbe350bf59ac767477b.jpg', '/list/500506-0.html');
INSERT INTO `sp_category` VALUES ('387', '坚果', '377', '2', '0', 'full/786cb23ffb8b1e6294c6b34f8468b69fd4adee88.jpg', '/list/500519-0.html');
INSERT INTO `sp_category` VALUES ('388', '糖果', '377', '2', '0', 'full/804163a6d36ba3d389f2a0cc40b8a83647223076.jpg', '/list/500507-0.html');
INSERT INTO `sp_category` VALUES ('389', '肉松/肉脯', '377', '2', '0', 'full/49c11a78943ca3b59ad9349b60c7a2c326791cda.jpg', '/list/500515-0.html');
INSERT INTO `sp_category` VALUES ('390', '蜜饯/果脯', '377', '2', '0', 'full/fdeccdeb2edc87a1e4ca517ecb1541a709b56d3a.jpg', '/list/500520-0.html');
INSERT INTO `sp_category` VALUES ('391', '糕点/点心', '377', '2', '0', 'full/e0f89d76a74931aef874afccbde4c18c0193a9ad.jpg', '/list/500518-0.html');
INSERT INTO `sp_category` VALUES ('392', '口香糖', '377', '2', '0', 'full/02ee64a98a1c71f0f046c5991b94206a45ed1ccb.jpg', '/list/500508-0.html');
INSERT INTO `sp_category` VALUES ('393', '薯片', '377', '2', '0', 'full/a63b4414a93be8a75054bc7dc994da698dc00d60.jpg', '/list/500513-0.html');
INSERT INTO `sp_category` VALUES ('394', '进口食品', '351', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('395', '食用油', '1482', '2', '0', 'full/77716d5c1fb4c39a8e221c091f31933af23b12e5.jpg', '/list/500437-0.html');
INSERT INTO `sp_category` VALUES ('396', '大米', '383', '2', '0', 'full/cc5d9510cf0d0e62316cad9bb6d77a76f9dbaba2.jpg', '/list/500436-0.html');
INSERT INTO `sp_category` VALUES ('397', '面粉', '383', '2', '0', 'full/ecdbac0dff83cc572fb10b7c43c5406dfa81d407.jpg', '/list/500439-0.html');
INSERT INTO `sp_category` VALUES ('398', '面条', '383', '2', '0', 'full/d64b561b060441026f9ab794ea0fefa0a2d9db28.jpg', '/list/500438-0.html');
INSERT INTO `sp_category` VALUES ('399', '桂圆', '383', '2', '0', 'full/9bae759fa170c9ba2ad85b74a1cf847f1f5fe96c.jpg', '/list/500500-0.html');
INSERT INTO `sp_category` VALUES ('400', '枣', '383', '2', '0', 'full/0c34d7330d3dd9b69cb926ff44e2d4211094d9bd.jpg', '/list/500502-0.html');
INSERT INTO `sp_category` VALUES ('401', '方便速食', '351', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('402', '进口牛奶', '1482', '2', '0', 'full/0d43c4e8f841c2ada9ba1d506fbda8c7448c9379.jpg', '/list/500356-0.html');
INSERT INTO `sp_category` VALUES ('403', '厨房调料', '351', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('404', '进口大米', '394', '2', '0', 'full/d22dbfb72ddf6260d66831ceb149c5d2ad6d1011.jpg', '/list/500456-0.html');
INSERT INTO `sp_category` VALUES ('405', '进口食用油', '394', '2', '0', 'full/23eddb06f26f5442d560486c8aa94cdb894eee57.jpg', '/list/500455-0.html');
INSERT INTO `sp_category` VALUES ('406', '居家生活', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('407', '方便面', '1482', '2', '0', 'full/dd4dee4cab0f0bd9b36829efb86585f3f1c6d03c.jpg', '/list/500522-0.html');
INSERT INTO `sp_category` VALUES ('409', '罐头', '401', '2', '0', 'full/2b43a25f14a9fef3b99562e25c163fd158b23405.jpg', '/list/500524-0.html');
INSERT INTO `sp_category` VALUES ('410', '方便粥', '401', '2', '0', 'full/489ddc83c5c892ca336364925d543c13cca549a2.jpg', '/list/500525-0.html');
INSERT INTO `sp_category` VALUES ('411', '生活用纸', '406', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('412', '调味酱', '1482', '2', '0', 'full/5ddab8d532203b985c589520260e52e60d002c4a.jpg', '/list/500492-0.html');
INSERT INTO `sp_category` VALUES ('413', '酱菜', '403', '2', '0', 'full/30fe47b4cf95e90b210e357f95734f48a06dd7fc.jpg', '/list/500493-0.html');
INSERT INTO `sp_category` VALUES ('414', '酱油', '403', '2', '0', 'full/38c8a1243190361399e663cf6d2fd4f06d105791.jpg', '/list/500485-0.html');
INSERT INTO `sp_category` VALUES ('415', '食醋', '403', '2', '0', 'full/785e287f493cff27c4444bfe6fe4712a398caffd.jpg', '/list/500487-0.html');
INSERT INTO `sp_category` VALUES ('416', '火锅底料', '403', '2', '0', 'full/dd0b5f8c73067b4b060f156b7370270663721f6e.jpg', '/list/500490-0.html');
INSERT INTO `sp_category` VALUES ('417', '食糖', '403', '2', '0', 'full/c3ba70b78ea617db80f6518c76ea79facb6a4a6a.jpg', '/list/500488-0.html');
INSERT INTO `sp_category` VALUES ('418', '卷纸', '1482', '2', '0', 'full/63f6171eaafd9712d1814533bf767e972bff1617.jpg', '/list/500592-0.html');
INSERT INTO `sp_category` VALUES ('419', '家庭清洁', '406', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('420', '抽纸', '1482', '2', '0', 'full/07d3153ae3531199b2d6cfc2d7df29bb8b182c6d.jpg', '/list/500591-0.html');
INSERT INTO `sp_category` VALUES ('421', '手帕纸', '411', '2', '0', 'full/f3477e25f847ec1d4e27ae84e078a3b4164efe8e.jpg', '/list/500593-0.html');
INSERT INTO `sp_category` VALUES ('422', '厨房用纸', '411', '2', '0', 'full/2f50ef28df4b5042d9ebf248d37e19b476a55c35.jpg', '/list/500596-0.html');
INSERT INTO `sp_category` VALUES ('423', '平板纸', '411', '2', '0', 'full/8e6084000a04f5d4d805426252cf37d9e1d41d65.jpg', '/list/500595-0.html');
INSERT INTO `sp_category` VALUES ('424', '湿巾纸', '411', '2', '0', 'full/aada3687b64cafb16640ea555f6183f832c74b03.jpg', '/list/500594-0.html');
INSERT INTO `sp_category` VALUES ('425', '洗衣液', '1482', '2', '0', 'full/acf4e6fa7b9192683d65f88b5cde1e63758a9542.jpg', '/list/161729-991855.html');
INSERT INTO `sp_category` VALUES ('426', '洗衣粉', '419', '2', '0', 'full/c4fb4e5bccf3a57e6fc5049730f3a3e89aa7d039.jpg', '/list/161729-993093.html');
INSERT INTO `sp_category` VALUES ('427', '生活日用', '406', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('428', '洗洁精', '419', '2', '0', 'full/61151875e626da81c313fb7a75fda9dab4e933fc.jpg', '/list/500545-29506.html');
INSERT INTO `sp_category` VALUES ('429', '消毒液', '419', '2', '0', 'full/8c847d9a0dd32d770b3ebe34fb6c62c94c83e044.jpg', '/list/500545-28696.html');
INSERT INTO `sp_category` VALUES ('430', '洁厕剂', '419', '2', '0', 'full/2fa460ddadd7a88cdd879e32f7d27f9c607a7351.jpg', '/list/500545-23671.html');
INSERT INTO `sp_category` VALUES ('431', '清洁拖把', '419', '2', '0', 'full/fe1509c5167c835d273f225d3c58ca2c9fbb64e4.jpg', '/list/187501-22543.html');
INSERT INTO `sp_category` VALUES ('432', '百洁软具', '419', '2', '0', 'full/c5be2fc2909b4ed8a534d178fabf579443810b92.jpg', '/list/187501-26405.html');
INSERT INTO `sp_category` VALUES ('433', '垃圾袋', '419', '2', '0', 'full/9c3733ca7d58dfcc50a186f0c5d1757ad0d9178e.jpg', '/list/161657-24964.html');
INSERT INTO `sp_category` VALUES ('434', '保鲜袋', '419', '2', '0', 'full/f4cd06fc8f6b00f8a6c7a82cf0f1670da3a704f6.jpg', '/list/161657-29806.html');
INSERT INTO `sp_category` VALUES ('435', '保鲜膜', '419', '2', '0', 'full/3c178913c5e2e0beae9f359f35a07445641eb068.jpg', '/list/161657-26917.html');
INSERT INTO `sp_category` VALUES ('436', '擦玻璃器', '419', '2', '0', 'full/a0e79d068cc4c1fbe1fbcdbd948f574287e9d557.jpg', '/list/187501-26258.html');
INSERT INTO `sp_category` VALUES ('437', '口罩', '1482', '2', '0', 'full/ef3aff39fcda684eef15711d50da49a0c663a968.jpg', '/list/197501-0.html');
INSERT INTO `sp_category` VALUES ('438', '保暖用品', '427', '2', '0', 'full/63a1a42669c4c16c44ae4ecd5b93bddde7041f77.jpg', '/list/500351-0.html');
INSERT INTO `sp_category` VALUES ('439', '家纺布艺', '406', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('440', '保温器皿', '427', '2', '0', 'full/76fb4c5f22dc35d0c28fb14886c03d728031709f.jpg', '/list/501125-0.html');
INSERT INTO `sp_category` VALUES ('441', '水杯', '427', '2', '0', 'full/7325a2427341c8b61b8fe1a4be1f46c1b3dd741c.jpg', '/list/500683-904731.html');
INSERT INTO `sp_category` VALUES ('442', '收纳用品', '427', '2', '0', 'full/cfd6c20859e52bae2bd050dac7aec9fa0e245b8b.jpg', '/list/161666-0.html');
INSERT INTO `sp_category` VALUES ('443', '洗晒用品', '427', '2', '0', 'full/4668bc9a6f696d3964d7b79ad26f84532195ef51.jpg', '/list/342013-0.html');
INSERT INTO `sp_category` VALUES ('444', '净化除味', '427', '2', '0', 'full/cd64d1e8bc9af3e54b11fdad497c889f39f2d55a.jpg', '/list/215006-0.html');
INSERT INTO `sp_category` VALUES ('445', '茶具', '427', '2', '0', 'full/e00448462a14a3f9980a626d8474b4469181df19.jpg', '/list/500683-904738.html');
INSERT INTO `sp_category` VALUES ('446', '保鲜盒', '427', '2', '0', 'full/634a8a32eda28e1bb6bd8700617a8dbc23021594.jpg', '/list/500683-904761.html');
INSERT INTO `sp_category` VALUES ('447', '宠物生活', '406', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('448', '四件套', '1482', '2', '0', 'full/0891cea5f9e33a8ae2b9085a5ed3b5f5ca5d4224.jpg', '/list/161662-0.html');
INSERT INTO `sp_category` VALUES ('449', '毛巾浴巾', '439', '2', '0', 'full/58b31cc0c9ae7db9076473e9c01e498873af4891.jpg', '/list/212503-0.html');
INSERT INTO `sp_category` VALUES ('450', '被子', '439', '2', '0', 'full/185e587ac2c8a48e451d7a35c75f12f60466f0d8.jpg', '/list/455503-0.html');
INSERT INTO `sp_category` VALUES ('451', '枕芯枕套', '439', '2', '0', 'full/64e11e0aef479c0cf4af9c0450af97c673f87734.jpg', '/list/161727-0.html');
INSERT INTO `sp_category` VALUES ('452', '床品套件', '439', '2', '0', 'full/4fe8a5b7817b74379ec7418381f33612af6f45aa.jpg', '/list/161662-0.html');
INSERT INTO `sp_category` VALUES ('453', '厨房电器', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('454', '毛巾被/毯', '439', '2', '0', 'full/8d0837f1940a7c8d0f1377bfa2153b45a2bc518e.jpg', '/list/248003-0.html');
INSERT INTO `sp_category` VALUES ('456', '宠物主食', '1482', '2', '0', 'full/03db0c829081c100a17a664a0b7ff4b287e5e993.jpg', '/list/500553-0.html');
INSERT INTO `sp_category` VALUES ('457', '宠物零食', '447', '2', '0', 'full/d86273dd1bc1e199f8e0ae3a07f48fbe00389f11.jpg', '/list/500555-0.html');
INSERT INTO `sp_category` VALUES ('458', '中式厨房', '453', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('459', '宠物保健', '447', '2', '0', 'full/6e23982fdcff043dcf173abef1bf4e7b539711b5.jpg', '/list/500556-0.html');
INSERT INTO `sp_category` VALUES ('460', '洗护美容', '447', '2', '0', 'full/aec3ac2103922c81ea0ed3cfa4508825bf6faf42.jpg', '/list/500560-0.html');
INSERT INTO `sp_category` VALUES ('461', '出行装备', '447', '2', '0', 'full/7a03469257571a4ffb18412cc54ec28498660be9.jpg', '/list/500557-0.html');
INSERT INTO `sp_category` VALUES ('462', '宠物日用', '447', '2', '0', 'full/fdcf05601f6381c9f9ca3f18ea9cd52685e4cdb3.jpg', '/list/500559-0.html');
INSERT INTO `sp_category` VALUES ('463', '电饭煲', '1482', '2', '0', 'full/f1fdb681b0b4142d62d7afb5a7f40dd180768d3e.jpg', '/list/20329-0.html');
INSERT INTO `sp_category` VALUES ('464', '电压力锅', '1482', '2', '0', 'full/8dbb901c8c0929828ac206a3db998256892c765f.jpg', '/list/20330-0.html');
INSERT INTO `sp_category` VALUES ('465', '电磁炉', '458', '2', '0', 'full/7be88a9e7f8748593df6db28674c3dd28d5c2c6f.jpg', '/list/20328-0.html');
INSERT INTO `sp_category` VALUES ('466', '豆浆机', '458', '2', '0', 'full/d3f50275671e3e4cc9565a85c723833020b6e564.jpg', '/list/20333-0.html');
INSERT INTO `sp_category` VALUES ('467', '多用途锅', '458', '2', '0', 'full/97225f0e1dbed84b7998dd47ba79746bacb9ca9f.jpg', '/list/20337-0.html');
INSERT INTO `sp_category` VALUES ('468', '电饼铛', '458', '2', '0', 'full/ae5cf8dfe815ad1216f2db10548c8b6d1c8d364a.jpg', '/list/95502-0.html');
INSERT INTO `sp_category` VALUES ('469', '电水壶/瓶', '458', '2', '0', 'full/86e998ae232cadccfe699d48426e232e7f137957.jpg', '/list/20331-0.html');
INSERT INTO `sp_category` VALUES ('470', '电蒸锅', '458', '2', '0', 'full/9352b2cb9947b449aea190220c4b8e8a1af1bd6c.jpg', '/list/20337-26232.html');
INSERT INTO `sp_category` VALUES ('471', '养生壶', '458', '2', '0', 'full/ebd00d65d338aab7e583a6f0f60493e87829efd0.jpg', '/list/500030-0.html');
INSERT INTO `sp_category` VALUES ('472', '电陶炉', '458', '2', '0', 'full/5971e5f14dbf4919e4eadccb2ab5a9291b6adce8.jpg', '/list/337507-0.html');
INSERT INTO `sp_category` VALUES ('473', '西式厨房', '453', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('474', '煮蛋器', '458', '2', '0', 'full/18fb2ea7a948c182609afe67561ddfd58279cf5b.jpg', '/list/20340-0.html');
INSERT INTO `sp_category` VALUES ('475', '电热饭盒', '458', '2', '0', 'full/c468d891f19dfb2574b069edf97cda39c7372de5.jpg', '/list/234503-0.html');
INSERT INTO `sp_category` VALUES ('476', '电炖锅/盅', '458', '2', '0', 'full/52e60a80161a58d99ba6bff959c05faed0c21b44.jpg', '/list/136507-0.html');
INSERT INTO `sp_category` VALUES ('477', '美的', '458', '2', '0', 'full/80346cb1e9ae52dfeab17296eea3060ea5a5e632.jpg', '/list/20326-10018.html');
INSERT INTO `sp_category` VALUES ('478', '九阳', '458', '2', '0', 'full/ea4923bf5ea45295113ba0f5c5f473e27c00301f.jpg', '/list/20326-42089.html');
INSERT INTO `sp_category` VALUES ('479', '苏泊尔', '458', '2', '0', 'full/9dd85abe302416cc9d1dde48d20831f87fc180db.jpg', '/list/20326-10036.html');
INSERT INTO `sp_category` VALUES ('480', '利仁', '458', '2', '0', 'full/2228fc92f23a1ff73477a5fbfd0de57ee5a48c2b.jpg', '/list/20326-53315.html');
INSERT INTO `sp_category` VALUES ('481', '荣事达', '458', '2', '0', 'full/5ccf913415ab2ccb53138b5cca6d1498e99e702f.jpg', '/list/20326-42136.html');
INSERT INTO `sp_category` VALUES ('482', '微波炉', '1482', '2', '0', 'full/2f83f7ca9c8c5611158360089a3b6c4861c951d2.jpg', '/list/20327-0.html');
INSERT INTO `sp_category` VALUES ('483', '生活电器', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('484', '烤箱', '473', '2', '0', 'full/ca9b08c081596d95cac1a2a9e4434d740890485c.jpg', '/list/20336-0.html');
INSERT INTO `sp_category` VALUES ('486', '料理机', '473', '2', '0', 'full/bfe82f7e9620b5ec43128bb8dd7f8a530197ba5f.jpg', '/list/24002-0.html');
INSERT INTO `sp_category` VALUES ('487', '环境电器', '483', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('488', '面包机', '473', '2', '0', 'full/f2479f936fe75102f0e765a03a348bf1b7fd36df.jpg', '/list/20335-25383.html');
INSERT INTO `sp_category` VALUES ('489', '空气炸锅', '473', '2', '0', 'full/4ae89a1685b8c94f865d377adc5cc40da0b5d2c2.jpg', '/list/20337-29208.html');
INSERT INTO `sp_category` VALUES ('490', '咖啡机', '473', '2', '0', 'full/feac7d72cb13f59260138f00ed75f1a79810184a.jpg', '/list/20339-0.html');
INSERT INTO `sp_category` VALUES ('491', '酸奶机', '473', '2', '0', 'full/94bd8753d65fcf49aa790fabbae1309b6e57c3a4.jpg', '/list/20342-0.html');
INSERT INTO `sp_category` VALUES ('492', '打蛋器', '473', '2', '0', 'full/19b538961ff8d1367dc2d9dba7812dc44d228ece.jpg', '/list/24002-2350644.html');
INSERT INTO `sp_category` VALUES ('493', '电烧烤炉', '473', '2', '0', 'full/0779723e0c2c3923395f3a20d4b545733bf71227.jpg', '/list/95502-24634.html');
INSERT INTO `sp_category` VALUES ('494', '多士炉', '473', '2', '0', 'full/31c44944e9438a571de9fad1b176493f482a997c.jpg', '/list/20335-23409.html');
INSERT INTO `sp_category` VALUES ('495', '榨汁/原汁机', '473', '2', '0', 'full/94c2b3ad5c774c4c2ecbe6f024fd25606d339384.jpg', '/list/20334-0.html');
INSERT INTO `sp_category` VALUES ('496', '格兰仕', '473', '2', '0', 'full/b08322d63f34bc381ba24d4d811805a0025d5868.jpg', '/list/20326-10031.html');
INSERT INTO `sp_category` VALUES ('497', '东菱', '473', '2', '0', 'full/9f978a6c069868d0d60cbb8a6e1e67683f7a67a7.jpg', '/list/20326-45735.html');
INSERT INTO `sp_category` VALUES ('498', '松下', '473', '2', '0', 'full/521cde3c8593be68cf21c42e3abdb7a405f089dc.jpg', '/list/20326-10000.html');
INSERT INTO `sp_category` VALUES ('499', '长帝', '473', '2', '0', 'full/9986d6196c4797bb29d0331f7b6b94ab9602960c.jpg', '/list/20336-42255.html');
INSERT INTO `sp_category` VALUES ('500', '空气净化器', '1482', '2', '0', 'full/c28dbf9b72eeaf7150c5a2bade7dc35873db6e8e.jpg', '/list/20394-0.html');
INSERT INTO `sp_category` VALUES ('501', '油汀', '1482', '2', '0', 'full/6298db88f0d979fcd1291dd8feb2482fba872e43.jpg', '/list/20370-123235.html');
INSERT INTO `sp_category` VALUES ('502', '欧式快热炉', '487', '2', '0', 'full/76ac84b6a8f43aa02f88360a7260b5185843f14b.jpg', '/list/20370-28542.html');
INSERT INTO `sp_category` VALUES ('503', '加湿器', '487', '2', '0', 'full/5bf8888af6816dade1ef8f2d83e49e9f391cbeed.jpg', '/list/20395-0.html');
INSERT INTO `sp_category` VALUES ('504', '取暖器', '487', '2', '0', 'full/88a4dbcc2d1e7f9b7d056ae29c3209e13daf1f18.jpg', '/list/20370-0.html');
INSERT INTO `sp_category` VALUES ('505', '家居电器', '483', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('506', '暖风机', '487', '2', '0', 'full/133a908d8d402fc4aab0773851bb4f1d6ec1625d.jpg', '/list/20370-27663.html');
INSERT INTO `sp_category` VALUES ('507', '小太阳', '487', '2', '0', 'full/ac2478a40a953a56a52d0f9da8ec57f353a72af9.jpg', '/list/20370-28194.html');
INSERT INTO `sp_category` VALUES ('508', '除湿机', '487', '2', '0', 'full/92c2081b40bd02cdcb1f568010c87a9ec5bb26a0.jpg', '/list/20396-0.html');
INSERT INTO `sp_category` VALUES ('509', '干衣/干鞋机', '487', '2', '0', 'full/9c3ceb50749d06cdbaaa613bf0a5dab2fbf2b89c.jpg', '/list/173001-0.html');
INSERT INTO `sp_category` VALUES ('510', '先锋', '487', '2', '0', 'full/8ca5040c59965fa946165dcbb85883546ed11fd4.jpg', '/list/20366-10069.html');
INSERT INTO `sp_category` VALUES ('511', '艾美特', '487', '2', '0', 'full/aecf57e70fd292a8d7359cea7402c3324e750ad0.jpg', '/list/20366-45472.html');
INSERT INTO `sp_category` VALUES ('512', '美的', '487', '2', '0', 'full/80346cb1e9ae52dfeab17296eea3060ea5a5e632.jpg', '/list/20366-10018.html');
INSERT INTO `sp_category` VALUES ('513', '个护健康', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('514', '飞利浦', '487', '2', '0', 'full/07a14d76ed24165e6a9971556b44a40833af1a34.jpg', '/list/20366-10015.html');
INSERT INTO `sp_category` VALUES ('515', '小熊', '487', '2', '0', 'full/4c31ef1dee522c57cb4866e3c3fe33e25f771eb8.jpg', '/list/20366-42143.html');
INSERT INTO `sp_category` VALUES ('516', '小米', '487', '2', '0', 'full/b650ddb70969e81ce161555e6a13ba85ac0a8082.jpg', '/list/20358-12121.html');
INSERT INTO `sp_category` VALUES ('517', '吸尘器', '1482', '2', '0', 'full/a2a040cb291a050559b41a7b23c6cd939acf9687.jpg', '/list/20390-0.html');
INSERT INTO `sp_category` VALUES ('518', '扫地机器人', '505', '2', '0', 'full/45c8ae38d4e3c10c9d3448cca39661d42d7f92a1.jpg', '/list/20390-259337.html');
INSERT INTO `sp_category` VALUES ('520', '挂烫机', '505', '2', '0', 'full/2974629c7df6cd52f75d87535dd813f0754b52d6.jpg', '/list/20399-0.html');
INSERT INTO `sp_category` VALUES ('521', '戴森', '505', '2', '0', 'full/1dcd27afc799f10d91a0981559d3dd0623c8a758.jpg', '/list/20358-46081.html');
INSERT INTO `sp_category` VALUES ('522', '科沃斯', '505', '2', '0', 'full/e144107d679615acb02c0a427d96c5e54ad45e2e.jpg', '/list/20366-42106.html');
INSERT INTO `sp_category` VALUES ('523', '理容造型', '513', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('524', '小狗', '505', '2', '0', 'full/6f89b21866150c7aa7541784c8b1b7b08ae83e5e.jpg', '/list/20366-43940.html');
INSERT INTO `sp_category` VALUES ('525', '电动剃须刀', '1482', '2', '0', 'full/1d96b57defa0b897303c1d41dcb23b35801e123e.jpg', '/list/20360-0.html');
INSERT INTO `sp_category` VALUES ('526', '口腔护理', '513', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('527', '电吹风', '1482', '2', '0', 'full/a7450f85b9c199d84f8c21188c4b9bf7f315e0b4.jpg', '/list/20362-0.html');
INSERT INTO `sp_category` VALUES ('528', '健康电器', '513', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('529', '美容器', '523', '2', '0', 'full/8963dee424d154f78b65fbde37a624016f2b051c.jpg', '/list/337510-0.html');
INSERT INTO `sp_category` VALUES ('530', '美发器', '523', '2', '0', 'full/12b1ccdf7c6060b83904dad05772e67d01cf3f9d.jpg', '/list/337511-0.html');
INSERT INTO `sp_category` VALUES ('531', '剃毛器', '523', '2', '0', 'full/6b0fd4dbd3c30e859f11e5fdad060fae26ee8f75.jpg', '/list/20361-31677.html');
INSERT INTO `sp_category` VALUES ('532', '脱毛器', '523', '2', '0', 'full/7cc52c61643293ad5ed0c0a7596533549a0a8c3d.jpg', '/list/20361-28107.html');
INSERT INTO `sp_category` VALUES ('533', '理发器', '523', '2', '0', 'full/7fe1c8b084d651ba5f43ff2910dcab5a67b0bf41.jpg', '/list/337512-0.html');
INSERT INTO `sp_category` VALUES ('534', '鼻毛修剪器', '523', '2', '0', 'full/4b65fe002b32b7b691404e3fa5e05ab67419f9b7.jpg', '/list/337513-0.html');
INSERT INTO `sp_category` VALUES ('535', '飞利浦', '523', '2', '0', 'full/427b222a6687cceda3cecbde762ed39e151145bd.jpg', '/list/20359-10015.html');
INSERT INTO `sp_category` VALUES ('536', '飞科', '523', '2', '0', 'full/95f0a2fd54c7f48367b4e4309f7ffbafeb23ccc3.jpg', '/list/20359-42103.html');
INSERT INTO `sp_category` VALUES ('537', '斐珞尔', '523', '2', '0', 'full/1e56db9e96474c9153c4de58bf15d4a49ca1ce75.jpg', '/list/337510-615463.html');
INSERT INTO `sp_category` VALUES ('538', '雅萌', '523', '2', '0', 'full/4698f2ac1ff67aaa6aaad9e774346b6a59e69883.jpg', '/list/337510-186461.html');
INSERT INTO `sp_category` VALUES ('539', '松下', '523', '2', '0', 'full/521cde3c8593be68cf21c42e3abdb7a405f089dc.jpg', '/list/20359-10000.html');
INSERT INTO `sp_category` VALUES ('540', '金稻', '523', '2', '0', 'full/27ebe6452be571e72d28ad2ba35daf0eeafbc31e.jpg', '/list/20359-48430.html');
INSERT INTO `sp_category` VALUES ('541', '博朗', '523', '2', '0', 'full/877788a627a2094edebb123699fd0b1226d548ab.jpg', '/list/20360-11217.html');
INSERT INTO `sp_category` VALUES ('542', '电动牙刷', '1482', '2', '0', 'full/2945ad4a4fa66db9c934dbc9083e452aca6e3dba.jpg', '/list/20363-0.html');
INSERT INTO `sp_category` VALUES ('543', '牙刷头', '526', '2', '0', 'full/dd50c607d2568dabbee3f3d5f460929c16d2e81a.jpg', '/list/20363-22441.html');
INSERT INTO `sp_category` VALUES ('544', '冲牙器', '526', '2', '0', 'full/459d23a482aaf51043aca752880415c7ee975d91.jpg', '/list/20363-27205.html');
INSERT INTO `sp_category` VALUES ('545', '欧乐B', '526', '2', '0', 'full/f14af996b1a8a2f6694090f9b59284d1c08b17b4.jpg', '/list/20363-11217.html');
INSERT INTO `sp_category` VALUES ('546', '小荷', '526', '2', '0', 'full/3a4143c59c15e2fa33e9ef3412ae10c3b0a3277a.jpg', '/list/20363-736256.html');
INSERT INTO `sp_category` VALUES ('547', '拜尔', '526', '2', '0', 'full/b30a2e210d20d2836b8e9fbaf499341e85b9fcf3.jpg', '/list/20363-10213.html');
INSERT INTO `sp_category` VALUES ('548', '按摩椅', '1482', '2', '0', 'full/4920471f2be2f02350f0cee1d43d5408f7b695ce.jpg', '/list/92526-0.html');
INSERT INTO `sp_category` VALUES ('549', '按摩器', '528', '2', '0', 'full/fc4d06524be07a9e9ccef4254fdcd4b91e017e14.jpg', '/list/92520-0.html');
INSERT INTO `sp_category` VALUES ('550', '烹饪厨具', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('551', '健康秤', '528', '2', '0', 'full/40aa1ad02bee357742848987c6e1fd7548550b7b.jpg', '/list/92515-0.html');
INSERT INTO `sp_category` VALUES ('553', '锅具', '550', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('554', '足浴盆', '528', '2', '0', 'full/5d34fa750ef7da05898664c9e306f61d7d6320c2.jpg', '/list/92504-0.html');
INSERT INTO `sp_category` VALUES ('555', '荣泰', '528', '2', '0', 'full/b80aef71dfe13088d7afc909ba1ab6c217c7ed1c.jpg', '/list/92526-2398148.html');
INSERT INTO `sp_category` VALUES ('556', '泰昌', '528', '2', '0', 'full/e05849c5a2ec363ad6a93f7e3b97be50c5373ed1.jpg', '/list/20359-42181.html');
INSERT INTO `sp_category` VALUES ('557', '凯仕乐', '528', '2', '0', 'full/a2a6eb80eea8ec89a6310c4874aa8ab70ffe91fd.jpg', '/list/20359-42355.html');
INSERT INTO `sp_category` VALUES ('558', '迪斯', '528', '2', '0', 'full/5ea569ed8e30be3e614a762ad0007df52ee4d9b2.jpg', '/list/92526-14650.html');
INSERT INTO `sp_category` VALUES ('559', '套装锅', '1482', '2', '0', 'full/25d40d823ad85b4453a326b21f9452b803cd402a.jpg', '/list/23501-991794.html');
INSERT INTO `sp_category` VALUES ('560', '炒锅', '1482', '2', '0', 'full/316c46013761e4937c8f4ade0a53332a079709f2.jpg', '/list/23501-991773.html');
INSERT INTO `sp_category` VALUES ('561', '蒸锅', '553', '2', '0', 'full/9b0b7893ed75ed8317411782d4d69d5303043a7e.jpg', '/list/23501-991756.html');
INSERT INTO `sp_category` VALUES ('562', '煎锅', '553', '2', '0', 'full/af2e3e23dce5fa1d4827d92c4e37e2593662772f.jpg', '/list/23501-991888.html');
INSERT INTO `sp_category` VALUES ('563', '压力锅', '553', '2', '0', 'full/0e8a39df9d718e5cc843c33fee7c3856bcf0fffa.jpg', '/list/23501-991885.html');
INSERT INTO `sp_category` VALUES ('564', '奶锅', '553', '2', '0', 'full/b90613066a8416f171886eb087a44c43675efd09.jpg', '/list/23501-991783.html');
INSERT INTO `sp_category` VALUES ('565', '汤锅', '553', '2', '0', 'full/c3abe45eb02868c657a5c4e7021a202a31d6cb4b.jpg', '/list/23501-991785.html');
INSERT INTO `sp_category` VALUES ('566', '砂锅', '553', '2', '0', 'full/69156b0d7c4878530211e54f5d677accb323b73f.jpg', '/list/23501-993481.html');
INSERT INTO `sp_category` VALUES ('567', '火锅', '553', '2', '0', 'full/afbaceee05036d266b67173758c7187dc38bb469.jpg', '/list/23501-993433.html');
INSERT INTO `sp_category` VALUES ('568', '苏泊尔', '553', '2', '0', 'full/9dd85abe302416cc9d1dde48d20831f87fc180db.jpg', '/list/23501-10036.html');
INSERT INTO `sp_category` VALUES ('569', '爱仕达', '553', '2', '0', 'full/6402aea439c7de7185202c25d7331e9c9d2c22c8.jpg', '/list/23501-42099.html');
INSERT INTO `sp_category` VALUES ('570', '康宁', '553', '2', '0', 'full/5272ad00d2aeda13e7f7ba3efd2bd24627697f67.jpg', '/list/251027-135269.html');
INSERT INTO `sp_category` VALUES ('571', '炊大皇', '553', '2', '0', 'full/3002da8280d98d5e2424f0a2291690b298c85b00.jpg', '/list/23501-47124.html');
INSERT INTO `sp_category` VALUES ('572', '刀剪菜板', '550', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('573', '拉歌蒂尼', '553', '2', '0', 'full/aac36af00586f00bac340ade4830a1c440f9107d.jpg', '/list/251027-57951.html');
INSERT INTO `sp_category` VALUES ('574', '摩意达', '553', '2', '0', 'full/65801fcf45a1175267e935d7ec433ab851f227a2.jpg', '/list/23501-2303311.html');
INSERT INTO `sp_category` VALUES ('575', '珍珠生活', '553', '2', '0', 'full/0af8630a357665bb7e144dc5e1cbae232189b10a.jpg', '/list/23501-42531.html');
INSERT INTO `sp_category` VALUES ('576', '菲仕乐', '553', '2', '0', 'full/4846c0005887b253e74d712a74b30c1a1cb43ee8.jpg', '/list/23501-651596.html');
INSERT INTO `sp_category` VALUES ('577', '水具酒具', '550', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('578', '美厨', '553', '2', '0', 'full/f8abf0bbfa7470a26e11aa67b88132f4bcbb2a8a.jpg', '/list/23501-14354.html');
INSERT INTO `sp_category` VALUES ('579', '刀具套装', '1482', '2', '0', 'full/057a0c9ff43b86d961697f19f429c5886cd59649.jpg', '/list/36503-23289.html');
INSERT INTO `sp_category` VALUES ('580', '家装建材', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('581', '菜刀', '572', '2', '0', 'full/a161f5506236f3889cbc959f3b506ef75980b5a5.jpg', '/list/36503-25671.html');
INSERT INTO `sp_category` VALUES ('582', '多功能刀', '572', '2', '0', 'full/6662d733a82df6f8697bfe1068c2c0f83bf3409a.jpg', '/list/36503-23225.html');
INSERT INTO `sp_category` VALUES ('583', '剪刀', '572', '2', '0', 'full/993e888928f2eeccd20b7a45737845ac3d38cb49.jpg', '/list/36503-126528.html');
INSERT INTO `sp_category` VALUES ('585', '瓜果刀/刨刀', '572', '2', '0', 'full/67a26e69a9f7886345b2f96e695ca39221268b77.jpg', '/list/36503-26799.html');
INSERT INTO `sp_category` VALUES ('586', '砧板', '572', '2', '0', 'full/c81f1c19ff7c819143feb0345a0732b540fc978a.jpg', '/list/226809-22849.html');
INSERT INTO `sp_category` VALUES ('587', '双立人', '572', '2', '0', 'full/a92891dbaf723bebe14de2a209b804aa613acbc1.jpg', '/list/36503-78764.html');
INSERT INTO `sp_category` VALUES ('588', '张小泉', '572', '2', '0', 'full/d7ade06f22c214687e986679050b52c09124af4e.jpg', '/list/36503-43444.html');
INSERT INTO `sp_category` VALUES ('589', '灯具灯饰', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('590', '保温杯', '1482', '2', '0', 'full/a4f238397bcb57161be20e57cf5761615928a967.jpg', '/list/501124-904747.html');
INSERT INTO `sp_category` VALUES ('591', '保温瓶/桶', '577', '2', '0', 'full/314e659c08b4744269eae988265de90fb584bc3f.jpg', '/list/501125-904751.html');
INSERT INTO `sp_category` VALUES ('592', '酒具', '577', '2', '0', 'full/4337d0f393bd3f8698ab02461e782364aa726f25.jpg', '/list/500683-904741.html');
INSERT INTO `sp_category` VALUES ('593', '象印', '577', '2', '0', 'full/68bfa52142c9185b26ad362bc0a75855086d5618.jpg', '/list/501124-61087.html');
INSERT INTO `sp_category` VALUES ('594', '虎牌', '577', '2', '0', 'full/80e7d04f57963f572b8c9679b8d840e939035de5.jpg', '/list/501124-11169.html');
INSERT INTO `sp_category` VALUES ('595', '现代吸顶灯', '1482', '2', '0', 'full/f44729728c4b4c92435478e460bf04259d3b5294.jpg', '/list/456005-119631.html');
INSERT INTO `sp_category` VALUES ('596', '水晶吸顶灯', '1482', '2', '0', 'full/2241a3d3da24f26d94ebe5e01fb9c344e87b7cc0.jpg', '/list/456005-119638.html');
INSERT INTO `sp_category` VALUES ('597', '吸顶灯', '589', '2', '0', 'full/0a7680f508ecfbc239184aff3e1bb43550ee1ac1.jpg', '/list/456005-0.html');
INSERT INTO `sp_category` VALUES ('598', '欧式吊灯', '589', '2', '0', 'full/98e7465984adec313f5cf3f8b4d15604884ebd63.jpg', '/list/456007-119646.html');
INSERT INTO `sp_category` VALUES ('599', '厨房卫浴', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('600', '美式吊灯', '589', '2', '0', 'full/768d7eb037fc2d05cc0ffa15e5470a8f4d1bc73f.jpg', '/list/456007-119636.html');
INSERT INTO `sp_category` VALUES ('601', '水晶吊灯', '589', '2', '0', 'full/f0ef0ddd480d554f3f42a908b307e94bb40b44ef.jpg', '/list/456007-119638.html');
INSERT INTO `sp_category` VALUES ('602', '鱼线吊灯', '589', '2', '0', 'full/cb709730d4b073bcb6294302a1786f1a3d029bb5.jpg', '/list/456007-734872.html');
INSERT INTO `sp_category` VALUES ('603', '风扇灯', '589', '2', '0', 'full/1ca59eea9d06eed56927dcb648564749378ab938.jpg', '/list/456007-734863.html');
INSERT INTO `sp_category` VALUES ('604', '中式灯', '589', '2', '0', 'full/42d425e4337ff282e5adfb345aa4585f6d4e4a2b.jpg', '/list/456007-119634.html');
INSERT INTO `sp_category` VALUES ('605', '护眼台灯', '589', '2', '0', 'full/7cbf36af2c85faea578825bf2fb4c23c679dba9f.jpg', '/list/456008-137120.html');
INSERT INTO `sp_category` VALUES ('606', '装饰台灯', '589', '2', '0', 'full/592e998f0bafdf1c0928856a82b26635db36db9a.jpg', '/list/456008-648842.html');
INSERT INTO `sp_category` VALUES ('607', '壁灯', '589', '2', '0', 'full/65c686af7358dc044b5ae2619df4b3f56b05ef59.jpg', '/list/456009-0.html');
INSERT INTO `sp_category` VALUES ('608', '光源', '589', '2', '0', 'full/7775d21755f9cb03e84b49f25a64c21f115b9eab.jpg', '/list/456017-0.html');
INSERT INTO `sp_category` VALUES ('609', '射灯', '589', '2', '0', 'full/026ef49ee811b056921a1654ba79cdd035eaebed.jpg', '/list/456010-0.html');
INSERT INTO `sp_category` VALUES ('610', '筒灯', '589', '2', '0', 'full/16608562b464be93dea89d0e477b46e59b8a7c3a.jpg', '//m.suning.com/search/筒灯/?adTypeCode=1023&adId=筒灯');
INSERT INTO `sp_category` VALUES ('611', '小夜灯', '589', '2', '0', 'full/a728b5ae0a0b97bde30f628393acf664e279d941.jpg', '//m.suning.com/search/小夜灯/?adTypeCode=1023&adId=小夜灯');
INSERT INTO `sp_category` VALUES ('612', '灯带', '589', '2', '0', 'full/5967da17d8c800bdc686bb7c3ede15e76dbef7a3.jpg', '//m.suning.com/search/%E7%81%AF%E5%B8%A6/?adTypeCode=1023&adId=%E7%81%AF%E5%B8%A6');
INSERT INTO `sp_category` VALUES ('613', '灯具套餐', '589', '2', '0', 'full/49bcb6110e57bf8cc9566ed2bf9ed30ea614d084.jpg', '//m.suning.com/search/%E7%81%AF%E5%85%B7%E5%A5%97%E8%A3%85/?adTypeCode=1023&adId=%E7%81%AF%E5%85%B7%E5%A5%97%E8%A3%85');
INSERT INTO `sp_category` VALUES ('614', '坐便器', '1482', '2', '0', 'full/14c24a4734af20262e67ff18aa969fa89a11caac.jpg', '/list/456029-0.html');
INSERT INTO `sp_category` VALUES ('615', '沐浴/花洒', '599', '2', '0', 'full/b0e48465bd94f137f4dce6f2fc3a8212d534e160.jpg', '/list/456039-0.html');
INSERT INTO `sp_category` VALUES ('616', '五金电工', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('617', '水槽/厨盆', '599', '2', '0', 'full/1d5acf79fafa977f1e16389929d3cde2cf29036d.jpg', '/list/456045-0.html');
INSERT INTO `sp_category` VALUES ('618', '浴室柜', '599', '2', '0', 'full/030035c28f57c3117fbc992601a8be61e5b15cce.jpg', '/list/456041-0.html');
INSERT INTO `sp_category` VALUES ('619', '手持花洒', '599', '2', '0', 'full/2205583a1a9f469a1525f4b28e900eada5c0952c.jpg', '/list/456039-2292317.html');
INSERT INTO `sp_category` VALUES ('620', '卫浴五金', '599', '2', '0', 'full/2c9d2261ffd85feb0e4f1209fb687104dd2d5a4a.jpg', '/list/456040-0.html');
INSERT INTO `sp_category` VALUES ('621', '龙头', '599', '2', '0', 'full/a49a12b5085465a5860b47ed33f62ea9502ff3be.jpg', '/list/456044-0.html');
INSERT INTO `sp_category` VALUES ('622', '地漏', '599', '2', '0', 'full/e45659a50bc3c2a2df241cdbd1cea2f6f29d55a9.jpg', '/list/456038-0.html');
INSERT INTO `sp_category` VALUES ('623', '浴缸', '599', '2', '0', 'full/a4ea4a24831c3151c95f63fb1fa89149d36e5f1d.jpg', '/list/456052-0.html');
INSERT INTO `sp_category` VALUES ('624', '马桶盖板', '599', '2', '0', 'full/0b06981e7a1adeb4391e9c0a092a6c8e2e064c03.jpg', '/list/456030-0.html');
INSERT INTO `sp_category` VALUES ('625', '角阀', '599', '2', '0', 'full/56780ce9504edc3a774c42c9a8187649696932ce.jpg', '/list/456037-0.html');
INSERT INTO `sp_category` VALUES ('626', '淋浴房', '599', '2', '0', 'full/9ae60d2bef45727d5a570792208b62799dbd0fea.jpg', '/list/456051-0.html');
INSERT INTO `sp_category` VALUES ('627', '洗面盆', '599', '2', '0', 'full/9d81b224e3ef577ce07aed37fe377c7fccf98104.jpg', '//m.suning.com/search/洗面盆/?adTypeCode=1023&adId=洗面盆');
INSERT INTO `sp_category` VALUES ('628', '小便器', '599', '2', '0', 'full/ea1201d1487da95c317236a202db67b9f8ad6444.jpg', '/list/456032-0.html');
INSERT INTO `sp_category` VALUES ('629', '拖把池', '599', '2', '0', 'full/0667e818753d2d4c2f85ab25439e90a1ec3cef5d.jpg', '//m.suning.com/search/拖把池/?adTypeCode=1023&adId=拖把池');
INSERT INTO `sp_category` VALUES ('630', '开关', '1482', '2', '0', 'full/c1d17f26e737f15c0a9ed3b75be77bb87f97e58e.jpg', '/list/500062-0.html');
INSERT INTO `sp_category` VALUES ('631', '插座', '616', '2', '0', 'full/39560a52cafb85241d17c261ca1971f0f696057b.jpg', '/list/500063-0.html');
INSERT INTO `sp_category` VALUES ('632', '电线', '616', '2', '0', 'full/e6d6e4a8137ef309fe77d7ec30b38e529359f2a7.jpg', '//m.suning.com/search/电线/?adTypeCode=1023&adId=电线');
INSERT INTO `sp_category` VALUES ('633', '断路器', '616', '2', '0', 'full/074f57b7b2b7dda715d13cb52f9b510d1a94a3c3.jpg', '/list/500059-0.html');
INSERT INTO `sp_category` VALUES ('634', '锁具', '616', '2', '0', 'full/1d71d88b2abc9258bfa905676a6dfdb570e86280.jpg', '/list/500095-0.html');
INSERT INTO `sp_category` VALUES ('635', '监控摄像', '616', '2', '0', 'full/40b0295cb5463748aa592847f4f6083881287b79.jpg', '/list/500048-0.html');
INSERT INTO `sp_category` VALUES ('636', '电钻', '616', '2', '0', 'full/32b9cf66e848f3adc355bbd8f92d5be5f7b41a02.jpg', '//m.suning.com/search/电钻/?adTypeCode=1023&adId=电钻');
INSERT INTO `sp_category` VALUES ('637', '工具箱', '616', '2', '0', 'full/46e7300cc11c514210c7aa571ecd4f3be8832f93.jpg', '/list/500089-0.html');
INSERT INTO `sp_category` VALUES ('638', '墙地面', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('639', '电动工具', '616', '2', '0', 'full/08a84577dc48603edfaca0f46372d7df5ff30e83.jpg', '/list/500069-0.html');
INSERT INTO `sp_category` VALUES ('640', '手动工具', '616', '2', '0', 'full/48f6d5091e51b3c2caa38accd8e8d38a33239275.jpg', '/list/500066-0.html');
INSERT INTO `sp_category` VALUES ('641', '测量工具', '616', '2', '0', 'full/5801da84cbc035cf4904a7db7ec54969089cd9fc.jpg', '/list/500073-0.html');
INSERT INTO `sp_category` VALUES ('642', '指纹锁', '616', '2', '0', 'full/2f77037904b3e0482386ec10292f1a97f3f9be57.jpg', '//m.suning.com/search/指纹锁/?adTypeCode=1023&adId=指纹锁');
INSERT INTO `sp_category` VALUES ('643', '瓷砖', '1482', '2', '0', 'full/6f932da8cf111f634ce62e226701e808a9648f40.jpg', '/list/456021-0.html');
INSERT INTO `sp_category` VALUES ('644', '釉面砖', '638', '2', '0', 'full/ab947b05ee2c02f91b5d1ed3c720de79c1a4ccdb.jpg', '/list/456021-272661.html');
INSERT INTO `sp_category` VALUES ('645', '卧室家具', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('646', '玻化砖', '638', '2', '0', 'full/683bc93d9ab046338599d38eeff8c13e54e49eb9.jpg', '/list/456021-281564.html');
INSERT INTO `sp_category` VALUES ('647', '地板', '638', '2', '0', 'full/04e6ebdf83bd753d6f1407aa03c5800a6a8656f7.jpg', '//m.suning.com/search/地板/?adTypeCode=1023&adId=地板');
INSERT INTO `sp_category` VALUES ('648', '实木地板', '638', '2', '0', 'full/fbde9c73cb97b3c1db3cbce3298eb7760afee0c7.jpg', '//m.suning.com/search/实木地板/?adTypeCode=1023&adId=实木地板');
INSERT INTO `sp_category` VALUES ('649', '强化地板', '638', '2', '0', 'full/084e692ad3136dfb81088509a57a598db682b330.jpg', '//m.suning.com/search/强化地板/?adTypeCode=1023&adId=强化地板');
INSERT INTO `sp_category` VALUES ('650', '乳胶漆', '638', '2', '0', 'full/ce329447025888a09305fe604048b5761af1b520.jpg', '//m.suning.com/search/乳胶漆/?adTypeCode=1023&adId=乳胶漆');
INSERT INTO `sp_category` VALUES ('651', '内墙漆', '638', '2', '0', 'full/88aa924c23d46d72656d3ebc5de13ed6d1e75656.jpg', '/list/456022-3232982.html');
INSERT INTO `sp_category` VALUES ('652', '木器漆', '638', '2', '0', 'full/5838667adaac694ead3db6f4920ba973e611d6e0.jpg', '/list/456022-3235834.html');
INSERT INTO `sp_category` VALUES ('653', '墙纸', '638', '2', '0', 'full/bbdeab37e39b6ac76d4dbd83b5496dedf072b1bc.jpg', '/list/456019-0.html');
INSERT INTO `sp_category` VALUES ('654', 'PVC墙纸', '638', '2', '0', 'full/cd51a2effde3ae7f559b28c014989444ca5b69f5.jpg', '//m.suning.com/search/PVC墙纸/?adTypeCode=1023&adId=PVC墙纸');
INSERT INTO `sp_category` VALUES ('655', '背景墙', '638', '2', '0', 'full/3df0162892cb69f91042d809e443dc2093b25ce7.jpg', '//m.suning.com/search/%E8%83%8C%E6%99%AF%E5%A2%99/?adTypeCode=1023&adId=%E8%83%8C%E6%99%AF%E5%A2%99');
INSERT INTO `sp_category` VALUES ('656', '床', '1482', '2', '0', 'full/29661ccaa3280af044b990ab7a41b496f38573e7.jpg', '/list/457533-0.html');
INSERT INTO `sp_category` VALUES ('657', '床垫', '645', '2', '0', 'full/9e127bd5e30d8b81f3dce4d9e76b662904b6ee89.jpg', '//m.suning.com/search/床垫/?adTypeCode=1023&adId=床垫');
INSERT INTO `sp_category` VALUES ('658', '衣柜', '645', '2', '0', 'full/60bbe9ffa4e52283b2f95ffd894110634068e9ba.jpg', '/list/457545-0.html');
INSERT INTO `sp_category` VALUES ('659', '客厅家具', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('660', '床头柜', '645', '2', '0', 'full/f9f14aa76faaf62c9aa07b2826d481de405e1a62.jpg', '//m.suning.com/search/床头柜/?adTypeCode=1023&adId=床头柜');
INSERT INTO `sp_category` VALUES ('661', '穿衣镜', '645', '2', '0', 'full/6d5394efc52868bc731dedd7997b8174f5fda886.jpg', '/list/457549-0.html');
INSERT INTO `sp_category` VALUES ('662', '梳妆台', '645', '2', '0', 'full/84bfcfeb1eb673ad76443a0d78d379c155892cba.jpg', '/list/457546-0.html');
INSERT INTO `sp_category` VALUES ('663', '实木床', '645', '2', '0', 'full/1fc04a6485d0a33b05d5e46b6301a6d9d6885ba2.jpg', '/list/457533-981159.html');
INSERT INTO `sp_category` VALUES ('664', '板式床', '645', '2', '0', 'full/8b91279f75b0dc0026984e9b2dce9f1e61c0a9e1.jpg', '//m.suning.com/search/板式床/?adTypeCode=1023&adId=板式床');
INSERT INTO `sp_category` VALUES ('665', '皮艺床', '645', '2', '0', 'full/14ee41da7c05f409175b7b5b14470ee5177700ef.jpg', '/list/457533-981164.html');
INSERT INTO `sp_category` VALUES ('666', '乳胶床垫', '645', '2', '0', 'full/bc4c72648f78bec0fe78669c24c15fabbfd16917.jpg', '/list/457543-981181.html');
INSERT INTO `sp_category` VALUES ('667', '椰棕床垫', '645', '2', '0', 'full/977ae80a5e5597b5098c33abbfb49cf86e14ac1d.jpg', '/list/457543-981172.html');
INSERT INTO `sp_category` VALUES ('668', '卧室套装', '645', '2', '0', 'full/3086eb943b7ca94eaac4f78ceb53405d63c537b8.jpg', '/list/457548-0.html');
INSERT INTO `sp_category` VALUES ('669', '书房办公', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('670', '沙发', '1482', '2', '0', 'full/a49df6acb69b6c91209e4f2a2997280207f6fd71.jpg', '//m.suning.com/search/沙发/?adTypeCode=1023&adId=沙发');
INSERT INTO `sp_category` VALUES ('671', '电视柜', '659', '2', '0', 'full/20b6f9e0779324a813a017f8ea19f6fa7e02be79.jpg', '//m.suning.com/search/电视柜/?adTypeCode=1023&adId=电视柜');
INSERT INTO `sp_category` VALUES ('672', '茶几', '659', '2', '0', 'full/8479d3e9bdf8e1215dcfa7294392c63d9cf6b2a2.jpg', '/list/457553-0.html');
INSERT INTO `sp_category` VALUES ('673', '布艺沙发', '659', '2', '0', 'full/15ff4cf643a471d88da4f093e2d398de6f9d049f.jpg', '/list/457552-981171.html');
INSERT INTO `sp_category` VALUES ('674', '实木沙发', '659', '2', '0', 'full/4161d8d5d62142f8ae615291c33a88ba763b6a9a.jpg', '/list/457552-981180.html');
INSERT INTO `sp_category` VALUES ('675', '皮艺沙发', '659', '2', '0', 'full/0e3d58501f088253a5b2d2f268494a13db27b1c5.jpg', '/list/457552-981165.html');
INSERT INTO `sp_category` VALUES ('676', '花架', '659', '2', '0', 'full/1785e043f150c220f49dd35d1d51c810f9cda596.jpg', '/list/457556-0.html');
INSERT INTO `sp_category` VALUES ('677', '客厅套装', '659', '2', '0', 'full/26dd1a7641c0d0c32e92339fee4645836b231cef.jpg', '//m.suning.com/search/客厅套装/?adTypeCode=1023&adId=客厅套装');
INSERT INTO `sp_category` VALUES ('678', '餐厅门厅', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('679', '办公桌', '1482', '2', '0', 'full/6ba82e7b1030ff1de51c7354d038339bf30192a5.jpg', '//m.suning.com/search/%E5%8A%9E%E5%85%AC%E6%A1%8C/?adTypeCode=1023&adId=%E5%8A%9E%E5%85%AC%E6%A1%8C');
INSERT INTO `sp_category` VALUES ('680', '书柜书架', '669', '2', '0', 'full/b9a31b2006258b6d7b6e0b4acc56290bcc3100e4.jpg', '/list/457539-0.html');
INSERT INTO `sp_category` VALUES ('681', '电脑桌', '669', '2', '0', 'full/a88b75e75bd29654d16b71b371cfd1c5d50c7663.jpg', '/list/457541-0.html');
INSERT INTO `sp_category` VALUES ('682', '书桌', '669', '2', '0', 'full/3269ca71a707fcac98d9d94b0bccb7a42faae46d.jpg', '//m.suning.com/search/书桌/?adTypeCode=1023&adId=书桌');
INSERT INTO `sp_category` VALUES ('683', '老板椅', '669', '2', '0', 'full/eb5831ae3a1ec49905e87a75b798d5750dfc5e11.jpg', '//m.suning.com/search/老板椅/?adTypeCode=1023&adId=老板椅');
INSERT INTO `sp_category` VALUES ('684', '会议桌', '669', '2', '0', 'full/601f9edb79c235df441cc0bd9ca45714a0bb3f7f.jpg', '//m.suning.com/search/%E4%BC%9A%E8%AE%AE%E6%A1%8C/?adTypeCode=1023&adId=%E4%BC%9A%E8%AE%AE%E6%A1%8C');
INSERT INTO `sp_category` VALUES ('685', '餐桌', '1482', '2', '0', 'full/fd01051e492586bff308b7a62eab28fae7c3ba19.jpg', '/list/457560-0.html');
INSERT INTO `sp_category` VALUES ('686', '定制装修', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('687', '餐边柜', '678', '2', '0', 'full/b761f7ab4f978550468f0c92345b5e2987fdd8b5.jpg', '/list/457562-0.html');
INSERT INTO `sp_category` VALUES ('688', '酒柜', '678', '2', '0', 'full/5e50ec9bab1797b3afa6dcbb34e84fd2fd89c28f.jpg', '/list/457594-0.html');
INSERT INTO `sp_category` VALUES ('689', '餐厅套装', '678', '2', '0', 'full/e92314e8df7c6f51d2af89087d6976ce87ccb1ee.jpg', '//m.suning.com/search/餐厅套装/?adTypeCode=1023&adId=餐厅套装');
INSERT INTO `sp_category` VALUES ('690', '鞋柜', '678', '2', '0', 'full/bd47f3df44dcb87b522103d013dd133c80d92d43.jpg', '/list/457566-0.html');
INSERT INTO `sp_category` VALUES ('691', '门厅柜', '678', '2', '0', 'full/a4b00fad56d71a4be86880fe5033cbecf5f62fed.jpg', '//m.suning.com/search/门厅柜/?adTypeCode=1023&adId=门厅柜');
INSERT INTO `sp_category` VALUES ('692', '衣帽架', '678', '2', '0', 'full/43ab6b55c8b70d7631c9ef1daf94d543d42c3696.jpg', '/list/457568-0.html');
INSERT INTO `sp_category` VALUES ('693', '玄关台', '678', '2', '0', 'full/ea0bb74dd1271d6726ff8b8d1f5384923356421a.jpg', '//m.suning.com/search/玄关台/?adTypeCode=1023&adId=玄关台');
INSERT INTO `sp_category` VALUES ('694', '定制柜类', '1482', '2', '0', 'full/7c238db8a232a3b0592dcee926672061f817546e.jpg', '/list/501252-0.html');
INSERT INTO `sp_category` VALUES ('695', '暖气片/地暖', '686', '2', '0', 'full/814a378465ed9181fac1a49129043ef258fd2dc5.jpg', '/list/456064-0.html');
INSERT INTO `sp_category` VALUES ('696', '品牌墙', '580', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('697', '室内门', '686', '2', '0', 'full/6f43fdfda01d7540cee3bfcedc0d29695f26de76.jpg', '//m.suning.com/search/室内门/?adTypeCode=1023&adId=室内门');
INSERT INTO `sp_category` VALUES ('698', '全包装修', '686', '2', '0', 'full/4b0f93923dfb2288acbedc2d3d420eb58810f28e.jpg', '/list/500654-764867.html');
INSERT INTO `sp_category` VALUES ('699', '半包装修', '686', '2', '0', 'full/68c1e5d757b571303c6ee67bd9d72c636a8ebee4.jpg', '/list/500654-766543.html');
INSERT INTO `sp_category` VALUES ('700', '全案装修', '686', '2', '0', 'full/b10eb4c16b9cca29bfa1d8cdcf231a55641df6b6.jpg', '//m.suning.com/search/%E5%85%A8%E6%A1%88%E8%A3%85%E4%BF%AE/?adTypeCode=1023&adId=%E5%85%A8%E6%A1%88%E8%A3%85%E4%BF%AE');
INSERT INTO `sp_category` VALUES ('701', '装修设计', '686', '2', '0', 'full/dce7e5e5bfda3a7c80be91a888aee01672c86be9.jpg', '/list/500039-0.html');
INSERT INTO `sp_category` VALUES ('702', '拎包入住', '686', '2', '0', 'full/42795adad645bf17d08a8b70346a8a5060c51983.jpg', '//m.suning.com/search/%E6%8B%8E%E5%8C%85%E5%85%A5%E4%BD%8F/?adTypeCode=1023&adId=%E6%8B%8E%E5%8C%85%E5%85%A5%E4%BD%8F');
INSERT INTO `sp_category` VALUES ('703', '全友', '1482', '2', '0', 'full/a2d1393a23919cd81549591b6fedb69d395cec31.jpg', '//m.suning.com/search/全友/?adTypeCode=1023&adId=全友');
INSERT INTO `sp_category` VALUES ('704', 'A家家具', '696', '2', '0', 'full/11e4e8ea9177775e33583ad17e9d71374993626a.jpg', '//m.suning.com/search/A家家具/?adTypeCode=1023&adId=A家家具');
INSERT INTO `sp_category` VALUES ('705', '左右', '696', '2', '0', 'full/5993aa958b174bc4b4a443de48483732a54f7018.jpg', '/list/457552-1300609.html');
INSERT INTO `sp_category` VALUES ('706', '恒享家', '696', '2', '0', 'full/843b407739ceef2a05b2f144f5c598a5faaae528.jpg', '//m.suning.com/search/%E6%81%92%E4%BA%AB%E5%AE%B6/?adTypeCode=1023&adId=%E6%81%92%E4%BA%AB%E5%AE%B6');
INSERT INTO `sp_category` VALUES ('707', '双虎', '696', '2', '0', 'full/53a22ab573fed7559e301768bc25d2ba5bf37448.jpg', '//m.suning.com/search/%E5%8F%8C%E8%99%8E/?adTypeCode=1023&adId=%E5%8F%8C%E8%99%8E');
INSERT INTO `sp_category` VALUES ('708', '喜临门', '696', '2', '0', 'full/4c46f4783be8f9c8e68f2129aac0aab079539c41.jpg', '//m.suning.com/search/%E5%96%9C%E4%B8%B4%E9%97%A8/?adTypeCode=1023&adId=%E5%96%9C%E4%B8%B4%E9%97%A8');
INSERT INTO `sp_category` VALUES ('709', '欧普照明', '696', '2', '0', 'full/06e97cded29eca4cf23509f7ad6c48ade7219056.jpg', '//m.suning.com/search/%E6%AC%A7%E6%99%AE/?adTypeCode=1023&adId=%E6%AC%A7%E6%99%AE');
INSERT INTO `sp_category` VALUES ('710', '奶粉尿裤', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('711', '雷士照明', '696', '2', '0', 'full/f36b141d41d9fc249d286fe60d4b5755130d3000.jpg', '//m.suning.com/search/%E9%9B%B7%E5%A3%AB/?adTypeCode=1023&adId=%E9%9B%B7%E5%A3%AB');
INSERT INTO `sp_category` VALUES ('712', '松下', '696', '2', '0', 'full/764c0827d7567b42c67d05cf777d0a69bad4641a.jpg', '//m.suning.com/search/%E6%9D%BE%E4%B8%8B%E7%81%AF%E5%85%B7/?adTypeCode=1023&adId=%E6%9D%BE%E4%B8%8B%E7%81%AF%E5%85%B7');
INSERT INTO `sp_category` VALUES ('713', '正泰', '696', '2', '0', 'full/6cc3524e15053e7d6fb610d3112f55eccc4fee76.jpg', '//m.suning.com/search/%E6%AD%A3%E6%B3%B0/?adTypeCode=1023&adId=%E6%AD%A3%E6%B3%B0');
INSERT INTO `sp_category` VALUES ('714', '施耐德', '696', '2', '0', 'full/e26799f22d7dba7bfd9a938763e809d8ac0131ba.jpg', '//m.suning.com/search/%E6%96%BD%E8%80%90%E5%BE%B7/?adTypeCode=1023&adId=%E6%96%BD%E8%80%90%E5%BE%B7');
INSERT INTO `sp_category` VALUES ('715', '西门子', '696', '2', '0', 'full/adb0b92b0aabcd35d6ffa5179ced26eb5d43017f.jpg', '/list/500043-10002.html');
INSERT INTO `sp_category` VALUES ('717', '九牧', '696', '2', '0', 'full/dac5d3a129256b3a6ee715f93b72338662562862.jpg', '//m.suning.com/search/%E4%B9%9D%E7%89%A7/?adTypeCode=1023&adId=%E4%B9%9D%E7%89%A7');
INSERT INTO `sp_category` VALUES ('718', '华帝', '696', '2', '0', 'full/ed7e1e391ac383ea95d083025a5480d5cdb4e54d.jpg', '/list/456028-42232.html');
INSERT INTO `sp_category` VALUES ('719', '孕婴奶粉', '710', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('720', '箭牌卫浴', '696', '2', '0', 'full/e8a21b30631aefcc6f12bf584c710aebe1916bea.jpg', '/list/456028-161365.html');
INSERT INTO `sp_category` VALUES ('721', '尿裤湿巾', '710', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('722', '一段奶粉', '1482', '2', '0', 'full/b3efaa85d02e42ae47a74ab0f7f82f46babb5919.jpg', '/list/313006-0.html');
INSERT INTO `sp_category` VALUES ('723', '二段奶粉', '1482', '2', '0', 'full/e1b9d96edd873f99e11e277bdabb02a945b3dfc9.jpg', '/list/313007-0.html');
INSERT INTO `sp_category` VALUES ('724', '三段奶粉', '719', '2', '0', 'full/137925acb7e88a5dd88c765ad2b1dd2d1e44366a.jpg', '/list/313008-0.html');
INSERT INTO `sp_category` VALUES ('725', '四段奶粉', '719', '2', '0', 'full/581d1796bd1757322cd8ca8911a524bd9243f2bf.jpg', '/list/313009-0.html');
INSERT INTO `sp_category` VALUES ('726', '妈咪奶粉', '719', '2', '0', 'full/0fd5effab8c75d0c70f37f570273bbb6da6fba47.jpg', '/list/320504-0.html');
INSERT INTO `sp_category` VALUES ('727', '有机奶粉', '719', '2', '0', 'full/8475544bf0383fed78912bcd8ced981269204a5d.jpg', '//m.suning.com/search/有机奶粉/?adTypeCode=1023&adId=有机奶粉');
INSERT INTO `sp_category` VALUES ('728', '进口奶粉', '719', '2', '0', 'full/ead6c515529134e928250d70707cba3f5c726b7e.jpg', '/list/313005-123237.html');
INSERT INTO `sp_category` VALUES ('729', 'NB号', '1482', '2', '0', 'full/d6b23009a61603544c12a35d778ad0d421300424.jpg', '/list/362005-123434.html');
INSERT INTO `sp_category` VALUES ('730', '营养辅食', '710', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('731', 'S号', '721', '2', '0', 'full/a8c8e8edec68f421a1928098bef0b695f9fe7cac.jpg', '/list/313107-24615.html');
INSERT INTO `sp_category` VALUES ('732', 'M号', '721', '2', '0', 'full/8c2a737b3667760962710a13206655cda6f2847b.jpg', '/list/362005-24163.html');
INSERT INTO `sp_category` VALUES ('733', 'L号', '721', '2', '0', 'full/c4727bdaefd429d5db839f687df97a07616ee392.jpg', '/list/313107-24531.html');
INSERT INTO `sp_category` VALUES ('734', 'XL号', '721', '2', '0', 'full/2394e993e5a8c9ec15c36813d818f775b471939e.jpg', '/list/313107-1290982.html');
INSERT INTO `sp_category` VALUES ('735', 'XXL号', '721', '2', '0', 'full/c2b4b326bf03c78a3a6d19cf65d3181b9a87802a.jpg', '/list/313107-1291879.html');
INSERT INTO `sp_category` VALUES ('736', '拉拉裤', '721', '2', '0', 'full/4709334c1dc6aa721291701d32f2f5511714f270.jpg', '//m.suning.com/search/拉拉裤/?adTypeCode=1023&adId=拉拉裤');
INSERT INTO `sp_category` VALUES ('737', '纸尿片', '721', '2', '0', 'full/c628428891a777a44fb29f0fdc7c523e9d1d2ea9.jpg', '/list/313113-0.html');
INSERT INTO `sp_category` VALUES ('738', '湿巾', '721', '2', '0', 'full/a9df0218c28280a595e27658c404dab6f6f98156.jpg', '/list/362004-0.html');
INSERT INTO `sp_category` VALUES ('739', '米粉', '1482', '2', '0', 'full/90c243d6a801e1e15a787bdbd9b271a753a35dc2.jpg', '/list/313018-0.html');
INSERT INTO `sp_category` VALUES ('740', '洗护用品', '710', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('741', '果泥', '730', '2', '0', 'full/027eb6015bc92c9fc25e270652e520545b9aa4a8.jpg', '/list/313015-0.html');
INSERT INTO `sp_category` VALUES ('742', '果汁', '730', '2', '0', 'full/3be85527dd05c3f45c726aff87045a0e68f5d2b9.jpg', '/list/313016-0.html');
INSERT INTO `sp_category` VALUES ('743', '面食类', '730', '2', '0', 'full/47a0c59ae20973adec6a7e3a0186b4c34d3bfadc.jpg', '/list/313020-0.html');
INSERT INTO `sp_category` VALUES ('744', '肉松', '730', '2', '0', 'full/d19be697ed85d0c652a3ae4ccef1d9181b597489.jpg', '/list/313019-0.html');
INSERT INTO `sp_category` VALUES ('745', '饼干', '730', '2', '0', 'full/6c672c92676d0303edf2fc2992ab3038b453ec7a.jpg', '/list/313017-0.html');
INSERT INTO `sp_category` VALUES ('746', '宝宝零食', '730', '2', '0', 'full/7f1e49646547514095a3a63804aeb5e3dd2b0c2e.jpg', '/list/313021-0.html');
INSERT INTO `sp_category` VALUES ('747', '益生菌', '730', '2', '0', 'full/1d94a297a3c06b845997c79bf1b67acd222702d3.jpg', '/list/313028-0.html');
INSERT INTO `sp_category` VALUES ('748', 'DHA', '730', '2', '0', 'full/e016fa3b231cc87a5cdc776ca017bf0dcb1713fb.jpg', '/list/313033-0.html');
INSERT INTO `sp_category` VALUES ('749', '钙铁锌', '730', '2', '0', 'full/8498635064c479775d9d8aa2917e3c7b16bc24a5.jpg', '/list/313030-0.html');
INSERT INTO `sp_category` VALUES ('750', '牛初乳', '730', '2', '0', 'full/0103134255af27b172d1ca33d109b14aaf83ba83.jpg', '/list/340046-0.html');
INSERT INTO `sp_category` VALUES ('751', '免疫类', '730', '2', '0', 'full/cd62f1e69925bca0ad684db3a967e9bcb6d099d0.jpg', '/list/313026-0.html');
INSERT INTO `sp_category` VALUES ('752', '鱼肝油', '730', '2', '0', 'full/0a1d27b6a4618078361f560bc0a037abcb29f13f.jpg', '/list/313035-0.html');
INSERT INTO `sp_category` VALUES ('753', '维生素', '730', '2', '0', 'full/b68997636a5576e9d42971bfe402472c2bd5aa8f.jpg', '/list/313032-0.html');
INSERT INTO `sp_category` VALUES ('754', '营养素', '730', '2', '0', 'full/bd21679f5f9d2bb88b5c1e3cba858bc5b333048a.jpg', '/list/340047-0.html');
INSERT INTO `sp_category` VALUES ('755', '润肤乳', '1482', '2', '0', 'full/69e5341b3bbffb68c338e9263ed3d4beb59eeb60.jpg', '/list/365503-0.html');
INSERT INTO `sp_category` VALUES ('756', '洗发沐浴', '740', '2', '0', 'full/62fab4a70f8f941b2b52b1d7ce3197475dc07ef8.jpg', '/list/313090-0.html');
INSERT INTO `sp_category` VALUES ('757', '婴儿护肤', '740', '2', '0', 'full/42336463f4ac9f9ff079777a2b737bca86ff7343.jpg', '/list/313096-0.html');
INSERT INTO `sp_category` VALUES ('758', '洗衣液', '740', '2', '0', 'full/29348eb586bb9ffc1631defddfa7fd8e3ddc99c8.jpg', '/list/313100-0.html');
INSERT INTO `sp_category` VALUES ('759', '洗衣皂', '740', '2', '0', 'full/0f64d4be98969f04ac21dc694d5d648813ea9d07.jpg', '/list/313099-0.html');
INSERT INTO `sp_category` VALUES ('760', '喂养用品', '710', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('761', '套装礼盒', '740', '2', '0', 'full/f602f312b83b0d23f9ff7784787aea9608223fc3.jpg', '/list/369503-0.html');
INSERT INTO `sp_category` VALUES ('762', '婴儿护体', '740', '2', '0', 'full/217723a41dd8787c21ca82b05626f5efdbf0bef9.jpg', '/list/313094-0.html');
INSERT INTO `sp_category` VALUES ('763', '祛痱粉', '740', '2', '0', 'full/ea373ad974a8ee4df0deff58c06a6c00a808dca8.jpg', '/list/347507-0.html');
INSERT INTO `sp_category` VALUES ('764', '爽身粉', '740', '2', '0', 'full/304de7ded45243321882371f6d61a82780eedc97.jpg', '/list/347508-0.html');
INSERT INTO `sp_category` VALUES ('765', '防蚊/驱蚊', '740', '2', '0', 'full/a859c9e0ecaf88fb90a2b2eedb1ceb37ac3253cb.jpg', '/list/347512-0.html');
INSERT INTO `sp_category` VALUES ('766', '防晒', '740', '2', '0', 'full/4ae24ad0ed1beb77003ee2b28df8bf66c531ef50.jpg', '/list/347514-0.html');
INSERT INTO `sp_category` VALUES ('767', '口腔/鼻腔', '740', '2', '0', 'full/d5486a9e3658cbeb17a0d81867e147160d2fd661.jpg', '/list/313097-0.html');
INSERT INTO `sp_category` VALUES ('768', '奶瓶', '1482', '2', '0', 'full/d37343f0d57474d2bee33ad23f482720f8b5798e.jpg', '/list/313043-0.html');
INSERT INTO `sp_category` VALUES ('769', '奶嘴', '760', '2', '0', 'full/0a14ec061a561673f470fa7e7748ba15f31810e9.jpg', '/list/313045-0.html');
INSERT INTO `sp_category` VALUES ('770', '儿童餐具', '760', '2', '0', 'full/39b019adf1d18afefa27d1e7585f95f7f987885b.jpg', '/list/313049-0.html');
INSERT INTO `sp_category` VALUES ('771', '吸乳器', '760', '2', '0', 'full/ee15aab3ef5fe08fd877c9cc8fefd74c1cee35ce.jpg', '/list/313153-0.html');
INSERT INTO `sp_category` VALUES ('772', '辅食料理机', '760', '2', '0', 'full/4549deb3f89996f7db32a0fd0e696ba4bf788fab.jpg', '/list/313086-0.html');
INSERT INTO `sp_category` VALUES ('773', '辅助配件', '760', '2', '0', 'full/b487e6a4eca9eb49ffd9562ee4f8655fd7927f7f.jpg', '/list/313047-0.html');
INSERT INTO `sp_category` VALUES ('774', '浴室用品', '760', '2', '0', 'full/26ae7a3bd065d429043d2eb3fde27f57021a4553.jpg', '/list/313059-0.html');
INSERT INTO `sp_category` VALUES ('775', '日常用品', '760', '2', '0', 'full/5bc4e0bb918691278b2757c0a58c46eaea375df2.jpg', '/list/313072-0.html');
INSERT INTO `sp_category` VALUES ('776', '驱蚊用品', '760', '2', '0', 'full/e09595e839c9229fb74f3a26489502acbc749781.jpg', '/list/313069-0.html');
INSERT INTO `sp_category` VALUES ('777', '儿童玩具', '710', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('778', '儿童文具', '760', '2', '0', 'full/cb6dc3442da69f790fa3fa8159aefe4e909e7b4c.jpg', '/list/364009-0.html');
INSERT INTO `sp_category` VALUES ('779', '水杯/水壶', '760', '2', '0', 'full/386588a977a026d2cff6902a5d736a5eaab2c354.jpg', '/list/313046-0.html');
INSERT INTO `sp_category` VALUES ('780', '医护用品', '760', '2', '0', 'full/52a1e83d12b27f1146c1a497c0592be4867da966.jpg', '/list/313067-0.html');
INSERT INTO `sp_category` VALUES ('781', '安全防护', '760', '2', '0', 'full/a172851f6750cfddc550b3e7930075f540961532.jpg', '/list/313060-0.html');
INSERT INTO `sp_category` VALUES ('782', '消毒用品', '760', '2', '0', 'full/7a2ecb2d863693a32c9919967b3552819c753f14.jpg', '/list/316056-0.html');
INSERT INTO `sp_category` VALUES ('783', '保温用品', '760', '2', '0', 'full/452ecadcc82c33ccf165e4bca980c5205243deea.jpg', '/list/313058-0.html');
INSERT INTO `sp_category` VALUES ('784', '0至6月', '1482', '2', '0', 'full/6f9a0971c0df2eeafc2f234828ecd4b11f76140e.jpg', '/list/313118-25012.html');
INSERT INTO `sp_category` VALUES ('785', '6至12月', '777', '2', '0', 'full/a8cccef6e6a903120a098e9b0564692220e8be5d.jpg', '/list/313118-24050.html');
INSERT INTO `sp_category` VALUES ('786', '1至3岁', '777', '2', '0', 'full/67a9b14c71c2cdf46869d5a4afec3519bd69713a.jpg', '/list/313118-23542.html');
INSERT INTO `sp_category` VALUES ('787', '童车童床', '710', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('788', '3至6岁', '777', '2', '0', 'full/d69628ce1c34e96ec88f4a84292f9b3518ba0916.jpg', '/list/313118-24969.html');
INSERT INTO `sp_category` VALUES ('789', '6岁以上', '777', '2', '0', 'full/2f9f70d953bdef1e15bd33a9d0ff97398a882cf1.jpg', '/list/313118-22280.html');
INSERT INTO `sp_category` VALUES ('790', '益智玩具', '777', '2', '0', 'full/6d68ffdeffd05328b52c48bf0ffee024b2c023a1.jpg', '/list/313129-0.html');
INSERT INTO `sp_category` VALUES ('791', '户外玩具', '777', '2', '0', 'full/6fc63d79b31b3076960affaa7a90c2a227c171c9.jpg', '/list/315667-0.html');
INSERT INTO `sp_category` VALUES ('792', '积木拼插', '777', '2', '0', 'full/bd7b22e7a82f597076a58ad69b6430ae30dd6419.jpg', '/list/313128-0.html');
INSERT INTO `sp_category` VALUES ('793', '遥控航模', '777', '2', '0', 'full/78bd83169fd1b3ba291c657c20a3fa21741dfa78.jpg', '/list/317047-0.html');
INSERT INTO `sp_category` VALUES ('794', '毛绒玩具', '777', '2', '0', 'full/801e3e078ad03362cd8fb2d96bdfaed53f2b526b.jpg', '/list/313122-0.html');
INSERT INTO `sp_category` VALUES ('795', '动漫玩具', '777', '2', '0', 'full/21ea31a0cadc30d1d9751a1968d97f0c72ee8c7c.jpg', '/list/317055-0.html');
INSERT INTO `sp_category` VALUES ('796', '棋牌游戏', '777', '2', '0', 'full/182de769c3fca3f189e90333ac4b55e7d48ab085.jpg', '/list/317068-0.html');
INSERT INTO `sp_category` VALUES ('797', '手推车', '1482', '2', '0', 'full/ab6f96c92371d150be6801b76581f50304b447d4.jpg', '/list/315121-0.html');
INSERT INTO `sp_category` VALUES ('798', '婴儿床', '787', '2', '0', 'full/fe3d2ab07f3cd3c58d76deea911e37dee3455042.jpg', '/list/331003-0.html');
INSERT INTO `sp_category` VALUES ('799', '自行车', '787', '2', '0', 'full/43412f82e768868e7fab6ddf7279751415f0f269.jpg', '/list/315123-0.html');
INSERT INTO `sp_category` VALUES ('800', '电动车', '787', '2', '0', 'full/dc237aee7f194aef759025c10b902fd4ad51f960.jpg', '/list/315122-0.html');
INSERT INTO `sp_category` VALUES ('801', '妈妈专区', '710', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('802', '餐椅', '787', '2', '0', 'full/9d027cba2385d312a99b567f676fc503c09010a1.jpg', '/list/315131-0.html');
INSERT INTO `sp_category` VALUES ('803', '安全座椅', '787', '2', '0', 'full/d123b58979905b943dda254bdffe59df1902ed89.jpg', '/list/500314-0.html');
INSERT INTO `sp_category` VALUES ('804', '学步车', '787', '2', '0', 'full/5c4ec1c8e1a1772a918ca4a40afffe42e0ce6a0c.jpg', '/list/315125-0.html');
INSERT INTO `sp_category` VALUES ('805', '滑板车', '787', '2', '0', 'full/5db03a3606527aa978555cabcfcbc09a4cc148f3.jpg', '/list/315118-26581.html');
INSERT INTO `sp_category` VALUES ('806', '摇椅', '787', '2', '0', 'full/6b64d739cc2113c6e757fc495154df9802eaa466.jpg', '/list/315134-0.html');
INSERT INTO `sp_category` VALUES ('807', '防辐射服', '1482', '2', '0', 'full/f58aae1d5976ec3ab0a79323bc0fc57a35ced91b.jpg', '/list/315566-0.html');
INSERT INTO `sp_category` VALUES ('808', '孕妇服饰', '801', '2', '0', 'full/0b3071c6ee0387564848220a4cbf2fc76ce27ffa.jpg', '/list/315568-0.html');
INSERT INTO `sp_category` VALUES ('809', '妈妈内衣', '801', '2', '0', 'full/2f7dafc2eb5bce0bc4cdc3d5120a6cbb6813d439.jpg', '/list/315574-0.html');
INSERT INTO `sp_category` VALUES ('810', '孕妇枕', '801', '2', '0', 'full/5bebe430e1fc0dc04505963815e65b1555362005.jpg', '/list/315641-0.html');
INSERT INTO `sp_category` VALUES ('811', '妈咪鞋', '801', '2', '0', 'full/55b14d6ef813ff4f3a23afc2f249134b5e26e8fc.jpg', '/list/348004-0.html');
INSERT INTO `sp_category` VALUES ('812', '备孕待产', '801', '2', '0', 'full/e573bef30f7f1aed8994f8d128abc0f9da485fa6.jpg', '/list/315637-0.html');
INSERT INTO `sp_category` VALUES ('813', '妈咪包', '801', '2', '0', 'full/5420f5c62e24adad398c3cf1973ad07edc4bf36e.jpg', '/list/315656-0.html');
INSERT INTO `sp_category` VALUES ('814', '背婴带', '801', '2', '0', 'full/04dea0867d53cb26d4e41938cd14696ad50434a8.jpg', '/list/315657-0.html');
INSERT INTO `sp_category` VALUES ('815', '学步带', '801', '2', '0', 'full/2d38dea7fa3bcb231f8e792e6ea59f259ba11dc1.jpg', '/list/321503-0.html');
INSERT INTO `sp_category` VALUES ('816', '产后塑身', '801', '2', '0', 'full/66fac99bf6ef6da6d1ca0cf4e65971f447dbf7f4.jpg', '/list/315580-0.html');
INSERT INTO `sp_category` VALUES ('817', '产褥护理', '801', '2', '0', 'full/9df5940bcccef3fd76dfc1612678c8c30a2a16a2.jpg', '/list/315640-0.html');
INSERT INTO `sp_category` VALUES ('818', '品牌墙', '710', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('819', '妈咪洗护', '801', '2', '0', 'full/62cb3e6a82bd3012825439540370fc39d3af7747.jpg', '/list/313093-0.html');
INSERT INTO `sp_category` VALUES ('820', '月子餐', '801', '2', '0', 'full/251a4500c75543015756bff5328765dffc66ee04.jpg', '/list/459521-0.html');
INSERT INTO `sp_category` VALUES ('821', '亲子摄影', '801', '2', '0', 'full/bbf6b3542d100aee609668d7a34696e25fb1b843.jpg', '/list/500673-0.html');
INSERT INTO `sp_category` VALUES ('822', '孕妇摄影', '801', '2', '0', 'full/e2aeced84b80bc2be3fedbcaaabade9b4926726d.jpg', '//shop.m.suning.com/list/70142582_210159648_0_1.html?ctype=1');
INSERT INTO `sp_category` VALUES ('823', '美素佳儿', '1482', '2', '0', 'full/9a971252b4209cf5310aaf9ec98be029dff5a837.jpg', '/list/313005-43614.html');
INSERT INTO `sp_category` VALUES ('824', '雀巢', '818', '2', '0', 'full/b29b83152e85aed8795a2a3a9282978a239a4a23.jpg', '/list/313005-42301.html');
INSERT INTO `sp_category` VALUES ('825', '美赞臣', '818', '2', '0', 'full/295c6fcc4aec4e4199b52d27d86acbf24aaaeca9.jpg', '/list/313005-51312.html');
INSERT INTO `sp_category` VALUES ('826', '惠氏', '818', '2', '0', 'full/b3b123c17bde2d11125f59e43620d173eb9a2527.jpg', '/list/313005-19645.html');
INSERT INTO `sp_category` VALUES ('827', '爱他美', '818', '2', '0', 'full/43d94ab759c9feec413a635ce39b083dd31c5c06.jpg', '/list/313005-21541.html');
INSERT INTO `sp_category` VALUES ('828', '诺优能', '818', '2', '0', 'full/825e6b67ef2767826b0ecbafe3a9f36f90dd3d0f.jpg', '/list/313005-47753.html');
INSERT INTO `sp_category` VALUES ('829', '纽曼思', '818', '2', '0', 'full/b929c679c0dddc15eaa9b4f88645b399a3f137d3.jpg', '/list/313013-43310.html');
INSERT INTO `sp_category` VALUES ('830', '养生堂', '818', '2', '0', 'full/b3f8966370187c4eca427a9d9b21eb82b051199a.jpg', '/list/313013-11870.html');
INSERT INTO `sp_category` VALUES ('831', '英吉利', '818', '2', '0', 'full/163eeb69aabcc7a87b7d4b0a7518a4f676154a37.jpg', '/list/313013-49764.html');
INSERT INTO `sp_category` VALUES ('832', '亨氏', '818', '2', '0', 'full/0788f16d060833a2fbcba0a4658e540c0cc70839.jpg', '/list/313013-40461.html');
INSERT INTO `sp_category` VALUES ('833', '方广', '818', '2', '0', 'full/e545bf354517c7355991f94b12516057ab1131b3.jpg', '/list/313013-11210.html');
INSERT INTO `sp_category` VALUES ('834', '嘉宝', '818', '2', '0', 'full/11b736daa7c75516c8e541f6f8857ec7c6051bc8.jpg', '/list/313014-42219.html');
INSERT INTO `sp_category` VALUES ('835', '花王', '818', '2', '0', 'full/389cbb4c6c4795ecd32b095e0ed9126ad88955db.jpg', '/list/313107-216549.html');
INSERT INTO `sp_category` VALUES ('836', '尤妮佳', '818', '2', '0', 'full/c51755c46d389d03b5e335269f302670ba21e640.jpg', '/list/313107-118250.html');
INSERT INTO `sp_category` VALUES ('837', '好奇', '818', '2', '0', 'full/e561f67da51302479af188ec3d08a1d49826db55.jpg', '/list/313107-45518.html');
INSERT INTO `sp_category` VALUES ('838', '帮宝适', '818', '2', '0', 'full/07008e09c9ec8798ebffa0265e48f3990ee1cbd4.jpg', '/list/313107-43276.html');
INSERT INTO `sp_category` VALUES ('839', '安儿乐', '818', '2', '0', 'full/311206f8fa0afa6a9413d7d0de512d25d79ea1e2.jpg', '/list/313107-11260.html');
INSERT INTO `sp_category` VALUES ('840', '乐可爱', '818', '2', '0', 'full/388ccc2329c4882fcac4a168229acc0c1d5d77f5.jpg', '/list/313107-117738.html');
INSERT INTO `sp_category` VALUES ('841', '雀氏', '818', '2', '0', 'full/72d9c26339819f39a99c5cc1ce9dba9ad480ee6d.jpg', '/list/313107-11271.html');
INSERT INTO `sp_category` VALUES ('842', '妈咪宝贝', '818', '2', '0', 'full/0744ce9a2848b0bb4527a756f797fc75c0594701.jpg', '/list/313107-45517.html');
INSERT INTO `sp_category` VALUES ('843', '五羊', '818', '2', '0', 'full/fdfaa5e19a92cdfd5841b8064954587b8740a090.jpg', '/list/313107-13332.html');
INSERT INTO `sp_category` VALUES ('844', 'NUK', '818', '2', '0', 'full/addc1730ff4b2955fa3861aa44a6567be0ead3fc.jpg', '/list/313037-10368.html');
INSERT INTO `sp_category` VALUES ('845', '贝亲', '818', '2', '0', 'full/21687c34026768c2a58efe57832ca54874dd1178.jpg', '/list/313038-42169.html');
INSERT INTO `sp_category` VALUES ('846', '强生', '818', '2', '0', 'full/9b5c093d179692bd4fcdcf4507827f4a9cb170e8.jpg', '/list/313090-10220.html');
INSERT INTO `sp_category` VALUES ('847', '男装', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('849', '精选', '847', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('850', '木玩世家', '818', '2', '0', 'full/689868495b1fd7dae4ef94dfe4c2e643a16e812c.jpg', '/list/313118-10878.html');
INSERT INTO `sp_category` VALUES ('851', '奥迪双钻', '818', '2', '0', 'full/8c680abc31feefbeec1df517e66c264425b61ff2.jpg', '/list/313118-42156.html');
INSERT INTO `sp_category` VALUES ('852', '勾勾手', '818', '2', '0', 'full/bbfa027fc776370544a21ee8c9aeda70238abbda.jpg', '/list/313118-45829.html');
INSERT INTO `sp_category` VALUES ('853', '好孩子', '818', '2', '0', 'full/1cc417a6f0e2a557533182700c1ae46310a5fe9c.jpg', '/list/315118-826884.html');
INSERT INTO `sp_category` VALUES ('854', '爱贝丽', '818', '2', '0', 'full/86cd00acde4bdb0cc35bfbeb412cf8315b8436a2.jpg', '/list/315118-21932.html');
INSERT INTO `sp_category` VALUES ('855', '宝得适', '818', '2', '0', 'full/0b22e40cb6230290d3166c30db46c17858735974.jpg', '/list/500314-12649.html');
INSERT INTO `sp_category` VALUES ('856', '婧麒', '818', '2', '0', 'full/5c62964ed9c5c3d25b0819a411654f9f1f1615c8.jpg', '/list/315565-857463.html');
INSERT INTO `sp_category` VALUES ('857', '十月妈咪', '818', '2', '0', 'full/ded70aaf226331481948661bcac6a8eb76edf3c0.jpg', '/list/315565-16409.html');
INSERT INTO `sp_category` VALUES ('858', '添香', '818', '2', '0', 'full/37f23b818c3e035c1df9ce621cef4979b6044c82.jpg', '/list/315565-43303.html');
INSERT INTO `sp_category` VALUES ('859', '羽绒服', '1482', '2', '0', 'full/4075205fac095a93e65b63182227aa6979af9dfa.jpg', '//m.suning.com/search/羽绒服男/?adTypeCode=1023&adId=羽绒服男');
INSERT INTO `sp_category` VALUES ('860', '夹克', '1482', '2', '0', 'full/1212f818aa26bc4fb0cc114121985f9f6b861008.jpg', '//m.suning.com/search/夹克男/?adTypeCode=1023&adId=夹克男');
INSERT INTO `sp_category` VALUES ('861', '衬衫', '849', '2', '0', 'full/8c39fd72e20672eb7683ccdaeb2d6e6c7df9f4ca.jpg', '//m.suning.com/search/%E8%A1%AC%E8%A1%AB%E7%94%B7/?adTypeCode=1023&adId=%E8%A1%AC%E8%A1%AB%E7%94%B7');
INSERT INTO `sp_category` VALUES ('862', '针织衫', '849', '2', '0', 'full/5f2d4d93b8c6f06310d80aeacf165b5207e5b970.jpg', '//m.suning.com/search/针织衫男/?adTypeCode=1023&adId=针织衫男');
INSERT INTO `sp_category` VALUES ('863', '外套', '847', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('864', '毛呢大衣', '849', '2', '0', 'full/ddad9bb7ab6fce0e9517dba731e942e12418a57a.jpg', '//m.suning.com/search/大衣男/?adTypeCode=1023&adId=大衣男');
INSERT INTO `sp_category` VALUES ('865', '卫衣', '849', '2', '0', 'full/24f2881f915703f66b4e4137161631f3b2f6bf5f.jpg', '//m.suning.com/search/卫衣男/?adTypeCode=1023&adId=卫衣男');
INSERT INTO `sp_category` VALUES ('866', '皮衣', '849', '2', '0', 'full/bacb9fd9812d3ca3a30a8d0149d6b616e8f62b1e.jpg', '//m.suning.com/search/皮衣男/?adTypeCode=1023&adId=皮衣男');
INSERT INTO `sp_category` VALUES ('867', '休闲裤', '849', '2', '0', 'full/589c2f8b0618d5695159d95c1d0011c1041cba8c.jpg', '//m.suning.com/search/休闲裤男/?adTypeCode=1023&adId=休闲裤男');
INSERT INTO `sp_category` VALUES ('868', '牛仔裤', '849', '2', '0', 'full/d9ba821bd45fe32b69043d4375ee752043f717b2.jpg', '//m.suning.com/search/牛仔裤男/?adTypeCode=1023&adId=牛仔裤男');
INSERT INTO `sp_category` VALUES ('869', '风衣', '849', '2', '0', 'full/18aa2106e00559f4cd9975b74b6298c838f4a583.jpg', '//m.suning.com/search/男士风衣/?adTypeCode=1023&adId=男士风衣');
INSERT INTO `sp_category` VALUES ('870', '男士西服', '849', '2', '0', 'full/8f94936a15a19cd9daf6685328f3badd31784bc7.jpg', '//m.suning.com/search/西服男/?adTypeCode=1023&adId=西服男');
INSERT INTO `sp_category` VALUES ('871', '男士内搭', '847', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('872', '男士裤装', '847', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('873', '品牌墙', '847', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('874', '夹克', '863', '2', '0', 'full/1212f818aa26bc4fb0cc114121985f9f6b861008.jpg', '//m.suning.com/search/夹克男/?adTypeCode=1023&adId=夹克男');
INSERT INTO `sp_category` VALUES ('875', '风衣', '863', '2', '0', 'full/18aa2106e00559f4cd9975b74b6298c838f4a583.jpg', '//m.suning.com/search/男士风衣/?adTypeCode=1023&adId=男士风衣');
INSERT INTO `sp_category` VALUES ('876', '大衣', '863', '2', '0', 'full/ddad9bb7ab6fce0e9517dba731e942e12418a57a.jpg', '//m.suning.com/search/大衣男/?adTypeCode=1023&adId=大衣男');
INSERT INTO `sp_category` VALUES ('877', '皮衣', '863', '2', '0', 'full/bacb9fd9812d3ca3a30a8d0149d6b616e8f62b1e.jpg', '//m.suning.com/search/皮衣男/?adTypeCode=1023&adId=皮衣男');
INSERT INTO `sp_category` VALUES ('878', '西服套装', '863', '2', '0', 'full/8f94936a15a19cd9daf6685328f3badd31784bc7.jpg', '//m.suning.com/search/西服男/?adTypeCode=1023&adId=西服男');
INSERT INTO `sp_category` VALUES ('879', '针织衫', '1482', '2', '0', 'full/5f2d4d93b8c6f06310d80aeacf165b5207e5b970.jpg', '//m.suning.com/search/针织衫男/?adTypeCode=1023&adId=针织衫男');
INSERT INTO `sp_category` VALUES ('880', '卫衣', '871', '2', '0', 'full/24f2881f915703f66b4e4137161631f3b2f6bf5f.jpg', '//m.suning.com/search/卫衣男/?adTypeCode=1023&adId=卫衣男');
INSERT INTO `sp_category` VALUES ('881', '衬衫', '871', '2', '0', 'full/8c39fd72e20672eb7683ccdaeb2d6e6c7df9f4ca.jpg', '//m.suning.com/search/%E8%A1%AC%E8%A1%AB%E7%94%B7/?adTypeCode=1023&adId=%E8%A1%AC%E8%A1%AB%E7%94%B7');
INSERT INTO `sp_category` VALUES ('882', 'T恤', '871', '2', '0', 'full/141cf173be5efc139da1eb5f18cbd9d862ed0081.jpg', '//m.suning.com/search/T恤男/?adTypeCode=1023&adId=T恤男');
INSERT INTO `sp_category` VALUES ('883', '牛仔裤', '1482', '2', '0', 'full/d9ba821bd45fe32b69043d4375ee752043f717b2.jpg', '//m.suning.com/search/牛仔裤男/?adTypeCode=1023&adId=牛仔裤男');
INSERT INTO `sp_category` VALUES ('884', '休闲裤', '872', '2', '0', 'full/589c2f8b0618d5695159d95c1d0011c1041cba8c.jpg', '//m.suning.com/search/休闲裤男/?adTypeCode=1023&adId=休闲裤男');
INSERT INTO `sp_category` VALUES ('885', '西裤', '872', '2', '0', 'full/3671f70633c5ea82a8c2434302624d3553d49bd1.jpg', '//m.suning.com/search/西裤男/?adTypeCode=1023&adId=西裤男');
INSERT INTO `sp_category` VALUES ('886', '七匹狼', '1482', '2', '0', 'full/05ef066df5acee2caac730061e4d10f42bc26bcf.jpg', '//m.suning.com/search/七匹狼/?adTypeCode=1023&adId=七匹狼');
INSERT INTO `sp_category` VALUES ('887', '千纸鹤', '873', '2', '0', 'full/b8033acb2e7a61ef673caca80daf43cfc72ed868.jpg', '//m.suning.com/search/千纸鹤/?adTypeCode=1023&adId=千纸鹤');
INSERT INTO `sp_category` VALUES ('888', '利郎', '873', '2', '0', 'full/1a102a470ed2c1463d5e54246ca02f049a199916.jpg', '//m.suning.com/search/利郎/?adTypeCode=1023&adId=利郎');
INSERT INTO `sp_category` VALUES ('889', '雅戈尔', '873', '2', '0', 'full/d5e7421912b3865efbf68c8f041f5a14cbde81b3.jpg', '//m.suning.com/search/雅戈尔/?adTypeCode=1023&adId=雅戈尔');
INSERT INTO `sp_category` VALUES ('890', '红豆男装', '873', '2', '0', 'full/b0d854796e6ac9df72398ffe6d5f7e0c19e6725d.jpg', '//m.suning.com/search/红豆男装/?adTypeCode=1023&adId=红豆男装');
INSERT INTO `sp_category` VALUES ('891', '才子', '873', '2', '0', 'full/92925629cd634fd0f8159a39062be87d7605a38e.jpg', '//m.suning.com/search/%E6%89%8D%E5%AD%90/?adTypeCode=1023&adId=%E6%89%8D%E5%AD%90');
INSERT INTO `sp_category` VALUES ('892', '男鞋', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('893', '柒牌', '873', '2', '0', 'full/2898907286954f8ddfb71281d3182b49f29bf869.jpg', '//m.suning.com/search/柒牌/?adTypeCode=1023&adId=柒牌');
INSERT INTO `sp_category` VALUES ('894', '罗蒙', '873', '2', '0', 'full/a5d3741b371fca1b564cabc248db440bab70eb76.jpg', '//m.suning.com/search/罗蒙/?adTypeCode=1023&adId=罗蒙');
INSERT INTO `sp_category` VALUES ('895', '美特斯邦威', '873', '2', '0', 'full/a356c206080ab81b30d0aaa634f964d2169c6b3d.jpg', '//m.suning.com/search/美特斯邦威/?adTypeCode=1023&adId=美特斯邦威');
INSERT INTO `sp_category` VALUES ('897', '时尚男鞋', '892', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('898', '马克华菲', '873', '2', '0', 'full/ffe16db2c84cf42e2de154decc5231fa86a1f188.jpg', '//m.suning.com/search/马克华菲/?adTypeCode=1023&adId=马克华菲');
INSERT INTO `sp_category` VALUES ('899', '木林森', '873', '2', '0', 'full/57d8bc1b65391b4dcb7c4190fbd6133f3afeb488.jpg', '//m.suning.com/search/木林森/?adTypeCode=1023&adId=木林森');
INSERT INTO `sp_category` VALUES ('900', '骆驼', '873', '2', '0', 'full/fd7549f1e77aae771204acc77e7b8f66cb58d199.jpg', '//m.suning.com/search/骆驼/?adTypeCode=1023&adId=骆驼');
INSERT INTO `sp_category` VALUES ('901', '品牌墙', '892', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('902', '男士休闲鞋', '1482', '2', '0', 'full/53cbbaee35c128241282ef7d01db3bfdd173ef33.jpg', '//m.suning.com/search/%E4%BC%91%E9%97%B2%E9%9E%8B%E7%94%B7/?adTypeCode=1023&adId=%E4%BC%91%E9%97%B2%E9%9E%8B%E7%94%B7');
INSERT INTO `sp_category` VALUES ('903', '商务鞋', '1482', '2', '0', 'full/fb23f111ae112defcbc34ac75ef35830e52a787d.jpg', '//m.suning.com/search/商务鞋/?adTypeCode=1023&adId=商务鞋');
INSERT INTO `sp_category` VALUES ('904', '女装', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('905', '男靴', '897', '2', '0', 'full/280cc08d621e5ae6599ddee50630afe4b0cc6a83.jpg', '//m.suning.com/search/男靴/?adTypeCode=1023&adId=男靴');
INSERT INTO `sp_category` VALUES ('906', '精选', '904', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('907', '工装鞋', '897', '2', '0', 'full/d83fd87699b100724dd9909f2415b9996f38b591.jpg', '//m.suning.com/search/工装鞋/?adTypeCode=1023&adId=工装鞋');
INSERT INTO `sp_category` VALUES ('908', '男帆布鞋', '897', '2', '0', 'full/79ec853f4f6c17a7c7dab3e2627728b818114fa3.jpg', '//m.suning.com/search/%E5%B8%86%E5%B8%83%E9%9E%8B%E7%94%B7/?adTypeCode=1023&adId=%E5%B8%86%E5%B8%83%E9%9E%8B%E7%94%B7');
INSERT INTO `sp_category` VALUES ('909', '布洛克鞋', '897', '2', '0', 'full/dc6bc569befff0f9de28bab647bd60ec88aaa79e.jpg', '//m.suning.com/search/%E5%B8%83%E6%B4%9B%E5%85%8B%E9%9E%8B%E7%94%B7/?adTypeCode=1023&adId=%E5%B8%83%E6%B4%9B%E5%85%8B%E9%9E%8B%E7%94%B7');
INSERT INTO `sp_category` VALUES ('910', '懒人鞋', '897', '2', '0', 'full/c13e99e75d0eed9b7021f2d0425b4409a6d06472.jpg', '//m.suning.com/search/%E6%87%92%E4%BA%BA%E9%9E%8B%E7%94%B7/?adTypeCode=1023&adId=%E6%87%92%E4%BA%BA%E9%9E%8B%E7%94%B7');
INSERT INTO `sp_category` VALUES ('911', '圆头皮鞋', '897', '2', '0', 'full/2791f317a2541627abe729228f180803a69239ed.jpg', '//m.suning.com/search/%E5%9C%86%E5%A4%B4%E7%9A%AE%E9%9E%8B%E7%94%B7/?adTypeCode=1023&adId=%E5%9C%86%E5%A4%B4%E7%9A%AE%E9%9E%8B%E7%94%B7');
INSERT INTO `sp_category` VALUES ('912', '潮流女装', '904', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('913', '尖头皮鞋', '897', '2', '0', 'full/a77598175859972401eedd9e2d25b3431db0bd0f.jpg', '//m.suning.com/search/%E5%B0%96%E5%A4%B4%E7%9A%AE%E9%9E%8B%E7%94%B7/?adTypeCode=1023&adId=%E5%B0%96%E5%A4%B4%E7%9A%AE%E9%9E%8B%E7%94%B7');
INSERT INTO `sp_category` VALUES ('914', '森达', '1482', '2', '0', 'full/29f485dcd6bbf7821c909cef70252b770ca0778d.jpg', 'https://m.suning.com/search/森达/?adTypeCode=1023&adId=森达');
INSERT INTO `sp_category` VALUES ('915', '奥康', '901', '2', '0', 'full/7200a383ce43562e87229165e75d02cb4746f4cd.jpg', '//m.suning.com/search/奥康/?adTypeCode=1023&adId=奥康');
INSERT INTO `sp_category` VALUES ('916', '强人', '901', '2', '0', 'full/cdb6019d72338c72218ac3a5e1a439374a7faaa4.jpg', '//m.suning.com/search/强人/?adTypeCode=1023&adId=强人');
INSERT INTO `sp_category` VALUES ('917', '骆驼', '901', '2', '0', 'full/fd7549f1e77aae771204acc77e7b8f66cb58d199.jpg', '//m.suning.com/search/骆驼/?adTypeCode=1023&adId=骆驼');
INSERT INTO `sp_category` VALUES ('918', '木林森', '901', '2', '0', 'full/57d8bc1b65391b4dcb7c4190fbd6133f3afeb488.jpg', '//m.suning.com/search/木林森/?adTypeCode=1023&adId=木林森');
INSERT INTO `sp_category` VALUES ('919', '花花公子', '901', '2', '0', 'full/5d26457e65290f6f59e2e710700ba8149c472375.jpg', '//m.suning.com/search/花花公子/?adTypeCode=1023&adId=花花公子');
INSERT INTO `sp_category` VALUES ('920', '利郎', '901', '2', '0', 'full/1a102a470ed2c1463d5e54246ca02f049a199916.jpg', '//m.suning.com/search/利郎/?adTypeCode=1023&adId=利郎');
INSERT INTO `sp_category` VALUES ('921', '雅戈尔', '901', '2', '0', 'full/d5e7421912b3865efbf68c8f041f5a14cbde81b3.jpg', '//m.suning.com/search/雅戈尔/?adTypeCode=1023&adId=雅戈尔');
INSERT INTO `sp_category` VALUES ('922', '才子', '901', '2', '0', 'full/92925629cd634fd0f8159a39062be87d7605a38e.jpg', '//m.suning.com/search/才子男鞋/?adTypeCode=1023&adId=才子男鞋');
INSERT INTO `sp_category` VALUES ('923', '羽绒服', '848', '2', '0', 'full/797808fbd2af0618e6c529ff2a0d566ad0a45354.jpg', '/list/346882-0.html');
INSERT INTO `sp_category` VALUES ('924', '连衣裙', '1482', '2', '0', 'full/7584cf166a071b251c9827915e910af6b45be4e7.jpg', '//m.suning.com/search/连衣裙/?adTypeCode=1023&adId=连衣裙');
INSERT INTO `sp_category` VALUES ('925', '毛呢大衣', '906', '2', '0', 'full/abf2d7438657868095850064e3179ead587e86fb.jpg', '//m.suning.com/search/大衣女/?adTypeCode=1023&adId=大衣女');
INSERT INTO `sp_category` VALUES ('926', '卫衣', '912', '2', '0', 'full/ff4053cad62fb77359083d642ce53d3583b0da1e.jpg', '//m.suning.com/search/女士卫衣/?adTypeCode=1023&adId=女士卫衣');
INSERT INTO `sp_category` VALUES ('927', '品牌墙', '904', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('928', '棉服', '912', '2', '0', 'full/e2da8d14f735eea48763a6abc6f04f794b25f6fb.jpg', '//m.suning.com/search/%E6%A3%89%E6%9C%8D%E5%A5%B3/?adTypeCode=1023&adId=%E6%A3%89%E6%9C%8D%E5%A5%B3');
INSERT INTO `sp_category` VALUES ('929', '短外套', '912', '2', '0', 'full/a5a0ba5eb45b20a3865755a4fa71ad87924b7bdf.jpg', '//m.suning.com/search/短外套秋/?adTypeCode=1023&adId=短外套秋');
INSERT INTO `sp_category` VALUES ('930', '半身裙', '912', '2', '0', 'full/3dfeb40ec5e6741a174be07c9239e1477bfb34b8.jpg', '//m.suning.com/search/半身裙秋冬/?adTypeCode=1023&adId=半身裙秋冬');
INSERT INTO `sp_category` VALUES ('931', '牛仔外套', '912', '2', '0', 'full/4e9089a51631417646cf4c3987e9b757718e20d1.jpg', '//m.suning.com/search/牛仔外套女/?adTypeCode=1023&adId=牛仔外套女');
INSERT INTO `sp_category` VALUES ('932', '风衣', '912', '2', '0', 'full/f4ba9be1dc2c64699becaa299d2450a15c09639d.jpg', '//m.suning.com/search/风衣女/?adTypeCode=1023&adId=风衣女');
INSERT INTO `sp_category` VALUES ('933', '牛仔裤', '912', '2', '0', 'full/0d81ff4f121a4829f77b0adbcc1baac3d71e3ae4.jpg', '//m.suning.com/search/牛仔裤女/?adTypeCode=1023&adId=牛仔裤女');
INSERT INTO `sp_category` VALUES ('934', '皮草', '912', '2', '0', 'full/8b9ce75a952e128e04d08fd22b7bdd94e308dfcb.jpg', '//m.suning.com/search/%E7%9A%AE%E8%8D%89%E5%A5%B3/?adTypeCode=1023&adId=%E7%9A%AE%E8%8D%89%E5%A5%B3');
INSERT INTO `sp_category` VALUES ('935', '皮衣', '912', '2', '0', 'full/706de70a8e62a4dd7c7f119878026cae430b36a0.jpg', '//m.suning.com/search/皮衣女/?adTypeCode=1023&adId=皮衣女');
INSERT INTO `sp_category` VALUES ('936', '衬衫', '912', '2', '0', 'full/9b8c8b2d882e5ce47574d7611788d440025b0a63.jpg', '//m.suning.com/search/衬衫女/?adTypeCode=1023&adId=衬衫女');
INSERT INTO `sp_category` VALUES ('937', '马甲', '912', '2', '0', 'full/cb45f0202678c335e72a94952ead29cf1265935f.jpg', '//m.suning.com/search/马甲女/?adTypeCode=1023&adId=马甲女');
INSERT INTO `sp_category` VALUES ('938', '女鞋', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('939', '打底裤', '912', '2', '0', 'full/f720ea3f1a36ed7f66aa395138d5a6bea2367a7c.jpg', '/list/289517-0.html');
INSERT INTO `sp_category` VALUES ('940', '婚纱礼服', '912', '2', '0', 'full/521dd216b359ad1833851f43917704cbffd29dd0.jpg', '//m.suning.com/search/婚纱礼服/?adTypeCode=1023&adId=婚纱礼服');
INSERT INTO `sp_category` VALUES ('941', '西服', '912', '2', '0', 'full/c84174b1235416aae59af1ee805594f2a31abe3f.jpg', '//m.suning.com/search/西服女/?adTypeCode=1023&adId=西服女');
INSERT INTO `sp_category` VALUES ('942', '裂帛', '1482', '2', '0', 'full/410520ca7c4589c4e20d4182dc7e738b7cb93d65.jpg', '//m.suning.com/search/%E8%A3%82%E5%B8%9B/?adTypeCode=1023&adId=%E8%A3%82%E5%B8%9B');
INSERT INTO `sp_category` VALUES ('943', '茵曼', '927', '2', '0', 'full/e4a420f6ddbfc3219f93d14895a680a70e8dd207.jpg', '//m.suning.com/search/茵曼/?adTypeCode=1023&adId=茵曼');
INSERT INTO `sp_category` VALUES ('944', '纤莉秀', '927', '2', '0', 'full/c634f871937d913f678e8b1b840b9e755aaa7a38.jpg', '//m.suning.com/search/%E7%BA%A4%E8%8E%89%E7%A7%80%E7%A7%8B/?adTypeCode=1023&adId=%E7%BA%A4%E8%8E%89%E7%A7%80%E7%A7%8B');
INSERT INTO `sp_category` VALUES ('945', '韩都衣舍', '927', '2', '0', 'full/66d8305c81210a28c6b2193b7f46ce8d66c9db5b.jpg', '//m.suning.com/search/%E9%9F%A9%E9%83%BD%E8%A1%A3%E8%88%8D/?adTypeCode=1023&adId=%E9%9F%A9%E9%83%BD%E8%A1%A3%E8%88%8D');
INSERT INTO `sp_category` VALUES ('947', '烟花烫', '927', '2', '0', 'full/b8461024a4f19a91bc5959d0ce08902983ea670f.jpg', '//m.suning.com/search/%E7%83%9F%E8%8A%B1%E7%83%AB/?adTypeCode=1023&adId=%E7%83%9F%E8%8A%B1%E7%83%AB');
INSERT INTO `sp_category` VALUES ('948', '熙世界', '927', '2', '0', 'full/5d230194c83d1d5ff53cf15ae5dd91ba449243e0.jpg', '//m.suning.com/search/熙世界/?adTypeCode=1023&adId=熙世界');
INSERT INTO `sp_category` VALUES ('949', '佐露丝', '927', '2', '0', 'full/7edfa348fb1cb95bfd82d7aa03ee011bb4b40f21.jpg', '//m.suning.com/search/佐露丝/?adTypeCode=1023&adId=佐露丝');
INSERT INTO `sp_category` VALUES ('950', '时尚女鞋', '938', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('951', '初语', '927', '2', '0', 'full/95ed43f638a06139b8f01e79497ed8b0724b8a61.jpg', '//m.suning.com/search/初语/?adTypeCode=1023&adId=初语');
INSERT INTO `sp_category` VALUES ('952', '品牌墙', '938', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('953', '高跟鞋', '1482', '2', '0', 'full/27ed67c973093b29f12f255463d4eb6c5f10109a.jpg', '//m.suning.com/search/%E9%AB%98%E8%B7%9F%E9%9E%8B/?adTypeCode=1023&adId=%E9%AB%98%E8%B7%9F%E9%9E%8B');
INSERT INTO `sp_category` VALUES ('954', '汽车生活', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('956', '汽车整车', '954', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('957', '单鞋', '1482', '2', '0', 'full/2b7344c81244755396f41cd19fde0111add4da73.jpg', '//m.suning.com/search/单鞋女/?adTypeCode=1023&adId=单鞋女');
INSERT INTO `sp_category` VALUES ('958', '养护配件', '954', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('959', '马丁靴', '950', '2', '0', 'full/f46068eda7d1e701311239a793b1acd7f0e02f63.jpg', '//m.suning.com/search/%E9%A9%AC%E4%B8%81%E9%9D%B4%E5%A5%B3/?adTypeCode=1023&adId=%E9%A9%AC%E4%B8%81%E9%9D%B4%E5%A5%B3');
INSERT INTO `sp_category` VALUES ('960', '雪地靴', '950', '2', '0', 'full/0acb4b9db3f08d5c8f93ee1c0e053f108fefa473.jpg', '//m.suning.com/search/雪地靴/?adTypeCode=1023&adId=雪地靴');
INSERT INTO `sp_category` VALUES ('961', '帆布鞋', '950', '2', '0', 'full/8be040151728b62a420689115d75da97db6e4d1f.jpg', '//m.suning.com/search/%E5%B8%86%E5%B8%83%E9%9E%8B%E5%A5%B3/?adTypeCode=1023&adId=%E5%B8%86%E5%B8%83%E9%9E%8B%E5%A5%B3');
INSERT INTO `sp_category` VALUES ('962', '短靴', '950', '2', '0', 'full/2354806762f25093443bc86aac872339f304dda4.jpg', '//m.suning.com/search/短靴女/?adTypeCode=1023&adId=短靴女');
INSERT INTO `sp_category` VALUES ('963', '休闲鞋', '950', '2', '0', 'full/70823754a20647abead29b0707b0be404a79a31e.jpg', '//m.suning.com/search/休闲鞋女/?adTypeCode=1023&adId=休闲鞋女');
INSERT INTO `sp_category` VALUES ('964', '拖鞋', '950', '2', '0', 'full/ada90f68e8d3dc4a43f64d899cdb346888a8478c.jpg', '//m.suning.com/search/%E6%A3%89%E6%8B%96%E5%A5%B3/?adTypeCode=1023&adId=%E6%A3%89%E6%8B%96%E5%A5%B3');
INSERT INTO `sp_category` VALUES ('965', '长靴', '950', '2', '0', 'full/d337e325ac85715b52491f879be8b677b87cb093.jpg', '//m.suning.com/search/%E9%95%BF%E9%9D%B4/?adTypeCode=1023&adId=%E9%95%BF%E9%9D%B4');
INSERT INTO `sp_category` VALUES ('966', '百丽', '1482', '2', '0', 'full/5ba49572d13ec9269c6c9b2e372d2af183973a8b.jpg', 'https://m.suning.com/search/百丽/?adTypeCode=1023&adId=百丽');
INSERT INTO `sp_category` VALUES ('967', '他她', '952', '2', '0', 'full/5dd4a77f2357b2e6e92d888ee4191a5455448d1b.jpg', 'https://m.suning.com/search/他她/?adTypeCode=1023&adId=他她');
INSERT INTO `sp_category` VALUES ('968', '天美意', '952', '2', '0', 'full/f6198e2ae74dadf54c32f1cdd9d339b54bce1f15.jpg', 'https://m.suning.com/search/天美意/?adTypeCode=1023&adId=天美意');
INSERT INTO `sp_category` VALUES ('969', '红蜻蜓', '952', '2', '0', 'full/ad4e5a8febb420b208769b229a4d5db06b85021f.jpg', '//m.suning.com/search/红蜻蜓女鞋/?adTypeCode=1023&adId=红蜻蜓女鞋');
INSERT INTO `sp_category` VALUES ('970', '汽车', '1482', '2', '0', 'full/892fab8290f4f3c4d3d5cc8dd9e7320bad722ea6.jpg', '/list/344370-0.html');
INSERT INTO `sp_category` VALUES ('971', '摩托车', '1482', '2', '0', 'full/6029499b6553eb88bb320c1011f821abac77a4b4.jpg', '/list/344257-0.html');
INSERT INTO `sp_category` VALUES ('972', '平安车管家', '956', '2', '0', 'full/9de72570659becc6314ce487bd77bd7b23f129a8.jpg', '//shop.m.suning.com/70167639.html');
INSERT INTO `sp_category` VALUES ('973', '机油', '1482', '2', '0', 'full/1502770271955c8b28b825f939ed0c727e1c7c91.jpg', '/list/344326-0.html');
INSERT INTO `sp_category` VALUES ('974', '燃油添加剂', '958', '2', '0', 'full/4618e2a5ab98acb15dfcf2becb731afc92b1c82e.jpg', '/list/344327-0.html');
INSERT INTO `sp_category` VALUES ('975', '清洁美容', '954', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('976', '加油卡', '958', '2', '0', 'full/0df0b6827f0f42c24a09cd3826d5e16d391b8ad2.jpg', '/list/500016-0.html');
INSERT INTO `sp_category` VALUES ('977', '汽车电子', '954', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('978', '车载吸尘器', '958', '2', '0', 'full/921cb0884dda901aed8d4f18f8092549f89db878.jpg', '/list/344270-0.html');
INSERT INTO `sp_category` VALUES ('979', '电瓶', '958', '2', '0', 'full/37a0b4c33720bee85d297812b7ddaafab9697125.jpg', '/list/344346-0.html');
INSERT INTO `sp_category` VALUES ('980', '雨刷', '958', '2', '0', 'full/23ff966509f8a5352a40813d707c7cc4b7535d10.jpg', '/list/344337-0.html');
INSERT INTO `sp_category` VALUES ('981', '滤清器', '958', '2', '0', 'full/6d8e673499288585eb11d2d439782e1c4e77c277.jpg', '/list/344339-0.html');
INSERT INTO `sp_category` VALUES ('982', '刹车片', '958', '2', '0', 'full/551189cc5e1ed34e08391ec91aaec5b9e90fc633.jpg', '/list/344341-0.html');
INSERT INTO `sp_category` VALUES ('983', '轮胎', '958', '2', '0', 'full/7113982805f54b3ea1dd3202e22649b844dd488f.jpg', '/list/344343-0.html');
INSERT INTO `sp_category` VALUES ('984', '汽车装饰', '954', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('985', '火花塞', '958', '2', '0', 'full/deb35984fb48956da0460233b176262207003105.jpg', '/list/344340-0.html');
INSERT INTO `sp_category` VALUES ('986', '胎压监测', '958', '2', '0', 'full/1abbdf4e9533ed2dce85db52fba0503261be40bd.jpg', '/list/344273-0.html');
INSERT INTO `sp_category` VALUES ('987', '手机支架', '958', '2', '0', 'full/4dfc9a710be3ef5e38c93d5db3e7566910351597.jpg', '/list/344316-0.html');
INSERT INTO `sp_category` VALUES ('988', '洗车机', '1482', '2', '0', 'full/ae4cc21a373379cd4219eb5c976809ae6b86df22.jpg', '/list/344331-0.html');
INSERT INTO `sp_category` VALUES ('989', '玻璃水', '975', '2', '0', 'full/76e63c250bd679833ba4afd5293f600402b5e896.jpg', '/list/344334-0.html');
INSERT INTO `sp_category` VALUES ('990', '漆面修复', '975', '2', '0', 'full/183caef3968ee5649f2332f4f21b56dc7e166329.jpg', '/list/344333-0.html');
INSERT INTO `sp_category` VALUES ('991', '车蜡', '975', '2', '0', 'full/fcb45f81246a7b178b882e7dc6d3a166bb4706c8.jpg', '/list/344332-0.html');
INSERT INTO `sp_category` VALUES ('992', '内饰清洁', '975', '2', '0', 'full/749ac373cee7bfc05b9836ec431fd9335eff0de7.jpg', '/list/344335-0.html');
INSERT INTO `sp_category` VALUES ('993', '清洁工具', '975', '2', '0', 'full/0b18afc30f42220d6fc872f8a652de831b8d36e7.jpg', '/list/344336-0.html');
INSERT INTO `sp_category` VALUES ('994', '行车记录仪', '1482', '2', '0', 'full/ccf9922cb65a9f0f489145daa8ced2cde19d9df0.jpg', '/list/344259-0.html');
INSERT INTO `sp_category` VALUES ('995', '电子狗', '977', '2', '0', 'full/8328348fd256b6583c1f4e7588fd9fad34c77f53.jpg', '/list/344272-0.html');
INSERT INTO `sp_category` VALUES ('996', '车载冰箱', '977', '2', '0', 'full/5ea44a11dc9694c832fd201bdd2585290f1f6906.jpg', '/list/344271-0.html');
INSERT INTO `sp_category` VALUES ('997', '车载电源', '977', '2', '0', 'full/507a025286a33c9570b06544b68d2284b51f656b.jpg', '/list/344279-0.html');
INSERT INTO `sp_category` VALUES ('998', '车载空气净化器', '977', '2', '0', 'full/c20b19014a4f2dda83d2d70d4131d5ca508f0677.jpg', '/list/344262-0.html');
INSERT INTO `sp_category` VALUES ('999', '车衣', '1482', '2', '0', 'full/7e65d32910660e027269bbdba5070147f2e74d7c.jpg', '/list/344362-0.html');
INSERT INTO `sp_category` VALUES ('1000', '运动户外', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('1001', '热门推荐', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1002', '挂饰/摆饰', '984', '2', '0', 'full/63b52cac198ca15bc90e9852b4794096af1b3787.jpg', '/list/344314-0.html');
INSERT INTO `sp_category` VALUES ('1003', '汽车脚垫', '984', '2', '0', 'full/e320206297fcab6eadae7840f95cebcb868091f0.jpg', '/list/344305-0.html');
INSERT INTO `sp_category` VALUES ('1004', '运动服饰', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1005', '抱枕/腰靠', '984', '2', '0', 'full/e290c420b374137d20424b963c6aae3d4f051063.jpg', '/list/344318-0.html');
INSERT INTO `sp_category` VALUES ('1006', '安全座椅', '984', '2', '0', 'full/85477a7a29d618db6e96307c7d4cc9a6d07cf290.jpg', '/list/501421-0.html');
INSERT INTO `sp_category` VALUES ('1007', '汽车坐垫', '984', '2', '0', 'full/f123ee4f9c0da29b04db0bbe725adb1cccab0c0c.jpg', '/list/344289-0.html');
INSERT INTO `sp_category` VALUES ('1008', '冲锋衣', '52', '2', '0', 'full/dec71b02fc79cd5c3cf2f596f5fc40f2ae90ba15.jpg', '//m.suning.com/search/冲锋衣/?adTypeCode=1023&adId=冲锋衣');
INSERT INTO `sp_category` VALUES ('1009', '跑步鞋', '1482', '2', '0', 'full/889067de6290cc8081bc811b6ba30a40bd4b37cf.jpg', '//m.suning.com/search/跑步鞋/?adTypeCode=1023&adId=跑步鞋');
INSERT INTO `sp_category` VALUES ('1010', '哑铃', '1001', '2', '0', 'full/6783ce1dd0b6c45a63fbbf2aea781affbd7c2da3.jpg', '//m.suning.com/search/哑铃/?adTypeCode=1023&adId=哑铃');
INSERT INTO `sp_category` VALUES ('1011', '自行车', '1001', '2', '0', 'full/5ef9050f95999fdeecaca9ebf1ddcd4b50552b62.jpg', '//m.suning.com/search/自行车/?adTypeCode=1023&adId=自行车');
INSERT INTO `sp_category` VALUES ('1012', '篮球鞋', '1001', '2', '0', 'full/9485bac0fb9bfa23a25bc29d3c9aae5adf521e0b.jpg', '//m.suning.com/search/篮球鞋/?adTypeCode=1023&adId=篮球鞋');
INSERT INTO `sp_category` VALUES ('1013', '健身器材', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1014', '钓竿', '1001', '2', '0', 'full/fe75257fe7ac3bab672e20f78df3ad8b5a1c857c.jpg', '//m.suning.com/search/钓竿/?adTypeCode=1023&adId=钓竿');
INSERT INTO `sp_category` VALUES ('1015', '羽毛球', '1001', '2', '0', 'full/816d386f4cbaeb010e9385c9b22ab5836ba5141b.jpg', '//m.suning.com/search/羽毛球/?adTypeCode=1023&adId=羽毛球');
INSERT INTO `sp_category` VALUES ('1016', '篮球', '1001', '2', '0', 'full/2282f07518131dea04adfbf76d7a08f4ce68f4ba.jpg', '//m.suning.com/search/篮球/?adTypeCode=1023&adId=篮球');
INSERT INTO `sp_category` VALUES ('1017', '跑步机', '1001', '2', '0', 'full/76ec5cdc081a1a11ff871ccd1480bf8fee096f43.jpg', '/list/420555-0.html');
INSERT INTO `sp_category` VALUES ('1018', '运动夹克', '1004', '2', '0', 'full/d66ae03082c01a518822ec773cc58dc916ecc2d6.jpg', '//m.suning.com/search/运动夹克/?adTypeCode=1023&adId=运动夹克');
INSERT INTO `sp_category` VALUES ('1019', '运动T恤', '1004', '2', '0', 'full/b131bff701ae3d00092a5a94ba6a558be7db49a7.jpg', '/list/420518-0.html');
INSERT INTO `sp_category` VALUES ('1020', '运动风衣', '1004', '2', '0', 'full/5122f83fda3db8b998300615785c08fb94bc7199.jpg', '//m.suning.com/search/运动风衣/?adTypeCode=1023&adId=运动风衣');
INSERT INTO `sp_category` VALUES ('1021', '运动卫衣', '1004', '2', '0', 'full/d1d8466dbfb2810ce6338c68d2cf43dea8b1ea61.jpg', '/list/420519-0.html');
INSERT INTO `sp_category` VALUES ('1022', '运动长裤', '1004', '2', '0', 'full/5e514b3f19b1d96bc194386fb10e5b5925d68669.jpg', '/list/420520-0.html');
INSERT INTO `sp_category` VALUES ('1023', '棉服', '1004', '2', '0', 'full/d745513508fb45c66757ecb9dfd7b332a7593343.jpg', '/list/420533-0.html');
INSERT INTO `sp_category` VALUES ('1024', '健身服', '1004', '2', '0', 'full/672154615b1b64c8896a85592a400843dd24c315.jpg', '/list/420534-0.html');
INSERT INTO `sp_category` VALUES ('1025', '运动套装', '1004', '2', '0', 'full/edea4825c12746d021d2a8afa8e031ede8d7f144.jpg', '//m.suning.com/search/运动服/?adTypeCode=1023&adId=运动服');
INSERT INTO `sp_category` VALUES ('1026', '跑步机', '1482', '2', '0', 'full/181842e46dedc45f5ea22e3259e7acec1480a0bb.jpg', '/list/420555-0.html');
INSERT INTO `sp_category` VALUES ('1027', '骑行装备', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1028', '仰卧板', '1013', '2', '0', 'full/a346a74c8c94375db1fe2fb03c32beb62889590e.jpg', '//m.suning.com/search/仰卧板/?adTypeCode=1023&adId=仰卧板');
INSERT INTO `sp_category` VALUES ('1029', '甩脂机', '1013', '2', '0', 'full/26eac01de0b96a12582fef0c2dc958b6dc720653.jpg', '//m.suning.com/search/甩脂机/?adTypeCode=1023&adId=甩脂机');
INSERT INTO `sp_category` VALUES ('1030', '健腹轮', '1013', '2', '0', 'full/d877e5515ae70637f6d6555420839042a2ec837a.jpg', '//m.suning.com/search/健腹轮/?adTypeCode=1023&adId=健腹轮');
INSERT INTO `sp_category` VALUES ('1031', '体育休闲', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1032', '健身车', '1013', '2', '0', 'full/6ea38dfab2901483f0ef8a4d3081ac288d156568.jpg', '//m.suning.com/search/健身车/?adTypeCode=1023&adId=健身车');
INSERT INTO `sp_category` VALUES ('1033', '哑铃', '1013', '2', '0', 'full/6783ce1dd0b6c45a63fbbf2aea781affbd7c2da3.jpg', '//m.suning.com/search/哑铃/?adTypeCode=1023&adId=哑铃');
INSERT INTO `sp_category` VALUES ('1034', '拉力器', '1013', '2', '0', 'full/59a1742b19bfe945ba9ce3db279017c80b180e95.jpg', '//m.suning.com/search/拉力器/?adTypeCode=1023&adId=拉力器');
INSERT INTO `sp_category` VALUES ('1035', '跳绳', '1013', '2', '0', 'full/6870e136baea61f0bb567ae6d215541872df8cdd.jpg', '/list/420564-0.html');
INSERT INTO `sp_category` VALUES ('1036', '计步器', '1013', '2', '0', 'full/a1c9c8a6e2ceaebdc5f6358f1e9b7fe2d9d6aacb.jpg', '/list/420567-0.html');
INSERT INTO `sp_category` VALUES ('1037', '握力器', '1013', '2', '0', 'full/39f41c7fd52783f999bcf299a9dac937353c17f3.jpg', '//m.suning.com/search/握力器/?adTypeCode=1023&adId=握力器');
INSERT INTO `sp_category` VALUES ('1038', '综合训练器', '1013', '2', '0', 'full/4424cbe504b866ccec2d707dd71a0bb270d8a9fd.jpg', '//m.suning.com/search/综合训练器/?adTypeCode=1023&adId=综合训练器');
INSERT INTO `sp_category` VALUES ('1039', '山地车', '1482', '2', '0', 'full/59ac98bd554cd27480e794d7db5c667d53c27194.jpg', '//m.suning.com/search/山地车/?adTypeCode=1023&adId=山地车');
INSERT INTO `sp_category` VALUES ('1040', '公路车', '1027', '2', '0', 'full/7c64d94815222a0f67927f0b3cab8e1d82eebc00.jpg', '//m.suning.com/search/公路车/?adTypeCode=1023&adId=公路车');
INSERT INTO `sp_category` VALUES ('1041', '电动车', '1027', '2', '0', 'full/0cb3edf84a1ea0d72a4cf6a440bf4af700084acf.jpg', '/list/420036-0.html');
INSERT INTO `sp_category` VALUES ('1042', '死飞', '1027', '2', '0', 'full/0f21a6c417e7228ca5d06c58cdca40380dfb2497.jpg', '//m.suning.com/search/死飞/?adTypeCode=1023&adId=死飞');
INSERT INTO `sp_category` VALUES ('1043', '折叠自行车', '1027', '2', '0', 'full/bd7f2c50f916c06432a4503108f479306fc6127c.jpg', '//m.suning.com/search/折叠自行车/?adTypeCode=1023&adId=折叠自行车');
INSERT INTO `sp_category` VALUES ('1044', '平衡车', '1027', '2', '0', 'full/5dd2817db08231e8ac2092cd2e79dc8cb3412046.jpg', '/list/420035-0.html');
INSERT INTO `sp_category` VALUES ('1045', '通勤自行车', '1027', '2', '0', 'full/4b04c383ce45343f81e8b2b41929758be1fa2b8f.jpg', '//m.suning.com/search/通勤自行车/?adTypeCode=1023&adId=通勤自行车');
INSERT INTO `sp_category` VALUES ('1046', '骑行服饰', '1027', '2', '0', 'full/e7ef9be7f66ce83b37fba301bebda44804c29d43.jpg', '//m.suning.com/search/骑行服/?adTypeCode=1023&adId=骑行服');
INSERT INTO `sp_category` VALUES ('1047', '户外鞋服', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1048', '单车装备', '1027', '2', '0', 'full/08c1a1111326d2afb1ffbe7fdad74186cc939fde.jpg', '//m.suning.com/search/单车装备/?adTypeCode=1023&adId=单车装备');
INSERT INTO `sp_category` VALUES ('1049', '游泳用品', '1482', '2', '0', 'full/74e166f66836436f944599cd0d27b28a21aa4035.jpg', '//m.suning.com/search/游泳/?adTypeCode=1023&adId=游泳');
INSERT INTO `sp_category` VALUES ('1050', '篮球', '1031', '2', '0', 'full/e124e8558e7ecf7db4b4638a9e3d62a329439147.jpg', '//m.suning.com/search/篮球/?adTypeCode=1023&adId=篮球');
INSERT INTO `sp_category` VALUES ('1051', '瑜伽', '1031', '2', '0', 'full/9b3ac3b594c100c3dbca4dd45790dd339bcabd0c.jpg', '//m.suning.com/search/瑜伽/?adTypeCode=1023&adId=瑜伽');
INSERT INTO `sp_category` VALUES ('1052', '乒乓球', '1031', '2', '0', 'full/964c136945e34d78baf502979ed5ef6808deef77.jpg', '/list/420065-0.html');
INSERT INTO `sp_category` VALUES ('1053', '排球', '1031', '2', '0', 'full/e762b28b4274a525912d9da0a397a082d6ba8019.jpg', '//m.suning.com/search/排球/?adTypeCode=1023&adId=排球');
INSERT INTO `sp_category` VALUES ('1054', '网球', '1031', '2', '0', 'full/8a025084b0b64a0ddf6e93363da1c3a1254b2410.jpg', '/list/420066-0.html');
INSERT INTO `sp_category` VALUES ('1055', '田径运动', '1031', '2', '0', 'full/461fabe9990d59fbb38c6032ff419e010bc36c09.jpg', '/list/420071-0.html');
INSERT INTO `sp_category` VALUES ('1056', '垂钓用品', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1057', '武术搏击', '1031', '2', '0', 'full/8901994c21580a2b52e385c95da7c98bb17b7a1c.jpg', '/list/420080-0.html');
INSERT INTO `sp_category` VALUES ('1058', '棋牌麻将', '1031', '2', '0', 'full/5b5962ba97aed861c3c6b0563a1f85cca777e0b8.jpg', '//m.suning.com/search/棋牌麻将/?adTypeCode=1023&adId=棋牌麻将');
INSERT INTO `sp_category` VALUES ('1059', '休闲鞋', '1482', '2', '0', 'full/ad854e95f5a721f3e731705bf8f3a45326a6f338.jpg', '//m.suning.com/search/休闲板鞋/?adTypeCode=1023&adId=休闲板鞋');
INSERT INTO `sp_category` VALUES ('1060', '登山鞋', '1047', '2', '0', 'full/51120b9cf306f2841ca49b7a50940357c05cd6d4.jpg', '//m.suning.com/search/登山鞋/?adTypeCode=1023&adId=登山鞋');
INSERT INTO `sp_category` VALUES ('1061', '运动鞋', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1062', '越野跑鞋', '1047', '2', '0', 'full/a4b87a6af1f3315714f84646d896b1a688569cdd.jpg', '//m.suning.com/search/越野跑鞋/?adTypeCode=1023&adId=越野跑鞋');
INSERT INTO `sp_category` VALUES ('1063', '速干衣/裤', '1047', '2', '0', 'full/7203c1cebba3f8c6ee76cd97c9de113744f4e90e.jpg', '//m.suning.com/search/速干衣/?adTypeCode=1023&adId=速干衣');
INSERT INTO `sp_category` VALUES ('1064', '抓绒衣/裤', '1047', '2', '0', 'full/34be4fe7a0f42a9fa402c9765fcc1119c1c1caf9.jpg', '//m.suning.com/search/抓绒衣/?adTypeCode=1023&adId=抓绒衣');
INSERT INTO `sp_category` VALUES ('1065', '冲锋衣/裤', '1047', '2', '0', 'full/dec71b02fc79cd5c3cf2f596f5fc40f2ae90ba15.jpg', '//m.suning.com/search/冲锋衣/?adTypeCode=1023&adId=冲锋衣');
INSERT INTO `sp_category` VALUES ('1066', '钓竿', '1482', '2', '0', 'full/f973fbe9a912e4b7847d2293cf2a77941029c8c7.jpg', '/list/420047-0.html');
INSERT INTO `sp_category` VALUES ('1067', '钓鱼工具', '1056', '2', '0', 'full/929221a5fb6c2693d93999f7d842747d3b688d5c.jpg', '/list/420058-0.html');
INSERT INTO `sp_category` VALUES ('1068', '钓伞', '1056', '2', '0', 'full/eba770f368bf446a224a7b267c904021f2022b1c.jpg', '//m.suning.com/search/钓伞/?adTypeCode=1023&adId=钓伞');
INSERT INTO `sp_category` VALUES ('1069', '渔具套装', '1056', '2', '0', 'full/33fd5da81e377f2eeda23e20f79c5cc03475e73e.jpg', '/list/420055-0.html');
INSERT INTO `sp_category` VALUES ('1070', '鱼饵', '1056', '2', '0', 'full/8e5e2418ef6f6fbc40a9badbf5141973a37c78dc.jpg', '/list/420048-0.html');
INSERT INTO `sp_category` VALUES ('1071', '鱼钩/钓钩', '1056', '2', '0', 'full/272dc5a5e2d2016896802b77abc7f42cb0e4c49e.jpg', '//m.suning.com/search/鱼钩/?adTypeCode=1023&adId=鱼钩');
INSERT INTO `sp_category` VALUES ('1072', '钓鱼服', '1056', '2', '0', 'full/4d5dff9621c7f2ef174314a5cacfe772999bedcf.jpg', '//m.suning.com/search/钓鱼服/?adTypeCode=1023&adId=钓鱼服');
INSERT INTO `sp_category` VALUES ('1073', '户外装备', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1074', '浮漂', '1056', '2', '0', 'full/efb6baeb34c8dc3b8e3f09e3e9a4b9ed49a5b41a.jpg', '/list/420051-0.html');
INSERT INTO `sp_category` VALUES ('1075', '鱼线', '1056', '2', '0', 'full/47dfa1da4062723631d8fd3c4f0bdadd077e8ce5.jpg', '//m.suning.com/search/鱼线/?adTypeCode=1023&adId=鱼线');
INSERT INTO `sp_category` VALUES ('1076', '休闲板鞋', '1061', '2', '0', 'full/66f15332c45cb1a7e72c6f7802595c5a6792b2f5.jpg', '//m.suning.com/search/休闲板鞋/?adTypeCode=1023&adId=休闲板鞋');
INSERT INTO `sp_category` VALUES ('1077', '足球鞋', '1061', '2', '0', 'full/ff0a04bfbd85d791d25a3382966475ebad65e15e.jpg', '//m.suning.com/search/足球鞋/?adTypeCode=1023&adId=足球鞋');
INSERT INTO `sp_category` VALUES ('1078', '训练鞋', '1061', '2', '0', 'full/5ad3835bec32a072e5e3c9459938f6d27a516b72.jpg', '//m.suning.com/search/训练鞋/?adTypeCode=1023&adId=训练鞋');
INSERT INTO `sp_category` VALUES ('1079', '网球鞋', '1061', '2', '0', 'full/232b3ed9f86c2fd2284440aadd316018ed257f30.jpg', '//m.suning.com/search/网球鞋/?adTypeCode=1023&adId=网球鞋');
INSERT INTO `sp_category` VALUES ('1080', '羽毛球鞋', '1061', '2', '0', 'full/5c61f6f428ea86b34e65bb4c2c19a54ce1518365.jpg', '//m.suning.com/search/羽毛球鞋/?adTypeCode=1023&adId=羽毛球鞋');
INSERT INTO `sp_category` VALUES ('1081', '运动包/配件', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1082', '帐篷', '1482', '2', '0', 'full/b9fdd0fdb3a7db5a88cd874c4187d55229784342.jpg', '//m.suning.com/search/帐篷/?adTypeCode=1023&adId=帐篷');
INSERT INTO `sp_category` VALUES ('1083', '望远镜', '1073', '2', '0', 'full/a3e553a4c3bf56085cb9c338616e6c865b183fd3.jpg', '/list/420019-0.html');
INSERT INTO `sp_category` VALUES ('1084', '品牌墙', '1000', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1085', '防潮垫', '1073', '2', '0', 'full/e43769b72f3df450f7f5dcd4686f918168a46c96.jpg', '//m.suning.com/search/防潮垫/?adTypeCode=1023&adId=防潮垫');
INSERT INTO `sp_category` VALUES ('1086', '睡袋', '1073', '2', '0', 'full/696eccc654709c5dbbd682e15110f24eb41394fe.jpg', '//m.suning.com/search/睡袋/?adTypeCode=1023&adId=睡袋');
INSERT INTO `sp_category` VALUES ('1087', '多用刀具', '1073', '2', '0', 'full/bd7b4e6ce89288e47a0305433ff1fa0ed305672c.jpg', '/list/420022-0.html');
INSERT INTO `sp_category` VALUES ('1088', '户外照明/仪表', '1073', '2', '0', 'full/d4550d61e3a1a0f9784fb46be16c7cc44a4d059e.jpg', '/list/420014-0.html');
INSERT INTO `sp_category` VALUES ('1089', '户外水具', '1073', '2', '0', 'full/28ef326b195579b2a87c646a2804108cd0b89f79.jpg', '/list/420026-0.html');
INSERT INTO `sp_category` VALUES ('1090', '野餐烧烤', '1073', '2', '0', 'full/95c9ae52fc8a9cac7b83925677dd74e8c454fa79.jpg', '/list/420021-0.html');
INSERT INTO `sp_category` VALUES ('1091', '军迷用品', '1073', '2', '0', 'full/f234d6cc69f4ff8bb6069d01c32f7dc672403f72.jpg', '//m.suning.com/search/军迷用品/?adTypeCode=1023&adId=军迷用品');
INSERT INTO `sp_category` VALUES ('1092', '单肩背包', '1482', '2', '0', 'full/1cf7f9db834d45ea6b1d3a5144f26690aa00e811.jpg', '/list/420547-0.html');
INSERT INTO `sp_category` VALUES ('1093', '双肩背包', '1081', '2', '0', 'full/f86a6e33eae00d02269ba3779b4a79f2719cbb4e.jpg', '/list/420548-0.html');
INSERT INTO `sp_category` VALUES ('1094', '腰包/卡包', '1081', '2', '0', 'full/ad47ed2890eb3ea2358d6725eed777da8586d6a0.jpg', '/list/420550-0.html');
INSERT INTO `sp_category` VALUES ('1095', '鼓包/旅行包', '1081', '2', '0', 'full/9cf9d957557f740f860bf644a1b59efac4bed6ad.jpg', '//m.suning.com/search/鼓包旅行包/?adTypeCode=1023&adId=鼓包旅行包');
INSERT INTO `sp_category` VALUES ('1096', '运动袜', '1081', '2', '0', 'full/2d41554831628aa0232cf427d70a033809bebb0e.jpg', '/list/420538-0.html');
INSERT INTO `sp_category` VALUES ('1097', '运动帽', '1081', '2', '0', 'full/dee9651a87bbd0ae3255e7cd35829cb6043331f9.jpg', '//m.suning.com/search/运动帽/?adTypeCode=1023&adId=运动帽');
INSERT INTO `sp_category` VALUES ('1098', '耐克', '1482', '2', '0', 'full/c85ed098d2909ce221ac866975c2f2362713b948.jpg', '//m.suning.com/search/耐克/?adTypeCode=1023&adId=耐克');
INSERT INTO `sp_category` VALUES ('1099', '阿迪达斯', '1084', '2', '0', 'full/e76f8438cb97ff587313f41a05a7e49e99fe4cc9.jpg', '//m.suning.com/search/阿迪达斯/?adTypeCode=1023&adId=阿迪达斯');
INSERT INTO `sp_category` VALUES ('1100', '美妆洗护', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('1101', '新百伦', '1084', '2', '0', 'full/64d1f05ec678f0663185168ac26cbab0f1374aae.jpg', '//m.suning.com/search/新百伦/?adTypeCode=1023&adId=新百伦');
INSERT INTO `sp_category` VALUES ('1102', '彪马', '1084', '2', '0', 'full/2a40d7edf8574e5906607748fb8fb07ddb6f20e3.jpg', '//m.suning.com/search/彪马/?adTypeCode=1023&adId=彪马');
INSERT INTO `sp_category` VALUES ('1103', '面部护理', '1100', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1104', '安踏', '1084', '2', '0', 'full/b8b1af8e33363186396f9226a736447ea83a72d0.jpg', '//m.suning.com/search/安踏/?adTypeCode=1023&adId=安踏');
INSERT INTO `sp_category` VALUES ('1105', '李宁', '1084', '2', '0', 'full/c00f164295c247382a8b1b9ab3a35451ec153d27.jpg', '//m.suning.com/search/李宁/?adTypeCode=1023&adId=李宁');
INSERT INTO `sp_category` VALUES ('1106', '鸿星尔克', '1084', '2', '0', 'full/b1382d64b4dee5681329d43f98492ffbabc6c9f7.jpg', '//m.suning.com/search/鸿星尔克/?adTypeCode=1023&adId=鸿星尔克');
INSERT INTO `sp_category` VALUES ('1107', '特步', '1084', '2', '0', 'full/24bd48cdbdd5d6fd23c474378eef6023ff2cda76.jpg', '//m.suning.com/search/特步/?adTypeCode=1023&adId=特步');
INSERT INTO `sp_category` VALUES ('1108', '乔丹', '1084', '2', '0', 'full/d7d878b26f886cff751d83e2f3309463cabe7483.jpg', '//m.suning.com/search/乔丹/?adTypeCode=1023&adId=乔丹');
INSERT INTO `sp_category` VALUES ('1109', '美发护发', '1100', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1110', '护肤套装', '109', '2', '0', 'full/37e2413fad20445374180542fce4d06d0cb38545.jpg', '/list/330021-0.html');
INSERT INTO `sp_category` VALUES ('1111', '身体护理', '1100', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1112', '面膜', '1482', '2', '0', 'full/3b801fda58d17c42afc4407f9e54eee9d7b061d8.jpg', '/list/362506-0.html');
INSERT INTO `sp_category` VALUES ('1113', '乳液', '1103', '2', '0', 'full/b14b472e9db94505b97ed89a42c795b6a1e012f9.jpg', '/list/330016-0.html');
INSERT INTO `sp_category` VALUES ('1114', '面霜', '1103', '2', '0', 'full/cc0f16954496782494817b9bde73ff4235ac2786.jpg', '/list/330018-0.html');
INSERT INTO `sp_category` VALUES ('1115', '防晒隔离', '1103', '2', '0', 'full/e25c89ded62e4fe99ec80a509dca81d1dc5d0975.jpg', '/list/330019-0.html');
INSERT INTO `sp_category` VALUES ('1116', '卸妆', '1103', '2', '0', 'full/e0058325da578ae69a88810c3bc45681676983c2.jpg', '/list/330010-0.html');
INSERT INTO `sp_category` VALUES ('1117', '唇部护理', '1103', '2', '0', 'full/a3138038d0d96018bb0f0a42052370cb0da39dc2.jpg', '/list/330008-0.html');
INSERT INTO `sp_category` VALUES ('1118', '爽肤水', '1103', '2', '0', 'full/862063ded00c4586df6fade021d23bb09ba28555.jpg', '/list/349505-0.html');
INSERT INTO `sp_category` VALUES ('1119', '精华', '1103', '2', '0', 'full/e023d99895ebcff2336ec6ec63b5da41f0f56758.jpg', '/list/330017-0.html');
INSERT INTO `sp_category` VALUES ('1120', '洗发水', '1482', '2', '0', 'full/d1a3eb2753159eb836ac629fea43b075034ff5b9.jpg', '/list/316550-0.html');
INSERT INTO `sp_category` VALUES ('1121', '护发素', '1109', '2', '0', 'full/03ed5b8e582bb9e3b5d0de2627f9dcb73ecc8f97.jpg', '/list/316551-0.html');
INSERT INTO `sp_category` VALUES ('1122', '洗护套装', '1109', '2', '0', 'full/62806b292a13f24a05ac6cee7460be3ce0ed76a8.jpg', '/list/316553-0.html');
INSERT INTO `sp_category` VALUES ('1123', '染烫造型', '1109', '2', '0', 'full/981e79b13cf0c5b176bb92e31ebb5cdc87f537c4.jpg', '/list/316547-0.html');
INSERT INTO `sp_category` VALUES ('1124', '营养水', '1109', '2', '0', 'full/b52322aa135b8089be8b65c35fac35700012f056.jpg', '/list/336040-0.html');
INSERT INTO `sp_category` VALUES ('1125', '美发工具', '1109', '2', '0', 'full/03eba86a12b85ce380ab53940c2095b8819b250a.jpg', '/list/315720-0.html');
INSERT INTO `sp_category` VALUES ('1126', '沐浴露', '1482', '2', '0', 'full/24d045b41610351ec9042116142b7bf9013e4b7f.jpg', '/list/316028-0.html');
INSERT INTO `sp_category` VALUES ('1127', '颈霜', '1111', '2', '0', 'full/57e05e7de23043df7144baa389b2277a6018587d.jpg', '/list/330521-0.html');
INSERT INTO `sp_category` VALUES ('1128', '手霜', '1111', '2', '0', 'full/84ea8258c963e419aea923b1a9f9d903f01f966e.jpg', '/list/316035-0.html');
INSERT INTO `sp_category` VALUES ('1129', '护足霜', '1111', '2', '0', 'full/812cbcb8876beb49f13df7b95e53a4a0a0e738e3.jpg', '/list/316041-0.html');
INSERT INTO `sp_category` VALUES ('1130', '丰胸美乳', '1111', '2', '0', 'full/0ff26043f3a4364200b1e3686d1a54237374cade.jpg', '/list/316026-0.html');
INSERT INTO `sp_category` VALUES ('1131', '按摩膏', '1111', '2', '0', 'full/a37fbd391ccf7d0d7ec04c59830a0066a525dfd8.jpg', '/list/316027-0.html');
INSERT INTO `sp_category` VALUES ('1132', '口腔护理', '1100', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1133', '男士护理', '1100', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1134', '润体霜', '1111', '2', '0', 'full/15aa95f739f243c05827c0efb8a4a9167bcce968.jpg', '/list/316021-0.html');
INSERT INTO `sp_category` VALUES ('1135', '女性护理', '1100', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1136', '润体乳', '1111', '2', '0', 'full/915f6072a671ee9953b56c251c1de04683d669b9.jpg', '/list/316020-0.html');
INSERT INTO `sp_category` VALUES ('1137', '脱毛', '1111', '2', '0', 'full/2c44ddb76bbddda97df55b252df2d875e0279264.jpg', '/list/316023-0.html');
INSERT INTO `sp_category` VALUES ('1138', '香水彩妆', '1100', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1139', '牙膏', '1482', '2', '0', 'full/508820022495b5f633589a68444b23bccd820d94.jpg', '/list/316563-0.html');
INSERT INTO `sp_category` VALUES ('1140', '牙刷', '1132', '2', '0', 'full/139d4a55be911e5bdcb66e1e5d67e5f72eb9b651.jpg', '/list/336044-0.html');
INSERT INTO `sp_category` VALUES ('1141', '漱口水', '1132', '2', '0', 'full/77963f6fe174f9cefa3428d6e8c0d50f855d40d5.jpg', '/list/316566-0.html');
INSERT INTO `sp_category` VALUES ('1142', '牙线', '1132', '2', '0', 'full/8ceee4bd77068676427c83a7be455aa7926b1857.jpg', '/list/336043-0.html');
INSERT INTO `sp_category` VALUES ('1143', '口腔套装', '1132', '2', '0', 'full/37b3d511627482067ec453db3542d0a082bc7f99.jpg', '/list/315198-0.html');
INSERT INTO `sp_category` VALUES ('1144', '剃须护理', '1482', '2', '0', 'full/1af6424e6d6425eddab70c7cef32d11d76e19f9e.jpg', '/list/316507-0.html');
INSERT INTO `sp_category` VALUES ('1145', '男士香水', '1133', '2', '0', 'full/0b436713d65bccf2b9e57e1d680f9aa216e07e3a.jpg', '/list/362505-24838.html');
INSERT INTO `sp_category` VALUES ('1146', '男士套装', '1133', '2', '0', 'full/3c05de2f9da3ad6482a514b1834510b273d1568c.jpg', '/list/330004-9173.html');
INSERT INTO `sp_category` VALUES ('1147', '卫生巾', '1482', '2', '0', 'full/012fcef844193448cf4c795a0ae0d5e8d1a0c2f5.jpg', '/list/362508-0.html');
INSERT INTO `sp_category` VALUES ('1148', '护垫', '1135', '2', '0', 'full/56eb10c175d9af83f3c623cbe1115ab7332bdcd1.jpg', '/list/316008-0.html');
INSERT INTO `sp_category` VALUES ('1149', '私密护理', '1135', '2', '0', 'full/2d1bf8a7b132a702d6ab3412bbb82effd9e164a9.jpg', '/list/316004-0.html');
INSERT INTO `sp_category` VALUES ('1150', '香水香氛', '1482', '2', '0', 'full/85d3abd5a76feea5dff7cdd8cce36921ceaf0757.jpg', '/list/315147-0.html');
INSERT INTO `sp_category` VALUES ('1151', '品牌墙', '1100', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1152', '美妆套装', '1138', '2', '0', 'full/5497416d7df96d97d5386175c567b295d4272a3d.jpg', '/list/315688-0.html');
INSERT INTO `sp_category` VALUES ('1153', '面部卸妆', '1138', '2', '0', 'full/1fadebdbb63a4cf8f644d2c25d02a97bfdbb29bd.jpg', '/list/329504-0.html');
INSERT INTO `sp_category` VALUES ('1154', '粉饼', '1138', '2', '0', 'full/e8e917aed6d036d18c307507a45ab1e5b8b06436.jpg', '/list/315692-0.html');
INSERT INTO `sp_category` VALUES ('1155', '粉底遮瑕', '1138', '2', '0', 'full/f8b33114a95ef8f43fd407a00c28f070502d1877.jpg', '/list/336021-0.html');
INSERT INTO `sp_category` VALUES ('1156', '眉笔', '1138', '2', '0', 'full/cea6f6044c525521551198edcaa01ff404ab6e38.jpg', '/list/315696-0.html');
INSERT INTO `sp_category` VALUES ('1157', '内衣配饰', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('1158', '睫毛膏', '1138', '2', '0', 'full/f91d7f283dc436ac5c36afd7cf456d2ae04cfb3d.jpg', '/list/315698-0.html');
INSERT INTO `sp_category` VALUES ('1159', '眼线', '1138', '2', '0', 'full/80370239b2d33222199fae41cded044ae7ddd675.jpg', '/list/315701-0.html');
INSERT INTO `sp_category` VALUES ('1161', '眼影', '1138', '2', '0', 'full/94f7ee20004845e636eb00425fa64e576ee695a4.jpg', '/list/315702-0.html');
INSERT INTO `sp_category` VALUES ('1162', '文胸', '1157', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1163', '沙宣', '1482', '2', '0', 'full/be4730cd59ab8ccee9722a0ea5b10d3f2d23ca04.jpg', '/list/316550-51186.html');
INSERT INTO `sp_category` VALUES ('1164', '苏菲', '1151', '2', '0', 'full/61ce5dc8ae128b2ccb4d60ffc08dda0159cf8fff.jpg', '/list/362508-131444.html');
INSERT INTO `sp_category` VALUES ('1165', '多芬', '1151', '2', '0', 'full/03f89239ac8d67180b4a60ea95eb6ca2fc4a2ae9.jpg', '/list/316546-42160.html');
INSERT INTO `sp_category` VALUES ('1166', '施华蔻', '1151', '2', '0', 'full/8ed1cdfc76ac30895cd2fa3017d4d6d5ccdb8d3f.jpg', '/list/316546-18437.html');
INSERT INTO `sp_category` VALUES ('1167', '云南白药', '1151', '2', '0', 'full/ed7b8bbdaaefe9f0ca1a94d4c32d35b8f04df02e.jpg', '/list/316563-51404.html');
INSERT INTO `sp_category` VALUES ('1168', '可莱丝', '1151', '2', '0', 'full/c9b20b34e0f6f771c5dc41a2e47c57b7d34f68bb.jpg', '/list/330005-56212.html');
INSERT INTO `sp_category` VALUES ('1169', '睡衣', '1157', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1170', '无钢圈文胸', '1482', '2', '0', 'full/00341149a1759ed540c571459752d5a85c803833.jpg', '//m.suning.com/search/无钢圈文胸/?adTypeCode=1023&adId=无钢圈文胸');
INSERT INTO `sp_category` VALUES ('1171', '聚拢文胸', '1162', '2', '0', 'full/833540973e124ed58ee30c23b46ba3e60f1b9617.jpg', '//m.suning.com/search/聚拢文胸/?adTypeCode=1023&adId=聚拢文胸');
INSERT INTO `sp_category` VALUES ('1172', '调整文胸', '1162', '2', '0', 'full/f741b02d7af40939d8a70526853ea1c39d80b414.jpg', '//m.suning.com/search/调整文胸/?adTypeCode=1023&adId=调整文胸');
INSERT INTO `sp_category` VALUES ('1173', '按摩文胸', '1162', '2', '0', 'full/d1743f8ef5b8bf874d39c98cb44487199cf7663f.jpg', '//m.suning.com/search/按摩文胸/?adTypeCode=1023&adId=按摩文胸');
INSERT INTO `sp_category` VALUES ('1174', '内裤', '1157', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1175', '隐形文胸', '1162', '2', '0', 'full/237f403b93d1e61950fabd8febab24f61c2e9809.jpg', '//m.suning.com/search/隐形文胸/?adTypeCode=1023&adId=隐形文胸');
INSERT INTO `sp_category` VALUES ('1176', '抹胸', '1162', '2', '0', 'full/77e4d901350695f08799e509ce05c1cc768cad06.jpg', '//m.suning.com/search/抹胸/?adTypeCode=1023&adId=抹胸');
INSERT INTO `sp_category` VALUES ('1177', '塑身衣', '1162', '2', '0', 'full/9803719f86a084af6badbe65a9b29d4e471b720d.jpg', '//m.suning.com/search/塑身衣/?adTypeCode=1023&adId=塑身衣');
INSERT INTO `sp_category` VALUES ('1178', '情趣内衣', '1162', '2', '0', 'full/3e8ac3af1477627192412d4ea8cf489a4d8c51c9.jpg', '/list/233010-0.html');
INSERT INTO `sp_category` VALUES ('1179', '法兰绒睡衣', '1482', '2', '0', 'full/e19ce5e9bd19b4679074bc5b2f9e169817bb2124.jpg', '//m.suning.com/search/法兰绒睡衣/?adTypeCode=1023&adId=法兰绒睡衣');
INSERT INTO `sp_category` VALUES ('1180', '男士睡衣', '1169', '2', '0', 'full/667c9adb178e9d15442ceb323910538957d07c86.jpg', '//m.suning.com/search/睡衣男/?adTypeCode=1023&adId=睡衣男');
INSERT INTO `sp_category` VALUES ('1181', '女士睡衣', '1169', '2', '0', 'full/2234550cef713f1534377d0ec68cb73e98607f03.jpg', '//m.suning.com/search/睡衣女/?adTypeCode=1023&adId=睡衣女');
INSERT INTO `sp_category` VALUES ('1182', '情侣睡衣', '1169', '2', '0', 'full/69797f85bcffef99a6baf654c9110401770fa860.jpg', '//m.suning.com/search/情侣睡衣/?adTypeCode=1023&adId=情侣睡衣');
INSERT INTO `sp_category` VALUES ('1183', '睡袍', '1169', '2', '0', 'full/f15694dbdb6b18fba78fc0bf53a99cf2087de80b.jpg', '//m.suning.com/search/睡袍/?adTypeCode=1023&adId=睡袍');
INSERT INTO `sp_category` VALUES ('1184', '真丝睡衣', '1169', '2', '0', 'full/ecf93b0f5c2dd14cbe71477300823a598c42f923.jpg', '//m.suning.com/search/真丝睡衣/?adTypeCode=1023&adId=真丝睡衣');
INSERT INTO `sp_category` VALUES ('1185', '内裤', '1482', '2', '0', 'full/9622233284bf3409f6af1f847130ea4afdebce9f.jpg', '//m.suning.com/search/内裤/?adTypeCode=1023&adId=内裤');
INSERT INTO `sp_category` VALUES ('1186', '男士内裤', '1174', '2', '0', 'full/7746c2afd89432fb7207b852c0299133ec433185.jpg', '//m.suning.com/search/内裤男/?adTypeCode=1023&adId=内裤男');
INSERT INTO `sp_category` VALUES ('1187', '袜子', '1157', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1188', '女士内裤', '1174', '2', '0', 'full/f9b5b417ed107c9a8b98bcf6652c422574dd31c7.jpg', '//m.suning.com/search/内裤女/?adTypeCode=1023&adId=内裤女');
INSERT INTO `sp_category` VALUES ('1189', '纯棉内裤', '1174', '2', '0', 'full/d399ee6a064e5c8f2776674e742c2524a0fb55fb.jpg', '//m.suning.com/search/%E7%BA%AF%E6%A3%89%E5%86%85%E8%A3%A4/?adTypeCode=1023&adId=%E7%BA%AF%E6%A3%89%E5%86%85%E8%A3%A4');
INSERT INTO `sp_category` VALUES ('1190', '平角内裤', '1174', '2', '0', 'full/3c7d7c0fae8d4e217d40061de01bb43edf83422c.jpg', '//m.suning.com/search/%E5%B9%B3%E8%A7%92%E5%86%85%E8%A3%A4/?adTypeCode=1023&adId=%E5%B9%B3%E8%A7%92%E5%86%85%E8%A3%A4');
INSERT INTO `sp_category` VALUES ('1191', '无痕内裤', '1174', '2', '0', 'full/d904a3a18abb0f5fc38f7a776a9bd0ee440c28db.jpg', '//m.suning.com/search/无痕内裤/?adTypeCode=1023&adId=无痕内裤');
INSERT INTO `sp_category` VALUES ('1192', '保暖内衣', '1157', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1193', '丁字裤', '1174', '2', '0', 'full/81ebf0c580b2c9d7ab6cb7890c4a59f1624606ce.jpg', '//m.suning.com/search/%E4%B8%81%E5%AD%97%E5%86%85%E8%A3%A4/?adTypeCode=1023&adId=%E4%B8%81%E5%AD%97%E5%86%85%E8%A3%A4');
INSERT INTO `sp_category` VALUES ('1194', '三角内裤', '1174', '2', '0', 'full/0ccb3fc9133da71b4a52e25c2f6d0b72d6ad38c8.jpg', '//m.suning.com/search/三角内裤/?adTypeCode=1023&adId=三角内裤');
INSERT INTO `sp_category` VALUES ('1195', '收腹内裤', '1174', '2', '0', 'full/cfaf4178412c33f8dfce98458224a5e7b8b51d66.jpg', '//m.suning.com/search/收腹内裤女/?adTypeCode=1023&adId=收腹内裤女');
INSERT INTO `sp_category` VALUES ('1196', '丝袜', '1482', '2', '0', 'full/353285f18fbf60d4953b86b05db724ed30cf497f.jpg', '//m.suning.com/search/%E4%B8%9D%E8%A2%9C/?adTypeCode=1023&adId=%E4%B8%9D%E8%A2%9C');
INSERT INTO `sp_category` VALUES ('1197', '男袜', '1187', '2', '0', 'full/2be3d0f8bb141396d05ab4737fc331ed2e71b961.jpg', '//m.suning.com/search/男袜/?adTypeCode=1023&adId=男袜');
INSERT INTO `sp_category` VALUES ('1198', '女袜', '1187', '2', '0', 'full/cbf04b0ea94a28ecc8e9deeae7f07e3cfb9c7308.jpg', '//m.suning.com/search/女袜/?adTypeCode=1023&adId=女袜');
INSERT INTO `sp_category` VALUES ('1199', '船袜', '1187', '2', '0', 'full/c985d24beb5defb9c97119d159c3b9243e6d4fb4.jpg', '//m.suning.com/search/船袜/?adTypeCode=1023&adId=船袜');
INSERT INTO `sp_category` VALUES ('1200', '连裤袜', '1187', '2', '0', 'full/dc18e7e3095f2b30fd2a8b1b8d4ce0a339a0256d.jpg', '//m.suning.com/search/连裤袜/?adTypeCode=1023&adId=连裤袜');
INSERT INTO `sp_category` VALUES ('1201', '棉袜', '1187', '2', '0', 'full/55f80addfa47bf2a77faba5c29d38dfc3e73745d.jpg', '//m.suning.com/search/棉袜/?adTypeCode=1023&adId=棉袜');
INSERT INTO `sp_category` VALUES ('1202', '配饰', '1157', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1203', '保暖内衣', '1482', '2', '0', 'full/e50d323557338369bbab068aca04479b3f7eef14.jpg', '//m.suning.com/search/保暖内衣/?adTypeCode=1023&adId=保暖内衣');
INSERT INTO `sp_category` VALUES ('1204', '基础内衣', '1192', '2', '0', 'full/0623571b8318f8d1c409b56379787311d2e7b78a.jpg', '//m.suning.com/search/%E5%9F%BA%E7%A1%80%E5%86%85%E8%A1%A3/?adTypeCode=1023&adId=%E5%9F%BA%E7%A1%80%E5%86%85%E8%A1%A3');
INSERT INTO `sp_category` VALUES ('1205', '男士保暖', '1192', '2', '0', 'full/03af45e6d77d45d820b97cc10d8065e3dfd64edf.jpg', '//m.suning.com/search/保暖内衣男/?adTypeCode=1023&adId=保暖内衣男');
INSERT INTO `sp_category` VALUES ('1206', '女士保暖', '1192', '2', '0', 'full/b3be16b44cf7d06973e8ac2fa1837e98a488848a.jpg', '//m.suning.com/search/保暖内衣女/?adTypeCode=1023&adId=保暖内衣女');
INSERT INTO `sp_category` VALUES ('1207', '秋衣秋裤', '1192', '2', '0', 'full/9cf7a4a82a84da2604f451ef4121681616a36a8a.jpg', '//m.suning.com/search/秋衣秋裤/?adTypeCode=1023&adId=秋衣秋裤');
INSERT INTO `sp_category` VALUES ('1208', '品牌墙', '1157', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1209', '加绒保暖', '1192', '2', '0', 'full/f3ecc59f3d96e07985416e7ca73a6724f7c9ef12.jpg', '//m.suning.com/search/%E5%8A%A0%E7%BB%92%E4%BF%9D%E6%9A%96%E5%86%85%E8%A1%A3/?adTypeCode=1023&adId=%E5%8A%A0%E7%BB%92%E4%BF%9D%E6%9A%96%E5%86%85%E8%A1%A3');
INSERT INTO `sp_category` VALUES ('1210', '帽子', '1482', '2', '0', 'full/09a3813e82c558bba9e30cd0b8f9ae815e1cf154.jpg', '//m.suning.com/search/帽子秋冬/?adTypeCode=1023&adId=帽子秋冬');
INSERT INTO `sp_category` VALUES ('1211', '围巾', '1202', '2', '0', 'full/3531ef3bafa2ee1c186014f82bcdbd890cb4e9f0.jpg', '//m.suning.com/search/围巾/?adTypeCode=1023&adId=围巾');
INSERT INTO `sp_category` VALUES ('1212', '腰带', '1202', '2', '0', 'full/fb455c2329b4f726c272bfed9ff00d44ab7f3f21.jpg', '//m.suning.com/search/腰带/?adTypeCode=1023&adId=腰带');
INSERT INTO `sp_category` VALUES ('1213', '领带/领结', '1202', '2', '0', 'full/0405eaf3a72d21b81fb3fe53be5be6e6714b2a30.jpg', '//m.suning.com/search/领带/?adTypeCode=1023&adId=领带');
INSERT INTO `sp_category` VALUES ('1214', '手套', '1202', '2', '0', 'full/4c48b8d0a28f974a9216cbdc74148e3165a0abaf.jpg', '//m.suning.com/search/手套秋冬/?adTypeCode=1023&adId=手套秋冬');
INSERT INTO `sp_category` VALUES ('1215', '眼镜', '1202', '2', '0', 'full/0c4ef16cef52e6f207885a5d881dfcad19516e88.jpg', '//m.suning.com/search/眼镜/?adTypeCode=1023&adId=眼镜');
INSERT INTO `sp_category` VALUES ('1216', '古今', '1482', '2', '0', 'full/c56f5bc3a6fded724e7706705e45c8e1db228ee1.jpg', '//m.suning.com/search/古今/?adTypeCode=1023&adId=古今');
INSERT INTO `sp_category` VALUES ('1217', '南极人', '1208', '2', '0', 'full/02430aa6b71539e29c1ec65ce07749bb02a3ac8b.jpg', '//m.suning.com/search/南极人/?adTypeCode=1023&adId=南极人');
INSERT INTO `sp_category` VALUES ('1218', '童装玩具', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('1219', 'PLAY', '1208', '2', '0', 'full/93b8ccc71cd809edcf8972c586601ef0aecc5946.jpg', '//m.suning.com/search/花花公子内衣/?adTypeCode=1023&adId=花花公子内衣');
INSERT INTO `sp_category` VALUES ('1220', '恒源祥', '1208', '2', '0', 'full/96f04af5d50d8e0915756bffe6953275650d7fed.jpg', '//m.suning.com/search/恒源祥内衣/?adTypeCode=1023&adId=恒源祥内衣');
INSERT INTO `sp_category` VALUES ('1221', '北极绒', '1208', '2', '0', 'full/f882661f8ea26017d9ef081092153f28f0ecd6f5.jpg', '//m.suning.com/search/北极绒内衣/?adTypeCode=1023&adId=北极绒内衣');
INSERT INTO `sp_category` VALUES ('1222', '俞兆林', '1208', '2', '0', 'full/19de4351be38ccda7f170e64320a1f86e781e997.jpg', '//m.suning.com/search/俞兆林/?adTypeCode=1023&adId=俞兆林');
INSERT INTO `sp_category` VALUES ('1224', '甜妹子', '1208', '2', '0', 'full/07c4d1d46771005af906985901c1bd680ad7ec0d.jpg', '//m.suning.com/search/甜妹子/?adTypeCode=1023&adId=甜妹子');
INSERT INTO `sp_category` VALUES ('1225', '婴幼玩具', '1218', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1226', '艾塞亚', '1208', '2', '0', 'full/3bb517d12be40853edc6976585cadeef6e0b8e3e.jpg', '//m.suning.com/search/艾塞亚/?adTypeCode=1023&adId=艾塞亚');
INSERT INTO `sp_category` VALUES ('1227', '都市丽人', '1208', '2', '0', 'full/5c01ab99beb173f6c5d57ecd81cfa33f7cd37e77.jpg', '//m.suning.com/search/都市丽人/?adTypeCode=1023&adId=都市丽人');
INSERT INTO `sp_category` VALUES ('1228', '户外玩具', '1218', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1229', '摇铃/床铃', '1482', '2', '0', 'full/9725047b016bc52c94f038c6adbc1fd767a271f2.jpg', '/list/313130-0.html');
INSERT INTO `sp_category` VALUES ('1230', '布书/挂图', '1482', '2', '0', 'full/2d62e3b9f5532202c5a16262c7ab14fd9c19c946.jpg', '/list/313131-0.html');
INSERT INTO `sp_category` VALUES ('1231', 'DIY玩具', '1218', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1232', '积木', '1225', '2', '0', 'full/5ba2c25ec57d83ff24231a2c4424d181159bda8c.jpg', '/list/317043-0.html');
INSERT INTO `sp_category` VALUES ('1233', '爬行垫', '1225', '2', '0', 'full/a4b69e1e5283587fc1fe36f3a9dc73cd7ad02851.jpg', '/list/313133-0.html');
INSERT INTO `sp_category` VALUES ('1234', '游泳池', '1225', '2', '0', 'full/4865cddb9152f068348bf4c407e06e7be07cd813.jpg', '/list/313134-0.html');
INSERT INTO `sp_category` VALUES ('1235', '健身架', '1225', '2', '0', 'full/513299e19e7881002bb4b47428c811d09dc3eca6.jpg', '/list/359004-0.html');
INSERT INTO `sp_category` VALUES ('1236', '迷宫/拼图', '1225', '2', '0', 'full/a8ac24e82c52ebbdac15292ccf98f7c863385c15.jpg', '/list/317044-0.html');
INSERT INTO `sp_category` VALUES ('1237', '磁力棒/磁贴', '1225', '2', '0', 'full/b84b4553bb2f418c36a3505914dda8a651bd0d03.jpg', '/list/317045-0.html');
INSERT INTO `sp_category` VALUES ('1238', '儿童旅行箱', '1225', '2', '0', 'full/9f05f003443628633980e927b3feb6e23b04466d.jpg', '/list/317061-0.html');
INSERT INTO `sp_category` VALUES ('1239', '运动户外玩具', '1482', '2', '0', 'full/fe4cb4f8c7aa5d85318cb8bb96861331a363b2ab.jpg', '/list/315670-0.html');
INSERT INTO `sp_category` VALUES ('1240', '绳类/球类', '1228', '2', '0', 'full/7de5f797209fb0fbaf7a8d3892aafb10e6724baf.jpg', '/list/315677-0.html');
INSERT INTO `sp_category` VALUES ('1241', '轮滑/摇马', '1228', '2', '0', 'full/5c47e2be4feb7b581f1b2d23079dfe34444d9c3d.jpg', '/list/315678-0.html');
INSERT INTO `sp_category` VALUES ('1242', '泡泡机', '1228', '2', '0', 'full/c92f188e55f78ea9d530fdb0c6b7e8421f6507d6.jpg', '/list/317019-0.html');
INSERT INTO `sp_category` VALUES ('1243', '戏水玩沙', '1228', '2', '0', 'full/b2e390895a11db7391588cfbfe3eb7544d63d206.jpg', '/list/317022-0.html');
INSERT INTO `sp_category` VALUES ('1244', '游戏屋/海洋球', '1228', '2', '0', 'full/ce2dce2f9e215085bff60da88591535d1d08a9d8.jpg', '/list/317025-0.html');
INSERT INTO `sp_category` VALUES ('1245', '靠垫抱枕', '1482', '2', '0', 'full/c5c12c588c99eb809655b16e0f88007e69b062a2.jpg', '/list/313142-0.html');
INSERT INTO `sp_category` VALUES ('1246', '遥控模型玩具', '1218', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1247', '布艺玩具', '1231', '2', '0', 'full/4480ed3f5207bb907c71fee9fdf4991ba551348e.jpg', '/list/317027-0.html');
INSERT INTO `sp_category` VALUES ('1248', '桌面游戏', '1231', '2', '0', 'full/30e177c7f6627839cc60e8d441797075809688a9.jpg', '/list/317070-0.html');
INSERT INTO `sp_category` VALUES ('1249', '手工彩泥', '1231', '2', '0', 'full/dee3e8675da6b7c28b7dba63e51f17b0270b16ba.jpg', '/list/313145-0.html');
INSERT INTO `sp_category` VALUES ('1250', '童装', '1218', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1251', '画笔画架', '1231', '2', '0', 'full/fb5fe221120c8d7d2dc5f6e036fe4afc33580838.jpg', '/list/317036-0.html');
INSERT INTO `sp_category` VALUES ('1252', '过家家玩具', '1231', '2', '0', 'full/756204dddeef34630511ecb2a22e5320809c7bbe.jpg', '/list/317037-0.html');
INSERT INTO `sp_category` VALUES ('1253', '轨道车', '1482', '2', '0', 'full/026e14c74b0960fa742bb00ff8c3c5a2306d3459.jpg', '/list/317031-0.html');
INSERT INTO `sp_category` VALUES ('1254', '电动玩具', '1246', '2', '0', 'full/51b46e388cf8929c23a772dc5737327a790049d8.jpg', '/list/317032-0.html');
INSERT INTO `sp_category` VALUES ('1255', '仿真模型玩具', '1246', '2', '0', 'full/8f78389f93da6cb6e124443446912a5e26a96ab4.jpg', '/list/317048-0.html');
INSERT INTO `sp_category` VALUES ('1256', '拼装模型玩具', '1246', '2', '0', 'full/79a0b5e24e27ee07287cd5d2f021930236fd19c5.jpg', '/list/317049-0.html');
INSERT INTO `sp_category` VALUES ('1257', '变形类玩具', '1246', '2', '0', 'full/e83b77d1edac84a9ce3278be2559ab11ed48bde2.jpg', '/list/317053-0.html');
INSERT INTO `sp_category` VALUES ('1258', '兵器/军事模型', '1246', '2', '0', 'full/c1850f27baa21bf9c00917bd777687523a276600.jpg', '/list/317054-0.html');
INSERT INTO `sp_category` VALUES ('1259', '童鞋', '1218', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1260', '棉服/羽绒服', '1482', '2', '0', 'full/494908f3d6417dc0d0225258c22fc2161c99f18d.jpg', '/list/315061-0.html');
INSERT INTO `sp_category` VALUES ('1261', '卫衣', '1250', '2', '0', 'full/0931c246da6788fff1158bdc642dfd1a65bcffb9.jpg', '/list/315066-0.html');
INSERT INTO `sp_category` VALUES ('1262', '毛衣/针织衫', '1250', '2', '0', 'full/2e9cc2a85f51edd86be4d1d94afc488f95b7591d.jpg', '/list/315062-0.html');
INSERT INTO `sp_category` VALUES ('1263', '婴儿爬服', '1250', '2', '0', 'full/9d53878f8008f70bbba09d5ff644c25a4ea979e6.jpg', '/list/362006-24246.html');
INSERT INTO `sp_category` VALUES ('1264', 'T恤/衬衫', '1250', '2', '0', 'full/eee6afe8f734bb62e1dea379d4a619904191715c.jpg', '/list/315065-0.html');
INSERT INTO `sp_category` VALUES ('1265', '裤子', '1250', '2', '0', 'full/04b0a2dc487b145a54881cce44413860b1f41d90.jpg', '/list/315063-0.html');
INSERT INTO `sp_category` VALUES ('1266', '外套', '1250', '2', '0', 'full/6b0df53069113e1cad7e1b31e3476b2825b814b9.jpg', '/list/315067-0.html');
INSERT INTO `sp_category` VALUES ('1267', '婴童内衣', '1250', '2', '0', 'full/e3b798e9afe567d1ca0e8593c33fb0117087ba84.jpg', '/list/315064-0.html');
INSERT INTO `sp_category` VALUES ('1268', '儿童配饰', '1250', '2', '0', 'full/ddcf9dd489ca65fe58cfb140157760f69c4d0f3c.jpg', '/list/341078-0.html');
INSERT INTO `sp_category` VALUES ('1269', '婴儿礼盒', '1250', '2', '0', 'full/e836f6a15af55ef41ebec9d1f02757a88e024f64.jpg', '/list/362007-0.html');
INSERT INTO `sp_category` VALUES ('1270', '裙子', '1250', '2', '0', 'full/cdb120e8e7564365fe006b71bd34e81d0dd803f2.jpg', '/list/362012-0.html');
INSERT INTO `sp_category` VALUES ('1271', '亲子装', '1250', '2', '0', 'full/0e9817152bfec9ecad5e5dcc859312d868f67747.jpg', '/list/315108-0.html');
INSERT INTO `sp_category` VALUES ('1272', '学步鞋', '1482', '2', '0', 'full/cd12fe014d1e0ad66c3c4aad8532e7fab2613caf.jpg', '/list/341071-0.html');
INSERT INTO `sp_category` VALUES ('1273', '宝宝寝居', '1218', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1274', '运动鞋', '1259', '2', '0', 'full/e06b38fd4af8c2669a889f552de475b7b2256fb7.jpg', '/list/315082-0.html');
INSERT INTO `sp_category` VALUES ('1275', '靴子/雪地靴', '1259', '2', '0', 'full/5fc86418b04bc157735da7adf04e02366940a3a7.jpg', '/list/315087-0.html');
INSERT INTO `sp_category` VALUES ('1276', '皮鞋/公主鞋', '1259', '2', '0', 'full/b05fb6c6a71fc84949e00d81dee2a7985955a78c.jpg', '/list/315085-0.html');
INSERT INTO `sp_category` VALUES ('1277', '帆布鞋', '1259', '2', '0', 'full/34b29edb6b150c63114fb75cdebf8fec51f12459.jpg', '/list/500330-0.html');
INSERT INTO `sp_category` VALUES ('1278', '棉鞋', '1259', '2', '0', 'full/c662b626ffb36dfd85a56a9b68385522b96f99b5.jpg', '/list/315084-0.html');
INSERT INTO `sp_category` VALUES ('1279', '拖鞋', '1259', '2', '0', 'full/bd2b4556016cd659732d83131659c0228c57f20e.jpg', '/list/315086-0.html');
INSERT INTO `sp_category` VALUES ('1280', '雨鞋', '1259', '2', '0', 'full/38a74dbfb77ea1fbfbd80c90c76295b1cae310d4.jpg', '/list/341072-0.html');
INSERT INTO `sp_category` VALUES ('1281', '凉鞋', '1259', '2', '0', 'full/3c5abecfd420e6f79e6c8cdac64f2a6c8cd4fd8f.jpg', '/list/315083-0.html');
INSERT INTO `sp_category` VALUES ('1282', '品牌墙', '1218', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1283', '睡袋/抱被', '1482', '2', '0', 'full/ca726c890a2da6838328fe27562dd5366e8e14c5.jpg', '/list/500341-0.html');
INSERT INTO `sp_category` VALUES ('1284', '隔尿垫', '1273', '2', '0', 'full/a96be611d329078b07db3b74ca8222f4d93472e5.jpg', '/list/500334-0.html');
INSERT INTO `sp_category` VALUES ('1285', '婴儿枕', '1273', '2', '0', 'full/f6b281d7f1b05939064576adf6a512ebfc46e9b4.jpg', '/list/500343-0.html');
INSERT INTO `sp_category` VALUES ('1286', '被褥/毛毯', '1273', '2', '0', 'full/ea2c6109b32d1f70ba5f72b1b7d05e103e06fe17.jpg', '/list/500342-0.html');
INSERT INTO `sp_category` VALUES ('1287', '浴巾/毛巾', '1273', '2', '0', 'full/b963df78cbe0e490d8ca822439950788f518b2f3.jpg', '/list/500340-0.html');
INSERT INTO `sp_category` VALUES ('1288', '床品套装', '1273', '2', '0', 'full/c0118901e334776d3aa795f5be9fa0069f59db3c.jpg', '/list/500339-0.html');
INSERT INTO `sp_category` VALUES ('1289', '布尿裤', '1273', '2', '0', 'full/18a4c00e176fe1dc6d902960095aadd342e2a25d.jpg', '/list/500335-0.html');
INSERT INTO `sp_category` VALUES ('1290', '床垫', '1273', '2', '0', 'full/e6ad215f1b80981aeefa62c4ab1569903556076c.jpg', '/list/500337-0.html');
INSERT INTO `sp_category` VALUES ('1291', '凉席/蚊帐', '1273', '2', '0', 'full/46b83768bd4aeb94005830cd6dc3ceaf622965e5.jpg', '/list/500336-0.html');
INSERT INTO `sp_category` VALUES ('1292', '抱抱熊', '1482', '2', '0', 'full/0a4393abd4c70c163cc59c85199dc869e2840f1c.jpg', '/list/315657-44419.html');
INSERT INTO `sp_category` VALUES ('1293', '十月妈咪', '1282', '2', '0', 'full/55262411b60f1736dc63a1672ad3144f22992855.jpg', '/list/315566-16409.html');
INSERT INTO `sp_category` VALUES ('1294', '英氏', '1282', '2', '0', 'full/6e1b2474991a9f8b23420136b0293d417f746852.jpg', '/list/362006-17504.html');
INSERT INTO `sp_category` VALUES ('1295', '珠宝首饰', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('1296', '七波辉', '1282', '2', '0', 'full/2aa5d99b3ed991144f67e8986e47bdb5e0adfbc3.jpg', '/list/315053-46037.html');
INSERT INTO `sp_category` VALUES ('1297', '史努比', '1282', '2', '0', 'full/b8972f09c51927f60cdec639ed7ce30347e2fe13.jpg', '/list/315056-10122.html');
INSERT INTO `sp_category` VALUES ('1299', 'UOVO', '1282', '2', '0', 'full/8d2a3be78e7719026de3106b524844e5365dd6d6.jpg', '/list/315056-118373.html');
INSERT INTO `sp_category` VALUES ('1300', '良良', '1282', '2', '0', 'full/25339f1975a2179c267819c38a75c725c2fd06bb.jpg', '/list/500332-48079.html');
INSERT INTO `sp_category` VALUES ('1301', '黄金珠宝', '1295', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1302', '费雪', '1282', '2', '0', 'full/949a5131aa3ba75aa61bb6f14134db6b4d17839b.jpg', '/list/313119-12008.html');
INSERT INTO `sp_category` VALUES ('1303', '乐高', '1282', '2', '0', 'full/e8c5468d87129d0a9fac8307f87a65393d3a7b97.jpg', '/list/313128-45582.html');
INSERT INTO `sp_category` VALUES ('1304', '澳贝', '1282', '2', '0', 'full/875ce9f9debe9775886c6109f8e28ee90b16349f.jpg', '/list/313119-42323.html');
INSERT INTO `sp_category` VALUES ('1305', '迪士尼', '1282', '2', '0', 'full/e7c8b64572b4abde2ec611fa1fb2c31b6202af84.jpg', '/list/313119-10116.html');
INSERT INTO `sp_category` VALUES ('1306', '仙邦宝贝', '1282', '2', '0', 'full/b0e616c85c747aedcebbcd2d16bc784fbed646d8.jpg', '/list/313126-235827.html');
INSERT INTO `sp_category` VALUES ('1307', '芭比', '1282', '2', '0', 'full/915d7d9a51dae75558bb7a4691b82438625b3fca.jpg', '/list/313122-10818.html');
INSERT INTO `sp_category` VALUES ('1308', '捣蛋鬼', '1282', '2', '0', 'full/c66ee35274666e8b4da5351e7215381f85dbad5c.jpg', '/list/313125-119865.html');
INSERT INTO `sp_category` VALUES ('1309', '风火轮', '1282', '2', '0', 'full/959ef5f9db88eee0bc1fb2424fd5cc38e85d8f96.jpg', '/list/313118-12660.html');
INSERT INTO `sp_category` VALUES ('1310', '铂金', '1482', '2', '0', 'full/9b26e181bd4f57139ccd7b407c0a55200fb7edde.jpg', '//m.suning.com/search/铂金/?adTypeCode=1023&adId=铂金');
INSERT INTO `sp_category` VALUES ('1311', '首饰配饰', '1295', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1312', '银饰', '1301', '2', '0', 'full/af8cee103e13d54fd45388b8cd7a7afbc07dff0c.jpg', '//m.suning.com/search/银饰/?adTypeCode=1023&adId=银饰');
INSERT INTO `sp_category` VALUES ('1313', '水晶玛瑙', '1301', '2', '0', 'full/0ee631e8482574bb4176247437669b13973a467d.jpg', '//m.suning.com/search/水晶玛瑙/?adTypeCode=1023&adId=水晶玛瑙');
INSERT INTO `sp_category` VALUES ('1314', '投资金', '1301', '2', '0', 'full/256dacb60f1e6abf08e27e52ebc986f8f5288b08.jpg', '//m.suning.com/search/投资金/?adTypeCode=1023&adId=投资金');
INSERT INTO `sp_category` VALUES ('1315', '邮币', '1295', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1316', '钻石', '1301', '2', '0', 'full/009ae1dcc6304dfd9ac8ac2faa1ccfebccad055c.jpg', '//m.suning.com/search/钻石/?adTypeCode=1023&adId=钻石');
INSERT INTO `sp_category` VALUES ('1317', '木饰', '1301', '2', '0', 'full/68ab7fc7417926a975f9dd6496f2c7b5e3e77290.jpg', '//m.suning.com/search/木饰/?adTypeCode=1023&adId=木饰');
INSERT INTO `sp_category` VALUES ('1318', '珍珠', '1301', '2', '0', 'full/83d589ea20c682f2c925731d7fa43e707b9ba250.jpg', '//m.suning.com/search/珍珠/?adTypeCode=1023&adId=珍珠');
INSERT INTO `sp_category` VALUES ('1319', '彩宝', '1301', '2', '0', 'full/8731ddc28434364208ac6ed43b5ccb6efeecd883.jpg', '//m.suning.com/search/彩宝/?adTypeCode=1023&adId=彩宝');
INSERT INTO `sp_category` VALUES ('1320', '琥珀', '1301', '2', '0', 'full/0d37962fe521d7eb22e832ad9d452d88787d7632.jpg', '//m.suning.com/search/琥珀/?adTypeCode=1023&adId=琥珀');
INSERT INTO `sp_category` VALUES ('1321', '投资银', '1301', '2', '0', 'full/0a7e65eec543f69a3837c99f3c418eee5f8265cb.jpg', '//m.suning.com/search/投资银/?adTypeCode=1023&adId=投资银');
INSERT INTO `sp_category` VALUES ('1322', '翡翠玉石', '1301', '2', '0', 'full/64e0841f539e792b9a5c6cf363ab9bd4eb7ec82a.jpg', '//m.suning.com/search/翡翠/?adTypeCode=1023&adId=翡翠');
INSERT INTO `sp_category` VALUES ('1323', '戒指', '1482', '2', '0', 'full/4860bc252190c4976bb022b3f7849b4b49cff282.jpg', '//m.suning.com/search/戒指/?adTypeCode=1023&adId=戒指');
INSERT INTO `sp_category` VALUES ('1324', '手链', '1311', '2', '0', 'full/3a4a77417f42c49999245ba5b2cd3c8742679df8.jpg', '//m.suning.com/search/手链/?adTypeCode=1023&adId=手链');
INSERT INTO `sp_category` VALUES ('1325', '手镯', '1311', '2', '0', 'full/4d62cf77e03b313ceaa25a9dc9bedca92cf6db10.jpg', '//m.suning.com/search/手镯/?adTypeCode=1023&adId=手镯');
INSERT INTO `sp_category` VALUES ('1326', '吊坠/项链', '1311', '2', '0', 'full/cdd1fe6a6d2fe28cd56dec2b1d990d572dc0d64a.jpg', '//m.suning.com/search/项链/?adTypeCode=1023&adId=项链');
INSERT INTO `sp_category` VALUES ('1327', '品牌墙', '1295', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1328', '耳饰', '1311', '2', '0', 'full/d024df5c124a65a8765c9430cd26a2acb8b0d0b1.jpg', '//m.suning.com/search/耳饰/?adTypeCode=1023&adId=耳饰');
INSERT INTO `sp_category` VALUES ('1329', '发饰', '1311', '2', '0', 'full/90312a57616e69827b335e0833a5cbc68b24a270.jpg', '//m.suning.com/search/发饰/?adTypeCode=1023&adId=发饰');
INSERT INTO `sp_category` VALUES ('1330', '纪念币', '1482', '2', '0', 'full/968b3e5193e8b814dd887ad0e99cae227b5f9aa9.jpg', '//m.suning.com/search/纪念币/?adTypeCode=1023&adId=纪念币');
INSERT INTO `sp_category` VALUES ('1331', '邮票', '1315', '2', '0', 'full/02695c4709b42df8048c7da393bcfa4dc2e418c7.jpg', '//m.suning.com/search/邮票/?adTypeCode=1023&adId=邮票');
INSERT INTO `sp_category` VALUES ('1332', '古玩杂项', '1315', '2', '0', 'full/cb976e9fd7ad3e8c1c3beadd1e6f08b5a4674c50.jpg', '//m.suning.com/search/%E5%8F%A4%E7%8E%A9/?adTypeCode=1023&adId=%E5%8F%A4%E7%8E%A9');
INSERT INTO `sp_category` VALUES ('1333', '钱币', '1315', '2', '0', 'full/47610d719d176d2594134a779722a70071550e44.jpg', '//m.suning.com/search/%E9%92%B1%E5%B8%81/?adTypeCode=1023&adId=%E9%92%B1%E5%B8%81');
INSERT INTO `sp_category` VALUES ('1334', '金银币', '1315', '2', '0', 'full/ecba6f29ecef4b50161f09804a96ddef6cdee831.jpg', '//m.suning.com/search/%E9%87%91%E9%93%B6%E5%B8%81/?adTypeCode=1023&adId=%E9%87%91%E9%93%B6%E5%B8%81');
INSERT INTO `sp_category` VALUES ('1335', '智能设备', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('1336', '周大福', '1482', '2', '0', 'full/1e5463826050a5b028f918abf52b67bb1992c6ce.jpg', '//m.suning.com/search/周大福/?adTypeCode=1023&adId=周大福');
INSERT INTO `sp_category` VALUES ('1338', '钻石快线', '1327', '2', '0', 'full/1abc05dd52d6758e387e6dd305765d78abe76c2e.jpg', '//m.suning.com/search/钻石快线/?adTypeCode=1023&adId=钻石快线');
INSERT INTO `sp_category` VALUES ('1339', '六福珠宝', '1327', '2', '0', 'full/8c13478409633c7fd636f467dc3333e4a0288ba8.jpg', '//m.suning.com/search/六福珠宝/?adTypeCode=1023&adId=六福珠宝');
INSERT INTO `sp_category` VALUES ('1340', '菜百首饰', '1327', '2', '0', 'full/3c8af9a4c7b6f84b341370bb4195690ee492bbae.jpg', '//m.suning.com/search/菜百/?adTypeCode=1023&adId=菜百');
INSERT INTO `sp_category` VALUES ('1341', '金利福', '1327', '2', '0', 'full/cda0eb2e42b08fb88b71af6ff6c80e12a0632aca.jpg', '//m.suning.com/search/金利福/?adTypeCode=1023&adId=金利福');
INSERT INTO `sp_category` VALUES ('1342', '中国黄金', '1327', '2', '0', 'full/5ea56d91c26274526353326e3d422ec09e1e3f26.jpg', '//m.suning.com/search/中国黄金/?adTypeCode=1023&adId=中国黄金');
INSERT INTO `sp_category` VALUES ('1343', '智能酷玩', '1335', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1344', '印象眸', '1327', '2', '0', 'full/f93cd4023c892d467c3ff62021177b6fc2b024e1.jpg', '//m.suning.com/search/印象眸/?adTypeCode=1023&adId=印象眸');
INSERT INTO `sp_category` VALUES ('1345', '千寻海风', '1327', '2', '0', 'full/94d5b8ea80d6108e424c0206323b8d6592c4279f.jpg', '//m.suning.com/search/千寻海风/?adTypeCode=1023&adId=千寻海风');
INSERT INTO `sp_category` VALUES ('1346', '施华洛世奇', '1327', '2', '0', 'full/b60b25c5bcedc6229900e159bbef2e8f08891616.jpg', '//m.suning.com/search/施华洛世奇/?adTypeCode=1023&adId=施华洛世奇');
INSERT INTO `sp_category` VALUES ('1347', '老冯记', '1327', '2', '0', 'full/d2e2a8f197fbcef73409459aec868f0db32fb8df.jpg', '//m.suning.com/search/%E8%80%81%E5%86%AF%E8%AE%B0/?adTypeCode=1023&adId=%E8%80%81%E5%86%AF%E8%AE%B0');
INSERT INTO `sp_category` VALUES ('1348', '佐卡伊', '1327', '2', '0', 'full/3868029ad69d50df4c9c9a3727154ca308ec675b.jpg', '//m.suning.com/search/%E4%BD%90%E5%8D%A1%E4%BC%8A/?adTypeCode=1023&adId=%E4%BD%90%E5%8D%A1%E4%BC%8A');
INSERT INTO `sp_category` VALUES ('1349', '金一', '1327', '2', '0', 'full/4aa23226f8c4b3477c646587b0ed8d0ad4d562da.jpg', '//m.suning.com/search/%E9%87%91%E4%B8%80/?adTypeCode=1023&adId=%E9%87%91%E4%B8%80');
INSERT INTO `sp_category` VALUES ('1350', '潮流数码', '1335', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1351', '无人机', '1482', '2', '0', 'full/cadadea264403e4400870ee93d51b28add8cb1fe.jpg', '/list/500316-0.html');
INSERT INTO `sp_category` VALUES ('1352', '智能家居', '1335', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1353', '平衡车', '1482', '2', '0', 'full/11a510cb4915035f43ca35b87ab863461dd61c89.jpg', '/list/420086-0.html');
INSERT INTO `sp_category` VALUES ('1354', '智能手环', '1343', '2', '0', 'full/9e720ac9681cfafcefe2c4479a963d058c40607f.jpg', '/list/410505-0.html');
INSERT INTO `sp_category` VALUES ('1355', 'VR眼镜', '1343', '2', '0', 'full/5eeb07cfdbcd49a66a5b2ceeb677fc1753738a71.jpg', '/list/500685-0.html');
INSERT INTO `sp_category` VALUES ('1356', '智能手表', '1343', '2', '0', 'full/906d55946aa1f33e91b48a9935f41deba7fadff0.jpg', '/list/410504-0.html');
INSERT INTO `sp_category` VALUES ('1357', '电子教育', '1335', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1358', '耳机耳麦', '1482', '2', '0', 'full/cec82af42e24d626d82017f1698a3497038e9ebf.jpg', '/list/232003-0.html');
INSERT INTO `sp_category` VALUES ('1359', '播放器', '1350', '2', '0', 'full/c15a4d7aa72136aef861f1b4f41cab1a3377a463.jpg', '/list/20092-0.html');
INSERT INTO `sp_category` VALUES ('1360', '蓝牙耳机', '1350', '2', '0', 'full/00f42017770a5a05289b4f4cea0b0e85629d2051.jpg', '/list/308503-0.html');
INSERT INTO `sp_category` VALUES ('1361', '蓝牙音箱', '1350', '2', '0', 'full/c902293ba800ac51c72189043f0d198b6a55a400.jpg', '/list/125008-0.html');
INSERT INTO `sp_category` VALUES ('1362', '收录机', '1350', '2', '0', 'full/1643979a1c1b72246b652336910979cc847acde9.jpg', '/list/20096-0.html');
INSERT INTO `sp_category` VALUES ('1363', '录音笔', '1350', '2', '0', 'full/96094fdd41ee259f2ae0707662d1fee2c04ebcdd.jpg', '/list/20095-0.html');
INSERT INTO `sp_category` VALUES ('1364', '智能门锁', '1482', '2', '0', 'full/d663ef4c58dd8a4ca2bb645080ff3fa277d706b3.jpg', '/list/501295-0.html');
INSERT INTO `sp_category` VALUES ('1365', '智能摄像头', '1352', '2', '0', 'full/e84d6a55ab6f8025c745cb0fd65c08cf6cb04181.jpg', '/list/501293-0.html');
INSERT INTO `sp_category` VALUES ('1366', '智能健康', '1352', '2', '0', 'full/1972abb93b65adfe62749691bb59ba7b479e7e9d.jpg', '/list/410506-0.html');
INSERT INTO `sp_category` VALUES ('1367', '品牌墙', '1335', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1368', '电子词典', '1482', '2', '0', 'full/03764df8a101b363e60aa33e03e0bc78fe325c81.jpg', '/list/20106-0.html');
INSERT INTO `sp_category` VALUES ('1369', '钟表眼镜', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('1370', '智能机器人', '1357', '2', '0', 'full/2e0e9e55d783914aa27a132530a6da654f39482e.jpg', '/list/501294-0.html');
INSERT INTO `sp_category` VALUES ('1371', '电纸书', '1357', '2', '0', 'full/a6378d058bd70d3ed0b9183f091b8e2ebea785d0.jpg', '/list/20107-0.html');
INSERT INTO `sp_category` VALUES ('1373', '点读机', '1357', '2', '0', 'full/2c7b06aa7feda5e9f50f7d098600c3aabbf161dc.jpg', '/list/336005-0.html');
INSERT INTO `sp_category` VALUES ('1374', '点读笔', '1357', '2', '0', 'full/e8c47a5571e3925d7ae1bc7464ce75629b861af6.jpg', '/list/20104-0.html');
INSERT INTO `sp_category` VALUES ('1375', '精品钟表', '1369', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1376', '复读机', '1357', '2', '0', 'full/3de148e7f40e4dd0044ef7a023dec50c2463441d.jpg', '/list/25502-0.html');
INSERT INTO `sp_category` VALUES ('1377', '小蚁', '1367', '2', '0', 'full/0720080c8f71e606f8a7b26e2a7f905480cfdb07.jpg', '/list/410503-732678.html');
INSERT INTO `sp_category` VALUES ('1378', '360', '1367', '2', '0', 'full/2ea56f9b180ce9b7a436bf93d42ae9c35d3ba926.jpg', 'https://shop.m.suning.com/30000761.html');
INSERT INTO `sp_category` VALUES ('1379', 'AKG', '1367', '2', '0', 'full/fe9d7fdaa353f8151e37115f216c61b81434d5bc.jpg', '/list/20090-10264.html');
INSERT INTO `sp_category` VALUES ('1380', 'Beats', '1367', '2', '0', 'full/28a5998e5f66d72be857dd7ba94835ad338dcb25.jpg', '/list/20090-43031.html');
INSERT INTO `sp_category` VALUES ('1381', 'JBL', '1367', '2', '0', 'full/399ecd22527b51c38dce3e3a1a945a7e7cdc9621.jpg', '/list/20090-10421.html');
INSERT INTO `sp_category` VALUES ('1382', '男士手表', '1482', '2', '0', 'full/b0ae6ed1d4427e4f46e83d19db6993a9e025b334.jpg', '//m.suning.com/search/%E7%94%B7%E8%A1%A8/?adTypeCode=1023&adId=%E7%94%B7%E8%A1%A8');
INSERT INTO `sp_category` VALUES ('1383', '眼镜', '1369', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1384', '女士手表', '1482', '2', '0', 'full/f231bf43e0e3ea3a8febeb6725facafe6d192e23.jpg', '//m.suning.com/search/%E5%A5%B3%E8%A1%A8/?adTypeCode=1023&adId=%E5%A5%B3%E8%A1%A8');
INSERT INTO `sp_category` VALUES ('1385', '情侣手表', '1375', '2', '0', 'full/623c6b1ffd6202b3ba5ad093bbf5fe7194e318d3.jpg', '//m.suning.com/search/%E6%83%85%E4%BE%A3%E8%A1%A8/?adTypeCode=1023&adId=%E6%83%85%E4%BE%A3%E8%A1%A8');
INSERT INTO `sp_category` VALUES ('1386', '瑞士手表', '1375', '2', '0', 'full/7c4a30cba106e40f4d0f44c0bc007af123a31106.jpg', '//m.suning.com/search/瑞士手表/?adTypeCode=1023&adId=瑞士手表');
INSERT INTO `sp_category` VALUES ('1387', '机械表', '1375', '2', '0', 'full/63cada601467d07c2894002cd8779af024f53d20.jpg', '//m.suning.com/search/机械表/?adTypeCode=1023&adId=机械表');
INSERT INTO `sp_category` VALUES ('1388', '石英手表', '1375', '2', '0', 'full/1ab6fd827964e767e3dce36936d1b7f46d6a480c.jpg', '//m.suning.com/search/石英表/?adTypeCode=1023&adId=石英表');
INSERT INTO `sp_category` VALUES ('1389', '电子表', '1375', '2', '0', 'full/eefd901df5dcec0ca260b94ec6e289ad131141e6.jpg', '//m.suning.com/search/电子表/?adTypeCode=1023&adId=电子表');
INSERT INTO `sp_category` VALUES ('1390', '闹钟', '1375', '2', '0', 'full/7403324e1507120462a045c9e0da3ff9583a7391.jpg', '//m.suning.com/search/闹钟/?adTypeCode=1023&adId=闹钟');
INSERT INTO `sp_category` VALUES ('1391', '挂钟', '1375', '2', '0', 'full/f641dd401c45a81bc1e3581c00e6bbee7cdcff4f.jpg', '//m.suning.com/search/挂钟/?adTypeCode=1023&adId=挂钟');
INSERT INTO `sp_category` VALUES ('1392', '太阳镜', '1482', '2', '0', 'full/27a836bd858ea816afc42a47b1a86a3f992fde24.jpg', '//m.suning.com/search/太阳镜/?adTypeCode=1023&adId=太阳镜');
INSERT INTO `sp_category` VALUES ('1393', '近视镜', '1383', '2', '0', 'full/6f64c075477e9d272cf29719a9692a74e8349117.jpg', '//m.suning.com/search/近视镜/?adTypeCode=1023&adId=近视镜');
INSERT INTO `sp_category` VALUES ('1394', '老花镜', '1383', '2', '0', 'full/9745371c95668e73a25d731629cc36510cf7ee74.jpg', '//m.suning.com/search/老花镜/?adTypeCode=1023&adId=老花镜');
INSERT INTO `sp_category` VALUES ('1395', '暴龙', '1383', '2', '0', 'full/d55c04cb3df832fed7d76232331afd8d2374e49d.jpg', '//m.suning.com/search/暴龙/?adTypeCode=1023&adId=暴龙');
INSERT INTO `sp_category` VALUES ('1396', '威古氏', '1383', '2', '0', 'full/7c8ed5cd1040d2a2ca00042f64dd1e8c45e016ed.jpg', '//m.suning.com/search/威古氏/?adTypeCode=1023&adId=威古氏');
INSERT INTO `sp_category` VALUES ('1397', '品牌墙', '1369', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1398', '帕森', '1383', '2', '0', 'full/0e7fc3b3776e5c90a936a08bf4d86264d26c5e50.jpg', '//m.suning.com/search/帕森/?adTypeCode=1023&adId=帕森');
INSERT INTO `sp_category` VALUES ('1399', 'MSMK', '1383', '2', '0', 'full/a3bbec24e71b359ef67a537b8416b75281c27bfd.jpg', '//m.suning.com/search/MSMK/?adTypeCode=1023&adId=MSMK');
INSERT INTO `sp_category` VALUES ('1400', '音米', '1383', '2', '0', 'full/e1b69896a1ddc4a15f5bd6f4af671921b46c374f.jpg', '//m.suning.com/search/%E9%9F%B3%E7%B1%B3/?adTypeCode=1023&adId=%E9%9F%B3%E7%B1%B3');
INSERT INTO `sp_category` VALUES ('1401', '帕莎', '1383', '2', '0', 'full/2929179087ee5c8180936c00d1a49af92f76135b.jpg', '//m.suning.com/search/帕莎/?adTypeCode=1023&adId=帕莎');
INSERT INTO `sp_category` VALUES ('1402', '皮具箱包', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('1403', '阿玛尼', '1482', '2', '0', 'full/28a4ac98f34417f259eaf2ddbf15de6e12c3cdfb.jpg', '//m.suning.com/search/阿玛尼手表/?adTypeCode=1023&adId=阿玛尼手表');
INSERT INTO `sp_category` VALUES ('1404', '天梭', '1397', '2', '0', 'full/81102326d445b33b078b496ef01b87f94394e8d9.jpg', '//m.suning.com/search/天梭/?adTypeCode=1023&adId=天梭');
INSERT INTO `sp_category` VALUES ('1406', '浪琴', '1397', '2', '0', 'full/5b45dd6918f6a19d9e74b0ac061511b115eaecd7.jpg', '//m.suning.com/search/浪琴/?adTypeCode=1023&adId=浪琴');
INSERT INTO `sp_category` VALUES ('1407', '卡西欧', '1397', '2', '0', 'full/8e5a0c90aea0b9d907a6df7e85427f7078b16fe4.jpg', '//m.suning.com/search/卡西欧表/?adTypeCode=1023&adId=卡西欧表');
INSERT INTO `sp_category` VALUES ('1408', '罗西尼', '1397', '2', '0', 'full/4d806f9a3969a3ecf74728ee986db82c9dc2acb9.jpg', '//m.suning.com/search/罗西尼/?adTypeCode=1023&adId=罗西尼');
INSERT INTO `sp_category` VALUES ('1409', '宾格', '1397', '2', '0', 'full/8d1079eaf47cdfa95995f194dd825f50e2039ce2.jpg', '//m.suning.com/search/宾格/?adTypeCode=1023&adId=宾格');
INSERT INTO `sp_category` VALUES ('1410', '功能箱包', '1402', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1411', '天王', '1397', '2', '0', 'full/3f03def4e62c42a526210f51460a596c2cb073b2.jpg', '//m.suning.com/search/天王/?adTypeCode=1023&adId=天王');
INSERT INTO `sp_category` VALUES ('1412', 'DW', '1397', '2', '0', 'full/19567c7e78dfb883570de3e25be3f5c3ebc3726f.jpg', '//m.suning.com/search/DW/?adTypeCode=1023&adId=DW');
INSERT INTO `sp_category` VALUES ('1413', '飞亚达', '1397', '2', '0', 'full/8322ed30bc6c52f0b4148fd90595702de931fe4d.jpg', '//m.suning.com/search/飞亚达/?adTypeCode=1023&adId=飞亚达');
INSERT INTO `sp_category` VALUES ('1414', 'CK', '1397', '2', '0', 'full/a8a3967610c035c6347cc9fa66ba3eaa8b449431.jpg', '//m.suning.com/search/CK手表/?adTypeCode=1023&adId=CK手表');
INSERT INTO `sp_category` VALUES ('1415', '艾戈勒', '1397', '2', '0', 'full/b2c05f247c5f407a98578306dc705f7db85a2888.jpg', '//m.suning.com/search/艾戈勒/?adTypeCode=1023&adId=艾戈勒');
INSERT INTO `sp_category` VALUES ('1416', '美度', '1397', '2', '0', 'full/9d5f8c73bf6c37891250a47e1cbace976d02ddd9.jpg', '//m.suning.com/search/美度/?adTypeCode=1023&adId=美度');
INSERT INTO `sp_category` VALUES ('1417', '拉杆箱', '1482', '2', '0', 'full/d053795d84ecb2b2cb9b3daa5e9db21e35a8dff2.jpg', '//m.suning.com/search/拉杆箱/?adTypeCode=1023&adId=拉杆箱');
INSERT INTO `sp_category` VALUES ('1418', '书包', '1482', '2', '0', 'full/cb969d6562ed64ac462d12080d192ad40c1d30bb.jpg', '//m.suning.com/search/书包/?adTypeCode=1023&adId=书包');
INSERT INTO `sp_category` VALUES ('1419', '时尚女包', '1402', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1420', '男包皮具', '1402', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1421', '背包', '1410', '2', '0', 'full/c74b058ee805269eda1aa6a8415f24fbe9925e6b.jpg', '//m.suning.com/search/双肩背包/?adTypeCode=1023&adId=双肩背包');
INSERT INTO `sp_category` VALUES ('1422', '旅行包', '1410', '2', '0', 'full/f2d1b9ec9d890b913e6b33eccfa286f8f3aada6f.jpg', '//m.suning.com/search/旅行包/?adTypeCode=1023&adId=旅行包');
INSERT INTO `sp_category` VALUES ('1423', '胸包', '1410', '2', '0', 'full/e4e96315bbe49613ccd7c2d02c228ef79c69aaec.jpg', '//m.suning.com/search/胸包/?adTypeCode=1023&adId=胸包');
INSERT INTO `sp_category` VALUES ('1424', '登山包', '1410', '2', '0', 'full/5db0f6923b93f743d7bff70b8f17d8bf22d668fa.jpg', '//m.suning.com/search/登山包/?adTypeCode=1023&adId=登山包');
INSERT INTO `sp_category` VALUES ('1425', '腰包', '1410', '2', '0', 'full/0daf350ccea7581c17c9893613b8a8b1c061ef04.jpg', '//m.suning.com/search/腰包/?adTypeCode=1023&adId=腰包');
INSERT INTO `sp_category` VALUES ('1426', '箱包配件', '1410', '2', '0', 'full/f67251089b8cfeb2ae0561615bf124dace0b3f45.jpg', '/list/344285-0.html');
INSERT INTO `sp_category` VALUES ('1427', '单肩包', '1482', '2', '0', 'full/9378ba86e87e088bef73a55ab6dc1e072be9b9fc.jpg', '//m.suning.com/search/女士单肩包/?adTypeCode=1023&adId=女士单肩包');
INSERT INTO `sp_category` VALUES ('1428', '品牌墙', '1402', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1429', '双肩包', '1419', '2', '0', 'full/cd4a6f996d398171205034fd611f41573fd2d378.jpg', '//m.suning.com/search/女士双肩包/?adTypeCode=1023&adId=女士双肩包');
INSERT INTO `sp_category` VALUES ('1430', '斜挎包', '1419', '2', '0', 'full/001a5df171785c1b3faefc3274bbec673c2bae53.jpg', '//m.suning.com/search/女士斜挎包/?adTypeCode=1023&adId=女士斜挎包');
INSERT INTO `sp_category` VALUES ('1431', '钱包', '1419', '2', '0', 'full/80f66f5c4f2fe81f4b80f0e3c14c52c3c0d752da.jpg', '//m.suning.com/search/钱包女/?adTypeCode=1023&adId=钱包女');
INSERT INTO `sp_category` VALUES ('1432', '手提包', '1419', '2', '0', 'full/c2dd141d0952068752b32f92f5a479c232318ab5.jpg', '//m.suning.com/search/女士手提包/?adTypeCode=1023&adId=女士手提包');
INSERT INTO `sp_category` VALUES ('1433', '手拿包', '1419', '2', '0', 'full/807535d5326de6092f28de413000a2cd6be6bc2a.jpg', '//m.suning.com/search/手拿包女/?adTypeCode=1023&adId=手拿包女');
INSERT INTO `sp_category` VALUES ('1434', '钱包', '1482', '2', '0', 'full/c5689e3ed81280d61dd74bc013db198bd445135d.jpg', '//m.suning.com/search/钱包男/?adTypeCode=1023&adId=钱包男');
INSERT INTO `sp_category` VALUES ('1435', '单肩包', '1420', '2', '0', 'full/0a92e7f01adc25db46ea20ce063cbd7ce51a7385.jpg', '//m.suning.com/search/男士单肩包/?adTypeCode=1023&adId=男士单肩包');
INSERT INTO `sp_category` VALUES ('1436', '斜挎包', '1420', '2', '0', 'full/8295cd16eaab592c7f6e8d527d69d98c4a230756.jpg', '//m.suning.com/search/男士斜挎包/?adTypeCode=1023&adId=男士斜挎包');
INSERT INTO `sp_category` VALUES ('1437', '男士手提包', '1420', '2', '0', 'full/265fc5470466fdeba9a162685ac9f17ede910206.jpg', '//m.suning.com/search/手提包男/?adTypeCode=1023&adId=手提包男');
INSERT INTO `sp_category` VALUES ('1438', '皮具套装', '1420', '2', '0', 'full/cdb6e8293ee400afa422475de204ef543dfad976.jpg', '/list/344294-0.html');
INSERT INTO `sp_category` VALUES ('1439', '男士手拿包', '1420', '2', '0', 'full/cbffda1a5348519c2f61cb347fc3557d459c1024.jpg', '//m.suning.com/search/手拿包男/?adTypeCode=1023&adId=手拿包男');
INSERT INTO `sp_category` VALUES ('1440', '斐格', '1482', '2', '0', 'full/3c2187195a83283808007a087c33e981dabec30b.jpg', '//m.suning.com/search/斐格/?adTypeCode=1023&adId=斐格');
INSERT INTO `sp_category` VALUES ('1441', '邮币乐器', '0', '0', '0', '', '');
INSERT INTO `sp_category` VALUES ('1443', '七匹狼', '1428', '2', '0', 'full/dfaaa82885a49c05a634926d6762cb25b5ead8ba.jpg', '//m.suning.com/search/七匹狼包/?adTypeCode=1023&adId=七匹狼包');
INSERT INTO `sp_category` VALUES ('1444', '礼品', '1441', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1445', '梦特娇', '1428', '2', '0', 'full/dff492d41eb0a832eb5b2db4e5731c1d55bc3db1.jpg', '//m.suning.com/search/梦特娇/?adTypeCode=1023&adId=梦特娇');
INSERT INTO `sp_category` VALUES ('1446', '美洲野牛', '1428', '2', '0', 'full/494e9c02483bb4934dda01285124714dccdc7956.jpg', '//m.suning.com/search/美洲野牛/?adTypeCode=1023&adId=美洲野牛');
INSERT INTO `sp_category` VALUES ('1447', '啄木鸟', '1428', '2', '0', 'full/f10156996e51c0e6c72ed4f02b86a7b1a0c20d96.jpg', '//m.suning.com/search/啄木鸟/?adTypeCode=1023&adId=啄木鸟');
INSERT INTO `sp_category` VALUES ('1448', '帕迪欧', '1428', '2', '0', 'full/02f7904cbb21b8e29f0c2ffafa458bf05426dc7e.jpg', '//m.suning.com/search/帕迪欧/?adTypeCode=1023&adId=帕迪欧');
INSERT INTO `sp_category` VALUES ('1449', '非常保罗', '1428', '2', '0', 'full/3237e6457956c445481a6cee1da961d6e24b8b09.jpg', '//m.suning.com/search/非常保罗/?adTypeCode=1023&adId=非常保罗');
INSERT INTO `sp_category` VALUES ('1450', '爱华仕', '1428', '2', '0', 'full/346a13d2a457108cea91f133a9307cecd6e7ee05.jpg', '//m.suning.com/search/爱华仕/?adTypeCode=1023&adId=爱华仕');
INSERT INTO `sp_category` VALUES ('1451', 'COACH', '1428', '2', '0', 'full/d669796643a973dddd2d24bfb69610a5ee980d10.jpg', '//m.suning.com/search/COACH/?adTypeCode=1023&adId=COACH');
INSERT INTO `sp_category` VALUES ('1452', '特斯黛', '1428', '2', '0', 'full/a9f2368716d43819ba022debb780d2a94495a192.jpg', '//m.suning.com/search/特斯黛/?adTypeCode=1023&adId=特斯黛');
INSERT INTO `sp_category` VALUES ('1453', 'doodoo', '1428', '2', '0', 'full/bc8dfc3ca2a7778442e2c38f92fba1f661487c15.jpg', '//m.suning.com/search/doodoo/?adTypeCode=1023&adId=doodoo');
INSERT INTO `sp_category` VALUES ('1454', 'MK', '1428', '2', '0', 'full/2355bb158ce39eb6d64656b816352e50a45147ab.jpg', '//m.suning.com/search/MK/?adTypeCode=1023&adId=MK');
INSERT INTO `sp_category` VALUES ('1455', '邮币', '1441', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1456', '创意礼品', '1482', '2', '0', 'full/726296c696d8f26b6f4f19831abf8348c8a9e1c1.jpg', '//m.suning.com/search/创意礼品/?adTypeCode=1023&adId=创意礼品');
INSERT INTO `sp_category` VALUES ('1457', '打火机', '1482', '2', '0', 'full/27a301c31bfd186814119333c3f718c5bc1281f2.jpg', '//m.suning.com/search/打火机/?adTypeCode=1023&adId=打火机');
INSERT INTO `sp_category` VALUES ('1458', '电子烟', '1444', '2', '0', 'full/f56b90aec0620eb1e1c6bc6ab99f2592223ec175.jpg', '//m.suning.com/search/电子烟/?adTypeCode=1023&adId=电子烟');
INSERT INTO `sp_category` VALUES ('1459', '工艺摆件', '1444', '2', '0', 'full/0181d14c847c8098e242ff5e945f19c5c4eacbb5.jpg', '//m.suning.com/search/工艺摆件/?adTypeCode=1023&adId=工艺摆件');
INSERT INTO `sp_category` VALUES ('1460', '婚庆节庆', '1444', '2', '0', 'full/0c9254b0adfaa4d892ea45e9f4776d4b4178d46a.jpg', '//m.suning.com/search/婚庆节庆/?adTypeCode=1023&adId=婚庆节庆');
INSERT INTO `sp_category` VALUES ('1461', '礼物', '1444', '2', '0', 'full/8b673239c2fed67f0806f7ad3d1b9c35649514ab.jpg', '//m.suning.com/search/礼物/?adTypeCode=1023&adId=礼物');
INSERT INTO `sp_category` VALUES ('1462', '瑞士军刀', '1444', '2', '0', 'full/9c3c21fffa255b1d52693a9774ac670160dc37f2.jpg', '//m.suning.com/search/瑞士军刀刀/?adTypeCode=1023&adId=瑞士军刀刀');
INSERT INTO `sp_category` VALUES ('1463', '收藏品', '1444', '2', '0', 'full/ce8d52e71716b17b10c1b1aeace08429e84ca0a5.jpg', '//m.suning.com/search/收藏品/?adTypeCode=1023&adId=收藏品');
INSERT INTO `sp_category` VALUES ('1464', '乐器', '1441', '1', '0', '', '');
INSERT INTO `sp_category` VALUES ('1465', '影视周边', '1444', '2', '0', 'full/247f65fa33cf6d1dbe7f618430a328cdacaf4d34.jpg', '//m.suning.com/search/苏宁影城/?adTypeCode=1023&adId=苏宁影城');
INSERT INTO `sp_category` VALUES ('1466', '邮票', '1455', '2', '0', 'full/02695c4709b42df8048c7da393bcfa4dc2e418c7.jpg', '//m.suning.com/search/邮票/?adTypeCode=1023&adId=邮票');
INSERT INTO `sp_category` VALUES ('1467', '古玩杂项', '1455', '2', '0', 'full/cb976e9fd7ad3e8c1c3beadd1e6f08b5a4674c50.jpg', '//m.suning.com/search/%E5%8F%A4%E7%8E%A9/?adTypeCode=1023&adId=%E5%8F%A4%E7%8E%A9');
INSERT INTO `sp_category` VALUES ('1468', '钱币', '1455', '2', '0', 'full/47610d719d176d2594134a779722a70071550e44.jpg', '//m.suning.com/search/%E9%92%B1%E5%B8%81/?adTypeCode=1023&adId=%E9%92%B1%E5%B8%81');
INSERT INTO `sp_category` VALUES ('1469', '金银币', '1455', '2', '0', 'full/ecba6f29ecef4b50161f09804a96ddef6cdee831.jpg', '//m.suning.com/search/%E9%87%91%E9%93%B6%E5%B8%81/?adTypeCode=1023&adId=%E9%87%91%E9%93%B6%E5%B8%81');
INSERT INTO `sp_category` VALUES ('1470', '电钢琴', '1482', '2', '0', 'full/9853745e27d4c369b0b2ccdb7c82206c40fa0ef2.jpg', '//m.suning.com/search/电钢琴/?adTypeCode=1023&adId=电钢琴');
INSERT INTO `sp_category` VALUES ('1471', '电子鼓', '1464', '2', '0', 'full/4faf3a405ed19a22776ae136bf056a21742929c7.jpg', '//m.suning.com/search/电子鼓/?adTypeCode=1023&adId=电子鼓');
INSERT INTO `sp_category` VALUES ('1472', '二胡', '1464', '2', '0', 'full/811f12bc2fc6f154d7f762fd2ff3b10fe5a09cc2.jpg', '//m.suning.com/search/二胡/?adTypeCode=1023&adId=二胡');
INSERT INTO `sp_category` VALUES ('1473', '钢琴', '1464', '2', '0', 'full/8a5cd2fc4af15e82a3de276357b2fe670f68b9e0.jpg', '//m.suning.com/search/钢琴/?adTypeCode=1023&adId=钢琴');
INSERT INTO `sp_category` VALUES ('1474', '古琴', '1464', '2', '0', 'full/9e2a3887f8a80d7acd0710862a37f1151a0254e7.jpg', '//m.suning.com/search/古琴/?adTypeCode=1023&adId=古琴');
INSERT INTO `sp_category` VALUES ('1475', '古筝', '1464', '2', '0', 'full/ce51352c554400a7ea32a3f9f6acdbc2b0fdb7dc.jpg', '//m.suning.com/search/古筝/?adTypeCode=1023&adId=古筝');
INSERT INTO `sp_category` VALUES ('1476', '吉他', '1464', '2', '0', 'full/b4e89aadbed99f0aaacc344ac97229856160e314.jpg', '//m.suning.com/search/吉他/?adTypeCode=1023&adId=吉他');
INSERT INTO `sp_category` VALUES ('1477', '口琴', '1464', '2', '0', 'full/092a57cf37ec64e62619d9f8b7df69e5f25cac1d.jpg', '//m.suning.com/search/口琴/?adTypeCode=1023&adId=口琴');
INSERT INTO `sp_category` VALUES ('1478', '小提琴', '1464', '2', '0', 'full/f66495cfd1549dabf9468ae5bfebc4af4a28c35b.jpg', '//m.suning.com/search/小提琴/?adTypeCode=1023&adId=小提琴');
INSERT INTO `sp_category` VALUES ('1479', '乐器配件', '1464', '2', '0', 'full/bd5ac9dc0ebc8920aa64297ad373d7e607c0f037.jpg', '//m.suning.com/search/乐器配件/?adTypeCode=1023&adId=乐器配件');
INSERT INTO `sp_category` VALUES ('1480', '其他', '0', '0', '0', null, null);
INSERT INTO `sp_category` VALUES ('1482', '热门关键词', '1480', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1483', 'asdfasfd', '0', '0', '1', null, null);
INSERT INTO `sp_category` VALUES ('1484', 'test1', '0', '0', '1', null, null);
INSERT INTO `sp_category` VALUES ('1485', 'test2', '1484', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1486', 'test3', '1485', '2', '0', null, null);
INSERT INTO `sp_category` VALUES ('1487', '情趣用品', '0', '0', '0', null, null);
INSERT INTO `sp_category` VALUES ('1488', '杜蕾斯Durex', '1487', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1489', '冈本', '1487', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1490', '杰士邦', '1487', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1491', '大象', '1487', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1492', '冈本001', '1489', '2', '0', null, null);
INSERT INTO `sp_category` VALUES ('1493', '冈本003', '1489', '2', '0', null, null);
INSERT INTO `sp_category` VALUES ('1494', '杜蕾斯超薄套装', '1488', '2', '0', null, null);
INSERT INTO `sp_category` VALUES ('1495', 'test123', '0', '0', '1', null, null);
INSERT INTO `sp_category` VALUES ('1496', '123', '1491', '2', '1', null, null);
INSERT INTO `sp_category` VALUES ('1497', '123', '1490', '2', '1', null, null);
INSERT INTO `sp_category` VALUES ('1498', '黑丝我的最爱^-^', '1487', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1499', '当然还有白丝和渔网(*ෆ´ ˘ `ෆ*)♡', '1487', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1500', '旅游', '0', '0', '0', null, null);
INSERT INTO `sp_category` VALUES ('1501', '湖南长沙', '1500', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1502', '湖北武汉', '1500', '1', '0', null, null);
INSERT INTO `sp_category` VALUES ('1503', '性感蕾丝低腰包臀平角裤', '1487', '1', '1', null, null);
INSERT INTO `sp_category` VALUES ('1504', '凸点螺纹装', '1488', '2', '0', null, null);
INSERT INTO `sp_category` VALUES ('1505', '美菱', '45', '2', '0', null, null);

-- ----------------------------
-- Table structure for sp_consignee
-- ----------------------------
DROP TABLE IF EXISTS `sp_consignee`;
CREATE TABLE `sp_consignee` (
  `cgn_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int NOT NULL COMMENT '会员id',
  `cgn_name` varchar(32) NOT NULL COMMENT '收货人名称',
  `cgn_address` varchar(200) NOT NULL DEFAULT '' COMMENT '收货人地址',
  `cgn_tel` varchar(20) NOT NULL DEFAULT '' COMMENT '收货人电话',
  `cgn_code` char(6) NOT NULL DEFAULT '' COMMENT '邮编',
  `delete_time` int DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`cgn_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='收货人表';

-- ----------------------------
-- Records of sp_consignee
-- ----------------------------
INSERT INTO `sp_consignee` VALUES ('1', '133', '王二柱', '北京市海淀区苏州街长远天地大厦305室', '13566771298', '306810', null);
INSERT INTO `sp_consignee` VALUES ('2', '133', '铁锤', '北京市海淀区西北旺用友大厦777室', '13126537865', '600981', null);
INSERT INTO `sp_consignee` VALUES ('3', '224', '鸭蛋', '北京市海淀区西三旗建材城西路中腾大厦15室', '18902564321', '600214', null);
INSERT INTO `sp_consignee` VALUES ('4', '224', '赵大海', '北京市海淀区中关村大街太平洋大厦801室', '15765329087', '600983', null);
INSERT INTO `sp_consignee` VALUES ('5', '226', '变形金刚', '北京市海淀区人大西门和平小区2#4门', '15028374375', '600912', null);
INSERT INTO `sp_consignee` VALUES ('6', '226', '葫芦娃', '北京市海淀区软件园软件大厦10室', '18679871209', '600011', null);
INSERT INTO `sp_consignee` VALUES ('12', '11', '111', '111', '111', '11', null);
INSERT INTO `sp_consignee` VALUES ('13', '11', 'asdasd', 'sdasd', '11111', '111111', null);

-- ----------------------------
-- Table structure for sp_express
-- ----------------------------
DROP TABLE IF EXISTS `sp_express`;
CREATE TABLE `sp_express` (
  `express_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` int unsigned NOT NULL COMMENT '订单id',
  `express_com` varchar(32) DEFAULT NULL COMMENT '订单快递公司名称',
  `express_nu` varchar(32) DEFAULT NULL COMMENT '快递单编号',
  `create_time` int unsigned NOT NULL COMMENT '记录生成时间',
  `update_time` int unsigned NOT NULL COMMENT '记录修改时间',
  PRIMARY KEY (`express_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='快递表';

-- ----------------------------
-- Records of sp_express
-- ----------------------------
INSERT INTO `sp_express` VALUES ('1', '54', 'huitongkuaidi', '70365716896101', '0', '0');
INSERT INTO `sp_express` VALUES ('2', '53', 'yuantong', 'sdfsfdw22ew32ed23wd2e2e', '1508985920', '1508985920');
INSERT INTO `sp_express` VALUES ('3', '48', 'yuantong', 'arfeesefsfsffw4ttefre', '1510025511', '1510025511');
INSERT INTO `sp_express` VALUES ('4', '46', 'yuantong', 'sadsdsd', '1510835549', '1510835549');

-- ----------------------------
-- Table structure for sp_goods
-- ----------------------------
DROP TABLE IF EXISTS `sp_goods`;
CREATE TABLE `sp_goods` (
  `goods_id` mediumint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `goods_name` varchar(255) NOT NULL COMMENT '商品名称',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '商品价格',
  `goods_number` int unsigned NOT NULL DEFAULT '0' COMMENT '商品数量',
  `goods_weight` smallint unsigned NOT NULL DEFAULT '0' COMMENT '商品重量',
  `cat_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT '类型id',
  `goods_introduce` text COMMENT '商品详情介绍',
  `goods_big_logo` char(128) NOT NULL DEFAULT '' COMMENT '图片logo大图',
  `goods_small_logo` char(128) NOT NULL DEFAULT '' COMMENT '图片logo小图',
  `is_del` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:正常  1:删除',
  `add_time` int NOT NULL COMMENT '添加商品时间',
  `upd_time` int NOT NULL COMMENT '修改商品时间',
  `delete_time` int DEFAULT NULL COMMENT '软删除标志字段',
  `cat_one_id` smallint DEFAULT '0' COMMENT '一级分类id',
  `cat_two_id` smallint DEFAULT '0' COMMENT '二级分类id',
  `cat_three_id` smallint DEFAULT '0' COMMENT '三级分类id',
  `hot_mumber` int unsigned DEFAULT '0' COMMENT '热卖数量',
  `is_promote` smallint DEFAULT '0' COMMENT '是否促销',
  `goods_state` int DEFAULT '0' COMMENT '商品状态 0: 未通过 1: 审核中 2: 已审核',
  PRIMARY KEY (`goods_id`),
  UNIQUE KEY `goods_name` (`goods_name`),
  KEY `goods_price` (`goods_price`),
  KEY `add_time` (`add_time`),
  KEY `goods_name_2` (`goods_name`)
) ENGINE=InnoDB AUTO_INCREMENT=946 DEFAULT CHARSET=utf8 COMMENT='商品表';

-- ----------------------------
-- Records of sp_goods
-- ----------------------------
INSERT INTO `sp_goods` VALUES ('1', '南极人女士三角内裤 中腰可爱无痕女士内裤 均码 k102P1027', '49.00', '100', '100', '1191', '<div class=\"lazyimg\"><div moduleid=\"R9000475_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/138920341921275653753268_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/138920341921275653753268_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/320294018209000122936780_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/320294018209000122936780_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/704928021836697029300000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/704928021836697029300000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/674563845781283224909500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/674563845781283224909500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/151134588018743970526002_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/151134588018743970526002_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/831318046793946113206000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/831318046793946113206000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/916281915185884963655750_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/916281915185884963655750_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/472343017167947876723490_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/472343017167947876723490_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/942767809372154340834000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/942767809372154340834000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/163812559664514099011170_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/163812559664514099011170_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/697203950107440612220250_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/697203950107440612220250_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/697247714477543390785500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/697247714477543390785500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/161411030914914658667827_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/161411030914914658667827_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/669094843119273038295020_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/669094843119273038295020_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/362990339109906307146490_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/362990339109906307146490_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/200766730097564804937320_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/200766730097564804937320_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/357686216186091569615500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/357686216186091569615500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/206539641915557176577986_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/206539641915557176577986_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/106568805613403252031066_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/106568805613403252031066_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/562575204157804367889930_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/562575204157804367889930_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/201136725963941859463860_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/201136725963941859463860_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/174343734111585091167516_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/174343734111585091167516_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/174437664961525990196410_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/174437664961525990196410_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/852602712102381755560600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/852602712102381755560600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000475_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/191351338116998619431514_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/191351338116998619431514_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000475_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/378452992490143925172200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/378452992490143925172200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255862', '1514255862', null, '1157', '1174', '1191', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('2', '邦诺姿 情趣内衣无痕蕾丝提臀诱惑丁字裤中腰档纯棉女士内裤低腰三角裤', '11.00', '100', '100', '1193', '<div class=\"lazyimg\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/689982530173400477121750_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/689982530173400477121750_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p>邦诺姿 情趣内衣无痕蕾丝提臀诱惑丁字裤中腰档纯棉内裤女低腰三角裤</p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/549576726132196462330130_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"25kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/549576726132196462330130_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/104343487925972960976710_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"15kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/104343487925972960976710_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/677188189104696859564200_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"25kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/677188189104696859564200_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/165268111319512662259174_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"19kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/165268111319512662259174_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/183861682115321737636075_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"16kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/183861682115321737636075_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/209636224883257434873210_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"22kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/209636224883257434873210_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/613490401485519279904600_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"21kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/613490401485519279904600_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/973421549384124627194600_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"20kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/973421549384124627194600_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/103415878141517397689040_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"18kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/103415878141517397689040_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/874812982127994638116750_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"23kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/874812982127994638116750_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/299521442384832985226700_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"31kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/299521442384832985226700_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/970478405999096697242500_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"20kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/970478405999096697242500_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/381378146241206027873200_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"33kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/381378146241206027873200_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/815691648173584685513900_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"15kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/815691648173584685513900_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/715947388156906411646530_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"28kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/715947388156906411646530_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514255865', '1514255865', null, '1157', '1174', '1193', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('3', '【4条装】无痕女士内裤 秋冰丝面料中腰性感纯棉档大码收腹三角裤', '39.00', '100', '100', '1195', '<div></div>', '', '', '0', '1514255872', '1514255872', null, '1157', '1174', '1195', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('4', '南极人【10双装】夏季男士丝袜超薄中筒袜男袜子薄款透气纯色商务袜P3038', '25.00', '100', '100', '1196', '<div class=\"lazyimg\"><div moduleid=\"R9001233_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/220554883151527898467690_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/220554883151527898467690_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/703454375142635257474010_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/703454375142635257474010_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/741179270136092137066940_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/741179270136092137066940_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/471302339104851119143100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/471302339104851119143100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/405007880245674608657000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/405007880245674608657000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/197249537833172444439330_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/197249537833172444439330_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/210539634615075087689478_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/210539634615075087689478_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001233_4\" modulename=\"商品尺码表\"><p>1</p></div><div moduleid=\"R9001233_5\" modulename=\"模特效果\"><p>1</p></div></div>', '', '', '0', '1514255876', '1514255876', null, '1480', '1482', '1196', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('5', '南极人 袜子男士 男女士船袜 精梳棉竹纤维棉袜 情侣袜 运动 休闲 商务男袜短袜吸湿排汗透气男袜女袜子P3015K31', '29.00', '100', '100', '1197', '<div class=\"lazyimg\"><div>\n<p><span><strong><span>  如需了解具体成分请联系客服咨询，商品以实物为准</span></strong></span></p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/144391318112221528421732_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144391318112221528421732_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/926379906193716650075230_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/926379906193716650075230_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/609920095927142381856000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/609920095927142381856000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/138970591410051613249858_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/138970591410051613249858_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/173997991716994227556748_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/173997991716994227556748_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/194506346246409106964940_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/194506346246409106964940_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/835801205190047935027900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/835801205190047935027900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/156976381316304347065690_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/156976381316304347065690_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/119973052319108199011705_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/119973052319108199011705_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/309092698178635031275570_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/309092698178635031275570_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/830767103995768205383700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/830767103995768205383700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/627842013350642281102100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/627842013350642281102100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/313610607133945989126580_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/313610607133945989126580_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/860111581648725031870800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/860111581648725031870800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/102257310525611615473360_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/102257310525611615473360_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/329813238197061593430300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/329813238197061593430300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/730820219139747538140180_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/730820219139747538140180_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/182827904012246926564991_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/182827904012246926564991_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/711880362551568465306000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/711880362551568465306000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/130229933959676785594770_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/130229933959676785594770_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/329740607175115333478420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/329740607175115333478420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/607609702128202942449380_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/607609702128202942449380_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n</div>\n<div>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/326997009152860027325930_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/326997009152860027325930_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n</div>\n<div>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/258716766148558069888800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/258716766148558069888800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n</div></div>', '', '', '0', '1514255879', '1514255879', null, '1157', '1187', '1197', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('6', '南极人 【5双礼盒装】男士袜子中筒棉袜四季商务袜透气袜子男P3014', '29.00', '100', '100', '1199', '<div class=\"lazyimg\"><div>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/953335138165082375991300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/953335138165082375991300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/227961096344975456541100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/227961096344975456541100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/677483126173629949329350_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/677483126173629949329350_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/148109580217533865507757_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/148109580217533865507757_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/174857875638598458068220_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/174857875638598458068220_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/461764481026973372136000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/461764481026973372136000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/335066572109061974774880_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/335066572109061974774880_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/201552654918331528602059_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/201552654918331528602059_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/179148531123750933149000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/179148531123750933149000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/100008941916663347388166_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/100008941916663347388166_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/162620507532584708489980_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/162620507532584708489980_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/427453920201633859942470_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/427453920201633859942470_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n</div>\n<div>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/179148531123750933149000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/179148531123750933149000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n</div>\n<div>\n<p><img data-src=\"//image.suning.cn/uimg/sop/richtext/125897017369821946972110.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/125897017369821946972110.gif?from=mobile\" width=\"100%\" height=\"auto\"></p>\n</div></div>', '', '', '0', '1514255885', '1514255885', null, '1157', '1187', '1199', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('7', 'Palmer’s 帕玛氏 孕妇 4359-6 产前产后妊娠纹多效玫瑰精华油 150ml 美国直采', '74.00', '100', '100', '119', '<div class=\"lazyimg\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/166276561634402126651000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/166276561634402126651000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"https://image.suning.cn/uimg/sop/commodity/625570756624615899324800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" usemap=\"#Map\" border=\"0\" src=\"https://image.suning.cn/uimg/sop/commodity/625570756624615899324800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p><div moduleid=\"R9003591_2\" modulename=\"商品信息\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/945462430196776307317450_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/945462430196776307317450_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/113715634612151110473760_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/113715634612151110473760_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/376187022608233105759100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/376187022608233105759100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003591_3\" modulename=\"商品特色\"><p><span>.</span></p></div><div moduleid=\"R9003591_4\" modulename=\"商品实拍\"><p><span>.</span></p></div><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/755363586928456648381100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" usemap=\"#Map\" border=\"0\" src=\"https://image.suning.cn/uimg/sop/commodity/755363586928456648381100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p></div>', '', '', '0', '1514255889', '1514255889', null, '1480', '1482', '119', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('8', 'PPTV-32C3 32英寸 1GB+8GB 4核 64位处理器 高清智能网络WIFI平板电视机', '0.00', '100', '100', '11', '<div class=\"lazyimg\"><p><a href=\"https://cuxiao.suning.com/hd20161212.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/132054885810478629024824_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/132054885810478629024824_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></p><div moduleid=\"R0503002_2\" modulename=\"关联推荐\"><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\">\n<tbody>\n<tr>\n<td colspan=\"2\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/991262126612863980128600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/991262126612863980128600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></td>\n</tr>\n<tr>\n<td><a href=\"https://product.suning.com/0000000000/165098507.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/214438867817603625057333_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/214438867817603625057333_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"https://product.suning.com/0000000000/623609906.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/109621120150932275484100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/109621120150932275484100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td><a href=\"https://product.suning.com/0000000000/657032630.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/208542801415375051738555_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/208542801415375051738555_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"https://product.suning.com/0000000000/721224512.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/136425987319765045349650_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/136425987319765045349650_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n</tbody>\n</table></div><div moduleid=\"customize_R0503002_3\" modulename=\"温馨提示\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/172423167210152060317847_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/172423167210152060317847_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R0503002_3\" modulename=\"商品详情\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/174905730410228950738155_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/174905730410228950738155_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/327635121199044123791600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/327635121199044123791600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/168119302943707504972600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/168119302943707504972600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/182405283628644008772000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/182405283628644008772000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/113863418972487033715300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/113863418972487033715300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/136177583518135210650900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/136177583518135210650900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/152064617016939385729226_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/152064617016939385729226_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/146376442711760825717550_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/146376442711760825717550_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/107047273820419814851380_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/107047273820419814851380_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/200261599911214285936452_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/200261599911214285936452_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/855847008204346095545310_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/855847008204346095545310_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/730996801621991773429500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/730996801621991773429500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/460427048259449913992500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/460427048259449913992500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/668191783147455659071930_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/668191783147455659071930_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/728060037145307562364800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/728060037145307562364800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">       </p></div><div moduleid=\"R0503002_6\" modulename=\"安装说明\"><p><a href=\"https://sale.suning.com/shfw/cdaz/index.html#suning\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/167782249410038252943695_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/167782249410038252943695_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></p></div></div>', '', '', '0', '1514255892', '1514255892', null, '1', '3', '11', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('9', '浪莎保暖裤 加绒加厚 外穿打底裤高腰踩脚裤 女秋冬大码中厚连裤袜', '19.00', '100', '100', '1200', '<div class=\"lazyimg\"><p> </p>\n<table id=\"__01\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\">\n<tbody>\n<tr>\n<td><br><img data-src=\"//image.suning.cn/uimg/sop/commodity/154882626910739506228433_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/154882626910739506228433_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></td>\n<td colspan=\"2\"><a href=\"http://quan.suning.com/lqzx_recommend.do?activityId=201703020001208792&amp;activitySecretKey=VGHtWp2zWdPwbQzWhIklpIDv\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/187578694613397619971860_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/187578694613397619971860_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"><a href=\"http://quan.suning.com/lqzx_recommend.do?activityId=201703020001208793&amp;activitySecretKey=i5JxhiKT2XQC0nhXCpvbr97b\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/781345889139100171635250_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/781345889139100171635250_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"><a href=\"http://quan.suning.com/lqzx_recommend.do?activityId=201703020001208794&amp;activitySecretKey=695xTLRFrRiA7BcbJTg6cRG3\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/141641843410271180304315_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/141641843410271180304315_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td colspan=\"7\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/489528312388248015591000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/489528312388248015591000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></td>\n</tr>\n<tr>\n<td colspan=\"2\"><a href=\"http://product.suning.com/0070129883/629964271.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/131111056612016773996253_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/131111056612016773996253_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"><a href=\"https://product.suning.com/0070129883/606673945.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/104800345320310594187041_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/104800345320310594187041_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"><a href=\"http://product.suning.com/0070129883/648506992.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/812931140132367847973250_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/812931140132367847973250_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"https://product.suning.com/0070129883/160116107.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/823622745221666007504000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/823622745221666007504000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td colspan=\"2\"><a href=\"http://product.suning.com/0070129883/159639322.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/153379123320707134502167_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/153379123320707134502167_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"> <a href=\"http://product.suning.com/0070129883/159876584.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/182562591010389658188725_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/182562591010389658188725_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"> <a href=\"http://product.suning.com/0070129883/149267566.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/213969885312155002374545_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/213969885312155002374545_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070129883/623354247.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/151632096310454017967223_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/151632096310454017967223_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td colspan=\"2\"><a href=\"http://product.suning.com/0070129883/647228722.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/350985277634200952238900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/350985277634200952238900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"><a href=\"http://product.suning.com/0070129883/160128696.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/121513526790129296393200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/121513526790129296393200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"><a href=\"http://product.suning.com/0070129883/159632830.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/106714016856350618506800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/106714016856350618506800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"https://product.suning.com/0070129883/623813237.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/189260085181169366592660_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/189260085181169366592660_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td colspan=\"2\"><a href=\"https://product.suning.com/0070129883/141816619.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/131061407640736466275740_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/131061407640736466275740_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"><a href=\"https://product.suning.com/0070129883/151250266.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/142770834981321268254920_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/142770834981321268254920_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td colspan=\"2\"><a href=\"https://product.suning.com/0070129883/604083282.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/179309088549551762475560_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/179309088549551762475560_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"https://product.suning.com/0070129883/604298623.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/699016911128281603955110_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/699016911128281603955110_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td><img data-src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" width=\"100%\" height=\"auto\"></td>\n<td><img data-src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" width=\"100%\" height=\"auto\"></td>\n<td><img data-src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" width=\"100%\" height=\"auto\"></td>\n<td><img data-src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" width=\"100%\" height=\"auto\"></td>\n<td><img data-src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" width=\"100%\" height=\"auto\"></td>\n<td><img data-src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" width=\"100%\" height=\"auto\"></td>\n<td><img data-src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/322938689132062992336310.gif?from=mobile\" width=\"100%\" height=\"auto\"></td>\n</tr>\n</tbody>\n</table>\n<!-- End Save for Web Slices -->\n<p> </p><div moduleid=\"R9001233_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/909937028119874689755610_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/909937028119874689755610_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/462552309452390218427100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/462552309452390218427100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/158253664657372978325550_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/158253664657372978325550_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/680280665178358333367640_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/680280665178358333367640_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/130964553617578707142404_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/130964553617578707142404_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/199493631889909315086550_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/199493631889909315086550_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/587448320123337588234600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/587448320123337588234600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/606616103151531094582940_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/606616103151531094582940_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/242553498251563991583000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/242553498251563991583000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/577164995123892665014260_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/577164995123892665014260_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/167740197383867160994610_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/167740197383867160994610_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/922500821756511951999100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/922500821756511951999100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/914586979819518659359200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/914586979819518659359200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/141578898312991847858241_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/141578898312991847858241_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001233_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/107817894117108419288338_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/107817894117108419288338_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001233_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/541598676749198016331300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/541598676749198016331300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><p> </p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/130425980914793741401748_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/130425980914793741401748_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/766487254604449538218700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/766487254604449538218700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514255895', '1514255895', null, '1157', '1187', '1200', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('10', '南极人黄金甲保暖内衣男士女士加绒加厚秋衣秋裤套装P6021', '69.00', '100', '100', '1203', '<div class=\"lazyimg\"><div moduleid=\"R9001237_3\" modulename=\"商品详情\"><p><span><strong>注意！！！由于生产批次不同，此款保暖内衣里层的绒颜色也会有所差异，介意者勿拍，此问题不作为日后退款原因！！！另大红已停产，大红发完将改成绛红色发货，介意者勿拍!!!</strong></span></p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/177728073126769677248820_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/177728073126769677248820_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/205140188153039368835310_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/205140188153039368835310_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/419236131101632119047950_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/419236131101632119047950_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/114700074172090210877950_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/114700074172090210877950_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/132694662128968538018270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/132694662128968538018270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/202996844619615574775720_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/202996844619615574775720_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/211766860713828489975213_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/211766860713828489975213_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/153061215325147670091460_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/153061215325147670091460_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/744926105165229554426740_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/744926105165229554426740_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/785478080200801410323470_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/785478080200801410323470_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/172179180215954398715210_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/172179180215954398715210_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/130931486931211335451480_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/130931486931211335451480_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/163651405373900172782910_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/163651405373900172782910_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/502844796668470702998200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/502844796668470702998200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/632506855120830616546310_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/632506855120830616546310_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/666992215198271981314120_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/666992215198271981314120_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/811821672203801058953850_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/811821672203801058953850_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/108454504714091899732984_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/108454504714091899732984_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001237_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/132694662128968538018270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/132694662128968538018270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001237_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/211766860713828489975213_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/211766860713828489975213_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255902', '1514255902', null, '1480', '1482', '1203', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('11', '【买2付1】南极人男士女士保暖内衣情侣薄款棉质基础棉毛衫秋衣秋裤套装P6007', '0.00', '100', '100', '1204', '<div class=\"lazyimg\"><div moduleid=\"R9001237_3\" modulename=\"商品详情\"><p><span>    把您喜欢的两件颜色和尺码同时加入</span></p>\n<p><span>    购物车结算，系统自动改价</span></p>\n<p><span>    不拍2件仓库只默认发一件！</span></p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/205859709224392816223670_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/205859709224392816223670_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/240339771182411428945010_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/240339771182411428945010_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/345864071849252183416900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/345864071849252183416900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/208196022647086495390010_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/208196022647086495390010_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/690523768197837709839600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/690523768197837709839600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/575886016125513573443500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/575886016125513573443500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/185884003820086852612420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/185884003820086852612420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/693054828653184845757000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/693054828653184845757000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/197242591393155244425370_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/197242591393155244425370_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/131155598178956218982610_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/131155598178956218982610_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/964306307138187664910910_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/964306307138187664910910_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/139470314718737671339975_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/139470314718737671339975_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/211385832936199568026060_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/211385832936199568026060_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/210034450216472888703609_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/210034450216472888703609_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/813291561841450628341100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/813291561841450628341100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/507705193196873574532940_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/507705193196873574532940_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/125672677420458614076017_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/125672677420458614076017_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/166568409392898570162110_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/166568409392898570162110_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/133390076870192949898000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/133390076870192949898000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/220312582272109063351400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/220312582272109063351400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/120404808176538182729840_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/120404808176538182729840_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/213968934511486060985769_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/213968934511486060985769_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/252653596100326193397590_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/252653596100326193397590_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/150328134195029000159900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/150328134195029000159900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/135852163051139480280400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/135852163051139480280400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/191775747027650264026140_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/191775747027650264026140_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/116739065611235109529700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/116739065611235109529700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/168848549412520062819640_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/168848549412520062819640_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/214090818372197203982100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/214090818372197203982100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/108775268458962779349080_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/108775268458962779349080_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/199260505910732681013750_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/199260505910732681013750_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/132243810272506765260810_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/132243810272506765260810_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/952517058681951624290000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/952517058681951624290000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/185265798510344197449104_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/185265798510344197449104_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/170503407012404610707203_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/170503407012404610707203_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/495519465153548443484800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/495519465153548443484800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/381304675711685143990000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/381304675711685143990000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/166611147618192066827192_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/166611147618192066827192_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/143906031819088697795161_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/143906031819088697795161_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/110217860216330033917583_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/110217860216330033917583_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/895727570277931977254100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/895727570277931977254100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/499650922756268186492700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/499650922756268186492700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/153648736320344482701462_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/153648736320344482701462_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/952321218186592386656770_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/952321218186592386656770_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/463662104429779319983000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/463662104429779319983000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/312820127433794109047000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/312820127433794109047000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/175379843320613719257701_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/175379843320613719257701_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001237_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/133390076870192949898000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/133390076870192949898000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001237_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/120404808176538182729840_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/120404808176538182729840_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255906', '1514255906', null, '1157', '1192', '1204', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('12', '南极人薄款保暖内衣【秋衣+秋裤】套装棉质内衣圆领打底基础棉毛套P6001', '49.00', '100', '100', '1207', '<div class=\"lazyimg\"><div moduleid=\"R9001235_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/802741114188663398954740_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/802741114188663398954740_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/174906704239419715055550_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/174906704239419715055550_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/115555712428993709564140_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/115555712428993709564140_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/633477660123911391951550_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/633477660123911391951550_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/905726045788783555982000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/905726045788783555982000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/155568900020821157885500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/155568900020821157885500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/114170254289035782036760_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/114170254289035782036760_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/117634333216162256291022_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/117634333216162256291022_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/808031738360249402766800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/808031738360249402766800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/629274141379545095402700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/629274141379545095402700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/937080678493363894526000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/937080678493363894526000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/167029522710938771575674_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/167029522710938771575674_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/180735519220664794296249_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/180735519220664794296249_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/115159272185071719411130_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/115159272185071719411130_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/156939452517579766922907_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/156939452517579766922907_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/144897295720882829767524_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144897295720882829767524_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/870014381251160732384700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/870014381251160732384700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/120595913911348288198720_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/120595913911348288198720_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/192481212818113897921309_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/192481212818113897921309_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/110604639712381890913157_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/110604639712381890913157_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/106492047720413294763779_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/106492047720413294763779_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/113868237336633045942090_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/113868237336633045942090_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/639258751154770616879170_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/639258751154770616879170_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/186049775612455382867418_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/186049775612455382867418_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/132748396119460644818164_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/132748396119460644818164_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/165300588595817411784600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/165300588595817411784600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/160158774218228409980930_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/160158774218228409980930_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/625581458521259287831500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/625581458521259287831500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/520575690166557944518410_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/520575690166557944518410_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/167840744414212190111760_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/167840744414212190111760_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/201146514511733595528545_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/201146514511733595528545_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/338053378100584105978100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/338053378100584105978100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/207151057512802178368000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/207151057512802178368000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/144090460018667640332000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144090460018667640332000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/168223708416711378231087_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/168223708416711378231087_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/111226402411686452464312_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/111226402411686452464312_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/183302896520589849941930_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/183302896520589849941930_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/richtext/385468987540707384892500.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/385468987540707384892500.gif?from=mobile\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/103890435015392393499517_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/103890435015392393499517_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001235_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/108357171813227960604242_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/108357171813227960604242_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001235_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/140502239923147994327250_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/140502239923147994327250_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255915', '1514255915', null, '1157', '1192', '1207', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('13', 'YANAGIYA 柳屋滋养发根精华液240ml 护发养发精预防掉发柳屋增发液 日本进口', '79.00', '100', '100', '120', '<div class=\"lazyimg\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/686390480144016572042540_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/686390480144016572042540_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><div moduleid=\"R9003260_2\" modulename=\"商品信息\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/852911084518219570797800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/852911084518219570797800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003260_3\" modulename=\"商品特色\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/160451085116417728847436_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/160451085116417728847436_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/142114656524900732035060_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/142114656524900732035060_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/826637948123189740221970_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/826637948123189740221970_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/149855843337463837070430_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/149855843337463837070430_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/861364520638656827459300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/861364520638656827459300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003260_4\" modulename=\"商品实拍\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/274889661381352078828500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/274889661381352078828500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><p> </p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/211843801017286496044110_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/211843801017286496044110_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p></div>', '', '', '0', '1514255922', '1514255922', null, '70', '113', '120', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('14', '依岚傲雪帽子男冬天加绒毛线帽加厚针织帽秋冬套头帽男包头帽棉帽冬季帽男4931', '19.00', '100', '100', '1210', '<div class=\"lazyimg\"><p></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/405100349207857572359650_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"103kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/405100349207857572359650_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/822202690280457494619800_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"92kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/822202690280457494619800_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/161256014719116061224311_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"99kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/161256014719116061224311_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/166598855410012410646300_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"114kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/166598855410012410646300_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/203932069515355272250650_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"99kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/203932069515355272250650_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/271180810311705542396500_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"81kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/271180810311705542396500_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/144385080546072191412300_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"89kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/144385080546072191412300_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/847527711757584052365000_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"96kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/847527711757584052365000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/209456298419113360465026_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"108kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/209456298419113360465026_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/722859392859981257746500_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"100kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/722859392859981257746500_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/122058773959623479976910_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"105kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/122058773959623479976910_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/572513943142365696719320_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"123kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/572513943142365696719320_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/635623678277896466896000_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"30kb\" src=\"https://image.suning.cn/uimg/sop/phonecomm/635623678277896466896000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514255925', '1514255925', null, '1480', '1482', '1210', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('15', '专柜同款 恒源祥100%纯羊毛围巾男女通用围脖 5503驼色', '129.00', '100', '100', '1211', '<div class=\"lazyimg\"><div moduleid=\"R6156001_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/596074641225036919297600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/596074641225036919297600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R6156001_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/183274605210183838196117_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/183274605210183838196117_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R6156001_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/146921146115320237999477_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/146921146115320237999477_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/101081235515130097747233_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/101081235515130097747233_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/817362648845439348884000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/817362648845439348884000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/496936394142283199838270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/496936394142283199838270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/191519555082153410925400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/191519555082153410925400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/180972295129245542393110_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/180972295129245542393110_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/208042447518842003239029_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/208042447518842003239029_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/134051289321053384646997_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/134051289321053384646997_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/169327095717809900267930_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/169327095717809900267930_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/910760969199722851384980_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/910760969199722851384980_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/566197989853207623730000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/566197989853207623730000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/328989057521481506251500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/328989057521481506251500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/190421718410673972655869_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/190421718410673972655869_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/159794766668292157753910_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/159794766668292157753910_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/546926056128815055183230_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/546926056128815055183230_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/182684694274575657054270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/182684694274575657054270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/161554571016543265319544_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/161554571016543265319544_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/118954550414620161469830_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/118954550414620161469830_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/588790379321568283335000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/588790379321568283335000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/989721118418288547063000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/989721118418288547063000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/787102495179083911946500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/787102495179083911946500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/192479304999540735798820_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/192479304999540735798820_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/742987111121544244737600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/742987111121544244737600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/200475111430247500671610_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/200475111430247500671610_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/117084185797154004543040_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/117084185797154004543040_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/188200361417764094085950_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/188200361417764094085950_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/281406431637563398686400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/281406431637563398686400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/653379354178127445367080_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/653379354178127445367080_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/531938177162461402819460_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/531938177162461402819460_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/125418117848548989654280_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/125418117848548989654280_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/419254947168796259312670_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/419254947168796259312670_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/186616128511350154637993_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/186616128511350154637993_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/260497941771479962229900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/260497941771479962229900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/589122697207558071059380_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/589122697207558071059380_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/174735068518831656986632_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/174735068518831656986632_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/202177366215976528541084_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/202177366215976528541084_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/183546150419172273377136_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/183546150419172273377136_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/139531104691344611389000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/139531104691344611389000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/106338568020992773205346_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/106338568020992773205346_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/487817513361340773704000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/487817513361340773704000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/131120493459399853760780_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/131120493459399853760780_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/163658755216138913723877_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/163658755216138913723877_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/335717144173525533217170_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/335717144173525533217170_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/741024431164442663643660_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/741024431164442663643660_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/170170312613090657138539_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/170170312613090657138539_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/156753971620658156999395_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/156753971620658156999395_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/109418466668839520938270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/109418466668839520938270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/627199332171600704750770_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/627199332171600704750770_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/829993373133014384877480_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/829993373133014384877480_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/186583614616392299225900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/186583614616392299225900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/137442149656412531655700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/137442149656412531655700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/207093274112386532883210_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/207093274112386532883210_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/192081234919898672898909_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/192081234919898672898909_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/198622624234948824184280_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/198622624234948824184280_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/616821854186482823573350_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/616821854186482823573350_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/903419749136984696056700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/903419749136984696056700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/177829349707733354320900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/177829349707733354320900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/175496612220340247507791_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/175496612220340247507791_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/157024051482310907013850_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/157024051482310907013850_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/196071452347764980771220_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/196071452347764980771220_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/240950300469798961970000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/240950300469798961970000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/780878141928682998484500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/780878141928682998484500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/122431389315363380719528_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/122431389315363380719528_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/197712009495282715613630_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/197712009495282715613630_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/117900060395199886489390_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/117900060395199886489390_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/571040584647478765122200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/571040584647478765122200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/432004323145542491521900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/432004323145542491521900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/323853512872431097893000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/323853512872431097893000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/132061533133079790042890_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/132061533133079790042890_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/149409372393371731963580_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/149409372393371731963580_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/773373539185675166084020_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/773373539185675166084020_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/186422822135103540170750_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/186422822135103540170750_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R6156001_6\" modulename=\"包装图示\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/160311763670390268786560_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/160311763670390268786560_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255929', '1514255929', null, '1157', '1202', '1211', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('16', '七匹狼男士自动扣皮带WA20173j（黑色）', '59.00', '100', '100', '1212', '<div class=\"lazyimg\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/108075279714597480358536_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" usemap=\"#Map\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/108075279714597480358536_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p><div moduleid=\"R4402001_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/162152439730657546991630_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/162152439730657546991630_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/254098321354226666654900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/254098321354226666654900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/602396647463520006514500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/602396647463520006514500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/743486007340594760529900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/743486007340594760529900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/627149307177830880632950_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/627149307177830880632950_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/159355513216910544774586_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/159355513216910544774586_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/137029921781382966090780_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/137029921781382966090780_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/304103978103057893484730_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/304103978103057893484730_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/168504582310359633936420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/168504582310359633936420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/224028381989917266931900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/224028381989917266931900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/165393372320272467437350_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/165393372320272467437350_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/198374643361832360356400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/198374643361832360356400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/850878613124108072089250_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/850878613124108072089250_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/115380628118881535167910_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/115380628118881535167910_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/190258373113335016905405_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/190258373113335016905405_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/929806259367993455502500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/929806259367993455502500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/143737750152357768893530_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/143737750152357768893530_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/157189255971417107179730_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/157189255971417107179730_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/180569422970306991128790_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/180569422970306991128790_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/579520946608206475461100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/579520946608206475461100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/220916967444877553950000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/220916967444877553950000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/123813029819399400125418_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/123813029819399400125418_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/420303294173163950639420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/420303294173163950639420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514255940', '1514255940', null, '1157', '1202', '1212', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('17', 'MNYDS/袋鼠 箭头型领带 男士商务正装 结婚新郎晚宴商务必备 韩版商务休闲', '39.00', '100', '100', '1213', '<div class=\"lazyimg\"><div moduleid=\"R6156002_2\" modulename=\"关联推荐\"><!-- tjb_top_mark_start --><div style=\"overflow:hidden;clear:both\"><!-- tjb_top_6140_mark_start --><div style=\"overflow:hidden\"><!-- tjb_mod_7193_mark_start --><table cellpadding=\"0\" cellspacing=\"0\" align=\"left\" style=\"width: 100%; height: auto;\">\n	<tbody>\n		<tr>\n			<td colspan=\"4\">\n				<a target=\"_blank\" href=\"http://shop.suning.com/70090130/index.html\"><img border=\"0\" data-src=\"https://image.suning.cn/uimg/sop/commodity/109849941913886482271021_x.jpg?from=mobile&amp;format=80q.webp\" src=\"https://image.suning.cn/uimg/sop/commodity/109849941913886482271021_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n		</tr>\n		<tr>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/10015773674.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/211795942620897707699083_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/211795942620897707699083_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/10015810947.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/980459295532688593982700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/980459295532688593982700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/10014461871.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/340219082114567680872300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/340219082114567680872300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/10014415735.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/201086740312229207405136_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/201086740312229207405136_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n		</tr>\n		<tr>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/621454892.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/220265917618813389481800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/220265917618813389481800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/624670967.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/545259395929819990839300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/545259395929819990839300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/621455741.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/408002174181964103884280_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/408002174181964103884280_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/621436027.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/315780237210433163729260_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/315780237210433163729260_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n		</tr>\n		<tr>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/654393114.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/122251891611236844049552_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/122251891611236844049552_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/601633507.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/144418159217778690084544_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/144418159217778690084544_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/127697435.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/214686938319072036430890_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/214686938319072036430890_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n			<td>\n				<a href=\"http://product.suning.com/0070090130/856538918.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/180118563062512430181990_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/180118563062512430181990_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a>\n			</td>\n		</tr>\n	</tbody>\n</table><!-- tjb_mod_7193_mark_end --></div><!-- tjb_top_6140_mark_end --></div><!-- tjb_top_mark_end --></div><div moduleid=\"R6156002_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/richtext/740495941200887400445780.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/740495941200887400445780.gif?from=mobile\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/173758734672031574590410_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/173758734672031574590410_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/110765367373152035347600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/110765367373152035347600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/146379007113935289507562_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/146379007113935289507562_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/121914790611549455462968_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/121914790611549455462968_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/184870818321020293504893_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/184870818321020293504893_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/109738604222503543277660_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/109738604222503543277660_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/156299293691842687829080_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/156299293691842687829080_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/599745449498464363750900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/599745449498464363750900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/157108416819701233591860_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/157108416819701233591860_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/153077938049008031029690_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/153077938049008031029690_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/162720768817909873924302_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/162720768817909873924302_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/197186427810549817947500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/197186427810549817947500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/144220547183918048642530_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144220547183918048642530_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/126865062162946720046570_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/126865062162946720046570_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/133258597665258532314510_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/133258597665258532314510_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/810684899124289728068760_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/810684899124289728068760_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/153336931186096714345300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/153336931186096714345300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/115318965874512132423760_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/115318965874512132423760_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/204589085718126753321452_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/204589085718126753321452_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/641906970173817274924000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/641906970173817274924000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255943', '1514255943', null, '1157', '1202', '1213', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('18', '触屏手套男女手套秋冬款韩版针织时尚外出开车加厚分指保暖手套 女款玫红', '29.00', '100', '100', '1214', '<div class=\"lazyimg\"><p></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/154560332784971866371000_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"80.20KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/154560332784971866371000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/138252867013681355707019_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"63.96KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/138252867013681355707019_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/234409312101400339112070_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"83.90KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/234409312101400339112070_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/121082393041828847524180_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"81.29KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/121082393041828847524180_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/341922175107070027675210_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"77.98KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/341922175107070027675210_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/138461843167839865058660_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"74.52KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/138461843167839865058660_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/707185023301385541536800_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"84.75KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/707185023301385541536800_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/980678455565961165321000_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"84.08KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/980678455565961165321000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/736511552202364313364430_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"87.16KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/736511552202364313364430_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/302459800218904933822100_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"81.62KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/302459800218904933822100_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/110250153735240071053290_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"70.95KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/110250153735240071053290_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/106768991611331928946131_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"184.07KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/106768991611331928946131_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/107220768090701171582410_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"48.21KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/107220768090701171582410_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/441970801992171111560600_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"166.63KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/441970801992171111560600_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/394347703102816637024400_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"79.49KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/394347703102816637024400_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/phonecomm/395455514941123842965000_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"53.12KB\" src=\"https://image.suning.cn/uimg/sop/phonecomm/395455514941123842965000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514255946', '1514255946', null, '1157', '1202', '1214', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('19', '【亏本清仓】龙眼 T5男女蛤蟆款防紫外线偏光太阳镜司机开车钓鱼墨镜百搭太阳眼镜', '0.00', '100', '100', '1215', '<div class=\"lazyimg\"><p><span><strong>本品有枪灰,黑灰,枪绿,如有颜色要求,请亲们下单时留言或联系客服备注,正常发枪灰或黑灰.谢谢</strong></span></p>\n<p><span> </span></p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/486690978271904689651600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/486690978271904689651600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/richtext/597178053110485359911560.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/597178053110485359911560.gif?from=mobile\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/496747650897637521370900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/496747650897637521370900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/177170464158481344977570_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/177170464158481344977570_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/richtext/109828157481067511354890.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/109828157481067511354890.gif?from=mobile\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/579079051415184983442900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/579079051415184983442900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/199474388092906590424220_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/199474388092906590424220_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/756120450124968690184890_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/756120450124968690184890_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/139900818719520059046784_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/139900818719520059046784_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/richtext/188700972368228061966160.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/188700972368228061966160.gif?from=mobile\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/906982142101314721097470_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/906982142101314721097470_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/451381505107820217527650_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/451381505107820217527650_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/205786706915016970361110_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/205786706915016970361110_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/120535984093826219043510_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/120535984093826219043510_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/327094941117044188821740_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/327094941117044188821740_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/207046466112255018031000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/207046466112255018031000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/642310714157963337421300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/642310714157963337421300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514255950', '1514255950', null, '1157', '1202', '1215', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('20', '古今文胸专柜正品薄款聚拢小胸调整型蕾丝性感女性胸罩内衣0D202 肤色 80C', '64.00', '100', '100', '1216', '<div class=\"lazyimg\"><p> </p>\n<table id=\"__01\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\">\n<tbody>\n<tr>\n<td><a href=\"http://product.suning.com/0070121854/138878674.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/129727734542018825222500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/129727734542018825222500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070121854/152295814.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/876914277112775514810060_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/876914277112775514810060_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070121854/139021318.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/196937902810569614654658_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/196937902810569614654658_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070121854/155307606.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/176783504515099137820910_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/176783504515099137820910_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td><a href=\"http://product.suning.com/0070121854/151999586.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/146213374120779497531189_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/146213374120779497531189_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070121854/139582366.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/322213094704878527767600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/322213094704878527767600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070121854/139487004.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/157258974834412288938720_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/157258974834412288938720_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070121854/139917543.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/147355853943566945327870_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/147355853943566945327870_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td><a href=\"http://product.suning.com/0070121854/172542088.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/185370294933412928957880_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/185370294933412928957880_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070121854/185287283.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/308074354379310112224800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/308074354379310112224800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070121854/172547942.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/171225410658445722846620_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/171225410658445722846620_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070121854/172545192.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/686795703689143515418100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/686795703689143515418100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n</tbody>\n</table>\n<!-- End Save for Web Slices -->\n<p> </p><div moduleid=\"R9000474_3\" modulename=\"商品详情\"><p><span>1.为苛求圆润乳房的女子特别设计，圆润而舒适的文胸</span><br><span>2.为追求玲珑圆润乳房的你准备了这款特别的文胸，它经过千次真人试穿，百次修改后而发行销售。它的尺码设计从娇小的75A至丰满的80C。配插片的设计更为给您想要的圆润~</span><span>如没有合适的尺码，可以去店铺挑选适合自己喜欢的。</span></p>\n<p> <img data-src=\"//image.suning.cn/uimg/sop/commodity/146041528839589343566700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/146041528839589343566700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/157077713010016331433174_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/157077713010016331433174_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/198410307623875217151660_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/198410307623875217151660_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/671009790203182104170740_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/671009790203182104170740_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/121022982195890861267720_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/121022982195890861267720_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/117055094474994613328530_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/117055094474994613328530_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/388619245117119437974850_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/388619245117119437974850_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/140594491717787087626037_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/140594491717787087626037_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000474_4\" modulename=\"商品尺码表\"><p> </p>\n<p>..</p></div><div moduleid=\"R9000474_5\" modulename=\"模特效果\"><p>.</p></div></div>', '', '', '0', '1514255953', '1514255953', null, '1480', '1482', '1216', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('21', '送背心 花花公子男士内裤平角裤透气中腰男内裤四角裤头内裤男 5370-4 XXL180', '109.00', '100', '100', '1219', '<div class=\"lazyimg\"><p><a href=\"http://product.suning.com/0070062355/104672481.html\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/102398015215353708548560_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/102398015215353708548560_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></p><div moduleid=\"R9000475_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/201531381714794964872053_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/201531381714794964872053_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/185370611516328817231321_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/185370611516328817231321_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/145025876210826066924260_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/145025876210826066924260_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/297685475179488171236600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/297685475179488171236600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/153335036839338306567610_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/153335036839338306567610_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/167995924010359987694470_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/167995924010359987694470_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/778493114698414684094000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/778493114698414684094000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000475_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/171102355564556101846160_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/171102355564556101846160_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/388242859144126760985090_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/388242859144126760985090_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/372081159574167907115600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/372081159574167907115600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/132109328234075627883880_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/132109328234075627883880_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/184079468517126339012149_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/184079468517126339012149_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/643941393303816121181600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/643941393303816121181600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/746892691778464507518600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/746892691778464507518600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/211960538527490308282000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/211960538527490308282000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/195785418711616783987393_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/195785418711616783987393_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/361462304958827811395100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/361462304958827811395100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/183081007516627761363533_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/183081007516627761363533_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/296784024504672578583000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/296784024504672578583000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/149937831217445105001372_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/149937831217445105001372_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/121998121220676088953645_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/121998121220676088953645_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/192264415855053108658420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/192264415855053108658420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/963301573332950374792600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/963301573332950374792600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/188363174313827658491415_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/188363174313827658491415_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/296600608211882464842150_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/296600608211882464842150_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/828481798637078516262000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/828481798637078516262000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/278826078112670094112660_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/278826078112670094112660_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/620947673156435849408800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/620947673156435849408800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/197475647817193425353066_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/197475647817193425353066_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/195483964314977104143802_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/195483964314977104143802_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/143500533243993625105100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/143500533243993625105100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/862491525599035765218300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/862491525599035765218300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/199311929691288638545560_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/199311929691288638545560_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n<p> </p>\n<p> </p></div><div moduleid=\"R9000475_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/138745601276311936060780_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/138745601276311936060780_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/397421341729045684879500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/397421341729045684879500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><p><a href=\"http://playboy-js.suning.com/\" target=\"_blank\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/252399832945587584214800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/252399832945587584214800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></p></div>', '', '', '0', '1514255959', '1514255959', null, '1157', '1208', '1219', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('22', 'YSL伊夫·圣罗兰持久亮泽指甲油(6# 10ml)', '179.00', '100', '100', '121', '<div class=\"lazyimg\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/686390480144016572042540_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/686390480144016572042540_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/142957582013555126053686_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/142957582013555126053686_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p> </p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/211843801017286496044110_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/211843801017286496044110_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p></div>', '', '', '0', '1514255963', '1514255963', null, '70', '113', '121', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('23', '恒源祥全棉男女高领保暖内衣套装秋衣秋裤圆领基础内衣棉毛衫', '99.00', '100', '100', '1220', '<div class=\"lazyimg\"><div moduleid=\"R9001235_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/569891494119489940257720_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_01\" src=\"//image.suning.cn/uimg/sop/commodity/569891494119489940257720_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/352132873119085256743390_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_02\" src=\"//image.suning.cn/uimg/sop/commodity/352132873119085256743390_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/260063971887424978500000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_03\" src=\"//image.suning.cn/uimg/sop/commodity/260063971887424978500000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/887567158136763619720930_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_04\" src=\"//image.suning.cn/uimg/sop/commodity/887567158136763619720930_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/147904073715223799206156_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_05\" src=\"//image.suning.cn/uimg/sop/commodity/147904073715223799206156_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/962025956199842750685040_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_06\" src=\"//image.suning.cn/uimg/sop/commodity/962025956199842750685040_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/138187053070238723947510_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_07\" src=\"//image.suning.cn/uimg/sop/commodity/138187053070238723947510_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/881453504933658738680000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_08\" src=\"//image.suning.cn/uimg/sop/commodity/881453504933658738680000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/179580281543459124627350_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_09\" src=\"//image.suning.cn/uimg/sop/commodity/179580281543459124627350_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/142782012119418639316660_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_11\" src=\"//image.suning.cn/uimg/sop/commodity/142782012119418639316660_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/205148691717181583531815_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_12\" src=\"//image.suning.cn/uimg/sop/commodity/205148691717181583531815_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/162490223720024257346805_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_013\" src=\"//image.suning.cn/uimg/sop/commodity/162490223720024257346805_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/767771690701442183423200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_13\" src=\"//image.suning.cn/uimg/sop/commodity/767771690701442183423200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/187740411612535337464782_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_14\" src=\"//image.suning.cn/uimg/sop/commodity/187740411612535337464782_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/172774229714802777702725_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_15\" src=\"//image.suning.cn/uimg/sop/commodity/172774229714802777702725_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/878713963195659055146400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_16\" src=\"//image.suning.cn/uimg/sop/commodity/878713963195659055146400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/276188733188501725423120_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_17\" src=\"//image.suning.cn/uimg/sop/commodity/276188733188501725423120_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/406611722159912313988200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_18\" src=\"//image.suning.cn/uimg/sop/commodity/406611722159912313988200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/651181825113060297743810_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_19\" src=\"//image.suning.cn/uimg/sop/commodity/651181825113060297743810_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/101711419810173871598781_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_20\" src=\"//image.suning.cn/uimg/sop/commodity/101711419810173871598781_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/452752870208812433894820_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_21\" src=\"//image.suning.cn/uimg/sop/commodity/452752870208812433894820_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/196798767615456023484879_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_22\" src=\"//image.suning.cn/uimg/sop/commodity/196798767615456023484879_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/960057768673626013864500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_23\" src=\"//image.suning.cn/uimg/sop/commodity/960057768673626013864500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/171636066965218437878940_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/171636066965218437878940_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/899595308813420982875000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/899595308813420982875000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/206405149621418566417215_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/206405149621418566417215_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/329082341360042294734900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/329082341360042294734900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/916189375119499542239380_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/916189375119499542239380_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/252485024192063139346740_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/252485024192063139346740_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/907640793146603697470580_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/907640793146603697470580_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/134053206496760948226100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/134053206496760948226100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/162337019712620625749813_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/162337019712620625749813_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/146131644177894775662970_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/146131644177894775662970_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/698257023559340098971000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/698257023559340098971000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/429506809164849361331200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/429506809164849361331200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/766660402696394071114200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_24\" src=\"//image.suning.cn/uimg/sop/commodity/766660402696394071114200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/753250311922071173183200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_25\" src=\"//image.suning.cn/uimg/sop/commodity/753250311922071173183200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/765350397135322513695890_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_26\" src=\"//image.suning.cn/uimg/sop/commodity/765350397135322513695890_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/117251765775811060419610_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_27\" src=\"//image.suning.cn/uimg/sop/commodity/117251765775811060419610_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/393793916710065651353400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_28\" src=\"//image.suning.cn/uimg/sop/commodity/393793916710065651353400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/142654677970066604866160_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_29\" src=\"//image.suning.cn/uimg/sop/commodity/142654677970066604866160_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001235_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/767771690701442183423200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_13\" src=\"//image.suning.cn/uimg/sop/commodity/767771690701442183423200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9001235_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/406611722159912313988200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"详情-拷贝_18\" src=\"//image.suning.cn/uimg/sop/commodity/406611722159912313988200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255966', '1514255966', null, '1157', '1208', '1220', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('24', '北极绒秋衣秋裤 男女士情侣基础棉毛衫保暖内衣套装', '59.00', '100', '100', '1221', '<div class=\"lazyimg\"><div moduleid=\"R9001235_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/192323775598817798600500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_01\" src=\"//image.suning.cn/uimg/sop/commodity/192323775598817798600500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/136932193184196538085640_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_02\" src=\"//image.suning.cn/uimg/sop/commodity/136932193184196538085640_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/117753386662228342392700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_03\" src=\"//image.suning.cn/uimg/sop/commodity/117753386662228342392700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/119939693776135075289390_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_04\" src=\"//image.suning.cn/uimg/sop/commodity/119939693776135075289390_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/264030266687092962122800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_05\" src=\"//image.suning.cn/uimg/sop/commodity/264030266687092962122800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/109417756322382481179760_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_06\" src=\"//image.suning.cn/uimg/sop/commodity/109417756322382481179760_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/104253442317476219173705_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_07\" src=\"//image.suning.cn/uimg/sop/commodity/104253442317476219173705_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/209567316016196499406615_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_08\" src=\"//image.suning.cn/uimg/sop/commodity/209567316016196499406615_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/582192899883744614835100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_09\" src=\"//image.suning.cn/uimg/sop/commodity/582192899883744614835100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/536496261197598680620900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_10\" src=\"//image.suning.cn/uimg/sop/commodity/536496261197598680620900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/499726590544013274667700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_11\" src=\"//image.suning.cn/uimg/sop/commodity/499726590544013274667700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/173352425866289121976200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_12\" src=\"//image.suning.cn/uimg/sop/commodity/173352425866289121976200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/904318801202686093914000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_13\" src=\"//image.suning.cn/uimg/sop/commodity/904318801202686093914000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/213039705716807524912480_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_14\" src=\"//image.suning.cn/uimg/sop/commodity/213039705716807524912480_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/132051775619381717326989_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_15\" src=\"//image.suning.cn/uimg/sop/commodity/132051775619381717326989_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/859240452111047787288780_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_16\" src=\"//image.suning.cn/uimg/sop/commodity/859240452111047787288780_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/166448291015632746808323_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_17\" src=\"//image.suning.cn/uimg/sop/commodity/166448291015632746808323_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/673618819980103537303800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_18\" src=\"//image.suning.cn/uimg/sop/commodity/673618819980103537303800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/212398217814895810037219_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_19\" src=\"//image.suning.cn/uimg/sop/commodity/212398217814895810037219_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/126378337151234805762110_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_20\" src=\"//image.suning.cn/uimg/sop/commodity/126378337151234805762110_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/711064250179458605797210_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_21\" src=\"//image.suning.cn/uimg/sop/commodity/711064250179458605797210_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/568053909702115014497200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_22\" src=\"//image.suning.cn/uimg/sop/commodity/568053909702115014497200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/786894843213787203484370_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_23\" src=\"//image.suning.cn/uimg/sop/commodity/786894843213787203484370_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/186640953449981636419300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_24\" src=\"//image.suning.cn/uimg/sop/commodity/186640953449981636419300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/182713161969642332057820_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_25\" src=\"//image.suning.cn/uimg/sop/commodity/182713161969642332057820_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/213568768187197702818670_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_26\" src=\"//image.suning.cn/uimg/sop/commodity/213568768187197702818670_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/134820818745508279633380_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"棉毛详情_27\" src=\"//image.suning.cn/uimg/sop/commodity/134820818745508279633380_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255969', '1514255969', null, '1157', '1208', '1221', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('25', '俞兆林【4条装】男士内裤中腰印花英伦风u凸短裤头弹力舒适平角内裤', '49.00', '100', '100', '1222', '<div class=\"lazyimg\"><div moduleid=\"R9000475_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/326957451136701122816410_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/326957451136701122816410_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/878833022152044999372910_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/878833022152044999372910_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/845218666604746656462700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/845218666604746656462700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/850442201203345991775900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/850442201203345991775900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/123646445293314654833440_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/123646445293314654833440_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/130576250502427654798100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/130576250502427654798100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/101522669611281255961622_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/101522669611281255961622_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/490663171149485125317700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/490663171149485125317700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/134188076229619990350750_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/134188076229619990350750_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/128020128924330815540750_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/128020128924330815540750_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/207109081153001975171910_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/207109081153001975171910_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/179080787719077608269752_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/179080787719077608269752_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/994239420125304623676660_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/994239420125304623676660_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255972', '1514255972', null, '1157', '1208', '1222', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('26', '甜妹子秋冬季加厚夹棉卡通长袖珊瑚绒可爱家居服套装 8633款 女款L码', '168.00', '100', '100', '1224', '<div class=\"lazyimg\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/155210931317110755512118_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" usemap=\"#Map11\" border=\"0\" src=\"https://image.suning.cn/uimg/sop/commodity/155210931317110755512118_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p><div moduleid=\"R9001230_3\" modulename=\"商品详情\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/305733943159720155032920_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/305733943159720155032920_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/162075505813112700829759_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/162075505813112700829759_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/326883516195718164415620_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/326883516195718164415620_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/165470547120826880639242_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/165470547120826880639242_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/505795133106190615380300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/505795133106190615380300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/109303712218926157157201_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/109303712218926157157201_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/964559011340447745531700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/964559011340447745531700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/774792575202515779798960_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/774792575202515779798960_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/188290415685487778602400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/188290415685487778602400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/324259071442367656402400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/324259071442367656402400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/125765081015635648079420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/125765081015635648079420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/126236236613890098166224_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/126236236613890098166224_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/167186589024167548846540_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/167186589024167548846540_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/155505728520077184839724_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/155505728520077184839724_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/155123567919966525715535_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/155123567919966525715535_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/148481497311445343842700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/148481497311445343842700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255976', '1514255976', null, '1157', '1208', '1224', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('27', '[5条盒装]艾塞亚内裤女纯棉新品舒肤棉简约纯色低腰女三角裤糖果色 5条盒装随机色 小码适合80-110斤', '25.00', '100', '100', '1226', '<div class=\"lazyimg\"><p>收到快递通知，新疆暂时无法发货，急件请慎重考虑再下单，具体能发货时间快递无答复，无法催件。谢谢！</p>\n<p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/726148839213792151065000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/726148839213792151065000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><div moduleid=\"R9000475_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/209748880921111001946471_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/209748880921111001946471_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/148101543619882322380290_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/148101543619882322380290_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000475_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/620544987728815036722000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/620544987728815036722000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/110392387014095212729126_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/110392387014095212729126_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000475_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/367103228195262088303400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/367103228195262088303400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/769313984112202226967150_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/769313984112202226967150_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/182967968056724390260750_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/182967968056724390260750_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/570808734876418075884000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/570808734876418075884000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/118950667852701956785040_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/118950667852701956785040_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/921777444825356183192100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/921777444825356183192100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/275142401162676903340920_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/275142401162676903340920_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/297432252152377081953890_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/297432252152377081953890_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/158201519479155206072650_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/158201519479155206072650_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/459271204204778955134100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/459271204204778955134100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/158036995011670885248188_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/158036995011670885248188_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/187650745862654486516940_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/187650745862654486516940_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/149702790419741769558270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/149702790419741769558270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/695436678134481059654620_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/695436678134481059654620_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/328181924102305250735800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/328181924102305250735800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255979', '1514255979', null, '1157', '1208', '1226', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('28', '都市丽人组合内裤 俪人女士内裤 低腰蕾丝性感提臀女士组合内裤3条装2K6331 绿/粉/黄 均码', '0.00', '100', '100', '1227', '<div class=\"lazyimg\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/122460208110686260785200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"苏宁_04\" usemap=\"#Map59\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/122460208110686260785200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p><div moduleid=\"R9000475_3\" modulename=\"商品详情\"><p><strong><span>亲爱的丽人们：<br>          都市丽人品牌旗下拥有都市丝语、都市俪人、都市缤纷派、都市锋尚、都市丽人风、紫色阳光、衣之密语、蒂梦琪、Freeday、都市丽人的秘密、伊丽莎白的秘密等子系列。<br></span></strong></p>\n<p><strong><span>        以上名称会在吊牌中体现，皆为都市丽人集团商品，请放心选购！</span></strong><img data-src=\"//image.suning.cn/uimg/sop/commodity/233747432104115331333750_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absMiddle\" src=\"//image.suning.cn/uimg/sop/commodity/233747432104115331333750_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/743107785212076796030510_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absMiddle\" src=\"//image.suning.cn/uimg/sop/commodity/743107785212076796030510_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/196577055019538015342291_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absMiddle\" src=\"//image.suning.cn/uimg/sop/commodity/196577055019538015342291_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/102856381120640982913600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absMiddle\" src=\"//image.suning.cn/uimg/sop/commodity/102856381120640982913600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/140212133107376145918130_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absMiddle\" src=\"//image.suning.cn/uimg/sop/commodity/140212133107376145918130_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/164754279671281931410000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absMiddle\" src=\"//image.suning.cn/uimg/sop/commodity/164754279671281931410000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/208123151317151188695907_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absMiddle\" src=\"//image.suning.cn/uimg/sop/commodity/208123151317151188695907_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000475_4\" modulename=\"商品尺码表\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/107890508885077319872070_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/107890508885077319872070_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000475_5\" modulename=\"模特效果\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/164754279671281931410000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absMiddle\" src=\"//image.suning.cn/uimg/sop/commodity/164754279671281931410000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000475_6\" modulename=\"包装图示\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/526224481190658946138410_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/526224481190658946138410_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255982', '1514255982', null, '1157', '1208', '1227', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('29', '婴儿玩具大号猫头鹰不倒翁3-6-12个月儿童早教益智宝宝0-1岁不倒翁玩具', '9.00', '100', '100', '1229', '<div class=\"lazyimg\"><div moduleid=\"R3007001_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/174855804673418372145440_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/174855804673418372145440_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3007001_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/129423107131919385219090_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/129423107131919385219090_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/201247519685483064119440_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/201247519685483064119440_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/267482195198653447135910_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/267482195198653447135910_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3007001_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/186139523817552325002083_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/186139523817552325002083_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/577452827249818430320800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/577452827249818430320800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/149994687710948383291556_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/149994687710948383291556_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/151619512910614589171300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/151619512910614589171300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/865211324267361038537800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/865211324267361038537800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255985', '1514255985', null, '1480', '1482', '1229', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('30', 'Propolinse 比那氏蜂胶经典漱口水600ml 王菲同款 除菌防口臭清洁口腔', '79.00', '100', '100', '122', '<div class=\"lazyimg\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/686390480144016572042540_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/686390480144016572042540_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><div moduleid=\"R9000317_2\" modulename=\"商品信息\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/119450857072734095384620_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/119450857072734095384620_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000317_3\" modulename=\"商品特色\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/185650295147680342516880_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/185650295147680342516880_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000317_4\" modulename=\"商品实拍\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/176431681131557188457850_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/176431681131557188457850_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/211877895771728245416500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/211877895771728245416500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/161682451494394610563770_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/161682451494394610563770_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/687846486502198624200000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/687846486502198624200000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/135010172796361502690600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/135010172796361502690600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><p> </p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/211843801017286496044110_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/211843801017286496044110_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p></div>', '', '', '0', '1514255988', '1514255988', null, '70', '113', '122', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('31', '铭铎点读书儿童益智中英文早教书智能电子书', '59.00', '100', '100', '1230', '<div class=\"lazyimg\"><div moduleid=\"R9003176_3\" modulename=\"商品详情\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/146551433218425197482490_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/146551433218425197482490_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/210922413117125626586418_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/210922413117125626586418_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/899732426102456456079500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/899732426102456456079500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/163331912118881234186866_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/163331912118881234186866_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/177184537990732655212450_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/177184537990732655212450_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/922027698408423067390300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/922027698408423067390300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003176_4\" modulename=\"商品参数\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/137436073721920599640150_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/137436073721920599640150_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/109272904212044761851862_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/109272904212044761851862_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/139128451696542671937000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/139128451696542671937000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/190466131819636228866143_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/190466131819636228866143_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/123067710913680718108751_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/123067710913680718108751_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003176_5\" modulename=\"商品展示图\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/167663850122074543272440_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/167663850122074543272440_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/141368271711985516125707_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/141368271711985516125707_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/186092195716750228636696_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/186092195716750228636696_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/838015833180858512559020_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/838015833180858512559020_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/242834336708064730660000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/242834336708064730660000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255991', '1514255991', null, '1480', '1482', '1230', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('32', '新森宝 兼容乐高积木幻影忍者双头龙益智拼装未来骑士团塑料200块以上男女孩玩具6-14岁 空术神庙村送拆件器', '78.00', '100', '100', '1232', '<div class=\"lazyimg\"><div moduleid=\"R3007004_3\" modulename=\"商品详情\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/592808904155141699138380_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/592808904155141699138380_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/213941350716977607252024_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/213941350716977607252024_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/331298837990288748920000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/331298837990288748920000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/188785258049532066667040_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/188785258049532066667040_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/104708688513718157776971_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/104708688513718157776971_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/149852964421218488309120_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/149852964421218488309120_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3007004_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/927609106172664019049240_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/927609106172664019049240_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/694343544128524499284790_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/694343544128524499284790_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/802050773111358732461230_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/802050773111358732461230_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/199197229818724141815507_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/199197229818724141815507_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/442592162235945746539600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/442592162235945746539600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/144230188024497561660670_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144230188024497561660670_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/153359971415771620847365_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/153359971415771620847365_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/244811528360686436500000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/244811528360686436500000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/169352110380370756275800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/169352110380370756275800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/191754680622482612392330_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/191754680622482612392330_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/199607349022134357282210_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/199607349022134357282210_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/182809700714009907066513_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/182809700714009907066513_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/598147853203173878019870_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/598147853203173878019870_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/103758406519427967069900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/103758406519427967069900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/159082024593018231782400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/159082024593018231782400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/400256632115061131748190_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/400256632115061131748190_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/435494201355001470278400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/435494201355001470278400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3007004_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/144832460734840276358680_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144832460734840276358680_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255994', '1514255994', null, '1218', '1225', '1232', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('33', '立健 立体飞行棋单面游戏宝宝爬行垫地毯82*82CM 婴儿爬爬垫毯子儿童地垫', '19.00', '100', '100', '1233', '<div class=\"lazyimg\"><div moduleid=\"R3004002_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/152741593413076293345307_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/152741593413076293345307_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/348008451055232537545500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/348008451055232537545500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/653042452196215722706300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/653042452196215722706300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/128631980420412505357306_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/128631980420412505357306_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/134768879410264724658766_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/134768879410264724658766_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/147083062177593997488330_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/147083062177593997488330_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/190800950119315136516713_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/190800950119315136516713_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/126742141629531952510230_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/126742141629531952510230_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/106120624411735958469469_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/106120624411735958469469_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/194646698110236482856250_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/194646698110236482856250_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/109037929214556543496949_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/109037929214556543496949_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3004002_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/161489734713265863462510_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/161489734713265863462510_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3004002_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/614615459152555608820000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/614615459152555608820000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3004002_9\" modulename=\"购买说明\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/104184739413908159412932_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/104184739413908159412932_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514255998', '1514255998', null, '1218', '1225', '1233', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('34', '诺澳婴儿童游泳池充气婴儿浴盆宝宝洗澡盆充气泳池加大保温家庭戏水池球池 115-95-75豪华套餐', '158.00', '100', '100', '1234', '<div class=\"lazyimg\"><table id=\"__01\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\">\n<tbody>\n<tr>\n<td colspan=\"5\"><a href=\"http://product.suning.com/0070149550/754793344.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/165405090815892846082344_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/165405090815892846082344_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td colspan=\"5\"><a href=\"http://product.suning.com/0070149550/602397254.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/554436799144137291961640_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/554436799144137291961640_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td colspan=\"5\"><a href=\"http://iboolbear1.suning.com/list_210299647_1.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/511430627198792135653130_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/511430627198792135653130_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td><a href=\"http://product.suning.com/0070149550/600667737.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/645918493905957611577000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/645918493905957611577000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/193727835.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/146685808619070748513602_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/146685808619070748513602_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/193727850.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/506423433112265434797700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/506423433112265434797700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/602898536.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/272715110868594081299600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/272715110868594081299600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/193724809.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/155924099062810128278950_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/155924099062810128278950_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td colspan=\"5\"><a href=\"http://iboolbear1.suning.com/list_210299577_1.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/143629356420876509110810_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/143629356420876509110810_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td><a href=\"http://product.suning.com/0070149550/646966738.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/177453957150087844324590_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/177453957150087844324590_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/654484707.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/100148148257269295438270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/100148148257269295438270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/646481182.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/166617815414556472749196_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/166617815414556472749196_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/654481944.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/770057873147862962865320_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/770057873147862962865320_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/654490471.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/447708278188672216830280_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/447708278188672216830280_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n<tr>\n<td><a href=\"http://product.suning.com/0070149550/652338394.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/105263031111249736222672_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/105263031111249736222672_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/652668518.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/530904733179857900646670_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/530904733179857900646670_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/654487345.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/197872559683026662813440_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/197872559683026662813440_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/652670524.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/188903172318476311497319_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/188903172318476311497319_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n<td><a href=\"http://product.suning.com/0070149550/653452714.html\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/497523203118045994519070_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/497523203118045994519070_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td>\n</tr>\n</tbody>\n</table><p></p><p><img picsize=\"57KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/645400132190841857535660_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/645400132190841857535660_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"64KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/112911040820431324378888_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/112911040820431324378888_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"48KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/147580674205017308192680_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/147580674205017308192680_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"43KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/898715961355050199656100_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/898715961355050199656100_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"62KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/489624012476819323053000_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/489624012476819323053000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"36KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/199794010139968405994390_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/199794010139968405994390_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"53KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/307788554156410542678700_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/307788554156410542678700_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"27KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/524006139444351992626100_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/524006139444351992626100_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"46KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/542023689819520661397500_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/542023689819520661397500_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"51KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/486596251808006498605400_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/486596251808006498605400_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"36KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/367083757115821683083110_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/367083757115821683083110_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"38KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/173829627168186644111320_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/173829627168186644111320_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"53KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/159143292326022585978950_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/159143292326022585978950_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"63KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/179276544521211196881270_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/179276544521211196881270_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"51KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/186352272390597795583720_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/186352272390597795583720_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"51KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/925107886203040026358140_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/925107886203040026358140_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"50KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/285786352162640354729540_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/285786352162640354729540_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"45KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/134838941681164497258000_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/134838941681164497258000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"48KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/134950492053903887823530_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/134950492053903887823530_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"41KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/778771951969952349218600_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/778771951969952349218600_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"55KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/112015944776794089792840_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/112015944776794089792840_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"46KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/124438914917421997253611_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/124438914917421997253611_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"43KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/126671243616919131936027_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/126671243616919131936027_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"115KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/144424678221313058868911_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/144424678221313058868911_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"49KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/138429605716648470661355_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/138429605716648470661355_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"55KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/733122658132604234801000_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/733122658132604234801000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"70KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/136033548916782871810220_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/136033548916782871810220_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514256006', '1514256006', null, '1218', '1225', '1234', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('35', 'AUBY 澳贝 益智玩具 森林钢琴健身架 463325DS', '209.00', '100', '100', '1235', '<div class=\"lazyimg\"><div moduleid=\"R3004003_3\" modulename=\"商品详情\"><p><span>钢琴健身架、播放6首音乐、满足坐爬躺</span></p></div><div moduleid=\"R3004003_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/662278725750678915320000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/662278725750678915320000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/128538198784983913751900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/128538198784983913751900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/162882505467842255297650_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/162882505467842255297650_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/217362409907439166724500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/217362409907439166724500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/154982796119115256931586_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/154982796119115256931586_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/740023135898203745179700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/740023135898203745179700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/588751139427945468736800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/588751139427945468736800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/179609333914518230978863_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/179609333914518230978863_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/897238557554055945220000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/897238557554055945220000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/113980109034950522556000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/113980109034950522556000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/102041395641151518914290_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/102041395641151518914290_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/115379354323346933174420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/115379354323346933174420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/101279315015902978015491_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/101279315015902978015491_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/125477259517352294931839_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/125477259517352294931839_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/479929241304478578164700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/479929241304478578164700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/152147568021446862574204_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/152147568021446862574204_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/752486005129240464512390_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/752486005129240464512390_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/145744425116338618007479_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/145744425116338618007479_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3004003_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/611671081254772293125000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/611671081254772293125000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/157132351717138741013679_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/157132351717138741013679_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/192689209865146941584270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/192689209865146941584270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256009', '1514256009', null, '1218', '1225', '1235', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('36', 'DHA磁性立体城市交通运笔迷宫配有磁性白板儿童玩具动手锻炼送有磁性贴纸七巧板农场大迷宫', '218.00', '100', '100', '1236', '<div class=\"lazyimg\"><div moduleid=\"R9003181_5\" modulename=\"商品展示图\"><p><img id=\"3b02766772c54314807e834a2370f200\" data-src=\"//image.suning.cn/uimg/sop/commodity/125408696238030611069180_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/125408696238030611069180_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><br><img id=\"987809388068432598d71c867b700e02\" data-src=\"//image.suning.cn/uimg/sop/commodity/295711225673230843757800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/295711225673230843757800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">  <br><br><img id=\"452268b729024947ad95a6b0a332a8a6\" data-src=\"//image.suning.cn/uimg/sop/commodity/125387318552429426434690_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/125387318552429426434690_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">  <br><br><img id=\"bf70e2bf164c40f9ba56792960437bd7\" data-src=\"//image.suning.cn/uimg/sop/commodity/136365628543483588744000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/136365628543483588744000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n<p> </p>\n<p><br><img id=\"70c4b86e21104115a09d21e2d7f96da2\" data-src=\"//image.suning.cn/uimg/sop/commodity/176028403420719116827595_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/176028403420719116827595_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003181_3\" modulename=\"商品详情\"><p><br> <br> <img id=\"806de25e01d0410893c7b15a5ddcb996\" data-src=\"//image.suning.cn/uimg/sop/commodity/300567702307387575193000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/300567702307387575193000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">  <img id=\"a57485b954f0469a9cd5d0f41903a73d\" data-src=\"//image.suning.cn/uimg/sop/commodity/382106955118171465220120_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/382106955118171465220120_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">  <img id=\"26753f20effe4860bd2a18c9d4570969\" data-src=\"//image.suning.cn/uimg/sop/commodity/203971856218872704313028_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/203971856218872704313028_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n<p><br> </p>\n<p><img id=\"desc-module-3\" data-src=\"//image.suning.cn/uimg/sop/commodity/176028403420719116827595_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/176028403420719116827595_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">  <img data-src=\"//image.suning.cn/uimg/sop/commodity/557385270135049862635170_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absmiddle\" src=\"//image.suning.cn/uimg/sop/commodity/557385270135049862635170_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/159747697684979705153600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absmiddle\" src=\"//image.suning.cn/uimg/sop/commodity/159747697684979705153600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/172674810011559121716433_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absmiddle\" src=\"//image.suning.cn/uimg/sop/commodity/172674810011559121716433_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img id=\"be03828f5fb043f79c68527af96e6ead\" data-src=\"//image.suning.cn/uimg/sop/commodity/163540846915403376912813_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/163540846915403376912813_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">    </p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/138309398412131690676992_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absmiddle\" src=\"//image.suning.cn/uimg/sop/commodity/138309398412131690676992_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/420069693403638232437900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absmiddle\" src=\"//image.suning.cn/uimg/sop/commodity/420069693403638232437900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/214748207412863168989268_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absmiddle\" src=\"//image.suning.cn/uimg/sop/commodity/214748207412863168989268_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/190499507031827659618960_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absmiddle\" src=\"//image.suning.cn/uimg/sop/commodity/190499507031827659618960_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/104185039419629267548410_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absmiddle\" src=\"//image.suning.cn/uimg/sop/commodity/104185039419629267548410_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/207799775813175447003997_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" align=\"absmiddle\" src=\"//image.suning.cn/uimg/sop/commodity/207799775813175447003997_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><span> </span> </p></div><div moduleid=\"R9003181_4\" modulename=\"商品参数\"><p><img id=\"806de25e01d0410893c7b15a5ddcb996\" data-src=\"//image.suning.cn/uimg/sop/commodity/300567702307387575193000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/300567702307387575193000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256012', '1514256012', null, '1218', '1225', '1236', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('37', '268件磁力棒儿童益智玩具礼物男女孩早教磁性拼装积木片环保材质', '89.00', '100', '100', '1237', '<div class=\"lazyimg\"><div moduleid=\"R3007006_3\" modulename=\"商品详情\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/716238464761535744069000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/716238464761535744069000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/151730520819725606565553_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/151730520819725606565553_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/571017611150337526571680_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/571017611150337526571680_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/793451169721229853994000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/793451169721229853994000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/180161400711282650307914_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/180161400711282650307914_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/553425241172805877857300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/553425241172805877857300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/103218595720477139612700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/103218595720477139612700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/846343468695732674907900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/846343468695732674907900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/141710035135733708064850_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/141710035135733708064850_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/157020944743943418266760_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/157020944743943418266760_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/420011953521407581616400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/420011953521407581616400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/516862067101537603817960_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/516862067101537603817960_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/558164157163221596372610_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/558164157163221596372610_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/998537439191126045766900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/998537439191126045766900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/180746716053145261236600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/180746716053145261236600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/441564195246104533971200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/441564195246104533971200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/102088258728645089216300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/102088258728645089216300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/184523273320494285896100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/184523273320494285896100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/148628412515667457042967_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/148628412515667457042967_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/561911463815783221154000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/561911463815783221154000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/523329788158858849012900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/523329788158858849012900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/137581860013885035699516_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/137581860013885035699516_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/157962544671965102781420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/157962544671965102781420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/166618949821190519518329_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/166618949821190519518329_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/729706435144762078129120_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/729706435144762078129120_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/188931376720319253374204_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/188931376720319253374204_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3007006_4\" modulename=\"商品参数\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/159817785819803758028283_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/159817785819803758028283_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3007006_5\" modulename=\"商品展示图\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/443668831192068133386740_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/443668831192068133386740_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256015', '1514256015', null, '1218', '1225', '1237', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('38', '奥迪双钻（AULDEY）超级飞侠-立体造型背包（乐迪款） 710061', '98.00', '100', '100', '1238', '<div class=\"lazyimg\"><div moduleid=\"R9003183_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/147701583116748550144784_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/147701583116748550144784_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/150922313421313741392393_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/150922313421313741392393_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/166504589119083637106387_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/166504589119083637106387_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003183_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/188757056049969188114980_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/188757056049969188114980_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/177893219215179157553159_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/177893219215179157553159_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003183_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/111339085120182629825506_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/111339085120182629825506_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/439138874203278912064500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/439138874203278912064500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256019', '1514256019', null, '1218', '1225', '1238', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('39', '麦宝创玩 麦宝 韩版音乐滑梯 小鹿滑梯宝宝上下式折叠滑梯 游乐幼儿园儿童内户外健身玩具（卡通小鹿粉蓝色）', '149.00', '100', '100', '1239', '<div class=\"lazyimg\"><div moduleid=\"R3004006_2\" modulename=\"关联推荐\"><!-- tjb_top_mark_start --><div style=\"overflow:hidden;clear:both\"><!-- tjb_top_5681_mark_start --><div style=\"overflow:hidden\"><!-- tjb_mod_6652_mark_start --><img data-src=\"//image.suning.cn/uimg/sop/commodity/180916272032062430714560_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" title=\"\" align=\"\" src=\"//image.suning.cn/uimg/sop/commodity/180916272032062430714560_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><!-- tjb_mod_6652_mark_end --></div><div style=\"overflow:hidden\"><!-- tjb_mod_6654_mark_start --><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"left\" bgcolor=\"#FFBF25\" style=\"width: 100%; height: auto;\"><tbody><tr><td><a href=\"http://shop.suning.com/70073473/index.html\" target=\"_blank\"><img data-src=\"http://image.suning.cn/uimg/sop/commodity/507534564163138526889810_x.jpg?from=mobile&amp;format=80q.webp\" border=\"0\" src=\"http://image.suning.cn/uimg/sop/commodity/507534564163138526889810_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr><tr><td><ul><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/185825859.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image1.suning.cn/uimg/b2c/newcatentries/0070073473-000000000185825859_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image1.suning.cn/uimg/b2c/newcatentries/0070073473-000000000185825859_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩 中国地图 拼图宝宝 世界地理国家 认知玩具木质拼图 儿童益智互动玩具1526</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥35元</del><br><b><b>￥</b><b>25</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/185825859.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/129166747.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image1.suning.cn/uimg/b2c/newcatentries/0070073473-000000000129166747_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image1.suning.cn/uimg/b2c/newcatentries/0070073473-000000000129166747_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩 立体木质动物拼图儿童积木制早教益智力拼板 卡通木质拼图4款不同</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥30元</del><br><b><b>￥</b><b>9.9</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/129166747.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/172963711.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image2.suning.cn/uimg/b2c/newcatentries/0070073473-000000000172963711_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image2.suning.cn/uimg/b2c/newcatentries/0070073473-000000000172963711_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩 麦宝 益智玩具塑料积木 幼儿乐园雪花片拼插搭建片 拼搭创意 数字雪花片500G袋装</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥59元</del><br><b><b>￥</b><b>19</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/172963711.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/168432766.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image5.suning.cn/uimg/b2c/newcatentries/0070073473-000000000168432766_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image5.suning.cn/uimg/b2c/newcatentries/0070073473-000000000168432766_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩 麦宝 儿童益智宝宝小猫钓鱼 玩具戏水磁性钓鱼玩具池套装 （颜色随机发）</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥60元</del><br><b><b>￥</b><b>45</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/168432766.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/129166819.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image2.suning.cn/uimg/b2c/newcatentries/0070073473-000000000129166819_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image2.suning.cn/uimg/b2c/newcatentries/0070073473-000000000129166819_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩 树叶型 雪花拼插塑料积木 儿童早教益智拼插拼装积木玩具 中号圆孔雪花片箱装1300片</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥102元</del><br><b><b>￥</b><b>65</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/129166819.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/190591700.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image4.suning.cn/uimg/b2c/newcatentries/0070073473-000000000190591700_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image4.suning.cn/uimg/b2c/newcatentries/0070073473-000000000190591700_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩 加厚连体塑料摇马 儿童小木马宝宝摇摇马婴幼儿摇椅 多色摇马幼儿游乐园儿童房玩具 紫色闪光音乐连体马+送电池</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥108元</del><br><b><b>￥</b><b>68</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/190591700.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/123128543.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image3.suning.cn/uimg/b2c/newcatentries/0070073473-000000000123128543_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image3.suning.cn/uimg/b2c/newcatentries/0070073473-000000000123128543_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩音乐加厚连体塑料摇马小木马宝宝摇婴幼儿摇椅幼儿游乐园儿童房玩具户外 糖果蓝升级40首闪光音乐+豪华版</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥108元</del><br><b><b>￥</b><b>65</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/123128543.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/184934419.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image1.suning.cn/uimg/b2c/newcatentries/0070073473-000000000184934419_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image1.suning.cn/uimg/b2c/newcatentries/0070073473-000000000184934419_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩 新款加厚环保音乐儿童摇马宝宝室内塑料摇摇小木马婴儿摇摇马玩具萌小马 粉色萌小马+豪华款</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥125元</del><br><b><b>￥</b><b>85</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/184934419.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/121546335.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image2.suning.cn/uimg/b2c/newcatentries/0070073473-000000000121546335_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image2.suning.cn/uimg/b2c/newcatentries/0070073473-000000000121546335_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>盈泰YT027直径130cm充气水晶底三环游泳池浴缸戏水池送气泵 1.3米球池+300个球</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥108元</del><br><b><b>￥</b><b>98</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/121546335.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/120709061.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image4.suning.cn/uimg/b2c/newcatentries/0070073473-000000000120709061_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image4.suning.cn/uimg/b2c/newcatentries/0070073473-000000000120709061_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩 韩版儿童滑梯皇冠加长宽音乐塑料滑滑梯室内户外家庭幼儿游乐园折叠收纳滑梯婴儿玩具 粉蓝+音乐 加长滑梯+球框</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥398元</del><br><b><b>￥</b><b>198</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/120709061.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/188401601.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image3.suning.cn/uimg/b2c/newcatentries/0070073473-000000000188401601_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image3.suning.cn/uimg/b2c/newcatentries/0070073473-000000000188401601_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩儿童室内滑梯家用多功能滑滑梯宝宝组合滑梯秋千塑料玩具加厚 炫彩典藏版四合一</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥619元</del><br><b><b>￥</b><b>539</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/188401601.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li><li onmouseover=\"this.style.backgroundColor=\'#FFBF25\'\" onmouseout=\"this.style.backgroundColor=\'#FFFFFF\'\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><p><a target=\"_blank\" href=\"http://product.suning.com/0070073473/617250559.html\"><img width=\"100%\" height=\"auto\" border=\"0\" data-src=\"//image1.suning.cn/uimg/b2c/newcatentries/0070073473-000000000617250559_1_400x400.jpg?from=mobile&amp;format=80q.webp\" src=\"//image1.suning.cn/uimg/b2c/newcatentries/0070073473-000000000617250559_1_400x400.jpg?from=mobile&format=80q.webp\"></a></p></td></tr><tr><td align=\"center\"><p>麦宝创玩 室内儿童滑梯家用多功能 滑滑梯 宝宝滑梯秋千组合塑料玩具健身 新款小熊粉色六合一</p></td></tr><tr><td><table cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\"><tbody><tr><td><del>￥889元</del><br><b><b>￥</b><b>790</b></b></td><td width=\"47\" align=\"center\"><a target=\"_blank\" href=\"http://product.suning.com/0070073473/617250559.html\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&amp;format=80q.webp\" src=\"//image.suning.cn/uimg/sop/commodity/107146341856357379355900_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></td></tr></tbody></table></td></tr></tbody></table></li></ul></td></tr></tbody></table><!-- tjb_mod_6654_mark_end --></div><!-- tjb_top_5681_mark_end --></div><!-- tjb_top_mark_end --></div><div moduleid=\"R3004006_3\" modulename=\"商品详情\"><p><img id=\"b6e23ac7970d4cb19693ccb78fac03e6\" data-src=\"//image.suning.cn/uimg/sop/commodity/165296517921119481312339_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/165296517921119481312339_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><img id=\"39235b9189434b3c9f16083136bd8a12\" data-src=\"//image.suning.cn/uimg/sop/commodity/791639965617990863179200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/791639965617990863179200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">  <br><img id=\"6c30de452b374fc9a23aaaf1e3e7dc00\" data-src=\"//image.suning.cn/uimg/sop/commodity/133048023512564778161438_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/133048023512564778161438_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">   <br><img id=\"22ffd914cfc64a3dbc4fe74477b57414\" data-src=\"//image.suning.cn/uimg/sop/commodity/123078455927489558267300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/123078455927489558267300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><br><img id=\"52baff4cf3f74ab18de4eaf98ff2b489\" data-src=\"//image.suning.cn/uimg/sop/commodity/385583993189705943235700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/385583993189705943235700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><img id=\"6f4df02e7d264baea208eb2c66297222\" data-src=\"//image.suning.cn/uimg/sop/commodity/170049863619629171541810_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/170049863619629171541810_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><img id=\"aa1ace3af47041698e62d0edf5bee647\" data-src=\"//image.suning.cn/uimg/sop/commodity/912510117193227942292010_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/912510117193227942292010_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><img id=\"a36bfacf1fe24f40b7251d7d577c7c6b\" data-src=\"//image.suning.cn/uimg/sop/commodity/103602262617300634184438_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/103602262617300634184438_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><img id=\"e1032d2537a74de284420e327560f473\" data-src=\"//image.suning.cn/uimg/sop/commodity/734045189142774442220570_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/734045189142774442220570_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><img id=\"4e91b0d8bb5940cc93ad80ff2308ebe7\" data-src=\"//image.suning.cn/uimg/sop/commodity/101772337921314351636324_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/101772337921314351636324_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">   <br><img id=\"b1fd0cc375ba4fa9851e48517001b96d\" data-src=\"//image.suning.cn/uimg/sop/commodity/148814544611702909824603_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/148814544611702909824603_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\">   <br><img id=\"ddca73396e8c4c14a4e50c7656cb4e9c\" data-src=\"//image.suning.cn/uimg/sop/commodity/889821858234693610235800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/889821858234693610235800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img id=\"25f7812a2c014e0b9a49af4b965b4c04\" data-src=\"//image.suning.cn/uimg/sop/commodity/380415778288653658296700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/380415778288653658296700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p><p><img id=\"eda786b0ca624e99af3020f310eaea76\" data-src=\"//image.suning.cn/uimg/sop/commodity/228689954169647295693290_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/228689954169647295693290_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><img id=\"ae4e88068a274959b1721531126d317b\" data-src=\"//image.suning.cn/uimg/sop/commodity/156056271276119940024340_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/156056271276119940024340_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><img id=\"6495ef7f92314e3699489da1c7a649ad\" data-src=\"//image.suning.cn/uimg/sop/commodity/632387947119380300585000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/632387947119380300585000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><br><img id=\"ffd4aaa0dfaf41b2a3b444145e66cb2e\" data-src=\"//image.suning.cn/uimg/sop/commodity/638247926251782515223000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/638247926251782515223000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3004006_4\" modulename=\"商品参数\"><p>小花朵奶油白 标配</p></div><div moduleid=\"R3004006_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/194120635902945499526900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/194120635902945499526900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256022', '1514256022', null, '1480', '1482', '1239', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('40', 'Femfresh 芳芯女性私密洗护液洋甘菊250ml 无皂去异味女性清新温和【新旧包装随机】', '39.00', '100', '100', '123', '<div class=\"lazyimg\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/686390480144016572042540_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/686390480144016572042540_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><div moduleid=\"R9000369_2\" modulename=\"商品信息\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/183474652810647021119364_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/183474652810647021119364_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000369_3\" modulename=\"商品特色\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/463819558287106294633900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/463819558287106294633900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9000369_4\" modulename=\"商品实拍\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/427197466131578483597000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/427197466131578483597000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/232757341173731867248440_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/232757341173731867248440_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/515510882427338034297400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/515510882427338034297400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><p> </p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/211843801017286496044110_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/211843801017286496044110_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p></div>', '', '', '0', '1514256025', '1514256025', null, '70', '113', '123', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('41', '安格尔婴儿波波球宝宝海洋球加厚弹力彩色球儿童玩具多色球戏水玩具30个6.5cm海洋球', '10.00', '100', '100', '1240', '<div class=\"lazyimg\"><div moduleid=\"R9003156_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/623046273223412595781000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/623046273223412595781000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/114744202416301451354093_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/114744202416301451354093_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/102025343860007139555660_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/102025343860007139555660_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/369226401130793991914910_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/369226401130793991914910_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/126085976314084060741807_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/126085976314084060741807_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/168336356059924681382360_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/168336356059924681382360_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/185472178686916580658820_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/185472178686916580658820_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/123649434190477937682080_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/123649434190477937682080_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003156_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/126576826193095611959060_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/126576826193095611959060_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003156_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/275783994144826462058360_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/275783994144826462058360_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/122522395795623390879270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/122522395795623390879270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/122174163418910008371668_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/122174163418910008371668_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/106929949111015774412957_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/106929949111015774412957_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/590242523662399956355000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/590242523662399956355000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/225068630185957954345690_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/225068630185957954345690_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003156_9\" modulename=\"购买说明\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/146180655892618076150670_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/146180655892618076150670_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/122198211011682380352012_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/122198211011682380352012_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/557410593159740515412600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/557410593159740515412600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256028', '1514256028', null, '1218', '1228', '1240', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('42', '汇乐玩具（HUILE TOYS）快乐摇马 987 儿童音乐小木马摇摇马/滑行车摇摇车两用玩具 18个月', '159.00', '100', '100', '1241', '<div></div>', '', '', '0', '1514256031', '1514256031', null, '1218', '1228', '1241', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('43', '【苏宁易购】moreyear儿童吹泡泡机电动玩具发光带音乐炫酷赛车泡泡枪', '39.00', '100', '100', '1242', '<div class=\"lazyimg\"><div moduleid=\"R9003152_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/385724327196338540730810_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/385724327196338540730810_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/187678720485726495572500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/187678720485726495572500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/149513160717238157831331_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/149513160717238157831331_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/117739787127470246981330_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/117739787127470246981330_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/178893557613740246029765_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/178893557613740246029765_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/169487664914029267152807_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/169487664914029267152807_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/187955468899002546635190_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/187955468899002546635190_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/645073115161401151826060_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/645073115161401151826060_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/133326565120252885364853_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/133326565120252885364853_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/208784799689298816224470_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/208784799689298816224470_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003152_4\" modulename=\"商品参数\"><p>.......</p></div><div moduleid=\"R9003152_5\" modulename=\"商品展示图\"><p>........</p></div></div>', '', '', '0', '1514256035', '1514256035', null, '1218', '1228', '1242', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('44', '澳贝 AUBY 沐浴系列 海洋动物沐浴套装 463505DS', '51.00', '100', '100', '1243', '<div class=\"lazyimg\"><div moduleid=\"R9003145_3\" modulename=\"商品详情\"><p>产品基本参数：<br>品牌：澳贝AUBY<br>商品名称：沐浴系列 海洋动物沐浴套装<br>商品货号：463505DS<br>材质：塑料<br>使用年龄：18个月以上<br>产品特点：<br>1、沐浴/戏水多用途使宝宝爱上沐浴<br>2、玩法多多，乐趣多多<br>3、加强宝宝与家长之间的互动交流</p><p><img title=\"463505DS_01.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097235763866.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097235763866.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_02.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097171105383.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097171105383.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_03.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097228368587.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097228368587.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_04.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097305815366.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097305815366.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_05.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097553213990.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097553213990.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_06.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097560305825.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097560305825.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_07.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097629182293.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097629182293.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003145_4\" modulename=\"商品参数\"><p><img title=\"463505DS_08.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097882433547.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097882433547.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_09.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097915523262.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097915523262.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_10.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285097923710517.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285097923710517.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003145_5\" modulename=\"商品展示图\"><p><img title=\"463505DS_11.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285098147581873.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285098147581873.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_12.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285098165992254.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285098165992254.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img title=\"463505DS_13.jpg\" data-src=\"//image.suning.cn/uimg/sop/commodity/144285098177924603.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144285098177924603.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256039', '1514256039', null, '1218', '1228', '1243', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('45', '儿童玩具海洋球池婴儿帐篷宝宝热带雨林运动会投手球池投篮游戏屋波波球户外玩具', '83.00', '100', '100', '1244', '<div class=\"lazyimg\"><div moduleid=\"R9003153_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/850620611161327504068350_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/850620611161327504068350_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/833180606154572198925470_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/833180606154572198925470_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/121428288219279912372612_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/121428288219279912372612_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/100009542754189806696800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/100009542754189806696800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003153_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/732319433150544564357660_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/732319433150544564357660_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107821891177316219861430_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/107821891177316219861430_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003153_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/157356262828789454869330_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/157356262828789454869330_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/139588720333959748798820_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/139588720333959748798820_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/130777865210311902135263_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/130777865210311902135263_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/112705279328385054330840_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/112705279328385054330840_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/690962859345072064770000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/690962859345072064770000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/247204197473442984277600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/247204197473442984277600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003153_6\" modulename=\"商品细节\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/154540751970791684246890_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/154540751970791684246890_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/134948680813022767344658_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/134948680813022767344658_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/136938172814166390636058_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/136938172814166390636058_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/880077059181081206473100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/880077059181081206473100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/147013606861185649716510_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/147013606861185649716510_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003153_8\" modulename=\"包装图示\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/182811510369834231524020_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/182811510369834231524020_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/199289314143092217453100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/199289314143092217453100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/842503226796377566498600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/842503226796377566498600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/122262009620238502374015_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/122262009620238502374015_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/987256059430761000659100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/987256059430761000659100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003153_9\" modulename=\"购买说明\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/146180655892618076150670_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/146180655892618076150670_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/190841846077125146920270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/190841846077125146920270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/410337602121325429926700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/410337602121325429926700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256042', '1514256042', null, '1218', '1228', '1244', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('46', '小猪佩奇圆形零钱包 儿童卡通小包包 佩佩猪斜跨包挂包女孩可爱玩具 粉色', '26.00', '100', '100', '1245', '<div class=\"lazyimg\"><div moduleid=\"R3003004_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/219987593115418747011400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/219987593115418747011400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/137516250352839917790760_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/137516250352839917790760_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3003004_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/255983226212315892135780_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/255983226212315892135780_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/690309601138522578231400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/690309601138522578231400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/273066620861330035503100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/273066620861330035503100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/144029999120241928492640_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144029999120241928492640_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/179411278243166008786750_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/179411278243166008786750_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3003004_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/394573055324119303402200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/394573055324119303402200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/153875162104736959180440_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/153875162104736959180440_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/793782118140211882273950_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/793782118140211882273950_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/375290119210204428544070_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/375290119210204428544070_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/381025599570936967235600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/381025599570936967235600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/156699677093974013069010_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/156699677093974013069010_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/101287580168717380557790_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/101287580168717380557790_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256045', '1514256045', null, '1480', '1482', '1245', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('47', 'Fisher Price 费雪-声光安抚海马- 蓝色0-6个月婴幼儿毛绒玩具 DGH82', '0.00', '100', '100', '1247', '<div class=\"lazyimg\"><div moduleid=\"R3003002_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/594650657780531096426800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/594650657780531096426800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3003002_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/582946466703049279948000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/582946466703049279948000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/110231541910914516418862_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/110231541910914516418862_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/763975901134107646341870_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/763975901134107646341870_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/335639137494264002304400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/335639137494264002304400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/149938587119710673299900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/149938587119710673299900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/546597609167990155988570_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/546597609167990155988570_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/124560531619103632669544_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/124560531619103632669544_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/180477695315595125902782_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/180477695315595125902782_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/273137695174358765245330_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/273137695174358765245330_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/152112797134081334269000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/152112797134081334269000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/550754981739968774252900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/550754981739968774252900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3003002_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/739527104552469078668500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/739527104552469078668500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/168483419711908019793244_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/168483419711908019793244_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256048', '1514256048', null, '1218', '1231', '1247', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('48', '木丸子大号榉木51数字层层叠叠叠乐叠叠高 抽积木桌游儿童成人木质益智玩具 带锤子', '41.00', '100', '100', '1248', '<div class=\"lazyimg\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/732273534111935214871150_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/732273534111935214871150_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p></p><p><img picsize=\"155KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/563992329190531943188040_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/563992329190531943188040_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"31KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/119804892670224291470670_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/119804892670224291470670_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"53KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/758100233126002711674410_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/758100233126002711674410_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"116KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/138427254860049471037920_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/138427254860049471037920_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"126KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/120822456521157615134148_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/120822456521157615134148_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"91KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/124773567133588867660120_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/124773567133588867660120_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"2KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/405997313120856171053830_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/405997313120856171053830_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"139KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/543010689200409787011200_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/543010689200409787011200_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"129KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/209686191184219894739570_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/209686191184219894739570_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"95KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/120881403112549539543640_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/120881403112549539543640_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"155KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/160896807014780168162064_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/160896807014780168162064_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514256052', '1514256052', null, '1218', '1231', '1248', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('49', 'Disney/迪士尼 3D橡皮泥套装雪糕机彩泥模具工具无毒手工泥粘土男女孩玩具蛋糕甜品套装', '0.00', '100', '100', '1249', '<div class=\"lazyimg\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/159216691314123474716835_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" usemap=\"#Map\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/159216691314123474716835_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p><div moduleid=\"R3008001_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/625109981751227548850600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/625109981751227548850600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/885030326587516518915700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/885030326587516518915700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/172204595217467948872818_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/172204595217467948872818_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/159900741514829941122148_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/159900741514829941122148_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/194963163181648315550300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/194963163181648315550300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/115306392348265735272870_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/115306392348265735272870_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/785054321948574047772500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/785054321948574047772500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/189023719848092967357740_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/189023719848092967357740_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/119734679416477792889900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/119734679416477792889900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/923525499496237846889800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/923525499496237846889800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/202661598314755273836320_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/202661598314755273836320_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/207120321711305976717951_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/207120321711305976717951_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/166427231153536643992250_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/166427231153536643992250_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/190174139222343427182690_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/190174139222343427182690_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/896831549166822557798400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/896831549166822557798400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/203638698737472587685300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/203638698737472587685300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/174815466317338986713099_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/174815466317338986713099_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/194499287098596630355700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/194499287098596630355700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3008001_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/958886682611281385315800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/958886682611281385315800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3008001_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/152961938221064988861695_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/152961938221064988861695_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256055', '1514256055', null, '1218', '1231', '1249', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('50', '【海外购自营】Swisse奶蓟草片 120片/瓶 澳洲进口 护肝排毒 保健品', '0.00', '100', '100', '124', '<div class=\"lazyimg\"><p><a href=\"https://g.suning.com/\" target=\"_blank\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/302227931152378466201300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/302227931152378466201300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></a></p><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/208193367518487593577283_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/208193367518487593577283_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n<p>Swisse Ultiboost排毒片是一种高品质的配方，含有传统上广泛用于维持肝功能的草本植物，能够缓解消化不良和腹胀引起的不适。</p>\n<p>【成分】：每片含：洋蓟提取物，相当于洋蓟鲜叶1克；相当于下列成分干燥物的标准化提取物：奶蓟果实（相当于28.6毫克的水飞蓟宾计算的</p>\n<p>黄酮木脂素）2.5克，姜黄根茎（相当于48.75毫克姜黄素）1.5克。</p>\n<p>【过敏原】：不添加乳糖、麸质、酵母、蛋类和人工香精。</p>\n<p>【食用建议】：成人剂量：每日2片。随餐或餐后服用；或遵专业医护人员指示服用。</p>\n<p>【储存方法】：请于30℃下保存。如果密封盖已破损，请勿食用。</p>\n<p>【温馨提示】：如果已怀孕货计划怀孕请勿食用。若症状持续，请咨询医护人员。</p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/160389625218413580739677_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/160389625218413580739677_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514256059', '1514256059', null, '1480', '1482', '124', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('51', '七巧板大号双面磁性 儿童画板 画架小黑板支架式升降写字板画画板', '153.00', '100', '100', '1251', '<div class=\"lazyimg\"><div moduleid=\"R3008002_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/351724778214348546817300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/351724778214348546817300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/151841203727213643947000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/151841203727213643947000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/636066469587231536317800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/636066469587231536317800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/617196808116855219580610_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/617196808116855219580610_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/139143436237050329727350_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/139143436237050329727350_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/112649631573629764390790_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/112649631573629764390790_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/206984969957927704998190_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/206984969957927704998190_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/410831804163864740658740_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/410831804163864740658740_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/170332543976534671438990_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/170332543976534671438990_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/584125332747001002200000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/584125332747001002200000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/728988325156305510922160_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/728988325156305510922160_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/790933095115637503251420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/790933095115637503251420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/185948878110511365675944_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/185948878110511365675944_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/111530930634980792391240_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/111530930634980792391240_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/172190699713239493485807_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/172190699713239493485807_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3008002_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/113903788312803793512863_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/113903788312803793512863_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R3008002_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/181518829671034791652330_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/181518829671034791652330_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256062', '1514256062', null, '1218', '1231', '1251', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('52', 'TOPBRIGHT/特宝儿 赛车滑轨 120272 轨道车赛车玩具车模型套装儿童小汽车套装组合儿童玩具', '56.00', '100', '100', '1252', '<div class=\"lazyimg\"><div moduleid=\"R9003171_3\" modulename=\"商品详情\"><p>Topbright特宝儿 赛车轨道 120272</p>\n<p>●趣味滑行车，开启成长智力，感受速度与激情。●可以练习孩子的专注力、视觉追踪、颜色识别、数字认知。●简约酷跑小车，品质体现，超厚轴承。●弧形极速彩虹跑道，视觉速度感官强强联手。●停车场设计，再也不怕找不到停车位。●视觉追踪和专注力，宝宝的眼睛随着小车的滑行而移动，锻炼视觉追踪和专注力。●亲子互动滑行，比一比谁的车跑的快？</p>\n<p>产品基本参数：<br>品牌：特宝儿 Topbright<br>商品名称：赛车滑轨</p>\n<p>商品货号：120272</p>\n<p>材质：荷木、ABS、铁线、夹板</p>\n<p>使用年龄：24个月以上 <br>产品特点：</p>\n<ul>\n<li>亲子互动滑行</li>\n<li>锻炼宝宝的时间追踪和专注力</li>\n<li>弧形极速彩虹跑道，视觉速度感官强强联手</li>\n</ul>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/158360555523435394357600_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/158360555523435394357600_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/613090047742178374357900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/613090047742178374357900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/808518659263060628996800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/808518659263060628996800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/201330375362924817360340_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/201330375362924817360340_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/377116405403643464790800_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/377116405403643464790800_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003171_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/167786748448627415691190_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/167786748448627415691190_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/439614297201802751972620_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/439614297201802751972620_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/517756830190717740646680_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/517756830190717740646680_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/177531727724534586879000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/177531727724534586879000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/846891717104275676256030_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/846891717104275676256030_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/508321782284393016554900_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/508321782284393016554900_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/114119525612918084218369_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/114119525612918084218369_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/153920192019656301498971_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/153920192019656301498971_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/728904896145750505515490_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/728904896145750505515490_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/925416288193588067342850_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/925416288193588067342850_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003171_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/721282457580932056715400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/721282457580932056715400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256065', '1514256065', null, '1218', '1231', '1252', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('53', '【苏宁自营】Hot Wheels风火轮火辣小跑车C4982', '0.00', '100', '100', '1253', '<div class=\"lazyimg\"><div moduleid=\"R3002003_3\" modulename=\"商品详情\"><p> </p><p><span>【商品品牌】风火轮 HOTWHEELS<br>【商品名称】HOT WHEELS 风火轮火辣小跑车<br>【商品货号】C4982（1支卡装 款式随机）<br>【商品产地】马来西亚<br>【适合年龄】3岁以上<br>【商品材质】高级安全塑料、锌合金<br>【包装尺寸】长:10.7cm 宽:3.7cm 高：16.5cm<br>【实物尺寸】长：6cm左右 宽：3.3cm左右（实物较小，介意勿拍）<br>【保养方法】用软布轻拭，不可洗涤<br>【安全警告】内涵小零件不适合3岁及以下儿童使用</span></p><p> </p><p>风火轮经典小车，拥有40年的历史，以设计大胆，形式多样而著称，深受国内外小朋友的喜爱，据统计，全世界已超过1600万3-10岁的小朋友成为风火轮的收藏者。另外，小车还可以配合风火轮各主题轨道一起游戏，无以伦比的速度与刺激更是给小朋友带来了无限的乐趣。</p><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/201502111039032091_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/201502111039032091_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p>混装随机发货</p></div><div moduleid=\"R3002003_4\" modulename=\"商品参数\"><p>C4982</p></div><div moduleid=\"R3002003_5\" modulename=\"商品展示图\"><p>C4982</p></div></div>', '', '', '0', '1514256069', '1514256069', null, '1480', '1482', '1253', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('54', 'EVTTO怡多贝 电动儿童钓鱼玩具多功能音乐捕鱼台宝宝过家家益智玩具亲子互...', '49.00', '100', '100', '1254', '<div class=\"lazyimg\"><p></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/736641441178111532763300_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"90.9501953125KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/736641441178111532763300_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/109731849719008760951239_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"114.59375KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/109731849719008760951239_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/545374387653154204414000_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"89.0966796875KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/545374387653154204414000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/105726297435172671799510_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"103.3271484375KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/105726297435172671799510_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/180225304715143150482080_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"135.5615234375KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/180225304715143150482080_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/948193061182048794676150_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"64.2490234375KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/948193061182048794676150_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/143962406159043804590140_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"59.138671875KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/143962406159043804590140_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/327208860159896630935670_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"85.5947265625KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/327208860159896630935670_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/131395974857092390433510_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"62.984375KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/131395974857092390433510_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/125660468316572686615138_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"32.017578125KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/125660468316572686615138_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/171747045920078096606451_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"105.4150390625KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/171747045920078096606451_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/202826943611645427339738_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"55.033203125KB\" src=\"//image.suning.cn/uimg/sop/phonecomm/202826943611645427339738_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514256072', '1514256072', null, '1218', '1246', '1254', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('55', '恐龙玩具模型变形恐龙蛋儿童仿真动物霸王龙翼龙三角龙模型玩具', '38.00', '100', '100', '1255', '<div class=\"lazyimg\"><div moduleid=\"R9003169_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/102315337419170059535518_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/102315337419170059535518_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/187430909913456285998795_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/187430909913456285998795_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/154435002716389433951210_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/154435002716389433951210_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/740658891940486648662700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/740658891940486648662700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/106039923714853356429530_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/106039923714853356429530_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003169_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/200912887457518735729160_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/200912887457518735729160_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003169_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/109120610014694441231747_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/109120610014694441231747_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256075', '1514256075', null, '1218', '1246', '1255', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('56', '优衣乐5斤太空火星玩具沙套装儿童魔力粘土散沙子安全无毒女孩橡皮彩泥', '58.00', '100', '100', '1256', '<div class=\"lazyimg\"><p></p><p><img picsize=\"64KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/151706252034587844514900_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/151706252034587844514900_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"64KB\" data-src=\"?from=mobile\" alt=\"\" src=\"?from=mobile\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"38KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/912132793192075883731210_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/912132793192075883731210_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"64KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/137795161912864913000000_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/137795161912864913000000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"55KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/469275823991149637639200_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/469275823991149637639200_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"58KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/161128335610786753241188_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/161128335610786753241188_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"59KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/137592339139280268852220_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/137592339139280268852220_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"50KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/160397374814513866826608_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/160397374814513866826608_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"78KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/126587058490264026058170_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/126587058490264026058170_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"38KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/867217740167140403134190_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/867217740167140403134190_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"33KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/136004985620654172877773_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/136004985620654172877773_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"29KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/261553535631347560636000_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/261553535631347560636000_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"36KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/476948352124423990354860_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/476948352124423990354860_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"33KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/109483629516732756199162_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/109483629516732756199162_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"30KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/144016917216391425373928_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/144016917216391425373928_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"43KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/198634985717773388131879_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/198634985717773388131879_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"40KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/108140637116176578194488_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/108140637116176578194488_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"44KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/591396510136548332529480_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/591396510136548332529480_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"30KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/103921445819409730242030_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/103921445819409730242030_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img picsize=\"54KB\" data-src=\"//image.suning.cn/uimg/sop/phonecomm/180046070890917710514500_640x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/phonecomm/180046070890917710514500_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p>乐分享，拼划算，购喜欢。 苏宁乐拼购是依托苏宁易购的社交购物方式，正品保证，精品好货，亿万用户的购物平台，打造购物新体验。</p></div>', '', '', '0', '1514256078', '1514256078', null, '1218', '1246', '1256', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('57', '奥迪双钻 AULDEY 超级飞侠 珍藏系列可动玩偶-大鹏 710051', '38.00', '100', '100', '1257', '<div class=\"lazyimg\"><div moduleid=\"R9003166_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/703057253544432086339200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/703057253544432086339200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003166_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/176913880418428306116849_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/176913880418428306116849_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/506881139238319783322000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/506881139238319783322000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003166_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/648517558172922150233340_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/648517558172922150233340_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/210225735114249741649188_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/210225735114249741649188_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256081', '1514256081', null, '1218', '1246', '1257', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('58', 'LEFEI/乐飞 儿童惯性迷你坦克/军事战车克模型导弹战车玩具塑料滑行车1-3岁单只', '19.00', '100', '100', '1258', '<div class=\"lazyimg\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/166078137718443710762394_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/166078137718443710762394_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><div moduleid=\"R9003164_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/526202545153531181589090_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/526202545153531181589090_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/172053414920217114371512_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/172053414920217114371512_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/947327988419612770921200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/947327988419612770921200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/richtext/471019778680698141918100.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/471019778680698141918100.gif?from=mobile\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/richtext/212036627114265083898526.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/212036627114265083898526.gif?from=mobile\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/richtext/739646523188163306439940.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/739646523188163306439940.gif?from=mobile\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/richtext/175851843387084396422200.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/175851843387084396422200.gif?from=mobile\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/richtext/114539040616255610286017.gif?from=mobile\" alt=\"\" src=\"//image.suning.cn/uimg/sop/richtext/114539040616255610286017.gif?from=mobile\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003164_4\" modulename=\"商品参数\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/101689846263739564297200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/101689846263739564297200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003164_5\" modulename=\"商品展示图\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/141188451441911214068500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/141188451441911214068500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/201622765241649209139100_x.png?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/201622765241649209139100_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n<p> </p></div></div>', '', '', '0', '1514256085', '1514256085', null, '1218', '1246', '1258', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('59', '【美国苏宁直采】普丽普莱Puritans’sPride 双倍氨糖软骨素MSM营养片 240粒/瓶 美国进口 保护关节', '0.00', '100', '100', '125', '<div class=\"lazyimg\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/166276561634402126651000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/166276561634402126651000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/158173321115840668503743_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" usemap=\"#Map\" border=\"0\" src=\"//image.suning.cn/uimg/sop/commodity/158173321115840668503743_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p><p>  </p>\n<p><img data-src=\"//image.suning.cn/uimg/sop/commodity/100110829125258600547950_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/100110829125258600547950_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/847296614202990993026780_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/847296614202990993026780_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/150337536714263945297959_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/150337536714263945297959_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/728057281111935363897640_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/728057281111935363897640_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> <img data-src=\"//image.suning.cn/uimg/sop/commodity/164701850918021676012635_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/164701850918021676012635_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/425872862105173660569250_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/425872862105173660569250_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/130870028720717534417333_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/130870028720717534417333_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/180800861514068288654470_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/180800861514068288654470_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/119497783119298172688785_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/119497783119298172688785_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/191811452319726224635657_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/191811452319726224635657_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/492118060120366439112270_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/492118060120366439112270_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/936441696178601660172200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/936441696178601660172200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/256729937146906086548830_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/256729937146906086548830_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/755363586928456648381100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" usemap=\"#Map\" border=\"0\" src=\"https://image.suning.cn/uimg/sop/commodity/755363586928456648381100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"> </p></div>', '', '', '0', '1514256088', '1514256088', null, '70', '115', '125', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('60', '2017冬季新款童装儿童棉服 中小童可爱小清新棉衣保暖可爱印花棉服【A36】', '99.00', '100', '100', '1260', '<div class=\"lazyimg\"><table id=\"__01\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%; height: auto;\">\n<tbody>\n<tr>\n<td><img data-src=\"https://image.suning.cn/uimg/sop/commodity/707258368938755293827100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" usemap=\"#a222\" border=\"0\" src=\"https://image.suning.cn/uimg/sop/commodity/707258368938755293827100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></td>\n</tr>\n<tr>\n<td><img data-src=\"https://image.suning.cn/uimg/sop/commodity/201610170670356547855100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" usemap=\"#a333\" border=\"0\" src=\"https://image.suning.cn/uimg/sop/commodity/201610170670356547855100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></td>\n</tr>\n</tbody>\n</table>\n<!-- End Save for Web Slices -->\n<p> </p><div moduleid=\"R9003088_3\" modulename=\"商品详情\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/148332867814577558569574_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/148332867814577558569574_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/172061136910832312466609_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/172061136910832312466609_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/134761316486876342740200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/134761316486876342740200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/184959467513557349033133_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/184959467513557349033133_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/806962697835765068286400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/806962697835765068286400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/204035444020292942718027_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/204035444020292942718027_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/169927769611320958139403_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/169927769611320958139403_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/597019268123400541741480_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/597019268123400541741480_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/134022086859285049361510_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/134022086859285049361510_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/212248578517874372114862_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/212248578517874372114862_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/212055272112531339351163_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/212055272112531339351163_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/149842409140360409011080_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/149842409140360409011080_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/601785316620775984006000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/601785316620775984006000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/155737594889237585147870_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/155737594889237585147870_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/612631918359400501033000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/612631918359400501033000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003088_4\" modulename=\"商品参数\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/782972053173984332686530_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/782972053173984332686530_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003088_5\" modulename=\"商品实拍\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/782972053173984332686530_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/782972053173984332686530_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256091', '1514256091', null, '1480', '1482', '1260', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('61', '2017冬季加厚中大男童纯棉加绒卫衣绒衫冬装长袖T恤儿童连帽上衣外套', '69.00', '100', '100', '1261', '<div class=\"lazyimg\"><div moduleid=\"R9003092_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/393866842165076987646440_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"1 (1)\" src=\"//image.suning.cn/uimg/sop/commodity/393866842165076987646440_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/104356385116037581898049_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"1\" src=\"//image.suning.cn/uimg/sop/commodity/104356385116037581898049_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/213952157510057910183281_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"2\" src=\"//image.suning.cn/uimg/sop/commodity/213952157510057910183281_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/150638209479960955095690_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"3\" src=\"//image.suning.cn/uimg/sop/commodity/150638209479960955095690_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/332233958212421548455590_x.png?from=mobile&amp;format=80q.webp\" alt=\"4\" src=\"//image.suning.cn/uimg/sop/commodity/332233958212421548455590_x.png?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/283555510565486300808200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"5\" src=\"//image.suning.cn/uimg/sop/commodity/283555510565486300808200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/764267391160894507459390_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"6\" src=\"//image.suning.cn/uimg/sop/commodity/764267391160894507459390_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/119373660716131504009788_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"7\" src=\"//image.suning.cn/uimg/sop/commodity/119373660716131504009788_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/178510874310755274168320_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"8\" src=\"//image.suning.cn/uimg/sop/commodity/178510874310755274168320_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/107491847615212760485700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"9\" src=\"//image.suning.cn/uimg/sop/commodity/107491847615212760485700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/137345358676298011959790_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"10\" src=\"//image.suning.cn/uimg/sop/commodity/137345358676298011959790_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/920791933928611518141300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"11\" src=\"//image.suning.cn/uimg/sop/commodity/920791933928611518141300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/209662677211817695462002_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"12\" src=\"//image.suning.cn/uimg/sop/commodity/209662677211817695462002_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/108089261349264185412680_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"13\" src=\"//image.suning.cn/uimg/sop/commodity/108089261349264185412680_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/112960061387269147446360_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"14\" src=\"//image.suning.cn/uimg/sop/commodity/112960061387269147446360_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/585939039922637605292000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"15\" src=\"//image.suning.cn/uimg/sop/commodity/585939039922637605292000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/205619241550061535532870_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"16\" src=\"//image.suning.cn/uimg/sop/commodity/205619241550061535532870_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/510423004961815618999000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"17\" src=\"//image.suning.cn/uimg/sop/commodity/510423004961815618999000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/149575417664514430127360_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"18\" src=\"//image.suning.cn/uimg/sop/commodity/149575417664514430127360_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/483698789167490498745300_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"19\" src=\"//image.suning.cn/uimg/sop/commodity/483698789167490498745300_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/312630075211045522570650_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"20\" src=\"//image.suning.cn/uimg/sop/commodity/312630075211045522570650_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003092_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/393866842165076987646440_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"1 (1)\" src=\"//image.suning.cn/uimg/sop/commodity/393866842165076987646440_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003092_5\" modulename=\"商品实拍\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/104356385116037581898049_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"1\" src=\"//image.suning.cn/uimg/sop/commodity/104356385116037581898049_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256094', '1514256094', null, '1218', '1250', '1261', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('62', '优衣乐百搭儿童中大童加厚圆领毛衣高领毛线衫男童女童针织衫童装打底衫', '39.00', '100', '100', '1262', '<div class=\"lazyimg\"><div moduleid=\"R9003089_4\" modulename=\"商品参数\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/115602839920857812902555_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/115602839920857812902555_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003089_5\" modulename=\"商品实拍\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/652693206169160424127200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/652693206169160424127200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003089_3\" modulename=\"商品详情\"><p><img data-src=\"https://image.suning.cn/uimg/sop/commodity/102330853573312830289320_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/102330853573312830289320_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/184943108110424551023650_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/184943108110424551023650_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/111666893019381896885136_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/111666893019381896885136_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/113932861615283433004976_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/113932861615283433004976_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/149726249774977797497770_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/149726249774977797497770_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/124444260190861257675850_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/124444260190861257675850_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/162520895428180895968000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/162520895428180895968000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/198245475889868529278070_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/198245475889868529278070_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/422547335762178164331700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/422547335762178164331700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/297401516669130403545400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/297401516669130403545400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/291054052180505746855500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/291054052180505746855500_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/166944249914023031621651_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/166944249914023031621651_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/822403640196517425449850_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/822403640196517425449850_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/127156368944975773875000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/127156368944975773875000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/155198724151001600136990_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/155198724151001600136990_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/319657279167902356041450_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/319657279167902356041450_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"https://image.suning.cn/uimg/sop/commodity/121282376742960122142700_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/121282376742960122142700_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div></div>', '', '', '0', '1514256098', '1514256098', null, '1218', '1250', '1262', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('63', '宝宝冬装婴儿0秋冬款加厚连体衣3冬季哈衣新生儿6衣服男童装9女宝', '75.00', '100', '100', '1263', '<div class=\"lazyimg\"><p></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/196149690311837662446431_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"170kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/196149690311837662446431_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/151545728564387996968100_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"184kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/151545728564387996968100_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/135998996711266449679951_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"152kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/135998996711266449679951_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/161088111319507277435780_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"144kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/161088111319507277435780_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/107709006414754029883090_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"141kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/107709006414754029883090_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/942323999289631712138200_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"133kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/942323999289631712138200_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p><p><img data-src=\"//image.suning.cn/uimg/sop/phonecomm/101364845325642569061440_640x.jpg?from=mobile&amp;format=80q.webp\" picsize=\"179kb\" src=\"//image.suning.cn/uimg/sop/phonecomm/101364845325642569061440_640x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div>', '', '', '0', '1514256101', '1514256101', null, '1218', '1250', '1263', '0', '0', '0');
INSERT INTO `sp_goods` VALUES ('64', '2017春秋季新款男女中小儿童长袖纯棉T恤 宝宝韩版纯棉上衣打底衫 长袖T恤', '36.00', '100', '100', '1264', '<div class=\"lazyimg\"><div moduleid=\"R9003091_3\" modulename=\"商品详情\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/240357447206835056687960_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/240357447206835056687960_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/122667439914200901473560_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/122667439914200901473560_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/217082905831477885196100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/217082905831477885196100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/189297394524153794814340_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/189297394524153794814340_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/115480230511018272066717_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/115480230511018272066717_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/222281291355263738903400_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/222281291355263738903400_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/201642509316394828239151_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/201642509316394828239151_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/151019929180860261778870_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/151019929180860261778870_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/126614202515196970471930_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/126614202515196970471930_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/866916209769538077430000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/866916209769538077430000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/470787300213507918254640_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/470787300213507918254640_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/493683340119155108242000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/493683340119155108242000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/585026815171008417874490_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/585026815171008417874490_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/165225459483245932532630_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/165225459483245932532630_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/213060792212411463796598_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/213060792212411463796598_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/732936398303750919254200_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/732936398303750919254200_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/426415432332085359986000_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/426415432332085359986000_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/198569816927710469034420_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/198569816927710469034420_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/177826714415523145106599_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/177826714415523145106599_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/133486844221388943887773_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/133486844221388943887773_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003091_4\" modulename=\"商品参数\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/122667439914200901473560_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/122667439914200901473560_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/217082905831477885196100_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/217082905831477885196100_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"></p></div><div moduleid=\"R9003091_5\" modulename=\"商品实拍\"><p><img data-src=\"//image.suning.cn/uimg/sop/commodity/144939362510701533598596_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/144939362510701533598596_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/126918112676768594010390_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/126918112676768594010390_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/680185210207640455540430_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/680185210207640455540430_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/204323769415724440422720_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/204323769415724440422720_x.jpg?from=mobile&format=80q.webp\" width=\"100%\" height=\"auto\"><img data-src=\"//image.suning.cn/uimg/sop/commodity/761475541232913614985500_x.jpg?from=mobile&amp;format=80q.webp\" alt=\"\" src=\"//image.suning.cn/uimg/sop/commodity/761475541232913614985500_x.jpg?from=mobile&format=8