#!/bin/bash

# Get full user name of current user
# E.g. "Robbie Hanson"
full1=$(osascript -e "tell application \"System Events\"" -e "get the full name of the current user" -e "end tell")
#echo $full1

# Convert to lower case
# E.g. "robbie hanson"
full2=$(echo $full1 | awk '{print tolower($0)}')
#echo $full2

# Replace spaces with underscores
# E.g. "robbie_hanson"
full3=$(echo ${full2// /_})
#echo $full3

# Remove any characters that are illegal in a macro name
full4=$(echo $full3 | sed 's/[^0-9a-zA-Z_]*//g')
#echo $full4

# If blank, set the name to an anonymous user
if [ "$full4" == "" ]
then
	full4='anonymous_user'
fi

echo "// This file is automatically generated" > ${SCRIPT_OUTPUT_FILE_0}
echo "#define $full4 1" >> ${SCRIPT_OUTPUT_FILE_0}
