# Contributing to CocoaLumberjack

We want to make contributing to this project as easy and transparent as possible. Here are a few guidelines for making all our lives easier.

## Asking questions

We don't use GitHub as a support forum. For any usage questions that are not specific to the project itself, please ask on [Stack Overflow](https://stackoverflow.com/) instead. By doing so, you'll be more likely to quickly solve your problem, and you'll allow anyone else with the same question to find the answer. This also allows maintainers to focus on improving the project for others.

## Reporting Issues

A great way to contribute to the project is to send a detailed issue when you encounter an problem.
It is very important to check for the same problem or suggestion in the project's issue list first. If you find a match, just add a small comment there. If the issue is closed and you think it is still occuring in the latest version, please re-open the issue.
Doing this helps prioritize the most common problems and requests.

When reporting issues, please include the following:

- The platform name and version (e.g. iOS 13.4)
- The library version
- The integration method (e.g. Swift Package Manager / CocoaPods / Carthage / manually)
- The version of Xcode you're using
- The full output of any stack trace or compiler error
- A small reproduction project that replicates the issue (especially if the way to reproduce the issue is not straight-forward)
- Any other details that would be useful in understanding the problem

This information will help us review and fix your issue faster.

Please do not be offended if we close your issue and reference this document. 
If you believe the issue is truely a fault in the project’s codebase, re-open it.

## Pull Requests

We gladly accept any PR's assuming they are well written, documented (if necessary) and preferably have test code. 
If you're unsure if we'll accept a new feature please open an issue requesting it and we can have a discussion before you code and submit a PR.

Checklist:
- Fork the repo and create your branch from the latest master (to minimize the conflicts)
- If you've added code that should be tested, add tests.
- If you've changed APIs, update the documentation.
- Ensure the test suite passes.
- Make sure your code lints (`pod lib lint`)
